/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.core.service;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import org.eclipse.core.runtime.Assert;

public class JiraTimeFormat
extends Format {
    private static final long serialVersionUID = 1L;
    private final int workDaysPerWeek;
    private final int workHoursPerDay;

    public JiraTimeFormat() {
        this(7, 24);
    }

    public JiraTimeFormat(int workDaysPerWeek, int workHoursPerDay) {
        Assert.isTrue((1 <= workDaysPerWeek && workDaysPerWeek <= 7 ? 1 : 0) != 0);
        Assert.isTrue((1 <= workHoursPerDay && workHoursPerDay <= 24 ? 1 : 0) != 0);
        this.workDaysPerWeek = workDaysPerWeek;
        this.workHoursPerDay = workHoursPerDay;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer sb, FieldPosition pos) {
        if (obj instanceof Long) {
            this.format(sb, (Long)obj);
        } else if (obj instanceof Integer) {
            this.format(sb, ((Integer)obj).intValue());
        }
        return sb;
    }

    private void format(StringBuffer sb, long seconds) {
        long minutes;
        long hours;
        long days;
        long weeks = seconds / (long)(this.workDaysPerWeek * this.workHoursPerDay * 60 * 60);
        if (weeks > 0L) {
            sb.append(Long.toString(weeks)).append('w');
        }
        if ((days = seconds % (long)(this.workDaysPerWeek * this.workHoursPerDay * 60 * 60) / (long)(this.workHoursPerDay * 60 * 60)) > 0L) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(Long.toString(days)).append('d');
        }
        if ((hours = seconds % (long)(this.workHoursPerDay * 60 * 60) / 3600L) > 0L) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(Long.toString(hours)).append('h');
        }
        if ((minutes = seconds % 3600L / 60L) > 0L) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(Long.toString(minutes)).append('m');
        } else if (sb.length() == 0) {
            sb.append("0m");
        }
    }

    public long parse(String source) throws ParseException {
        Assert.isNotNull((Object)source);
        Object parsedObject = this.parseObject(source, new ParsePosition(0));
        if (parsedObject == null) {
            throw new ParseException("Invalid string", 0);
        }
        return (Long)parsedObject;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        if (source.trim().equals("0")) {
            pos.setIndex(source.length() + 1);
            return new Long(0L);
        }
        StringBuffer buffer = new StringBuffer(source.length());
        char[] charArray = source.toCharArray();
        long value = 0L;
        boolean processed = false;
        int i = 0;
        while (i < charArray.length) {
            char c = charArray[i];
            if (Character.isDigit(c)) {
                buffer.append(c);
            } else if (buffer.length() != 0) {
                int count = Integer.parseInt(buffer.toString());
                if (c == 'w') {
                    value += (long)(count * 60 * 60 * this.workHoursPerDay * this.workDaysPerWeek);
                } else if (c == 'd') {
                    value += (long)(count * 60 * 60 * this.workHoursPerDay);
                } else if (c == 'h') {
                    value += (long)(count * 60 * 60);
                } else if (c == 'm') {
                    value += (long)(count * 60);
                } else {
                    pos.setErrorIndex(i);
                    return null;
                }
                processed = true;
                buffer.setLength(0);
            } else if (!Character.isWhitespace(c)) {
                pos.setErrorIndex(i);
                return null;
            }
            ++i;
        }
        if (!processed || buffer.length() != 0) {
            pos.setErrorIndex(0);
            return null;
        }
        pos.setIndex(source.length() + 1);
        return value;
    }
}

