/* ***********************************************************/
/* Copyright (c) 1984-2005 by Progress Software Corporation  */
/*                                                           */
/* All rights reserved.  No part of this program or document */
/* may be  reproduced in  any form  or by  any means without */
/* permission in writing from Progress Software Corporation. */
/*************************************************************/

    DEFINE INPUT  PARAMETER cPrm AS CHARACTER  NO-UNDO.
    DEFINE NEW GLOBAL SHARED VARIABLE OEIDE_Context    AS HANDLE NO-UNDO.
    
    function getProjectWorkDirectory returns character 	(  ) in OEIDE_Context.
    DEFINE VARIABLE dbConnections      AS CHARACTER  NO-UNDO.
    DEFINE VARIABLE creturn            AS CHARACTER  NO-UNDO.
    
    DEFINE VARIABLE i 				   AS INTEGER    NO-UNDO.
    DEFINE VARIABLE initialConnections AS INTEGER    NO-UNDO.
    DEFINE VARIABLE ErrorLogFile       AS CHARACTER  NO-UNDO.


    ErrorLogFile = getProjectWorkDirectory() + "/error.log".
    
    initialConnections = NUM-DBS.
    REPEAT i = 1 TO initialConnections:
        dbConnections = dbConnections + "," + LDBNAME(i).
    END. 
    
    dbConnections = TRIM (dbConnections).
    
    /* some connection errors are untrappable by no-error
       and therefore must be suppressed by redirecting their
       output to a file
    */
    CBLOCK:
    DO ON ERROR UNDO, LEAVE CBLOCK
       ON STOP  UNDO, LEAVE CBLOCK:
        OUTPUT TO VALUE(ErrorLogFile) UNBUFFERED.
	    CONNECT VALUE (cprm) NO-ERROR.
	    OUTPUT CLOSE.
	END.

	/* if there was an error return the error message */
    IF ERROR-STATUS:ERROR or ERROR-STATUS:NUM-MESSAGES > 0 THEN DO:
    	cReturn = ERROR-STATUS:GET-MESSAGE(1).
    	
        REPEAT i = 1 TO NUM-DBS:
            IF LOOKUP( LDBNAME(i) , dbConnections) = 0 THEN DO:
                DISCONNECT VALUE(LDBNAME(i)) NO-ERROR.
            END.
        END.
    END. 
    ELSE DO:
    	/* if there was no error, but the number of connected databases
    	   is the same, then something odd happened so report a 
    	   generic error message
    	*/
    	IF NUM-DBS = initialConnections THEN DO:
    		cReturn = "Connection to database failed.".
    	END.
    	ELSE DO:
	        REPEAT i = 1 TO NUM-DBS:
	        	IF LOOKUP( LDBNAME(i) , dbConnections) = 0 THEN DO:
	    			DISCONNECT VALUE(LDBNAME(i)) NO-ERROR.
	        	END.
	        END.
	        cReturn = "OK".
	    END.
	END.
    	
    
    RETURN cReturn.
	