&ANALYZE-SUSPEND _VERSION-NUMBER UIB_v9r12
&ANALYZE-RESUME
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CUSTOM _DEFINITIONS Procedure 
/*********************************************************************
* Copyright (C) 2000-2016 by Progress Software Corporation ("PSC"),  *
* 14 Oak Park, Bedford, MA 01730, and other contributors as listed   *
* below.  All Rights Reserved.                                       *
*                                                                    *
* The Initial Developer of the Original Code is PSC.  The Original   *
* Code is Progress IDE code released to open source December 1, 2000.*
*                                                                    *
* The contents of this file are subject to the Possenet Public       *
* License Version 1.0 (the "License"); you may not use this file     *
* except in compliance with the License.  A copy of the License is   *
* available as of the date of this notice at                         *
* http://www.possenet.org/license.html                               *
*                                                                    *
* Software distributed under the License is distributed on an "AS IS"*
* basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. You*
* should refer to the License for the specific language governing    *
* rights and limitations under the License.                          *
*                                                                    *
* Contributors:                                                      *
*                                                                    *
*********************************************************************/
/*------------------------------------------------------------------------

  File: web-util.p

  Description: 

  Input Parameters:
      <none>

  Output Parameters:
      <none>

------------------------------------------------------------------------*/
&GLOBAL-DEFINE WEB-UTIL_P TRUE           /* lets proto.i know where to find functions */

{ src/web/method/cgidefs.i  }            /* Basic CGI variables */
{ src/web/method/cgiarray.i }            /* Extended CGI array variables */
{ src/web/method/tagmap.i   }            /* Tagmap Temp-Table definition */

DEFINE SHARED VARIABLE server-connection AS CHARACTER NO-UNDO.
DEFINE SHARED VARIABLE wcCharset     AS CHARACTER NO-UNDO.

DEFINE NEW GLOBAL SHARED VARIABLE OEIDE_Context    AS HANDLE NO-UNDO.
  
function getProjectWorkDirectory returns character 	(  ) in OEIDE_Context.

/* New temp-tables for CGI and FORM values */
DEFINE TEMP-TABLE ttCGI
  FIELD tName  AS CHARACTER
  FIELD tValue AS CHARACTER
  INDEX tName IS PRIMARY UNIQUE tName.

DEFINE TEMP-TABLE ttForm
  FIELD tName  AS CHARACTER
  FIELD tValue AS CHARACTER
  INDEX tName IS PRIMARY UNIQUE tName.

DEFINE VARIABLE wcFormGet  AS CHARACTER  NO-UNDO.
DEFINE VARIABLE wcFormPost AS CHARACTER  NO-UNDO.
DEFINE VARIABLE wcCookie   AS CHARACTER  NO-UNDO.
DEFINE VARIABLE wcCGI      AS CHARACTER  NO-UNDO.


&GLOBAL-DEFINE CONNECTION-NAME "SERVER_CONNECTION_ID":U
&SCOPED-DEFINE WEB-CURRENT-ENVIRONMENT wcCGI
&SCOPED-DEFINE WEB-EXCLUSIVE-ID WEB-CONTEXT:EXCLUSIVE-ID
&GLOBAL-DEFINE WSEU-NAME "WSEU":U
&SCOPED-DEFINE tagMapFileName "tagmap.dat":U

DEFINE STREAM  tagMapStream.

/* Variables for configuration options.  Initialized upon Agent startup. */
DEFINE VARIABLE cfg-appurl           AS CHARACTER  NO-UNDO.
DEFINE VARIABLE cfg-environment      AS CHARACTER  NO-UNDO.
DEFINE VARIABLE cfg-eval-mode        AS LOGICAL    NO-UNDO.
DEFINE VARIABLE cfg-cookiedomain     AS CHARACTER  NO-UNDO.
DEFINE VARIABLE cfg-cookiepath       AS CHARACTER  NO-UNDO.
DEFINE VARIABLE cfg-debugging        AS CHARACTER  NO-UNDO.

/* Configuration options for enhanced functionality. */
DEFINE VARIABLE cfg-checktime        AS LOGICAL    NO-UNDO.
DEFINE VARIABLE cfg-compile-on-fly   AS LOGICAL    NO-UNDO.
DEFINE VARIABLE cfg-compile-options  AS CHARACTER  NO-UNDO.
DEFINE VARIABLE cfg-compile-xcode    AS CHARACTER  NO-UNDO.
DEFINE VARIABLE cfg-development-mode AS LOGICAL    NO-UNDO.
DEFINE VARIABLE cfg-no-save-rcode    AS LOGICAL    NO-UNDO INITIAL TRUE.
DEFINE VARIABLE cfg-web-run-path     AS CHARACTER  NO-UNDO.

{ src/web/method/proto.i}
{ src/web/method/admweb.i}

/* Override cgiutils.i version of output-content-type */
&SCOPED-DEFINE EXCLUDE-output-content-type TRUE

/* { src/web/method/cgiutils.i} */

/* ***************************************** */
/* This section was originally in cgiutils.i */
/* ***************************************** */

/* Variables used only by cgiutils.i */
/* TEMPORARY VARIABLE TO SET CGI MODE. [billb]
   TRUE = API calls core WEB-CONTEXT: methods
   FALSE = API calls use existing 4GL implementation
   This is set in the procedure init-session in web-util.p. */
DEFINE NEW GLOBAL SHARED VARIABLE use-core-api AS LOGICAL NO-UNDO INITIAL TRUE.

/* Exclusive Web User variables. */
DEFINE VARIABLE wseu-cookie AS CHARACTER NO-UNDO.

/* E-mail address of application maintainer */
DEFINE VARIABLE HelpAddress  AS CHARACTER NO-UNDO FORMAT "x(40)":U.

/* Unsafe characters that must be encoded in URL's.  See RFC 1738 Sect 2.2. */
DEFINE VARIABLE url_unsafe   AS CHARACTER NO-UNDO 
    INITIAL " <>~"#%~{}|~\^~~[]`":U.

/* Reserved characters that normally are not encoded in URL's */
DEFINE VARIABLE url_reserved AS CHARACTER NO-UNDO 
    INITIAL "~;/?:@=&":U.
&ANALYZE-RESUME


/* runlog */

DEFINE VARIABLE cRunLog   AS CHARACTER  NO-UNDO.
DEFINE VARIABLE cLogTypes AS CHARACTER  NO-UNDO.
DEFINE VARIABLE cLogPath  AS CHARACTER  NO-UNDO.
DEFINE VARIABLE lNoCache  AS LOGICAL    NO-UNDO.
DEFINE VARIABLE iEtime    AS INTEGER    NO-UNDO.

DEFINE STREAM logger.   





/* *********************** Procedure Settings ************************ */

&ANALYZE-SUSPEND _PROCEDURE-SETTINGS
/* Settings for THIS-PROCEDURE
   Other Settings: INCLUDE-ONLY
 */
&ANALYZE-RESUME _END-PROCEDURE-SETTINGS

&ANALYZE-SUSPEND _INCLUDED-LIBRARIES
/* ************************* Included-Libraries *********************** */
&ANALYZE-RESUME _END-INCLUDED-LIBRARIES

/* ***************************  Functions  **************************** */

&IF DEFINED(EXCLUDE-convert-datetime) = 0 &THEN

&ANALYZE-SUSPEND _CODE-BLOCK _FUNCTION convert-datetime 
FUNCTION convert-datetime RETURNS CHARACTER
  (INPUT p_conversion AS CHARACTER,
   INPUT p_idate       AS DATE,
   INPUT p_itime       AS INTEGER,
   OUTPUT p_odate      AS DATE,
   OUTPUT p_otime      AS INTEGER) :
/****************************************************************************
Description: Performs conversions of date and time between local time and
  UTC time.  In addition, an option is supported to normalize a date and
  time ensuring the value of time is legal between zero and the number of
  seconds per day.  The normalizing step is also performed for either the
  local to UTC or UTC to local conversions.
Parameters:
  Input:  Conversion option:
          "UTC" - Converts date and time from local to UTC time.
          "LOCAL" - Converts date and time from UTC to local time.
          "NORMALIZE" - Normalize date and time so the value of time is
            legal between zero and the number of seconds per day.
  Input:  Date to convert.  Uses the DATE data type.
  Input:  Time to convert.  Seconds since midnight (see TIME function).
  Output: Converted date.
  Output: Converted time.
Returns: 
Global Variables: utc-offset
****************************************************************************/
  DEFINE VARIABLE seconds-per-day AS INTEGER NO-UNDO INITIAL 86400.

  /* Default option is to normalize */
  IF p_conversion = "" OR p_conversion = ? THEN
    ASSIGN p_conversion = "NORMALIZE":U.

  /* If date is ? ... */
  IF p_idate = ? THEN
    RETURN "".

  IF p_itime = ? THEN
    ASSIGN p_itime = 0.

  /* Set time adjustment depending on conversion option */
  CASE p_conversion:
    WHEN "LOCAL":U THEN
      ASSIGN p_itime = p_itime - utc-offset.
    WHEN "UTC":U THEN
      ASSIGN p_itime = p_itime + utc-offset.
  END CASE.

  /* Normalize if time is too large */
  DO WHILE p_itime >= seconds-per-day:
    ASSIGN
      p_itime = p_itime - seconds-per-day
      p_idate = p_idate + 1.  /* tomorrow */
  END.

  /* Normalize if time is too small */
  DO WHILE p_itime < 0:
    ASSIGN
      p_itime = p_itime + seconds-per-day
      p_idate = p_idate - 1.  /* yesterday */
  END.

  ASSIGN
    p_odate = p_idate
    p_otime = p_itime.

  RETURN "".

END FUNCTION. /* convert-datetime */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-format-datetime) = 0 &THEN

&ANALYZE-SUSPEND _CODE-BLOCK _FUNCTION format-datetime 
FUNCTION format-datetime RETURNS CHARACTER
  (INPUT p_format  AS CHARACTER,
   INPUT p_date    AS DATE,
   INPUT p_time    AS INTEGER,
   INPUT p_options AS CHARACTER) :

/****************************************************************************
Description: Returns a date and time string formatted for Internet use.
  Currently, the formats "COOKIE" and "HTTP" are supported.  The HTTP format
  is useful for the Expires: or other headers.  The Cookie format is used
  by the set-cookie() function when an expiration date is specified.
Parameters:
  Input:  Date format.  Supported are "COOKIE" and "HTTP".
  Input:  Date as a DATE data type.
  Input:  Time as an integer (See TIME function).
  Input:  Options.  "LOCAL" - indicates the specified date and time are local
          time such as returned by the TODAY and TIME functions.  The date
          and time are converted to UTC before formatting.
          "UTC" - The specified date and time are already in UTC time.  The
          date and time are normalized to ensure the value of time is between
          zero and the number of seconds in one day.
Returns:  Formatted date
Global variables:
References:
  Cookie Date format:
    Netscape Cookie Spec: http://home.netscape.com/newsref/std/cookie_spec.html
  HTTP Date format:
    RFC 2068, 3.3 Date/Time Formats: http://ds.internic.net/rfc/rfc2068.txt
****************************************************************************/
  DEFINE VARIABLE p_rfcdate AS CHARACTER NO-UNDO.

  /* Does RFC 850/822 allow translated days and months?  Think not. */
  DEFINE VARIABLE weekday-list AS CHARACTER NO-UNDO INITIAL
    "Sun,Mon,Tue,Wed,Thu,Fri,Sat":U.
  DEFINE VARIABLE month-list AS CHARACTER NO-UNDO INITIAL
    "Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec":U.

  /* If date is ?, return a blank date */
  IF p_date = ? THEN
    RETURN "".

  IF p_time = ? THEN
    ASSIGN p_time = 0.

  /* If no options are specified, LOCAL is the default */
  IF p_options = "" OR p_options = ? THEN
    ASSIGN p_options = "LOCAL":U.

  /* If Local was specified and the format is Cookie or HTTP, convert date and 
     time to UTC. */
  IF CAN-DO(p_options, "LOCAL":U) AND
    (p_format = "COOKIE":U OR p_format = "HTTP":U) THEN
    /* Convert date and time from Local to UTC */
    convert-datetime("UTC":U, p_date, p_time, OUTPUT p_date, OUTPUT p_time).
  /* Otherwise, just normalize */
  ELSE
    /* Normalize date and time */
    convert-datetime("NORMALIZE":U, p_date, p_time, OUTPUT p_date, OUTPUT p_time).

  /* Output the formatted date */
  CASE p_format:
    WHEN "COOKIE":U THEN DO:
      /* Cookie format based on RFC-1123: Wdy, DD-Mon-YYYY HH:MM:SS GMT */
      ASSIGN 
        p_rfcdate = ENTRY(WEEKDAY(p_date), weekday-list) + ", ":U +
                    STRING(DAY(p_date),"99":U) + "-":U +
                    ENTRY(MONTH(p_date), month-list) + "-":U +
                    STRING(YEAR(p_date), "9999":U) + " ":U +
                    STRING(p_time,"HH:MM:SS":U) + " GMT":U.
    END.
    WHEN "HTTP":U THEN DO:
      /* HTTP format based on RFC-1123: Wdy, DD Mon YYYY HH:MM:SS GMT */
      ASSIGN 
        p_rfcdate = ENTRY(WEEKDAY(p_date), weekday-list) + ", ":U +
                    STRING(DAY(p_date),"99":U) + " ":U +
                    ENTRY(MONTH(p_date), month-list) + " ":U +
                    STRING(YEAR(p_date), "9999":U) + " ":U +
                    STRING(p_time,"HH:MM:SS":U) + " GMT":U.
    END.
    OTHERWISE
      queue-message("WebSpeed":U, "format-datetime: format '" + p_format +
                    "' is not supported").
  END CASE.

  RETURN p_rfcdate.

END FUNCTION. /* format-datetime */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-get-cgi) = 0 &THEN

&ANALYZE-SUSPEND _CODE-BLOCK _FUNCTION get-cgi 
FUNCTION get-cgi RETURNS CHARACTER
  (INPUT p_name AS CHARACTER) :
/****************************************************************************
Description: Retrieves the value for the specified CGI variable
Input Parameter: Name of variable or ?
Returns: Value or blank if invalid name.  If ? was specified for
  the name, the list of variables is returned.
****************************************************************************/
  IF p_name = ? THEN DO:
    RETURN wcCGI.
  END.  
  ELSE DO:
    FIND FIRST ttCGI WHERE ttCGI.tName = p_name NO-ERROR.
    IF AVAILABLE ttCGI THEN RETURN ttCGI.tValue.     
  END.
END FUNCTION. /* get-cgi */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-get-field) = 0 &THEN

&ANALYZE-SUSPEND _CODE-BLOCK _FUNCTION get-field 
FUNCTION get-field RETURNS CHARACTER
  (INPUT p_name AS CHARACTER) :
/****************************************************************************
Description: Retrieves the associated value for the specified form field.
Input Parameter: Name of field or ?
Returns: Value of field or blank if invalid field name.  If ? was
  specified for the name, the list of fields is returned.
Global Variables: FieldList
****************************************************************************/
  DEFINE VARIABLE v-value AS CHARACTER NO-UNDO.
  DEFINE VARIABLE i AS INTEGER NO-UNDO.

  DEFINE VARIABLE v-form  AS CHARACTER NO-UNDO.
  DEFINE VARIABLE v-query AS CHARACTER NO-UNDO.
  DEFINE VARIABLE v-name  AS CHARACTER NO-UNDO.

  /* Get list of fields? */
  IF p_name = ? THEN DO:
    /* If the field list was already computed for this request, return it */
    IF FieldList <> "" THEN
      RETURN FieldList.
    ASSIGN v-form = wcFormPost
           v-query = wcFormGet
           /* Combine form input and query string */
           v-value = v-form +
             (IF v-form <> "" AND v-query <> "" THEN ",":U ELSE "") +
             v-query.
    /* If returning a field list, eliminate dupes */
    DO i = 1 TO NUM-ENTRIES(v-value):
      ASSIGN v-name = ENTRY(i, v-value).
      IF LOOKUP(v-name, FieldList) = 0 THEN
        ASSIGN FieldList = FieldList +
               (IF FieldList = "" THEN "" ELSE ",":U) + v-name.
    END.
    RETURN FieldList.
  END.

  /* Else, get a field value */
  ELSE DO:
    /* Return the output directly to maximize the allowable length.
       Replace all CF/LF's with with an LF so when an HTML <TEXTAREA>
       is saved in a database, etc. it won't contain extra characters
       or double-space output. */
    IF CAN-DO(wcFormPost, p_name) OR CAN-DO(wcFormGet, p_name) THEN DO:
      FIND FIRST ttForm WHERE ttForm.tName = p_name NO-ERROR.
      IF AVAILABLE ttForm THEN v-value = ttForm.tValue.
    END.
  END.
  RETURN v-value.
END FUNCTION. /* get-field */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-get-user-field) = 0 &THEN

&ANALYZE-SUSPEND _CODE-BLOCK _FUNCTION get-user-field 
FUNCTION get-user-field RETURNS CHARACTER
  (INPUT p_name AS CHARACTER) :
/****************************************************************************
Description: Retrieves the associated value for the specified user field
  that was set with set-user-field().
Input Parameter: Name of user field or ?
Returns: Value of user field or blank if invalid name.  If ? was
  specified for the name, the list of user fields is returned.
Global Variables: UserFieldList, UserFieldVar
****************************************************************************/
  DEFINE VARIABLE i AS INTEGER NO-UNDO.

  IF p_name = ? THEN
    RETURN UserFieldList.
  ELSE DO:
    ASSIGN i = LOOKUP(p_name, UserFieldList).
    RETURN (IF i > 0 THEN UserFieldVar[i] ELSE "").
  END.
END FUNCTION. /* get-user-field */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-get-value) = 0 &THEN

&ANALYZE-SUSPEND _CODE-BLOCK _FUNCTION get-value 
FUNCTION get-value RETURNS CHARACTER
  (INPUT p_name AS CHARACTER) :
/****************************************************************************
Description: Retrieves the first available value for a user field, field
  or cookie.
Input Parameter: Name of item or ?
Returns: Value of user field, form field or Cookie in that order or blank if 
  an invalid name.  If ? was specified for the name, a comma separated list
of all user fields, fields and cookies is returned.
Global Variables: UserFieldList, UserFieldVar, FieldList, FieldVar
****************************************************************************/
  DEFINE VARIABLE v-value AS CHARACTER NO-UNDO.
  DEFINE VARIABLE v-field-list AS CHARACTER NO-UNDO.
  DEFINE VARIABLE v-cookie-list AS CHARACTER NO-UNDO.
  DEFINE VARIABLE i AS INTEGER NO-UNDO.

  /* If name is ?, pass a list of all names in user fields, fields and
     cookies. */
  IF p_name = ? THEN DO:
    ASSIGN
      v-field-list = get-field(?)
      v-value = UserFieldList +
        (IF UserFieldList <> "" AND v-field-list <> "" THEN ",":U ELSE "") +
        v-field-list
      v-cookie-list = get-cookie(?)
      v-value = v-value +
        (IF v-value <> "" AND v-cookie-list <> "" THEN ",":U ELSE "") +
        v-cookie-list.
    RETURN v-value.
  END.

  /* Else, item name passed so look for it in user fields, fields and
     cookies in that order. */
  ELSE DO:
    ASSIGN i = LOOKUP(p_name, UserFieldList).
    IF i > 0 THEN
      RETURN UserFieldVar[i].
    IF CAN-DO(get-field(?), p_name) THEN
      RETURN get-field(p_name).
    RETURN get-cookie(p_name).
  END.

END FUNCTION. /* get-value */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-hidden-field) = 0 &THEN

&ANALYZE-SUSPEND _CODE-BLOCK _FUNCTION hidden-field 
FUNCTION hidden-field RETURNS CHARACTER
  (INPUT p_name AS CHARACTER,
   INPUT p_value AS CHARACTER) :
/****************************************************************************
Description: Returns an HTML hidden field with the name and value encoded
  with HTML entities.  See html-encode().
Input Parameters: name and value
Returns: HTML hidden field
****************************************************************************/
  RETURN '<INPUT TYPE="HIDDEN" NAME="':U + html-encode(p_name) +
         '" VALUE="':U + html-encode(p_value) + '">':U.
END FUNCTION.  /* hidden-field */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-hidden-field-list) = 0 &THEN

&ANALYZE-SUSPEND _CODE-BLOCK _FUNCTION hidden-field-list 
FUNCTION hidden-field-list RETURNS CHARACTER
  (INPUT p_name-list AS CHARACTER) :
/****************************************************************************
Description: Returns list of fields formatted as hidden fields.
Input Parameters: List of field names (available via get-value), delimiter
Returns: HTML hidden fields delimited by newlines.
****************************************************************************/
  DEFINE VARIABLE i AS INTEGER NO-UNDO.
  DEFINE VARIABLE v-item AS CHARACTER NO-UNDO.
  DEFINE VARIABLE v-value AS CHARACTER NO-UNDO.
  DEFINE VARIABLE v-out AS CHARACTER NO-UNDO.

  IF p_name-list = "" THEN RETURN "".   /* return blank if blank */

  DO i = 1 TO NUM-ENTRIES(p_name-list):
    ASSIGN
      v-item = ENTRY(i, p_name-list)
      v-value = get-value(v-item).
    /* Only add hidden field if the value is not blank [Bug 97-02-14-036] */
    IF v-value <> "" THEN
      ASSIGN v-out = v-out + hidden-field(v-item, v-value) + "~n".
  END.
    
  RETURN v-out.
END FUNCTION.  /* hidden-field-list */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-html-encode) = 0 &THEN

&ANALYZE-SUSPEND _CODE-BLOCK _FUNCTION html-encode 
FUNCTION html-encode RETURNS CHARACTER
  (INPUT p_in AS CHARACTER):
/****************************************************************************
Description: Converts various ASCII characters to their HTML representation
  to prevent problems with invalid HTML.  This procedure can only be called
  once on a string or ampersands will incorrectly be replaced with "&amp; .
Input Parameter: Character string to encode
Returns: Encoded character string
****************************************************************************/
  /* Ampersand must be replaced first or the output will be hosed if done
     after any of these other subsititutions. */
  ASSIGN
    p_in = REPLACE(p_in, "&":U, "&amp~;":U)       /* ampersand */
    p_in = REPLACE(p_in, "~"":U, "&quot~;":U)     /* quote */
    p_in = REPLACE(p_in, "<":U, "&lt~;":U)        /* < */
    p_in = REPLACE(p_in, ">":U, "&gt~;":U).       /* > */
  RETURN p_in.
END FUNCTION. /* html-encode */
&ANALYZE-RESUME

&ENDIF
/*
&IF DEFINED(EXCLUDE-output-content-type) = 0 &THEN

&ANALYZE-SUSPEND _CODE-BLOCK _FUNCTION output-content-type 
FUNCTION output-content-type RETURNS LOGICAL
  (INPUT p_type AS CHARACTER) :
/****************************************************************************
Description: Sets and outputs the MIME Content-Type header followed by a
  blank line.  If the header was already output, no action is taken.
Input Parameter: MIME content type.  If the input value is "", then no
  Content-Type header will be output.  However, other headers such as Cookies
  will be output followed by a blank line.
Returns: If a Content-Type header was output, TRUE is returned, else FALSE.
Global Variables: output-content-type
****************************************************************************/  
  DEFINE VARIABLE c-new-wseu   AS CHARACTER NO-UNDO.
  DEFINE VARIABLE rslt         AS LOGICAL   NO-UNDO.
  DEFINE VARIABLE mime-charset AS CHARACTER NO-UNDO.
  
  /* Set the content type. If previously set, then output-content-type will
     be non-blank.  In that case we do nothing.  If p_type is blank, then no
     Content-Type header will be output.  In this case output-content-type 
     will be set to ?. */
  IF output-content-type = "" THEN DO:
    ASSIGN 
      output-content-type = (IF p_type = "" THEN ? ELSE p_type)
      c-new-wseu          = ENTRY(2, {&WEB-EXCLUSIVE-ID}, "=":U).
      
    &IF KEYWORD-ALL("HTML-CHARSET") <> ? &THEN  
    /* Add MIME codepage, if available. */
    IF output-content-type BEGINS TRIM("text/html":U) 
      AND INDEX(output-content-type, "charset":U) = 0
      AND wcCharset <> "" THEN DO:
        RUN adecomm/convcp.p ( wcCharset, "toMime":U,
                               OUTPUT mime-charset ) NO-ERROR.
        IF mime-charset <> "" THEN
          output-content-type = output-content-type + "; charset=":U + 
                                mime-charset.
    END.
    &ENDIF
    
    /* If there are any persistent Web objects, then reset the cookie used by 
     * the web broker to identify this Agent. (The wo temp-table is 
     * defined in web/objects/web-util.p.)
     */
    RUN find-web-objects IN web-utilities-hdl (OUTPUT rslt).
    IF rslt THEN
      set-wseu-cookie(c-new-wseu).
    ELSE
      /* No persistent Web objects, so kill the wseu cookie */
      set-wseu-cookie("").

    IF output-content-type <> ? THEN
       output-http-header ("Content-Type":U, output-content-type).
    output-http-header ("", "").  /* blank line */

    /* If output-content-type is not ?, then a Content-Type header was
       output so return TRUE. */
    RETURN (output-content-type <> ?).
  END.
  /*  This needs to be sent *after* <BODY> is output.  This error message is
      another reason why we need to queue up certain error messages and output
      later. -dma
  ELSE DO: /* Attempt to send cookies *after* Content-Type has been sent! */
    XXX: To do: Queue a runtime error message with queue-message().
    {&OUT}
    "<b>WARNING:</b> output-content-type was called more than once."
    .
    RETURN ?.
  END.
  */

  /* If the "top" debugging option was specified, run printval.p before the
     application output rather than after.  This is not the default because
     printval.p generates its own HEAD and BODY tags which could cause
     those tags in the application's HTML to not function as expected. */
  /** disable "top" option
  IF CAN-DO(debug-options,"top":U) THEN
    RUN web/support/printval.p (debug-options).
   **/

END FUNCTION. /* output-content-type */
&ANALYZE-RESUME

&ENDIF
*/
&IF DEFINED(EXCLUDE-output-http-header) = 0 &THEN

&ANALYZE-SUSPEND _CODE-BLOCK _FUNCTION output-http-header 
FUNCTION output-http-header RETURNS CHARACTER
  (INPUT p_header AS CHARACTER,
   INPUT p_value  AS CHARACTER) :
/****************************************************************************
Description: Outputs the specified HTTP header with associated value followed
  by a carriage return and linefeed.  If the header name is blank, then the
  value and carriage return/linefeed pair are still output.
Input Parameters: HTTP Header name (less colon), associated header value.
****************************************************************************/
  
  /* Remove a trailing colon or spaces from the header name.  Add it back
     on exactly the way we want it. */
  ASSIGN p_header = RIGHT-TRIM(p_header, ": ":U).
  IF p_header <> "" THEN
    ASSIGN p_header = p_header + ": ":U.

  /* If debugging is enabled and "http" is a debugging option, queue
     the headers so we can see what was actually sent out. */
  IF debugging-enabled AND CAN-DO(debug-options, "http":U) AND
      p_header <> "" AND p_value <> "" THEN
    queue-message("DEBUG":U, "<B>HTTP header:</B> ":U + p_header + p_value).

  /* Output the header and associated value to the output stream */
  PUT {&WEBSTREAM} CONTROL
    p_header
    p_value 
    /* Newline must have both CR and LF even on UNIX.   
       Bug: 97-03-04-008  Some web servers such as Netscape-Fasttrack 2.01
       don't like the CR character so allow the newline to be changed. */
    http-newline.
END FUNCTION. /* output-http-header */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-set-user-field) = 0 &THEN

&ANALYZE-SUSPEND _CODE-BLOCK _FUNCTION set-user-field 
FUNCTION set-user-field RETURNS LOGICAL  
  (INPUT p_name AS CHARACTER,
   INPUT p_value AS CHARACTER) :
/****************************************************************************
Description: Sets the associated value for the specified user field.  User
  field values are global and available to any Web object run by the
  current Agent in the same web request.  The value can be retrieved with 
  get-user-field() or get-value(). 
Input Parameters: Name of user field, associated value
Returns: TRUE if field added, otherwise FALSE
Side effects: Queues a message if adding a field fails
Global Variables: UserFieldList, UserFieldVar
****************************************************************************/

  DEFINE VARIABLE i AS INTEGER NO-UNDO.

  ASSIGN i = LOOKUP(p_name, UserFieldList).

  IF i > 0 THEN
    ASSIGN UserFieldVar[i] = p_value.
  ELSE DO:
    IF NUM-ENTRIES(UserFieldList) < {&MAX-USER-FIELDS} THEN
      ASSIGN
        UserFieldList = UserFieldList +
          (IF UserFieldList = "" THEN "" ELSE ",":U) + p_name
        i = NUM-ENTRIES(UserFieldList)
        UserFieldVar[i] = p_value.
    ELSE DO:
      /* If we get to here, then there's no more room for new parameters. */
      queue-message("WebSpeed":U, "set-user-field: maximum number of entries" +
                                  " {&MAX-USER-FIELDS} exceeded").
      ASSIGN i = ?.
    END.
  END.
  RETURN (i <> ?).  /* return TRUE unless field could not be added */
END FUNCTION. /* set-user-field */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-set-wseu-cookie) = 0 &THEN

&ANALYZE-SUSPEND _CODE-BLOCK _FUNCTION set-wseu-cookie 
FUNCTION set-wseu-cookie RETURNS CHARACTER
  (INPUT p_cookie AS CHARACTER) :
/****************************************************************************
Description: Sets the WSEU cookie in a standard way.  This also changes
  the wseu-cookie variable to the value set.  When this is called, it checks
  the current value of wseu-cookie, and only sets the new value if it is
  different.  If the new value, p_cookie, is blank or ?, then the wseu
  cookie is deleted.
Input Parameters: p_cookie -- the new cookie value..
****************************************************************************/
  /* Change unknown to blank. */
  IF p_cookie eq ? THEN p_cookie = "".

  /* Is the cookie value different? */
  IF p_cookie NE wseu-cookie THEN DO:
    /* Save the new value. */
    ASSIGN wseu-cookie = p_cookie.
    IF p_cookie eq "":U THEN 
      RETURN delete-cookie ({&WSEU-NAME}, ?, ?).   
    ELSE DO:
      IF NOT cfg-eval-mode THEN
        set-cookie ({&WSEU-NAME}, wseu-cookie, ?, ?, ?, ?, ?).    
      RETURN "".
    END.
  END.  
END FUNCTION. /* set-wseu-cookie */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-url-decode) = 0 &THEN

&ANALYZE-SUSPEND _CODE-BLOCK _FUNCTION url-decode 
FUNCTION url-decode RETURNS CHARACTER
  (INPUT p_in AS CHARACTER) :
/****************************************************************************
Description: Decodes URL form input from either POST or GET methods or
  encoded Cookie values.  CR/LF pairs are replaced with LF.
Input: String to decode
Returns: decoded string
****************************************************************************/
  DEFINE VARIABLE cOut AS CHARACTER NO-UNDO.
  DEFINE VARIABLE i   AS INTEGER    NO-UNDO.  
  DEFINE VARIABLE c   AS CHARACTER  NO-UNDO.
  /* Copy and replace from p_in to out.  Note that p_in will have
     End-of-Line replaced with a CF/LF.  We need to replace this with the
     4GL-standard LF so when an HTML <TEXTAREA> is saved in a database, it
     won't contain extra characters. */
  ASSIGN 
    p_in = REPLACE(REPLACE(p_in, 
                  "+":U, " ":U), 
                  "%0D%0A":U, "~n":U)
    .
  DO i = 1 TO LENGTH(p_in):
    c = SUBSTRING(p_in,i,1).
    IF c = "%" THEN DO:
      c = CHR(
        (INDEX("123456789ABCDEF",SUBSTRING(p_in,i + 1,1)) * 16) + 
         INDEX("123456789ABCDEF",SUBSTRING(p_in,i + 2,1)) 
      ).      
      i = i + 2.
    END.
    cOut = cOut + c. 
  END.
  RETURN cOut.
END FUNCTION.  /* url-decode */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-url-encode) = 0 &THEN

&ANALYZE-SUSPEND _CODE-BLOCK _FUNCTION url-encode 
FUNCTION url-encode RETURNS CHARACTER
  (INPUT p_value AS CHARACTER,
   INPUT p_enctype AS CHARACTER) :
/****************************************************************************
Description: Encodes unsafe characters in a URL as per RFC 1738 section 2.2.
  <URL:http://ds.internic.net/rfc/rfc1738.txt>, 2.2
Input Parameters: Character string to encode, Encoding option where "query",
  "cookie", "default" or any specified string of characters are valid.
  In addition, all characters specified in the global variable url_unsafe
  plus ASCII values 0 <= x <= 31 and 127 <= x <= 255 are considered unsafe.
Returns: Encoded string  (unkown value is returned as blank)
Global Variables: url_unsafe, url_reserved
****************************************************************************/
  DEFINE VARIABLE hx          AS CHARACTER NO-UNDO INITIAL "0123456789ABCDEF":U.
  DEFINE VARIABLE encode-list AS CHARACTER NO-UNDO.
  DEFINE VARIABLE i           AS INTEGER   NO-UNDO.
  DEFINE VARIABLE c           AS INTEGER   NO-UNDO.
 
  /* Don't bother with blank or unknown  */
  IF LENGTH(p_value) = 0 OR p_value = ? THEN 
    RETURN "":U.
   
  /* What kind of encoding should be used? */
  CASE p_enctype:
    WHEN "query":U THEN              /* QUERY_STRING name=value parts */
      encode-list = url_unsafe + url_reserved + "+":U.
    WHEN "cookie":U THEN             /* Persistent Cookies */
      encode-list = url_unsafe + " ,~;":U.
    WHEN "default":U OR WHEN "" THEN /* Standard URL encoding */
      encode-list = url_unsafe.
    OTHERWISE
      encode-list = url_unsafe + p_enctype.   /* user specified ... */
  END CASE.

  /* Loop through entire input string */
  ASSIGN i = 0.
  DO WHILE TRUE:
    ASSIGN
      i = i + 1
      /* ASCII value of character using single byte codepage */
      c = ASC(SUBSTRING(p_value, i, 1, "RAW":U), "1252", "1252").
    IF c <= 31 OR c >= 127 OR INDEX(encode-list, CHR(c)) > 0 THEN DO:
      /* Replace character with %hh hexidecimal triplet */
      SUBSTRING(p_value, i, 1, "RAW":U) =
        "%":U +
        SUBSTRING(hx, INTEGER(TRUNCATE(c / 16, 0)) + 1, 1, "RAW":U) + /* high */
        SUBSTRING(hx, c MODULO 16 + 1, 1, "RAW":U).             /* low digit */
      ASSIGN i = i + 2.   /* skip over hex triplet just inserted */
    END.
    IF i = LENGTH(p_value,"RAW") THEN LEAVE.
  END.

  RETURN p_value.
END FUNCTION.  /* url-encode */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-url-field) = 0 &THEN

&ANALYZE-SUSPEND _CODE-BLOCK _FUNCTION url-field 
FUNCTION url-field RETURNS CHARACTER
  (INPUT p_name AS CHARACTER,
   INPUT p_value AS CHARACTER,
   INPUT p_delim AS CHARACTER) :
/****************************************************************************
Description: Encodes name and value pairs for use suitable as an
  argument "field" to a URL.
Input Parameters: name, value, delimeter
Returns: Encoded name and value pair
****************************************************************************/
  RETURN (IF p_delim = ? THEN "&amp~;":U ELSE p_delim) +
         url-encode(p_name, "query":U) +
         "=":U +
         url-encode(p_value, "query":U).
END FUNCTION.  /* url-field */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-url-field-list) = 0 &THEN

&ANALYZE-SUSPEND _CODE-BLOCK _FUNCTION url-field-list 
FUNCTION url-field-list RETURNS CHARACTER
  (INPUT p_name-list AS CHARACTER,
   INPUT p_delim AS CHARACTER) :
/****************************************************************************
Description: Encodes list of items for use suitable as a argument "fields"
  to a URL.
Input Parameters: List of field names (available via get-value),
  delimiter
Returns: Encoded name and value pairs
****************************************************************************/
  DEFINE VARIABLE i AS INTEGER NO-UNDO.
  DEFINE VARIABLE v-item AS CHARACTER NO-UNDO.
  DEFINE VARIABLE v-value AS CHARACTER NO-UNDO.
  DEFINE VARIABLE v-out AS CHARACTER NO-UNDO.

  /* return blank if blank or unknown */
  IF p_name-list = "" OR p_name-list = ? THEN RETURN "".
  /* blank delimiter uses the default */
  IF p_delim = "" THEN p_delim = ?.

  DO i = 1 TO NUM-ENTRIES(p_name-list):
    ASSIGN
      v-item = ENTRY(i, p_name-list)
      v-value = get-value(v-item).
    /* Only add name=value pair if the value is not blank [Bug 97-02-14-036] */
    IF v-value <> "" THEN
      ASSIGN v-out = v-out +
        /* Encode to name=value pair using specified delimiter with no
           delimiter before the first name=value pair. */
        url-field(v-item, v-value, (IF v-out = "" THEN "" ELSE p_delim)).
  END.
    
  RETURN v-out.
END FUNCTION.  /* url-field-list */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-url-format) = 0 &THEN

&ANALYZE-SUSPEND _CODE-BLOCK _FUNCTION url-format 
FUNCTION url-format RETURNS CHARACTER
  (INPUT p_url AS CHARACTER,
   INPUT p_name-list AS CHARACTER,
   INPUT p_delim AS CHARACTER):
/****************************************************************************
Description: Given a URL, item list and delimiter, format it including any
  state information.
Input Parameters: URL, item list, argument delimeter (use ? for default)
Returns: Encoded URL
****************************************************************************/
  DEFINE VARIABLE url-arg AS CHARACTER NO-UNDO.

  ASSIGN url-arg = url-field-list(p_name-list, p_delim).

  RETURN (IF p_url = ? THEN SelfURL ELSE p_url) +
         (IF url-arg = "" THEN "" ELSE "?":U + url-arg).
END FUNCTION.  /* url-format */
&ANALYZE-RESUME

&ENDIF

&ANALYZE-SUSPEND _CODE-BLOCK _CUSTOM "Main Code Block" 


/* ***************************  Main Block  *************************** */
&ANALYZE-RESUME
/* **********************  Internal Procedures  *********************** */
&IF DEFINED(EXCLUDE-AsciiToHtml) = 0 &THEN

&ANALYZE-SUSPEND _CODE-BLOCK _PROCEDURE AsciiToHtml 
PROCEDURE AsciiToHtml :
/****************************************************************************
Description: See html-encode.  For backwards compatibility with
WebSpeed 1.0.
Input Parameter: Character string to convert
Output Parameter: Converted character string
****************************************************************************/
  DEFINE INPUT  PARAMETER p_in  AS CHARACTER NO-UNDO.
  DEFINE OUTPUT PARAMETER p_out AS CHARACTER NO-UNDO.

  /* Invoke function to perform the conversion */
  ASSIGN p_out = html-encode(p_in).
END PROCEDURE. /* AsciiToHtml */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-GetCGI) = 0 &THEN

&ANALYZE-SUSPEND _CODE-BLOCK _PROCEDURE GetCGI 
PROCEDURE GetCGI :
/****************************************************************************
Description: See getcgi().
Input Parameter: Name of variable or ?
Output Parameter: Value or blank if invalid name.  If ? was specified for
  the name, the list of variables is returned.
Global Variables: CgiList, CgiVar
****************************************************************************/
  DEFINE INPUT  PARAMETER p_name  AS CHARACTER NO-UNDO.
  DEFINE OUTPUT PARAMETER p_value AS CHARACTER NO-UNDO.
  
  /* Just return the function output */
  ASSIGN p_value = get-cgi (p_name).
END PROCEDURE.
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-GetField) = 0 &THEN

&ANALYZE-SUSPEND _CODE-BLOCK _PROCEDURE GetField 
PROCEDURE GetField :
/****************************************************************************
Description: See get-field().
Input Parameter: Name of field or ?
Output Parameter: Value of field or blank if invalid field name.  If ? was
  specified for the name, the list of fields is returned.
Global Variables: FieldList, FieldVar
****************************************************************************/
  DEFINE INPUT  PARAMETER p_name  AS CHARACTER NO-UNDO.
  DEFINE OUTPUT PARAMETER p_value AS CHARACTER NO-UNDO.
  DEFINE VARIABLE i AS INTEGER NO-UNDO.

  /* Just return the function output */
  ASSIGN p_value = get-field(p_name).
END PROCEDURE.
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-HtmlError) = 0 &THEN

&ANALYZE-SUSPEND _CODE-BLOCK _PROCEDURE HtmlError 
PROCEDURE HtmlError :
/****************************************************************************
Description: Prints the input text string as an HTML error message also
  printing the MIME Content-Type header if required.
Input Parameter: Character string to output
****************************************************************************/
  DEFINE INPUT PARAMETER p_error AS CHARACTER NO-UNDO.
  
  RUN OutputContentType (INPUT "text/html":U).
  {&OUT}
  "<HTML>~n":U
  "<HEAD><TITLE>":U "Application Error" "</TITLE></HEAD>~n":U
  "<BODY>~n":U
  "<H1>":U "Application Error" "</H1>~n~n":U
  "<P>":U p_error "</P>~n":U
  (IF HelpAddress <> "" THEN
    "<P>":U + "In the event of a problem with this application, please " +
    "contact " + HelpAddress + "</P>~n":U ELSE "")
  "</BODY>~n":U
  "</HTML>~n":U
  {&END}
END PROCEDURE. /* HtmlError */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-OutputContentType) = 0 &THEN

&ANALYZE-SUSPEND _CODE-BLOCK _PROCEDURE OutputContentType 
PROCEDURE OutputContentType :
/****************************************************************************
Description: See output-content-type().
Input Parameter: MIME content type (optional).  The default Content Type is
  "text/html" if the input value is "".
Global Variables: output-content-type
****************************************************************************/
  DEFINE INPUT PARAMETER p_type AS CHARACTER NO-UNDO.

  /* Execute the output-content-type() function.  For backwards compatibility,
     make text/html the default MIME type. */
  output-content-type ((IF p_type = "" THEN "text/html":U ELSE p_type)).
END PROCEDURE. /* OutputContentType */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-OutputHttpHeader) = 0 &THEN

&ANALYZE-SUSPEND _CODE-BLOCK _PROCEDURE OutputHttpHeader 
PROCEDURE OutputHttpHeader :
/****************************************************************************
Description: See output-http-header().
Input Parameters: HTTP Header name (less colon), associated header value.
****************************************************************************/
  DEFINE INPUT PARAMETER p_header AS CHARACTER NO-UNDO.
  DEFINE INPUT PARAMETER p_value  AS CHARACTER NO-UNDO.
  
  output-http-header(p_header, p_value).
END PROCEDURE. /* OutputHttpHeader */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-UrlDecode) = 0 &THEN

&ANALYZE-SUSPEND _CODE-BLOCK _PROCEDURE UrlDecode 
PROCEDURE UrlDecode :
/****************************************************************************
Description: See url-decode().
Input: String to decode
Output: decoded string
Stream: Decoded string
****************************************************************************/
  DEFINE INPUT  PARAMETER p_in  AS CHARACTER NO-UNDO.
  DEFINE OUTPUT PARAMETER p_out AS CHARACTER NO-UNDO.

  ASSIGN p_out = url-decode(p_in).
END PROCEDURE.  /* UrlDecode */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-UrlEncode) = 0 &THEN

&ANALYZE-SUSPEND _CODE-BLOCK _PROCEDURE UrlEncode 
PROCEDURE UrlEncode :
/****************************************************************************
Description: See url-encode().
Input Parameters: Character string to encode, Encoding option where "query",
  "cookie", "default" or any specified string of characters are valid.
  In addition, all characters specified in the global variable url_unsafe
  plus ASCII values 0 <= x <= 31 and 127 <= x <= 255 are considered unsafe.
Output: Encoded string
Global Variables: url_unsafe, url_reserved
****************************************************************************/
  DEFINE INPUT  PARAMETER p_value   AS CHARACTER NO-UNDO.
  DEFINE OUTPUT PARAMETER p_encoded AS CHARACTER NO-UNDO.
  DEFINE INPUT  PARAMETER p_enctype AS CHARACTER NO-UNDO.

  ASSIGN p_encoded = url-encode(p_value, p_enctype).
END PROCEDURE.  /* UrlEncode */

/* END OF CGIUTILS.I PREPROCESSOR */
&ENDIF  /* DEFINED(CGIUTILS_I) = 0 */
&ANALYZE-RESUME







/* ***************************************** */
/* This section is the original web-utils    */
/* ***************************************** */


&UNDEFINE EXCLUDE-output-content-type 

{ src/web/method/cookies.i}   
{ src/web/method/message.i}
{ src/web/method/webutils.i }



/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-PREPROCESSOR-BLOCK 

/* ********************  Preprocessor Definitions  ******************** */

&Scoped-define PROCEDURE-TYPE Procedure
&Scoped-define DB-AWARE no



/* _UIB-PREPROCESSOR-BLOCK-END */
&ANALYZE-RESUME


/* ************************  Function Prototypes ********************** */
&IF DEFINED(EXCLUDE-logWrite) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD logWrite Procedure
FUNCTION logWrite RETURNS LOGICAL PRIVATE
	(  ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-logNote) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD logNote Procedure
FUNCTION logNote RETURNS LOGICAL
  ( INPUT pcLogType AS CHARACTER,
    INPUT pcLogText AS CHARACTER )  FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-getLogFile) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD getLogFile Procedure
FUNCTION getLogFile RETURNS CHARACTER PRIVATE
	(  ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF


&IF DEFINED(EXCLUDE-check-agent-mode) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD check-agent-mode Procedure 
FUNCTION check-agent-mode RETURNS LOGICAL
  ( INPUT p_mode AS CHARACTER )  FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-devCheck) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD devCheck Procedure 
FUNCTION devCheck RETURNS LOGICAL
  ( /* parameter-definitions */ )  FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-get-config) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD get-config Procedure 
FUNCTION get-config RETURNS CHARACTER
  ( INPUT cVarName AS CHARACTER )  FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-getAgentSetting) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD getAgentSetting Procedure 
FUNCTION getAgentSetting RETURNS CHARACTER
  (cInKey  AS CHARACTER,
   cInSub  AS CHARACTER,
   cInName AS CHARACTER) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-logNote) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD logNote Procedure 
FUNCTION logNote RETURNS LOGICAL
  ( INPUT pcLogType AS CHARACTER,
    INPUT pcLogText AS CHARACTER )  FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-output-content-type) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD output-content-type Procedure 
FUNCTION output-content-type RETURNS LOGICAL
  ( INPUT p_type AS CHARACTER )  FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-setAgentSetting) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD setAgentSetting Procedure 
FUNCTION setAgentSetting RETURNS LOGICAL
  (cInKey  AS CHARACTER,
   cInSub  AS CHARACTER,
   cInName AS CHARACTER,
   cInVal  AS CHARACTER) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-showErrorScreen) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD showErrorScreen Procedure 
FUNCTION showErrorScreen RETURNS LOGICAL
  ( INPUT cErrorMsg AS CHARACTER)  FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-trueRandom) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD trueRandom Procedure 
FUNCTION trueRandom RETURNS CHARACTER
  ( /* parameter-definitions */ )  FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-webCompile) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD webCompile Procedure 
FUNCTION webCompile RETURNS CHARACTER
  ( INPUT cFile     AS CHARACTER)  FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF


/* *********************** Procedure Settings ************************ */

&ANALYZE-SUSPEND _PROCEDURE-SETTINGS
/* Settings for THIS-PROCEDURE
   Type: Procedure
   Allow: 
   Frames: 0
   Add Fields to: Neither
   Other Settings: CODE-ONLY COMPILE
 */
&ANALYZE-RESUME _END-PROCEDURE-SETTINGS

/* *************************  Create Window  ************************** */

&ANALYZE-SUSPEND _CREATE-WINDOW
/* DESIGN Window definition (used by the UIB) 
  CREATE WINDOW Procedure ASSIGN
         HEIGHT             = 18.86
         WIDTH              = 109.
/* END WINDOW DEFINITION */
                                                                        */
&ANALYZE-RESUME

 


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CUSTOM _MAIN-BLOCK Procedure 


/* ***************************  Main Block  *************************** */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


/* **********************  Internal Procedures  *********************** */
&IF DEFINED(EXCLUDE-addCookie) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE addCookie Procedure
PROCEDURE addCookie :
/*------------------------------------------------------------------------------
  Purpose:     
  Parameters:  <none>
  Notes:       
------------------------------------------------------------------------------*/
  DEFINE INPUT  PARAMETER cName  AS CHARACTER  NO-UNDO.
  DEFINE INPUT  PARAMETER cValue AS CHARACTER  NO-UNDO.

  FIND ttForm WHERE ttForm.tName = cName NO-ERROR.
  IF NOT AVAILABLE ttForm THEN DO:
    CREATE ttForm.
    ASSIGN 
      ttForm.tValue = URL-DECODE(cValue)
      ttForm.tName  = cName
      .
  END.
  wcCookie = wcCookie + (IF wcCookie = "" THEN "" ELSE ",") + cName.
END PROCEDURE.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-addFormGet) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE addFormGet Procedure
PROCEDURE addFormGet:
/*------------------------------------------------------------------------------
  Purpose:     
  Parameters:  <none>
  Notes:       
------------------------------------------------------------------------------*/
  DEFINE INPUT  PARAMETER cName  AS CHARACTER  NO-UNDO.
  DEFINE INPUT  PARAMETER cValue AS CHARACTER  NO-UNDO.
  
  FIND ttForm WHERE ttForm.tName = cName NO-ERROR.
  IF NOT AVAILABLE ttForm THEN
    CREATE ttForm.
  ASSIGN ttForm.tValue = URL-DECODE(cValue)
         ttForm.tName  = cName
         wcFormGet    = wcFormGet + (IF wcFormGet = "" THEN "" ELSE ",") + cName
         .
END PROCEDURE.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-addPost) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE addPost Procedure
PROCEDURE addFormPost :
/*------------------------------------------------------------------------------
  Purpose:     
  Parameters:  <none>
  Notes:       
------------------------------------------------------------------------------*/
  DEFINE INPUT  PARAMETER cName  AS CHARACTER  NO-UNDO.
  DEFINE INPUT  PARAMETER cValue AS CHARACTER  NO-UNDO.
  FIND ttForm WHERE ttForm.tName = cName NO-ERROR.
  IF NOT AVAILABLE ttForm THEN 
    CREATE ttForm.
  ASSIGN ttForm.tValue = URL-DECODE(cValue)
         ttForm.tName  = cName
         wcFormPost    = wcFormPost + (IF wcFormPost = "" THEN "" ELSE ",") + cName
         .
END PROCEDURE.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-addCGI) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE addCGI Procedure
PROCEDURE addCGI :
/*------------------------------------------------------------------------------
  Purpose:     
  Parameters:  <none>
  Notes:       
------------------------------------------------------------------------------*/
  DEFINE INPUT  PARAMETER cName  AS CHARACTER  NO-UNDO.
  DEFINE INPUT  PARAMETER cValue AS CHARACTER  NO-UNDO.
  find first ttCGI where ttCGI.tName = cName no-error.
  if not available ttCGI then
	  CREATE ttCGI.
  ASSIGN 
    wcCGI        = wcCGI + (IF wcCGI = "" THEN "" ELSE "~377") + cName
    ttCGI.tName  = cName
    ttCGI.tValue = cValue
    .
END PROCEDURE.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF


&IF DEFINED(EXCLUDE-dbCheck) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE dbCheck Procedure 
PROCEDURE dbCheck :
/*------------------------------------------------------------------------------
  Purpose:     
  Parameters:  <none>
  Notes:      Called from web-util after filename has been figured out 
------------------------------------------------------------------------------*/
   DEFINE INPUT  PARAMETER pcFilename AS CHARACTER  NO-UNDO.
   DEFINE OUTPUT PARAMETER lRetVal    AS LOGICAL    NO-UNDO INITIAL TRUE.

END PROCEDURE.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-delete-tagmap-utilities) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE delete-tagmap-utilities Procedure 
PROCEDURE delete-tagmap-utilities :
/*------------------------------------------------------------------------------
  Purpose:     Delete any tagmap utility procedures as well as the tagmap
               records.
  Parameters:  <none>
  Notes:       
------------------------------------------------------------------------------*/
  /* Remove any existing tagmap records and persistent utilities. */
  FOR EACH tagmap:
    /* Delete the persistent process. */
    IF VALID-HANDLE(tagmap.util-Proc-Hdl) THEN
      DELETE PROCEDURE tagmap.util-Proc-Hdl NO-ERROR.
    /* Now the record can be deleted. */
    DELETE tagmap.
  END.

END PROCEDURE.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-destroy) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE destroy Procedure 
PROCEDURE destroy :
/*------------------------------------------------------------------------------
  Purpose:     Destroy Web object, if any, before destroying this-procedure. 
  Parameters:  <none>
  Notes:
------------------------------------------------------------------------------*/
  FOR EACH tagmap:
    DELETE PROCEDURE tagmap.util-Proc-Hdl NO-ERROR.
  END.
  ASSIGN web-utilities-hdl = ?.
  DELETE PROCEDURE THIS-PROCEDURE NO-ERROR.

END PROCEDURE.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-end-request) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE end-request Procedure 
PROCEDURE end-request :
/*------------------------------------------------------------------------------
  Purpose:     place-holder procedure for allowing other super procedures to run
               after a web request has completed
  Parameters:  <none>
  Notes:       
------------------------------------------------------------------------------*/
  EMPTY TEMP-TABLE ttCGI.
  EMPTY TEMP-TABLE ttForm.
  ASSIGN    wcFormPost = ""
    wcFormGet  = ""
    wcCGI      = ""
    wcCookie   = "".

  /* runlog */
  logNote("RUN":U, "End webrequest: " +              
             STRING(YEAR(TODAY),"9999":U) + "/" +
             STRING(MONTH(TODAY),"99":U) + "/" +
             STRING(DAY(TODAY),"99":U) + " " +
             STRING(TIME,"HH:MM:SS":U) + "~n").
  logWrite().
    
END PROCEDURE.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-get-server-connection) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE get-server-connection Procedure 
PROCEDURE get-server-connection :
/*------------------------------------------------------------------------------
  Purpose:     Return the value of SESSION:SERVER-CONNECTION-ID
  Parameters:  <none>
  Notes:       
------------------------------------------------------------------------------*/
  RETURN server-connection.

END PROCEDURE.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-get-transaction-state) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE get-transaction-state Procedure 
PROCEDURE get-transaction-state :
/*------------------------------------------------------------------------------
  Purpose:     Return the transaction state.
  Parameters:  <none>
  Notes:       
------------------------------------------------------------------------------*/
  IF glStateAware THEN DO:
    /* Run get-transaction-state in web/objects/stateaware.p. */
    RUN SUPER.
    RETURN RETURN-VALUE.
  END.
  ELSE
    DYNAMIC-FUNCTION ("logNote":U IN web-utilities-hdl, "Error":U,
                      "#3 StateAware support is inactive.  To activate, create a broker 'STATE_AWARE_ENABLED' environment variable with value of 'yes'.") NO-ERROR.

END PROCEDURE.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-init-cgi) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE init-cgi Procedure 
PROCEDURE init-cgi :
/*---------------------------------------------------------------------------
  Procedure:   init-cgi
  Description: Initializes WebSpeed functionality prior to web request
  Input:       Environment variables
  Output:      Sets global variables defined in src/web/method/cgidefs.i
---------------------------------------------------------------------------*/
  DEFINE VARIABLE v-http-host     AS CHARACTER  NO-UNDO.
  DEFINE VARIABLE v-host          AS CHARACTER  NO-UNDO.
  DEFINE VARIABLE v-port          AS CHARACTER  NO-UNDO.

  RUN init-variables.    /* initialize CGI and misc. variables */
  
  /* Reset the server-connection variable and SERVER_CONNECTION_ID cookie. */
  RUN set-server-connection(SESSION:SERVER-CONNECTION-ID).
    
  /* Initialize User Fields */
  ASSIGN
    UserFieldVar  = ""
    UserFieldList = "".

  /* Set global variables HostURL, AppURL and SelfURL so self-referencing
     URL's can be generated by applications. If the Host: header (HTTP_HOST) 
     was sent by the browser, using it will provide for fewer problems with 
     self-referencing URL's than SERVER_NAME and SERVER_PORT. */
  ASSIGN 
    v-http-host = get-cgi("HTTP_HOST":U).
  IF v-http-host = "" THEN
    /* No Host: header was sent by the browser. */
    ASSIGN 
      v-host = SERVER_NAME
      v-port = SERVER_PORT.
  ELSE IF NUM-ENTRIES(v-http-host, ":":U) = 2 THEN
  /* Host: hostname:port combination was sent by the browser */
    ASSIGN 
      v-host = ENTRY(1, v-http-host, ":":U)
      v-port = ENTRY(2, v-http-host, ":":U).
  ELSE
  /* Else Host: hostname with no port number was sent by the browser */
    ASSIGN 
      v-host = v-http-host
      v-port = SERVER_PORT.
  /* Set the scheme, host and port of the URL to ourself.  Omit
     port if 80 or 443 if https is on. */
  IF HTTPS = "ON":U THEN
    ASSIGN 
      HostURL = (IF v-host = "" THEN ""
                 ELSE "https://":U + v-host +
                  (IF v-port = "443":U THEN "" ELSE ":":U + v-port)).
  ELSE
    ASSIGN 
      HostURL = (IF v-host = "" THEN ""
                 ELSE "http://":U + v-host +
                  (IF v-port = "80":U THEN "" ELSE ":":U + v-port)).

  /* Server-relative URL to ourself (this program) except for optional
       QUERY_STRING. */
  ASSIGN
    SelfURL = SCRIPT_NAME + PATH_INFO.

  /* Check for alternate URL format used by the Messengers */
  IF PATH_INFO BEGINS "/WService=":U THEN
    ASSIGN
      /* Web object filename is everything after the second "/" in PATH_INFO */
      AppProgram = (IF NUM-ENTRIES(PATH_INFO, "/":U) >= 3 THEN
                      SUBSTRING(PATH_INFO, INDEX(PATH_INFO, "/":U, 2) + 1)
                    ELSE "")
      /* Server relative URL of this Web objects's application */
      AppURL     = SCRIPT_NAME + "/":U + ENTRY(2, PATH_INFO, "/":U).

  ELSE
    ASSIGN
      /* Web object filename is everything after the second "/" in PATH_INFO */
      AppProgram = SUBSTRING(PATH_INFO, 2)
      /* Server relative URL of this Web objects's application */
      AppURL     = SCRIPT_NAME.

  /* If the ApplicationURL option was set in the Windows Registry or
     webspeed.cnf, then use that to set AppURL instead of SCRIPT_NAME and
     PATH_INFO.  Make sure it's prefixed with a "/" since we don't handle
     an entire URL. */
  IF cfg-appurl BEGINS "/":U THEN
    ASSIGN
      AppURL  = cfg-appurl
      SelfURL = AppURL + "/":U + AppProgram.

  /* The Alibaba 2.0 NT server upper cases SCRIPT_NAME and PATH_INFO.  This
     is a bug.  To work around this, lower case AppURL, etc.  Otherwise
     Cookies (which are case sensitive) will fail to match preventing
     locking from working . */
  IF SERVER_SOFTWARE BEGINS "Alibaba/2":U THEN
    ASSIGN
      HostURL    = LC(HostURL)
      AppURL     = LC(AppURL)
      SelfURL    = LC(SelfURL)
      AppProgram = LC(AppProgram).
 
  ASSIGN
    http-newline = (IF SERVER_SOFTWARE BEGINS "Netscape-":U 
                    OR SERVER_SOFTWARE BEGINS "IPlanet-":U 
                    OR SERVER_SOFTWARE BEGINS "Sun ONE":U 
                    OR SERVER_SOFTWARE BEGINS "FrontPage-PWS":U THEN "~n":U
                    ELSE "~r~n":U)

    /* Set cookie defaults from either configuration defaults or AppURL */
    CookiePath   = (IF cfg-cookiepath <> "" THEN cfg-cookiepath ELSE AppURL)
    CookieDomain = cfg-cookiedomain.
  
END PROCEDURE.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-init-config) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE init-config Procedure 
PROCEDURE init-config :
/*------------------------------------------------------------------------------
  Purpose:     Read in extra configuration options at Agent startup.
  Parameters:  None
  Notes:       Watch the propath issues
               Check for @{workpath} and v-workdir 
               Review Xcode option(s)
               Consider prefixing settings.
               Bring all Dynamics vars (icf*) into variable(s) then parse. This will avoid 
               hard-coding, but it will add a level of complexity.
------------------------------------------------------------------------------*/
  DEFINE VARIABLE cValue     AS CHARACTER  NO-UNDO.
  DEFINE VARIABLE ix         AS INTEGER    NO-UNDO.
  DEFINE VARIABLE cDatabases AS CHARACTER  NO-UNDO.

  /* Set a default session tracking cookie. This allows the application to automatically 
     track anonymouse/unidentified user 'movements' through the system.  This is 
     the prefix of the cookie. If it is non-blank the session tracking cookie 
     will be used automatically. */
  ASSIGN cValue = OS-GETENV("SESSION_COOKIE":U).
  IF cValue > "" THEN
    setAgentSetting("Session":U,"","Cookie":U,cValue).

  /* WebRunPath example.  Allow specific resources to be accessed via the URL.  
     This does not override the PROPATH.
        
     WebRunPath=c:\webapps\apps\ *,c:\program files\progress\tty\webtools\ *,
                c:\program files\progress\tty\webedit\ *,
                c:\program files\progress\tty\workshop.r
  */
  ASSIGN cValue = REPLACE(OS-GETENV("WEB_RUN_PATH":U),';',',').
  IF cValue > "" THEN
    setAgentSetting("Path":U,"","WebRunPath":U,cValue).
  
  /* Batch Interval Time.  Amount of time agents sit idle before breaking out 
     of WAIT-FOR and running DB checks and the batch procedure.  Wait for 
     web-request for the larger of either 15, or cfg-check-interval seconds. By 
     breaking out of WAIT-FOR we can simulate a batch procedure.  NOTE: Anything 
     that goes into the batch program should have a relatively short run time,
     otherwise agents could potentially all lock. */ 
  ASSIGN ix = INTEGER(OS-GETENV("BATCH_INTERVAL":U)) NO-ERROR.
  ASSIGN ix = IF ix > 0 THEN MAXIMUM(15,ix) ELSE -1.
  setAgentSetting("Misc":U,"","BatchInterval":U,STRING(ix)).

  /* CompileOnFly.  What options to use when compilation is needed.
     Save:  Save the r-code after the compile.
     CheckTime: Check the time difference between the source and R-code and 
     compile if source is newer. */    
  ASSIGN cValue  = REPLACE(OS-GETENV("COMPILE_ON_FLY":U),";",",").
  IF cValue > "" THEN
    setAgentSetting("Compile":U,"":U, "Options":U,cValue).

  /* CompileXCODE -- Xcode to be used when compile code. */
  ASSIGN cValue = OS-GETENV("COMPILE_XCODE":U).
  IF cValue > "" THEN
    setAgentSetting("Compile":U,"","xcode",cValue).

  /* SessionPath configuration -- path for storing session information.
     This option is not used when using database-driven session storage 
     mechanism. */
  ASSIGN cValue = OS-GETENV("SESSION_PATH":U).
  IF cValue > "" THEN
    setAgentSetting("Session":U,"","StorePath":U, REPLACE(cValue,"~\","~/")).

  /* Set flag that activates state-aware support code. Check for missing value
     for backward compatability. */
  ASSIGN cValue = OS-GETENV("STATE_AWARE_ENABLED":U).
  IF cValue = "yes":U OR cValue = "" OR cValue = ? THEN
    setAgentSetting("Session":U, "", "StateAware":U, "yes":U).


  /* runlog */
  DEFINE VARIABLE c1         AS CHARACTER  NO-UNDO.
  DEFINE VARIABLE c2         AS CHARACTER  NO-UNDO.
  DEFINE VARIABLE i1         AS INTEGER    NO-UNDO.
  DEFINE VARIABLE lRetVal    AS LOGICAL    NO-UNDO.
  
  /* Logging.  Not just a canadian thing anymore
  */ 
  ASSIGN 
    c1      = REPLACE("*",";",",")
    c1      = (IF c1 EQ "" OR c1 = ? THEN "*" ELSE c1)
    lRetVal = DYNAMIC-FUNCTION("setAgentSetting" IN web-utilities-hdl,
                "Logging":U,"","LogTypes":U,c1).

  ASSIGN 
    c1                  =   getProjectWorkDirectory()
    FILE-INFORMATION:FILE-NAME = c1 NO-ERROR.
  IF FILE-INFORMATION:FULL-PATHNAME         EQ ? OR 
    INDEX(FILE-INFORMATION:FILE-TYPE,"D":U) LT 1 THEN
    ASSIGN c1 = SESSION:TEMP-DIRECTORY.
  lRetVal = DYNAMIC-FUNCTION("setAgentSetting" IN web-utilities-hdl,
              "Logging":U,"","LogDir":U, REPLACE (c1,"~\","~/")).

END PROCEDURE.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-init-request) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE init-request Procedure 
PROCEDURE init-request :
/*---------------------------------------------------------------------------
  Procedure:   init-request
  Description: Initializes WebSpeed environment for each web request
  Input:       Environment variables
  Output:      Sets global variables defined in src/web/method/cgidefs.i
---------------------------------------------------------------------------*/
  ASSIGN 
    output-content-type = "".

  /* runlog */
  ASSIGN
    iEtime = ETIME(TRUE) 
    iEtime = 0.

  IF CAN-DO(cLogTypes,"RUN") AND cLogPath NE "" THEN  
    cRunLog = " ~n":U + 
             STRING(YEAR(TODAY),"9999":U) + "/" +
             STRING(MONTH(TODAY),"99":U) + "/" +
             STRING(DAY(TODAY),"99":U) + " " +
             STRING(TIME,"HH:MM:SS":U) + " ":U + 
             " Program ("       +
             ENTRY(1,appProgram,".":U)       + 
             ", METHOD = ":U                 +
             REQUEST_METHOD                  + ") ":U + "~n".
  
END PROCEDURE.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-init-session) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE init-session Procedure 
PROCEDURE init-session :
/*---------------------------------------------------------------------------
  Procedure:   init-session
  Description: Initializes PROGRESS session variables from the environment. 
  Input:       <none>
  Output:      Sets global variables defined in src/web/method/cgidefs.i
  Notes:       These values should be the default values on a WEB-based client.
               (But it never hurts to make sure.)
----------------------------------------------------------------------------*/
  DEFINE VARIABLE cValue AS  CHARACTER  NO-UNDO.

  /* Never pause for user input. */
  PAUSE 0 BEFORE-HIDE.
  ASSIGN 
    SESSION:SYSTEM-ALERT-BOXES = FALSE
    SESSION:APPL-ALERT-BOXES   = FALSE.
 
  /* Get configuration settings from ubroker.properties */
  ASSIGN
    cfg-environment  = "Development" 
    cfg-eval-mode    = FALSE   
    cfg-debugging    = "Enabled" 
    cfg-appurl       = ""
    cfg-cookiepath   = ""
    cfg-cookiedomain = ""
    RootURL          = "/webspeed"
    .

  /* If in Production mode and debugging is not enabled or debugging is
     disabled, then set flag to disable debugging. */
  ASSIGN debugging-enabled = TRUE.

  IF debugging-enabled THEN
    /* The following values are retrieved from the Configuration Manager. */
    ASSIGN
      cfg-development-mode = cfg-environment BEGINS "Dev"
      cfg-compile-options  = getAgentSetting("Compile":U, "":U, "Options":U)
      cfg-compile-xcode    = getAgentSetting("Compile":U, "":U, "xcode":U)
      cfg-web-run-path     = getAgentSetting("Path":U, "":U,"WebRunPath":U)
      cfg-no-save-rcode    = CAN-DO(cfg-compile-options,"NoSave")
      cfg-checktime        = CAN-DO(cfg-compile-options,"CheckTime")
      cfg-compile-on-fly   = cfg-compile-options > "" AND cfg-development-mode
      glStateAware = NO.
      .

   /** runlog - setup Runlogging dir/logname **/
   ASSIGN 
     cLogTypes = DYNAMIC-FUNCTION ("getAgentSetting":U IN web-utilities-hdl,"Logging":U, "":U, "LogTypes":U)
     cLogPath  = DYNAMIC-FUNCTION ("getAgentSetting":U IN web-utilities-hdl,"Logging":U, "":U, "LogDir":U)
     lNoCache  = CAN-DO(cLogtypes,'NoCache').


END PROCEDURE.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-init-variables) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE init-variables Procedure 
PROCEDURE init-variables :
/*---------------------------------------------------------------------------
Procedure:   init-variables
Description: Initializes PROGRESS variables from the environment
Input:       Environment variables
Output:      Sets global variables defined in src/web/method/cgidefs.i
----------------------------------------------------------------------------*/
  DEFINE VARIABLE i-field AS CHARACTER  NO-UNDO.
  DEFINE VARIABLE i-pair  AS CHARACTER  NO-UNDO.
  DEFINE VARIABLE asc-del AS CHARACTER  NO-UNDO
    INITIAL "~377":U.   /* delimiter character in octal = CHR(255) */
  DEFINE VARIABLE hex-del AS CHARACTER  NO-UNDO
    INITIAL "%FF":U.    /* delimiter character in encoded hex */
  DEFINE VARIABLE ix      AS INTEGER    NO-UNDO.
  DEFINE VARIABLE eql     AS INTEGER    NO-UNDO.
  
  /* Global variables to initialize with each request */
  ASSIGN
    CgiVar              = ""  
    CgiList             = ""  
    output-content-type = ""
    SelDelim            = ",":U
    FieldList           = ""
    FieldVar            = "".

  /* Read in the CGI environment variable pairs which are delimited by 
     ASCII 255 characters.  Any literal ASCII 255 values have been encoded
     as hexidecimal %FF in the same manner as URL encoding. */
  DO ix = 1 TO NUM-ENTRIES({&WEB-CURRENT-ENVIRONMENT}, asc-del):
    ASSIGN
      i-pair     = ENTRY(ix, {&WEB-CURRENT-ENVIRONMENT}, asc-del)
      eql        = INDEX(i-pair,"=":U)
      i-field    = SUBSTRING(i-pair,1,eql - 1,"RAW":U)
      CgiVar[ix] = REPLACE(SUBSTRING(i-pair,eql + 1,-1,"RAW":U),hex-del,asc-del)
      CgiList    = CgiList + (IF CgiList = "" THEN "" ELSE ",":U ) + i-field.
  END.

  /* Import CGI 1.1 variables into global variables */
  ASSIGN
    AUTH_TYPE               = get-cgi("AUTH_TYPE":U)
    CONTENT_LENGTH          = INTEGER(get-cgi("CONTENT_LENGTH":U))
    CONTENT_TYPE            = get-cgi("CONTENT_TYPE":U)
    GATEWAY_INTERFACE       = get-cgi("GATEWAY_INTERFACE":U)
    PATH_INFO               = get-cgi("PATH_INFO":U)
    PATH_TRANSLATED         = get-cgi("PATH_TRANSLATED":U)
    QUERY_STRING            = get-cgi("QUERY_STRING":U)
    REMOTE_ADDR             = get-cgi("REMOTE_ADDR":U)
    REMOTE_HOST             = get-cgi("REMOTE_HOST":U)
    REMOTE_IDENT            = get-cgi("REMOTE_IDENT":U)
    REMOTE_USER             = get-cgi("REMOTE_USER":U)
    REQUEST_METHOD          = get-cgi("REQUEST_METHOD":U)
    SCRIPT_NAME             = get-cgi("SCRIPT_NAME":U)
    SERVER_PROTOCOL         = get-cgi("SERVER_PROTOCOL":U)
    SERVER_NAME             = get-cgi("SERVER_NAME":U)
    SERVER_PORT             = get-cgi("SERVER_PORT":U)
    SERVER_SOFTWARE         = get-cgi("SERVER_SOFTWARE":U) NO-ERROR.

  /* Import some HTTP variables into global variables */
  ASSIGN
    HTTP_ACCEPT             = get-cgi("HTTP_ACCEPT":U)
    HTTP_COOKIE             = get-cgi("HTTP_COOKIE":U)
    HTTP_REFERER            = get-cgi("HTTP_REFERER":U)
    HTTP_USER_AGENT         = get-cgi("HTTP_USER_AGENT":U)
    HTTPS                   = get-cgi("HTTPS":U).

  /* Test for Microsoft's IIS which doesn't use HTTPS ON/OFF*/
  IF SERVER_SOFTWARE BEGINS "Microsoft-IIS/":U AND
    get-cgi("SERVER_PORT_SECURE":U) = "1":U THEN
    ASSIGN HTTPS = "ON":U.

  /* Other environment variables */
  ASSIGN
     UTC-OFFSET             = 0 /* WEB-CONTEXT:UTC-OFFSET */.

  /* If SERVER_PORT is null, then set it 80 or 443 if HTTPS is ON */
  IF SERVER_PORT = "" THEN
    ASSIGN SERVER_PORT = (IF HTTPS = "ON":U THEN "443":U ELSE "80":U).

END PROCEDURE.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-reset-tagmap-utilities) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE reset-tagmap-utilities Procedure 
PROCEDURE reset-tagmap-utilities :
/*------------------------------------------------------------------------------
  Purpose:     Load the tagmap.dat file and create entries in the tagmap temp-
               table. Run the procedures associated with each one of these
               files.              
  Parameters:  <none>
  Notes:       Any existing tagmap records are first deleted.
------------------------------------------------------------------------------*/
  DEFINE VARIABLE next-line   AS CHARACTER  NO-UNDO.
  DEFINE VARIABLE tagmapfile  AS CHARACTER  NO-UNDO.
  DEFINE VARIABLE cSearchFile AS CHARACTER  NO-UNDO.
  DEFINE VARIABLE i-count     AS INTEGER    NO-UNDO.
  DEFINE VARIABLE num-ent     AS INTEGER    NO-UNDO.
  
  DEFINE BUFFER xtagmap FOR tagmap.
  
  /* Remove any existing tagmap records and persistent utilities. */
  RUN delete-tagmap-utilities NO-ERROR.
  
  /* Make sure the tagmap.dat file exists in the PROPATH */
  ASSIGN 
    tagmapfile = SEARCH({&tagMapFileName})
    i-count    = 0.
  IF tagmapfile EQ ? THEN DO:
    DYNAMIC-FUNCTION ("logNote" IN web-utilities-hdl, "Error":U,
                                 "The file '":U + {&tagMapFileName} + "' was not in your PROPATH":U) NO-ERROR.
    RETURN ERROR.
  END.

  INPUT STREAM tagMapStream FROM VALUE(tagmapfile) NO-ECHO.
  REPEAT ON ENDKEY UNDO, LEAVE:
    /* Clear variable before read to handle blank lines. */
    ASSIGN 
      next-line = "". 
    IMPORT STREAM tagMapStream UNFORMATTED next-line.
    
    IF LENGTH(next-line,"CHARACTER":U) > 4 AND
      SUBSTRING(next-line,1,1,"CHARACTER":U) <> "#":U THEN DO:
      CREATE tagmap.
      ASSIGN
        i-count               = i-count + 1
        num-ent               = NUM-ENTRIES(next-line)
        tagmap.i-order        = i-count
        tagmap.htm-Tag        = ENTRY(1,next-line)
        tagmap.htm-Type       = (IF num-ent >= 3 THEN 
                                   ENTRY(3,next-line) ELSE "":U)
        tagmap.psc-Type       = (IF num-ent >= 4 
                                   THEN ENTRY(4,next-line) ELSE "":U)
        tagmap.util-Proc-Name = (IF num-ent >= 5 
                                   THEN ENTRY(5,next-line) ELSE "":U)
        .
      
      /* We allow for empty utility procedures. */
      IF tagmap.util-Proc-Name ne "":U THEN DO:
        /* If there another tagmap that is already running this procedure? */
        FIND FIRST xtagmap WHERE xtagmap.util-Proc-Name eq tagmap.util-Proc-Name
                             AND RECID(xtagmap) ne RECID(tagmap) NO-ERROR.
        IF AVAILABLE (xtagmap) AND VALID-HANDLE(xtagmap.util-Proc-Hdl) THEN
          tagmap.util-Proc-Hdl = xtagmap.util-Proc-Hdl.
        ELSE DO:
          /* Check that the file exists. */
          RUN adecomm/_rsearch.p (INPUT tagmap.util-Proc-Name, OUTPUT cSearchFile).
          IF cSearchFile ne ? THEN DO:
            /*RUN VALUE(cSearchFile) PERSISTENT SET tagmap.util-Proc-Hdl NO-ERROR.*/
            RUN VALUE(tagmap.util-Proc-Name) PERSISTENT SET tagmap.util-Proc-Hdl NO-ERROR.
            IF ERROR-STATUS:ERROR THEN DO:
              tagmap.util-Proc-Hdl = ?.
              RUN HtmlError (SUBSTITUTE ("Unable to run Tagmap Utility file '&1'", 
                                           tagmap.util-Proc-Name )).
            END. /* IF...ERROR... */
          END. /* IF cSearchFile ne ?... */
          ELSE
            RUN HtmlError (SUBSTITUTE ("Unable to find Tagmap Utility file '&1'", 
                                          tagmap.util-Proc-Name )).
        END. /* IF <not> AVAILABLE (xtagmap)... */
      END. /* IF...util-Proc-Name ne ""... */
     END. /* IF LENGTH... */
  END. /* REPEAT... */
  
  /* Close the tagmap stream. */
  INPUT STREAM tagMapStream CLOSE.
END PROCEDURE.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-run-batch-object) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE run-batch-object Procedure 
PROCEDURE run-batch-object :
/*------------------------------------------------------------------------------
  Purpose:      Runs the user specified procedure during the 'break wait-state' intervals.
  Parameters:  <none>
  Notes:       
------------------------------------------------------------------------------*/
  MESSAGE "Batch Procedure called but not configured!".
  
END PROCEDURE.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-run-web-object) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE run-web-object Procedure 
PROCEDURE run-web-object :
/*------------------------------------------------------------------------------
  Purpose:     Run the selected program 
  Parameters:  pcFilename = (CHAR) Name of application file user is requesting
  Notes:       If this agent is in development and rcode does not exist, then a 
               compile on the requested HTML program will be attempted and the 
               resulting rcode will be run if possible.
------------------------------------------------------------------------------*/
  DEFINE INPUT  PARAMETER pcFilename     AS CHARACTER  NO-UNDO.
   
  DEFINE VARIABLE cCompileExt            AS CHARACTER  NO-UNDO.
  DEFINE VARIABLE cCompilerMsg           AS CHARACTER  NO-UNDO.
  DEFINE VARIABLE cFileExt               AS CHARACTER  NO-UNDO.
  DEFINE VARIABLE cLog                   AS CHARACTER  NO-UNDO. 
  DEFINE VARIABLE cRFile                 AS CHARACTER  NO-UNDO.
  DEFINE VARIABLE cSearch                AS CHARACTER  NO-UNDO.
  DEFINE VARIABLE cSearchFile            AS CHARACTER  NO-UNDO.
  DEFINE VARIABLE cSessionPrefix         AS CHARACTER  NO-UNDO.
  DEFINE VARIABLE dFile                  AS DATE       NO-UNDO.
  DEFINE VARIABLE lCompiled              AS LOGICAL    NO-UNDO.
  DEFINE VARIABLE lRetVal                AS LOGICAL    NO-UNDO.
  DEFINE VARIABLE lRunOk                 AS LOGICAL    NO-UNDO.
  DEFINE VARIABLE tFile                  AS INTEGER    NO-UNDO.

  /* Log all runs of workshop in Production */
  IF cfg-development-mode NE TRUE AND pcFilename MATCHES "workshop*" THEN DO:
    ASSIGN
      cLog = SUBSTITUTE("WebSpeed Workshop (&1) was requested by &2",
                         pcFilename, REMOTE_ADDR) NO-ERROR.
    DYNAMIC-FUNCTION ("logNote":U IN web-utilities-hdl, "WARNING":U, cLog).
  END.
   
  /* Make sure the file is in the PROPATH.  Make sure we can find rcode. */
  RUN adecomm/_rsearch.p (INPUT pcFilename, OUTPUT cSearchFile).

  IF cSearchFile = ? THEN
    /* If there is no rcode then just make sure the file is in the propath */
    RUN webutil/_relname.p (INPUT pcFilename, "MUST-BE-REL":U, OUTPUT cSearchFile).  
  ELSE DO:
    /* If we found rcode, then make sure the Rcode is in the propath */
    /* 
       This is not necessary if we found the rcode in a .pl file, since the .pl must
       have been added to the PROPATH, otherwise we wouldn't have found it in
       _rsearch.p to begin with. WE can't call _relname.p for .pl since it will always
       fail. 
    */
    IF NOT cSearchFile MATCHES ('*<<*>>':U) THEN 
       RUN webutil/_relname.p (INPUT cSearchFile, "MUST-BE-REL":U, OUTPUT cSearchFile).
  END.

  /* If the rcode or the file was not in the propath then error */
  IF cSearchFile = ? THEN DO:
      /* If we found rcode but the file was not in the propath then reject it */
    DYNAMIC-FUNCTION ("logNote":U IN web-utilities-hdl, "WARNING",
      SUBSTITUTE ("&1 was requested by &2 but was not in the propath and was rejected. (Ref: &3)", 
                  pcFilename, REMOTE_ADDR, HTTP_REFERER)) NO-ERROR.
    DYNAMIC-FUNCTION ("ShowErrorScreen":U IN web-utilities-hdl,
      SUBSTITUTE ("Unable to find web object file '&1'", 
                  pcFilename)) NO-ERROR.  
    RETURN.
  END. /* Not found in the propath */

  /* If this is configured then perform the check, if its left blank, then 
     allow anything.  Check and see if there is a more restricted path for 
     running objects. */
  ASSIGN
    cSearchFile = SEARCH(cSearchFile).
    
  IF cfg-web-run-path > "" AND NOT CAN-DO(cfg-web-run-path,cSearchFile) THEN DO:
    DYNAMIC-FUNCTION ("logNote":U IN web-utilities-hdl, "WARNING":U,
                                SUBSTITUTE ("&1 was requested by &2 but was not in the WebRunPath and was rejected. (Ref: &3)",
                                            pcFilename, REMOTE_ADDR, HTTP_REFERER)) NO-ERROR.
    DYNAMIC-FUNCTION ("ShowErrorScreen":U IN web-utilities-hdl,
                                SUBSTITUTE ("Unable to find web object file '&1'",
                                            pcFilename )) NO-ERROR.  
    RETURN.
  END. /* not found in the WebRunPath */

  /* Verify file extension is valid, i.e. .w, .r, .p, or .  */
  ASSIGN
    cSearch = IF cSearchFile = ? THEN pcFileName
              ELSE IF cSearchFile MATCHES ('*<<*>>':U) THEN
                ENTRY(1,ENTRY(3,cSearchFile,'<':U),'>':U)
              ELSE cSearchFile.
  RUN adecomm/_osfext.p (INPUT cSearch, OUTPUT cFileExt) NO-ERROR.
    
  IF cFileExt > "" AND NOT CAN-DO(".w,.p,.r,.":U, cFileExt) THEN 
    /* if the file cannot be run directly then look for rcode by the same file name */
    cSearchFile = SEARCH(SUBSTRING(pcFilename, 1, R-INDEX(pcFilename, ".":U),"CHARACTER":U) + "r":U).

  IF cfg-compile-xcode > "" AND CAN-DO(".w,.p":U, cFileExt) THEN
    cSearchFile = SEARCH(SUBSTRING(pcFilename, 1, R-INDEX(pcFilename, ".":U),"CHARACTER":U) + "r":U).

  IF cfg-checktime AND cSearchFile > "" AND NOT CAN-DO(".r,.":U, cFileExt) THEN DO:
    ASSIGN
      FILE-INFORMATION:FILE-NAME = cSearchFile
      dFile               = FILE-INFORMATION:FILE-MOD-DATE
      tFile               = FILE-INFORMATION:FILE-MOD-TIME
      FILE-INFORMATION:FILE-NAME = SEARCH(pcFilename).
    IF   dFile < FILE-INFORMATION:FILE-MOD-DATE OR 
        (dFile = FILE-INFORMATION:FILE-MOD-DATE AND 
         tFile < FILE-INFORMATION:FILE-MOD-TIME) OR 
         tFile = ?  THEN  DO:
      DYNAMIC-FUNCTION ("logNote":U IN web-utilities-hdl, "COMPILE":U,
                        "Source Code has changed since compile.") NO-ERROR.
      OS-DELETE VALUE(cSearchFile) NO-ERROR.
      cSearchFile = ?.
    END.
  END.

  /* If rcode is not available then see if we can compile the current file. */
  IF cfg-compile-on-fly AND cSearchFile = ? AND NOT CAN-DO(".r,.":U, cFileExt) THEN DO: 
    /* If we're allowed, try to find .html or .htm and try to compile it */
    ASSIGN 
      cSearchFile = SEARCH(pcFilename).
    IF cSearchFile > "" THEN DO:

      ASSIGN cCompilerMsg =  webCompile(cSearchFile).  

      /* If the compile failed, then log the failed compile and return an error 
         to the user. */
      IF NOT cCompilerMsg BEGINS "OK" THEN DO:
        DYNAMIC-FUNCTION ("logNote":U IN web-utilities-hdl, "COMPILE":U,
                                     cCompilerMsg + " ") NO-ERROR.
        DYNAMIC-FUNCTION ("logNote":U IN web-utilities-hdl, "ERROR":U,
                                     SUBSTITUTE ("&1 cannot be run as a web object (Ref: &2)"), 
                                                 pcFileName, HTTP_REFERER) NO-ERROR.
        DYNAMIC-FUNCTION ("ShowErrorScreen":U IN web-utilities-hdl,
                                     cCompilerMsg) NO-ERROR.
        RETURN.
      END. 
      ELSE DO:
        DYNAMIC-FUNCTION ("logNote":U IN web-utilities-hdl, "COMPILE":U,
                                     SUBSTITUTE ("Compiled &1 at run time", 
                                                 cSearchFile)) NO-ERROR.
        lCompiled = TRUE.
      END. /* compilermsg eq OK */
    END. /* could not find HTML file */
  END. /* Could not find the file at all and not in development mode */

  IF cSearchfile = ? THEN DO: /* could not find html or rcode */
    DYNAMIC-FUNCTION ("logNote":U IN web-utilities-hdl, "ERROR":U,
                                SUBSTITUTE("& could not be found (Ref: &2)",
                                           pcFilename, HTTP_REFERER)) NO-ERROR.
    DYNAMIC-FUNCTION ("ShowErrorScreen":U IN web-utilities-hdl,
                                SUBSTITUTE("Unable to find web object file '&1'", 
                                           pcFilename )) NO-ERROR.
    RETURN.
  END.  /* cannot find a file to run anywhere (or not in development )*/
        
  /* Now check database connections prior to running/compiling. */
  RUN dbCheck IN web-utilities-hdl (INPUT pcFilename, OUTPUT lRetVal).
  IF lRetVal EQ FALSE THEN DO:
    DYNAMIC-FUNCTION ("logNote":U IN web-utilities-hdl, "ERROR":U,
                                SUBSTITUTE("&1 did not have the required databases connected (Ref: &2)",
                                           pcFilename, HTTP_REFERER)) NO-ERROR.
    DYNAMIC-FUNCTION ("ShowErrorScreen":U IN web-utilities-hdl,
                                SUBSTITUTE("&1 cannot be run as a web object.", 
                                           pcFilename)) NO-ERROR.
    RETURN.
  END.
  
  /* Make a note about which program we are running. */
  cLog = "Running: " + pcFilename.
  DYNAMIC-FUNCTION ("logNote":U IN web-utilities-hdl, "RUN":U, cLog) NO-ERROR.
  ASSIGN
    ERROR-STATUS:ERROR = FALSE
    COMPILER:ERROR     = FALSE.

  EXECUTE-BLOCK:   
  DO ON ERROR  UNDO EXECUTE-BLOCK, LEAVE EXECUTE-BLOCK  
     ON ENDKEY UNDO EXECUTE-BLOCK, LEAVE EXECUTE-BLOCK
     ON STOP   UNDO EXECUTE-BLOCK, LEAVE EXECUTE-BLOCK
     ON QUIT                     , LEAVE EXECUTE-BLOCK:

     /* Assumes state-aware support is turned on.  Run run-web-object in
        web/objects/stateaware.p. */
     IF glStateAware THEN
       RUN SUPER (pcFileName) NO-ERROR.
     ELSE 
       RUN VALUE(pcFilename) NO-ERROR. 
  END.

  /* Did the code run okay?  Also trap for compiler error here, since some code 
     may run a program directly without running it through run-web-object */
  lRunOk = (NOT ERROR-STATUS:ERROR AND NOT COMPILER:ERROR).  
  IF NOT lRunOk THEN DO:
    IF COMPILER:ERROR = TRUE THEN
      DYNAMIC-FUNCTION ("logNote":U IN web-utilities-hdl, "Error":U,
                                   SUBSTITUTE ("Compile error in &1 at line &2.",
                                               COMPILER:FILENAME, COMPILER:ERROR-ROW)) NO-ERROR.
    DYNAMIC-FUNCTION ("logNote":U IN web-utilities-hdl, "Error":U,
                                 SUBSTITUTE ("&1 tried to run but failed. Message: &2", pcFilename, ERROR-STATUS:GET-MESSAGE(1))) NO-ERROR.

    DYNAMIC-FUNCTION ("ShowErrorScreen":U IN web-utilities-hdl,
                                 SUBSTITUTE ("Unable to run Web object '&1'",pcFilename)) NO-ERROR.
  END. /* IF...ERROR... */
  
  ASSIGN cLog = SUBSTITUTE ("Finished: &1 : &2",pcFilename,
                            STRING(lRunOk,"OK/ERROR")).
  DYNAMIC-FUNCTION ("logNote":U IN web-utilities-hdl, "RUN":U, cLog) NO-ERROR.

   /* If the requested file was compiled on the fly, and NoSave was specified 
      for r-code, then delete the temporary .r file. */
  IF cfg-no-save-rcode AND lCompiled THEN DO:
    /** check which file to delete */
      cSearchFile = SUBSTRING(cSearchFile,1,R-INDEX(cSearchFile, ".":U), "CHARACTER":U) + "r":U.
      DYNAMIC-FUNCTION ("logNote":U IN web-utilities-hdl, "COMPILE":U,
                        "NoSave Option -> Removing:" + cSearchFile) NO-ERROR.
      OS-DELETE VALUE(cSearchFile) NO-ERROR.
  END.

   /* close default logging */
END PROCEDURE.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-set-server-connection) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE set-server-connection Procedure 
PROCEDURE set-server-connection :
/*------------------------------------------------------------------------------
  Purpose:     Used to reset server-connection variable or destroy the 
               SERVER_CONNECTION_ID cookie
  Parameters:  p_wo-hdl        - TARGET-PROCEDURE handle
               p_connection-id - SESSION:SERVER-CONNECTION-ID value or blank
  Notes:       
------------------------------------------------------------------------------*/
  DEFINE INPUT PARAMETER p_connection-id   AS CHARACTER NO-UNDO.

  server-connection = p_connection-id.

  IF useConnID = "0":U THEN DO:
    /* Delete the SERVER_CONNECTION_ID cookie */
    IF INDEX(HTTP_COOKIE,"SERVER_CONNECTION_ID=":U) > 0 THEN
      delete-cookie({&CONNECTION-NAME}, ?, ?).
    
    /* Let core know the logical session has ended */
/*    WEB-CONTEXT:SESSION-END = TRUE.
*/
  END.
  ELSE IF p_connection-id <> "" THEN DO:
    /* Create the SERVER_CONNECTION_ID cookie used to maintain context across 
       browser sessions. */
    set-cookie({&CONNECTION-NAME}, p_connection-id, ?, ?, ?, ?, ?).
    
    /* Let core know the logical session is active */
/*    WEB-CONTEXT:SESSION-END = FALSE.
*/
  END.
END PROCEDURE.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-set-transaction-state) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE set-transaction-state Procedure 
PROCEDURE set-transaction-state :
/*------------------------------------------------------------------------------
  Purpose:     Set transaction state.
  Parameters:  <none>
  Notes:       
------------------------------------------------------------------------------*/
  DEFINE INPUT PARAMETER pState AS CHARACTER NO-UNDO.
  
  IF glStateAware THEN
    /* Run set-transaction-state in web/objects/stateaware.p. */
    RUN SUPER (pState).
  ELSE
    DYNAMIC-FUNCTION ("logNote":U IN web-utilities-hdl, "Error":U,
                      "#1 StateAware support is inactive.  To activate, create a broker 'STATE_AWARE_ENABLED' environment variable with value of 'yes'.") NO-ERROR.

END PROCEDURE.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-set-web-state) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE set-web-state Procedure 
PROCEDURE set-web-state :
/*------------------------------------------------------------------------------
  Purpose:     Set web-state for the current Web object. Create appropriate 
               cookie information.
  Parameters:  p_wo-hdl:  Procedure handle of the Web object
               p_timeout: Timeout period in minutes
  Notes:       
------------------------------------------------------------------------------*/
  DEFINE INPUT PARAMETER p_wo-hdl          AS HANDLE  NO-UNDO.
  DEFINE INPUT PARAMETER p_timeout         AS DECIMAL NO-UNDO.

  IF glStateAware THEN
    /* Run set-web-state in web/objects/stateaware.p. */
    RUN SUPER (p_wo-hdl, p_timeout).
  ELSE
    DYNAMIC-FUNCTION ("logNote":U IN web-utilities-hdl, "Error":U,
                      "#2 StateAware support is inactive.  To activate, create a broker 'STATE_AWARE_ENABLED' environment variable with value of 'yes'.") NO-ERROR.
                      
END PROCEDURE.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-show-errors) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE show-errors Procedure 
PROCEDURE show-errors :
/*------------------------------------------------------------------------------
  Purpose:     
  Parameters:  <none>
  Notes:       Empty stub - no longer needed, but still referenced by admweb.i, 
               which we need
------------------------------------------------------------------------------*/

END PROCEDURE.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

/* ************************  Function Implementations ***************** */
&IF DEFINED(EXCLUDE-logWrite) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION logWrite Procedure
FUNCTION logWrite RETURNS LOGICAL PRIVATE
  () :
/*------------------------------------------------------------------------------
  Purpose:  writes log information out to disk
    Notes:  
------------------------------------------------------------------------------*/
  DEFINE VARIABLE cFile AS CHARACTER NO-UNDO.

  IF cRunLog GE "" THEN DO:
    cFile = getLogFile().    
    IF cFile > "" THEN DO:
/* 
      MESSAGE "logfile=" cFile.
 */
      OUTPUT stream logger TO VALUE(cFile) APPEND KEEP-MESSAGES.
      put stream logger unformatted cRunLog.
      OUTPUT stream logger CLOSE.
    END.
  END.
  ASSIGN cRunLog = "".
  RETURN TRUE.
  
END FUNCTION.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-getLogFile) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION getLogFile Procedure
FUNCTION getLogFile RETURNS CHARACTER PRIVATE
	(  ):
  DEFINE VARIABLE cLogName   AS CHARACTER NO-UNDO.

  ASSIGN 
    cLogName   = cLogPath + "/session.log":U.

  IF OPSYS = "win32":U THEN
    RETURN REPLACE(cLogName, "/", "~\").
  ELSE
    RETURN cLogName.   /* Function return value. */

END FUNCTION.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF


&IF DEFINED(EXCLUDE-check-agent-mode) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION check-agent-mode Procedure 
FUNCTION check-agent-mode RETURNS LOGICAL
  ( INPUT p_mode AS CHARACTER ) :
/*------------------------------------------------------------------------------
  Purpose:  
    Notes:  
------------------------------------------------------------------------------*/
  RETURN CAN-DO(cfg-environment, p_mode).

END FUNCTION.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-devCheck) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION devCheck Procedure 
FUNCTION devCheck RETURNS LOGICAL
  ( /* parameter-definitions */ ) :
/*------------------------------------------------------------------------------
  Purpose:  To check for development mode for security
    Notes:  
------------------------------------------------------------------------------*/
  RETURN TRUE.

END FUNCTION.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-get-config) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION get-config Procedure 
FUNCTION get-config RETURNS CHARACTER
  ( INPUT cVarName AS CHARACTER ) :
/*------------------------------------------------------------------------------
  Purpose:  
    Notes:  
------------------------------------------------------------------------------*/

  CASE cVarName:
    WHEN "wsroot" THEN
      RETURN "/webspeed31E".
    OTHERWISE
      MESSAGE "get-config:" PROGRAM-NAME(2) "=>" cVarName.
  END CASE.
END FUNCTION.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-getAgentSetting) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION getAgentSetting Procedure 
FUNCTION getAgentSetting RETURNS CHARACTER
  (cInKey  AS CHARACTER,
   cInSub  AS CHARACTER,
   cInName AS CHARACTER):
/*------------------------------------------------------------------------------
  Purpose:  Used to get the value of a Name/Value key out of the user-specified 
            agent setting temp-table.
   Inputs:  cInKey: key name that the name/value is specified under
            cInSub: sub-key, provides for sub-type orginization. Not required
            cInName: name of 'variable' that is being requested
  Returns:  Value or "" if not available
    Notes:  
------------------------------------------------------------------------------*/
  DEFINE VARIABLE cRetVal AS CHARACTER NO-UNDO.
   
  FIND ttAgentSetting WHERE
       ttAgentSetting.cKey  EQ cInKey AND
       ttAgentSetting.cSub  EQ cInSub AND
       ttAgentSetting.cName BEGINS cInName NO-ERROR.

  ASSIGN cRetVal = (IF AVAILABLE ttAgentSetting THEN ttAgentSetting.cVal ELSE "").

  RETURN cRetVal.

END FUNCTION.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-logNote) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION logNote Procedure 
FUNCTION logNote RETURNS LOGICAL
  ( INPUT pcLogType AS CHARACTER,
    INPUT pcLogText AS CHARACTER ) :
/*------------------------------------------------------------------------------
  Purpose:  Builds a log string for run time events into individual logs.
    Notes:  In order for everything to work right a session id must be 
            available.  In most cases this means that the messager session id 
            is turned on, the user does not have cookies blocked, and run 
            logging is turned on.
            It will save to disk only when it has reached a certain length or 
            when the web-request is done.
------------------------------------------------------------------------------*/
  IF pcLogText GT "" AND cLogPath NE "" AND CAN-DO(cLogTypes,pcLogType) THEN 
  DO:   
    ASSIGN 
      cRunLog     = cRunLog
                  + STRING(ENTRY(1,ENTRY(NUM-ENTRIES(PROGRAM-NAME(2),"/":U),PROGRAM-NAME(2),"/":U),".":U),"x(17)":U) 
                  + " ":U + (IF TRANSACTION THEN "TR ":U ELSE "   ":U)  
                  + STRING(ETIME MOD 10000000,">>>>>>9":U)
                  + " ":U + STRING((ETIME - iETIME) MOD 10000000,">>>>>>9":U)
                  + " ":U + pcLogText + "~n":U
      iETIME = ETIME.
     
    IF LENGTH(cRunLog) > 20000 OR lNoCache THEN logWrite().
  END.
END FUNCTION.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-output-content-type) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION output-content-type Procedure 
FUNCTION output-content-type RETURNS LOGICAL
  ( INPUT p_type AS CHARACTER ) :
/****************************************************************************
Function: output-content-type
Description: Sets and outputs the MIME Content-Type header followed by a
  blank line.  If the header was already output, no action is taken.
****************************************************************************/
   DEFINE VARIABLE cMimeCharset AS CHARACTER  NO-UNDO.

   IF output-content-type EQ "" THEN DO:
      ASSIGN 
        output-content-type = (IF p_type = "" THEN ? ELSE p_type).
      
      &IF KEYWORD-ALL("HTML-CHARSET") <> ? &THEN  
      /* Add MIME codepage, if available. */
      IF output-content-type BEGINS TRIM("text/html":U) 
         AND INDEX(output-content-type, "charset":U) = 0
         AND wcCharset <> "" THEN DO:
         RUN adecomm/convcp.p ( wcCharset, "toMime":U,
                                OUTPUT cMimeCharset ) NO-ERROR.
         IF cMimeCharset <> "" THEN
            output-content-type = output-content-type + "; charset=":U + 
                                  cMimeCharset.
      END.
      &ENDIF
      
      IF output-content-type NE ? THEN
         output-http-header ("Content-Type":U, output-content-type).
    
      /* This is required as a 'delimiter' for the header information */
      output-http-header ("", "").  /* blank line */

      /* If output-content-type is not ?, then a Content-Type header was output so return TRUE. */
      RETURN (output-content-type NE ?).
   END. /* output-content-type eq "" */

END FUNCTION.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-setAgentSetting) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION setAgentSetting Procedure 
FUNCTION setAgentSetting RETURNS LOGICAL
  (cInKey  AS CHARACTER,
   cInSub  AS CHARACTER,
   cInName AS CHARACTER,
   cInVal  AS CHARACTER):
/*------------------------------------------------------------------------------
  Purpose:  Used to set the value of a Name/Value key to the user-specified 
            agent setting temp-table.
   Inputs:  cInKey: key name that the name/value is specified under
            cInSub: sub-key, provides for sub-type orginization. Not required
            cInName: name of 'variable' that is being requested
            cInVal: value that the 'variable' is to be set to
  Returns:  Logical ERROR-STATUS:ERROR
    Notes:  
------------------------------------------------------------------------------*/
  DEFINE VARIABLE retVal AS LOGICAL NO-UNDO.

  SettingBLOCK:
  DO ON ERROR UNDO SettingBlock, LEAVE SettingBlock:
    FIND ttAgentSetting WHERE
      ttAgentSetting.cKey  EQ cInKey  AND
      ttAgentSetting.cSub  EQ cInSub  AND
      ttAgentSetting.cName EQ cInName EXCLUSIVE-LOCK NO-ERROR.
    IF NOT AVAILABLE ttAgentSetting THEN DO:
      CREATE ttAgentSetting.
      ASSIGN 
        ttAgentSetting.cKey  = cInKey
        ttAgentSetting.cSub  = cInSub
        ttAgentSetting.cName = cInName NO-ERROR.
    END. /* name/value not available */
   
    ASSIGN ttAgentSetting.cVal = cInVal.
    RELEASE ttAgentSetting.
    ASSIGN retVal = ERROR-STATUS:ERROR. 
  END. /* SettingBlock */

  RETURN retVal.

END FUNCTION. /* setValue */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-showErrorScreen) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION showErrorScreen Procedure 
FUNCTION showErrorScreen RETURNS LOGICAL
  ( INPUT cErrorMsg AS CHARACTER) :
/*------------------------------------------------------------------------------
  Purpose:  
    Notes:  
------------------------------------------------------------------------------*/
  DEFINE VARIABLE iCntr   AS INTEGER    NO-UNDO.
  DEFINE VARIABLE cTxt    AS CHARACTER  NO-UNDO.
  DEFINE VARIABLE lRetVal AS LOGICAL    NO-UNDO.

  /* Check to see if there are any errors. If so, output them one by one. */
  IF ERROR-STATUS:ERROR             AND 
    ERROR-STATUS:NUM-MESSAGES GT 0 THEN DO:
    ASSIGN cErrorMsg = cErrorMsg + "~n<br><H1>Error Messages</H1>~n~n".

    DO iCntr = 1 TO ERROR-STATUS:NUM-MESSAGES:
      ASSIGN cErrorMsg = cErrorMsg +
                         "<P>":U + html-encode(ERROR-STATUS:GET-MESSAGE(iCntr)) + 
                         "</P>~n":U NO-ERROR.
      DYNAMIC-FUNCTION ("LogNote":U IN web-utilities-hdl, "Note":U,
                        STRING (" " + ERROR-STATUS:GET-MESSAGE(iCntr) + "")).
    END. /* DO cntr... */
  END. /* IF...NUM-MESSAGES > 0 */
    
  /* Custom error file... this should be enhanced to handle specific errors
     such as database connectivity, redirects, run-time problems,  access denial
     and other similar things.  This would mean another input parameter would
     need to be added for error type. */
  ASSIGN FILE-INFORMATION:FILE-NAME = 
    SEARCH(getAgentSetting("Misc":U, "":U, "ErrorProc":U)) NO-ERROR.
    
  IF FILE-INFORMATION:FULL-PATHNAME NE ? THEN 
    RUN VALUE(FILE-INFORMATION:FULL-PATHNAME)(cErrorMsg) NO-ERROR.
  ELSE DO:
    DYNAMIC-FUNCTION("output-content-type" IN web-utilities-hdl,"text/html").
    {&OUT} "<BR>" cErrorMsg "<BR>".
  END.

END FUNCTION.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-trueRandom) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION trueRandom Procedure 
FUNCTION trueRandom RETURNS CHARACTER
  ( /* parameter-definitions */ ) :
/*------------------------------------------------------------------------------
  Purpose:  
    Notes:  
------------------------------------------------------------------------------*/
  RETURN STRING(RANDOM(1000,9999)) + string(time).

END FUNCTION.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ENDIF

&IF DEFINED(EXCLUDE-webCompile) = 0 &THEN

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION webCompile Procedure 
FUNCTION webCompile RETURNS CHARACTER
  ( INPUT cFile     AS CHARACTER) :
/*------------------------------------------------------------------------------
  Purpose:  Compile one file
    Notes:  
------------------------------------------------------------------------------*/
  DEFINE VARIABLE object-type AS CHARACTER  NO-UNDO.
  DEFINE VARIABLE cTempFile   AS CHARACTER  NO-UNDO.
  DEFINE VARIABLE cReturn     AS CHARACTER  NO-UNDO.
  DEFINE VARIABLE ix          AS INTEGER    NO-UNDO.
  
  IF cFile MATCHES "*.html" OR cFile MATCHES "*.htm" THEN DO:
    RUN webutil/e4gl-gen.p (SEARCH(cFile), INPUT-OUTPUT object-type, 
                            INPUT-OUTPUT cTempFile) NO-ERROR.
    IF ERROR-STATUS:ERROR THEN 
      RETURN ERROR-STATUS:GET-MESSAGE(1).
  END.
  ELSE 
    cTempFile = cFile.
  
  IF cfg-compile-xcode > "" THEN DO:
    COMPILE VALUE(cTempFile) SAVE XCODE cfg-compile-xcode NO-ERROR.
    DYNAMIC-FUNCTION ("logNote":U IN web-utilities-hdl, "COMPILE":U,
                                  "XCode Compile:" + cFile) NO-ERROR.
  END.                                
  ELSE DO: 
    DYNAMIC-FUNCTION ("logNote":U IN web-utilities-hdl, "COMPILE":U,
                                  "CompileOnFly:" + cFile) NO-ERROR.
    COMPILE VALUE(cTempFile) SAVE NO-ERROR.
  END.
  IF ERROR-STATUS:NUM-MESSAGES > 0 THEN DO:
    cReturn = "<h1>Compile Error: " + cFile + "</h1>".
    DO ix = 1 TO ERROR-STATUS:NUM-MESSAGES:
      cReturn = cReturn + "<br>" + ERROR-STATUS:GET-MESSAGE(ix).
    END.
    DYNAMIC-FUNCTION ("logNote":U IN web-utilities-hdl, "COMPILE":U,
         "ERROR:" + ERROR-STATUS:GET-MESSAGE(ix)) NO-ERROR.
  END.
  ELSE DO: 
    cReturn = "OK".
    IF cTempFile > "" AND cTempFile <> cFile THEN
      OS-DELETE VALUE(cTempFile) NO-ERROR.
  END.
  RETURN cReturn.

END FUNCTION.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME
&ENDIF














