/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.search;

import com.proalpha.git.exceptions.PaGitGrepException;
import com.proalpha.git.grep.GitCliGrep;
import com.proalpha.git.grep.GrepConfig;
import com.proalpha.git.model.grep.Result;
import com.proalpha.pds.gitutils.search.GitGrepSearchResult;
import com.proalpha.pds.gitutils.search.GitGrepSearchResultElement;
import com.proalpha.pds.gitutils.search.GitGrepSearchSettings;
import com.proalpha.pds.paconnector.Activator;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitGrepSearchQuery
implements ISearchQuery {
    private final Logger logger = LoggerFactory.getLogger(GitGrepSearchQuery.class);
    private GitGrepSearchSettings searchSettings;
    private GitGrepSearchResult searchResult = new GitGrepSearchResult(this);

    public GitGrepSearchQuery(GitGrepSearchSettings settings) {
        this.searchSettings = settings;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        try {
            monitor.beginTask("pA GitGrep Search Result", 3);
            monitor.worked(1);
            this.fillSearchResultElements();
            monitor.worked(1);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.done();
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return Status.CANCEL_STATUS;
        }
    }

    private void fillSearchResultElements() {
        GrepConfig config = new GrepConfig();
        config.setLimit(this.searchSettings.getMaxFinds());
        config.setBranch(this.searchSettings.getBranchName());
        config.setFileFilter(this.searchSettings.getFileNamePhrase());
        switch (this.searchSettings.getFileType()) {
            case "ALL": {
                config.setSearchScope(GrepConfig.SearchScope.ALL);
                break;
            }
            case "PDI": {
                config.setSearchScope(GrepConfig.SearchScope.PDI);
                break;
            }
            case "SRC": {
                config.setSearchScope(GrepConfig.SearchScope.SRC);
                break;
            }
            case "SRC_PDI": {
                config.setSearchScope(GrepConfig.SearchScope.SRC_PDI);
            }
        }
        config.setWordBoundaries(false);
        config.setIgnoreCase(!this.searchSettings.isCaseSensitive());
        GitCliGrep grep = null;
        try {
            grep = new GitCliGrep(this.searchSettings.getRepositoryPath(), this.searchSettings.getTextPhrase(), config);
            grep.setGitCLI(Activator.getDefault().getPreferenceStore().getString("PaGitExe"));
            List results = grep.getResults();
            for (Result r : results) {
                int indexOfLastPathDelimiter = r.getContext().getFile().lastIndexOf(47);
                String trimmedPath = indexOfLastPathDelimiter >= 0 ? r.getContext().getFile().substring(indexOfLastPathDelimiter + 1) : "";
                GitGrepSearchResultElement elem = new GitGrepSearchResultElement(trimmedPath, Integer.toString(r.getLineNo()), r.getHit(), r.getContext().getContext());
                int indexOfLastRepositoryDelimiter = this.searchSettings.getRepositoryPath().lastIndexOf(92);
                elem.setAbsolutePath(String.valueOf(this.searchSettings.getRepositoryPath().substring(0, indexOfLastRepositoryDelimiter > 0 ? indexOfLastRepositoryDelimiter + 1 : this.searchSettings.getRepositoryPath().length())) + r.getContext().getFile());
                this.searchResult.addMatch(new Match((Object)elem, 0, 0));
            }
        }
        catch (PaGitGrepException | IOException e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    public String getLabel() {
        return "pA GitGrep Search";
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return this.searchResult;
    }

    public String getSearchPhrase() {
        return this.searchSettings.getTextPhrase();
    }

    public String getRepository() {
        return this.searchSettings.getRepositoryPath();
    }
}

