/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.pagit.util;

import com.proalpha.pds.pagit.PaGitConfig;
import com.proalpha.pds.pagit.exceptions.PaHookException;
import com.proalpha.pds.pagit.model.jira.JiraIssue;
import com.proalpha.pds.pagit.model.jira.JiraIssueCache;
import com.proalpha.pds.pagit.util.PaBranchName;
import com.proalpha.pds.pagit.util.PaCommitMsg;
import com.proalpha.pds.pagit.util.PaIssueExplorer;
import com.proalpha.pds.pagit.util.PaRepository;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.util.io.NullOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaServerHooks {
    protected static final Logger logger = LoggerFactory.getLogger(PaServerHooks.class);

    private PaServerHooks() {
    }

    public static boolean areCommitsOnCorrectFeatureBranch(Repository r, ReceiveCommand command) throws IOException, PaHookException {
        if (!PaBranchName.isFeatureBranch(command.getRefName(), r)) {
            return true;
        }
        String featureOfBranch = PaBranchName.getIssue(command.getRefName(), r);
        for (RevCommit commit : PaIssueExplorer.getNewCommits(r, command)) {
            String featureOfCommit = PaCommitMsg.getIssueKeyFromCommitMsg(commit);
            if (featureOfCommit == null || featureOfCommit.equals(featureOfBranch)) continue;
            String msg = String.format("The commit %s must not be applied to the given branch. The issue key given in the commit message (%s) does not match the issue key in the branch name (%s), where the commit should be  applied to", commit.getName(), featureOfCommit, featureOfBranch);
            if (logger.isInfoEnabled()) {
                logger.info(msg);
            }
            throw new PaHookException(msg);
        }
        return true;
    }

    private static String[] getValidStates(String ref, Repository r) {
        List<String> states = PaBranchName.isFeatureBranch(ref, r) ? PaGitConfig.getListFromConfig("wfl.committable") : PaGitConfig.getListFromConfig("wfl.publishable");
        String[] statesAsArray = new String[states.size()];
        return states.toArray(statesAsArray);
    }

    public static boolean areIssuesOpenForAction(Repository r, ReceiveCommand command) throws IOException, PaHookException {
        JiraIssueCache issueCache = new JiraIssueCache();
        Object[] states = PaServerHooks.getValidStates(command.getRefName(), r);
        for (RevCommit commit : PaIssueExplorer.getNewCommits(r, command)) {
            String key = PaCommitMsg.getIssueKeyFromCommitMsg(commit);
            if (key == null) continue;
            JiraIssue issue = issueCache.getIssue(key);
            if (issue == null) {
                String msg = String.format("Issue %s could not be found on the JIRA server", key);
                if (logger.isInfoEnabled()) {
                    logger.info(msg);
                }
                throw new PaHookException(msg);
            }
            if (issue.isInWflState((String[])states)) continue;
            String msg = String.format("Issue %s does not allow an update of reference %s, because it is in state %s and NOT in state %s", key, command.getRefName(), issue.getStatusName(), Arrays.toString(states));
            if (logger.isInfoEnabled()) {
                logger.info(msg);
            }
            throw new PaHookException(msg);
        }
        return true;
    }

    public static boolean areIssuesForVersion(Repository r, ReceiveCommand command) throws IOException, PaHookException {
        JiraIssueCache issueCache = new JiraIssueCache();
        String version = PaBranchName.getVersion(command.getRefName(), r);
        for (RevCommit commit : PaIssueExplorer.getNewCommits(r, command)) {
            String key = PaCommitMsg.getIssueKeyFromCommitMsg(commit);
            if (key == null) continue;
            JiraIssue issue = issueCache.getIssue(key);
            if (issue == null) {
                String msg = String.format("Issue %s could not be found on the JIRA server", key);
                if (logger.isInfoEnabled()) {
                    logger.info(msg);
                }
                throw new PaHookException(msg);
            }
            if (issue.isForVersion(version)) continue;
            String msg = String.format("Issue %s must not be committed to version %s", key, version);
            if (logger.isInfoEnabled()) {
                logger.info(msg);
            }
            throw new PaHookException(msg);
        }
        return true;
    }

    public static boolean areCommitMsgsWithIssueKey(Repository r, ReceiveCommand command) throws IOException, PaHookException {
        List<RevCommit> commits = PaIssueExplorer.getNewCommits(r, command);
        for (RevCommit commit : commits) {
            if (commit.getParentCount() > 1 || PaCommitMsg.isCommitMsgWithIssueKey(commit)) continue;
            String msg = String.format("Following commit message of commit %s is invalid, because it does not start with an issue key: %s", commit.getName(), commit.getFullMessage());
            throw new PaHookException(msg);
        }
        return true;
    }

    private static boolean isDiffTextual(DiffEntry diff, RevWalk revWalk) throws IOException {
        ObjectLoader obj = revWalk.getObjectReader().open((AnyObjectId)diff.getNewId().toObjectId());
        byte[] blob = obj.getCachedBytes(100);
        int i = 0;
        while (i < Integer.min(100, blob.length)) {
            if (blob[i] == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean areFilesTextual(Repository rep, ReceiveCommand command) throws PaHookException {
        List<String> wl = PaGitConfig.getListFromConfig("files.whitelist");
        if (command.getNewId().equals((AnyObjectId)ObjectId.zeroId())) {
            return true;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (RevWalk revWalk = new RevWalk(rep);){
                List<DiffEntry> diffs = PaServerHooks.getDiffFiles(rep, command.getOldId(), command.getNewId());
                for (DiffEntry diff : diffs) {
                    if (diff.getChangeType() == DiffEntry.ChangeType.DELETE || PaServerHooks.isFileOnWhitelist(wl, diff.getNewPath()) || PaServerHooks.isDiffTextual(diff, revWalk)) continue;
                    String msg = String.format("File %s is probably binary and not listed on the whitelist", diff.getNewPath());
                    if (logger.isInfoEnabled()) {
                        logger.info(msg);
                    }
                    throw new PaHookException(msg);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            if (logger.isErrorEnabled()) {
                logger.error("A serious IO exception occured while trying to get the size of a file:", (Throwable)ex);
            }
            throw new PaHookException("An IO exception occurred: " + ex.getMessage());
        }
        return true;
    }

    public static boolean areFilesWithinSizeLimit(Repository rep, ReceiveCommand command) throws PaHookException {
        block14: {
            int limit = PaGitConfig.getIntFromConfig("files.sizeLimit");
            List<String> wl = PaGitConfig.getListFromConfig("files.whitelist");
            if (command.getNewId().equals((AnyObjectId)ObjectId.zeroId())) {
                return true;
            }
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (RevWalk revWalk = new RevWalk(rep);){
                    List<DiffEntry> diffs = PaServerHooks.getDiffFiles(rep, command.getOldId(), command.getNewId());
                    for (DiffEntry diff : diffs) {
                        long size;
                        if (diff.getChangeType() == DiffEntry.ChangeType.DELETE || PaServerHooks.isFileOnWhitelist(wl, diff.getNewPath()) || (long)limit >= (size = revWalk.getObjectReader().getObjectSize((AnyObjectId)diff.getNewId().toObjectId(), 3))) continue;
                        String msg = String.format("File %s exceeds the file size limit of %d bytes", diff.getNewPath(), limit);
                        if (logger.isInfoEnabled()) {
                            logger.info(msg);
                        }
                        throw new PaHookException(msg);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                if (!logger.isErrorEnabled()) break block14;
                logger.error("A serious IO exception occured while trying to get the size of a file (we return true, but this should be fixed):", (Throwable)ex);
            }
        }
        return true;
    }

    private static List<DiffEntry> getDiffFiles(Repository rep, ObjectId oldId, ObjectId newId) throws IOException {
        List diffs = null;
        Throwable throwable = null;
        Object var5_6 = null;
        try (RevWalk revWalk = new RevWalk(rep);){
            Object var10_14;
            Throwable throwable2;
            Object oldTree;
            RevTree newTree = !newId.equals((AnyObjectId)ObjectId.zeroId()) ? revWalk.parseCommit((AnyObjectId)newId).getTree() : null;
            if (!oldId.equals((AnyObjectId)ObjectId.zeroId())) {
                oldTree = revWalk.parseCommit((AnyObjectId)oldId).getTree();
            } else {
                throwable2 = null;
                var10_14 = null;
                try (RevWalk revWalkMerge = new RevWalk(rep);){
                    revWalkMerge.setRevFilter(RevFilter.MERGE_BASE);
                    revWalkMerge.markStart(revWalkMerge.parseCommit((AnyObjectId)newId));
                    RevCommit mergeCommit = revWalkMerge.next();
                    oldTree = mergeCommit != null ? mergeCommit.getTree() : null;
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            throwable2 = null;
            var10_14 = null;
            try (DiffFormatter formatter = new DiffFormatter((OutputStream)NullOutputStream.INSTANCE);){
                formatter.setRepository(rep);
                diffs = formatter.scan(oldTree, newTree);
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                } else if (throwable2 != throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
        return diffs;
    }

    private static boolean isFileOnWhitelist(List<String> wl, String path) {
        for (String regex : wl) {
            if (!path.matches(regex)) continue;
            return true;
        }
        return false;
    }

    public static boolean addIssueFixedVersion(Repository r, ReceiveCommand command) throws IOException {
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean areCommitsMergedFromMaster(Repository rep, ReceiveCommand command) throws IOException, PaHookException {
        if (command.getOldId().equals((AnyObjectId)ObjectId.zeroId())) {
            return true;
        }
        if (!PaBranchName.isFeatureBranch(command.getRefName(), rep)) {
            return true;
        }
        var2_2 = null;
        var3_4 = null;
        try {
            block21: {
                git = new Git(rep);
                var5_7 = null;
                var6_9 = null;
                try {
                    rWalk = new RevWalk(rep);
                    lastCommit = rWalk.parseCommit((AnyObjectId)command.getNewId());
                    rWalk.markStart(lastCommit);
                    var10_13 = rWalk.iterator();
                }
                catch (Throwable var6_10) {
                    if (var5_7 == null) {
                        var5_7 = var6_10;
                        throw var5_7;
                    }
                    if (var5_7 == var6_10) throw var5_7;
                    var5_7.addSuppressed(var6_10);
                    throw var5_7;
                }
                while (true) {
                    ** try [egrp 6[TRYBLOCK] [1 : 201->229)] { 
lbl30:
                    // 1 sources

                    if (rev.getId().equals((AnyObjectId)command.getOldId())) {
                        return true;
                    }
lbl33:
                    // 1 sources

                    finally {
                        if (rWalk != null) {
                            rWalk.close();
                        }
                    }
                    break;
                }
                finally {
                    if (var10_13.hasNext()) break block21;
                    return true;
                }
            }
            if ((branchId = PaRepository.getBranchOfCommit(rep, rev = (RevCommit)var10_13.next())) == null) ** continue;
            if (PaBranchName.isMasterBranch(branchId, rep)) {
                msg = String.format("Merge from master branch (%s) to feature branch (%s) is not allowed.", new Object[]{branchId, PaBranchName.getShortBranchName(command.getRefName(), rep)});
                if (PaServerHooks.logger.isInfoEnabled() == false) throw new PaHookException(msg);
                PaServerHooks.logger.info(msg);
                throw new PaHookException(msg);
            }
            if (rWalk == null) return true;
            rWalk.close();
            return true;
        }
        catch (Throwable var3_5) {
            if (var2_2 == null) {
                var2_2 = var3_5;
                throw var2_2;
            }
            if (var2_2 == var3_5) throw var2_2;
            var2_2.addSuppressed(var3_5);
            throw var2_2;
        }
    }
}

