/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.checks;

import com.proalpha.pds.gitutils.Activator;
import com.proalpha.pds.paconnector.PaProject;
import com.proalpha.pds.pagit.util.PaRepository;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.ui.handlers.HandlerUtil;

public class RepositoryTools {
    private Repository repository = null;

    public RepositoryTools(Repository repository) {
        this.repository = repository;
    }

    public RepositoryTools(ExecutionEvent event) {
        RepositoryTreeNode treenode = null;
        try {
            treenode = (RepositoryTreeNode)this.getSelectedNodes(event).get(0);
        }
        catch (ExecutionException e) {
            Activator.logToConsole(String.format("Error in Constructor of class RepositoryTools: %s", e.getMessage()));
        }
        if (treenode != null) {
            this.repository = treenode.getRepository();
        }
    }

    public List<?> getSelectedNodes(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).toList();
        }
        Activator.logToConsole(String.format("Event %s is no instance of IStructuredSelection. Returning empty list.", event.toString()));
        return Collections.emptyList();
    }

    public List<String> getStagedFiles() {
        Status status = null;
        ArrayList<String> stagesFiles = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Git git = new Git(this.repository);){
                status = git.status().call();
                for (String file : status.getChanged()) {
                    if (file.contains("/")) {
                        stagesFiles.add(file.substring(file.lastIndexOf(47) + 1));
                        continue;
                    }
                    stagesFiles.add(file);
                }
                for (String file : status.getAdded()) {
                    if (file.contains("/")) {
                        stagesFiles.add(file.substring(file.lastIndexOf(47) + 1));
                        continue;
                    }
                    stagesFiles.add(file);
                }
                for (String file : status.getRemoved()) {
                    if (file.contains("/")) {
                        stagesFiles.add(file.substring(file.lastIndexOf(47) + 1));
                        continue;
                    }
                    stagesFiles.add(file);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (GitAPIException | NoWorkTreeException e) {
            Activator.logToConsole(String.format("Error in Method getStagedFiles: %s", e.getMessage()));
            return Collections.emptyList();
        }
        return stagesFiles;
    }

    public List<String> getUnstagedFiles() {
        Status status = null;
        ArrayList<String> unStagesFiles = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Git git = new Git(this.repository);){
                status = git.status().call();
                for (String file : status.getUntracked()) {
                    if (file.contains("/")) {
                        unStagesFiles.add(file.substring(file.lastIndexOf(47) + 1));
                        continue;
                    }
                    unStagesFiles.add(file);
                }
                for (String file : status.getModified()) {
                    if (file.contains("/")) {
                        unStagesFiles.add(file.substring(file.lastIndexOf(47) + 1));
                        continue;
                    }
                    unStagesFiles.add(file);
                }
                for (String file : status.getConflicting()) {
                    if (file.contains("/")) {
                        unStagesFiles.add(file.substring(file.lastIndexOf(47) + 1));
                        continue;
                    }
                    unStagesFiles.add(file);
                }
                for (String file : status.getMissing()) {
                    if (file.contains("/")) {
                        unStagesFiles.add(file.substring(file.lastIndexOf(47) + 1));
                        continue;
                    }
                    unStagesFiles.add(file);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (GitAPIException | NoWorkTreeException e) {
            Activator.logToConsole(String.format("Error in Method getUnstagedFiles: %s", e.getMessage()));
            return Collections.emptyList();
        }
        return unStagesFiles;
    }

    public List<String> getChangedFilesWithPath() {
        Status status = null;
        ArrayList<String> changedFiles = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Git git = new Git(this.repository);){
                status = git.status().call();
                for (String file : status.getModified()) {
                    if (file.contains("src/")) {
                        changedFiles.add(file.substring(file.lastIndexOf("src/") + 4));
                        continue;
                    }
                    changedFiles.add(file);
                }
                for (String file : status.getConflicting()) {
                    if (file.contains("src/")) {
                        changedFiles.add(file.substring(file.lastIndexOf("src/") + 4));
                        continue;
                    }
                    changedFiles.add(file);
                }
                for (String file : status.getAdded()) {
                    if (file.contains("src/")) {
                        changedFiles.add(file.substring(file.lastIndexOf("src/") + 4));
                        continue;
                    }
                    changedFiles.add(file);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (GitAPIException | NoWorkTreeException e) {
            Activator.logToConsole(String.format("Error in Method getChangedFilesWithPath: %s", e.getMessage()));
            return Collections.emptyList();
        }
        return changedFiles;
    }

    public String getDirectory() {
        return this.repository.getDirectory().getPath();
    }

    public String getBranch() {
        try {
            return this.repository.getBranch();
        }
        catch (IOException e) {
            Activator.logToConsole(String.format("Error in Method getBranch: %s", e.getMessage()));
            return "";
        }
    }

    public PaProject getPaProject() {
        long countSeparator = this.repository.getDirectory().getAbsolutePath().codePoints().filter(ch -> ch == System.getProperty("file.separator").toCharArray()[0]).count();
        String[] filePathArray = this.repository.getDirectory().getAbsolutePath().split(Matcher.quoteReplacement(System.getProperty("file.separator")));
        IProject project = null;
        project = countSeparator > 3L ? ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(filePathArray[filePathArray.length - 4]) + "-" + filePathArray[filePathArray.length - 3]) : ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(filePathArray[filePathArray.length - 2]) + "-" + filePathArray[filePathArray.length - 1]);
        return com.proalpha.pds.paconnector.Activator.getDefault().getProjectManager().getPaProject(project);
    }

    public List<String> getBranchDiffFiles() {
        try {
            String branch = this.extendBanchName(this.getBranch());
            String master_branch = this.extendBanchName(this.getMasterBranch());
            AbstractTreeIterator oldTreeParser = RepositoryTools.prepareTreeParser(this.repository, branch);
            AbstractTreeIterator newTreeParser = RepositoryTools.prepareTreeParser(this.repository, master_branch);
            return this.getTreeDiffs(oldTreeParser, newTreeParser);
        }
        catch (IOException e) {
            Activator.logToConsole(String.format("Error in Method getBranchDiffFiles: %s", e.getMessage()));
            return Collections.emptyList();
        }
    }

    public List<String> getBranchesDiffs(String branch1, String branch2) {
        try {
            AbstractTreeIterator oldTreeParser = RepositoryTools.prepareTreeParser(this.repository, branch1);
            AbstractTreeIterator newTreeParser = RepositoryTools.prepareTreeParser(this.repository, branch2);
            return this.getTreeDiffs(oldTreeParser, newTreeParser);
        }
        catch (IOException e) {
            Activator.logToConsole(String.format("Error in Method getBranchesDiffs: %s", e.getMessage()));
            return Collections.emptyList();
        }
    }

    private List<String> getTreeDiffs(AbstractTreeIterator oldTreeParser, AbstractTreeIterator newTreeParser) {
        List diff;
        if (oldTreeParser == null || newTreeParser == null) {
            return Collections.emptyList();
        }
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (Git git = new Git(this.repository);){
                diff = git.diff().setOldTree(oldTreeParser).setNewTree(newTreeParser).call();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (GitAPIException e) {
            Activator.logToConsole(String.format("Error in Method getTreeDiffs: %s" + e.getMessage(), new Object[0]));
            return Collections.emptyList();
        }
        ArrayList<String> changedFiles = new ArrayList<String>();
        for (DiffEntry entry : diff) {
            String change_type = entry.getChangeType().toString();
            if (change_type.equals("ADD") || change_type.equals("MODIFY")) {
                changedFiles.add(Paths.get(entry.getNewPath(), new String[0]).getFileName().toString());
                continue;
            }
            changedFiles.add(Paths.get(entry.getOldPath(), new String[0]).getFileName().toString());
        }
        return changedFiles;
    }

    private static AbstractTreeIterator prepareTreeParser(Repository repository, String branch) throws IOException {
        Ref branchref = repository.exactRef(branch);
        if (branchref != null) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (RevWalk walk = new RevWalk(repository);){
                RevCommit commit = walk.parseCommit((AnyObjectId)branchref.getObjectId());
                RevTree tree = walk.parseTree((AnyObjectId)commit.getTree().getId());
                CanonicalTreeParser cronTreeParser = new CanonicalTreeParser();
                Throwable throwable2 = null;
                Object var10_13 = null;
                try (ObjectReader reader = repository.newObjectReader();){
                    cronTreeParser.reset(reader, (AnyObjectId)tree.getId());
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                walk.dispose();
                return cronTreeParser;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        Activator.logToConsole(String.format("Branch not found: %s", branch));
        return null;
    }

    private AbstractTreeIterator getTreeParserbyCommit(RevCommit commit) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (commit != null) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (RevWalk walk = new RevWalk(this.repository);){
                RevTree tree = walk.parseTree((AnyObjectId)commit.getTree().getId());
                CanonicalTreeParser cronTreeParser = new CanonicalTreeParser();
                Throwable throwable2 = null;
                Object var8_11 = null;
                try (ObjectReader reader = this.repository.newObjectReader();){
                    cronTreeParser.reset(reader, (AnyObjectId)tree.getId());
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                walk.dispose();
                return cronTreeParser;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        Activator.logToConsole("commit is null. can not init Tree parser");
        return null;
    }

    public String extendBanchName(String branch) {
        if (!branch.startsWith("refs/heads/")) {
            branch = "refs/heads/" + branch;
        }
        return branch;
    }

    private RevCommit getCurrentBranchCommit(String branchName) throws IOException {
        Ref branchref = this.repository.exactRef(branchName);
        if (branchref != null) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (RevWalk walk = new RevWalk(this.repository);){
                return walk.parseCommit((AnyObjectId)branchref.getObjectId());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return null;
    }

    public String getMasterBranch() {
        List<String> branches = PaRepository.getMasterBranches(this.repository);
        String mainBranch = null;
        if (branches != null && !branches.isEmpty()) {
            mainBranch = branches.get(0);
        } else {
            branches = PaRepository.getCodeFreezeBranches(this.repository);
            if (branches != null && !branches.isEmpty()) {
                mainBranch = branches.get(0);
            }
        }
        return mainBranch;
    }

    public Repository getRepository() {
        return this.repository;
    }
}

