/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.generate_pdos;

import com.proalpha.pds.gitutils.generate_pdos.GeneratePDOModel;
import com.proalpha.pds.gitutils.generate_pdos.GeneratePDOView;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class GeneratePDOWizard
extends Wizard {
    String repositoryPath;
    GeneratePDOView view;

    public GeneratePDOWizard(String repositoryPath) {
        this.repositoryPath = repositoryPath;
    }

    public void addPages() {
        this.view = new GeneratePDOView("Generate PDO", this.repositoryPath);
        this.addPage((IWizardPage)this.view);
    }

    public boolean performFinish() {
        final GeneratePDOModel model = this.view.getData();
        Job job = new Job("Generate PDO Job"){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
                return GeneratePDOWizard.this.pythonGeneratePDOs(subMonitor, model);
            }

            public boolean shouldSchedule() {
                return true;
            }
        };
        job.schedule();
        return true;
    }

    private String addOriginIfBranchName(String commit) {
        if (commit.contains(".") || commit.contains("-")) {
            return String.format("origin/%s", commit);
        }
        return commit;
    }

    private String getProgressExe() {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "com.openedge.pdt.core");
        String progress_exe = String.format("%s\\bin\\prowin.exe", store.getString("configPathVariables_DLC"));
        File f = new File(progress_exe);
        if (!f.exists()) {
            progress_exe = String.format("%s\\bin\\prowin32.exe", store.getString("configPathVariables_DLC"));
        }
        return progress_exe;
    }

    private IStatus pythonGeneratePDOs(SubMonitor monitor, final GeneratePDOModel model) {
        try {
            String line;
            String commit_from = this.addOriginIfBranchName(model.getCommitFrom());
            String commit_to = this.addOriginIfBranchName(model.getCommitTo());
            String command = String.format("python -m pa_internal.generate_pdos --repository_path %s --commit_from %s --commit_to %s --pdo_dir %s --progress_executable %s", model.getRepositoryPath(), commit_from, commit_to, model.getPdoDirPath(), this.getProgressExe());
            ProcessBuilder processBuilder = new ProcessBuilder(command.split("\\s+"));
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String output = "";
            while ((line = reader.readLine()) != null) {
                output = String.format("%s%s\n", output, line);
                if (monitor.isCanceled()) {
                    process.destroy();
                    return Status.CANCEL_STATUS;
                }
                if (line.contains("Checking out old PDIs")) {
                    monitor.split(1);
                    monitor.setTaskName("Checking out old PDIs");
                    continue;
                }
                if (line.contains("Checking out new PDIs")) {
                    monitor.split(1);
                    monitor.setTaskName("Checking out new PDIs");
                    continue;
                }
                if (!line.contains("Generating PDOs")) continue;
                monitor.split(1);
                monitor.setTaskName("Generating PDOs");
            }
            int exitCode = process.waitFor();
            monitor.split(1);
            if (exitCode > 0) {
                final String out = output;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ErrorDialog.openError(null, (String)"PDO Generation failed!", (String)"PDO Generation failed!", (IStatus)GeneratePDOWizard.createErrorStatus(out));
                    }
                });
                return Status.CANCEL_STATUS;
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation(null, (String)"PDO Generation succeeded!", (String)String.format("You can find your PDOs at %s/new", model.getPdoDirPath()));
                }
            });
            return Status.OK_STATUS;
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            return Status.CANCEL_STATUS;
        }
    }

    private static IStatus createErrorStatus(String exception) {
        return new Status(4, "Plugin ID", 0, "Underlying python call failed.\nCopy details for more information.", new Throwable(exception));
    }
}

