/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.pagit.util.bitbucket;

import com.proalpha.pds.pagit.PaGitConfig;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BitbucketRestCall<T> {
    private final Logger logger = LoggerFactory.getLogger(BitbucketRestCall.class);
    private final String baseUrl = PaGitConfig.getStringFromConfig("bitbucket.server");
    private final String path = PaGitConfig.getStringFromConfig("bitbucket.path");
    private final String accessToken = PaGitConfig.getStringFromConfig("bitbucket.bearer_token");
    private static final Integer PAGE_SIZE = 100;
    private T restResponse;
    private String subUrl;
    private Integer startEntry = 0;

    public T getRestResponse() {
        return this.restResponse;
    }

    public String getSubUrl() {
        return this.subUrl;
    }

    public void setSubUrl(String subUrl) {
        this.subUrl = subUrl;
    }

    public Integer getStartEntry() {
        return this.startEntry;
    }

    public void setStartEntry(Integer startEntry) {
        this.startEntry = startEntry;
    }

    public void execute() {
        URI requestUrl = this.buildUrl();
        HttpRequest request = null;
        HttpResponse<InputStream> response = null;
        request = HttpRequest.newBuilder().uri(requestUrl).headers("Authorization", "Bearer " + this.accessToken).GET().build();
        try {
            response = HttpClient.newBuilder().build().send(request, HttpResponse.BodyHandlers.ofInputStream());
            this.restResponse = this.parseRestResponse(response);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
        }
    }

    private URI buildUrl() {
        StringBuilder sb = new StringBuilder(this.baseUrl);
        sb.append(this.path);
        sb.append(this.subUrl);
        sb.append("?limit=");
        sb.append(PAGE_SIZE);
        sb.append("&start=");
        sb.append(this.startEntry);
        URI uri = null;
        try {
            uri = new URI(sb.toString());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
        }
        return uri;
    }

    protected abstract T parseRestResponse(HttpResponse<InputStream> var1) throws IOException;
}

