/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.pagit.model.jira;

import com.proalpha.pds.pagit.model.jira.JiraIssue;
import com.proalpha.pds.pagit.util.jira.JiraRestCall;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraIssueCache {
    private final Logger logger = LoggerFactory.getLogger(JiraIssueCache.class);
    private HashMap<String, JiraIssue> issues = new HashMap();

    public JiraIssue getIssue(String key) {
        if (this.issues.containsKey(key)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Issue {} found in cache.", (Object)key);
            }
            return this.issues.get(key);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Issue {} not found in cache: Going to make a new REST call", (Object)key);
        }
        JiraRestCall call = new JiraRestCall();
        JiraIssue issue = null;
        issue = call.getIssue(key);
        if (issue != null) {
            this.issues.put(key, issue);
        }
        return issue;
    }
}

