/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.pagit.commands;

import com.proalpha.pds.pagit.PaGit;
import com.proalpha.pds.pagit.exceptions.PaCherryPickException;
import com.proalpha.pds.pagit.model.PaCherryPickResult;
import com.proalpha.pds.pagit.util.PaCommitMsg;
import com.proalpha.pds.pagit.util.PaGitTransaction;
import com.proalpha.pds.pagit.util.PaRepository;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.MessageRevFilter;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaCherryPickCommand
extends GitCommand<PaCherryPickResult> {
    private final Logger logger = LoggerFactory.getLogger(PaCherryPickCommand.class);
    private static final String REFLOG_PREFIX = "pa-cherry-pick";
    private String targetIssue = "";
    private String targetRef = null;
    private boolean resetOnFailure = true;
    private boolean resetOnConflict = false;
    private List<RevCommit> commits = null;
    private PaGitTransaction trans = null;
    List<RevCommit> successfulPicks = new ArrayList<RevCommit>();
    List<RevCommit> openPicks;

    protected PaCherryPickCommand() {
        super(PaGit.getInstance().getGit().getRepository());
        this.openPicks = new ArrayList<RevCommit>();
        this.setCallable(false);
    }

    protected PaCherryPickCommand(String targetRef, List<RevCommit> commits) {
        super(PaGit.getInstance().getGit().getRepository());
        this.targetRef = targetRef;
        this.commits = commits;
        this.openPicks = new ArrayList<RevCommit>(commits);
        this.setCallable(true);
    }

    private void setCallable() {
        if (this.targetRef != null && this.commits != null) {
            this.setCallable(true);
        } else {
            this.setCallable(false);
        }
    }

    public String getTargetRef() {
        return this.targetRef;
    }

    public PaCherryPickCommand setTargetRef(String targetRef) {
        this.targetRef = targetRef;
        this.setCallable();
        return this;
    }

    public String getTargetIssue() {
        return this.targetIssue;
    }

    public void setTargetIssue(String targetIssue) {
        this.targetIssue = targetIssue;
    }

    public boolean getResetOnFailure() {
        return this.resetOnFailure;
    }

    public PaCherryPickCommand setResetOnFailure(boolean resetOnFailure) {
        this.resetOnFailure = resetOnFailure;
        return this;
    }

    public boolean getResetOnConflict() {
        return this.resetOnConflict;
    }

    public PaCherryPickCommand setResetOnConflict(boolean resetOnConflict) {
        this.resetOnConflict = resetOnConflict;
        return this;
    }

    public List<RevCommit> getCommits() {
        return this.commits;
    }

    public PaCherryPickCommand setCommits(List<RevCommit> commits) {
        this.commits = commits;
        this.openPicks = new ArrayList<RevCommit>(commits);
        this.setCallable();
        return this;
    }

    /*
     * Exception decompiling
     */
    private PaCherryPickResult cherryPick() throws IOException, GitAPIException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 12[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public PaCherryPickResult call() throws GitAPIException {
        this.checkCallable();
        try {
            this.checkRepositoryState();
            return this.cherryPick();
        }
        catch (IOException e) {
            throw new PaCherryPickException("Cherry pick failed due to a general IOException. Something went really wrong!");
        }
    }

    private void checkRepositoryState() throws GitAPIException, IOException {
        if (!PaRepository.isValidRef(this.targetRef)) {
            throw new PaCherryPickException("The target ref is no valid git reference!");
        }
        if (PaRepository.isRemoteTrackingBranch(this.targetRef)) {
            throw new PaCherryPickException("The target ref has to reference a local branc, not a remote-tracking branch!");
        }
        if (!PaGit.getInstance().getGit().getRepository().getFullBranch().equals(this.targetRef)) {
            throw new PaCherryPickException("You have to checkout the target branch before running a cherry pick.");
        }
        if (PaGit.getInstance().getGit().status().call().hasUncommittedChanges()) {
            throw new PaCherryPickException("Your working tree is dirty: Please stash or commit your changes before applying the cherry pick.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isAlreadyApplied(RevCommit sourceCommit) throws IOException {
        for (RevCommit c : this.successfulPicks) {
            if (!c.getName().equals(sourceCommit.getName())) continue;
            if (!this.logger.isDebugEnabled()) return true;
            this.logger.debug(String.format("Commit %s is already applied.", sourceCommit.getName()));
            return true;
        }
        Throwable throwable = null;
        Iterator<RevCommit> iterator = null;
        try (RevWalk revWalk = new RevWalk(PaGit.getInstance().getGit().getRepository());){
            RevFilter filter = MessageRevFilter.create((String)PaCommitMsg.getCherryPickedFromString(sourceCommit.getId().name()));
            revWalk.markStart(revWalk.parseCommit((AnyObjectId)PaGit.getInstance().getGit().getRepository().resolve(this.targetRef)));
            revWalk.setRevFilter(filter);
            RevCommit commit = (RevCommit)revWalk.iterator().next();
            if (commit == null) return false;
            String hash = PaCommitMsg.getIdFromCherryPickMsg(commit.getFullMessage());
            RevCommit origCommit = revWalk.parseCommit((AnyObjectId)PaGit.getInstance().getGit().getRepository().resolve(hash));
            this.successfulPicks.add(origCommit);
            this.openPicks.remove(origCommit);
            if (!this.logger.isDebugEnabled()) return true;
            this.logger.debug(String.format("Commit %s is already applied.", commit.getName()));
            return true;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    public void rollback() throws GitAPIException, IOException {
        if (this.trans != null) {
            this.trans.rollback();
        }
    }

    public void skipNextCommit() {
        if (!this.openPicks.isEmpty()) {
            this.successfulPicks.add(this.openPicks.remove(0));
        }
    }
}

