/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.pagit.grep;

import com.proalpha.pds.pagit.PaGitConfig;
import com.proalpha.pds.pagit.exceptions.PaGitGrepException;
import com.proalpha.pds.pagit.grep.GitGrep;
import com.proalpha.pds.pagit.grep.GrepConfig;
import com.proalpha.pds.pagit.model.grep.Result;
import com.proalpha.pds.pagit.model.grep.ResultContext;
import com.proalpha.pds.pagit.model.grep.ResultStorage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.lib.Repository;

public class GitCliGrep
extends GitGrep {
    private static final String SRC_PATH = "pa.src_path";
    private static final String PDI_PATH = "pa.pdi_path";
    private String gitCLI = "C:\\Program Files\\Git\\bin\\git.exe";
    private ParserState state = ParserState.UNKNOWN;
    private String searchTermEscaped;
    private ResultContext currentContext;
    private Boolean returnSearchLines = false;
    private List<String> resultLines = new ArrayList<String>();

    public GitCliGrep(Repository repository, String searchTerm, GrepConfig config) {
        super(repository, searchTerm, config);
        this.searchTermEscaped = this.escapeTerm(searchTerm);
    }

    public GitCliGrep(String repositoryPath, String searchTerm, GrepConfig config) throws IOException {
        super(repositoryPath, searchTerm, config);
        this.searchTermEscaped = this.escapeTerm(searchTerm);
    }

    public GitCliGrep(Repository repository, String searchTerm) {
        super(repository, searchTerm);
        this.searchTermEscaped = this.escapeTerm(searchTerm);
    }

    public GitCliGrep(String repositoryPath, String searchTerm) throws IOException {
        super(repositoryPath, searchTerm);
        this.searchTermEscaped = this.escapeTerm(searchTerm);
    }

    private String escapeTerm(String input) {
        String term = input;
        if (term != null) {
            term = term.replace("\\", "\\\\");
            term = term.replace("\t", "\\t");
            term = term.replace("\b", "\\b");
            term = term.replace("\n", "\\n");
            term = term.replace("\r", "\\r");
            term = term.replace("\f", "\\f");
            term = term.replace("'", "\\'");
        }
        return term;
    }

    @Override
    public void retrieveResults() throws IOException, PaGitGrepException {
        this.resultStorage = new ResultStorage();
        ProcessBuilder builder = new ProcessBuilder(this.getCommand());
        builder.directory(this.repository.getDirectory());
        Process process = builder.start();
        InputStream is = process.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader bir = new BufferedReader(isr);
        if (this.returnSearchLines.booleanValue()) {
            String line;
            while ((line = bir.readLine()) != null && this.resultLines.add(line)) {
            }
        } else {
            String line;
            while ((line = bir.readLine()) != null && this.parseLine(line)) {
            }
        }
        if (this.logger.isInfoEnabled()) {
            if (this.returnSearchLines.booleanValue()) {
                this.logger.info("Number of retrieved results {}", (Object)this.resultLines.size());
            } else {
                this.logger.info("Number of retrieved results {}", (Object)this.resultStorage.getResults().size());
            }
        }
    }

    public List<String> retriveResultLines() {
        this.resultLines.clear();
        try {
            try {
                this.returnSearchLines = true;
                this.retrieveResults();
            }
            catch (PaGitGrepException | IOException e) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Error while store search results {}", (Object)((Throwable)e).getMessage());
                }
                this.returnSearchLines = false;
            }
        }
        finally {
            this.returnSearchLines = false;
        }
        return this.resultLines;
    }

    private boolean parseProcedure(String line) {
        Pattern p = Pattern.compile("([\\d]+)(-|:)(.*)");
        Matcher m = p.matcher(line);
        if (!m.matches()) {
            if (this.resultStorage.getResults().size() >= this.config.getLimit()) {
                return false;
            }
            if (line.equals("")) {
                this.state = ParserState.UNKNOWN;
                return true;
            }
            if (line.equals("--")) {
                this.state = ParserState.FILE;
                this.currentContext = new ResultContext(this.currentContext.getBranch(), this.currentContext.getFile());
                return true;
            }
            this.logger.warn("Unexpected line found in state PROCEDURE while parsing output of git grep: {}", (Object)line);
        } else {
            try {
                int lineNo = Integer.parseInt(m.group(1));
                Character type = Character.valueOf(m.group(2).charAt(0));
                String content = m.group(3);
                switch (type.charValue()) {
                    case '-': {
                        this.currentContext.appendContext(content);
                        break;
                    }
                    case ':': {
                        if (this.resultStorage.getResults().size() < this.config.getLimit()) {
                            this.resultStorage.addResult(new Result(this.currentContext, content, lineNo));
                        }
                        this.currentContext.appendContext(content);
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                this.logger.error("", (Throwable)e);
            }
        }
        return true;
    }

    private void parseFile(String line) {
        Pattern p = Pattern.compile("([\\d]+)(=|:)(.*)");
        Matcher m = p.matcher(line);
        if (!m.matches()) {
            this.logger.warn("Unexpected line found in state FILE while parsing output of git grep: {}", (Object)line);
        } else {
            this.state = ParserState.PROCEDURE;
            try {
                int lineNo = Integer.parseInt(m.group(1));
                Character type = Character.valueOf(m.group(2).charAt(0));
                String content = m.group(3);
                this.currentContext.setFirstLineNo(lineNo);
                if (type.equals(Character.valueOf('='))) {
                    this.currentContext.appendContext(content);
                } else {
                    this.parseLine(line);
                }
            }
            catch (NumberFormatException e) {
                this.logger.error("", (Throwable)e);
            }
        }
    }

    private boolean parseLine(String line) {
        switch (this.state) {
            case UNKNOWN: {
                Pattern p = Pattern.compile("([\\w-/_.]+):([\\w-/_\\.]*)");
                Matcher m = p.matcher(line);
                if (!m.matches()) {
                    this.logger.warn("Unexpected line found in state UNKNOWN while parsing output of git grep: {}", (Object)line);
                    return true;
                }
                String branch = m.group(1);
                String file = m.group(2);
                this.currentContext = new ResultContext(branch, file);
                this.state = ParserState.FILE;
                break;
            }
            case FILE: {
                this.parseFile(line);
                break;
            }
            case PROCEDURE: {
                return this.parseProcedure(line);
            }
        }
        return true;
    }

    private List<String> getCommand() {
        ArrayList<String> command = new ArrayList<String>();
        command.add("\"" + this.gitCLI + "\"");
        command.add("grep");
        if (this.config.isFilenameonly()) {
            command.add("--name-only");
        } else {
            command.add("--break");
            command.add("-n");
            command.add("--heading");
        }
        if (this.config.isIgnoreCase()) {
            command.add("-i");
        }
        if (this.config.isWordBoundaries()) {
            command.add("-w");
        }
        command.addAll(Arrays.asList(this.searchTermEscaped.split(" ")));
        command.add(this.config.getBranch());
        command.add("--");
        switch (this.config.getSearchScope()) {
            case SRC: {
                if (this.config.getFileFilter() != null) {
                    command.add(String.valueOf(PaGitConfig.getStringFromConfig(SRC_PATH)) + "/" + this.config.getFileFilter());
                    break;
                }
                command.add(PaGitConfig.getStringFromConfig(SRC_PATH));
                break;
            }
            case PDI: {
                if (this.config.getFileFilter() != null) {
                    command.add(String.valueOf(PaGitConfig.getStringFromConfig(PDI_PATH)) + "/" + this.config.getFileFilter());
                    break;
                }
                command.add(PaGitConfig.getStringFromConfig(PDI_PATH));
                break;
            }
            case SRC_PDI: {
                if (this.config.getFileFilter() != null) {
                    command.add(String.valueOf(PaGitConfig.getStringFromConfig(SRC_PATH)) + "/" + this.config.getFileFilter());
                    command.add(String.valueOf(PaGitConfig.getStringFromConfig(PDI_PATH)) + "/" + this.config.getFileFilter());
                    break;
                }
                command.add(PaGitConfig.getStringFromConfig(SRC_PATH));
                command.add(PaGitConfig.getStringFromConfig(PDI_PATH));
                break;
            }
            case ALL: {
                if (this.config.getFileFilter() != null && !this.config.getFileFilter().isEmpty()) {
                    command.add(this.config.getFileFilter());
                    break;
                }
                command.add(".");
            }
        }
        this.logger.info("Calling following command: {} ", command);
        return command;
    }

    public String getGitCLI() {
        return this.gitCLI;
    }

    public void setGitCLI(String gitCLI) {
        this.gitCLI = gitCLI;
    }

    private static enum ParserState {
        UNKNOWN,
        FILE,
        PROCEDURE;

    }
}

