/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.paconnector;

import com.openedge.core.runtime.IAVMClient;
import com.openedge.core.runtime.IAVMRuntimeListener;
import com.openedge.core.runtime.IPropath;
import com.openedge.pdt.project.OEProject;
import com.proalpha.pds.paconnector.Activator;
import com.proalpha.pds.paconnector.PaPreference;
import com.proalpha.pds.paconnector.RunCommonPaProgram;
import com.proalpha.pds.paconnector.exception.ProALPHANotAvailableException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaProject {
    private static final Logger logger = LoggerFactory.getLogger(PaProject.class);
    private static final String PLUGIN_ID = Activator.getDefault().getBundle().getSymbolicName();
    private final OEProject oeProject;
    private IAVMRuntimeListener avmRuntimeListener;
    private String customLevel = "";
    private String codepage;
    private String version;
    private String wrkDir;
    private String tstDir;
    private int rayPort;
    private int MajorVersion;
    private int MinorVersion;
    private int PatchVersion;
    private int BuildVersion;
    private IPropath propath;
    private IPath bridgePath;
    private boolean available;
    private RunCommonPaProgram bridge;

    public PaProject(OEProject oeProject) {
        this.oeProject = oeProject;
        this.available = false;
        this.avmRuntimeListener = new AVMRuntimeListener();
        this.oeProject.getRuntime().addAVMRuntimeListener(this.avmRuntimeListener);
    }

    public IPropath getPropath() {
        return this.propath;
    }

    public RunCommonPaProgram getBridge() {
        return this.bridge;
    }

    public void setPropath(IPropath propath) {
        this.propath = propath;
    }

    public IPath getBridgePath() {
        return this.bridgePath;
    }

    public void setBridgePath(IPath bridgePath) {
        this.bridgePath = bridgePath;
    }

    public String getCodepage() {
        return this.codepage;
    }

    public void setCodepage(String codepage) {
        this.codepage = codepage;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
        this.SetVersionNumbers();
    }

    public String getWrkdir() {
        return this.wrkDir;
    }

    public void setWrkdir(String wrkdir) {
        this.wrkDir = wrkdir;
    }

    public String getTstDir() {
        return this.tstDir;
    }

    public void setTstDir(String tstDir) {
        this.tstDir = tstDir;
    }

    public int getRayPort() {
        return this.rayPort;
    }

    public int getMajorVersion() {
        return this.MajorVersion;
    }

    public int getMinorVersion() {
        return this.MinorVersion;
    }

    public int getPatchVersion() {
        return this.PatchVersion;
    }

    public int getBuildVersion() {
        return this.BuildVersion;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        if (!available) {
            this.bridge = null;
        }
        this.available = available;
    }

    public OEProject getOeProject() {
        return this.oeProject;
    }

    public String getCustomLevel() {
        return this.customLevel;
    }

    public void setCustomLevel(String customLevel) {
        this.customLevel = customLevel;
    }

    public void setRayPort(int rayPort) {
        this.rayPort = rayPort;
    }

    public String getName() {
        return this.getOeProject().getProject().toString();
    }

    public String toString() {
        return "proALPHA Project: " + this.getName();
    }

    public List<PaPreference> loadPaPrefs() {
        ProjectScope ctxt = new ProjectScope(this.getOeProject().getProject());
        IEclipsePreferences prefs = ctxt.getNode(PLUGIN_ID);
        ArrayList<PaPreference> paPrefs = new ArrayList<PaPreference>();
        try {
            String[] stringArray = prefs.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String pakey = stringArray[n2];
                PaPreference tmpPref = new PaPreference(pakey, prefs.get(pakey, ""));
                paPrefs.add(tmpPref);
                ++n2;
            }
            return paPrefs;
        }
        catch (BackingStoreException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new ArrayList<PaPreference>();
        }
    }

    public boolean savePaPref(String name, String value) {
        ProjectScope ctxt = new ProjectScope(this.getOeProject().getProject());
        IEclipsePreferences prefs = ctxt.getNode(PLUGIN_ID);
        if (name == null || value == null || prefs == null) {
            return false;
        }
        prefs.put(name, value);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            return false;
        }
        return true;
    }

    public void dispose() {
        if (this.avmRuntimeListener != null) {
            this.oeProject.getRuntime().removeAVMRuntimeListener(this.avmRuntimeListener);
            this.avmRuntimeListener = null;
        }
    }

    private void SetVersionNumbers() {
        if (this.version.matches("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}") || this.version.matches("\\d{1,3}\\.\\d{1,3}")) {
            this.SetVersionByV9Format();
        } else if (this.version.matches("\\d{9}")) {
            this.SetVersionByConsFormat();
        } else if (this.version.matches("\\d\\.\\d[a-zA-Z]\\d{2}.*")) {
            this.SetVersionByOldFormat();
        }
    }

    private void SetVersionByV9Format() {
        String[] arrOfStr = this.version.split("\\.");
        try {
            this.MajorVersion = Integer.parseInt(arrOfStr[0]);
            this.MinorVersion = Integer.parseInt(arrOfStr[1]);
            this.PatchVersion = arrOfStr.length > 2 ? Integer.parseInt(arrOfStr[2]) : 0;
            this.BuildVersion = this.getPatchVersion();
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
        }
    }

    private void SetVersionByConsFormat() {
        try {
            this.MajorVersion = Integer.parseInt(this.version.substring(0, 3));
            this.MinorVersion = Integer.parseInt(this.version.substring(3, 6));
            this.PatchVersion = Integer.parseInt(this.version.substring(6, 9));
            this.BuildVersion = this.getPatchVersion();
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
        }
    }

    private void SetVersionByOldFormat() {
        try {
            char[] versionChars = this.version.toLowerCase().toCharArray();
            this.MajorVersion = Integer.parseInt("" + versionChars[0]);
            this.MinorVersion = Integer.parseInt("" + versionChars[2]);
            char cPatch = versionChars[3];
            int cReference = 97;
            byte bpatch = (byte)cPatch;
            byte bReference = (byte)cReference;
            this.PatchVersion = bpatch - bReference + 1;
            String sBuild = "" + versionChars[4] + versionChars[5];
            this.BuildVersion = Integer.parseInt(sBuild);
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
        }
    }

    private class AVMRuntimeListener
    implements IAVMRuntimeListener {
        private AVMRuntimeListener() {
        }

        public void runtimeStarted(IAVMClient runtime) {
            logger.info("Runtime of project {} started", (Object)PaProject.this.getName());
            PaProject.this.setAvailable(false);
        }

        public void runtimeStopped(IAVMClient runtime) {
            logger.info("Runtime of project {} stopped", (Object)PaProject.this.getName());
            PaProject.this.setAvailable(false);
        }

        public void runtimeShutdown(IAVMClient rutime) {
            logger.info("Runtime of project {} shut down", (Object)PaProject.this.getName());
            PaProject.this.setAvailable(false);
        }

        public void runtimeInitialized(IAVMClient runtime) {
            logger.info("Runtime of project {} initialized", (Object)PaProject.this.getName());
        }

        public void runtimeAvailable(IAVMClient runtime) {
            logger.info("Runtime of project {} available", (Object)PaProject.this.getName());
            try {
                PaProject.this.bridge = new RunCommonPaProgram(PaProject.this);
            }
            catch (ProALPHANotAvailableException e) {
                e.printStackTrace();
            }
        }
    }
}

