/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.paconnector.utils;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ExceptionUtils {
    public static void showMessage(Throwable exception) {
        final Shell activeShell = Display.getDefault().getActiveShell();
        String title = "Error occurred";
        final String message = ExceptionUtils.getMessage(exception);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)activeShell, (String)"Error occurred", (String)message);
            }
        });
    }

    public static void logErrorMessage(AbstractUIPlugin plugin, Throwable exception) {
        IStatus status = ExceptionUtils.createStatus(4, plugin, exception);
        plugin.getLog().log(status);
    }

    public static void logWarnigMessage(AbstractUIPlugin plugin, Throwable exception) {
        IStatus status = ExceptionUtils.createStatus(2, plugin, exception);
        plugin.getLog().log(status);
    }

    private static IStatus createStatus(int severity, AbstractUIPlugin plugin, Throwable exception) {
        String pluginID = plugin.getBundle().getSymbolicName();
        String message = ExceptionUtils.getMessage(exception);
        return new Status(severity, pluginID, message, exception);
    }

    public static void showAndLogErrorMessage(AbstractUIPlugin plugin, Throwable exception) {
        ExceptionUtils.logErrorMessage(plugin, exception);
        ExceptionUtils.showMessage(exception);
    }

    private static String getMessage(Throwable exception) {
        return exception.getMessage() != null ? exception.getMessage() : exception.getClass().getName();
    }
}

