/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.projconf.importwizards;

import com.proalpha.pds.paconnector.Activator;
import com.proalpha.pds.projconf.importwizards.ReadDemasFile;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class ImportPageOne
extends WizardPage {
    private static final String DEMAS_CONFIG_FILE = "PDSconfig.properties";
    private static final String DEMAS_CONFIG_LABEL = "DEMAS Install Files";
    private Text singleprojectFile;
    private Map<String, String> installedProjects;
    private Map<String, String> selectedProjects;
    private List<String> eclipseAvailableprojects;

    public ImportPageOne() {
        super("First Page");
        this.setTitle("select proALPHA Installations");
        this.setDescription("Import proALPHA DEMAS installations into the PDS");
        this.selectedProjects = new HashMap<String, String>();
        this.eclipseAvailableprojects = this.getPDSProjects();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        Label projectFileInformation = new Label(container, 0);
        projectFileInformation.setText("Project Information File");
        this.singleprojectFile = new Text(container, 2052);
        this.singleprojectFile.addKeyListener((KeyListener)new CheckTextboxListener());
        Button button = new Button(container, 8);
        button.setText("...");
        this.singleprojectFile.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileopen = new FileDialog(Display.getCurrent().getActiveShell());
                String[] filterExtensions = new String[]{ImportPageOne.DEMAS_CONFIG_FILE};
                fileopen.setFilterExtensions(filterExtensions);
                String[] filterNames = new String[]{ImportPageOne.DEMAS_CONFIG_LABEL};
                fileopen.setFilterNames(filterNames);
                String targetFile = fileopen.open();
                if (targetFile != null && ImportPageOne.this.checkIniParams(targetFile)) {
                    ImportPageOne.this.singleprojectFile.setText(targetFile);
                    ImportPageOne.this.checkPageIsReady();
                }
            }
        });
        this.setControl((Control)container);
        new Label(container, 0);
        Table table = new Table(container, 546);
        GridData gridData = new GridData();
        gridData.heightHint = 254;
        gridData.horizontalAlignment = 4;
        table.setLayoutData((Object)gridData);
        table.setBackground(projectFileInformation.getBackground());
        final CheckboxTableViewer paprojecttable = new CheckboxTableViewer(table);
        paprojecttable.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                String selproject = event.getElement().toString();
                if (event.getChecked()) {
                    ImportPageOne.this.selectedProjects.put(selproject, ImportPageOne.this.installedProjects.get(selproject));
                } else {
                    ImportPageOne.this.selectedProjects.remove(selproject);
                }
                ImportPageOne.this.checkPageIsReady();
            }
        });
        String projectDirectory = Activator.getDefault().getPreferenceStore().getString("PaProjectDirectory");
        this.installedProjects = new TreeMap<String, String>(this.getInstalledProjects(projectDirectory));
        for (Map.Entry<String, String> e : this.installedProjects.entrySet()) {
            paprojecttable.add((Object)e.getKey());
        }
        new Label(container, 0);
        new Label(container, 0);
        paprojecttable.setAllChecked(true);
        Button selectAllItems = new Button(container, 32);
        selectAllItems.setText("select all items");
        selectAllItems.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button btn = (Button)event.getSource();
                boolean allItemsSelected = btn.getSelection();
                if (allItemsSelected) {
                    paprojecttable.setAllChecked(true);
                    for (Map.Entry<String, String> p : ImportPageOne.this.installedProjects.entrySet()) {
                        ImportPageOne.this.selectedProjects.put(p.getKey(), p.getValue());
                    }
                } else {
                    paprojecttable.setAllChecked(false);
                    ImportPageOne.this.selectedProjects.clear();
                }
                ImportPageOne.this.checkPageIsReady();
            }
        });
        selectAllItems.setSelection(true);
        for (Map.Entry<String, String> p : this.installedProjects.entrySet()) {
            this.selectedProjects.put(p.getKey(), p.getValue());
        }
        new Label(container, 0);
        this.checkPageIsReady();
    }

    public List<String> getProjectFiles() {
        List<String> allProjects = this.getSelectedList();
        if (!this.singleprojectFile.getText().isEmpty() || this.checkIniParams(this.singleprojectFile.getText())) {
            allProjects.add(this.singleprojectFile.getText());
        } else {
            allProjects.clear();
            allProjects.addAll(this.selectedProjects.values());
        }
        return allProjects;
    }

    private Map<String, String> getInstalledProjects(String searchDir) {
        HashMap<String, String> projects = new HashMap<String, String>();
        File dir = new File(searchDir);
        File[] filesList = dir.listFiles();
        if (filesList != null) {
            File[] fileArray = filesList;
            int n = filesList.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    String projectname;
                    List<String> envs = this.getInstalledEnvs(file.getAbsolutePath());
                    int i = 0;
                    while (i < envs.size()) {
                        String projectname2;
                        Path envdir = Paths.get(file.getAbsolutePath(), new String[0]);
                        if (new File((envdir = envdir.resolve(envs.get(i)).resolve("dev").resolve(DEMAS_CONFIG_FILE)).toString()).isFile() && this.checkIniParams(envdir.toString()) && !this.eclipseAvailableprojects.contains(projectname2 = file.getName().concat("-").concat(envs.get(i)))) {
                            projects.put(projectname2, envdir.toString());
                        }
                        ++i;
                    }
                    Path configFilePath = Paths.get(file.getAbsolutePath(), new String[0]).resolve(DEMAS_CONFIG_FILE);
                    if (new File(configFilePath.toString()).isFile() && this.checkIniParams(configFilePath.toString()) && !this.eclipseAvailableprojects.contains(projectname = file.getName())) {
                        projects.put(projectname, configFilePath.toString());
                    }
                }
                ++n2;
            }
        }
        return projects;
    }

    private List<String> getInstalledEnvs(String searchdir) {
        ArrayList<String> envs = new ArrayList<String>();
        File dir = new File(searchdir);
        File[] filesList = dir.listFiles();
        if (filesList != null) {
            File[] fileArray = filesList;
            int n = filesList.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    envs.add(file.getName());
                }
                ++n2;
            }
        }
        return envs;
    }

    private boolean checkIniParams(String filename) {
        ReadDemasFile demasini = new ReadDemasFile(filename);
        String missingProp = "";
        File file = new File(filename);
        if (!file.exists()) {
            return false;
        }
        if (!file.getName().equals(DEMAS_CONFIG_FILE)) {
            return false;
        }
        missingProp = demasini.getmissingField();
        if (!missingProp.isEmpty()) {
            this.setErrorMessage(String.format("the keyname %s is missing in Filename", missingProp));
            return false;
        }
        if (this.eclipseAvailableprojects.contains(demasini.getFullProjectName())) {
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private void checkPageIsReady() {
        boolean singleprojectFileVaild;
        boolean bl = singleprojectFileVaild = !this.singleprojectFile.getText().isEmpty() && this.checkIniParams(this.singleprojectFile.getText());
        if (this.selectedProjects.size() > 0 || singleprojectFileVaild) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    private List<String> getPDSProjects() {
        List<IProject> pdsProjects = Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects());
        ArrayList<String> projectlist = new ArrayList<String>();
        for (IProject p : pdsProjects) {
            projectlist.add(p.getName());
        }
        return projectlist;
    }

    public List<String> getSelectedList() {
        ArrayList<String> selProjects = new ArrayList<String>();
        for (String projectfile : this.selectedProjects.values()) {
            selProjects.add(projectfile);
        }
        return selProjects;
    }

    private final class CheckTextboxListener
    implements KeyListener {
        private CheckTextboxListener() {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if (!ImportPageOne.this.singleprojectFile.getText().isEmpty()) {
                ImportPageOne.this.checkPageIsReady();
            }
        }
    }
}

