/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui.wizards.wizardpages;

import com.proalpha.pds.paconnector.PaProject;
import com.proalpha.pds.paconnector.parameter.StartparameterReader;
import com.proalpha.pds.paconnector.repository.Instance;
import com.proalpha.pds.paconnector.repository.RepositoryDelegate;
import com.proalpha.pds.paconnector.repository.RepositoryInformations;
import com.proalpha.pds.ui.wizards.wizardpages.IpaWizardPage;
import com.proalpha.pds.ui.wizards.wizardpages.WizardMainPageConfiguration;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WizardMainPage
extends WizardPage
implements IpaWizardPage {
    private static final Logger logger = LoggerFactory.getLogger(WizardMainPage.class);
    private PaProject paProject;
    private RepositoryDelegate repositoryDelegate;
    private RepositoryInformations repositoryInformations;
    private StartparameterReader startparameterReader;
    private CCombo programVariant;
    private Text containerText;
    private Text fileText;
    private Text relativePathText;
    private String currConfig;
    private Map<String, WizardMainPageConfiguration> configList;
    private boolean checkRepository;
    private boolean supportRepositoryCreateButton;
    private boolean checkFileNameLength;
    private boolean checkLowerCase;
    private Combo parentClassCombo;
    private String rootClass;
    private Text shortDescriptionText;
    private Text descriptionText;
    private Button buttonCreateObject;
    private Text productText;
    private Text versionText;
    private Text authorText;
    private List<String> extensionList;
    private Text productDescriptionText;
    private Text moduleDescriptionText;
    private Text moduleText;
    private String thirdDigit;
    private HashMap<String, String> classGroupCode;
    private Boolean isFileExisting = false;
    private static final String OO_ABL = "OOABL";

    public WizardMainPage(PaProject paProject, Map<String, WizardMainPageConfiguration> configs, RepositoryDelegate repositoryDelegate, RepositoryInformations repositoryInformations, StartparameterReader startparameterReader) {
        super("WizardMainPage");
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)"com.proalpha.pds.ui"), (IPath)new Path("icons/pA-logox72.png"), Collections.emptyMap());
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)url));
        this.paProject = paProject;
        this.configList = configs;
        this.currConfig = configs.entrySet().iterator().next().getKey();
        this.repositoryDelegate = repositoryDelegate;
        this.repositoryInformations = repositoryInformations;
        this.startparameterReader = startparameterReader;
        repositoryDelegate.refreshChache();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout glContainer = new GridLayout(3, false);
        container.setLayout((Layout)glContainer);
        ValidateModifyListener modifyListener = new ValidateModifyListener();
        this.createLabel(container, "Program &Variant:", 0);
        this.programVariant = new CCombo(container, 2052);
        this.programVariant.setEditable(false);
        GridData gdProgramVariant = new GridData(4, 4, true, false, 1, 1);
        gdProgramVariant.widthHint = this.convertWidthInCharsToPixels(10);
        this.programVariant.setLayoutData((Object)gdProgramVariant);
        this.programVariant.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!WizardMainPage.this.currConfig.equals(WizardMainPage.this.programVariant.getText())) {
                    WizardMainPage.this.currConfig = WizardMainPage.this.programVariant.getText();
                    WizardMainPage.this.initialize();
                }
            }
        });
        this.createEmptyLabel(container, 0);
        this.createLabel(container, "&File name:", 0);
        this.fileText = this.createTextField(container, "Physical File Name");
        this.fileText.addModifyListener((ModifyListener)modifyListener);
        this.fileText.addFocusListener((FocusListener)new FileNameFocusAdapter());
        this.createEmptyLabel(container, 0);
        this.createLabel(container, "&Parent Class:", 0);
        this.parentClassCombo = new Combo(container, 0);
        GridData gdParentClass = new GridData(4, 4, true, false, 1, 1);
        gdParentClass.widthHint = this.convertWidthInCharsToPixels(10);
        this.parentClassCombo.setLayoutData((Object)gdParentClass);
        this.parentClassCombo.addModifyListener((ModifyListener)modifyListener);
        this.buttonCreateObject = this.createButton(container, "Create in Repository");
        this.buttonCreateObject.addSelectionListener((SelectionListener)new CreateInRepositorySelectionAdapter());
        this.createLabel(container, "&Container:", 0);
        this.containerText = this.createTextField(container, "Parent Directory");
        this.containerText.addModifyListener((ModifyListener)modifyListener);
        Button buttonBrowseForContainer = this.createButton(container, "Browse...");
        buttonBrowseForContainer.setToolTipText("Browse Directories in current Project");
        buttonBrowseForContainer.addSelectionListener((SelectionListener)new BrowseButtonSelectionAdapter());
        this.createLabel(container, "Author:", 0);
        this.authorText = this.createTextField(container, "Author");
        this.createEmptyLabel(container, 0);
        this.createLabel(container, "Version:", 0);
        this.versionText = this.createTextField(container, "Current proALPHA Version");
        this.createEmptyLabel(container, 0);
        this.createLabel(container, "Product:", 0);
        this.productText = this.createReadOnlyTextField(container, "proALPHA Product Key");
        this.productDescriptionText = this.createReadOnlyTextField(container, "proALPHA Product Description");
        this.createLabel(container, "Module:", 0);
        this.moduleText = this.createReadOnlyTextField(container, "proALPHA Sub Module Key");
        this.moduleDescriptionText = this.createReadOnlyTextField(container, "proALPHA Sub Module Description");
        this.createLabel(container, "Relative Path:", 0);
        this.relativePathText = this.createReadOnlyTextField(container, "Relative Path of File");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)this.relativePathText);
        this.createLabel(container, "Short Description:", 0);
        this.shortDescriptionText = this.createTextField(container, "Short Description");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)this.shortDescriptionText);
        this.shortDescriptionText.addModifyListener((ModifyListener)modifyListener);
        this.shortDescriptionText.setTextLimit(80);
        Label descriptionLabel = this.createLabel(container, "Description:", 0);
        GridDataFactory.fillDefaults().align(4, 128).applyTo((Control)descriptionLabel);
        this.descriptionText = this.createTextField(container, "Description", 2626);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 1).applyTo((Control)this.descriptionText);
        this.descriptionText.addModifyListener((ModifyListener)modifyListener);
        this.descriptionText.setTextLimit(800);
        this.setControl((Control)container);
        new Label(container, 0);
        new Label(container, 0);
    }

    public void setVisible(boolean visible) {
        this.programVariant.setItems(this.getConfigKeys((LinkedHashMap)this.configList));
        this.programVariant.setText(this.currConfig);
        this.initialize();
        super.setVisible(visible);
    }

    private Button createButton(Composite composite, String text) {
        Button newButton = new Button(composite, 8);
        newButton.setText(text);
        return newButton;
    }

    private Text createReadOnlyTextField(Composite composite, String tooltip) {
        return this.createTextField(composite, tooltip, 2060);
    }

    private Text createTextField(Composite composite, String tooltip) {
        return this.createTextField(composite, tooltip, 2052);
    }

    private Text createTextField(Composite composite, String tooltip, int style) {
        Text newText = new Text(composite, style);
        newText.setToolTipText(tooltip);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)newText);
        return newText;
    }

    private Label createEmptyLabel(Composite composite, int style) {
        return this.createLabel(composite, "", style);
    }

    private Label createLabel(Composite composite, String text, int style) {
        Label newLabel = new Label(composite, style);
        newLabel.setText(text);
        return newLabel;
    }

    private void initialize() {
        this.authorText.setText(System.getProperty("user.name"));
        this.versionText.setText(this.paProject.getVersion());
        WizardMainPageConfiguration configuration = this.configList.get(this.currConfig);
        this.setTitle(configuration.getWizardTitle());
        this.setDescription(configuration.getWizardDescription());
        this.checkRepository = configuration.isCheckRepository();
        this.extensionList = configuration.getExtensionList();
        this.thirdDigit = configuration.getThirdDigit();
        this.rootClass = configuration.getRootClass();
        this.extensionList = configuration.getExtensionList();
        this.checkFileNameLength = configuration.isCheckFileNameLength();
        this.checkLowerCase = configuration.isCheckLowerCase();
        this.supportRepositoryCreateButton = configuration.isSupportRepositoryCreateButton();
        IFolder workingDirectory = this.startparameterReader.getWorkingDirectory();
        this.containerText.setText(workingDirectory.getFullPath().toString());
        this.buttonCreateObject.setEnabled(false);
        if (!this.checkRepository) {
            this.parentClassCombo.setEnabled(false);
        } else {
            String subClasses = this.repositoryInformations.getListOFSubClasses(this.rootClass);
            if (subClasses != null && !subClasses.isEmpty()) {
                String[] subClassesArray = subClasses.split(",");
                this.parentClassCombo.setItems(subClassesArray);
                this.parentClassCombo.setText(this.rootClass);
                this.classGroupCode = new HashMap();
                if (this.rootClass.equals(OO_ABL)) {
                    String[] stringArray = subClassesArray;
                    int n = subClassesArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String className = stringArray[n2];
                        String objectClassCode = this.repositoryInformations.getClassGroupOf(className);
                        this.classGroupCode.put(className, objectClassCode);
                        ++n2;
                    }
                }
            }
        }
        this.setPageComplete(false);
    }

    private void validateInput() {
        try {
            if (!this.paProject.isAvailable()) {
                return;
            }
            String fileName = this.getFileName();
            this.buttonCreateObject.setEnabled(this.checkRepository && this.supportRepositoryCreateButton && !this.shortDescriptionText.getText().equals("") && this.isFileExisting == false && (this.paProject.getMajorVersion() >= 9 || !this.paProject.getCustomLevel().equals("")));
            this.parentClassCombo.setEnabled(this.checkRepository && this.parentClassCombo.getItemCount() != 1 && this.isFileExisting == false);
            this.shortDescriptionText.setEnabled(!this.checkRepository || this.isFileExisting == false);
            IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
            int dotLoc = fileName.lastIndexOf(46);
            if (dotLoc == -1) {
                this.updateStatus("File extension must be specified");
                this.buttonCreateObject.setEnabled(Boolean.FALSE.booleanValue());
                return;
            }
            String ext = fileName.substring(dotLoc + 1);
            if (!this.extensionList.contains(ext)) {
                this.updateStatus("Invalid File Extension \"" + ext + "\"");
                this.buttonCreateObject.setEnabled(Boolean.FALSE.booleanValue());
                return;
            }
            if (this.getContainerName().length() == 0) {
                this.updateStatus("File container must be specified");
                return;
            }
            if (container == null || (container.getType() & 6) == 0) {
                this.updateStatus("File container must exist");
                return;
            }
            if (!container.isAccessible()) {
                this.updateStatus("Project must be writable");
                return;
            }
            if (fileName.length() == 0) {
                this.updateStatus("File name must be specified");
                return;
            }
            if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
                this.updateStatus("File name must be valid");
                return;
            }
            if (this.checkLowerCase && !fileName.toLowerCase().equals(fileName)) {
                this.updateStatus("File name must be lower case");
                return;
            }
            String fileBody = fileName.substring(0, dotLoc);
            if (this.checkFileNameLength && fileBody.length() != 8) {
                this.updateStatus("File name must have a length of 8 digits");
                return;
            }
            if (this.thirdDigit.length() > 0 && !fileName.substring(2, 3).equals(this.thirdDigit)) {
                this.updateStatus("Thirdt Digit of File name must be \"" + this.thirdDigit + "\"");
                return;
            }
            if (!fileName.startsWith("_") && this.moduleText.getText().equals("")) {
                this.updateStatus("The file must be assigned to a module.");
                return;
            }
            if (this.shortDescriptionText.getText().length() == 0) {
                this.updateStatus("Short description must be specified");
                return;
            }
            if (fileName.endsWith(".cls")) {
                String parentClass = this.parentClassCombo.getText();
                String objectClassCode = this.classGroupCode.get(parentClass);
                int i = 0;
                while (i < 2) {
                    if (Character.isLowerCase(fileName.charAt(i))) {
                        this.updateStatus("The first three characters must be uppercase.");
                        return;
                    }
                    ++i;
                }
                if (objectClassCode == null || objectClassCode.contains("?")) {
                    objectClassCode = "";
                }
                if (!fileName.contains(String.valueOf(objectClassCode) + ".cls") && !this.parentClassCombo.getText().equals(OO_ABL)) {
                    this.updateStatus("You selected the following parent Class: " + parentClass + "Your Classname does not contain the dedicated Class Group Code: *" + objectClassCode + ".cls");
                    this.buttonCreateObject.setEnabled(false);
                    return;
                }
                if (!fileName.contains(String.valueOf(objectClassCode) + ".cls") && this.parentClassCombo.getText().equals(OO_ABL)) {
                    this.fileText.setText(fileName.replace(objectClassCode, ""));
                    return;
                }
            }
            if (this.checkRepository && this.parentClassCombo.getText().equals("") && !this.isFileExisting.booleanValue()) {
                this.updateStatus("Object should be member of Class \"" + this.rootClass + "\"");
                return;
            }
            if (this.checkRepository && !this.isFileExisting.booleanValue()) {
                this.updateStatus("File unknown to Repository Manager.");
                return;
            }
            this.updateStatus(null);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    public void setFileName(String fileName) {
        this.fileText.setText(fileName);
        this.validateFileName();
    }

    public String getAuthor() {
        return this.authorText.getText();
    }

    public String getShortDescription() {
        return this.shortDescriptionText.getText();
    }

    public String getProduct() {
        return this.productText.getText();
    }

    public String getProductDescription() {
        return this.productDescriptionText.getText();
    }

    public String getRelativePath() {
        return this.relativePathText.getText();
    }

    public String getVersion() {
        return this.versionText.getText();
    }

    public String getModule() {
        return this.moduleText.getText();
    }

    public String getModuleDescription() {
        return this.moduleDescriptionText.getText();
    }

    @Override
    public Map<String, Object> getSettings() {
        HashMap<String, Object> wizardSettings = new HashMap<String, Object>();
        wizardSettings.put("Author", this.getAuthor());
        wizardSettings.put("ContainerName", this.getContainerName());
        wizardSettings.put("Description", this.getShortDescription());
        wizardSettings.put("FileName", this.getFileName());
        wizardSettings.put("Product", this.getProduct());
        wizardSettings.put("ProductDescription", this.getProductDescription());
        wizardSettings.put("RelativePath", this.getRelativePath());
        wizardSettings.put("Module", this.getModule());
        wizardSettings.put("ModuleDescription", this.getModuleDescription());
        wizardSettings.put("Version", this.getVersion());
        wizardSettings.put("ParentObject", this.getParentClass());
        wizardSettings.put("TemplateName", this.configList.get(this.currConfig).getTemplateName());
        return wizardSettings;
    }

    private Object getParentClass() {
        return this.parentClassCombo.getText();
    }

    public void setFileDescriptionText(String description) {
        if (this.shortDescriptionText != null) {
            this.shortDescriptionText.setText(description);
        }
    }

    public boolean isCheckFileNameLength() {
        return this.checkFileNameLength;
    }

    public void setCheckFileNameLength(boolean checkFileNameLength) {
        this.checkFileNameLength = checkFileNameLength;
    }

    public boolean isCheckLowerCase() {
        return this.checkLowerCase;
    }

    public void setCheckLowerCase(boolean checkLowerCase) {
        this.checkLowerCase = checkLowerCase;
    }

    private void checkFileExisting(String fileName) {
        this.isFileExisting = this.checkRepository ? this.repositoryInformations.exitsInstanceInRepository(fileName) : Boolean.valueOf(false);
    }

    private void validateFileName() {
        if (!this.paProject.isAvailable()) {
            return;
        }
        String fileName = this.getFileName();
        this.checkFileExisting(fileName);
        if (fileName.length() > 0) {
            this.productText.setText(this.repositoryInformations.getProductName(fileName));
            this.productDescriptionText.setText(this.repositoryInformations.getProductDescription(fileName));
            this.moduleText.setText(this.repositoryInformations.getModule(fileName));
            this.moduleDescriptionText.setText(this.repositoryInformations.getModuleDescription(fileName));
            this.relativePathText.setText(this.repositoryInformations.getRelativePath(fileName));
        } else {
            this.productText.setText("");
            this.productDescriptionText.setText("");
            this.moduleText.setText("");
            this.moduleDescriptionText.setText("");
            this.relativePathText.setText("");
        }
        if (this.isFileExisting.booleanValue()) {
            this.shortDescriptionText.setText(this.repositoryInformations.getProgramShortDesc(fileName));
        }
        if (this.checkRepository) {
            String parentClass = "";
            if (this.isFileExisting.booleanValue()) {
                parentClass = this.repositoryInformations.getClassName(this.repositoryInformations.getClassOBJ(fileName));
            } else if (fileName.contains(".cls")) {
                parentClass = this.retrieveParentClass();
            }
            if (!parentClass.isEmpty()) {
                this.parentClassCombo.setText(parentClass);
            }
        }
        this.validateInput();
    }

    private String retrieveParentClass() {
        String fileName = this.getFileName();
        for (Map.Entry<String, String> entry : this.classGroupCode.entrySet()) {
            String classCode = entry.getValue();
            if (classCode == null || classCode.isEmpty() || classCode.length() != 3 || !fileName.contains(classCode = String.valueOf(classCode) + ".cls")) continue;
            return entry.getKey();
        }
        return OO_ABL;
    }

    private String[] getConfigKeys(LinkedHashMap<String, WizardMainPageConfiguration> configList) {
        return (String[])configList.keySet().stream().toArray(String[]::new);
    }

    private class BrowseButtonSelectionAdapter
    extends SelectionAdapter {
        private BrowseButtonSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent event) {
            Object[] result;
            ContainerSelectionDialog dialog = new ContainerSelectionDialog(WizardMainPage.this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select new file container");
            if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
                WizardMainPage.this.containerText.setText(((Path)result[0]).toString());
            }
        }
    }

    private class CreateInRepositorySelectionAdapter
    extends SelectionAdapter {
        private CreateInRepositorySelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent event) {
            String fileName = WizardMainPage.this.getFileName();
            String description = this.getFileDescription();
            String shortDescription = WizardMainPage.this.getShortDescription();
            String parentClass = WizardMainPage.this.parentClassCombo.getText();
            Instance instance = WizardMainPage.this.repositoryDelegate.getEmptyInstance();
            instance.setName(fileName);
            instance.setDescription(description);
            instance.setShortDescription(shortDescription);
            instance.setParentClass(parentClass);
            WizardMainPage.this.repositoryDelegate.createRepositoryEntryforInstance(instance);
            if (WizardMainPage.this.paProject.getCustomLevel().equals("") && WizardMainPage.this.paProject.getMajorVersion() >= 9) {
                String new_message = "A new object has been created in the repository. some attributes might still be missing or empty. These will be filled over the weekend with a separate issue during the reconcile.";
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Repository object created", (String)new_message);
            }
            WizardMainPage.this.checkFileExisting(WizardMainPage.this.getFileName());
            WizardMainPage.this.validateInput();
        }

        private String getFileDescription() {
            return WizardMainPage.this.descriptionText.getText();
        }
    }

    private class FileNameFocusAdapter
    extends FocusAdapter {
        private FileNameFocusAdapter() {
        }

        public void focusLost(FocusEvent event) {
            WizardMainPage.this.validateFileName();
        }
    }

    private class ValidateModifyListener
    implements ModifyListener {
        private ValidateModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (WizardMainPage.this.programVariant.isVisible()) {
                WizardMainPage.this.validateInput();
            }
        }
    }
}

