/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui.wizards.controller;

import com.proalpha.pds.generator.ContentGenerator;
import com.proalpha.pds.paconnector.Activator;
import com.proalpha.pds.paconnector.PaProject;
import com.proalpha.pds.paconnector.RunProgramInPa;
import com.proalpha.pds.paconnector.exception.ProALPHANotAvailableException;
import com.proalpha.pds.paconnector.parameter.ParameterFactory;
import com.proalpha.pds.paconnector.parameter.StartparameterReader;
import com.proalpha.pds.paconnector.repository.RepositoryDelegate;
import com.proalpha.pds.paconnector.repository.RepositoryFactory;
import com.proalpha.pds.paconnector.repository.RepositoryInformations;
import com.proalpha.pds.paconnector.utils.ExceptionUtils;
import com.proalpha.pds.templates.data.DataContainerFactory;
import com.proalpha.pds.templates.data.IGeneratorDataContainer;
import com.proalpha.pds.ui.PaProjectSelection;
import com.proalpha.pds.ui.wizards.wizardpages.InstanceListenerWizardPage;
import com.proalpha.pds.ui.wizards.wizardpages.IpaWizardPage;
import com.proalpha.pds.ui.wizards.wizardpages.WizardMainPage;
import com.proalpha.pds.ui.wizards.wizardpages.WizardMainPageConfiguration;
import com.proalpha.pds.ui.wizards.wizardpages.WizardpageFactory;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PaWizard
extends Wizard {
    private final Logger logger = LoggerFactory.getLogger(PaWizard.class);
    protected ISelection selection;
    protected WizardMainPage wizardMainPage;
    protected InstanceListenerWizardPage instanceListenerPage = null;
    private RunProgramInPa bridge;
    private LinkedHashMap<String, WizardMainPageConfiguration> configList;
    private RepositoryDelegate repositoryDelegate;
    private RepositoryInformations repositoryInformations;
    private StartparameterReader startparameterReader;
    protected Map<String, Object> wizardSettings;
    protected PaProject paProject;

    public PaWizard() {
        this.setNeedsProgressMonitor(true);
        this.paProject = Activator.getDefault().getProjectManager().getPaProjectByProjectExplorer();
        if (this.paProject == null || !this.paProject.getOeProject().getProject().isOpen() || !this.paProject.isAvailable()) {
            PaProjectSelection dialog = new PaProjectSelection(this.getShell());
            dialog.create();
            if (dialog.open() == 0) {
                this.paProject = dialog.getSelectedProject();
            }
        }
        if (this.paProject == null || !this.paProject.getOeProject().getProject().isOpen() || !this.paProject.isAvailable()) {
            this.dispose();
            return;
        }
        this.logger.debug("Running wizard for {}", (Object)this.paProject);
        try {
            RepositoryFactory repositoryFactory = new RepositoryFactory();
            this.repositoryDelegate = repositoryFactory.createRepositoryDelegate(this.paProject);
            this.repositoryInformations = repositoryFactory.createRepositoryInformations(this.paProject);
            ParameterFactory parameterFactory = new ParameterFactory();
            this.startparameterReader = parameterFactory.createStartparameterReader(this.paProject);
        }
        catch (ProALPHANotAvailableException e) {
            ExceptionUtils.showAndLogErrorMessage((AbstractUIPlugin)Activator.getDefault(), (Throwable)e);
        }
        if (!this.paProject.isAvailable()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Connect to version control failed", (String)"The version control is not available.");
            throw new IllegalStateException("Version control is not available");
        }
        this.wizardSettings = new HashMap<String, Object>();
    }

    protected boolean doFinish() {
        try {
            DataContainerFactory factory = new DataContainerFactory();
            IGeneratorDataContainer dataContainer = factory.createDataContainer(this.paProject, this.wizardSettings);
            new ContentGenerator("", dataContainer, this.wizardSettings.get("TemplateName").toString()).schedule();
        }
        catch (Exception e) {
            ExceptionUtils.showAndLogErrorMessage((AbstractUIPlugin)Activator.getDefault(), (Throwable)e);
            return false;
        }
        return true;
    }

    protected void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "com.proalpha.java.plugins.templates", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench wb, IStructuredSelection selection) {
        this.selection = selection;
    }

    public boolean performFinish() {
        this.wizardSettings = this.getWizardSettingsFromPages();
        return this.doFinish();
    }

    private Map<String, Object> getWizardSettingsFromPages() {
        HashMap<String, Object> wizardSettings = new HashMap<String, Object>();
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof IpaWizardPage) {
                Map<String, Object> pageSettings = ((IpaWizardPage)page).getSettings();
                wizardSettings.putAll(pageSettings);
            }
            ++n2;
        }
        return wizardSettings;
    }

    protected Map<String, Object> cloneWizardSettings() {
        HashMap<String, Object> exitFileGeneratorSettings = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.wizardSettings.entrySet()) {
            exitFileGeneratorSettings.put(entry.getKey(), entry.getValue());
        }
        return exitFileGeneratorSettings;
    }

    public void addPages() {
        this.wizardMainPage = WizardpageFactory.createWizardMainPage(this.paProject, this.configList, this.repositoryDelegate, this.repositoryInformations, this.startparameterReader);
        this.addPage((IWizardPage)this.wizardMainPage);
    }

    public RunProgramInPa getBridge() {
        return this.bridge;
    }

    public RepositoryDelegate getRepositoryDelegate() {
        return this.repositoryDelegate;
    }

    public RepositoryInformations getRepositoryInformations() {
        return this.repositoryInformations;
    }

    public StartparameterReader getStartparameterReader() {
        return this.startparameterReader;
    }

    public LinkedHashMap<String, WizardMainPageConfiguration> getConfigList() {
        return this.configList;
    }

    public void setConfigList(LinkedHashMap<String, WizardMainPageConfiguration> configList) {
        this.configList = configList;
    }
}

