/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui.handlers;

import com.proalpha.pds.paconnector.Activator;
import com.proalpha.pds.paconnector.PaProject;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class Copy2TstHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        PaProject paProject = Activator.getDefault().getProjectManager().getPaProjectByTextSelection();
        if (paProject != null) {
            if (paProject.isAvailable()) {
                Copy2TstHandler.copyFile(paProject);
            } else {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"pA not available", (String)"no proALPHA Project available or still starting");
            }
        } else {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"No Project", (String)"no proALPHA Project found");
        }
        return null;
    }

    private static void copyFile(PaProject paProject) {
        IFile sourceFile = Activator.getDefault().getProjectManager().getFileFromActiveSelection();
        IPath targetDir = Path.fromOSString((String)paProject.getTstDir());
        IPath relPath = Copy2TstHandler.getRelPath(sourceFile);
        IPath fullTargetPath = targetDir.append(relPath);
        IPath fullSourcePath = null;
        if (Copy2TstHandler.checkTstDirExists(paProject).booleanValue() && !relPath.toString().equals("")) {
            fullSourcePath = Path.fromOSString((String)paProject.getBridge().getAbsolutePath(sourceFile.getName()));
            if (targetDir.isPrefixOf(fullSourcePath)) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"file alredy exists", (String)String.format("The file %s already exists in directory %s", sourceFile.getName(), targetDir.toOSString()));
                return;
            }
            if (!Copy2TstHandler.getFileOsPath(sourceFile).toOSString().equalsIgnoreCase(fullSourcePath.toOSString())) {
                IPath propathEntry = fullSourcePath.removeLastSegments(relPath.segmentCount());
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"not current Source File", (String)String.format("The selected source file\n'%s'\nis not the version used for execution. The version determined and used for execution by PROPATH is located in the directory \n'%s'\nCopying is not possible.", relPath.toOSString(), propathEntry.toOSString()));
                return;
            }
            File src = new File(fullSourcePath.toOSString());
            File dest = new File(fullTargetPath.toOSString());
            File destDir = dest.getParentFile();
            if (!destDir.isDirectory() && !destDir.mkdirs()) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error creating directory", (String)String.format("Tartget directory '%s'\ndoes not exist and can't be created", destDir.toString()));
                return;
            }
            try {
                Files.copy(src.toPath(), dest.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error copy File", (String)String.format("Error while copy %s\nto\n%s.\nError = %s", src.toString(), dest.toString(), e.getMessage()));
            }
            IFile newFile = Copy2TstHandler.getNewFileLocation(sourceFile);
            if (!newFile.isAccessible()) {
                try {
                    newFile.refreshLocal(0, null);
                }
                catch (CoreException e1) {
                    return;
                }
            }
            if (Copy2TstHandler.askForOpen(sourceFile)) {
                int line = Copy2TstHandler.getFileInEditorLine();
                Copy2TstHandler.openFileInEditor(line, dest);
            }
        }
    }

    private static IPath getRelPath(IFile fileName) {
        IPath filePath = fileName.getProjectRelativePath();
        if (filePath.segmentCount() > 1) {
            return filePath.removeFirstSegments(1);
        }
        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Get relative Path", (String)"You can't copy files from the root project directory");
        return Path.fromPortableString((String)"");
    }

    private static Boolean checkTstDirExists(PaProject paProject) {
        if (paProject.getTstDir().equals("")) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"pA Param not set", (String)"The Work dir is empty");
            return false;
        }
        File myfile = new File(paProject.getTstDir());
        if (!myfile.isDirectory() && !myfile.mkdir()) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Invalid proALPHA Param Setting", (String)String.format("Workir\n'%s'\ndoes not exist and can't be created", myfile.toString()));
            return false;
        }
        return true;
    }

    private static IPath getFileOsPath(IFile sourceFile) {
        IPath fullFilePath = sourceFile.getProject().getLocation();
        return fullFilePath.append(sourceFile.getProjectRelativePath());
    }

    private static int getFileInEditorLine() {
        ISelectionProvider selectionProvider;
        ISelection selection;
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor instanceof ITextEditor && (selection = (selectionProvider = ((ITextEditor)editor).getSelectionProvider()).getSelection()) instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            int curLineNumber = textSelection.getStartLine();
            ((ITextEditor)editor).close(false);
            return curLineNumber;
        }
        return 0;
    }

    private static void openFileInEditor(int lineToJump, File fileToOpen) {
        try {
            IFileStore fileStore = EFS.getLocalFileSystem().getStore(fileToOpen.toURI());
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorPart editor = IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
            if (editor instanceof ITextEditor) {
                IDocumentProvider provider = ((ITextEditor)editor).getDocumentProvider();
                IDocument document = provider.getDocument((Object)editor.getEditorInput());
                int start = 0;
                if (lineToJump < 0) {
                    lineToJump = 0;
                }
                start = document.getLineOffset(lineToJump);
                ((ITextEditor)editor).selectAndReveal(start, 0);
            }
        }
        catch (BadLocationException | PartInitException e) {
            e.printStackTrace();
        }
    }

    private static boolean askForOpen(IFile sourceFile) {
        MessageDialog dg = new MessageDialog(Display.getCurrent().getActiveShell(), "Open copied file", null, "should the copied file be opened right away?", 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        int result = dg.open();
        return result == 0;
    }

    private static IFile getNewFileLocation(IFile sourceFile) {
        IPath relPath = sourceFile.getProjectRelativePath().removeFirstSegments(1);
        IPath targetPath = Path.fromOSString((String)"tst").append(relPath);
        IFile targetFile = sourceFile.getProject().getFile(targetPath.toOSString());
        return targetFile;
    }
}

