/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui.util;

import com.proalpha.pds.paconnector.PaVersion;
import com.proalpha.pds.ui.util.IPaVersionCheck;
import com.proalpha.pds.ui.util.IPaVersionCheckResult;

public class PaMinMaxVersionCheck
implements IPaVersionCheck {
    private PaVersion minVersion = null;
    private PaVersion maxVersion = null;
    private String versionMismatchMessage = "";

    public PaMinMaxVersionCheck(PaVersion minVersion) {
        this.minVersion = minVersion;
    }

    public PaMinMaxVersionCheck(PaVersion minVersion, PaVersion maxVersion) {
        this(minVersion);
        this.maxVersion = maxVersion;
    }

    public PaMinMaxVersionCheck(PaVersion minVersion, PaVersion maxVersion, String versionMismatchMessage) {
        this(minVersion, maxVersion);
        this.versionMismatchMessage = versionMismatchMessage;
    }

    public PaVersion getMinVersion() {
        return this.minVersion;
    }

    public void setMinVersion(PaVersion minVersion) {
        this.minVersion = minVersion;
    }

    public PaVersion getMaxVersion() {
        return this.maxVersion;
    }

    public void setMaxVersion(PaVersion maxVersion) {
        this.maxVersion = maxVersion;
    }

    public String getVersionMismatchMessage() {
        return this.versionMismatchMessage;
    }

    public void setVersionMismatchMessage(String versionMismatchMessage) {
        this.versionMismatchMessage = versionMismatchMessage;
    }

    @Override
    public IPaVersionCheckResult checkVersion(PaVersion versionToCheck) {
        if (this.minVersion != null && versionToCheck.isLowerThan(this.minVersion) || this.maxVersion != null && versionToCheck.isHigherThan(this.maxVersion)) {
            return new Result(false, this.createMessage(versionToCheck));
        }
        return new Result(true);
    }

    private String createMessage(PaVersion versionToCheck) {
        String message = this.versionMismatchMessage;
        message = message.replace("${MinVersion}", this.minVersion != null ? this.minVersion.toString() : "");
        message = message.replace("${MaxVersion}", this.maxVersion != null ? this.maxVersion.toString() : "");
        message = message.replace("${VersionToCheck}", versionToCheck.toString());
        return message;
    }

    public class Result
    implements IPaVersionCheckResult {
        private boolean validVersion = false;
        private String versionMismatchMessage = "";

        public Result(boolean validVersion) {
            this.validVersion = validVersion;
        }

        public Result(boolean validVersion, String versionMismatchMessage) {
            this(validVersion);
            this.versionMismatchMessage = versionMismatchMessage;
        }

        @Override
        public boolean isValidVersion() {
            return this.validVersion;
        }

        public void setValidVersion(boolean validVersion) {
            this.validVersion = validVersion;
        }

        @Override
        public String getVersionMismatchMessage() {
            return this.versionMismatchMessage;
        }

        public void setVersionMismatchMessage(String versionMismatchMessage) {
            this.versionMismatchMessage = versionMismatchMessage;
        }
    }
}

