/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui.handlers;

import com.proalpha.pds.paconnector.Activator;
import com.proalpha.pds.paconnector.PaProject;
import com.proalpha.pds.paconnector.exception.ProALPHANotAvailableException;
import com.proalpha.pds.paconnector.utils.ExceptionUtils;
import com.proalpha.pds.ui.AbstractProAlphaHandler;
import com.proalpha.pds.ui.wizards.controller.GenerateMissingDbTriggers;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class GenerateMissingDbTriggersForTableHandler
extends AbstractProAlphaHandler {
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            PaProject paProject = this.getPaProjectOfEvent(event);
            String tablePDIFile = this.getOeFileOfEvent(event);
            GenerateMissingDbTriggers.generateForTable(paProject, this.getTableName(tablePDIFile));
        }
        catch (ProALPHANotAvailableException | NotHandledException e) {
            ExceptionUtils.showAndLogErrorMessage((AbstractUIPlugin)Activator.getDefault(), (Throwable)e);
        }
        return null;
    }

    private String getTableName(String tablePDIFile) throws NotHandledException {
        if (!tablePDIFile.startsWith("tables_") || !tablePDIFile.endsWith(".pdi")) {
            throw new NotHandledException(String.format("File %s is not a valid name for a table PDI file", tablePDIFile));
        }
        return tablePDIFile.replace("tables_", "").replace(".pdi", "");
    }
}

