/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui.wizards.wizardpages;

import com.proalpha.pds.paconnector.PaProject;
import com.proalpha.pds.paconnector.repository.RepositoryInformations;
import com.proalpha.pds.templates.data.OOInterfaceTemplate;
import com.proalpha.pds.templates.data.OOType;
import com.proalpha.pds.ui.Activator;
import com.proalpha.pds.ui.listener.InstanceListenerType;
import com.proalpha.pds.ui.wizards.wizardpages.InstanceListenerTargetPage;
import com.proalpha.pds.ui.wizards.wizardpages.IpaWizardPage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class InstanceListenerInterfaceWizardPage
extends WizardPage
implements IpaWizardPage {
    private static final String GENERATE_SAMPLES_INIT_VALUE = "GENERATE_SAMPLES_INIT_VALUE";
    private PaProject paProject = null;
    private Set<OOInterfaceTemplate> selectedTemplates = new HashSet<OOInterfaceTemplate>();
    private Button generateSamplesButton = null;
    private boolean generateSamples = true;
    private RepositoryInformations repositoryInformations = null;
    private InstanceListenerTargetPage instanceListenerTargetPage = null;
    private Map<InstanceListenerType, Button> listenerTypeButtonMap = new HashMap<InstanceListenerType, Button>();
    private String[] targetInstances = new String[0];
    private Set<InstanceListenerType> listenerTypes = new HashSet<InstanceListenerType>();

    public InstanceListenerInterfaceWizardPage(PaProject paProject, RepositoryInformations repositoryInformations) {
        super("InstanceListenerWizardPage");
        this.repositoryInformations = repositoryInformations;
        this.paProject = paProject;
        this.setTitle("Instance Listener Options");
        this.setDescription("Select Instance Listener types to implement");
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.createUserInterfaceGroup(container);
        this.createDatabaseTriggerGroup(container);
        this.createSampleGroup(container);
        this.setControl((Control)container);
        container.computeSize(-1, 400);
        this.setControl((Control)container);
        this.initState();
    }

    private void initState() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings.get(GENERATE_SAMPLES_INIT_VALUE) != null) {
            this.generateSamples = settings.getBoolean(GENERATE_SAMPLES_INIT_VALUE);
        }
        this.generateSamplesButton.setSelection(this.generateSamples);
        for (InstanceListenerType listenerType : this.listenerTypes) {
            Button listenerTypeButton = this.listenerTypeButtonMap.get((Object)listenerType);
            if (listenerTypeButton != null) {
                listenerTypeButton.setSelection(true);
                listenerTypeButton.notifyListeners(13, new Event());
            }
            if (listenerType != InstanceListenerType.DB_TRIGGER_PROCEDURE) continue;
            this.generateSamplesButton.setSelection(true);
        }
        this.updateSampleButtonState();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.updateTargetInstances();
        }
        super.setVisible(visible);
    }

    public void addListenerType(InstanceListenerType listenerType) {
        this.listenerTypes.add(listenerType);
    }

    private void updateTargetInstances() {
        if (this.getInstanceListenerTargetPage() != null) {
            Map<String, Object> config = this.getInstanceListenerTargetPage().getSettings();
            this.targetInstances = (String[])config.get("ListenerTargetInstances");
        }
        this.enableInterfaceButtons();
    }

    private void enableInterfaceButtons() {
        if (this.targetInstances.length > 0) {
            HashSet<String> listenerTypes = new HashSet<String>(Arrays.asList(this.getSupprtedListenerTypes().split(",")));
            int supportedTypeCount = 0;
            for (Map.Entry<InstanceListenerType, Button> listenerTypeEntry : this.listenerTypeButtonMap.entrySet()) {
                InstanceListenerType listenerType = listenerTypeEntry.getKey();
                Button listenerButton = listenerTypeEntry.getValue();
                boolean isSupported = listenerTypes.contains(listenerType.getId());
                listenerButton.setEnabled(isSupported);
                if (!listenerButton.isEnabled()) {
                    listenerButton.setSelection(false);
                }
                if (!isSupported) continue;
                ++supportedTypeCount;
            }
            if (supportedTypeCount == 0) {
                this.setErrorMessage("None of the selected instances publishes listener events!");
            } else {
                this.setErrorMessage(null);
            }
        } else {
            for (Button listenerButton : this.listenerTypeButtonMap.values()) {
                listenerButton.setEnabled(true);
            }
        }
        this.updateSampleButtonState();
    }

    private String getSupprtedListenerTypes() {
        return this.repositoryInformations.getSupportedListenerTypesForPublishers(String.join((CharSequence)";", this.targetInstances));
    }

    private String[] getSelectedListenerTypes() {
        ArrayList<String> selectedListeners = new ArrayList<String>();
        for (Map.Entry<InstanceListenerType, Button> listenerTypeEntry : this.listenerTypeButtonMap.entrySet()) {
            InstanceListenerType listenerType = listenerTypeEntry.getKey();
            Button listenerButton = listenerTypeEntry.getValue();
            if (!listenerButton.getSelection()) continue;
            selectedListeners.add(listenerType.getId());
        }
        return selectedListeners.toArray(new String[selectedListeners.size()]);
    }

    private void createDatabaseTriggerGroup(Composite parent) {
        Group databaseTriggerGroup = new Group(parent, 0);
        databaseTriggerGroup.setText("Database Trigger");
        databaseTriggerGroup.setBackgroundMode(1);
        databaseTriggerGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        databaseTriggerGroup.setLayout((Layout)new RowLayout(512));
        Button databaseTriggerEventButton = this.createInterfaceButton((Composite)databaseTriggerGroup, "Database Trigger Events", new OOInterfaceTemplate(new OOType("adm.method.cls", "DMITriggerProcedureLst"), "paOOAblInterfaceImplDMITriggerProcedureLst", new String[]{"paOOAblTriggerEventSubscriptionMethodSample"}));
        this.listenerTypeButtonMap.put(InstanceListenerType.DB_TRIGGER_PROCEDURE, databaseTriggerEventButton);
    }

    private void createUserInterfaceGroup(Composite parent) {
        Group userInterfaceGroup = new Group(parent, 0);
        userInterfaceGroup.setText("User Interface");
        userInterfaceGroup.setBackgroundMode(1);
        userInterfaceGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        userInterfaceGroup.setLayout((Layout)new RowLayout(512));
        Button windowEventButton = this.createInterfaceButton((Composite)userInterfaceGroup, "Window Events", new OOInterfaceTemplate(new OOType("adm.method.cls", "DMIWindowEventLst"), "paOOAblInterfaceImplDMIWindowEventLst", new String[]{"paOOAblWindowEventSubscriptionMethodSample"}));
        this.listenerTypeButtonMap.put(InstanceListenerType.WINDOW, windowEventButton);
        Button widgetEventButton = this.createInterfaceButton((Composite)userInterfaceGroup, "Widget Events", new OOInterfaceTemplate(new OOType("adm.method.cls", "DMIWidgetEventLst"), "paOOAblInterfaceImplDMIWidgetEventLst", new String[]{"paOOAblWidgetEventSubscriptionMethodSample"}));
        this.listenerTypeButtonMap.put(InstanceListenerType.WIDGETS, widgetEventButton);
        Button uiProcedureEventsButton = this.createInterfaceButton((Composite)userInterfaceGroup, "UI Procedure Events", new OOInterfaceTemplate(new OOType("adm.method.cls", "DMIUIProcedureEventLst"), "paOOAblInterfaceImplDMIUIProcedureEventLst", new String[]{"paOOAblUIProcedureEventSubscriptionMethodSample"}));
        this.listenerTypeButtonMap.put(InstanceListenerType.UI_PROCEDURE, uiProcedureEventsButton);
        Button browseEventButton = this.createInterfaceButton((Composite)userInterfaceGroup, "Browse Events", new OOInterfaceTemplate(new OOType("adm.method.cls", "DMIBrowseEventLst"), "paOOAblInterfaceImplDMIBrowseEventLst", new String[]{"paOOAblBrowseEventSubscriptionMethodSample"}));
        this.listenerTypeButtonMap.put(InstanceListenerType.BROWSE, browseEventButton);
        Button printOrFilterDialogEventButton = this.createInterfaceButton((Composite)userInterfaceGroup, "Print or Filter Dialog Events", new OOInterfaceTemplate(new OOType("adm.method.cls", "DMIPrintOrFilterDialogEventLst"), "paOOAblInterfaceImplDMIPrintOrFilterDialogEventLst", new String[]{"paOOAblDMIPrintOrFilterDialogEventSubscriptionMethodSample"}));
        this.listenerTypeButtonMap.put(InstanceListenerType.PRINT_OR_FILTER_DIALOG, printOrFilterDialogEventButton);
    }

    private void createSampleGroup(Composite parent) {
        Group sampleGroup = new Group(parent, 0);
        sampleGroup.setText("Examples");
        sampleGroup.setBackgroundMode(1);
        sampleGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        sampleGroup.setLayout((Layout)new RowLayout(512));
        this.generateSamplesButton = new Button((Composite)sampleGroup, 32);
        this.generateSamplesButton.setText("Generate Examples");
        this.generateSamplesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstanceListenerInterfaceWizardPage.this.generateSamples = InstanceListenerInterfaceWizardPage.this.generateSamplesButton.getSelection();
                IDialogSettings settings = InstanceListenerInterfaceWizardPage.this.getDialogSettings();
                settings.put(InstanceListenerInterfaceWizardPage.GENERATE_SAMPLES_INIT_VALUE, InstanceListenerInterfaceWizardPage.this.generateSamples);
            }
        });
    }

    private Button createInterfaceButton(Composite parent, String labelText, final OOInterfaceTemplate sampleTemplate) {
        final Button button = new Button(parent, 32);
        button.setText(labelText);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (button.getSelection()) {
                    InstanceListenerInterfaceWizardPage.this.selectedTemplates.add(sampleTemplate);
                } else {
                    InstanceListenerInterfaceWizardPage.this.selectedTemplates.remove(sampleTemplate);
                }
                InstanceListenerInterfaceWizardPage.this.updateSampleButtonState();
            }
        });
        String relativeName = sampleTemplate.getOoType().getRelativeName().concat(".cls");
        IPath ooTypePath = this.paProject.getOeProject().getPropath().search(relativeName, false);
        button.setEnabled(ooTypePath != null);
        return button;
    }

    private void updateSampleButtonState() {
        this.generateSamplesButton.setEnabled(this.selectedTemplates.size() > 0);
    }

    @Override
    public Map<String, Object> getSettings() {
        HashMap<String, Object> wizardSettings = new HashMap<String, Object>();
        TreeSet<String> selectedInterfaces = new TreeSet<String>();
        TreeSet<String> selectedUsingStatements = new TreeSet<String>();
        ArrayList<String> selectedTemplatesNames = new ArrayList<String>();
        for (OOInterfaceTemplate ooTypeSampleTemplate : this.selectedTemplates) {
            selectedInterfaces.add(ooTypeSampleTemplate.getOoType().getTypeName());
            selectedUsingStatements.add(String.valueOf(ooTypeSampleTemplate.getOoType().getPackageName()) + ".*");
            selectedTemplatesNames.add(ooTypeSampleTemplate.getImplementationTemplateName());
        }
        if (this.generateSamples) {
            for (OOInterfaceTemplate ooTypeSampleTemplate : this.selectedTemplates) {
                selectedTemplatesNames.addAll(ooTypeSampleTemplate.getAdditionalTemplateNames());
            }
        }
        wizardSettings.put("UsingStatements", selectedUsingStatements);
        wizardSettings.put("ImplementedInterfaces", selectedInterfaces);
        wizardSettings.put("MethodSnippetTemplates", selectedTemplatesNames);
        wizardSettings.put("ListenerTypes", this.getSelectedListenerTypes());
        return wizardSettings;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings dialogSettings = Activator.getDefault().getDialogSettings();
        return DialogSettings.getOrCreateSection((IDialogSettings)dialogSettings, (String)this.getName());
    }

    public InstanceListenerTargetPage getInstanceListenerTargetPage() {
        return this.instanceListenerTargetPage;
    }

    public void setInstanceListenerTargetPage(InstanceListenerTargetPage instanceListenerTargetPage) {
        this.instanceListenerTargetPage = instanceListenerTargetPage;
    }
}

