/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui.wizards.controller;

import com.openedge.pdt.project.IOpenEdgeProject;
import com.proalpha.pds.generator.GeneratorFactory;
import com.proalpha.pds.generator.OOABLExitFileGenerator;
import com.proalpha.pds.paconnector.parameter.CustomLevel;
import com.proalpha.pds.paconnector.repository.RepositoryDelegate;
import com.proalpha.pds.templates.data.DataContainerFactory;
import com.proalpha.pds.templates.data.IGeneratorDataContainer;
import com.proalpha.pds.ui.handlers.CreateInstanceListenerHandler;
import com.proalpha.pds.ui.listener.InstanceListenerTools;
import com.proalpha.pds.ui.listener.InstanceListenerType;
import com.proalpha.pds.ui.wizards.controller.OOABLObject;
import com.proalpha.pds.ui.wizards.controller.PaWizard;
import com.proalpha.pds.ui.wizards.wizardpages.InstanceListenerInterfaceWizardPage;
import com.proalpha.pds.ui.wizards.wizardpages.InstanceListenerTargetPage;
import com.proalpha.pds.ui.wizards.wizardpages.WizardMainPageConfiguration;
import com.proalpha.pds.ui.wizards.wizardpages.WizardpageFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceListenerWizard
extends PaWizard
implements INewWizard {
    private static final Logger logger = LoggerFactory.getLogger(OOABLObject.class);
    private static final String OOABL_LISTENER = "Listener";
    private static final String CLASS_SUFFIX = ".cls";
    private static final String CUSTOM_CLASS_SUFFIX_PATTERN;
    private boolean canRegisterInstanceListener = false;
    private CustomLevel currentCustomLevel = null;
    private IFile selectedFile = null;
    private InstanceListenerTargetPage targetWizardPage = null;
    private InstanceListenerInterfaceWizardPage interfaceWizardPage = null;
    private IWizardPage startingPage = null;

    static {
        StringBuilder customLevelStringListBuilder = new StringBuilder();
        customLevelStringListBuilder.append("(?:");
        CustomLevel[] customLevelArray = CustomLevel.values();
        int n = customLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            CustomLevel customLevel = customLevelArray[n2];
            if (customLevelStringListBuilder.length() > 0) {
                customLevelStringListBuilder.append("|");
            }
            customLevelStringListBuilder.append(customLevel.getClassSuffix());
            ++n2;
        }
        customLevelStringListBuilder.append(")?\\.cls");
        CUSTOM_CLASS_SUFFIX_PATTERN = customLevelStringListBuilder.toString();
    }

    public InstanceListenerWizard() {
        try {
            LinkedHashMap<String, WizardMainPageConfiguration> configList = new LinkedHashMap<String, WizardMainPageConfiguration>();
            ArrayList<String> extensionList = new ArrayList<String>();
            extensionList.add("cls");
            WizardMainPageConfiguration configuration = new WizardMainPageConfiguration();
            configuration.setWizardTitle("Proalpha Instance Listener File");
            configuration.setWizardDescription("This wizard creates a new Proalpha Instance Listener File.");
            configuration.setTemplateName("pAOOABLClass");
            configuration.setExtensionList(extensionList);
            configuration.setRootClass(OOABL_LISTENER);
            configuration.setThirdDigit("C");
            configuration.setCheckRepository(true);
            configuration.setSupportRepositoryCreateButton(true);
            configuration.setCheckFileNameLength(false);
            configuration.setCheckLowerCase(false);
            configList.put(OOABL_LISTENER, configuration);
            this.setConfigList(configList);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Unable to initialize Template", (String)e.getMessage());
        }
    }

    @Override
    public void addPages() {
        this.canRegisterInstanceListener = InstanceListenerTools.canRegisterInstanceListener((IOpenEdgeProject)this.paProject.getOeProject());
        if (this.canRegisterInstanceListener) {
            this.targetWizardPage = WizardpageFactory.createInstanceListenerTargetPage(this.getRepositoryInformations());
            this.addPage((IWizardPage)this.targetWizardPage);
            if (this.selectedFile != null) {
                this.targetWizardPage.addFile(this.selectedFile);
            }
        }
        this.interfaceWizardPage = WizardpageFactory.createInstanceListenerInterfaceWizardPage(this.paProject, this.getRepositoryInformations());
        this.interfaceWizardPage.setInstanceListenerTargetPage(this.targetWizardPage);
        this.addPage((IWizardPage)this.interfaceWizardPage);
        TriggerInfo triggerInfo = this.getTriggerInfoFromTriggerInstanceOrNull(this.selectedFile);
        if (triggerInfo != null) {
            this.interfaceWizardPage.addListenerType(InstanceListenerType.DB_TRIGGER_PROCEDURE);
        }
        super.addPages();
        this.startingPage = triggerInfo != null ? this.wizardMainPage : (this.selectedFile != null || this.targetWizardPage == null ? this.interfaceWizardPage : this.targetWizardPage);
    }

    private IFile getFileFromSelectionOrNull() {
        if (!(this.selection instanceof CreateInstanceListenerHandler.InstanceListenerHandlerSelection)) {
            return null;
        }
        Object element = ((CreateInstanceListenerHandler.InstanceListenerHandlerSelection)this.selection).getFirstElement();
        if (!(element instanceof IFile)) {
            return null;
        }
        return (IFile)element;
    }

    private TriggerInfo getTriggerInfoFromTriggerInstanceOrNull(IFile file) {
        if (file == null) {
            return null;
        }
        return this.getTriggerInfoFromTriggerInstanceOrNull(file.getName());
    }

    private TriggerInfo getTriggerInfoFromTriggerInstanceOrNull(String instanceId) {
        String tableName = InstanceListenerTools.getTableNameFromTriggerInstanceOrNull(this.getRepositoryInformations(), instanceId);
        if (tableName != null) {
            TriggerInfo triggerInfo = new TriggerInfo();
            triggerInfo.tableName = tableName;
            triggerInfo.triggerFunction = InstanceListenerTools.getTriggerFunctionFromTriggerInstance(instanceId);
            return triggerInfo;
        }
        return null;
    }

    private TriggerInfo getTriggerInfoFromFirstTriggerInstanceOrNull(String[] instances) {
        if (instances == null) {
            return null;
        }
        String[] stringArray = instances;
        int n = instances.length;
        int n2 = 0;
        while (n2 < n) {
            String instanceId = stringArray[n2];
            TriggerInfo triggerInfo = this.getTriggerInfoFromTriggerInstanceOrNull(instanceId);
            if (triggerInfo != null) {
                return triggerInfo;
            }
            ++n2;
        }
        return null;
    }

    private String getTriggerListenerNameFromTriggerInfo(String triggerName, TriggerInfo triggerInfo) {
        CustomLevel customLevel = this.getCurrentCustomLevel();
        String modulePrefix = customLevel != CustomLevel.STANDARD ? String.valueOf(customLevel.getIdentChar()) + triggerName.substring(0, 1).toUpperCase() : triggerName.substring(0, 2).toUpperCase();
        return String.valueOf(modulePrefix) + "C" + "_" + triggerInfo.tableName + "_" + triggerInfo.triggerFunction + "Lst.cls";
    }

    private String getTriggerListenerShortDescriptionFromTriggerInfo(TriggerInfo triggerInfo) {
        return "Trigger Listener for " + triggerInfo.triggerFunction + " of " + triggerInfo.tableName;
    }

    @Override
    public void init(IWorkbench wb, IStructuredSelection selection) {
        super.init(wb, selection);
        this.selectedFile = this.getFileFromSelectionOrNull();
        TriggerInfo triggerInfo = this.getTriggerInfoFromTriggerInstanceOrNull(this.selectedFile);
        if (triggerInfo != null) {
            WizardMainPageConfiguration configuration = this.getConfigList().get(OOABL_LISTENER);
            configuration.setFilename(this.getTriggerListenerNameFromTriggerInfo(this.selectedFile.getName(), triggerInfo));
            configuration.setShortDescritpion(this.getTriggerListenerShortDescriptionFromTriggerInfo(triggerInfo));
        }
    }

    public CustomLevel getCurrentCustomLevel() {
        if (this.currentCustomLevel == null) {
            this.currentCustomLevel = CustomLevel.getByValue((String)this.getStartparameterReader().getCurrentCustomLevel());
        }
        return this.currentCustomLevel;
    }

    public IWizardPage getStartingPage() {
        return this.startingPage;
    }

    public boolean canFinish() {
        IWizardPage page = this.getStartingPage();
        while (page != null) {
            if (!page.isPageComplete()) {
                return false;
            }
            page = this.getNextPage(page);
        }
        return true;
    }

    @Override
    protected boolean doFinish() {
        TriggerInfo triggerInfo;
        CharSequence[] targetInstanceArray = (String[])this.wizardSettings.get("ListenerTargetInstances");
        if (targetInstanceArray == null && this.selectedFile != null) {
            targetInstanceArray = new String[]{this.selectedFile.getName()};
            this.wizardSettings.put("ListenerTargetInstances", targetInstanceArray);
        }
        if ((triggerInfo = this.getTriggerInfoFromFirstTriggerInstanceOrNull((String[])targetInstanceArray)) != null) {
            this.wizardSettings.put("TableName", triggerInfo.tableName);
            this.wizardSettings.put("TriggerFunction", triggerInfo.triggerFunction);
        }
        try {
            this.generatorMainClassAndStdClass();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        if (!super.doFinish()) {
            return false;
        }
        if (this.canRegisterInstanceListener && targetInstanceArray.length > 0) {
            String listenerId = (String)this.wizardSettings.get("FileName");
            String targetInstances = String.join((CharSequence)";", targetInstanceArray);
            String listenerTypes = String.join((CharSequence)";", (String[])this.wizardSettings.get("ListenerTypes"));
            RepositoryDelegate repositoryDelegate = this.getRepositoryDelegate();
            repositoryDelegate.registerInstanceListener(listenerId, targetInstances, listenerTypes);
        }
        return true;
    }

    private void generatorMainClassAndStdClass() throws Exception {
        String targetSuffix;
        String fileName = (String)this.wizardSettings.get("FileName");
        if (!fileName.endsWith(targetSuffix = String.valueOf(this.getCurrentCustomLevel().getClassSuffix()) + CLASS_SUFFIX)) {
            fileName = fileName.replaceAll(CUSTOM_CLASS_SUFFIX_PATTERN, targetSuffix);
        }
        this.wizardSettings.put("CustomLevel", this.getCurrentCustomLevel().getValue());
        this.wizardSettings.put("CustomFileName", fileName);
        this.wizardSettings.put("StandardFileName", fileName);
        DataContainerFactory factory = new DataContainerFactory();
        IGeneratorDataContainer datacontainer = factory.createDataContainer(this.paProject, this.cloneWizardSettings());
        GeneratorFactory generatorFactory = new GeneratorFactory();
        String stdTemplate = this.wizardSettings.get("TemplateName").toString();
        if (!stdTemplate.endsWith("Form")) {
            stdTemplate = stdTemplate.replace("pAOOABL", "pAOOABLStd");
        }
        OOABLExitFileGenerator oOABLClass = generatorFactory.createOOABLExitFileGenerator(datacontainer, stdTemplate);
        oOABLClass.generate();
    }

    private class TriggerInfo {
        public String tableName = "";
        public String triggerFunction = "";

        private TriggerInfo() {
        }
    }
}

