/*
 * Decompiled with CFR 0.152.
 */
package com.progress.tools.reportbug.store;

import com.progress.tools.installinfo.IProduct;
import com.progress.tools.installinfo.util.ProductInfoUtil;
import com.progress.tools.reportbug.model.CustomerType;
import com.progress.tools.reportbug.model.PhoneType;
import com.progress.tools.reportbug.store.ProductImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class ProductRegistrationStore {
    private static final String PREFERENCE_REGION_NAME = "Region";
    private static final String PREFERENCE_PHONE_NUMBER = "PhoneNumber";
    private static final String PREFERENCE_PHONE_EXTN = "PhoneExtension";
    private static final String PREFERENCE_EMAIL_NAME = "Email";
    private static final String PREFERENCE_CUSTOMER_NAME = "customerName";
    private static final String PREFERENCE_COMPANY_NAME = "companyName";
    private static final String PREFERENCE_SERIAL_NUMBER_PREFIX = "serialNumber";
    private static final String EMPTY_STRING = "";
    private IPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new ConfigurationScope(), "com.progress.tools.reportbug.core");
    static ProductRegistrationStore registrationStore = null;

    private ProductRegistrationStore() {
    }

    public static ProductRegistrationStore getInstance() {
        if (registrationStore == null) {
            registrationStore = new ProductRegistrationStore();
        }
        return registrationStore;
    }

    public void storeCustomerInfo(CustomerType info) {
        this.store.setValue(PREFERENCE_COMPANY_NAME, info.getCompany());
        this.store.setValue(PREFERENCE_CUSTOMER_NAME, info.getName());
        this.store.setValue(PREFERENCE_EMAIL_NAME, info.getEmail());
        if (info.getPhone() != null) {
            if (info.getPhone().getValue() != null) {
                this.store.setValue(PREFERENCE_PHONE_NUMBER, info.getPhone().getValue());
            }
            if (info.getPhone().getExtension() != null) {
                this.store.setValue(PREFERENCE_PHONE_EXTN, info.getPhone().getExtension());
            }
        }
        this.store.setValue(PREFERENCE_REGION_NAME, info.getRegion());
        this.save();
    }

    private void save() {
        try {
            ((ScopedPreferenceStore)this.store).save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CustomerType getCustomerInfo() {
        CustomerType customerInfo = new CustomerType();
        customerInfo.setCompany(this.store.getString(PREFERENCE_COMPANY_NAME));
        customerInfo.setName(this.store.getString(PREFERENCE_CUSTOMER_NAME));
        customerInfo.setEmail(this.store.getString(PREFERENCE_EMAIL_NAME));
        String phoneNumber = this.store.getString(PREFERENCE_PHONE_NUMBER);
        if (phoneNumber != null && !phoneNumber.equals(EMPTY_STRING)) {
            PhoneType phone = new PhoneType();
            phone.setValue(phoneNumber);
            String extn = this.store.getString(PREFERENCE_PHONE_EXTN);
            if (extn != null && !extn.equals(EMPTY_STRING)) {
                phone.setExtension(extn);
            }
            customerInfo.setPhone(phone);
        }
        customerInfo.setRegion(this.store.getString(PREFERENCE_REGION_NAME));
        return customerInfo;
    }

    public void storeProductInfo(List<ProductImpl> products) {
        for (ProductImpl productImpl : products) {
            this.store.setValue(PREFERENCE_SERIAL_NUMBER_PREFIX + productImpl.getName(), this.getSerialNumber(productImpl));
        }
        this.save();
    }

    private String getSerialNumber(ProductImpl productImpl) {
        return productImpl.getSerialNumber() == null ? EMPTY_STRING : productImpl.getSerialNumber();
    }

    public List<ProductImpl> getProductInfo() {
        IProduct[] products = ProductInfoUtil.getInstance().getProducts();
        ArrayList<ProductImpl> productsList = new ArrayList<ProductImpl>(products.length);
        IProduct[] iProductArray = products;
        int n = products.length;
        int n2 = 0;
        while (n2 < n) {
            IProduct product = iProductArray[n2];
            ProductImpl productImpl = new ProductImpl(product);
            String serialNumber = this.store.getString(PREFERENCE_SERIAL_NUMBER_PREFIX + product.getName());
            if (serialNumber != null && !serialNumber.equals(EMPTY_STRING)) {
                productImpl.setSerialNumber(serialNumber);
            }
            productsList.add(productImpl);
            ++n2;
        }
        return productsList;
    }

    public ProductImpl getProduct(String productName) {
        List<ProductImpl> products = this.getProductInfo();
        for (ProductImpl product : products) {
            if (!product.getName().equals(productName)) continue;
            return product;
        }
        return null;
    }
}

