/*
 * Decompiled with CFR 0.152.
 */
package com.progress.tools.reportbug.ui.actions;

import com.progress.tools.reportbug.IPrelauchCallback;
import com.progress.tools.reportbug.model.BugData;
import com.progress.tools.reportbug.ui.ReportBugDialog;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ProjectReportBugHandler
extends AbstractHandler
implements ISelectionListener,
ISelectionChangedListener {
    private IProject project = null;
    protected ISelection selection;
    protected IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    private boolean enabled = true;

    public boolean isEnabled() {
        return this.enabled;
    }

    protected void setEnabled(boolean isEnabled) {
        if (this.enabled != isEnabled) {
            this.enabled = isEnabled;
            this.fireHandlerChanged(new HandlerEvent((IHandler)this, true, false));
        }
    }

    public ProjectReportBugHandler() {
        this.activeWorkbenchWindow.getSelectionService().addPostSelectionListener((ISelectionListener)this);
        this.selection = this.activeWorkbenchWindow.getSelectionService().getSelection();
        this.selectionChanged();
    }

    public void selectionChanged() {
        boolean enable = false;
        if (this.selection instanceof IStructuredSelection) {
            Object selected = ((IStructuredSelection)this.selection).getFirstElement();
            if (selected instanceof IProject) {
                this.project = (IProject)selected;
                enable = true;
            }
            this.setEnabled(enable);
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.project != null) {
            map.put("PROJECT_SELECTED", this.project);
        }
        this.openDialog(new BugData(), map);
        return null;
    }

    protected void openDialog(BugData data, Map<String, Object> env) {
        this.invokePrelaunchContributors(data, env);
        this.openReportBugDialog(data);
    }

    private void openReportBugDialog(BugData data) {
        ReportBugDialog dialog = new ReportBugDialog(data);
        dialog.setBlockOnOpen(true);
        dialog.open();
    }

    private void invokePrelaunchContributors(BugData data, Map<String, Object> env) {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("com.progress.tools.reportbug.prelaunch");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            try {
                IPrelauchCallback prelaunch = (IPrelauchCallback)iConfigurationElement.createExecutableExtension("class");
                prelaunch.prelaunch(data, env);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part instanceof ISelectionProvider) {
            ((ISelectionProvider)part).addSelectionChangedListener((ISelectionChangedListener)this);
        } else {
            part.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.selection = selection;
        this.selectionChanged();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selection = event.getSelection();
        this.selectionChanged();
    }
}

