/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.core.service.web;

import com.atlassian.connector.eclipse.internal.jira.core.model.JiraIssue;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraClient;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraRedirectException;
import java.io.IOException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.commons.net.WebUtil;

public abstract class JiraWebSessionCallback {
    private HostConfiguration hostConfiguration;
    private HttpClient httpClient;
    private String baseUrl;
    private boolean followRedirects;

    public void configure(HttpClient httpClient, HostConfiguration hostConfiguration, String baseUrl, boolean followRedirects) {
        this.httpClient = httpClient;
        this.hostConfiguration = hostConfiguration;
        this.baseUrl = baseUrl;
        this.followRedirects = followRedirects;
    }

    public int execute(HttpMethod method) throws JiraException {
        return this.execute(method, Policy.monitorFor(null));
    }

    public int execute(HttpMethod method, IProgressMonitor monitor) throws JiraException {
        try {
            return WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)method, (IProgressMonitor)monitor);
        }
        catch (IOException e) {
            throw new JiraException(e);
        }
    }

    public abstract void run(JiraClient var1, String var2, IProgressMonitor var3) throws JiraException, IOException;

    protected boolean expectRedirect(HttpMethodBase method, JiraIssue issue) throws JiraException {
        return this.expectRedirect(method, "/browse/" + issue.getKey());
    }

    protected boolean expectRedirect(HttpMethodBase method, String page) throws JiraException {
        return this.expectRedirect(method, page, true);
    }

    protected boolean expectRedirect(HttpMethodBase method, String page, boolean fullMatch) throws JiraException {
        if (method.getStatusCode() != 302) {
            return false;
        }
        Header locationHeader = method.getResponseHeader("location");
        if (locationHeader == null) {
            throw new JiraRedirectException();
        }
        String url = locationHeader.getValue();
        if (fullMatch ? this.followRedirects && !url.startsWith(String.valueOf(this.baseUrl) + page) || !this.followRedirects && !url.endsWith(page) : !url.contains(page)) {
            throw new JiraRedirectException(url);
        }
        return true;
    }

    public String toString() {
        return "WEB[" + this.hostConfiguration.toString() + " baseUrl=" + this.baseUrl + " followRedirects=" + this.followRedirects + "]";
    }
}

