/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.java.oea.plugins.querygenerator.handlers;

import com.openedge.core.runtime.IAVMClient;
import com.openedge.core.runtime.IAVMRuntimeListener;
import com.openedge.pdt.project.OEProjectPlugin;
import com.openedge.pdt.project.RuntimePVM;
import com.openedge.pdt.project.sharedavm.SharedAVM;
import com.proalpha.java.oea.plugins.querygenerator.EditorTools;
import com.proalpha.java.oea.plugins.querygenerator.handlers.EditorInsertCommandHandler;
import com.proalpha.java.oea.plugins.querygenerator.handlers.LoadPluginSettingHandler;
import com.proalpha.java.oea.plugins.querygenerator.handlers.SavePluginSettingHandler;
import com.proalpha.java.oea.plugins.querygenerator.runtime.HandlerTools;
import com.proalpha.java.oea.plugins.querygenerator.runtime.QueryGeneratorPrograms;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Display;

public class QueryGeneratorHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Display.getDefault().syncExec((Runnable)new QueryGeneratorCommand(event.getParameters()));
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    private void startQueryGenerator(IAVMClient runtime, String commandParameter) {
        if (runtime != null && runtime.isAvailable()) {
            HandlerTools.getInstance().runProgram(runtime, QueryGeneratorPrograms.START_QUERY_GENERATOR, commandParameter, true);
        }
    }

    private class QueryGeneratorCommand
    implements Runnable {
        private Map<String, String> parameters = null;

        public QueryGeneratorCommand(Map<String, String> parameters) {
            this.parameters = parameters;
        }

        @Override
        public void run() {
            String commandParameter = String.format("EditorInsertRequestId=%s%sSavePluginSettingId=%s%sLoadPluginSettingId=%s", EditorInsertCommandHandler.getRequestId(), Character.valueOf(HandlerTools.PARAM_SPLITTER), SavePluginSettingHandler.getRequestId(), Character.valueOf(HandlerTools.PARAM_SPLITTER), LoadPluginSettingHandler.getRequestId());
            IAVMClient runtime = null;
            String menuItemType = this.parameters.get("com.proalpha.java.oea.plugins.querygenerator.avmTypeParameter");
            if (menuItemType == null || menuItemType.isEmpty() || menuItemType.equals("DefaultAVM")) {
                runtime = HandlerTools.getInstance().getRuntime();
            } else if (menuItemType.equals("ProjectAVM")) {
                OEProjectPlugin projectPlugin = OEProjectPlugin.getDefault();
                String avmName = this.parameters.get("com.proalpha.java.oea.plugins.querygenerator.avmNameParameter");
                if (avmName != null && !avmName.isEmpty()) {
                    runtime = projectPlugin.getOpenEdgeModel().getOpenEdgeProject(avmName).getRuntime();
                }
            } else if (menuItemType.equals("SharedAVM")) {
                if (SharedAVM.isRuntimeStarted()) {
                    runtime = SharedAVM.getSharedAVM();
                } else {
                    RuntimePVM sharedRuntime = SharedAVM.getSharedAVM();
                    sharedRuntime.addAVMRuntimeListener((IAVMRuntimeListener)new SharedAVMRuntimeListener(commandParameter));
                }
            }
            if (runtime != null) {
                QueryGeneratorHandler.this.startQueryGenerator(runtime, commandParameter);
                String selectionText = EditorTools.getInstance().getSelectionText();
                if (selectionText != null && !selectionText.isEmpty() && selectionText.length() <= 1024) {
                    HandlerTools.getInstance().runProgram(runtime, QueryGeneratorPrograms.EXECUTE_COMMAND, String.format("command=select_table%stable_name=%s", Character.valueOf(HandlerTools.PARAM_SPLITTER), selectionText), false);
                }
            }
        }
    }

    private class SharedAVMRuntimeListener
    implements IAVMRuntimeListener {
        private String commandParameter = "";

        public SharedAVMRuntimeListener(String commandParameter) {
            this.commandParameter = commandParameter;
        }

        public void runtimeAvailable(IAVMClient runtime) {
        }

        public void runtimeInitialized(IAVMClient runtime) {
        }

        public void runtimeShutdown(IAVMClient runtime) {
        }

        public void runtimeStarted(IAVMClient runtime) {
            runtime.removeAVMRuntimeListener((IAVMRuntimeListener)this);
            QueryGeneratorHandler.this.startQueryGenerator(runtime, this.commandParameter);
        }

        public void runtimeStopped(IAVMClient runtime) {
        }
    }
}

