&ANALYZE-SUSPEND _VERSION-NUMBER AB_v10r12 GUI
&ANALYZE-RESUME
/* Connected Databases 
*/
&Scoped-define WINDOW-NAME hQueryWindow

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CUSTOM _DECLARATIONS hQueryWindow 
routine-level on error undo, throw.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CUSTOM _DEFINITIONS hQueryWindow 
/******************************************************************************/
/*                                      (c) 2013   proALPHA Software AG       */
/*                                                 Auf dem Immel 8            */
/*                                                 67661  Kaiserslautern      */
/*                                                                            */
/*  erstellt am: 02.05.2013                                                   */
/*  Autor......: Manuel Thiemann                                              */
/*                                                                            */
/*  Version....: 4.0.0 Dev 24                                                 */
/*                                                                            */
/*----------------------------------------------------------------------------*/
/*  AUFGABE                                                                   */
/*----------------------------------------------------------------------------*/
/*                                                                            */
/* Ermglicht das "Zusammenklicken" einer Datenbank-Abfrage als "find first", */
/* "for each" oder "can-find".                                                */
/*                                                                            */
/*----------------------------------------------------------------------------*/
/*  NDERUNGSPROTOKOLL                                                        */
/*----------------------------------------------------------------------------*/
/* 02.05.2013 mth Version 1.0.0                                               */
/* 02.05.2013 mth Version 1.1.0                                               */
/* 08.05.2013 mth Version 1.2.0                                               */
/* 15.05.2013 mth Version 2.0.0                                               */
/* 16.05.2013 mth Version 2.1.0                                               */
/* 23.05.2013 mth Version 2.2.0                                               */
/* 20.08.2013 mth Version 3.0.0                                               */
/* 18.09.2013 mth Version 3.1.0                                               */
/* 04.11.2013 mth Version 3.2.0                                               */
/* 03.02.2014 mth Version 3.3.0                                               */
/* 20.02.2014 mth Version 3.4.0                                               */
/* 06.03.2014 mth Version 3.5.0                                               */
/* 02.04.2014 mth Version 3.6.0                                               */
/* 15.05.2014 mth Version 3.7.0                                               */
/* 29.07.2014 mth Version 3.8.0                                               */
/* 14.11.2014 mth Version 3.9.0                                               */
/* 01.02.2015 mth Version 3.10.0                                              */
/* 03.03.2015 mth Version 3.10.1                                              */
/* 23.04.2015 mth Version 3.10.2                                              */
/* 04.08.2015 mth Version 3.11.0                                              */
/* 03.09.2015 mth Version 3.11.1                                              */
/* 03.09.2015 mth Version 3.11.2                                              */
/* ??.??.???? mth Version 4.0.0                                               */
/******************************************************************************/

/*----------------------------------------------------------------------------*/
/*          This .W file was created with the Progress AppBuilder.            */
/*----------------------------------------------------------------------------*/

/* Create an unnamed pool to store all the widgets created 
     by this procedure. This is a good default which assures
     that this procedure's triggers and internal procedures 
     will execute in this procedure's storage, and that proper
     cleanup will occur on deletion of the procedure. */

create widget-pool.

/*----------------------------------------------------------------------------*/
/* Definitionen                                                               */
/*----------------------------------------------------------------------------*/

/* Globals -------------------------------------------------------------------*/


/* SCOPEDs -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Options                                                                    */
/*----------------------------------------------------------------------------*/

&SCOPED-DEFINE K_SHOW_QUERY_TYPE_MODIFIER            no
&SCOPED-DEFINE K_ALWAYS_USE_FIND_FIRST               no
&SCOPED-DEFINE K_ALWAYS_USE_CANFIND_FIRST            no

&SCOPED-DEFINE K_SET_SLIM_MODE_ON_STARTUP            no

&SCOPED-DEFINE K_SHOW_GRID_ON_BROWSE                 no
&SCOPED-DEFINE K_TOGGLE_GRID_ON_BROWSE               no
&SCOPED-DEFINE K_SELECT_COLUMN_ON_BROWSE             yes
&SCOPED-DEFINE K_EXPORT_ON_BROWSE                    yes
&SCOPED-DEFINE K_RECORD_COUNT_ON_BROWSE              yes

&SCOPED-DEFINE K_EDITMODE_ENABLED                    yes
&SCOPED-DEFINE K_COLORED_INDEX_USAGE                 no

&SCOPED-DEFINE K_MAX_FIELD_HISTORY_ENTRIES           50

&SCOPED-DEFINE K_SESSIONTRIGGER_SHOWMESSAGE          yes
&SCOPED-DEFINE K_SESSIONTRIGGER_WRITELOG             no
&SCOPED-DEFINE K_SESSIONTRIGGER_LOGFILENAME          '':U
&SCOPED-DEFINE K_SESSIONTRIGGER_INDEXVALUES          yes
&SCOPED-DEFINE K_SESSIONTRIGGER_STACKTRACE           yes

&SCOPED-DEFINE K_AUTOFILTER_OMIT_TABLE_SUFFIX        '':U

&SCOPED-DEFINE K_DEFAULT_REPOSITORY_LANGUAGE         'D':U

/*----------------------------------------------------------------------------*/
/* Parameters                                                                 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Defaults                                                                   */
/*----------------------------------------------------------------------------*/

&SCOPED-DEFINE K_DEFAULT_BUFFER_PATTERN              '&1':U
&SCOPED-DEFINE K_DEFAULT_DEFINE_BUFFER               no

&SCOPED-DEFINE K_DEFAULT_EXCLUSIVE_LOCK              no
&SCOPED-DEFINE K_DEFAULT_COMPANY_VIA_CLASS           yes
&SCOPED-DEFINE K_DEFAULT_NO_ERROR                    yes
&SCOPED-DEFINE K_DEFAULT_IF_STATEMENT                yes
&SCOPED-DEFINE K_DEFAULT_NOT                         no
&SCOPED-DEFINE K_DEFAULT_DO_BLOCK                    no
&SCOPED-DEFINE K_DEFAULT_DEFINE_VARIABLES            yes
&SCOPED-DEFINE K_DEFAULT_USE_VIRTUAL_INDEX_API       yes
&SCOPED-DEFINE K_DEFAULT_USE_VIRTUAL_INDEX_INCLUDES  no

&SCOPED-DEFINE K_DEFAULT_ON_ERROR                    yes
&SCOPED-DEFINE K_DEFAULT_ON_ERROR_PHRASE             ~{&K_ON_ERROR_PHRASE_THROW}
&SCOPED-DEFINE K_DEFAULT_BLOCK_PATTERN               '':U
&SCOPED-DEFINE K_DEFAULT_DEFINE_BLOCK                no
&SCOPED-DEFINE K_DEFAULT_RETRY_BLOCK                 no
&SCOPED-DEFINE K_DEFAULT_FINALLY_BLOCK               no

&SCOPED-DEFINE K_DEFAULT_QUERY_TYPE                  ~{&K_QUERYTYPE_FINDFIRST}

&SCOPED-DEFINE K_DEFAULT_INDENTATION                 0

&SCOPED-DEFINE K_DEFAULT_INSERT_MODE                 yes

/*----------------------------------------------------------------------------*/
/* Buffer-Buttons                                                             */
/*----------------------------------------------------------------------------*/

/* Use &1 as table name replacement and # as a counter replacement. Use ## to */
/* actually insert the # character                                            */

&SCOPED-DEFINE K_BUFFER_PATTERN_1                    'b#&1':U
&SCOPED-DEFINE K_BUFFER_PATTERN_LABEL_1              'b#':U

&SCOPED-DEFINE K_BUFFER_PATTERN_2                    'gb#&1':U
&SCOPED-DEFINE K_BUFFER_PATTERN_LABEL_2              'gb#':U

&SCOPED-DEFINE K_BUFFER_PATTERN_3                    'bx#&1':U
&SCOPED-DEFINE K_BUFFER_PATTERN_LABEL_3              'bx#':U

&SCOPED-DEFINE K_BUFFER_PATTERN_4                    'gbx#&1':U
&SCOPED-DEFINE K_BUFFER_PATTERN_LABEL_4              'gbx#':U

&SCOPED-DEFINE K_NUM_BUFFER_PATTERN_INDICES          5

/*----------------------------------------------------------------------------*/
/* Block-Buttons                                                              */
/*----------------------------------------------------------------------------*/

&SCOPED-DEFINE K_BLOCK_PATTERN_1                     'FE_&1':U
&SCOPED-DEFINE K_BLOCK_PATTERN_LABEL_1               'FE':U

&SCOPED-DEFINE K_BLOCK_PATTERN_2                     'Main':U
&SCOPED-DEFINE K_BLOCK_PATTERN_LABEL_2               'Main':U

&SCOPED-DEFINE K_BLOCK_PATTERN_3                     '':U
&SCOPED-DEFINE K_BLOCK_PATTERN_LABEL_3               '':U

&SCOPED-DEFINE K_BLOCK_PATTERN_4                     '':U
&SCOPED-DEFINE K_BLOCK_PATTERN_LABEL_4               '':U


/*----------------------------------------------------------------------------*/
/* Other constants                                                            */
/*----------------------------------------------------------------------------*/

&SCOPED-DEFINE K_Version                           '4.0.0 Dev 24':U
&GLOBAL-DEFINE xITCFramework_VERSION               40024

&IF proversion < '11.3':U &THEN
  
  /* The progress system constant PROCESS-ARCHITECTURE was introduced in      */
  /* progress version 11.3. To avoid compile errors in version prior to that  */
  /* we declare it as 32 bit. Chances are very slim that it is anything else  */
  /* in earlier progress versions.                                            */
  
  &GLOBAL-DEFINE PROCESS-ARCHITECTURE  32
  
&ENDIF

&SCOPED-DEFINE K_FIELD_TYPE_DB_FIELD               0
&SCOPED-DEFINE K_FIELD_TYPE_VIRTUAL_DB_FIELD       10

&SCOPED-DEFINE K_BASE_DB_NAME                      'basis':U

&SCOPED-DEFINE K_QG_WIKI_URL                       'http://pawiki/wiki/Query%20Generator':U
&SCOPED-DEFINE K_QG_CUSTOMER_WIKI_URL              'https://b2b.proalpha.de/wiki/index.php?title=Query%20Generator':U
&SCOPED-DEFINE K_PLUGIN_WIKI_URL                   'http://pawiki/wiki/Query%20Generator%20(Eclipse%20Plugin)':U
&SCOPED-DEFINE K_PLUGIN_CUSTOMER_WIKI_URL          'https://b2b.proalpha.de/wiki/index.php?title=Query%20Generator%20(Eclipse%20Plugin)':U

&SCOPED-DEFINE K_COMPANY_FIELDS                    'Firma,Company':U
&SCOPED-DEFINE K_COMPANY_INCLUDE_BLACKLIST         '*dt_fir00.fir*':U
&SCOPED-DEFINE K_OBJECT_ID_DOMAIN                  'Object ID':U

&SCOPED-DEFINE K_QUERYRANGE_DEFAULT                1
&SCOPED-DEFINE K_QUERYRANGE_FIRST                  2
&SCOPED-DEFINE K_QUERYRANGE_LAST                   3

&SCOPED-DEFINE K_QUERYTYPE_FINDFIRST               1
&SCOPED-DEFINE K_QUERYTYPE_FOREACH                 2
&SCOPED-DEFINE K_QUERYTYPE_CANFIND                 3

&SCOPED-DEFINE K_ACCESS_MODE_PHYSICAL              0
&SCOPED-DEFINE K_ACCESS_MODE_VIRTUAL_INDEX_API     1
&SCOPED-DEFINE K_ACCESS_MODE_VIRTUAL_INDEX_INCLUDE 2

&SCOPED-DEFINE K_ON_ERROR_PHRASE_LEAVE             1
&SCOPED-DEFINE K_ON_ERROR_PHRASE_NEXT              2
&SCOPED-DEFINE K_ON_ERROR_PHRASE_RETRY             3
&SCOPED-DEFINE K_ON_ERROR_PHRASE_THROW             4

&SCOPED-DEFINE K_DISPLAYMODE_FIELD                 1
&SCOPED-DEFINE K_DISPLAYMODE_INDEX                 2
&SCOPED-DEFINE K_DISPLAYMODE_RELATION              3

&SCOPED-DEFINE K_EDITACTION_EDIT                   1
&SCOPED-DEFINE K_EDITACTION_CREATE                 2
&SCOPED-DEFINE K_EDITACTION_DUPLICATE              3

&SCOPED-DEFINE K_WINDOW_MAXIMIZED                  1
&SCOPED-DEFINE K_WINDOW_MINIMIZED                  2
&SCOPED-DEFINE K_WINDOW_NORMAL                     3
&SCOPED-DEFINE K_WINDOW_DELAYED_MINIMIZE           4

&SCOPED-DEFINE K_WINDOW_MAXIMIZED_STR              'maximized':U
&SCOPED-DEFINE K_WINDOW_MINIMIZED_STR              'minimized':U
&SCOPED-DEFINE K_WINDOW_NORMAL_STR                 'normal':U

&SCOPED-DEFINE K_CLASS_COMPANY_STATEMENT           pACConnectionSvc:prpcCompany

&SCOPED-DEFINE K_PARAM_SPLITTER                    chr(3)

&SCOPED-DEFINE K_EDITOR_INSERT_REQUEST_HANDLER     'EditorInsertRequestId':U
&SCOPED-DEFINE K_SAVE_PLUGIN_SETTING_HANDLER       'SavePluginSettingId':U
&SCOPED-DEFINE K_LOAD_PLUGIN_SETTING_HANDLER       'LoadPluginSettingId':U

&SCOPED-DEFINE K_WINDOW_MIN_WIDTH                  210
&SCOPED-DEFINE K_WINDOW_MIN_WIDTH_SLIM             85
&SCOPED-DEFINE K_WINDOW_MIN_HEIGHT                 24
&SCOPED-DEFINE K_WINDOW_MIN_HEIGHT_SLIM            22
&SCOPED-DEFINE K_SLIM_MODE_FACTOR                  (231 / 121)

&SCOPED-DEFINE K_COLOR_BLACK                       1
&SCOPED-DEFINE K_COLOR_DARK_RED                    4
&SCOPED-DEFINE K_COLOR_GREEN                       10
&SCOPED-DEFINE K_COLOR_RED                         12
&SCOPED-DEFINE K_COLOR_YELLOW                      14
&SCOPED-DEFINE K_COLOR_DARK_GREY                   7
&SCOPED-DEFINE K_COLOR_LIGHT_GREY                  8

&SCOPED-DEFINE K_WHERE_DATA_TYPE_BLACKLIST         'BLOB,CLOB':U

&SCOPED-DEFINE K_MAX_INT64_FORMAT                  '-z,zzz,zzz,zzz,zzz,zzz,zz9':U

&SCOPED-DEFINE K_PROGRESS_TTNAME                   'PROGRESST':U
&SCOPED-DEFINE K_PERSISTENT_TT_DBNAME              'Persistent':U
&SCOPED-DEFINE K_PERSISTENT_TT_PHYSICALNAME        '*** Virtual persistent temp-table database ***':T
&SCOPED-DEFINE K_SNAPSHOT_DBNAME                   'Snapshots':U
&SCOPED-DEFINE K_SNAPSHOT_PHYSICALNAME             '*** Virtual snapshot database ***':T

&SCOPED-DEFINE K_QUERY_SIZE_MODE_DEFAULT           0
&SCOPED-DEFINE K_QUERY_SIZE_MODE_DEFAULT_SPLITTER  1
&SCOPED-DEFINE K_QUERY_SIZE_MODE_SMALL             2
&SCOPED-DEFINE K_QUERY_SIZE_MODE_MINIMUM           3
&SCOPED-DEFINE K_QUERY_SIZE_MODE_BIG               4
&SCOPED-DEFINE K_RECORD_SIZE_MODE_DEFAULT          5

&SCOPED-DEFINE K_VALUE_MODE_DATA_TYPE              0
&SCOPED-DEFINE K_VALUE_MODE_DEFAULT_VALUE          1
&SCOPED-DEFINE K_VALUE_MODE_PARAMETER              2

&SCOPED-DEFINE K_WIN_CONST_VK_SCROLL               0x91
&SCOPED-DEFINE K_WIN_CONST_VK_NUMLOCK              0x90
&SCOPED-DEFINE K_WIN_CONST_VK_CAPITAL              0x14
&SCOPED-DEFINE K_WIN_CONST_VK_CTRL                 0x11
&SCOPED-DEFINE K_WIN_CONST_VK_ALT                  0x12
&SCOPED-DEFINE K_WIN_CONST_VK_SHIFT                0x10

&GLOBAL-DEFINE K_WIN_CONST_HKEY_CURRENT_USER       -2147483647
&GLOBAL-DEFINE K_WIN_CONST_HKEY_LOCAL_MACHINE      -2147483646
&GLOBAL-DEFINE K_WIN_CONST_HKEY_CURRENT_CONFIG     -2147483643
&GLOBAL-DEFINE K_WIN_CONST_HKEY_CLASSES_ROOT       -2147483648

&GLOBAL-DEFINE K_WIN_CONST_KEY_QUERY_VALUE         1

&GLOBAL-DEFINE K_WIN_CONST_GWL_STYLE               -16
&GLOBAL-DEFINE K_WIN_CONST_WS_BORDER               0x00800000
&GLOBAL-DEFINE K_WIN_CONST_WS_CHILD                0x40000000
&GLOBAL-DEFINE K_WIN_CONST_WS_CLIPCHILDREN         0x02000000
&GLOBAL-DEFINE K_WIN_CONST_WS_POPUP                0x80000000
&GLOBAL-DEFINE K_WIN_CONST_WS_TABSTOP              0x00010000
&GLOBAL-DEFINE K_WIN_CONST_WS_HSCROLL              0x00100000
&GLOBAL-DEFINE K_WIN_CONST_WS_VSCROLL              0x00200000

&GLOBAL-DEFINE K_WIN_CONST_SWP_NOSIZE              1
&GLOBAL-DEFINE K_WIN_CONST_SWP_FRAMECHANGED        32

&GLOBAL-DEFINE K_QUERY_WINDOW_MODE_QUERY           0
&GLOBAL-DEFINE K_QUERY_WINDOW_MODE_QUERY_STR       'query':U
&GLOBAL-DEFINE K_QUERY_WINDOW_MODE_RECORD          1
&GLOBAL-DEFINE K_QUERY_WINDOW_MODE_RECORD_STR      'record':U

&GLOBAL-DEFINE K_NAVIGATE_FIRST                    1
&GLOBAL-DEFINE K_NAVIGATE_PREV                     2
&GLOBAL-DEFINE K_NAVIGATE_NEXT                     3
&GLOBAL-DEFINE K_NAVIGATE_LAST                     4

&GLOBAL-DEFINE K_QUERY_WINDOW_LINK_MODE_FIX_ROWID  1
&GLOBAL-DEFINE K_QUERY_WINDOW_LINK_MODE_FIX_INDEX  2
&GLOBAL-DEFINE K_QUERY_WINDOW_LINK_MODE_LINKED     3

&SCOPED-DEFINE K_DIRECTION_UP                      0
&SCOPED-DEFINE K_DIRECTION_DOWN                    1
&SCOPED-DEFINE K_DIRECTION_LEFT                    2
&SCOPED-DEFINE K_DIRECTION_RIGHT                   3

&SCOPED-DEFINE K_QP_TOKEN_TYPE_UNDEFINED           0
&SCOPED-DEFINE K_QP_TOKEN_TYPE_EOF                 1
&SCOPED-DEFINE K_QP_TOKEN_TYPE_KEYWORD             2
&SCOPED-DEFINE K_QP_TOKEN_TYPE_STRING              3
&SCOPED-DEFINE K_QP_TOKEN_TYPE_COMMENT             4
&SCOPED-DEFINE K_QP_TOKEN_TYPE_OPERATOR            5
&SCOPED-DEFINE K_QP_TOKEN_TYPE_NUMBER              6
&SCOPED-DEFINE K_QP_TOKEN_TYPE_DATE                7
&SCOPED-DEFINE K_QP_TOKEN_TYPE_PUNCTUATION         8
&SCOPED-DEFINE K_QP_TOKEN_TYPE_PREPROCESSOR        9
&SCOPED-DEFINE K_QP_TOKEN_TYPE_BRACE_OPEN          10
&SCOPED-DEFINE K_QP_TOKEN_TYPE_BRACE_CLOSE         11
&SCOPED-DEFINE K_QP_TOKEN_TYPE_BRACKET_OPEN        12
&SCOPED-DEFINE K_QP_TOKEN_TYPE_BRACKET_CLOSE       13
&SCOPED-DEFINE K_QP_TOKEN_TYPE_PARENTHESE_OPEN     14
&SCOPED-DEFINE K_QP_TOKEN_TYPE_PARENTHESE_CLOSE    15
&SCOPED-DEFINE K_QP_TOKEN_TYPE_IDENTIFIER          16
&SCOPED-DEFINE K_QP_TOKEN_TYPE_EXTERNAL_REFERENCE  17

&SCOPED-DEFINE K_QP_NODE_TYPE_NODE                 0
&SCOPED-DEFINE K_QP_NODE_TYPE_TOKEN                1

&SCOPED-DEFINE K_QP_COMPARATOR_OPERATORS ~
    'EQ,LT,LE,GT,GE,NE,BEGINS,MATCHES,CONTAINS,=,<,<=,>,>=,<>':U

&SCOPED-DEFINE K_QP_CONDITION_BREAK_KEYWORDS ~
      'FOR,EACH,FIRST,LAST,BREAK,BY,COLLATE,TRANSACTION,STOP-AFTER':U ~
    + ',ON,USE-INDEX,NO-LOCK,SHARE-LOCK,EXCLUSIVE-LOCK,NO-PREFETCH':U ~
    + ',LOOKAHEAD,NO-LOOKAHEAD,DEBUG,NO-DEBUG,SEPARATE-CONNECTION':U ~
    + ',NO-SEPARATE-CONNECTION,JOIN-BY-SQLDB,NO-JOIN-BY-SQLDB,BIND-WHERE':U ~
    + ',NO-BIND-WHERE,INDEX-HINT,NO-INDEX-HINT,SKIP-GROUP-DUPLICATES':U ~
    + ',TABLE-SCAN,USING':U

&SCOPED-DEFINE K_QP_KEYWORD_FUNCTIONS ~
      'TODAY,NOW,ETIME,ALIAS,ASC,AVAILABLE,CAN-DO,CAN-FIND,CAST,COUNT-OF':U ~
    + ',CURRENT-CHANGED,CURRENT-LANGUAGE,DATASERVERS,DBCODEPAGE,DBCOLLATION':U ~
    + ',DBNAME,DBPARAM,DBRESTRICTIONS,DBTASKID,DBTYPE,DBVERSION':U ~
    + ',DYNAMIC-FUNCTION,ENCODE,ENTRY,ETIME,FILL,FIRST-OF,FRAME-COL':U ~
    + ',FRAME-DB,FRAME-DOWN,FRAME-FIELD,FRAME-FILE,FRAME-INDEX,FRAME-LINE':U ~
    + ',FRAME-NAME,FRAME-ROW,FRAME-VALUE,GET-BYTE,GET-CODEPAGES':U ~
    + ',GET-COLLATIONS,INDEX,INPUT,IS-ATTR-SPACE,KBLABEL,KEYCODE':U ~
    + ',KEYFUNCTION,KEYLABEL,KEYWORD,LAST-OF,LASTKEY,LDBNAME,LIBRARY':U ~
    + ',LINE-COUNTER,LOCKED,LOOKUP,MEMBER,MESSAGE-LINES,NEW,NUM-ALIASES':U ~
    + ',NUM-DBS,NUM-ENTRIES,OS-DRIVES,OS-ERROR,PAGE-NUMBER,PDBNAME':U ~
    + ',PROC-HANDLE,PROC-STATUS,PROGRAM-NAME,R-INDEX,RECID,RECORD-LENGTH':U ~
    + ',RETRY,RETURN-VALUE,SCREEN-LINES,SDBNAME,SEARCH,SEEK,SETUSERID,SUPER':U ~
    + ',TERMINAL,TIME,TRIM,USERID':U

&SCOPED-DEFINE K_CASEMODE_TABLE                    1
&SCOPED-DEFINE K_CASEMODE_FIELD                    2
&SCOPED-DEFINE K_CASEMODE_TABLE_FIELD              3
&SCOPED-DEFINE K_CASEMODE_TABLE_FIELD_LABEL        4
&SCOPED-DEFINE K_CASEMODE_TABLE_INDEX              5
&SCOPED-DEFINE K_CASEMODE_TABLE_RELATION           6

&SCOPED-DEFINE K_SNAPSHOT_SCOPE_RECORD             'rec':U
&SCOPED-DEFINE K_SNAPSHOT_SCOPE_ALL                'all':U

&SCOPED-DEFINE K_OVERLAY_TYPE_OBJ_STR              'obj':U

&SCOPED-DEFINE K_OBJECTID_OVERLAY_FGCOLOR          5
&SCOPED-DEFINE K_OBJECTID_OVERLAY_DEFAULT_WIDTH    35
&SCOPED-DEFINE K_OBJECTID_OVERLAY_FORMAT           'x(1024)':U
&SCOPED-DEFINE K_OBJECTID_OVERLAY_NAME_PATTERN     '$resolve( &1 )':U
&SCOPED-DEFINE K_OBJECTID_OVERLAY_LABEL_PATTERN    '&1 <resolved>':U

&SCOPED-DEFINE K_IMPORT_TYPE_DATASET               0
&SCOPED-DEFINE K_IMPORT_TYPE_TEMP_TABLE            1

/* Variables -----------------------------------------------------------------*/

define stream strExport.
define stream strClipboard.
define stream strSeTrigger.
define stream strTemp.

define new global shared variable pa-broker-hdl  as handle no-undo.

define variable gcBufferBaseName            as character no-undo.
define variable gcBufferPattern             as character no-undo.
define variable gcBlockPattern              as character no-undo.

define variable gcStatusText60              as character no-undo format 'x(60)':U.
define variable gcStatusText120             as character no-undo format 'x(120)':U.

define variable giQuerySeq                  as integer   no-undo.

define variable gcExportFilename            as character no-undo.
define variable gcQRScenarioFileName        as character no-undo.

define variable glShowHiddenTables          as logical   no-undo.

define variable glShowChildRelations        as logical   no-undo init yes.
define variable glShowParentRelations       as logical   no-undo init yes.

define variable giIndentation               as integer   no-undo.

define variable gcIDEProjectName            as character no-undo.

define variable glIDECanInsert              as logical   no-undo.
define variable glIDECanSaveSetting         as logical   no-undo.
define variable glIDECanLoadSetting         as logical   no-undo.

define variable glInsertMode                as logical   no-undo.

define variable gdOriginalWidth             as decimal   no-undo.
define variable gdMinWidth                  as decimal   no-undo init {&K_WINDOW_MIN_WIDTH}.
define variable gdOriginalHeight            as decimal   no-undo.
define variable gdMinHeight                 as decimal   no-undo init {&K_WINDOW_MIN_HEIGHT}.

define variable gcFieldDatatypeFilter       as character no-undo.

define variable gcSessionTitle              as character no-undo.
define variable gcTitlePrefix               as character no-undo.
define variable gcIconDir                   as character no-undo.

define variable giRecentQueriesSeq          as integer   no-undo.

define variable glBrowseFields              as logical   no-undo init no.
define variable glRawValues                 as logical   no-undo init no.
define variable glCopyRawValues             as logical   no-undo init yes.
define variable glShowLinkedChildWindows    as logical   no-undo init yes.

define variable gcPersitentTTProcedure      as character no-undo.

define variable gcTTWidgetPool              as character no-undo.

define variable gcCursorHand                as character no-undo.

define variable giQueryParserSeq            as integer   no-undo.

define variable gcQPQueryText               as character no-undo.
define variable giQPOffset                  as integer   no-undo.
define variable giQPTokenStart              as integer   no-undo.
define variable giQPTokenEnd                as integer   no-undo.
define variable gcQPToken                   as character no-undo.
define variable giQPTokenType               as integer   no-undo.

define variable glShowQueryTypeModifier     as logical   no-undo.
define variable glAlwaysUseFindFirst        as logical   no-undo.
define variable glAlwaysUseCanFindFirst     as logical   no-undo.
define variable glUseVirtualIndexApi        as logical   no-undo.
define variable glSlimMode                  as logical   no-undo.

define variable glUnicode                   as logical   no-undo.
define variable gcSpace                     as character no-undo.
define variable gcBulletChar1               as character no-undo.
define variable gcBulletChar1White          as character no-undo.
define variable gcBulletChar2               as character no-undo.
define variable gcBulletChar2White          as character no-undo.
define variable gcLineVertical              as character no-undo.
define variable gcLineUpAndRight            as character no-undo.
define variable gcLineVerticalAndRight      as character no-undo.

define variable giSessionTriggerSeq         as integer   no-undo.
define variable giSessionTriggerInstSeq     as integer   no-undo.

define variable ghSessionTriggersWindow     as handle    no-undo.
define variable ghSessionTriggersBrowse     as handle    no-undo.
define variable ghSessionTriggerShowMessage as handle    no-undo.
define variable ghSessionTriggerWriteLog    as handle    no-undo.
define variable ghSessionTriggerLogFileName as handle    no-undo.
define variable ghSessionTriggerIndexValues as handle    no-undo.
define variable ghSessionTriggerStackTrace  as handle    no-undo.

define variable glSessionTriggerShowMessage as logical   no-undo.
define variable glSessionTriggerWriteLog    as logical   no-undo.
define variable gcSessionTriggerLogFileName as character no-undo.
define variable glSessionTriggerIndexValues as logical   no-undo.
define variable glSessionTriggerStackTrace  as logical   no-undo.

define variable giRelationSeq               as integer   no-undo.
define variable giRelationViewSeq           as integer   no-undo.
define variable giRelationId                as integer   no-undo.
define variable gcRelationBufferName        as character no-undo.
define variable ghRelationWindow            as handle    no-undo.

define variable glRefreshFieldBrowse        as logical   no-undo.
define variable glRefreshIndexBrowse        as logical   no-undo.
define variable glRefreshRelationBrowse     as logical   no-undo.

define variable gchMerge                    as com-handle no-undo.
define variable gcBufferComparison1Tables   as character no-undo.
define variable gcBufferComparison1Buffers  as character no-undo.
define variable gcBufferComparison1RowIds   as character no-undo.
define variable gcBufferComparison2Tables   as character no-undo.
define variable gcBufferComparison2Buffers  as character no-undo.
define variable gcBufferComparison2RowIds   as character no-undo.

define variable giFilterSeq                 as integer   no-undo.

define variable gcRepositoryLanguage        as character no-undo init {&K_DEFAULT_REPOSITORY_LANGUAGE}.

/* Work-/Temp-Tables ---------------------------------------------------------*/

define temp-table ttDatabase no-undo
  field DatabaseName            as character
    format 'x(30)':U
    label 'Database':T
  field PhysicalName            as character
    format 'x(255)':U
    label 'Physical name':T
  field DisplayPriority         as integer
  field DirectoryName           as character
  field TempDB                  as logical
  field BasisDB                 as logical
  field BasisDBName             as character
  field PhysicalDB              as logical
  field SharedMemory            as logical
  field VirtualDBFieldsPossible as logical
  field VirtualIndicesPossible  as logical
  index Main is primary unique
    DatabaseName
  index PhysicalName is unique
    PhysicalName
    DatabaseName
  index TempDB
    TempDB
    DatabaseName
  index BasisDB
    DirectoryName
    BasisDB
    DatabaseName
  index DisplayPriority
    DisplayPriority
    DatabaseName
    .

define temp-table ttTable no-undo
  field DatabaseName            like ttDatabase.DatabaseName
  field TableName               as character
    format 'x(32)':U
    label 'Table':T
  field ShortDescription        as character
    format 'x(80)':U
    label 'Short Description':U
  field TableFilterMatches      as logical
  field TableFieldFilterMatches as logical
  field CreateTrigger           as character
  field CreateTriggerProcName   as character
    format 'x(32)':U
    label 'Create trigger':T
  field WriteTrigger            as character
  field WriteTriggerProcName    as character
    format 'x(32)':U
    label 'Write trigger':T
  field DeleteTrigger           as character
  field DeleteTriggerProcName   as character
    format 'x(32)':U
    label 'Delete trigger':T
  field CompanyInclude          as character
    format 'x(12)':U
    label 'Company include':T
  field KeyInclude              as character
    format 'x(12)':U
    label 'Key include':T
  field FillInclude              as character
    format 'x(12)':U
    label 'Key include':T
  field InternalIdentifier      as character
  field PrimaryIndexName        as character
  field DetailsLoaded           as logical
  field DescriptionLoaded       as logical
  field PhysicalTable           as logical
  field TableHandle             as handle
  field OriginalTableHandle     as handle
  field Snapshot                as logical
  field RepObjectId             as character
  field RepTableId              as character
  index Main is primary unique
    DatabaseName
    TableName
  index RepObjectId
    RepObjectId
    DatabaseName
    TableName
  index Filter
    DatabaseName
    TableFilterMatches
    TableFieldFilterMatches
    TableName
  index PhysicalTable
    PhysicalTable
    DatabaseName
    TableName
  index InternalId
    DatabaseName
    InternalIdentifier
    TableName
  index DescriptionLoaded
    DescriptionLoaded
    DatabaseName
    TableName
    .

define temp-table ttField no-undo
  field DatabaseName       like ttDatabase.DatabaseName
  field TableName          like ttTable.TableName
  field FieldName          as character
    format 'x(32)':U
    label 'Field':T
  field RepObjectId        as character
  field DataType           as character
    format 'x(13)':U
    label 'Data type':T
  field FieldFormat        as character
    format 'x(30)':U
    label 'Format':T
  field FieldExtent        as integer
    format '>>>9':U
    label 'Extent':T
  field FieldDecimals      as integer
    format '>>>9':U
    label 'Decimals':T
  field FieldInitialValue  as character
    format 'x(30)':U
    label 'Initial':U
  field FieldLabel         as character
    format 'x(30)':U
    label 'Label':T
  field FieldColumnLabel   as character
    format 'x(30)':U
    label 'Column-Label':T
  field IsMandatory        as logical
    format 'yes/no':U
    label 'Mandatory':T
    view-as toggle-box
  field Domain             as character
    format 'x(40)':U
    label 'Domain':T
  field FieldViewAs        as character
    format 'x(50)':U
    label 'View as':T
  field IsObjectId         as logical
  field IsVirtual          as logical
    format '*/':U
    label 'Virtual Field':T
    column-label 'V':T
  field FieldType          as integer
  field FieldFilterMatches as logical
  index Main is primary unique
    DatabaseName
    TableName
    FieldName
  index RepObjectId
    RepObjectId
    DatabaseName
    TableName
    FieldName
  index FieldName
    DatabaseName
    FieldName
    TableName
  index VirtualField
    DatabaseName
    TableName
    IsVirtual
    FieldType
    DataType
    FieldName
  index FieldLabel
    DatabaseName
    FieldLabel
    TableName
    FieldName
  index Filter
    DatabaseName
    TableName
    FieldFilterMatches
    FieldName
    .

define temp-table ttIndex no-undo
  field DatabaseName                   like ttDatabase.DatabaseName
  field TableName                      like ttTable.TableName
  field IndexName                      as character
    format 'x(32)':U
    label 'Index':T
  field IsPrimary                      as logical
    format '*/ ':U
    label 'P':T
  field IndexFields                    as character
    format 'x(255)':U
    label 'Fields':T
  field IndexFieldList                 as character
  field IsUnique                       as logical
    format '*/ ':U
    label 'U':T
  field IndexFilterMatches             as logical
  field IndexFieldFilterMatches        as logical
  field IsVirtual                      as logical
    format '*/':U
    label 'V':U
  field VirtualFieldList               as character
  field VirtualFieldDataTypes          as character
  field VirtualIndexDataFieldList      as character
  field VirtualIndexDataFieldLabels    as character
  field VirtualIndexDataUntaggedValues as character
  field VirtualIndexDataTaggedValues   as character
  index Main is primary unique
    DatabaseName
    TableName
    IndexName
  index IsPrimary
    DatabaseName
    TableName
    IsPrimary
    IndexName
  index IsUnique
    DatabaseName
    TableName
    IsUnique
    IndexName
  index Filter
    DatabaseName
    TableName
    IndexFilterMatches
    IndexFieldFilterMatches
    IndexName
    .

define temp-table ttIndexField no-undo
  field DatabaseName  like ttDatabase.DatabaseName
  field TableName     like ttTable.TableName
  field IndexName     as character
  field IndexSequence as integer
  field FieldName     like ttField.FieldName
  field DataType      as character
  field SortAscending as logical
  index Main is primary unique
    DatabaseName
    TableName
    IndexName
    IndexSequence
  index FieldName
    DatabaseName
    TableName
    IndexName
    FieldName
    IndexSequence
    .

define temp-table ttTableRelation no-undo
  field RelationId       as integer
  field DatabaseName     like ttDatabase.DatabaseName
  field ParentTableName  like ttTable.TableName
    label 'Parent table':T
  field ChildTableName   like ttTable.TableName
    label 'Child table':T
  field SequentialNumber as integer
  field RelationType     as character
  field ParentFields     as character
  field ChildFields      as character
  field ParentFieldList  as character
  field ChildFieldList   as character
  index Main is primary unique
    RelationId
  index ParentTableName is unique
    DatabaseName
    ParentTableName
    ChildTableName
    SequentialNumber
  index ChildTableName is unique
    DatabaseName
    ChildTableName
    ParentTableName
    SequentialNumber
    .

define temp-table ttTableRelationField no-undo
  field RelationId         as integer
  field Order              as integer
  field ParentFieldName    like ttField.FieldName
    label 'Parent field':U
  field ParentConstantData as character
  field ChildFieldName     like ttField.FieldName
    label 'Child field':U
  field ChildConstantData  as character
  field FieldRelationType  as character
  index Main is primary unique
    RelationId
    Order
  index ParentFieldName
    ParentFieldName
    RelationId
    Order
  index ChildFieldName
    ChildFieldName
    RelationId
    Order
    .

define temp-table ttTableRelationView no-undo
  field RelationViewId     as integer
  field RelationId         like ttTableRelation.RelationId
  field DatabaseName       like ttTableRelation.DatabaseName
  field ReferenceTableName like ttTable.TableName
  field RelatedTableName   like ttTable.TableName
  field RelationType       as character
    label 'Type':T
    format 'x(4)':U
  field ReferenceFields    as character
    label 'Fields':T
    format 'x(1024)':U
  field RelatedFields      as character
    label 'Fields':T
    format 'x(1024)':U
  field FieldDetails      as character
    label 'Field details':T
    format 'x(1024)':U
  field ParentRelation    as logical
    label 'Parent Relation':T
    column-label 'CP':U
    format 'P/C':U
  field ReferenceFieldList as character
  field RelatedFieldList   as character
  field TableFilterMatches as logical
  field FieldFilterMatches as logical
  field ParentRelationFilterMatches as logical
  index Main is primary unique
    RelationViewId
  index RelationId
    RelationId
    DatabaseName
    ReferenceTableName
    RelatedTableName
    RelationViewId
  index TableName
    DatabaseName
    ReferenceTableName
    RelatedTableName
    RelationId
    RelationViewId
    .

define temp-table ttBufferComparisonField no-undo
  field FieldName    as character
  field FieldIndex   as integer
  field BufferNo     as integer
  field DataType     as character
  field FieldFormat  as character
  field DatabaseName as character
  field TableName    as character
  field BufferName   as character
  field FieldValue   as clob
  field IsEqual      as logical init ?
  field IsVirtual    as logical
  field FieldType    as integer
  index Main is primary unique
    FieldName
    FieldIndex
    BufferNo
  index BufferNo
    BufferNo
    FieldName
    FieldIndex
  index IsEqual
    IsEqual
    BufferNo
    FieldName
    FieldIndex
  index DataType
    DataType
    FieldName
    FieldIndex
    BufferNo
    .

define temp-table ttFilterMatch no-undo
  field FilterId as integer
  field RecordRowId as rowid
  field RecordMatches as logical
  index Main is primary unique
    FilterId
    RecordRowId
  index RecordMatch
    FilterId
    RecordMatches
    RecordRowId
    .

define temp-table ttQueryWindow no-undo
  field WindowHandle                 as handle
  field QuerySeq                     as integer
  field WindowMode                   as integer
  field QueryText                    as character
  field QueryHandle                  as handle
  field QueryFrameHandle             as handle
  field QueryMenuHandle              as handle
  field QueryTextEditorHandle        as handle
  field QueryFieldBrowseHandle       as handle
  field QueryFieldBrowseBufferHandle as handle
  field QueryFieldBrowseColHandles   as handle extent 4
  field QueryBrowseHandle            as handle
  field QueryBrowseSelectedColumn    as handle
  field RecordFrameHandle            as handle
  field RecordMenuHandle             as handle
  field RecordQueryHandle            as handle
  field RecordBrowseHandle           as handle
  field RecordBrowseColHandles       as handle extent 5
  field DisplayRawValues             as logical
  field ApplyColumnFormats           as logical
  field ObjSourceQuerySeq            as integer
  field ObjSourceBufferName          as character
  field ObjSourceFieldName           as character
  field ObjSourceFieldIndex          as integer
  field ObjTargetTableId             as character
  field ObjTargetTableName           as character
  field DeepResolveObjectIds         as logical
  field WindowTitle                  as character
    label 'Query window':T
    format 'x(255)':U
  field Updated                    as logical
  field MissingObjectIdFields      as character
  field LastMissingObjectIdRecords as character
  index Main is primary unique
    WindowHandle
  index QuerySeq is unique
    QuerySeq
    .

define temp-table ttQueryWindowQueryBrowseColumn no-undo
  field WindowHandle   as handle
  field ColumnHandle   as handle
  field OriginalFormat as character
  field RawFormat      as character
  index Main is primary unique
    ColumnHandle
  index WindowHandle is unique
    WindowHandle
    ColumnHandle
    .

define temp-table ttQueryWindowField no-undo
  field WindowHandle            as handle
  field BufferId                as integer
  field DatabaseName            like ttDatabase.DatabaseName
  field TableName               like ttTable.TableName
  field BufferName              like ttTable.TableName
    label 'Buffer':T
    column-label 'Buffer':T
  field FieldName               like ttField.FieldName
  field FieldIndex              as integer
    format '>>>9':U
    label 'Idx':T
  field IsOverlay               as logical
  field IsOverlayResolved       as logical
  field FieldLabel              as character
    format 'x(30)':U
    label 'Label':T
  field DisplayName             like ttField.FieldName
    format 'x(255)':U
  field DataType                like ttField.DataType
  field FieldFormat             like ttField.FieldFormat
  field FieldViewAs             like ttField.FieldViewAs
  field FieldType               like ttField.FieldType
  field IsVirtual               like ttField.IsVirtual
  field IsObjectId              like ttField.IsObjectId
  field BufferHandle            as handle
  field FieldHandle             as handle
  field OldFormattedValue       as clob
  field OldUnformattedValue     as clob
  field OldDisplayValue         as character
    format 'x(255)':U
    label 'Old value':U
  field CurrentFormattedValue   as clob
  field CurrentUnformattedValue as clob
  field CurrentDisplayValue     as character
    format 'x(255)':U
    label 'Current value':U
  field Order                   as integer
  index Main is primary unique
    WindowHandle
    BufferId
    FieldName
    FieldIndex
    IsOverlay
  index BufferName
    WindowHandle
    BufferName
    FieldName
    FieldIndex
    IsOverlay
  index Order
    WindowHandle
    Order
    BufferId
    FieldName
    FieldIndex
    IsOverlay
  index IsVirtual
    WindowHandle
    BufferId
    IsVirtual
    FieldName
    FieldIndex
    IsOverlay
    .

define temp-table ttQueryWindowFieldChanges no-undo like ttQueryWindowField.

define temp-table ttQueryWindowObjField no-undo
  field WindowHandle       as handle
  field DatabaseName       like ttDatabase.DatabaseName
  field TableName          like ttTable.TableName
  field BufferName         like ttTable.TableName
    label 'Buffer':T
    column-label 'Buffer':T
  field FieldName          like ttField.FieldName
  field FieldIndex         as integer
    format '>>>9':U
    label 'Idx':T
  field DisplayName        like ttField.FieldName
    format 'x(255)':U
  field IsObjectId         like ttField.IsObjectId
  field IsVirtual          like ttField.IsVirtual
  field FieldType          like ttField.FieldType
  field ContainsObj        as logical
  field TargetDatabaseName like ttDatabase.DatabaseName
    label 'Target database':T
    column-label 'Target db':T
  field TargetTableName    like ttTable.TableName
    label 'Target table':T
    column-label 'Target table':T
  field Priority           as integer
  index Main is primary unique
    WindowHandle
    BufferName
    FieldName
    FieldIndex
  index TableName
    WindowHandle
    DatabaseName
    TableName
    FieldName
    FieldIndex
  index Priority
    WindowHandle
    Priority
    DatabaseName
    TableName
    FieldName
    FieldIndex
    .

define temp-table ttFieldOverlay no-undo
  field OwnerHandle         as handle
  field DatabaseName        as character
  field BufferName          as character
  field FieldName           like ttField.FieldName
  field FieldIndex          as integer
  field ColumnHandle        as handle
  field FieldHandle         as handle
  field OverlayTableId      as character
  field OverlayBufferHandle as handle
  field OverlayColumnHandle as handle
  index Main is primary unique
    OwnerHandle
    BufferName
    FieldName
    FieldIndex
  index ColumnHandle
    OwnerHandle
    ColumnHandle
  index OverlayColumnHandle
    OwnerHandle
    OverlayColumnHandle
    .

define temp-table ttQueryWindowView no-undo
  field Id                 as integer
  field Root               as integer
  field ParentWindowHandle as handle
  field WindowHandle       as handle
  field WindowMode         as integer
  field Depth              as integer
  field LineText           as character
    label 'Query window':T
    format 'x(255)':U
  index Main is primary unique
    ParentWindowHandle
    WindowHandle
  index WindowHandle
    WindowHandle
    ParentWindowHandle
  index Id
    Id
  index Root
    Root
    Id
  index Depth
    Depth
    Root
    Id
    .

define temp-table ttSessionTrigger no-undo
  field Id                   as integer
  field TriggerEvent         as character
    label 'Trigger-Event':T 
    format 'x(6)':U
  field DatabaseName         like ttDatabase.DatabaseName
  field TableName            like ttTable.TableName
  field FieldName            like ttField.FieldName
  field ShowMessage          as logical init yes
    label 'Show message':T
    column-label 'Msg':T
    view-as toggle-box
  field WriteLogfile         as logical init yes
    label 'Write logfile':T
    column-label 'Log':T
    view-as toggle-box
  field LogfileName          as character
    label 'Logfile name':T
    column-label 'Logfile name':T
  field AddSnapshot          as logical
    label 'Add snapshot':T
    column-label 'Sn':T
    view-as toggle-box
  field SnapshotName         as character
    label 'Snapshot name':T
    column-label 'Snapshot name':T
    format 'x(32)':U
  field SnapshotScope        as character init {&K_SNAPSHOT_SCOPE_RECORD}
    label 'Snapshot scope':T
    column-label 'SnSc':T
  field AdditionalInfoFields as character
    label 'Additional info fields':T
    format 'x(1024)':U
  field AdditionalInfo       as logical
  field AdditionalInfoText   as character
  field Condition            as logical
  field ConditionText        as character
  field CustomCode           as logical
  field CustomCodeText       as character
  field TriggerActive         as logical
    label 'Act':U
    view-as toggle-box
  field TriggerFileName      as character
  field ProcedureHandle      as handle
  index Main is primary unique
    Id
  index TriggerEvent
    TriggerEvent
    DatabaseName
    TableName
    FieldName
  index TriggerObject
    DatabaseName
    TableName
    FieldName
    TriggerEvent
    .

define temp-table ttRecentQuery no-undo
  field WindowHandle as handle
  field Order        as integer
  field QueryText    as character
  field OrderLabel   as integer
  field QueryLabel   as character
  index Main is primary unique
    WindowHandle
    QueryText
  index Order
    WindowHandle
    Order descending
    .

define temp-table ttRecentQueryBuffer no-undo
  field WindowHandle  as handle
  field RecentQueryId as integer
  field DatabaseName  as character
  field TableName     as character
  field BufferName    as character
  field Order         as integer
  
  .

define temp-table ttQueryLink no-undo
  field SourceSeq  as integer
  field TargetSeq  as integer
  field StartPos   as integer
  field EndPos     as integer
  field BufferName as character
  field FieldName  like ttField.FieldName
  field FieldIndex as integer
  index Main is primary unique
    TargetSeq
    SourceSeq
    StartPos
    EndPos
  index StartPos
    TargetSeq
    StartPos
    EndPos
    SourceSeq
    .

define temp-table ttExternalRecord no-undo
  field Id             as integer
  field DatabaseName   like ttDatabase.DatabaseName
  field TableName      like ttTable.TableName
  field BufferHandle   as handle
  field TableHandle    as handle
  field RecordRowId    as rowid
  field RecordKey      as character
    format 'x(32000)':U
    label 'Key':U
  index Main is primary unique
    Id
  index Record
    TableName
    RecordRowId
    .

define temp-table ttQueryBuffer no-undo
  field QuerySeq       as integer
    format 'zzzzz9':U
    label 'Id':T
  field BufferName     as character
    format 'x(50)':U
    label 'Buffer name':T
  field BufferHandle     as handle
  field DatabaseName     like ttDatabase.DatabaseName
  field TableName        like ttTable.TableName
  field TableDisplayName as character
    format 'x(1024)':U
    label 'Table':U
  field Order            as integer
  index Main is primary unique
    QuerySeq
    BufferName
  index Order
    QuerySeq
    Order
    BufferName
    .

define temp-table ttQueryBufferField no-undo
  field FieldHandle    as handle
  field FieldName      like ttField.FieldName
  field FieldIndex     as integer
  field DisplayName    as character
    format 'x(32)':U
    label 'Field name':T
  field IsVirtual      like ttField.IsVirtual
  index Main is primary unique
    FieldName
    FieldIndex
    .

define temp-table ttIDEHandler no-undo
  field HandlerName as character
  field HandlerId   as integer
  index Main is primary unique
    HandlerName
    .

define temp-table ttQueryWindowExport no-undo
  &IF proversion >= '11.2':U &THEN
    serialize-name 'QueryWindow':U
  &ELSE
    xml-node-name 'QueryWindow':U
  &ENDIF
  field QuerySeq             as integer
    &IF proversion >= '11.2':U &THEN
      serialize-name 'QueryId':U
    &ELSE
      xml-node-name 'QueryId':U
    &ENDIF
    column-label 'Id':T
  field WindowMode           as character
  field WindowState          as character
  field QueryText            as character
  field WindowWidth          as decimal
  field WindowHeight         as decimal
  field WindowColumn         as decimal
  field WindowRow            as decimal
  field BrowseColumns        as character init ?
  field HideFieldList        as logical   init ?
  field Splitter1Pos         as integer   init ?
  field RecordBrowseColumns  as character init ?
  field RecordBrowseFields   as character init ?
  field DisplayRawValues     as logical   init ?
  field ObjSourceQuerySeq    as integer
  field ObjSourceBufferName  as character
  field ObjSourceFieldName   as character
  field ObjSourceFieldIndex  as integer
  field DeepResolveObjectIds as logical
  field NewQuerySeq          as integer
    &IF proversion >= '11.2':U &THEN
      serialize-hidden
    &ELSE
      xml-node-type 'HIDDEN':U
    &ENDIF
  field WindowSelected       as logical
    initial yes
    column-label '':U
    &IF proversion >= '11.2':U &THEN
      serialize-hidden
    &ELSE
      xml-node-type 'HIDDEN':U
    &ENDIF
  field BufferList           as character
    format 'x(120)':U
    column-label 'Buffers':T
    &IF proversion >= '11.2':U &THEN
      serialize-hidden
    &ELSE
      xml-node-type 'HIDDEN':U
    &ENDIF
  index Main is primary unique
    QuerySeq
  index WindowSelected
    WindowSelected
    QuerySeq
    .

define temp-table ttQueryBufferExport no-undo
  &IF proversion >= '11.2':U &THEN
    serialize-name 'QueryBuffer':U
  &ELSE
    xml-node-name 'QueryBuffer':U
  &ENDIF
  field QuerySeq       as integer
    &IF proversion >= '11.2':U &THEN
      serialize-hidden
    &ELSE
      xml-node-type 'HIDDEN':U
    &ENDIF
  field BufferId       as integer
  field DatabaseName   like ttDatabase.DatabaseName
  field TableName      like ttTable.TableName
  field BufferName     as character
  index Main is primary unique
    QuerySeq
    BufferId
  index BufferName is unique
    QuerySeq
    BufferName
    .

define temp-table ttQueryFieldOverlayExport no-undo
  &IF proversion >= '11.2':U &THEN
    serialize-name 'FieldOverlay':U
  &ELSE
    xml-node-name 'FieldOverlay':U
  &ENDIF
  field QuerySeq    as integer
    &IF proversion >= '11.2':U &THEN
      serialize-hidden
    &ELSE
      xml-node-type 'HIDDEN':U
    &ENDIF
  field BufferId    as integer
    &IF proversion >= '11.2':U &THEN
      serialize-hidden
    &ELSE
      xml-node-type 'HIDDEN':U
    &ENDIF
  field FieldName   like ttField.FieldName
  field FieldIndex  as integer
  field OverlayType as character
    xml-node-type 'ATTRIBUTE':U
  index Main is primary unique
    QuerySeq
    BufferId
    FieldName
    FieldIndex
    .

define temp-table ttRecentQueryExport no-undo
  &IF proversion >= '11.2':U &THEN
    serialize-name 'QueryHistory':U
  &ELSE
    xml-node-name 'QueryHistory':U
  &ENDIF
  field QuerySeq   as integer
    &IF proversion >= '11.2':U &THEN
      serialize-name 'QueryId':U
    &ELSE
      xml-node-name 'QueryId':U
    &ENDIF
  field Order      as integer
  field QueryText  as character
  index Main is primary unique
    QuerySeq
    Order
    .

define dataset dsQueryWindowExport
  &IF proversion >= '11.2':U &THEN
    serialize-name 'QueryScenario':U
  &ELSE
    xml-node-name 'QueryScenario':U
  &ENDIF
  for ttQueryWindowExport, ttQueryBufferExport, ttQueryFieldOverlayExport,
    ttRecentQueryExport
  data-relation QueryBuffer for ttQueryWindowExport, ttQueryBufferExport
    relation-fields(QuerySeq, QuerySeq)
    nested
  data-relation FieldOverlay for ttQueryBufferExport, ttQueryFieldOverlayExport
    relation-fields(QuerySeq, QuerySeq, BufferId, BufferId)
    nested
  data-relation RecentQuery for ttQueryWindowExport, ttRecentQueryExport
    relation-fields(QuerySeq, QuerySeq)
    nested
    .

define temp-table ttPersistentProcedure no-undo
  field ProcedureName as character
    format 'x(255)':U
    column-label 'Procedure':T
  index Main is primary unique
    ProcedureName
    .

define temp-table ttPersistentTempTable no-undo
  field ProcedureName like ttPersistentProcedure.ProcedureName
  field TableHandle   as handle
  field TableName     like ttTable.TableName
  index Main is primary unique
    ProcedureName
    TableHandle
  index TableName
    ProcedureName
    TableName
    .

define temp-table ttQueryAST no-undo
  field Id           as integer
  field ParentId     as integer
  field TokenStart   as integer
  field TokenEnd     as integer
  field TokenType    as integer
  field NodeType     as integer
  field TokenText    as character
    format 'x(255)':U
  field Level        as integer
  index Main is primary unique
    Id
  index ParentId
    ParentId
    TokenStart
    TokenEnd
  index TokenType
    TokenType
    TokenStart
    TokenEnd
    TokenText
  index NodeType
    NodeType
    TokenStart
    TokenEnd
    TokenText
  index TokenStart
    TokenStart
    TokenEnd
    TokenType
    TokenText
    .

define temp-table ttQueryCondition no-undo
  field StartPos           as integer
  field EndPos             as integer
  field LeftStartPos       as integer
  field LeftEndPos         as integer
  field ComparatorStartPos as integer
  field ComparatorEndPos   as integer
  field RightStartPos      as integer
  field RightEndPos        as integer
  index Main is primary unique
    StartPos
  EndPos
  index LeftStartPos
    LeftStartPos
    LeftEndPos
  index LeftEndPos
    LeftEndPos
    LeftStartPos
  index ComparatorStartPos
    ComparatorStartPos
    ComparatorEndPos
  index ComparatorEndPos
    ComparatorEndPos
    ComparatorStartPos
  index RightStartPos
    RightStartPos
    RightEndPos
  index RightEndPos
    RightEndPos
    RightStartPos
    .

define temp-table ttQueryLine no-undo
  field LineNo          as integer
  field StartPos        as integer
  field EndPos          as integer
  field ExceedingToken  as logical
  field LineLevel       as integer
  field LineIndentation as integer
  index Main is primary unique
    LineNo.

{adecomm/oeideservice.i}


&IF {&PROCESS-ARCHITECTURE} = 64 &THEN
  procedure SetForegroundWindow external 'user32.dll':U:
    define input  parameter hwnd    as int64 no-undo.
  end procedure.
&ELSE
  procedure SetForegroundWindow external 'user32.dll':U:
    define input  parameter hwnd    as long no-undo.
  end procedure.
&ENDIF

procedure GetKeyState external 'user32.dll':U:
    define input  parameter iVirtKey as long      no-undo.
    define return parameter iResult  as short     no-undo.
end procedure.

procedure ExpandEnvironmentStringsA external "kernel32.dll":
  define input  parameter cString        as character no-undo.
  define output parameter cRetString     as character no-undo.
  define input  parameter iStringSize    as long      no-undo.
  define return parameter iRetStringSize as long      no-undo.
end procedure.

&IF {&PROCESS-ARCHITECTURE} = 64 &THEN
  procedure RegOpenKeyExA external 'advapi32':U:
    define input  parameter iKey       as long      no-undo.
    define input  parameter cSubKey    as character no-undo.
    define input  parameter iOptions   as long      no-undo.
    define input  parameter iDesired   as long      no-undo.
    define output parameter iResult    as int64     no-undo.
    define return parameter iRetResult as int64     no-undo.
  end procedure.
&ELSE
  procedure RegOpenKeyExA external 'advapi32':U:
    define input  parameter iKey       as long      no-undo.
    define input  parameter cSubKey    as character no-undo.
    define input  parameter iOptions   as long      no-undo.
    define input  parameter iDesired   as long      no-undo.
    define output parameter iResult    as long      no-undo.
    define return parameter iRetResult as long      no-undo.
  end procedure.
&ENDIF

&IF {&PROCESS-ARCHITECTURE} = 64 &THEN
  procedure RegQueryValueExA external 'advapi32':U:
    define input  parameter ikey         as long      no-undo.
    define input  parameter iPValueName  as character no-undo.
    define input  parameter iPdwReserved as long      no-undo.
    define output parameter iPdwType     as long      no-undo.
    define input  parameter iPbData      as int64     no-undo.
    define output parameter iPcbData     as long      no-undo.
    define return parameter iPResult     as long      no-undo.
  end procedure.
&ELSE
  procedure RegQueryValueExA external 'advapi32':U:
    define input  parameter ikey         as long      no-undo.
    define input  parameter iPValueName  as character no-undo.
    define input  parameter iPdwReserved as long      no-undo.
    define output parameter iPdwType     as long      no-undo.
    define input  parameter iPbData      as long      no-undo.
    define output parameter iPcbData     as long      no-undo.
    define return parameter iPResult     as long      no-undo.
  end procedure.
&ENDIF

procedure RegCloseKey external 'advapi32':U:
  define input  parameter iKey     as long      no-undo.
  define return parameter iPResult as long      no-undo.
end procedure.

&IF {&PROCESS-ARCHITECTURE} = 64 &THEN
  procedure GetParent external 'user32.dll':U:
     define input  parameter plHWND    as int64     no-undo.
     define return parameter plWinLong as long      no-undo.
  end procedure.
&ELSE
  procedure GetParent external 'user32.dll':U:
     define input  parameter plHWND    as long      no-undo.
     define return parameter plWinLong as long      no-undo.
end procedure.
&ENDIF

&IF {&PROCESS-ARCHITECTURE} = 64 &THEN
  procedure GetWindowRect external 'user32.dll':U:
    define input  parameter hWnd    as int64     no-undo.
    define output parameter lpRect  as memptr    no-undo.
    define return parameter iResult as long      no-undo.
  end procedure.
&ELSE
  procedure GetWindowRect external 'user32.dll':U:
    define input  parameter hWnd    as long      no-undo.
    define output parameter lpRect  as memptr    no-undo.
    define return parameter iResult as long      no-undo.
  end procedure.
&ENDIF

&IF {&PROCESS-ARCHITECTURE} = 64 &THEN
  procedure GetWindowLongA external 'user32.dll':U:
    define input  parameter phwnd       as int64      no-undo.
    define input  parameter cindex      as long      no-undo.
    define return parameter ReturnValue as long      no-undo.
  end procedure.
&ELSE
  procedure GetWindowLongA external 'user32.dll':U:
    define input  parameter phwnd       as long      no-undo.
    define input  parameter cindex      as long      no-undo.
    define return parameter ReturnValue as long      no-undo.
  end procedure.
&ENDIF

&IF {&PROCESS-ARCHITECTURE} = 64 &THEN
  procedure SetWindowLongA external 'user32.dll':U:
    define input  parameter hWnd         as int64         no-undo.
    define input  parameter nIndex       as long          no-undo.
    define input  parameter dwNewLong    as unsigned-long no-undo.
    define return parameter ReturnValue  as long          no-undo.
  end procedure.
&ELSE
  procedure SetWindowLongA external 'user32.dll':U:
    define input  parameter hWnd         as long          no-undo.
    define input  parameter nIndex       as long          no-undo.
    define input  parameter dwNewLong    as unsigned-long no-undo.
    define return parameter ReturnValue  as long          no-undo.
  end procedure.
&ENDIF

&IF {&PROCESS-ARCHITECTURE} = 64 &THEN
  procedure SetWindowPos external 'user32.dll':U:
    define input  parameter hWnd            as int64         no-undo.
    define input  parameter hWndInsertAfter as int64         no-undo.
    define input  parameter X               as long          no-undo.
    define input  parameter Y               as long          no-undo.
    define input  parameter cx              as long          no-undo.
    define input  parameter cy              as long          no-undo.
    define input  parameter uFlags          as long          no-undo.
    define return parameter ReturnValue     as long          no-undo.
  end procedure.
&ELSE
  procedure SetWindowPos external 'user32.dll':U:
    define input  parameter hWnd            as long          no-undo.
    define input  parameter hWndInsertAfter as long          no-undo.
    define input  parameter X               as long          no-undo.
    define input  parameter Y               as long          no-undo.
    define input  parameter cx              as long          no-undo.
    define input  parameter cy              as long          no-undo.
    define input  parameter uFlags          as long          no-undo.
    define return parameter ReturnValue     as long          no-undo.
  end procedure.
&ENDIF

&IF {&PROCESS-ARCHITECTURE} = 64 &THEN
  procedure ShellExecuteA external 'shell32.dll':U:
    define input  parameter hwnd         as int64. /* Handle to parent window */
    define input  parameter lpOperation  as char.  /* Operation to perform: open, print */
    define input  parameter lpFile       as char.  /* Document or executable name */
    define input  parameter lpParameters as char.  /* Command line parameters to executable in lpFile */
    define input  parameter lpDirectory  as char.  /* Default directory */
    define input  parameter nShowCmd     as long.  /* whether shown when opened: */
                                                   /* 0 hidden, 1 normal, minimized 2, maximized 3, etc.*/
                                                   /* 0 if lpFile is a document */
    define return parameter hInstance    as long.  /* >32 -> Success ; <=32 -> Errorcode */
  end procedure.
&ELSE
  procedure ShellExecuteA external 'shell32.dll':U:
    define input  parameter hwnd         as long. /* Handle to parent window */
    define input  parameter lpOperation  as char. /* Operation to perform: open, print */
    define input  parameter lpFile       as char. /* Document or executable name */
    define input  parameter lpParameters as char. /* Command line parameters to executable in lpFile */
    define input  parameter lpDirectory  as char. /* Default directory */
    define input  parameter nShowCmd     as long. /* whether shown when opened: */
                                                  /* 0 hidden, 1 normal, minimized 2, maximized 3, etc.*/
                                                  /* 0 if lpFile is a document */
    define return parameter hInstance    as long. /* >32 -> Success ; <=32 -> Errorcode */
  end procedure.
&ENDIF

&IF {&PROCESS-ARCHITECTURE} = 64 &THEN
  procedure FindWindowA external "user32.dll":
    define input  parameter iClassName as long.
    define input  parameter cCaption   as character.
    define return parameter iHandle    as int64.
  end procedure.
&ELSE
  procedure FindWindowA external "user32.dll":
    define input  parameter iClassName as long.
    define input  parameter cCaption   as character.
    define return parameter iHandle    as long.
  end procedure.
&ENDIF

&IF {&PROCESS-ARCHITECTURE} = 64 &THEN
  procedure SetFocus external "user32.dll":
    define input  parameter hWnd     as int64         no-undo.
    define return parameter hPrevWnd as long          no-undo.
  end procedure.
&ELSE
  procedure SetFocus external "user32.dll":
    define input  parameter hWnd as long          no-undo.
    define return parameter hPrevWnd as long          no-undo.
  end procedure.
&ENDIF

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-PREPROCESSOR-BLOCK 

/* ********************  Preprocessor Definitions  ******************** */

&Scoped-define PROCEDURE-TYPE Window
&Scoped-define DB-AWARE no

/* Name of designated FRAME-NAME and/or first browse and/or first query */
&Scoped-define FRAME-NAME fQuery
&Scoped-define BROWSE-NAME brDatabase

/* Internal Tables (found by Frame, Query & Browse Queries)             */
&Scoped-define INTERNAL-TABLES ttDatabase ttField ttIndex ~
ttTableRelationView ttTable

/* Definitions for BROWSE brDatabase                                    */
&Scoped-define FIELDS-IN-QUERY-brDatabase ttDatabase.DatabaseName ttDatabase.PhysicalName   
&Scoped-define ENABLED-FIELDS-IN-QUERY-brDatabase   
&Scoped-define SELF-NAME brDatabase
&Scoped-define QUERY-STRING-brDatabase FOR EACH ttDatabase WHERE true   NO-LOCK   BY ttDatabase.DisplayPriority BY ttDatabase.DatabaseName
&Scoped-define OPEN-QUERY-brDatabase OPEN QUERY brDatabase FOR EACH ttDatabase WHERE true   NO-LOCK   BY ttDatabase.DisplayPriority BY ttDatabase.DatabaseName.
&Scoped-define TABLES-IN-QUERY-brDatabase ttDatabase
&Scoped-define FIRST-TABLE-IN-QUERY-brDatabase ttDatabase


/* Definitions for BROWSE brField                                       */
&Scoped-define FIELDS-IN-QUERY-brField ttField.FieldName ttField.IsVirtual ttField.DataType ttField.FieldExtent ttField.FieldDecimals ttField.FieldInitialValue ttField.FieldFormat ttField.FieldLabel ttField.FieldColumnLabel ttField.IsMandatory ttField.Domain   
&Scoped-define ENABLED-FIELDS-IN-QUERY-brField   
&Scoped-define SELF-NAME brField
&Scoped-define QUERY-STRING-brField FOR EACH ttField WHERE true and ttField.DatabaseName = ttDatabase.DatabaseName and ttField.TableName = ttTable.TableName and ttField.FieldFilterMatches = yes and ( glShowVirtualFields    or ttField.IsVirtual <> yes )  NO-LOCK
&Scoped-define OPEN-QUERY-brField OPEN QUERY brField FOR EACH ttField WHERE true and ttField.DatabaseName = ttDatabase.DatabaseName and ttField.TableName = ttTable.TableName and ttField.FieldFilterMatches = yes and ( glShowVirtualFields    or ttField.IsVirtual <> yes )   NO-LOCK.
&Scoped-define TABLES-IN-QUERY-brField ttField
&Scoped-define FIRST-TABLE-IN-QUERY-brField ttField


/* Definitions for BROWSE brIndex                                       */
&Scoped-define FIELDS-IN-QUERY-brIndex ttIndex.IsPrimary ttIndex.IndexName ttIndex.IsUnique ttIndex.IsVirtual ttIndex.IndexFields   
&Scoped-define ENABLED-FIELDS-IN-QUERY-brIndex   
&Scoped-define SELF-NAME brIndex
&Scoped-define QUERY-STRING-brIndex FOR EACH ttIndex WHERE true   AND ttIndex.DatabaseName = ttDatabase.DatabaseName   and ttIndex.TableName = ttTable.TableName   AND ttIndex.IndexFilterMatches = yes   AND ttIndex.IndexFieldFilterMatches = yes  and ( glShowVirtualIndices    or ttIndex.IsVirtual <> yes )   NO-LOCK
&Scoped-define OPEN-QUERY-brIndex OPEN QUERY brIndex FOR EACH ttIndex WHERE true   AND ttIndex.DatabaseName = ttDatabase.DatabaseName   and ttIndex.TableName = ttTable.TableName   AND ttIndex.IndexFilterMatches = yes   AND ttIndex.IndexFieldFilterMatches = yes  and ( glShowVirtualIndices    or ttIndex.IsVirtual <> yes )   NO-LOCK.
&Scoped-define TABLES-IN-QUERY-brIndex ttIndex
&Scoped-define FIRST-TABLE-IN-QUERY-brIndex ttIndex


/* Definitions for BROWSE brRelation                                    */
&Scoped-define FIELDS-IN-QUERY-brRelation ttTableRelationView.RelatedTableName ttTableRelationView.RelationType ttTableRelationView.ParentRelation ttTableRelationView.RelatedFields ttTableRelationView.FieldDetails  
&Scoped-define ENABLED-FIELDS-IN-QUERY-brRelation   
&Scoped-define SELF-NAME brRelation
&Scoped-define QUERY-STRING-brRelation FOR EACH ttTableRelationView WHERE true   AND ttTableRelationView.DatabaseName = ttDatabase.DatabaseName   and ttTableRelationView.ReferenceTableName = ttTable.TableName   AND ttTableRelationView.TableFilterMatches = yes   AND ttTableRelationView.FieldFilterMatches = yes   NO-LOCK
&Scoped-define OPEN-QUERY-brRelation OPEN QUERY brRelation FOR EACH ttTableRelationView WHERE true   AND ttTableRelationView.DatabaseName = ttDatabase.DatabaseName   and ttTableRelationView.ReferenceTableName = ttTable.TableName   AND ttTableRelationView.TableFilterMatches = yes   AND ttTableRelationView.FieldFilterMatches = yes   AND ttTableRelationView.ParentRelationFilterMatches = yes   NO-LOCK.
&Scoped-define TABLES-IN-QUERY-brRelation ttTableRelationView
&Scoped-define FIRST-TABLE-IN-QUERY-brRelation ttTableRelationView


/* Definitions for BROWSE brTable                                       */
&Scoped-define FIELDS-IN-QUERY-brTable ttTable.TableName ttTable.ShortDescription  
&Scoped-define ENABLED-FIELDS-IN-QUERY-brTable   
&Scoped-define SELF-NAME brTable
&Scoped-define QUERY-STRING-brTable FOR EACH ttTable WHERE true   AND ttTable.DatabaseName = ttDatabase.DatabaseName   AND ttTable.TableFilterMatches = yes   AND ttTable.TableFieldFilterMatches = yes   AND (glShowHiddenTables     OR (  not can-do('sys*':U, ~
       ttTable.TableName)       and not can-do('_*':U, ~
       ttTable.TableName)))   NO-LOCK
&Scoped-define OPEN-QUERY-brTable OPEN QUERY brTable FOR EACH ttTable WHERE true   AND ttTable.DatabaseName = ttDatabase.DatabaseName   AND ttTable.TableFilterMatches = yes   AND ttTable.TableFieldFilterMatches = yes   AND (glShowHiddenTables     OR (  not can-do('sys*':U, ~
       ttTable.TableName)       and not can-do('_*':U, ~
       ttTable.TableName)))   NO-LOCK.
&Scoped-define TABLES-IN-QUERY-brTable ttTable
&Scoped-define FIRST-TABLE-IN-QUERY-brTable ttTable


/* Definitions for FRAME fQuery                                         */

/* Standard List Definitions                                            */
&Scoped-Define ENABLED-OBJECTS gdIndexUsage btnClearFieldLabelFilter ~
gcFieldLabelFilter gcFieldDummy brDatabase btnConnectDB btnDisconnectDB ~
btnRefresh gcTableFilter btnClearTableFilter gcTableFieldFilter ~
btnClearTableFieldFilter brTable giDisplayMode glInvertQuery gcFieldFilter ~
btnClearFieldFilter brField gcIndexFilter btnClearIndexFilter ~
gcIndexFieldFilter btnClearIndexFieldFilter brIndex gcBufferName ~
btnClearBufferPattern btnBuffer1 btnBuffer2 btnBuffer3 btnBuffer4 ~
glDefineBuffer glCompanyViaClass glExclusiveLock glNoError glIfStatement ~
glNot glDoBlock glOnError giOnErrorPhrase giQueryTypeModifier gcBlockName btnClearBlockName ~
btnBlock1 btnBlock2 btnBlock3 btnBlock4 glDefineBlock glRetryBlock ~
glFinallyBlock giQueryType btnCopyToClipboard btnExecuteQuery btnResetAll ~
btnIncreaseIndentation btnDecreaseIndentation btnResetIndentation btnOf ~
gcQueryText brRelation gcRelationFilter gcRelationFieldFilter ~
btnClearRelationFilter btnClearRelationFieldFilter glDefineVariables ~
glUseVirtualIndexIncludes
&Scoped-Define DISPLAYED-OBJECTS gdIndexUsage gcFieldLabelFilter ~
gcFieldDummy gcTableFilter gcTableFieldFilter giDisplayMode glInvertQuery gcFieldFilter ~
gcIndexFilter gcIndexFieldFilter gcBufferName glDefineBuffer ~
glCompanyViaClass glExclusiveLock glNoError glIfStatement glNot glDoBlock ~
giOnErrorPhrase glOnError giQueryTypeModifier gcBlockName glDefineBlock glRetryBlock ~
glFinallyBlock giQueryType gcQueryText gcRelationFilter ~
gcRelationFieldFilter glDefineVariables glUseVirtualIndexIncludes

/* Custom List Definitions                                              */
/* List-1,List-2,List-3,List-4,List-5,List-6                            */

/* _UIB-PREPROCESSOR-BLOCK-END */
&ANALYZE-RESUME


/* ************************  Function Prototypes ********************** */

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cBeautifyQueryText hQueryWindow 
FUNCTION qg_cBeautifyQueryText returns character
  ( pcQueryText as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cBrowseColumnList hQueryWindow 
FUNCTION qg_cBrowseColumnList returns character
  ( phBrowse      as handle,
    plBuffernames as logical,
    plAllColumns  as logical,
    plColumnWidth as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_clBrowseValues hQueryWindow 
FUNCTION qg_clBrowseValues returns longchar
  ( phBrowse    as handle,
    plRawValues as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cBufferCompare hQueryWindow 
FUNCTION qg_cBufferCompare returns character
  ( phBuffer1 as handle,
    phBuffer2 as handle ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cColumnFieldName hQueryWindow 
FUNCTION qg_cColumnFieldName returns character
  ( phColumn      as handle,
    plBuffernames as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cCreateQueryText hQueryWindow 
FUNCTION qg_cCreateQueryText returns character
  ( pcFieldList as character,
    plAddTags   as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cCreateRelationValueList hQueryWindow 
FUNCTION qg_cCreateRelationValueList returns character
  ( pcFieldList  as character,
    piRelationId as integer,
    pcBufferName as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cCreateRelatedWhereClause hQueryWindow 
FUNCTION qg_cCreateRelatedWhereClause returns character
  ( buffer pbttTableRelation for ttTableRelation,
    plParent           as logical,
    pcBufferName       as character,
    pcParentBufferName as character,
    piParentQuerySeq   as integer ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cCreateWhereClause hQueryWindow 
FUNCTION qg_cCreateWhereClause returns character
  ( pcDatabaseName   as character,
    pcTableName      as character,
    pcBufferName     as character,
    pcFieldList      as character,
    pcFieldLabelList as character,
    plStartWithWhere as logical, 
    piValueMode      as integer,
    pcValueList      as character,
    piAccessMode     as integer,
    plAddTags        as logical,
    piIndentBlanks   as integer ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cCurrentFieldList hQueryWindow 
FUNCTION qg_cCurrentFieldList returns character
  (  ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cExtractFieldName hQueryWindow 
FUNCTION qg_cExtractFieldName returns character
  ( pcFieldName as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cFieldAssignments hQueryWindow 
FUNCTION qg_cFieldAssignments returns character
  ( plInsertMode as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cFieldAssignStatement hQueryWindow 
FUNCTION qg_cFieldAssignStatement returns character
  ( plInsertMode as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cFieldValues hQueryWindow 
FUNCTION qg_cFieldValues returns character
  ( phBuffer    as handle,
    phOldBuffer as handle,
    pcFieldList as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cFileName hQueryWindow
function qg_cFileName returns character 
  (pcFilename as character) forward.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME



&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cFilterEntryMatchcode hQueryWindow 
FUNCTION qg_cFilterEntryMatchcode returns character
  ( pcFilterEntry as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cFixQuerySeq hQueryWindow 
FUNCTION qg_cFixQuerySeq returns character
  ( pcQuerytext as character,
    piQuerySeq  as integer ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cFormattedFieldName hQueryWindow 
FUNCTION qg_cFormattedFieldName returns character
  ( pcDatabaseName as character,
    pcTableName    as character,
    pcFieldName    as character,
    piIndex        as integer ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cGetBufferBaseName hQueryWindow 
FUNCTION qg_cGetBufferBaseName returns character
  ( plCustomBuffer as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cGetCompany hQueryWindow 
FUNCTION qg_cGetCompany returns character
  ( pcTableName as character,
    pcCompany   as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cGetCompanyInclude hQueryWindow 
FUNCTION qg_cGetCompanyInclude returns character
  ( pcTableName as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cGetDefaultValue hQueryWindow 
FUNCTION qg_cGetDefaultValue returns character
  ( pcDatatype as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cGetFieldAssignmentsStatement hQueryWindow 
FUNCTION qg_cGetFieldAssignmentsStatement returns character
  ( pcDatabaseName as character,
    pcTableName    as character,
    pcBufferName   as character,
    pcFieldList    as character,
    piValueMode    as integer,
    pcValueList    as character,
    plAddTags      as logical,
    piIndentBlanks as integer ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cGetPrimaryKeyValues hQueryWindow 
FUNCTION qg_cGetPrimaryKeyValues returns character
  ( phBuffer            as handle,
    pcSplitter          as character,
    plResolveObjectIds  as logical,
    plIncludeFieldNames as logical,
    plIncludeCompany    as logical,
    plQuoteValues       as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cGetPutStatement hQueryWindow 
FUNCTION qg_cGetPutStatement returns character
  ( pcDatabaseName as character,
    pcTableName    as character,
    pcBufferName   as character,
    pcFieldList    as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cGetRelationField hQueryWindow 
FUNCTION qg_cGetRelationField returns character
  ( buffer pbttTableRelation      for ttTableRelation,
    buffer pbttTableRelationField for ttTableRelationField,
    pcBufferName    as character,
    plParentValue   as logical,
    plKeyAllowed    as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cGetSelectedFields hQueryWindow 
FUNCTION qg_cGetSelectedFields returns character
  ( pcBufferName as character,
    pcSeparator  as character,
    plQuoted     as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cIndexFieldValues hQueryWindow 
FUNCTION qg_cIndexFieldValues returns character
  ( phBuffer    as handle,
    pcIndexName as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cMaximumDataTypeFormat hQueryWindow
function qg_cMaximumDataTypeFormat returns character 
  ( pcDataType as character,
    piDecimals as integer ) forward.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cModulePathByChar hQueryWindow
function qg_cModulePathByChar returns character 
  ( pcChar as character ) forward.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME



&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cOverlayFieldValue hQueryWindow 
FUNCTION qg_cOverlayFieldValue returns character
  ( buffer pbttFieldOverlay for ttFieldOverlay,
    pcFieldValue as character,
    plDeep       as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cParamListReadValue hQueryWindow 
FUNCTION qg_cParamListReadValue returns character
  ( pcParamList as character,
    pcParamName as character,
    pcSplitter  as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cParamListWriteCharacter hQueryWindow 
FUNCTION qg_cParamListWriteCharacter returns character
  ( pcParamList  as character,
    pcParamName  as character,
    pcParamValue as character,
    pcSplitter   as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cParamListWriteDecimal hQueryWindow 
FUNCTION qg_cParamListWriteDecimal returns character
  ( pcParamList  as character,
    pcParamName  as character,
    pdParamValue as decimal,
    pcSplitter   as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cParamListWriteInteger hQueryWindow 
FUNCTION qg_cParamListWriteInteger returns character
  ( pcParamList  as character,
    pcParamName  as character,
    piParamValue as integer,
    pcSplitter   as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cParamListWriteLogical hQueryWindow 
FUNCTION qg_cParamListWriteLogical returns character
  ( pcParamList  as character,
    pcParamName  as character,
    plParamValue as logical,
    pcSplitter   as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cPutStatement hQueryWindow 
FUNCTION qg_cPutStatement returns character
  ( plInsertMode as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cQueryIndexInfo hQueryWindow 
FUNCTION qg_cQueryIndexInfo returns character
  ( pcDatabaseName as character,
    pcTableName    as character,
    pcQueryText    as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cQueryLabel hQueryWindow 
FUNCTION qg_cQueryLabel returns character
  ( pcQueryText as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cQueryLabel hQueryWindow 
FUNCTION qg_cQueryWindowFieldList returns character
  ( phWindow      as handle,
    plBuffernames as logical,
    plAllFields   as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cReadRegistryValue hQueryWindow 
FUNCTION qg_cReadRegistryValue returns character
  ( piSection as integer,
    pcSubKey  as character,
    pcKeyName as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cReadRegistryValue hQueryWindow 
FUNCTION qg_cReplaceColumn returns character
  ( pcColumnList as character,
    pcColumn     as character,
    pcNewColumn  as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cResolveObjectId hQueryWindow 
FUNCTION qg_cResolveObjectId returns character
  ( pcDatabaseName as character,
    pcFieldName    as character,
    pcObjectId     as character,
    plForceQuote   as logical,
    plDeep         as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cResolveObjectIdForBuffer hQueryWindow 
FUNCTION qg_cResolveObjectIdForBuffer returns character
  ( pcObjectId   as character,
    phBuffer     as handle,
    plTable      as logical,
    plForceQuote as logical,
    plDeep       as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cSoundexCode hQueryWindow 
FUNCTION qg_cSoundexCode returns character
  ( pcText as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cStacktrace hQueryWindow 
FUNCTION qg_cStacktrace returns character
  (  )  FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cSubstituteChar hQueryWindow 
FUNCTION qg_cSubstituteChar returns character
  ( pcString   as character,
    pcFromChar as character,
    pcToChar   as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cSubstituteLinkTokens hQueryWindow 
FUNCTION qg_cSubstituteLinkTokens returns character
  ( pcText          as character,
    piTargetSeq     as integer,
    phLinkTempTable as handle ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cSubstituteQueryLinkTokens hQueryWindow 
FUNCTION qg_cSubstituteQueryLinkTokens returns character
  ( phWindow as handle ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cTaggedValue hQueryWindow 
FUNCTION qg_cTaggedValue returns character
  ( pcText   as character,
    plAddTag as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cTTWidgetPool hQueryWindow 
FUNCTION qg_cTTWidgetPool returns character
  (  ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_dIndexUsage hQueryWindow 
FUNCTION qg_dIndexUsage returns decimal
  ( pcDatabaseName as character,
    pcTableName    as character,
    pcIndexName    as character,
    pcFieldList    as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_dParamListReadValue hQueryWindow 
FUNCTION qg_dParamListReadValue returns decimal
  ( pcParamList as character,
    pcParamName as character,
    pcSplitter  as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_hGetWidgetByName hQueryWindow 
FUNCTION qg_hGetWidgetByName returns handle
  ( phContainer  as handle,
    pcWidgetName as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_hStartSessionTrigger hQueryWindow 
FUNCTION qg_hStartSessionTrigger returns handle
  ( piTriggerId as integer ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_iExtractIndex hQueryWindow 
FUNCTION qg_iExtractIndex returns integer
  ( pcFieldName as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_iFilterSeq hQueryWindow 
FUNCTION qg_iFilterSeq returns integer
  (  ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_iGetHandlerId hQueryWindow 
FUNCTION qg_iGetHandlerId returns integer
  ( pcHandlerName as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_iParamListReadValue hQueryWindow 
FUNCTION qg_iParamListReadValue returns integer
  ( pcParamList as character,
    pcParamName as character,
    pcSplitter  as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_lcClipboardValue hQueryWindow 
FUNCTION qg_lcClipboardValue returns longchar
  (  ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_lCheckLinkReference hQueryWindow 
FUNCTION qg_lCheckLinkReference returns logical
  ( piQuerySeq     as integer,
    pcQuerySeqList as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION qg_lIsHostReachable hQueryWindow 
FUNCTION qg_lIsHostReachable returns logical
  ( pcHost    as character, 
    pcService as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_lParamListReadValue hQueryWindow 
FUNCTION qg_lParamListReadValue returns logical
  ( pcParamList as character,
    pcParamName as character,
    pcSplitter  as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_lQueryOpen hQueryWindow 
FUNCTION qg_lQueryOpen returns logical
  ( phQuery        as handle,
    pcQueryText    as character,
    phParentWindow as handle ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_lSelectNextQueryCondition hQueryWindow 
FUNCTION qg_lSelectNextQueryCondition returns logical
  ( phEditor as handle,
    plNext   as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_lTestBits hQueryWindow 
FUNCTION qg_lTestBits returns logical
  ( piTestValue as integer,
    piRefValue  as integer ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_lUniqueQuery hQueryWindow 
FUNCTION qg_lUniqueQuery returns logical
  ( pcDatabaseName as character,
    pcTableName    as character,
    pcFieldList    as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


/* ***********************  Control Definitions  ********************** */

/* Define the widget handle for the window                              */
DEFINE VAR hQueryWindow AS WIDGET-HANDLE NO-UNDO.

/* Menu Definitions                                                     */
DEFINE SUB-MENU m_File 
       MENU-ITEM mi_SaveQueryScenario LABEL "Save query scenario"
       MENU-ITEM mi_LoadQueryScenario LABEL "Load query scenario"
       RULE
       MENU-ITEM mi_Exit        LABEL "Exit"          .

DEFINE SUB-MENU m_Edit 
       MENU-ITEM mi_CopyQueryText LABEL "Copy query text"
       MENU-ITEM mi_InsertQueryText LABEL "Insert query text"
       RULE
       MENU-ITEM mi_CopyQueryScenario LABEL "Copy query scenario"
       MENU-ITEM mi_PasteQueryScenario LABEL "Paste query scenario".

DEFINE SUB-MENU m_Tools 
       MENU-ITEM mi_ExecuteQuery LABEL "Execute query"  ACCELERATOR "F2"
       MENU-ITEM mi_FindObjectIdRecord LABEL "Find object id record"  ACCELERATOR "SHIFT-F2"
       RULE
       MENU-ITEM mi_AddPersistentTempTable LABEL "Add persistent temp table" ACCELERATOR "F9"
       MENU-ITEM mi_AddSnapshot LABEL "Add snpapshot"  ACCELERATOR "F10"
       RULE
       MENU-ITEM mi_ImportTDF LABEL "Import TDF as Snapshot"
       MENU-ITEM mi_ImportPDS LABEL "Import PDS as Snapshot"
       RULE
       MENU-ITEM mi_ImportDatasetFile LABEL "Import Dataset File"
       MENU-ITEM mi_ImportTempTableFile LABEL "Import Temp-Table File"
       RULE
       MENU-ITEM mi_CopyQueryGeneratorSourcefilePath LABEL "Copy Query Generator Sourcefile Path"
       MENU-ITEM mi_CopyQueryGeneratorSource LABEL "Copy Query Generator Source"
       RULE
       MENU-ITEM mi_ResetAll    LABEL "Reset"          ACCELERATOR "F12".

DEFINE SUB-MENU m_Options 
       MENU-ITEM mi_InsertMode  LABEL "Insert mode"   
              TOGGLE-BOX
       RULE
       MENU-ITEM mi_ShowQueryTypeModifier  LABEL "Show Query type modifier"
              TOGGLE-BOX
       MENU-ITEM mi_AlwaysUseFindFirst  LABEL "Always use 'find first'"
              TOGGLE-BOX
       MENU-ITEM mi_AlwaysUseCanFindFirst  LABEL "Always use 'can-find first'"
              TOGGLE-BOX
       MENU-ITEM mi_UseVirtualIndexApi  LABEL "Use virtual index API"
              TOGGLE-BOX
       RULE
       MENU-ITEM mi_OpenQueryWindowPersistentTT LABEL "Open query window for persistent temp-tables"
              TOGGLE-BOX
       MENU-ITEM mi_OpenQueryWindowSnapshotTT LABEL "Open query window for snapshots"
              TOGGLE-BOX
       RULE
       MENU-ITEM mi_RepositoryLanguage LABEL "Repository Language".

DEFINE SUB-MENU m_Window 
       MENU-ITEM mi_SlimMode    LABEL "Slim mode"     
              TOGGLE-BOX
       MENU-ITEM mi_RestoreDefaultWindowSize LABEL "Restore default window size"
       RULE
       MENU-ITEM mi_OpenQueryWindowListWindow LABEL "Query windows" ACCELERATOR "CTRL-F7"
       MENU-ITEM mi_CloseAllQueryWindows LABEL "Close all query windows"
       RULE
       MENU-ITEM mi_SessionTriggers LABEL "Session triggers".

DEFINE SUB-MENU m_Help 
       MENU-ITEM mi_OpenQGWiki     LABEL "pA-Wiki (Query Generator)".
       MENU-ITEM mi_OpenPluginWiki LABEL "pA-Wiki (Query Generator Plugin)".
       RULE
       MENU-ITEM mi_About          LABEL "About Query Generator".

DEFINE MENU MENU-BAR-hQueryWindow MENUBAR
       SUB-MENU  m_File         LABEL "File"          
       SUB-MENU  m_Edit         LABEL "Edit"          
       SUB-MENU  m_Tools        LABEL "Tools"         
       SUB-MENU  m_Options      LABEL "Options"       
       SUB-MENU  m_Window       LABEL "Window"        
       SUB-MENU  m_Help         LABEL "Help"          .

DEFINE MENU POPUP-MENU-brDatabase 
       MENU-ITEM mi_CopyDatabaseName LABEL "Copy name"     
       MENU-ITEM mi_CopyPhysicalName LABEL "Copy physical name"
       RULE
       MENU-ITEM mi_ReconcileDatabaseSchema LABEL "Incremental Dump && Reconcile of Database Schema"
       MENU-ITEM mi_LoadDataDefinitions LABEL "Load data definitions (.df)"
       RULE
       MENU-ITEM mi_DataDictionary LABEL "Data Dictionary"
       MENU-ITEM mi_DataAdministration LABEL "Data Administration"
       RULE
       MENU-ITEM mi_ExportJSON LABEL "Export Dataset as JSON"
       MENU-ITEM mi_ExportXML LABEL "Export Dataset as XML".

DEFINE SUB-MENU m_SelectedFields 
       MENU-ITEM mi_CopyFieldAssignStatement LABEL "Copy assign statement"
       MENU-ITEM mi_CopyFieldAssignments LABEL "Copy field assignments"
       MENU-ITEM mi_CopyPutStatement LABEL "Copy put statement"
       RULE
       MENU-ITEM mi_CopyFieldNamesCommaSeparated LABEL "Copy names (comma separated)"
       MENU-ITEM mi_CopyFieldNamesSpaceSeparated LABEL "Copy names (space separated)"
       MENU-ITEM mi_CopyFieldNamesLineSeparated LABEL "Copy names (line separated)"
       RULE
       MENU-ITEM mi_SessionTriggerAddFieldsAssign LABEL "Add session triggers (assign)"
       MENU-ITEM mi_SessionTriggerRemoveFieldsAssign LABEL "Remove session triggers (assign)"
       RULE
       MENU-ITEM mi_FindFieldIndex LABEL "Find index for selected fields"
       MENU-ITEM mi_FindFieldTables LABEL "Find tables containing selected fields".

DEFINE MENU POPUP-MENU-brField 
       MENU-ITEM mi_CopyFieldName LABEL "Copy name"     
       MENU-ITEM mi_CopyFullFieldName LABEL "Copy name"     
       RULE
       MENU-ITEM mi_SelectAllFields LABEL "Selected all"  
       SUB-MENU  m_SelectedFields LABEL "Selected fields"
       RULE
       MENU-ITEM mi_CopyFieldInitialValue LABEL "Copy initial value"
       MENU-ITEM mi_CopyFieldFormat LABEL "Copy format"   
       MENU-ITEM mi_CopyFieldLabel LABEL "Copy label"    
       MENU-ITEM mi_CopyFieldColumnLabel LABEL "Copy column label"
       MENU-ITEM mi_CopyFieldDomain LABEL "Copy Domain"   
       RULE
       MENU-ITEM mi_SessionTriggerFieldAssign LABEL "Add session trigger (assign)"
       RULE
       MENU-ITEM mi_VirtualFields LABEL "Show Virtual Fields"
              TOGGLE-BOX
       RULE
       MENU-ITEM mi_FilterDataypes LABEL "Dataype filter".

DEFINE MENU POPUP-MENU-brIndex 
       MENU-ITEM mi_CopyIndexName LABEL "Copy name"     
       RULE
       MENU-ITEM mi_CopyIndexFields LABEL "Copy fields"   
       RULE
       MENU-ITEM mi_ModifyIndexQueryFields LABEL "Modify query fields"
       RULE
       MENU-ITEM mi_VirtualIndices LABEL "Show Virtual Indices"
              TOGGLE-BOX.

DEFINE MENU POPUP-MENU-brRelation 
       MENU-ITEM mi_CopyRelationTable LABEL "Copy table"     
       RULE
       MENU-ITEM mi_CopyRelationFields LABEL "Copy fields"   
       RULE
       MENU-ITEM mi_SwitchToRelatedTable LABEL "Swtich to related table".
       MENU-ITEM mi_ModifyRelationQueryFields LABEL "Modify query fields".
       RULE
       MENU-ITEM mi_ShowChildRelations LABEL "Show child relations"
              TOGGLE-BOX.
       MENU-ITEM mi_ShowParentRelations LABEL "Show parent relations"
              TOGGLE-BOX.

DEFINE SUB-MENU m_TableCreateTrigger 
       MENU-ITEM mi_CopyTableCreateTrigger LABEL "Copy trigger name"
       MENU-ITEM mi_OpenTableCreateTrigger LABEL "Open trigger procedure".

DEFINE SUB-MENU m_TableWriteTrigger 
       MENU-ITEM mi_CopyTableWriteTrigger LABEL "Copy trigger name"
       MENU-ITEM mi_OpenTableWriteTrigger LABEL "Open trigger procedure".

DEFINE SUB-MENU m_TableDeleteTrigger 
       MENU-ITEM mi_CopyTableDeleteTrigger LABEL "Copy trigger name"
       MENU-ITEM mi_OpenTableDeleteTrigger LABEL "Open trigger procedure".

DEFINE SUB-MENU m_TableCompanyInclude 
       MENU-ITEM mi_CopyTableCompanyInclude LABEL "Copy include name"
       MENU-ITEM mi_OpenTableCompanyInclude LABEL "Open include file"
       RULE
       MENU-ITEM mi_CopyTableCompanyIncludeReference LABEL "Copy include reference".

DEFINE SUB-MENU m_TableKeyInclude 
       MENU-ITEM mi_CopyTableKeyInclude LABEL "Copy include name"
       MENU-ITEM mi_OpenTableKeyInclude LABEL "Open include file"
       RULE
       MENU-ITEM mi_CopyTableKeyIncludeReference LABEL "Copy include reference".

DEFINE SUB-MENU m_TableFillInclude 
       MENU-ITEM mi_CopyTableFillInclude LABEL "Copy include name"
       MENU-ITEM mi_OpenTableFillInclude LABEL "Open include file"
       RULE
       MENU-ITEM mi_CopyTableFillIncludeReference LABEL "Copy include reference".

DEFINE MENU POPUP-MENU-brTable 
       MENU-ITEM mi_CopyTableName LABEL "Copy name"     
       RULE
       MENU-ITEM mi_CopyTableDefineBuffer LABEL "Copy ~"define buffer~""
       RULE
       SUB-MENU  m_TableCreateTrigger LABEL "Create trigger"
       SUB-MENU  m_TableWriteTrigger LABEL "Write trigger" 
       SUB-MENU  m_TableDeleteTrigger LABEL "Delete trigger"
       RULE
       SUB-MENU  m_TableCompanyInclude LABEL "Company include"
       SUB-MENU  m_TableKeyInclude LABEL "Key include"   
       SUB-MENU  m_TableFillInclude LABEL "Fill include"  
       RULE
       MENU-ITEM mi_SessionTriggerCreate LABEL "Add session trigger (create)"
       MENU-ITEM mi_SessionTriggerWrite LABEL "Add session trigger (write)"
       MENU-ITEM mi_SessionTriggerDelete LABEL "Add session trigger (delete)"
       MENU-ITEM mi_SessionTriggerFind LABEL "Add session trigger (find)"
       RULE
       MENU-ITEM mi_AddSnapshotBtn LABEL "Add snapshot"  
       MENU-ITEM mi_RemoveTable LABEL "Remove table"  
       RULE
       MENU-ITEM mi_LoadAllTableDetails LABEL "Load all table details"
       MENU-ITEM mi_ShowHiddenTables LABEL "Show hidden tables"
              TOGGLE-BOX.

DEFINE MENU POPUP-MENU-btnCopyToClipboard 
       MENU-ITEM mi_InsertModeBtn LABEL "Insert mode"   
              TOGGLE-BOX.


/* Definitions of the field level widgets                               */
DEFINE BUTTON btnBlock1 
     LABEL "1" 
     SIZE 7 BY 1.

DEFINE BUTTON btnBlock2 
     LABEL "2" 
     SIZE 7 BY 1.

DEFINE BUTTON btnBlock3 
     LABEL "3" 
     SIZE 7 BY 1.

DEFINE BUTTON btnBlock4 
     LABEL "4" 
     SIZE 7 BY 1.

DEFINE BUTTON btnBuffer1 
     LABEL "1" 
     SIZE 7 BY 1.

DEFINE BUTTON btnBuffer2 
     LABEL "2" 
     SIZE 7 BY 1.

DEFINE BUTTON btnBuffer3 
     LABEL "3" 
     SIZE 7 BY 1.

DEFINE BUTTON btnBuffer4 
     LABEL "4" 
     SIZE 7 BY 1.

DEFINE BUTTON btnClearBlockName 
     LABEL "" 
     SIZE 7 BY 1 TOOLTIP "Clear blockname".

DEFINE BUTTON btnClearBufferPattern 
     LABEL "" 
     SIZE 7 BY 1 TOOLTIP "Reset buffername".

DEFINE BUTTON btnClearFieldFilter 
     LABEL "" 
     SIZE 7 BY 1 TOOLTIP "Clear field filter".

DEFINE BUTTON btnClearFieldLabelFilter 
     LABEL "" 
     SIZE 7 BY 1 TOOLTIP "Clear field label filter".

DEFINE BUTTON btnClearIndexFieldFilter 
     LABEL "" 
     SIZE 7 BY 1 TOOLTIP "Clear index field filter".

DEFINE BUTTON btnClearIndexFilter 
     LABEL "" 
     SIZE 7 BY 1 TOOLTIP "Clear index filter".

DEFINE BUTTON btnClearRelationFieldFilter 
     LABEL "" 
     SIZE 7 BY 1 TOOLTIP "Clear relation field filter".

DEFINE BUTTON btnClearRelationFilter 
     LABEL "" 
     SIZE 7 BY 1 TOOLTIP "Clear relation filter".

DEFINE BUTTON btnClearTableFieldFilter 
     LABEL "" 
     SIZE 7 BY 1 TOOLTIP "Clear table field filter".

DEFINE BUTTON btnClearTableFilter 
     LABEL "" 
     SIZE 7 BY 1 TOOLTIP "Clear table filter".

DEFINE BUTTON btnConnectDB 
     LABEL "Connect" 
     SIZE 19 BY 1 TOOLTIP "Connect to existing database".

DEFINE BUTTON btnCopyToClipboard DEFAULT 
     LABEL "Copy" 
     SIZE 20 BY 2 TOOLTIP "Copy query text to clipboard".

DEFINE BUTTON btnDecreaseIndentation 
     LABEL "<<" 
     SIZE 7 BY 2 TOOLTIP "Decrease indentation".

DEFINE BUTTON btnDisconnectDB 
     LABEL "Disconnect" 
     SIZE 19 BY 1 TOOLTIP "Disconnect selected database".

DEFINE BUTTON btnExecuteQuery 
     LABEL "Execute" 
     SIZE 20 BY 2 TOOLTIP "Execute current query (F2)".

DEFINE BUTTON btnIncreaseIndentation 
     LABEL ">>" 
     SIZE 7 BY 2 TOOLTIP "Increase indentation".

DEFINE BUTTON btnOf 
     LABEL "..." 
     SIZE 7 BY 2 TOOLTIP "Select related table and buffer".

DEFINE BUTTON btnRefresh 
     LABEL "Refresh" 
     SIZE 19 BY 1 TOOLTIP "Reload schema information for all connected databases".

DEFINE BUTTON btnResetAll 
     LABEL "Reset" 
     SIZE 10 BY 2 TOOLTIP "Reset everything to default values (F12)".

DEFINE BUTTON btnResetIndentation 
     LABEL "|" 
     SIZE 7 BY 2 TOOLTIP "Reset indentation".

DEFINE VARIABLE gcFieldFilter AS CHARACTER 
     LABEL "Field filter" 
     VIEW-AS COMBO-BOX INNER-LINES 8
     DROP-DOWN
     SIZE 42 BY 1 TOOLTIP "Filter for fields that match given name pattern (comma separated)" NO-UNDO.

DEFINE VARIABLE gcFieldLabelFilter AS CHARACTER 
     VIEW-AS COMBO-BOX INNER-LINES 5
     DROP-DOWN
     SIZE 42 BY 1 TOOLTIP "Filter for fields that match given label pattern (comma separated)" NO-UNDO.

DEFINE VARIABLE gcIndexFieldFilter AS CHARACTER 
     VIEW-AS COMBO-BOX INNER-LINES 8
     DROP-DOWN
     SIZE 42 BY 1 TOOLTIP "Filter for indices that contain fields matching given name pattern (comma separated)" NO-UNDO.

DEFINE VARIABLE gcIndexFilter AS CHARACTER 
     LABEL "Index filter" 
     VIEW-AS COMBO-BOX INNER-LINES 8
     DROP-DOWN
     SIZE 42 BY 1 TOOLTIP "Filter for indices that match given name pattern (comma separated)" NO-UNDO.

DEFINE VARIABLE gcRelationFieldFilter AS CHARACTER 
     VIEW-AS COMBO-BOX INNER-LINES 8
     DROP-DOWN
     SIZE 42 BY .96 TOOLTIP "Filter for relations that contain fields matching given name pattern (comma sep" NO-UNDO.

DEFINE VARIABLE gcRelationFilter AS CHARACTER 
     LABEL "Relation filter" 
     VIEW-AS COMBO-BOX INNER-LINES 8
     DROP-DOWN
     SIZE 42 BY .96 TOOLTIP "Filter for relations that match given name pattern (comma separated)" NO-UNDO.

DEFINE VARIABLE gcTableFieldFilter AS CHARACTER 
     VIEW-AS COMBO-BOX INNER-LINES 8
     DROP-DOWN
     SIZE 42 BY 1 TOOLTIP "Filter for tables that contain fields matching given name pattern (comma separated)" NO-UNDO.

DEFINE VARIABLE gcTableFilter AS CHARACTER 
     LABEL "Table filter" 
     VIEW-AS COMBO-BOX INNER-LINES 8
     DROP-DOWN
     SIZE 42 BY 1 TOOLTIP "Filter for tables that match given name pattern (comma separated)" NO-UNDO.

DEFINE VARIABLE gcQueryText AS CHARACTER 
     VIEW-AS EDITOR NO-WORD-WRAP SCROLLBAR-HORIZONTAL SCROLLBAR-VERTICAL
     SIZE 93 BY 14.5
     FONT 0 NO-UNDO.

DEFINE VARIABLE gcBlockName AS CHARACTER FORMAT "X(60)":U 
     LABEL "Block" 
     VIEW-AS FILL-IN 
     SIZE 60 BY 1 NO-UNDO.

DEFINE VARIABLE gcBufferName AS CHARACTER FORMAT "X(256)":U 
     LABEL "Buffer" 
     VIEW-AS FILL-IN 
     SIZE 60 BY 1 NO-UNDO.

DEFINE VARIABLE gcDatabaseDummy AS CHARACTER FORMAT "X(1)":U 
     LABEL "Database" 
     VIEW-AS FILL-IN 
     SIZE 1 BY 1 NO-UNDO.

DEFINE VARIABLE gcFieldDummy AS CHARACTER FORMAT "X(256)":U 
     LABEL "Field" 
     VIEW-AS FILL-IN 
     SIZE 1 BY 1 NO-UNDO.

DEFINE VARIABLE gcIndexDummy AS CHARACTER FORMAT "X(1)":U 
     LABEL "Index" 
     VIEW-AS FILL-IN 
     SIZE 1 BY 1 NO-UNDO.

DEFINE VARIABLE gcRelationDummy AS CHARACTER FORMAT "X(1)":U 
     LABEL "Relation" 
     VIEW-AS FILL-IN 
     SIZE 1 BY 1 NO-UNDO.

DEFINE VARIABLE gcTableDummy AS CHARACTER FORMAT "X(1)":U 
     LABEL "Table" 
     VIEW-AS FILL-IN 
     SIZE 1 BY 1 NO-UNDO.

DEFINE VARIABLE gdIndexUsage AS DECIMAL FORMAT "zz9%":U INITIAL 0 
      VIEW-AS TEXT 
     SIZE 6 BY 1 TOOLTIP "Index Usage" NO-UNDO.

DEFINE VARIABLE giDisplayMode AS INTEGER INITIAL 2 
     VIEW-AS RADIO-SET HORIZONTAL
     RADIO-BUTTONS 
          "Fields", 1,
"Indices", 2,
"Relations", 3
     SIZE 45 BY 1 NO-UNDO.

DEFINE VARIABLE glInvertQuery AS LOGICAL INITIAL no 
     LABEL "Invert query" 
     VIEW-AS TOGGLE-BOX
     size 15 by 1 tooltip "Create Query for related table instead of selected table." no-undo.

DEFINE VARIABLE glOnError AS LOGICAL INITIAL no 
     LABEL "on error" 
     VIEW-AS TOGGLE-BOX
     SIZE 10 BY 1 NO-UNDO.

DEFINE VARIABLE giOnErrorPhrase AS INTEGER 
     VIEW-AS RADIO-SET VERTICAL
     RADIO-BUTTONS 
          "on error undo, leave", 1,
"on error undo, next", 2,
"on error undo, retry", 3,
"on error undo, throw", 4
     SIZE 28 BY 4 NO-UNDO.

DEFINE VARIABLE giQueryTypeModifier AS INTEGER 
     VIEW-AS RADIO-SET HORIZONTAL EXPAND
     RADIO-BUTTONS 
          "unique", 1,
"first", 2,
"last", 3
     SIZE 45 BY 1 NO-UNDO.

DEFINE VARIABLE giQueryType AS INTEGER 
     VIEW-AS RADIO-SET HORIZONTAL EXPAND 
     RADIO-BUTTONS 
          "find first", 1,
"for each", 2,
"can-find", 3
     SIZE 45 BY 1 NO-UNDO.

DEFINE VARIABLE glExclusiveLock AS LOGICAL 
     VIEW-AS RADIO-SET VERTICAL
     RADIO-BUTTONS 
          "no-lock", no,
"exclusive-lock", yes
     SIZE 20 BY 2 NO-UNDO.

DEFINE VARIABLE glCompanyViaClass AS LOGICAL INITIAL no 
     LABEL "" 
     VIEW-AS TOGGLE-BOX
     size 40 by 1 tooltip "Use {&K_CLASS_COMPANY_STATEMENT} instead of pa-Firma" no-undo.

DEFINE VARIABLE glDefineBlock AS LOGICAL INITIAL no 
     LABEL "define block" 
     VIEW-AS TOGGLE-BOX
     SIZE 21 BY 1 NO-UNDO.

DEFINE VARIABLE glDefineBuffer AS LOGICAL INITIAL no 
     LABEL "define buffer" 
     VIEW-AS TOGGLE-BOX
     SIZE 17 BY 1 NO-UNDO.

DEFINE VARIABLE glDoBlock AS LOGICAL INITIAL no 
     LABEL "do" 
     VIEW-AS TOGGLE-BOX
     SIZE 7 BY 1 NO-UNDO.

DEFINE VARIABLE glFinallyBlock AS LOGICAL INITIAL no 
     LABEL "finally block" 
     VIEW-AS TOGGLE-BOX
     SIZE 15 BY 1 NO-UNDO.

DEFINE VARIABLE glIfStatement AS LOGICAL INITIAL no 
     LABEL "if statement" 
     VIEW-AS TOGGLE-BOX
     SIZE 16 BY 1 NO-UNDO.

DEFINE VARIABLE glNoError AS LOGICAL INITIAL no 
     LABEL "no error" 
     VIEW-AS TOGGLE-BOX
     SIZE 11.83 BY 1 NO-UNDO.

DEFINE VARIABLE glNot AS LOGICAL INITIAL no 
     LABEL "not" 
     VIEW-AS TOGGLE-BOX
     SIZE 7 BY 1 NO-UNDO.

DEFINE VARIABLE glRetryBlock AS LOGICAL INITIAL no 
     LABEL "retry block" 
     VIEW-AS TOGGLE-BOX
     SIZE 15 BY 1 NO-UNDO.

DEFINE VARIABLE glDefineVariables AS LOGICAL INITIAL no 
     LABEL "define variables" 
     VIEW-AS TOGGLE-BOX
     SIZE 20 BY 1 NO-UNDO.

DEFINE VARIABLE glUseVirtualIndexIncludes AS LOGICAL INITIAL no 
     LABEL "Use virtual index includes" 
     VIEW-AS TOGGLE-BOX
     SIZE 30 BY 1 NO-UNDO.


/* Query definitions                                                    */
&ANALYZE-SUSPEND
DEFINE QUERY brDatabase FOR 
      ttDatabase SCROLLING.

DEFINE QUERY brField FOR 
      ttField SCROLLING.

DEFINE QUERY brIndex FOR 
      ttIndex SCROLLING.

DEFINE QUERY brRelation FOR 
      ttTableRelationView SCROLLING.

DEFINE QUERY brTable FOR 
      ttTable SCROLLING.
&ANALYZE-RESUME

/* Browse definitions                                                   */
DEFINE BROWSE brDatabase
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _DISPLAY-FIELDS brDatabase hQueryWindow _FREEFORM
  QUERY brDatabase NO-LOCK DISPLAY
      ttDatabase.DatabaseName width 12
      ttDatabase.PhysicalName
/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME
    WITH NO-ASSIGN SIZE 80 BY 5.

DEFINE BROWSE brField
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _DISPLAY-FIELDS brField hQueryWindow _FREEFORM
  QUERY brField NO-LOCK DISPLAY
      ttField.FieldName
      ttField.IsVirtual
      ttField.DataType
      ttField.FieldExtent
      ttField.FieldDecimals
      ttField.FieldInitialValue width 7
      ttField.FieldFormat
      ttField.FieldLabel
      ttField.FieldColumnLabel
      ttField.IsMandatory
      ttField.Domain
/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME
    WITH NO-ASSIGN MULTIPLE SIZE 100 BY 12.

DEFINE BROWSE brIndex
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _DISPLAY-FIELDS brIndex hQueryWindow _FREEFORM
  QUERY brIndex NO-LOCK DISPLAY
      ttIndex.IsPrimary
      ttIndex.IndexName
      ttIndex.IsUnique
      ttIndex.IsVirtual
      ttIndex.IndexFields
/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME
    WITH NO-ASSIGN SIZE 100 BY 12.

DEFINE BROWSE brRelation
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _DISPLAY-FIELDS brRelation hQueryWindow _FREEFORM
  QUERY brRelation NO-LOCK DISPLAY
      ttTableRelationView.RelatedTableName
      ttTableRelationView.RelationType width 8
      ttTableRelationView.ParentRelation
      ttTableRelationView.RelatedFields
      ttTableRelationView.FieldDetails
/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME
    WITH NO-ASSIGN SIZE 100 BY 12.

DEFINE BROWSE brTable
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _DISPLAY-FIELDS brTable hQueryWindow _FREEFORM
  QUERY brTable NO-LOCK DISPLAY
      ttTable.TableName
      ttTable.ShortDescription
/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME
    WITH NO-ASSIGN SIZE 100 BY 10 FIT-LAST-COLUMN.


/* ************************  Frame Definitions  *********************** */

DEFINE FRAME fQuery
     gdIndexUsage AT ROW 32 COL 223 COLON-ALIGNED NO-LABEL
     gcDatabaseDummy AT ROW 1.5 COL 16 COLON-ALIGNED
     gcTableDummy AT ROW 8 COL 16 COLON-ALIGNED
     gcFieldDummy AT ROW 21 COL 16 COLON-ALIGNED
     gcIndexDummy AT ROW 21 COL 16 COLON-ALIGNED
     gcRelationDummy AT ROW 21 COL 16 COLON-ALIGNED
     brDatabase AT ROW 1.5 COL 18
     btnConnectDB AT ROW 1.5 COL 99
     btnDisconnectDB AT ROW 2.5 COL 99
     btnRefresh AT ROW 5.5 COL 99
     gcTableFilter AT ROW 7 COL 16 COLON-ALIGNED
     btnClearTableFilter AT ROW 7 COL 60
     gcTableFieldFilter AT ROW 7 COL 67 COLON-ALIGNED NO-LABEL
     btnClearTableFieldFilter AT ROW 7 COL 111
     brTable AT ROW 8 COL 18
     giDisplayMode AT ROW 18.5 COL 18 NO-LABEL
     glInvertQuery AT ROW 18.5 COL 65 NO-LABEL
     gcFieldFilter AT ROW 20 COL 16 COLON-ALIGNED
     btnClearFieldFilter AT ROW 20 COL 60
     gcFieldLabelFilter AT ROW 20 COL 67 COLON-ALIGNED NO-LABEL
     btnClearFieldLabelFilter AT ROW 20 COL 111
     brField AT ROW 21 COL 18
     gcIndexFilter AT ROW 20 COL 16 COLON-ALIGNED
     btnClearIndexFilter AT ROW 20 COL 60
     gcIndexFieldFilter AT ROW 20 COL 67 COLON-ALIGNED NO-LABEL
     btnClearIndexFieldFilter AT ROW 20 COL 111
     brIndex AT ROW 21 COL 18
     gcRelationFilter AT ROW 20 COL 16 COLON-ALIGNED
     btnClearRelationFilter AT ROW 20 COL 60
     gcRelationFieldFilter AT ROW 20 COL 67 COLON-ALIGNED NO-LABEL
     btnClearRelationFieldFilter AT ROW 20 COL 111
     brRelation AT ROW 21 COL 18
     gcBufferName AT ROW 1.5 COL 128 COLON-ALIGNED
     btnClearBufferPattern AT ROW 1.5 COL 190
     btnBuffer1 AT ROW 1.5 COL 199
     btnBuffer2 AT ROW 1.5 COL 207
     btnBuffer3 AT ROW 1.5 COL 215
     btnBuffer4 AT ROW 1.5 COL 223
     glDefineBuffer AT ROW 7 COL 178
     glDefineVariables AT ROW 8.5 COL 178
     glCompanyViaClass AT ROW 5.5 COL 178
     glExclusiveLock AT ROW 3 COL 130 NO-LABEL
     glNoError AT ROW 3 COL 178
     glIfStatement AT ROW 4 COL 181
     glNot AT ROW 4 COL 199
     glDoBlock AT ROW 4 COL 207
     glUseVirtualIndexIncludes AT ROW 9.5 COL 178
     glOnError AT ROW 5.5 COL 130
     giOnErrorPhrase AT ROW 6.5 COL 133 NO-LABEL
     giQueryTypeModifier AT ROW 17 COL 130 NO-LABEL
     gcBlockName AT ROW 11.5 COL 128 COLON-ALIGNED
     btnClearBlockName AT ROW 11.5 COL 190
     btnBlock1 AT ROW 11.5 COL 199
     btnBlock2 AT ROW 11.5 COL 207
     btnBlock3 AT ROW 11.5 COL 215
     btnBlock4 AT ROW 11.5 COL 223
     glDefineBlock AT ROW 13 COL 130
     glRetryBlock AT ROW 13 COL 160
     glFinallyBlock AT ROW 13 COL 178
     giQueryType AT ROW 16 COL 130 NO-LABEL
     btnCopyToClipboard AT ROW 16 COL 178
     btnExecuteQuery AT ROW 16 COL 199
     btnResetAll AT ROW 16 COL 220
     btnIncreaseIndentation AT ROW 18.5 COL 223
     btnDecreaseIndentation AT ROW 20.5 COL 223
     btnResetIndentation AT ROW 22.5 COL 223
     btnOf AT ROW 25 COL 223
     gcQueryText AT ROW 18.5 COL 130 NO-LABEL
    WITH 1 DOWN NO-BOX KEEP-TAB-ORDER OVERLAY 
         SIDE-LABELS NO-UNDERLINE THREE-D 
         AT COL 1 ROW 1
         SIZE 232 BY 32.5
         DEFAULT-BUTTON btnCopyToClipboard DROP-TARGET.


/* *********************** Procedure Settings ************************ */

&ANALYZE-SUSPEND _PROCEDURE-SETTINGS
/* Settings for THIS-PROCEDURE
   Type: Window
   Allow: Basic,Browse,DB-Fields,Window,Query
 */
&ANALYZE-RESUME _END-PROCEDURE-SETTINGS

/* *************************  Create Window  ************************** */

&ANALYZE-SUSPEND _CREATE-WINDOW
IF SESSION:DISPLAY-TYPE = "GUI":U THEN
  CREATE WINDOW hQueryWindow ASSIGN
         HIDDEN             = YES
         TITLE              = ""
         HEIGHT             = 32.5
         WIDTH              = 231
         MAX-HEIGHT         = 320
         MAX-WIDTH          = 320
         VIRTUAL-HEIGHT     = 320
         VIRTUAL-WIDTH      = 320
         RESIZE             = yes
         SCROLL-BARS        = no
         STATUS-AREA        = no
         BGCOLOR            = ?
         FGCOLOR            = ?
         KEEP-FRAME-Z-ORDER = yes
         THREE-D            = yes
         MESSAGE-AREA       = no
         SENSITIVE          = yes.
ELSE {&WINDOW-NAME} = CURRENT-WINDOW.

ASSIGN {&WINDOW-NAME}:MENUBAR    = MENU MENU-BAR-hQueryWindow:HANDLE.
/* END WINDOW DEFINITION                                                */
&ANALYZE-RESUME



/* ***********  Runtime Attributes and AppBuilder Settings  *********** */

&ANALYZE-SUSPEND _RUN-TIME-ATTRIBUTES
/* SETTINGS FOR WINDOW hQueryWindow
  VISIBLE,,RUN-PERSISTENT                                               */
/* SETTINGS FOR FRAME fQuery
   FRAME-NAME Custom                                                    */
/* BROWSE-TAB brDatabase gcIndexDummy fQuery */
/* BROWSE-TAB brTable btnClearTableFieldFilter fQuery */
/* BROWSE-TAB brField btnClearFieldFilter fQuery */
/* BROWSE-TAB brIndex btnClearIndexFieldFilter fQuery */
/* BROWSE-TAB brRelation gcQueryText fQuery */
ASSIGN 
       FRAME fQuery:PRIVATE-DATA     = 
                "WidthFactor=1,HeightFactor=1,SlimModeWidget=yes".

ASSIGN 
       brDatabase:POPUP-MENU IN FRAME fQuery             = MENU POPUP-MENU-brDatabase:HANDLE
       brDatabase:PRIVATE-DATA IN FRAME fQuery           = 
                "WidthFactor=0.5,SlimModeWidget=yes"
       brDatabase:COLUMN-RESIZABLE IN FRAME fQuery       = TRUE
       brDatabase:COLUMN-MOVABLE IN FRAME fQuery         = TRUE.

ASSIGN 
       brField:POPUP-MENU IN FRAME fQuery             = MENU POPUP-MENU-brField:HANDLE
       brField:NUM-LOCKED-COLUMNS IN FRAME fQuery     = 1
       brField:PRIVATE-DATA IN FRAME fQuery           = 
                "WidthFactor=0.5,HeightFactor=0.5,RowFactor=0.5,SlimModeWidget=yes"
       brField:COLUMN-RESIZABLE IN FRAME fQuery       = TRUE
       brField:COLUMN-MOVABLE IN FRAME fQuery         = TRUE.

ASSIGN 
       brIndex:POPUP-MENU IN FRAME fQuery             = MENU POPUP-MENU-brIndex:HANDLE
       brIndex:PRIVATE-DATA IN FRAME fQuery           = 
                "WidthFactor=0.5,HeightFactor=0.5,RowFactor=0.5,SlimModeWidget=yes"
       brIndex:COLUMN-RESIZABLE IN FRAME fQuery       = TRUE
       brIndex:COLUMN-MOVABLE IN FRAME fQuery         = TRUE.

ASSIGN 
       brRelation:POPUP-MENU IN FRAME fQuery             = MENU POPUP-MENU-brRelation:HANDLE
       brRelation:NUM-LOCKED-COLUMNS IN FRAME fQuery     = 1
       brRelation:PRIVATE-DATA IN FRAME fQuery           = 
                "WidthFactor=0.5,HeightFactor=0.5,RowFactor=0.5,SlimModeWidget=yes"
       brRelation:COLUMN-RESIZABLE IN FRAME fQuery       = TRUE
       brRelation:COLUMN-MOVABLE IN FRAME fQuery         = TRUE.

ASSIGN 
       brTable:POPUP-MENU IN FRAME fQuery             = MENU POPUP-MENU-brTable:HANDLE
       brTable:PRIVATE-DATA IN FRAME fQuery           = 
                "WidthFactor=0.5,HeightFactor=0.5,SlimModeWidget=yes"
       brTable:COLUMN-RESIZABLE IN FRAME fQuery       = TRUE
       brTable:COLUMN-MOVABLE IN FRAME fQuery         = TRUE.

ASSIGN 
       btnBlock1:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnBlock2:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnBlock3:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnBlock4:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnBuffer1:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnBuffer2:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnBuffer3:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnBuffer4:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnClearBlockName:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnClearBufferPattern:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnClearFieldFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.25,RowFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       btnClearFieldLabelFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,RowFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       btnClearIndexFieldFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,RowFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       btnClearIndexFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.25,RowFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       btnClearRelationFieldFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,RowFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       btnClearRelationFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.25,RowFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       btnClearTableFieldFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       btnClearTableFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.25,SlimModeWidget=yes".

ASSIGN 
       btnConnectDB:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       btnCopyToClipboard:POPUP-MENU IN FRAME fQuery       = MENU POPUP-MENU-btnCopyToClipboard:HANDLE
       btnCopyToClipboard:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,WidthFactor=0.2".

ASSIGN 
       btnDecreaseIndentation:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1,HeightFactor=0.12,RowFactor=0.12,MaxHeight=2.0,MaxRow=20.5".

ASSIGN 
       btnDisconnectDB:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       btnExecuteQuery:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.7,WidthFactor=0.2".

ASSIGN 
       btnIncreaseIndentation:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1,HeightFactor=0.12,MaxHeight=2.0".

ASSIGN 
       btnOf:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1,HeightFactor=0.12,RowFactor=0.36,MaxHeight=2.0,MaxRow=25.0".

ASSIGN 
       btnRefresh:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       btnResetAll:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.9,WidthFactor=0.1".

ASSIGN 
       btnResetIndentation:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1,HeightFactor=0.12,RowFactor=0.24,MaxHeight=2.0,MaxRow=22.5".

ASSIGN 
       gcBlockName:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,WidthFactor=0.5".

ASSIGN 
       gcBufferName:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,WidthFactor=0.5".

/* SETTINGS FOR FILL-IN gcDatabaseDummy IN FRAME fQuery
   NO-DISPLAY NO-ENABLE                                                 */
ASSIGN 
       gcFieldDummy:PRIVATE-DATA IN FRAME fQuery     = 
                "RowFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       gcFieldFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "RowFactor=0.5,WidthFactor=0.25,SlimModeWidget=yes".

ASSIGN 
       gcFieldLabelFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.25,RowFactor=0.5,WidthFactor=0.25,SlimModeWidget=yes".

/* SETTINGS FOR FILL-IN gcIndexDummy IN FRAME fQuery
   NO-DISPLAY NO-ENABLE                                                 */
ASSIGN 
       gcIndexDummy:PRIVATE-DATA IN FRAME fQuery     = 
                "RowFactor=0.5,SlimModeWidget=yes".

/* SETTINGS FOR FILL-IN gcRelationDummy IN FRAME fQuery
   NO-DISPLAY NO-ENABLE                                                 */
ASSIGN 
       gcRelationDummy:PRIVATE-DATA IN FRAME fQuery     = 
                "RowFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       gcIndexFieldFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.25,RowFactor=0.5,WidthFactor=0.25,SlimModeWidget=yes".

ASSIGN 
       gcIndexFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "RowFactor=0.5,WidthFactor=0.25,SlimModeWidget=yes".

ASSIGN 
       gcQueryText:READ-ONLY IN FRAME fQuery        = TRUE
       gcQueryText:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,HeightFactor=1,WidthFactor=0.5".

ASSIGN 
       gcRelationFieldFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.25,RowFactor=0.5,WidthFactor=0.25,SlimModeWidget=yes".

ASSIGN 
       gcRelationFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "RowFactor=0.5,WidthFactor=0.25,SlimModeWidget=yes".

/* SETTINGS FOR FILL-IN gcTableDummy IN FRAME fQuery
   NO-DISPLAY NO-ENABLE                                                 */
ASSIGN 
       gcTableDummy:PRIVATE-DATA IN FRAME fQuery     = 
                "SlimModeWidget=yes".

ASSIGN 
       gcTableFieldFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.25,WidthFactor=0.25,SlimModeWidget=yes".

ASSIGN 
       gcTableFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "WidthFactor=0.25,SlimModeWidget=yes".

ASSIGN 
       gdIndexUsage:READ-ONLY IN FRAME fQuery        = TRUE
       gdIndexUsage:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1,RowFactor=1".

ASSIGN 
       giDisplayMode:PRIVATE-DATA IN FRAME fQuery     = 
                "RowFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       glInvertQuery:PRIVATE-DATA IN FRAME fQuery     = 
                "RowFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       glOnError:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       giOnErrorPhrase:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       giQueryTypeModifier:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       giQueryType:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glCompanyViaClass:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glDefineBlock:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glDefineBuffer:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glDoBlock:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glExclusiveLock:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glFinallyBlock:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glIfStatement:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glNoError:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glNot:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glDefineVariables:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glUseVirtualIndexIncludes:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glRetryBlock:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

IF SESSION:DISPLAY-TYPE = "GUI":U AND VALID-HANDLE(hQueryWindow)
THEN hQueryWindow:HIDDEN = no.

/* _RUN-TIME-ATTRIBUTES-END */
&ANALYZE-RESUME


/* Setting information for Queries and Browse Widgets fields            */

&ANALYZE-SUSPEND _QUERY-BLOCK BROWSE brDatabase
/* Query rebuild information for BROWSE brDatabase
     _START_FREEFORM
OPEN QUERY brDatabase FOR EACH ttDatabase WHERE true
  NO-LOCK
  BY ttDatabase.DisplayPriority BY ttDatabase.DatabaseName.
     _END_FREEFORM
     _Options          = "NO-LOCK"
     _Query            is NOT OPENED
*/  /* BROWSE brDatabase */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _QUERY-BLOCK BROWSE brField
/* Query rebuild information for BROWSE brField
     _START_FREEFORM
OPEN QUERY brField FOR EACH ttField WHERE true
and ttField.DatabaseName = ttDatabase.DatabaseName
and ttField.TableName = ttTable.TableName
and ttField.FieldFilterMatches = yes
and ( glShowVirtualFields
   or ttField.IsVirtual <> yes )
  NO-LOCK.
     _END_FREEFORM
     _Options          = "NO-LOCK"
     _Query            is NOT OPENED
*/  /* BROWSE brField */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _QUERY-BLOCK BROWSE brIndex
/* Query rebuild information for BROWSE brIndex
     _START_FREEFORM
OPEN QUERY brIndex FOR EACH ttIndex WHERE true
  AND ttIndex.DatabaseName = ttDatabase.DatabaseName
  and ttIndex.TableName = ttTable.TableName
  AND ttIndex.IndexFilterMatches = yes
  AND ttIndex.IndexFieldFilterMatches = yes
  AND ( glShowVirtualIndices
     or ttIndex.IsVirtual <> yes )
  NO-LOCK.
     _END_FREEFORM
     _Options          = "NO-LOCK"
     _Query            is NOT OPENED
*/  /* BROWSE brIndex */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _QUERY-BLOCK BROWSE brRelation
/* Query rebuild information for BROWSE brRelation
     _START_FREEFORM
OPEN QUERY brTableRelationView FOR EACH ttTableRelationView WHERE true
  AND ttTableRelationView.DatabaseName = ttDatabase.DatabaseName
  AND ttTableRelationView.ReferenceTableName = ttTable.TableName
  AND ttTableRelationView.TableFilterMatches = yes
  AND ttTableRelationView.FieldFilterMatches = yes
  AND ttTableRelationView.ParentRelationFilterMatches = yes
  NO-LOCK.
     _END_FREEFORM
     _Options          = "NO-LOCK"
     _Query            is NOT OPENED
*/  /* BROWSE brRelation */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _QUERY-BLOCK BROWSE brTable
/* Query rebuild information for BROWSE brTable
     _START_FREEFORM
OPEN QUERY brTable FOR EACH ttTable WHERE true
  AND ttTable.DatabaseName = ttDatabase.DatabaseName
  AND ttTable.TableFilterMatches = yes
  AND ttTable.TableFieldFilterMatches = yes
  AND (glShowHiddenTables
    OR (  not can-do('sys*':U, ttTable.TableName)
      and not can-do('_*':U, ttTable.TableName)))
  NO-LOCK.
     _END_FREEFORM
     _Options          = "NO-LOCK"
     _Query            is NOT OPENED
*/  /* BROWSE brTable */
&ANALYZE-RESUME

/* >>> Include: incl/core.df >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> */

/*------------------------------------------------------------------------
    File        : core.df
    Purpose     : 

    Syntax      :

    Description : 

    Author(s)   : Thiemann_M
    Created     : Mon Apr 11 08:19:37 CEST 2022
    Notes       :
  ----------------------------------------------------------------------*/

/* ***************************  Definitions  ************************** */


/* ********************  Preprocessor Definitions  ******************** */

/* ************************  Function Prototypes ********************** */

function qg_cDataTypePrefix returns character 
  ( pcDataType as character ) forward.

function qg_cDatabaseNameForTableOrBuffer returns character 
  ( phBuffer as handle ) forward.

function qg_cDateStringFormUSFormat returns character 
  ( pcDateString as character ) forward.

function qg_cFieldValuesForObjectId returns character 
  ( pcDatabaseName as character,
    pcTableName    as character,
    pcObjectId     as character,
    pcFieldList    as character ) forward.

function qg_cIndexFieldValuesForObjectId returns character 
  ( pcDatabaseName as character,
    pcTableName    as character,
    pcObjectId     as character,
    pcIndexName    as character ) forward.

function qg_cObjectIdForBuffer returns character 
  ( phBuffer as handle ) forward.

function qg_lFieldExistsInDatabaseSchema returns logical 
  ( pcDatabaseName as character,
    pcTableName    as character,
    pcFieldName    as character ) forward.

function qg_lIsPhysicalDatabase returns logical 
  ( pcDatabaseName as character ) forward.

function qg_tDateDateFromUSFormat returns date 
  ( pcDateString as character ) forward.

function qg_tzDateDateTimeTzFromUSFormat returns datetime-tz 
  ( pcDateString as character ) forward.


/* ***************************  Main Block  *************************** */

/* <<< Include: incl/core.df <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

/* >>> Include: incl/database_schema.df >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> */

/*------------------------------------------------------------------------
    File        : database_schema.df
    Purpose     : 

    Syntax      :

    Description : 

    Author(s)   : Thiemann_M
    Created     : Wed Apr 06 11:56:21 CEST 2022
    Notes       :
  ----------------------------------------------------------------------*/

/* ***************************  Definitions  ************************** */


/* ********************  Preprocessor Definitions  ******************** */


/* ***************************  Main Block  *************************** */

/* <<< Include: incl/database_schema.df <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

/* >>> Include: incl/query_window.df >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> */

/*------------------------------------------------------------------------
    File        : database_schema.df
    Purpose     : 

    Syntax      :

    Description : 

    Author(s)   : Thiemann_M
    Created     : Wed Apr 06 11:56:21 CEST 2022
    Notes       :
  ----------------------------------------------------------------------*/

/* ***************************  Definitions  ************************** */

define variable ghQueryWindowListWindowSeq  as integer   no-undo.

define variable ghQueryWindowListWindow     as handle    no-undo.
define variable ghQueryWindowListBrowse     as handle    no-undo.
define variable ghActiveQueryWindow         as handle    no-undo.

/* ********************  Preprocessor Definitions  ******************** */


/* ***************************  Main Block  *************************** */

/* <<< Include: incl/query_window.df <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

/* >>> Include: incl/virtual_fields.df >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> */
/*------------------------------------------------------------------------
    File        : virtual_fields.i
    Purpose     : 

    Syntax      :

    Description : 

    Author(s)   : Thiemann_M
    Created     : Tue Apr 05 13:54:45 CEST 2022
    Notes       :
  ----------------------------------------------------------------------*/

/* ********************  Preprocessor Definitions  ******************** */

&GLOBAL-DEFINE K_VIRTUAL_DB_FIELD_FGCOLOR        3

/* ***************************  Definitions  ************************** */

define variable glShowVirtualFields                  as logical                    no-undo init yes.

define variable goVirtualDBFieldDataApiInstance      as class Progress.Lang.Object no-undo.
define variable goVirtualDBFieldDataFieldApiInstance as class Progress.Lang.Object no-undo.
define variable gcVirtualDBFieldReposFlagFieldName   as character                  no-undo init ?.

define temp-table ttVirtualFieldColumn no-undo
  field OwnerHandle         as handle
  field DatabaseName        as character
  field BufferName          as character
  field FieldName           like ttField.FieldName
  field FieldIndex          as integer
  field DataType            as character
  field FieldType           as integer
  field FieldFormat         as character
  field BufferHandle        as handle
  field ColumnHandle        as handle
  index Main is primary unique
    OwnerHandle
    BufferName
    FieldName
    FieldIndex
  index ColumnHandle
    OwnerHandle
    ColumnHandle
    .

/* ************************  Function Prototypes ********************** */

function qg_cBufferCompareVirtualFields returns character 
  ( phBuffer1 as handle,
    phBuffer2 as handle ) forward.

function qg_clVirtualDBFieldValueAsLongchar returns longchar 
  ( pcDataType      as character,
    pcFieldName     as character,
    pcObjectIdValue as character,
    pcFormat        as character ) forward.


function qg_clVirtualFieldValueAsLongchar returns longchar 
  ( piFieldType     as integer,
    pcDataType      as character,
    pcFieldName     as character,
    pcObjectIdValue as character,
    pcFormat        as character ) forward.

function qg_lBufferCompareSingleVirtualField returns logical 
  ( phBuffer1             as handle,
    plDatabase1IsPhysical as logical,
    pcObjectIdValue1      as character,
    phBuffer2             as handle,
    plDatabase2IsPhysical as logical,
    pcObjectIdValue2      as character,
    pcFieldName           as character,
    pcDataType            as character ) forward.

function qg_lVirtualDBFieldsPossible returns logical 
  ( buffer pbttDatabase for ttDatabase ) forward.

function qg_oVirtualDBFieldDataApiInstance returns class progress.lang.object 
  (  ) forward.

function qg_oVirtualDBFieldDataFieldApiInstance returns class progress.lang.object 
  (  ) forward.

/* <<< Include: incl/virtual_fields.df <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

/* >>> Include: incl/virtual_indices.df >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> */

/*------------------------------------------------------------------------
    File        : virtual_indices.df
    Purpose     : 

    Syntax      :

    Description : 

    Author(s)   : Thiemann_M
    Created     : Wed Jun 01 14:36:40 CEST 2022
    Notes       :
  ----------------------------------------------------------------------*/

/* ***************************  Definitions  ************************** */


/* ********************  Preprocessor Definitions  ******************** */

&GLOBAL-DEFINE K_VIRTUAL_INDEX_FGCOLOR        3

/* ***************************  Main Block  *************************** */

define variable glShowVirtualIndices             as logical                    no-undo init yes.

define variable goVirtualIndexApiInstance        as class Progress.Lang.Object no-undo.
define variable goVirtualIndexDataApiInstance    as class Progress.Lang.Object no-undo.

define variable gcVirtualQueryApiPackageName     as character no-undo.
define variable gcVirtualQueryApiClassName       as character no-undo.

define variable gcVirtualIndexReposFlagFieldName as character                  no-undo init ?.
define variable gcVirtualIndexDataTableName      as character                  no-undo init ?.

/* ************************  Function Prototypes ********************** */

function qg_cVirtualIndexFieldVariableName returns character 
  ( pcFieldName as character,
    pcDataType  as character ) forward.

function qg_lVirtualIndexPossible returns logical 
  ( buffer pbttDatabase for ttDatabase ) forward.

function qg_oVirtualIndexApiInstance returns class progress.lang.object 
  (  ) forward.

function qg_oVirtualIndexDataApiInstance returns class progress.lang.object 
  (  ) forward.

function qg_oVirtualQueryApiInstance returns class progress.lang.object 
  (  ) forward.



/* <<< Include: incl/virtual_indices.df <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


/* >>> Include: incl/core.i >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> */

/*------------------------------------------------------------------------
    File        : core.i
    Purpose     : 

    Syntax      :

    Description : 

    Author(s)   : Thiemann_M
    Created     : Mon Apr 11 08:19:37 CEST 2022
    Notes       :
  ----------------------------------------------------------------------*/

/* ***************************  Definitions  ************************** */


/* ********************  Preprocessor Definitions  ******************** */


/* ***************************  Main Block  *************************** */



/* **********************  Internal Procedures  *********************** */


/* ************************  Function Implementations ***************** */

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION qg_cDatabaseNameForTableOrBuffer Method-Library
function qg_cDatabaseNameForTableOrBuffer returns character 
  ( phDBObject as handle ):
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cDatabaseName as character no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

/* Prio 1: get property from given handle. */

cDatabaseName = qg_cParamListReadValue( phDBObject:private-data,
                                        'DatabaseName':U,
                                        ',':U ).

if  ( cDatabaseName > '':U ) then
  
  return cDatabaseName.
  
case phDBObject:type:
  
  when 'BUFFER':U then
  do:
    
    if valid-handle( phDBObject:table-handle ) then
    do:
      
      /* Prio 2 for Buffers: read property from table handle */
      
      cDatabaseName = qg_cParamListReadValue( phDBObject:table-handle:private-data,
                                              'DatabaseName':U,
                                              ',':U ).
      
      if cDatabaseName > '':U then
        
        return cDatabaseName.
      
      if phDBObject <> phDBObject:table-handle:default-buffer-handle then
      do:
        
        /* Prio 3 for Buffers: read property form default buffer handle (but  */
        /* only if the default buffer handle differs from given handle.       */
        
        cDatabaseName = qg_cParamListReadValue( phDBObject:table-handle:default-buffer-handle:private-data,
                                                'DatabaseName':U,
                                                ',':U ).
        if cDatabaseName > '':U then
          
          return cDatabaseName.
        
      end. /* if phDBObject <> phDBObject:table-handle:default-buffer-handle */
      
    end. /* if valid-handle( phDBObject:table-handle ) */
    
    return phDBObject:dbname.
    
  end. /* when 'BUFFER':U */
  
  when 'TABLE':U then
  do:
    
    /* Prio 2 for tables: read property from default buffer handle. */
    
    cDatabaseName = qg_cParamListReadValue( phDBObject:default-buffer-handle:private-data,
                                            'DatabaseName':U,
                                            ',':U ).
    
    if cDatabaseName > '':U then
      
      return cDatabaseName.
    
    return phDBObject:default-buffer-handle:dbname.
    
  end. /* when 'TABLE':U */
  
end case. /* phDBObject:type */

return ?.

end function. /* qg_cDatabaseNameForTableOrBuffer */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

/* ************************  Function Prototypes ********************** */

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION qg_cDataTypePrefix Method-Library
function qg_cDataTypePrefix returns character 
  ( pcDataType as character ):
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/    

case pcDataType:
  
  when 'character':U then
    
    return 'c':U.

  when 'integer':U
     or when 'int64':U then
    
    return 'i':U.
  
  when 'decimal':U then
    
    return 'd':U.
  
  when 'logical':U then
    
    return 'l':U.
  
  when 'date':U then
    
    return 't':U.
  
  when 'longchar':U then
    
    return 'cl':U.
  
  when 'datetime':U then
    
    return 'td':U.
  
  when 'datetime-tz':U then
    
    return 'tz':U.
  
  when 'handle':U then
    
    return 'h':U.
  
  when 'rowid':U then
    
    return 'r':U.
  
  when 'memptr':U then
    
    return 'm':U.
  
  when 'progress.lang.object':U then
    
    return 'o':U.
  
end case. /* pcDataType */

end function. /* qg_cDataTypePrefix */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION qg_cDateStringFormUSFormat Method-Library
function qg_cDateStringFormUSFormat returns character 
  ( pcDateString as character ):
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Returns a date-string representing the given us date string in format of   */
/* the session date-format.                                                   */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/* pcDateString   date(time-tz) string in US format (mm/dd/yyyy)              */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/    

if lookup(pcDateString,'today,now':U) > 0 then
  
  return pcDateString.

else if length(pcDateString) > 10 then

  return string(qg_tzDateDateTimeTzFromUSFormat(pcDateString)).

else

  return string(qg_tDateDateFromUSFormat(pcDateString)).

end function. /* qg_cDateStringFormUSFormat */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION qg_cFieldValuesForObjectId Method-Library
function qg_cFieldValuesForObjectId returns character 
  ( pcDatabaseName as character,
    pcTableName    as character,
    pcObjectId     as character,
    pcFieldList    as character ):
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

create buffer hBuffer for table substitute( '&1.&2':U,
                                            pcDatabaseName,
                                            pcTableName ).

hBuffer:find-first( substitute( 'where &1.&1_Obj = &2':U,
                                hBuffer:table,
                                quoter( pcObjectId ) ) ) no-error.

return ( if hBuffer:available then
           qg_cFieldValues( hBuffer, ?, pcFieldList )
         else
           ? ).

finally:
  
  if valid-handle( hBuffer ) then
    
    delete object hBuffer.
  
end finally.

end function. /* qg_cFieldValuesForObjectId */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION qg_cIndexFieldValuesForObjectId Method-Library
function qg_cIndexFieldValuesForObjectId returns character 
  ( pcDatabaseName as character,
    pcTableName    as character,
    pcObjectId     as character,
    pcIndexName    as character ):
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/    

create buffer hBuffer for table substitute( '&1.&2':U,
                                            pcDatabaseName,
                                            pcTableName ).

hBuffer:find-first( substitute( 'where &1.&1_Obj = &2':U,
                                hBuffer:table,
                                quoter( pcObjectId ) ) ) no-error.

return ( if hBuffer:available then
           qg_cIndexFieldValues( hBuffer, pcIndexName )
         else
           ? ).

finally:
  
  if valid-handle( hBuffer ) then
    
    delete object hBuffer.
  
end finally.

end function. /* qg_cIndexFieldValuesForObjectId */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION qg_cObjectIdForBuffer Method-Library
function qg_cObjectIdForBuffer returns character 
  ( phBuffer as handle ):
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hObjectIdField as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

hObjectIdField = phBuffer:buffer-field( substitute( '&1_Obj':U, phBuffer:table ) ).

return hObjectIdField:buffer-value.

catch oError as class progress.lang.error:
  return ?.
end catch.

end function. /* qg_cObjectIdForBuffer */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION qg_lFieldExistsInDatabaseSchema Method-Library
function qg_lFieldExistsInDatabaseSchema returns logical 
  ( pcDatabaseName as character,
    pcTableName    as character,
    pcFieldName    as character ):
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hFileBuffer  as handle    no-undo.
define variable hFieldBuffer as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

create buffer hFileBuffer for table substitute( '&1.&2':U,
                                                pcDatabaseName,
                                                '_File':U ).

hFileBuffer:find-first( substitute( 'where _File._File-Name = &1':U,
                                    quoter( pcTableName ) ),
                        no-lock ) no-error.

if not hFileBuffer:available then
  
  return no.

create buffer hFieldBuffer for table substitute( '&1.&2':U,
                                                 pcDatabaseName,
                                                 '_Field':U ).

hFieldBuffer:find-first( substitute(            'where _Field._File-recid = &1':U
                                     + '~n':U + '  and _Field._Field-Name = &2':U,
                                     quoter( hFileBuffer:recid ),
                                     quoter( pcFieldName ) ),
                         no-lock ) no-error.

return hFieldBuffer:available.

finally:
  
  if valid-handle( hFileBuffer ) then
    
    delete object hFileBuffer.
  
  if valid-handle( hFieldBuffer ) then
    
    delete object hFieldBuffer.
  
end finally.

end function. /* qg_lFieldExistsInDatabaseSchema */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION qg_lIsPhysicalDatabase Method-Library
function qg_lIsPhysicalDatabase returns logical 
  ( pcDatabaseName as character ):
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if pcDatabaseName = {&K_PROGRESS_TTNAME} then
  
  return no.

if can-find( first ttDatabase
               where ttDatabase.DatabaseName = pcDatabaseName
                 and ttDatabase.PhysicalDB   = yes ) then
  
  return yes.

return no.

end function. /* qg_lIsPhysicalDatabase */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION qg_tDateDateFromUSFormat Method-Library
function qg_tDateDateFromUSFormat returns date 
  ( pcDateString as character ):
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Returns the date for a given date string in US format                      */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcDateString   date(time-tz) string in US format (mm/dd/yyyy)              */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

return date(qg_tzDateDateTimeTzFromUSFormat(pcDateString)).

end function. /* qg_tDateDateFromUSFormat */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION qg_tzDateDateTimeTzFromUSFormat Method-Library
function qg_tzDateDateTimeTzFromUSFormat returns datetime-tz 
  ( pcDateString as character ):
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Returns the datetime-tz for a given date string in US format               */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcDateString   date(time-tz) string in US format (mm/dd/yyyy)              */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cDateFormat as character     no-undo.
define variable tzInitDate  as datetime-tz   no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/    

if    pcDateString = ?
   or pcDateString = '?':U
   or pcDateString = 'now':U then

  tzInitDate = datetime-tz(pcDateString).

else if pcDateString = 'today':U then

  tzInitDate = datetime-tz(today).

else

  assign
    cDateFormat         = session:date-format
    session:date-format = 'mdy':U
    tzInitDate          = datetime-tz(pcDateString)
    session:date-format = cDateFormat
    .

return tzInitDate.

catch oErr as Progress.Lang.Error :

  return ?.

end catch.

finally:
  
  if cDateFormat > '':U then
    
    session:date-format = cDateFormat.
  
end finally.
  
end function. /* qg_tzDateDateTimeTzFromUSFormat */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

/* <<< Include: incl/core.i <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

/* >>> Include: incl/database_schema.i >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> */

/*------------------------------------------------------------------------
    File        : database_schema.i
    Purpose     : 

    Syntax      :

    Description : 

    Author(s)   : Thiemann_M
    Created     : Wed Apr 06 11:56:21 CEST 2022
    Notes       :
  ----------------------------------------------------------------------*/

/* ***************************  Definitions  ************************** */


/* ********************  Preprocessor Definitions  ******************** */


/* ***************************  Main Block  *************************** */



/* **********************  Internal Procedures  *********************** */

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddDatabase hQueryWindow 
PROCEDURE qg_AddDatabase :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Add database to cache.                                                     */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcDatabase                     = logical name of database that should be   */
/*                                  added.                                    */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcDatabase as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cSchemaDatabaseName as character no-undo.
define variable hTableBuffer        as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttDatabase  for temp-table ttDatabase.
define buffer b2ttDatabase for temp-table ttDatabase.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

create bttDatabase.

assign
  cSchemaDatabaseName                 = sdbname( pcDatabase )
  bttDatabase.DatabaseName            = ldbname(pcDatabase)
  bttDatabase.PhysicalName            = trim(pdbname(pcDatabase), '/\':U)
  
  /* We assume that if the database is connected via shared mameory the       */
  /* pyhsical name contains a path.                                           */
  
  bttDatabase.SharedMemory            =    index(bttDatabase.PhysicalName, '/':U) > 0
                                        or index(bttDatabase.PhysicalName, '\':U) > 0
  bttDatabase.DirectoryName           = (if r-index(bttDatabase.PhysicalName, '\':U) > r-index(bttDatabase.PhysicalName, '/':U) then
                                           substring(bttDatabase.PhysicalName, 1, r-index(bttDatabase.PhysicalName, '\':U))
                                         else
                                           substring(bttDatabase.PhysicalName, 1, r-index(bttDatabase.PhysicalName, '/':U)))
  bttDatabase.DirectoryName           = replace(bttDatabase.DirectoryName, '/':U, '\':U)
  bttDatabase.PhysicalDB              = yes
  bttDatabase.DisplayPriority         = 1000.
  .

/* Check if this database contains repository information. */

create buffer hTableBuffer for table substitute( '&1._File':U, cSchemaDatabaseName ).

hTableBuffer:find-first(substitute('where &1._File._File-Name = "DRC_Table"':U,
                                   bttDatabase.DatabaseName),
                        no-lock) no-error.

bttDatabase.BasisDB = hTableBuffer:available.

if bttDatabase.BasisDB then
do:
  
  bttDatabase.BasisDBName = bttDatabase.DatabaseName.
  
  if bttDatabase.DirectoryName > '':U then
  do:
    
    for each b2ttDatabase
      where b2ttDatabase.DirectoryName = bttDatabase.DirectoryName
        and b2ttDatabase.BasisDBName  = '':U
      on error undo, throw:
      
      b2ttDatabase.BasisDBName = b2ttDatabase.DatabaseName.
      
    end. /* for each b2ttDatabase */
    
  end. /* if b2ttDatabase.DirectoryName > '':U */
  
end. /* if bttDatabase.BasisDB */

else
do:
  
  if bttDatabase.DirectoryName > '':U then
  do:
    
    find first b2ttDatabase
      where b2ttDatabase.DirectoryName = bttDatabase.DirectoryName
        and b2ttDatabase.BasisDB       = yes
      no-lock no-error.
    
    if available b2ttDatabase then
      bttDatabase.BasisDBName = b2ttDatabase.DatabaseName.
    
  end. /* if bttDatabase.DirectoryName > '':U */
  
end. /* else: if bttDatabase.BasisDB */

if not bttDatabase.BasisDB then
do:
  
  if bttDatabase.DatabaseName = 'temp-db':U then
    bttDatabase.TempDB = yes.
  
  else
  do:
    
    hTableBuffer:find-first(substitute( 'where &1._File._File-Name begins "TD_"':U,
                                        cSchemaDatabaseName ),
                            no-lock) no-error.
  
    bttDatabase.TempDB = hTableBuffer:available.
    
  end. /* if bttDatabase.DatabaseName = 'temp-db':U */
  
end. /* if not bttDatabase.BasisDB */

assign
  bttDatabase.VirtualDBFieldsPossible = qg_lVirtualDBFieldsPossible( buffer bttDatabase )
  bttDatabase.VirtualIndicesPossible  = qg_lVirtualIndexPossible( buffer bttDatabase )
  .

validate bttDatabase.

finally:
  
  delete object hTableBuffer no-error.
  
  hide frame fStatus.
  
end finally.
  
end procedure. /* qg_AddDatabase */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddIndices hQueryWindow 
PROCEDURE qg_AddIndices :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Add Indices of given Table to cache.                                       */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcDatabase                     = Database that contains the Table of the   */
/*                                  indices that should be added.             */
/* pcTable                        = Table that contains the indices that      */
/*                                  should be added.                          */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcDatabase as character no-undo.
define input parameter pcTable    as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cSchemaDatabaseName  as character no-undo.

define variable hFileBuffer          as handle    no-undo.
define variable hFieldBuffer         as handle    no-undo.

define variable cIndexQueryText      as character no-undo.
define variable hIndexQuery          as handle    no-undo.
define variable hIndexBuffer         as handle    no-undo.

define variable cIndexFieldQueryText as character no-undo.
define variable hIndexFieldQuery     as handle    no-undo.
define variable hIndexFieldBuffer    as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttIndex      for temp-table ttIndex.
define buffer bttIndexField for temp-table ttIndexField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if    pcDatabase > '':U
  and pcTable    > '':U then
do:
  
  cSchemaDatabaseName = sdbname( pcDatabase ).
  
  create buffer hFileBuffer       for table substitute('&1._File':U, cSchemaDatabaseName).
  create buffer hIndexBuffer      for table substitute('&1._Index':U, cSchemaDatabaseName).
  create buffer hIndexFieldBuffer for table substitute('&1._Index-Field':U, cSchemaDatabaseName).
  create buffer hFieldBuffer      for table substitute('&1._Field':U, cSchemaDatabaseName).
  
  hFileBuffer:find-first(substitute('where _File._File-Name = &1':U,
                                    quoter(pcTable)),
                         no-lock) no-error.
  
  if not hFileBuffer:available then
    leave.
  
  assign
    cIndexQueryText      =            'for each _Index':U
                           + '~n':U + '  where _Index._File-recid = &1':U
                           + '~n':U + '  no-lock':U
    cIndexFieldQueryText =            'for each _Index-Field':U
                           + '~n':U + '  where _Index-Field._Index-recid = &1':U
                           + '~n':U + '  no-lock':U
    .
  
  create query hIndexQuery.
  create query hIndexFieldQuery.
  
  hIndexQuery:set-buffers(hIndexBuffer).
  hIndexFieldQuery:set-buffers(hIndexFieldBuffer).
  
  hIndexQuery:query-prepare(substitute(cIndexQueryText, quoter(hFileBuffer:recid))).
  hIndexQuery:query-open().
  
  hIndexQuery:get-first().
  
  do while not hIndexQuery:query-off-end:
    
    create bttIndex.
    
    assign
      bttIndex.DatabaseName = pcDatabase
      bttIndex.TableName    = pcTable
      bttIndex.IndexName    = hIndexBuffer::_Index-Name
      bttIndex.IsPrimary    = (hIndexBuffer:recid = hFileBuffer::_Prime-Index)
      bttIndex.IsUnique     = hIndexBuffer::_Unique
      .
    
    hIndexFieldQuery:query-prepare(substitute(cIndexFieldQueryText, quoter(hIndexBuffer:recid))).
    hIndexFieldQuery:query-open().
    
    hIndexFieldQuery:get-first().
    
    do while not hIndexFieldQuery:query-off-end:
      
      hFieldBuffer:find-first(substitute('where recid(_Field) = &1':U,
                                         quoter(hIndexFieldBuffer::_Field-recid)),
                              no-lock) no-error.
      
      if not hFieldBuffer:available then
        next.
      
      create bttIndexField.
    
      assign
        bttIndexField.DatabaseName  = pcDatabase
        bttIndexField.TableName     = pcTable
        bttIndexField.IndexName     = hIndexBuffer::_Index-Name
        bttIndexField.FieldName     = hFieldBuffer::_Field-Name
        bttIndexField.IndexSequence = hIndexFieldBuffer::_Index-Seq
        bttIndexField.DataType      = hFieldBuffer::_Data-Type
        bttIndexField.SortAscending = hIndexFieldBuffer::_Ascending
        bttIndex.IndexFieldList     = substitute('&1,&2':U,
                                                 bttIndex.IndexFieldList,
                                                 bttIndexField.FieldName)
        bttIndex.IndexFields        = substitute('&1 &2&3':U,
                                                 bttIndex.IndexFields,
                                                 string(bttIndexField.SortAscending, '+/-':U),
                                                 bttIndexField.FieldName)
        .
      
      hIndexFieldQuery:get-next().
      
    end. /* do while not hIndexFieldQuery:query-off-end */
    
    assign
      bttIndex.IndexFieldList = trim(bttIndex.IndexFieldList, ',':U)
      bttIndex.IndexFields    = trim(bttIndex.IndexFields)
      .
    
    hIndexQuery:get-next().
    
  end. /* do while not hIndexQuery:query-off-end */
  
end. /* if pcDBName > '':U */

finally:
  
  if valid-handle (hFileBuffer) then
    delete object hFileBuffer.
  
  if valid-handle(hIndexQuery) then
    delete object hIndexQuery.
  
  if valid-handle (hIndexBuffer) then
    delete object hIndexBuffer.
  
  if valid-handle(hIndexFieldQuery) then
    delete object hIndexFieldQuery.
  
  if valid-handle (hIndexFieldBuffer) then
    delete object hIndexFieldBuffer.
  
  if valid-handle (hFieldBuffer) then
    delete object hFieldBuffer.
  
end finally.
  
end procedure. /* qg_AddIndices */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddTableDetails hQueryWindow 
PROCEDURE qg_AddTableDetails :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Load additional information for the given table.                           */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcDatabaseName                 = Name of the database that contains the    */
/*                                  table.                                    */
/* pcTableName                    = Table name for which to load the          */
/*                                  additional information.                   */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcDatabaseName as character no-undo.
define input parameter pcTableName    as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cBasisDBName           as character no-undo.
define variable cRepTableName          as character no-undo.

define variable cQueryText             as character no-undo.
define variable hQuery                 as handle    no-undo.

define variable hRepFieldBuffer        as handle    no-undo.
define variable hRepDomainBuffer       as handle    no-undo.

define variable cRepRelQueryText       as character no-undo.
define variable hRepRelQuery           as handle    no-undo.
define variable hRepRelBuffer          as handle    no-undo.

define variable cRepRelFieldQueryText  as character no-undo.
define variable hRepRelFieldQuery      as handle    no-undo.
define variable hRepRelFieldBuffer     as handle    no-undo.
define variable hRepField1Buffer       as handle    no-undo.
define variable hRepField2Buffer       as handle    no-undo.

define variable cRelParentFieldDetails as character no-undo.
define variable cRelChildFieldDetails  as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttDatabase           for temp-table ttDatabase.
define buffer bttTable              for temp-table ttTable.
define buffer bttField              for temp-table ttField.
define buffer bttTableRelation      for temp-table ttTableRelation.
define buffer bttTableRelationField for temp-table ttTableRelationField.
define buffer b1ttTableRelationView for temp-table ttTableRelationView.
define buffer b2ttTableRelationView for temp-table ttTableRelationView.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

find bttDatabase
  where bttDatabase.DatabaseName = pcDatabaseName
  no-error.

if not available bttDatabase then
  leave.

find first bttTable
  where bttTable.TableName = pcTableName
  no-error.

if not available bttTable then
  leave.

/* Add table repository information. */

if not bttTable.DescriptionLoaded then
  run qg_AddTableRepositoryInfo(bttTable.DatabaseName, bttTable.TableName).

/* Add indices if necessary. */

if not can-find(first ttIndex
                  where ttIndex.DatabaseName = bttTable.DatabaseName
                    and ttIndex.TableName    = bttTable.TableName) then
  
  run qg_AddIndices(bttTable.DatabaseName, bttTable.TableName).

cBasisDBName = bttDatabase.BasisDBName.

if    cBasisDBName > '':U
  and connected(cBasisDBName) then
do:

  /* Add proALPHA repository information. */
  
  create query hQuery.
  
  create buffer hRepFieldBuffer  for table substitute('&1.DRC_Field':U, cBasisDBName) no-error.
  create buffer hRepDomainBuffer for table substitute('&1.DRC_Domain':U, cBasisDBName) no-error.
  
  hQuery:set-buffers(hRepFieldBuffer,
                     hRepDomainBuffer).
  
  cQueryText =            'for each DRC_Field':U
               + '~n':U + '  where DRC_Field.DRC_Table_Obj = &1':U
               + '~n':U + '  no-lock,':U
               + '~n':U + 'first DRC_Domain left outer-join':U
               + '~n':U + '  where DRC_Domain.DRC_Domain_Obj = DRC_Field.DRC_Domain_Obj':U
               + '~n':U + '  no-lock':U.
  
  hQuery:query-prepare(substitute(cQueryText,
                                  quoter(bttTable.RepObjectId))).
  hQuery:query-open().
  
  hQuery:get-first().
  
  do while not hQuery:query-off-end:
    
    find first bttField
      where bttField.DatabaseName = pcDatabaseName
        and bttField.TableName    = pcTableName
        and bttField.FieldName    = hRepFieldBuffer::DRC_Field_ID
      no-error.
    
    if available bttField then
    do:
      
      assign
        bttField.RepObjectId = hRepFieldBuffer::DRC_Field_Obj
        bttField.Domain      = (if hRepDomainBuffer:available then
                                  hRepDomainBuffer::DRC_Domain_ID
                                else
                                  '':U)
        bttField.IsObjectId =  (     bttField.IsObjectId
                                  or lookup(bttField.Domain, {&K_OBJECT_ID_DOMAIN}) > 0 )
        .
      
    end. /* if available bttField */
    
    hQuery:get-next().
    
  end. /* do while not hQuery:query-off-end */
  
  if bttDatabase.VirtualDBFieldsPossible then
    
    run qg_AddTableVirtualDBFields( buffer bttDatabase,
                                    buffer bttTable ).
    
  if bttDatabase.VirtualIndicesPossible then
     
    run qg_AddTableVirtualIndices( buffer bttDatabase,
                                   buffer bttTable ).
    
  create query hRepRelQuery.
  create query hRepRelFieldQuery.
  
  create buffer hRepRelBuffer for table substitute('&1.DRC_Relation':U, cBasisDBName) no-error.
  
  if valid-handle(hRepRelBuffer) then
    create buffer hRepRelFieldBuffer for table substitute('&1.DRC_RelationField':U, cBasisDBName) no-error.
  
  else
  do:
    
    create buffer hRepRelBuffer for table substitute('&1.D_Rel':U, cBasisDBName) no-error.
    
    if valid-handle(hRepRelBuffer) then
      create buffer hRepRelFieldBuffer for table substitute('&1.D_RelSpalte':U, cBasisDBName) no-error.
    
  end. /* if valid-handle(hRepRelBuffer) then */
  
  if    valid-handle(hRepRelBuffer)
    and valid-handle(hRepRelFieldBuffer) then
  do:
    
    hRepRelQuery:set-buffers(hRepRelBuffer).
    
    if hRepRelBuffer:name = 'DRC_Relation':U then
    do:
      
      create buffer hRepField1Buffer for table 'DRC_Field':U buffer-name 'b1DRC_Field':U.
      create buffer hRepField2Buffer for table 'DRC_Field':U buffer-name 'b2DRC_Field':U.
      
      hRepRelFieldQuery:set-buffers(hRepRelFieldBuffer, hRepField1Buffer, hRepField2Buffer).
      
      assign
        cRepRelQueryText      =            'for each DRC_Relation':U
                                + '~n':U + '  where ( DRC_Relation.Parent_DRC_Table_Obj = &1':U
                                + '~n':U + '     or   DRC_Relation.Child_DRC_Table_Obj  = &1 )':U
                                + '~n':U + '  no-lock':U
        cRepRelFieldQueryText =            'for each DRC_RelationField':U
                                + '~n':U + '  where DRC_RelationField.DRC_Relation_Obj  = &1':U
                                + '~n':U + '  no-lock,':U
                                + '~n':U + 'first b1DRC_Field':U
                                + '~n':U + '  where b1DRC_Field.DRC_Field_Obj = DRC_RelationField.Parent_DRC_Field_Obj':U
                                + '~n':U + '  left outer-join':U
                                + '~n':U + '  no-lock,':U
                                + '~n':U + 'first b2DRC_Field':U
                                + '~n':U + '  where b2DRC_Field.DRC_Field_Obj = DRC_RelationField.Child_DRC_Field_Obj':U
                                + '~n':U + '  left outer-join':U
                                + '~n':U + '  no-lock':U
        .
      
      hRepRelQuery:query-prepare(substitute(cRepRelQueryText,
                                            quoter(bttTable.RepObjectId))).
      hRepRelQuery:query-open().
      
      hRepRelQuery:get-first().
      
      do while not hRepRelQuery:query-off-end:
      
        find bttTableRelation
          where bttTableRelation.DatabaseName     = pcDatabaseName
            and bttTableRelation.ParentTableName  = hRepRelBuffer::Parent_DRC_Table_ID
            and bttTableRelation.ChildTableName   = hRepRelBuffer::Child_DRC_Table_ID
            and bttTableRelation.SequentialNumber = hRepRelBuffer::DRC_Relation_ID
          no-error.
        
        if not available bttTableRelation then
        do:
          
          create bttTableRelation.
          
          assign
            giRelationSeq                     = giRelationSeq + 1
            bttTableRelation.RelationId       = giRelationSeq
            bttTableRelation.DatabaseName     = pcDatabaseName
            bttTableRelation.ParentTableName  = hRepRelBuffer::Parent_DRC_Table_ID
            bttTableRelation.ChildTableName   = hRepRelBuffer::Child_DRC_Table_ID
            bttTableRelation.SequentialNumber = hRepRelBuffer::DRC_Relation_ID
            bttTableRelation.RelationType     = hRepRelBuffer::RelationType
            .
          
          create b1ttTableRelationView.
          
          assign
            cRelParentFieldDetails                   = '':U
            giRelationViewSeq                        = giRelationViewSeq + 1
            b1ttTableRelationView.RelationViewId     = giRelationViewSeq
            b1ttTableRelationView.RelationId         = bttTableRelation.RelationId
            b1ttTableRelationView.DatabaseName       = bttTableRelation.DatabaseName
            b1ttTableRelationView.ReferenceTableName = bttTableRelation.ParentTableName
            b1ttTableRelationView.RelatedTableName   = bttTableRelation.ChildTableName
            b1ttTableRelationView.RelationType       = bttTableRelation.RelationType
            .
          
          create b2ttTableRelationView.
          
          assign
            cRelChildFieldDetails                    = '':U
            giRelationViewSeq                        = giRelationViewSeq + 1
            b2ttTableRelationView.RelationViewId     = giRelationViewSeq
            b2ttTableRelationView.RelationId         = bttTableRelation.RelationId
            b2ttTableRelationView.DatabaseName       = bttTableRelation.DatabaseName
            b2ttTableRelationView.ReferenceTableName = bttTableRelation.ChildTableName
            b2ttTableRelationView.RelatedTableName   = bttTableRelation.ParentTableName
            b2ttTableRelationView.RelationType       = (if num-entries(bttTableRelation.RelationType, ':':U) = 2 then
                                                          substitute('&1:&2':U,
                                                                     entry(2, bttTableRelation.RelationType, ':':U),
                                                                     entry(1, bttTableRelation.RelationType, ':':U))
                                                        else
                                                          '?':U)
            b2ttTableRelationView.ParentRelation     = yes
            .
          
          hRepRelFieldQuery:query-prepare(substitute(cRepRelFieldQueryText,
                                                     quoter(hRepRelBuffer::DRC_Relation_Obj))).
          hRepRelFieldQuery:query-open().
          
          hRepRelFieldQuery:get-first().
    
          do while not hRepRelFieldQuery:query-off-end:
    
            find bttTableRelationField
              where bttTableRelationField.RelationId = bttTableRelation.RelationId
                and bttTableRelationField.Order      = hRepRelFieldBuffer::DRC_RelationField_ID
              no-error.
            
            if not available bttTableRelationField then
            do:
      
              create bttTableRelationField.
              
              bttTableRelationField.RelationId = bttTableRelation.RelationId.
              
              assign
                bttTableRelationField.Order              = hRepRelFieldBuffer::DRC_RelationField_ID
                bttTableRelationField.ParentConstantData = hRepRelFieldBuffer::Parent_Constant_Data
                bttTableRelationField.ChildConstantData  = hRepRelFieldBuffer::Child_Constant_Data
                bttTableRelationField.FieldRelationType  = hRepRelFieldBuffer::ColumnInfoType
                .
              
              if hRepField1Buffer:available then
                bttTableRelationField.ParentFieldName = hRepField1Buffer::DRC_Field_ID.
              
              if hRepField2Buffer:available then
                bttTableRelationField.ChildFieldName = hRepField2Buffer::DRC_Field_ID.
              
              validate bttTableRelationField.
              
              assign
                bttTableRelation.ParentFields         = substitute('&1, &2':U,
                                                                   bttTableRelation.ParentFields,
                                                                   (if bttTableRelationField.ParentFieldName > '':U then
                                                                      bttTableRelationField.ParentFieldName
                                                                    else
                                                                      bttTableRelationField.ParentConstantData) )
                cRelParentFieldDetails                = substitute('&1   [ &2 = &3 ]':U,
                                                                   cRelParentFieldDetails,
                                                                   (if bttTableRelationField.ParentFieldName > '':U then
                                                                      bttTableRelationField.ParentFieldName
                                                                    else
                                                                      bttTableRelationField.ParentConstantData),
                                                                   (if bttTableRelationField.ChildFieldName > '':U then
                                                                      bttTableRelationField.ChildFieldName
                                                                    else
                                                                      bttTableRelationField.ChildConstantData))
                bttTableRelation.ChildFields          = substitute('&1, &2':U,
                                                                   bttTableRelation.ChildFields,
                                                                   (if bttTableRelationField.ChildFieldName > '':U then
                                                                      bttTableRelationField.ChildFieldName
                                                                    else
                                                                      bttTableRelationField.ChildConstantData))
                cRelChildFieldDetails                 = substitute('&1   [ &2 = &3 ]':U,
                                                                   cRelChildFieldDetails,
                                                                   (if bttTableRelationField.ChildFieldName > '':U then
                                                                      bttTableRelationField.ChildFieldName
                                                                    else
                                                                      bttTableRelationField.ChildConstantData),
                                                                   (if bttTableRelationField.ParentFieldName > '':U then
                                                                      bttTableRelationField.ParentFieldName
                                                                    else
                                                                      bttTableRelationField.ParentConstantData))
                .
              
              if bttTableRelationField.ParentFieldName > '':U then
                bttTableRelation.ParentFieldList = substitute('&1,&2':U,
                                                              bttTableRelation.ParentFieldList,
                                                              bttTableRelationField.ParentFieldName).
              
              if bttTableRelationField.ChildFieldName > '':U then
                bttTableRelation.ChildFieldList = substitute('&1,&2':U,
                                                             bttTableRelation.ChildFieldList,
                                                             bttTableRelationField.ChildFieldName).
              
            end. /* if not available bttTableRelationField */
            
            hRepRelFieldQuery:get-next().
            
          end. /* do while not hRepRelFieldQuery:query-off-end: */
          
          assign
            b1ttTableRelationView.ReferenceFields    = trim(bttTableRelation.ParentFields, ' ,':U)
            b1ttTableRelationView.RelatedFields      = trim(bttTableRelation.ChildFields, ' ,':U)
            b1ttTableRelationView.FieldDetails       = trim(cRelParentFieldDetails)
            b1ttTableRelationView.ReferenceFieldList = trim(bttTableRelation.ParentFieldList, ',':U)
            b1ttTableRelationView.RelatedFieldList   = trim(bttTableRelation.ChildFieldList, ',':U)
            b2ttTableRelationView.ReferenceFields    = trim(bttTableRelation.ChildFields, ' ,':U)
            b2ttTableRelationView.RelatedFields      = trim(bttTableRelation.ParentFields, ' ,':U)
            b2ttTableRelationView.FieldDetails       = trim(cRelChildFieldDetails)
            b2ttTableRelationView.RelatedFieldList   = trim(bttTableRelation.ParentFieldList, ',':U)
            b2ttTableRelationView.ReferenceFieldList = trim(bttTableRelation.ChildFieldList, ',':U)
            .
    
          validate b1ttTableRelationView.
          validate b2ttTableRelationView.
          
          validate bttTableRelation.
          
        end. /* if not available bttTableRelation */
        
        hRepRelQuery:get-next().
        
      end. /* do while not hRepRelQuery:query-off-end */
      
    end. /* if hRepRelBuffer:name = 'DRC_Relation':U */
    
    else
    do:
      
      hRepRelFieldQuery:set-buffers(hRepRelFieldBuffer).
      
      assign
        cRepRelQueryText      =            'for each D_Rel':U
                                + '~n':U + '  where ( D_Rel.Tabellenname_1 = &1':U
                                + '~n':U + '     or   D_Rel.Tabellenname_2 = &1 )':U
                                + '~n':U + '  no-lock':U
        cRepRelFieldQueryText =            'for each D_RelSpalte':U
                                + '~n':U + '  where D_RelSpalte.Tabellenname_1 = &1':U
                                + '~n':U + '    and D_RelSpalte.TabellenName_2 = &2':U
                                + '~n':U + '    and D_RelSpalte.lfdNr          = &3':U
                                + '~n':U + '  no-lock':U
        .
      
      hRepRelQuery:query-prepare(substitute(cRepRelQueryText,
                                            quoter(bttTable.RepTableId))).
      
      hRepRelQuery:query-open().
      
      hRepRelQuery:get-first().
      
      do while not hRepRelQuery:query-off-end:
        
        find bttTableRelation
          where bttTableRelation.DatabaseName     = pcDatabaseName
            and bttTableRelation.ParentTableName  = hRepRelBuffer::Tabellenname_1
            and bttTableRelation.ChildTableName   = hRepRelBuffer::Tabellenname_2
            and bttTableRelation.SequentialNumber = hRepRelBuffer::lfdNr
          no-error.
        
        if not available bttTableRelation then
        do:
          
          create bttTableRelation.
          
          assign
            giRelationSeq                     = giRelationSeq + 1
            bttTableRelation.RelationId       = giRelationSeq
            bttTableRelation.DatabaseName     = pcDatabaseName
            bttTableRelation.ParentTableName  = hRepRelBuffer::Tabellenname_1
            bttTableRelation.ChildTableName   = hRepRelBuffer::Tabellenname_2
            bttTableRelation.SequentialNumber = hRepRelBuffer::lfdNr
            bttTableRelation.RelationType     = hRepRelBuffer::Rel_Art
            .
          
          create b1ttTableRelationView.
          
          assign
            cRelParentFieldDetails                   = '':U
            giRelationViewSeq                        = giRelationViewSeq + 1
            b1ttTableRelationView.RelationViewId     = giRelationViewSeq
            b1ttTableRelationView.RelationId         = bttTableRelation.RelationId
            b1ttTableRelationView.DatabaseName       = bttTableRelation.DatabaseName
            b1ttTableRelationView.ReferenceTableName = bttTableRelation.ParentTableName
            b1ttTableRelationView.RelatedTableName   = bttTableRelation.ChildTableName
            b1ttTableRelationView.RelationType       = bttTableRelation.RelationType
            .
          
          create b2ttTableRelationView.
          
          assign
            cRelChildFieldDetails                    = '':U
            giRelationViewSeq                        = giRelationViewSeq + 1
            b2ttTableRelationView.RelationViewId     = giRelationViewSeq
            b2ttTableRelationView.RelationId         = bttTableRelation.RelationId
            b2ttTableRelationView.DatabaseName       = bttTableRelation.DatabaseName
            b2ttTableRelationView.ReferenceTableName = bttTableRelation.ChildTableName
            b2ttTableRelationView.RelatedTableName   = bttTableRelation.ParentTableName
            b2ttTableRelationView.RelationType       = (if num-entries(bttTableRelation.RelationType, ':':U) = 2 then
                                                          substitute('&1:&2':U,
                                                                     entry(2, bttTableRelation.RelationType, ':':U),
                                                                     entry(1, bttTableRelation.RelationType, ':':U))
                                                        else
                                                          '?':U)
            b2ttTableRelationView.ParentRelation     = yes
            .
  
          hRepRelFieldQuery:query-prepare(substitute(cRepRelFieldQueryText,
                                                     quoter(hRepRelBuffer::Tabellenname_1),
                                                     quoter(hRepRelBuffer::Tabellenname_2),
                                                     quoter(hRepRelBuffer::lfdNr))).
          hRepRelFieldQuery:query-open().
          
          hRepRelFieldQuery:get-first().
  
          do while not hRepRelFieldQuery:query-off-end:
            
            find bttTableRelationField
              where bttTableRelationField.RelationId = bttTableRelation.RelationId
                and bttTableRelationField.Order      = hRepRelFieldBuffer::Position
              no-error.
            
            if not available bttTableRelationField then
            do:
      
              create bttTableRelationField.
              
              assign
                bttTableRelationField.RelationId         = bttTableRelation.RelationId
                bttTableRelationField.Order              = hRepRelFieldBuffer::Position
                bttTableRelationField.FieldRelationType  = (if hRepRelFieldBuffer::SpaltenInfo > '':U then
                                                              hRepRelFieldBuffer::SpaltenInfo
                                                            else
                                                              'DB-Field':U)
                .
              
              if hRepRelFieldBuffer::SpaltenInfo = '':U then
                assign
                  bttTableRelationField.ParentFieldName = hRepRelFieldBuffer::SpaltenName_1
                  bttTableRelationField.ChildFieldName  = hRepRelFieldBuffer::SpaltenName_2
                  .
              
              else
              do:
                
                if can-find(ttField
                              where ttField.DatabaseName = pcDatabaseName
                                and ttField.TableName    = bttTableRelation.ParentTableName
                                and ttField.FieldName    = hRepRelFieldBuffer::SpaltenName_1) then
                  bttTableRelationField.ParentFieldName  = hRepRelFieldBuffer::SpaltenName_1.
                
                else
                  bttTableRelationField.ParentConstantData = hRepRelFieldBuffer::SpaltenName_1.
                
                if can-find(ttField
                              where ttField.DatabaseName = pcDatabaseName
                                and ttField.TableName    = bttTableRelation.ChildTableName
                                and ttField.FieldName    = hRepRelFieldBuffer::SpaltenName_2) then
                  bttTableRelationField.ChildFieldName   = hRepRelFieldBuffer::SpaltenName_2.
               
               else
                  bttTableRelationField.ChildConstantData = hRepRelFieldBuffer::SpaltenName_2.
                
              end. /* if hRepRelFieldBuffer::SpaltenInfo = '':U */
            
              validate bttTableRelationField.
              
              assign
                bttTableRelation.ParentFields = substitute('&1, &2':U,
                                                           bttTableRelation.ParentFields,
                                                           (if bttTableRelationField.ParentFieldName > '':U then
                                                              bttTableRelationField.ParentFieldName
                                                            else
                                                              bttTableRelationField.ParentConstantData) )
                cRelParentFieldDetails        = substitute('&1   [&2 = &3]':U,
                                                           cRelParentFieldDetails,
                                                           (if bttTableRelationField.ParentFieldName > '':U then
                                                              bttTableRelationField.ParentFieldName
                                                            else
                                                              bttTableRelationField.ParentConstantData),
                                                           (if bttTableRelationField.ChildFieldName > '':U then
                                                              bttTableRelationField.ChildFieldName
                                                            else
                                                              bttTableRelationField.ChildConstantData))
                bttTableRelation.ChildFields  = substitute('&1, &2':U,
                                                           bttTableRelation.ChildFields,
                                                           (if bttTableRelationField.ChildFieldName > '':U then
                                                              bttTableRelationField.ChildFieldName
                                                            else
                                                              bttTableRelationField.ChildConstantData))
                cRelChildFieldDetails         = substitute('&1   [&2 = &3]':U,
                                                           cRelChildFieldDetails,
                                                           (if bttTableRelationField.ChildFieldName > '':U then
                                                              bttTableRelationField.ChildFieldName
                                                            else
                                                              bttTableRelationField.ChildConstantData),
                                                           (if bttTableRelationField.ParentFieldName > '':U then
                                                              bttTableRelationField.ParentFieldName
                                                            else
                                                              bttTableRelationField.ParentConstantData))
                .
              
              if bttTableRelationField.ParentFieldName > '':U then
                bttTableRelation.ParentFieldList = substitute('&1,&2':U,
                                                              bttTableRelation.ParentFieldList,
                                                              bttTableRelationField.ParentFieldName).
              
              if bttTableRelationField.ChildFieldName > '':U then
                bttTableRelation.ChildFieldList = substitute('&1,&2':U,
                                                             bttTableRelation.ChildFieldList,
                                                             bttTableRelationField.ChildFieldName).
  
            end. /* if not available bttTableRelationField */
            
            hRepRelFieldQuery:get-next().
            
          end. /* do while not hRepRelFieldQuery:query-off-end */
          
          assign
            b1ttTableRelationView.ReferenceFields    = trim(bttTableRelation.ParentFields, ' ,':U)
            b1ttTableRelationView.RelatedFields      = trim(bttTableRelation.ChildFields, ' ,':U)
            b1ttTableRelationView.FieldDetails       = trim(cRelParentFieldDetails)
            b1ttTableRelationView.ReferenceFieldList = trim(bttTableRelation.ParentFieldList, ' ,':U)
            b1ttTableRelationView.RelatedFieldList   = trim(bttTableRelation.ChildFieldList, ' ,':U)
            b2ttTableRelationView.ReferenceFields    = trim(bttTableRelation.ChildFields, ' ,':U)
            b2ttTableRelationView.RelatedFields      = trim(bttTableRelation.ParentFields, ' ,':U)
            b2ttTableRelationView.FieldDetails       = trim(cRelChildFieldDetails)
            b2ttTableRelationView.RelatedFieldList   = trim(bttTableRelation.ParentFieldList, ' ,':U)
            b2ttTableRelationView.ReferenceFieldList = trim(bttTableRelation.ChildFieldList, ' ,':U)
            .
    
          validate b1ttTableRelationView.
          validate b2ttTableRelationView.
          
          validate bttTableRelation.
  
        end. /* if not available bttTableRelation */
          
        hRepRelQuery:get-next().
        
      end. /* do while not hRepRelQuery:query-off-end */
      
    end. /* else: if hRepRelBuffer:name = 'DRC_Relation':U */
    
  end. /* if    valid-handle(hRepRelBuffer) */
  
end. /* if    cBasisDBName > '':U ... */

bttTable.DetailsLoaded = yes.

finally:
  
  if valid-handle(hQuery) then
    delete object hQuery.
  
  if valid-handle(hRepDomainBuffer) then
    delete object hRepDomainBuffer.
  
  if valid-handle(hRepFieldBuffer) then
    delete object hRepFieldBuffer.
  
  if valid-handle(hRepRelQuery) then
    delete object hRepRelQuery.
  
  if valid-handle(hRepRelFieldQuery) then
    delete object hRepRelFieldQuery.
  
  if valid-handle(hRepRelBuffer) then
    delete object hRepRelBuffer.
  
  if valid-handle(hRepRelFieldBuffer) then
    delete object hRepRelFieldBuffer.

  if valid-handle(hRepField1Buffer) then
    delete object hRepField1Buffer.

  if valid-handle(hRepField2Buffer) then
    delete object hRepField2Buffer.

end finally.
  
end procedure. /* qg_AddTableDetails */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddTableRepositoryInfo hQueryWindow 
PROCEDURE qg_AddTableRepositoryInfo :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Add table repository information.                                          */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcDatabaseName as character no-undo.
define input parameter pcTableName    as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cBasisDBName        as character no-undo.
define variable cRepTableName       as character no-undo.

define variable hRepTableBuffer     as handle    no-undo.
define variable hRepTableDescBuffer as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttDatabase for temp-table ttDatabase.
define buffer bttTable    for temp-table ttTable.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

find bttDatabase
  where bttDatabase.DatabaseName = pcDatabaseName
  no-error.

if not available bttDatabase then
  leave.

find first bttTable
  where bttTable.TableName = pcTableName
  no-error.

if not available bttTable then
  leave.

cBasisDBName = bttDatabase.BasisDBName.

if    cBasisDBName > '':U
  and connected(cBasisDBName) then
do:

  /* Add proALPHA repository information. */
  
  cRepTableName = pcTableName.
  
  if    bttDatabase.TempDB
    and cRepTableName begins 'TD_':U then
    overlay(cRepTableName, 1, 3) = 'TT_':U. 
  
  create buffer hRepTableBuffer for table substitute('&1.DRC_Table':U,
                                                     cBasisDBName) no-error.
  
  if not valid-handle(hRepTableBuffer) then
    leave.
  
  hRepTableBuffer:find-first(substitute('where DRC_Table.DRC_Table_ID = &1':U,
                                        quoter(cRepTableName)),
                             no-lock) no-error.
  
  if not hRepTableBuffer:available then
    leave.
  
  create buffer hRepTableDescBuffer for table substitute('&1.DBM_ShortDescription':U,
                                                         cBasisDBName).
  
  assign
    bttTable.InternalIdentifier = hRepTableBuffer::InternalIdentifier
    bttTable.CompanyInclude     = hRepTableBuffer::CompanyInclude
    bttTable.KeyInclude         = hRepTableBuffer::KeyInclude
    bttTable.RepTableId         = hRepTableBuffer::DRC_Table_ID
    bttTable.RepObjectId        = hRepTableBuffer::DRC_Table_Obj
    .

  if valid-handle(hRepTableDescBuffer) then
  do:
    
    hRepTableDescBuffer:find-first( substitute(   'where DBM_ShortDescription.Owning_Obj = &1':U
                                                + '  and DBM_ShortDescription.Sprache    = &2':U,
                                                quoter( hRepTableBuffer::DRC_Table_Obj ),
                                                quoter( gcRepositoryLanguage ) ),
                                    no-lock ) no-error.
    
    if hRepTableDescBuffer:available then
      assign
        bttTable.ShortDescription  = hRepTableDescBuffer::ShortDesc1
        bttTable.DescriptionLoaded = yes
        .
    
  end. /* if valid-handle(hRepTableDescBuffer) */

end. /* if    cBasisDBName > '':U ... */

finally:
  
  if valid-handle(hRepTableBuffer) then
    delete object hRepTableBuffer.
  
  if valid-handle(hRepTableDescBuffer) then
    delete object hRepTableDescBuffer.
  
end finally.

end procedure. /* qg_AddTableRepositoryInfo */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddTables hQueryWindow 
PROCEDURE qg_AddTables :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Add Tables of given Database to cache.                                     */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcDatabase                     = Database that contains the tables that    */
/*                                  should be added.                          */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcDatabase as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cSchemaDatabaseName    as character no-undo.

define variable cTableQueryText        as character no-undo.
define variable cFieldQueryText        as character no-undo.
define variable hTableQuery            as handle    no-undo.
define variable hFieldQuery            as handle    no-undo.

define variable cTableName             as character no-undo.

define variable hFileBuffer            as handle    no-undo.
define variable hFieldBuffer           as handle    no-undo.

define variable cTriggerQueryText      as character no-undo.
define variable hTriggerQuery          as handle    no-undo.
define variable cTriggerEvent          as character no-undo.

define variable hFileTrigBuffer        as handle    no-undo.


/* Buffers -------------------------------------------------------------------*/

define buffer bttDatabase for temp-table ttDatabase.
define buffer bttTable    for temp-table ttTable.
define buffer bttField    for temp-table ttField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

display unless-hidden
  substitute('Loading database &1 ...':T,
             pcDatabase)
    @ gcStatusText60
  with frame fStatus
    no-labels
    overlay
    color messages
    centered
    view-as dialog-box
    width 65
    .
process events.

find bttDatabase
  where bttDatabase.DatabaseName = pcDatabase
  no-error.

if not available bttDatabase then
  leave.

cSchemaDatabaseName = sdbname( pcDatabase ).

create query hTableQuery.
create query hTriggerQuery.
create query hFieldQuery.

assign
  hTableQuery:forward-only   = yes
  hTriggerQuery:forward-only = yes
  hFieldQuery:forward-only   = yes
  .

create buffer hFileBuffer     for table substitute('&1._File':U, cSchemaDatabaseName).
create buffer hFileTrigBuffer for table substitute('&1._File-Trig':U, cSchemaDatabaseName).
create buffer hFieldBuffer    for table substitute('&1._Field':U, cSchemaDatabaseName).

hTableQuery:set-buffers(hFileBuffer).
hTriggerQuery:set-buffers(hFileTrigBuffer).
hFieldQuery:set-buffers(hFieldBuffer).

/* For some odd reason the queries are much faster, when no fields option is  */
/* present - thus the fields option has been removed. Joins somehow perform   */
/* very bad on dynamic queries as well. For this reason a separate query is   */
/* used for every table.                                                      */

assign
  cTableQueryText   =            'for each _File':U
                      + '~n':U + '  no-lock':U
  cFieldQueryText   =            'for each _Field':U
                      + '~n':U + '  where _Field._File-recid = &1':U
                      + '~n':U + '  no-lock':U
  cTriggerQueryText =            'for each _File-Trig':U
                      + '~n':U + '  where _File-Trig._File-Recid = &1':U
                      + '~n':U + '  no-lock':U
  .

hTableQuery:query-prepare(cTableQueryText).
hTableQuery:query-open().

hTableQuery:get-first().

do while not hTableQuery:query-off-end:
  
  create bttTable.
  
  assign
    bttTable.DatabaseName  = pcDatabase
    bttTable.TableName     = hFileBuffer::_File-Name
    cTableName             = bttTable.TableName
    bttTable.FillInclude   = substitute('&1.fld':U,
                                        hFileBuffer::_Dump-name)
    bttTable.PhysicalTable = yes
    .
  
  hTriggerQuery:query-prepare(substitute(cTriggerQueryText, string(hFileBuffer:recid))).
  hTriggerQuery:query-open().
  
  hTriggerQuery:get-first().
  
  do while not hTriggerQuery:query-off-end:
    
    cTriggerEvent = hFileTrigBuffer::_Event.
    
    case cTriggerEvent:
      
      when 'CREATE':U then
        assign
          bttTable.CreateTrigger         = hFileTrigBuffer::_Proc-Name
          bttTable.CreateTriggerProcName = substring(bttTable.CreateTrigger,
                                                     max(r-index(bttTable.CreateTrigger, '/':U),
                                                         r-index(bttTable.CreateTrigger, '\':U)) + 1)
          .
      
      when 'WRITE':U then
        assign
          bttTable.WriteTrigger         = hFileTrigBuffer::_Proc-Name
          bttTable.WriteTriggerProcName = substring(bttTable.WriteTrigger,
                                                     max(r-index(bttTable.WriteTrigger, '/':U),
                                                         r-index(bttTable.WriteTrigger, '\':U)) + 1)
          .
      
      when 'DELETE':U then
        assign
          bttTable.DeleteTrigger         = hFileTrigBuffer::_Proc-Name
          bttTable.DeleteTriggerProcName = substring(bttTable.DeleteTrigger,
                                                     max(r-index(bttTable.DeleteTrigger, '/':U),
                                                         r-index(bttTable.DeleteTrigger, '\':U)) + 1)
          .
      
    end case. /* case hFileTrigBuffer::_Event */
    
    hTriggerQuery:get-next().
    
  end. /* do while not hTriggerQuery:query-off-end */
  
  hFieldQuery:query-prepare(substitute(cFieldQueryText, string(hFileBuffer:recid))).
  hFieldQuery:query-open().
  
  hFieldQuery:get-first().
  
  do while not hFieldQuery:query-off-end:
    
    create bttField.
    
    assign
      bttField.DatabaseName      = pcDatabase
      bttField.TableName         = hFileBuffer::_File-Name
      bttField.FieldName         = hFieldBuffer::_Field-Name
      bttField.DataType          = substitute('&1&2':U,
                                              caps(substring(hFieldBuffer::_Data-Type, 1, 1)),
                                              lc(substring(hFieldBuffer::_Data-Type, 2)))
      bttField.FieldExtent       = hFieldBuffer::_Extent
      bttField.FieldInitialValue = hFieldBuffer::_Initial
      bttField.FieldLabel        = (if hFieldBuffer::_Label = ? then
                                      '':U
                                    else
                                      hFieldBuffer::_Label)
      bttField.FieldColumnLabel  = (if hFieldBuffer::_Col-label = ? then
                                      '':U
                                    else
                                      hFieldBuffer::_Col-label)
      bttField.FieldDecimals     = hFieldBuffer::_Decimals
      bttField.FieldFormat       = hFieldBuffer::_Format
      bttField.IsMandatory       = hFieldBuffer::_Mandatory
      bttField.FieldViewAs       = hFieldBuffer::_View-As
      bttField.IsObjectId        = ( bttField.FieldName matches '*_Obj':U )
      .
    
    hFieldQuery:get-next().
    
  end. /* do while not hFieldQuery:query-off-end */
  
  hTableQuery:get-next().
  
end. /* do while not hTableQuery:query-off-end */

finally:
  
  if valid-handle(hTableQuery) then
    delete object hTableQuery.
  
  if valid-handle (hFileBuffer) then
    delete object hFileBuffer.
  
  if valid-handle(hTriggerQuery) then
    delete object hTriggerQuery.
  
  if valid-handle (hFileTrigBuffer) then
    delete object hFileTrigBuffer.
  
  if valid-handle(hFieldQuery) then
    delete object hFieldQuery.
  
  if valid-handle (hFieldBuffer) then
    delete object hFieldBuffer.
  
end finally.
  
end procedure. /* qg_AddTables */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_LoadAllTableDetailsOfSingleDatabase Method-Library
procedure qg_LoadAllTableDetailsOfSingleDatabase :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcDatabaseName as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttTable for temp-table ttTable.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

display unless-hidden
  'Loading table details ...':T
    @ gcStatusText60
  with frame fStatus
    no-labels
    overlay
    color messages
    centered
    view-as dialog-box
    width 65
    in window {&WINDOW-NAME}
    .

process events.

for each bttTable
  where bttTable.DatabaseName  = pcDatabaseName
    and bttTable.DetailsLoaded = no
  on error undo, throw:
  
  run qg_AddTableDetails( bttTable.DatabaseName,
                          bttTable.TableName ).
  
end. /* for each bttTable */

finally:
  
  hide frame fStatus.
  
end finally.

end procedure. /* qg_LoadAllTableDetailsOfSingleDatabase */


/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

/* <<< Include: incl/database_schema.i <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

/* >>> Include: incl/query_window.i >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> */

/*------------------------------------------------------------------------
    File        : database_schema.i
    Purpose     : 

    Syntax      :

    Description : 

    Author(s)   : Thiemann_M
    Created     : Wed Apr 06 11:56:21 CEST 2022
    Notes       :
  ----------------------------------------------------------------------*/

/* ***************************  Definitions  ************************** */


/* ********************  Preprocessor Definitions  ******************** */


/* ***************************  Main Block  *************************** */



/* **********************  Internal Procedures  *********************** */

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddFieldToQueryBufferFieldsTempTable Method-Library
procedure qg_AddFieldToQueryBufferFieldsTempTable :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define parameter buffer pbttQueryBuffer for temp-table ttQueryBuffer.

define input        parameter phField            as handle    no-undo.
define input        parameter pcFieldName        as character no-undo.
define input        parameter piFieldIndex       as integer   no-undo.
define input        parameter plIsVirtual        as logical   no-undo.

define input        parameter pcFieldNameToMatch as character no-undo.
define input-output parameter ioprMatch          as rowid     no-undo extent 4.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryBufferField for temp-table ttQueryBufferField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

create bttQueryBufferField.

assign
  bttQueryBufferField.FieldHandle = phField
  bttQueryBufferField.FieldName   = pcFieldName
  bttQueryBufferField.FieldIndex  = piFieldIndex
  bttQueryBufferField.DisplayName = qg_cFormattedFieldName(?,
                                                           ?,
                                                           bttQueryBufferField.FieldName,
                                                           bttQueryBufferField.FieldIndex)
  bttQueryBufferField.IsVirtual   = plIsVirtual
  .

validate bttQueryBufferField.

if pcFieldNameToMatch > '':U then
do:
  
  if    ioprMatch[1]                  = ?
    and bttQueryBufferField.FieldName = pcFieldNameToMatch then
    
    ioprMatch[1] = rowid(bttQueryBufferField).
  
  else if ioprMatch[2]                       = ?
    and   bttQueryBufferField.FieldName begins pcFieldNameToMatch then
    
    ioprMatch[2] = rowid(bttQueryBufferField).
  
  else if ioprMatch[3]                        = ?
    and   pcFieldNameToMatch            matches '*_Obj':U
    and   bttQueryBufferField.FieldName       = substitute('&1_Obj':U,
                                                           pbttQueryBuffer.BufferHandle:table) then
    ioprMatch[3] = rowid(bttQueryBufferField).
  
  else if ioprMatch[4]                        = ?
    and   pcFieldNameToMatch            matches '*_Obj':U
    and   bttQueryBufferField.FieldName matches '*_Obj':U then
    
    ioprMatch[4] = rowid(bttQueryBufferField).
  
end. /* if pcFieldNameToMatch > '':U */

end procedure. /* qg_AddFieldToQueryBufferFieldsTempTable */


/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddFieldToQueryWindowObjFieldTempTable Method-Library
procedure qg_AddFieldToQueryWindowObjFieldTempTable :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define parameter buffer pbttQueryWindow for temp-table ttQueryWindow.

define input parameter pcDatabaseName as character no-undo.
define input parameter pcBufferName   as character no-undo.
define input parameter pcTableName    as character no-undo.
define input parameter pcFieldName    as character no-undo.
define input parameter piFieldIndex   as integer   no-undo.
define input parameter pcFieldValue   as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindowObjField for temp-table ttQueryWindowObjField.

define buffer bttField               for temp-table ttField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

create bttQueryWindowObjField.

assign
  bttQueryWindowObjField.WindowHandle = pbttQueryWindow.WindowHandle
  bttQueryWindowObjField.DatabaseName = pcDatabaseName
  bttQueryWindowObjField.TableName    = pcTableName
  bttQueryWindowObjField.BufferName   = pcBufferName
  bttQueryWindowObjField.FieldName    = pcFieldName
  bttQueryWindowObjField.FieldIndex   = piFieldIndex
  bttQueryWindowObjField.DisplayName  = qg_cFormattedFieldName(?,
                                                               ?,
                                                               bttQueryWindowObjField.FieldName,
                                                               bttQueryWindowObjField.FieldIndex)
  .

find bttField
  where bttField.DatabaseName = bttQueryWindowObjField.DatabaseName
    and bttField.TableName    = bttQueryWindowObjField.TableName
    and bttField.FieldName    = bttQueryWindowObjField.FieldName
  no-error.

assign
  bttQueryWindowObjField.IsObjectId = (     bttQueryWindowObjField.FieldName matches '*_Obj':U
                                         or ( available bttField
                                          and bttField.Domain = {&K_OBJECT_ID_DOMAIN}) )
  bttQueryWindowObjField.IsVirtual  = ( if available bttField then
                                          bttField.IsVirtual
                                        else
                                          no )
  bttQueryWindowObjField.FieldType  = ( if available bttField then
                                          bttField.FieldType
                                        else
                                          {&K_FIELD_TYPE_DB_FIELD} )
  .



bttQueryWindowObjField.ContainsObj  =     pcFieldValue                    <> ?
                                      and num-entries(pcFieldValue, ':':U) = 3
                                      and length(pcFieldValue)            >= 10.

if bttQueryWindowObjField.ContainsObj then
  
  run qg_GetObjectIdTable( pcDatabaseName,
                           pcFieldValue,
                           output bttQueryWindowObjField.TargetDatabaseName,
                           output bttQueryWindowObjField.TargetTableName ).
  
bttQueryWindowObjField.Priority = (if bttQueryWindowObjField.FieldName = substitute('&1_Obj':U, bttQueryWindowObjField.TableName) then
                                     3
                                   else if    bttQueryWindowObjField.IsObjectId
                                          and bttQueryWindowObjField.ContainsObj then
                                     1
                                   else if bttQueryWindowObjField.IsObjectId then
                                     2
                                   else if bttQueryWindowObjField.ContainsObj then
                                     4
                                   else
                                     5).

validate bttQueryWindowObjField.

end procedure. /* qg_AddFieldToQueryWindowObjFieldTempTable */


/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_FillQueryBufferFieldsTempTable Method-Library
procedure qg_FillQueryBufferFieldsTempTable :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define parameter buffer pbttQueryBuffer for temp-table ttQueryBuffer.

define input        parameter pcFieldNameToMatch as character no-undo.
define input        parameter plAddVirtualFields as logical   no-undo.

define input-output parameter ioprMatch          as rowid     no-undo extent 4.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBufferfield       as handle    no-undo.
define variable cDatabaseName      as character no-undo.
define variable iFieldCounter      as integer   no-undo.
define variable iFieldIndexCounter as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttField for temp-table ttField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

empty temp-table ttQueryBufferField.

/* Add physical fields. */

do iFieldCounter = 1 to pbttQueryBuffer.BufferHandle:num-fields:
  
  hBufferField = pbttQueryBuffer.BufferHandle:buffer-field(iFieldCounter).
  
  do iFieldIndexCounter = integer(hBufferField:extent > 0) to hBufferField:extent:
    
    run qg_AddFieldToQueryBufferFieldsTempTable( buffer pbttQueryBuffer,
                                                 hBufferField,
                                                 hBufferField:name,
                                                 iFieldIndexCounter,
                                                 no,
                                                 pcFieldNameToMatch,
                                                 input-output ioprMatch ).
    
  end. /* do iFieldIndexCounter = integer(hBufferField:extent > 0) to hBufferField:extent */
  
end. /* do iFieldCounter = 1 to pbttQueryBuffer.BufferHandle:num-fields */

/* Add virtual fields. */

if plAddVirtualFields then
do:
  
  cDatabaseName = qg_cDatabaseNameForTableOrBuffer( pbttQueryBuffer.BufferHandle ).
  
  if qg_lIsPhysicalDatabase( cDatabaseName ) then
    
    for each bttField
      where bttField.DatabaseName = cDatabaseName
        and bttField.TableName    = pbttQueryBuffer.BufferHandle:table
        and bttField.IsVirtual    = yes
      on error undo, throw:
      
      run qg_AddFieldToQueryBufferFieldsTempTable( buffer pbttQueryBuffer,
                                                   ?,
                                                   bttField.FieldName,
                                                   0,
                                                   bttField.IsVirtual,
                                                   pcFieldNameToMatch,
                                                   input-output ioprMatch ).
      
    end. /* for each bttField */
    
end. /* if plAddVirtualFields */

end procedure. /* qg_FillQueryBufferFieldsTempTable */


/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_GetOverlayColumnValue Method-Library
procedure qg_GetOverlayColumnValue :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define parameter buffer pbttFieldOverlay for temp-table ttFieldOverlay.

define input  parameter plDeepResolve   as logical   no-undo.
define input parameter  plRawValues     as logical   no-undo.

define output parameter opcOverlayValue as character no-undo.
define output parameter oplResolved     as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cFieldValue        as character no-undo.
define variable cKeyValues         as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttVirtualFieldColumn for temp-table ttVirtualFieldColumn.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if valid-handle( pbttFieldOverlay.FieldHandle ) then
  
  cFieldValue = pbttFieldOverlay.FieldHandle:buffer-value( pbttFieldOverlay.FieldIndex ).

else
do:
  
  find bttVirtualFieldColumn
    where bttVirtualFieldColumn.OwnerHandle  = pbttFieldOverlay.OwnerHandle
      and bttVirtualFieldColumn.ColumnHandle = pbttFieldOverlay.ColumnHandle
    no-error.
  
  if not available bttVirtualFieldColumn then
    
    cFieldValue = ?.
  
  else
    
    cFieldValue = string( qg_clVirtualFieldValueAsLongchar( bttVirtualFieldColumn.FieldType,
                                                            bttVirtualFieldColumn.DataType,
                                                            bttVirtualFieldColumn.FieldName,
                                                            qg_cObjectIdForBuffer( bttVirtualFieldColumn.BufferHandle ),
                                                            ? ) ).
  
end. /* else: if valid-handle( pbttFieldOverlay.FieldHandle ) */

opcOverlayValue = cFieldValue.

if    cFieldValue > '':U
  and num-entries( cFieldValue, ':':U ) = 3 then
do:
  
  cKeyValues = qg_cOverlayFieldValue( buffer pbttFieldOverlay,
                                      cFieldValue,
                                      plDeepResolve ).

  if cKeyValues <> ? then
    
    assign
      opcOverlayValue = cKeyValues
      oplResolved     = yes
      .
  
end. /* if    cFieldValue > '':U ... */

end procedure. /* qg_GetOverlayColumnValue */


/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowAddSnapshot hQueryWindow 
PROCEDURE qg_QueryWindowAddSnapshot :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Add snapshot of current query.                                             */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow        as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer as handle no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if not valid-handle(bttQueryWindow.QueryHandle) then
  leave.

hBuffer = bttQueryWindow.QueryHandle:get-buffer-handle(1).

run qg_AddTableSnapshot(hBuffer,
                        bttQueryWindow.QueryHandle:prepare-string,
                        bttQueryWindow.WindowHandle).

apply 'entry' to bttQueryWindow.WindowHandle.

end procedure. /* qg_QueryWindowAddSnapshot */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowAddSortFields hQueryWindow 
PROCEDURE qg_QueryWindowAddSortFields :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Add sort phrase for given field list.                                      */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* pcSortFieldList                = List of fields to insert.                 */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow        as handle    no-undo.
define input parameter pcSortFieldList as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i              as integer   no-undo.

define variable hEditor        as handle    no-undo.
define variable cQuerytext     as character no-undo.
define variable iOffset        as integer   no-undo.
define variable iLineEndOffset as integer   no-undo.
define variable cInsertText    as character no-undo.
define variable iLine          as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.
define buffer bttQueryAST       for temp-table ttQueryAST.
define buffer bttQueryCondition for temp-table ttQueryCondition.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

/*----------------------------------------------------------------------------*/
/* Get selection info                                                         */
/*----------------------------------------------------------------------------*/

assign
  hEditor    = bttQueryWindow.QueryTextEditorHandle
  cQueryText = hEditor:input-value
  iOffset    = (if hEditor:selection-end = ? then
                  hEditor:cursor-offset
                else
                  hEditor:selection-end - 1)
  .

/*----------------------------------------------------------------------------*/
/* Analyze selection and query text                                           */
/*----------------------------------------------------------------------------*/

run qg_ParseQueryConditions(cQueryText).

find last bttQueryCondition
  no-error.

if    available bttQueryCondition
  and bttQueryCondition.RightEndPos > iOffset then
  iOffset = bttQueryCondition.RightEndPos.

find first bttQueryAST
  where bttQueryAST.TokenType = {&K_QP_TOKEN_TYPE_KEYWORD}
    and lookup(bttQueryAST.TokenText, 'BREAK,BY':U) > 0
  no-error.

if    available bttQueryAST
  and bttQueryAST.TokenStart > iOffset then
do:
  
  iLineEndOffset = r-index(cQueryText, '~n':U, bttQueryAST.TokenStart).

  iOffset = (if iLineEndOffset > 0 then
               iLineEndOffset
             else
               1).
  
end. /* if    available bttQueryAST ... */

find last bttQueryAST
  where bttQueryAST.TokenType = {&K_QP_TOKEN_TYPE_KEYWORD}
    and lookup(bttQueryAST.TokenText, 'BREAK,BY':U) > 0
  no-error.

if    available bttQueryAST
  and bttQueryAST.TokenEnd < iOffset then
  iOffset = bttQueryAST.TokenEnd.

iLineEndOffset = index(cQueryText, '~n':U, iOffset).

if iLineEndOffset > 0 then
  iOffset = iLineEndOffset.

/*----------------------------------------------------------------------------*/
/* Generate line text.                                                        */
/*----------------------------------------------------------------------------*/

do i = 1 to num-entries(pcSortFieldList):
  
  cInsertText = substitute('&1  by &2~n':U,
                           cInsertText,
                           entry(i, pcSortFieldList)).
  
end. /* do i = 1 to num-entries(pcSortFieldList) */

cInsertText = trim(cInsertText, '~n':U).

/*----------------------------------------------------------------------------*/
/* Insert text lines.                                                         */
/*----------------------------------------------------------------------------*/

run qg_InsertTextLines(cInsertText,
                       iOffset,
                       input-output cQueryText,
                             output iLine).

/*----------------------------------------------------------------------------*/
/* Update editor                                                              */
/*----------------------------------------------------------------------------*/

cQueryText = qg_cBeautifyQueryText(cQueryText).

run qg_UpdateEditor(hEditor,
                    cQueryText,
                    iLine,
                    iLine + max(0, num-entries(cInsertText, '~n':U) - 1)).

apply 'entry':U to hEditor.

end procedure. /* qg_QueryWindowAddSortFields */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowAddSortOption hQueryWindow 
PROCEDURE qg_QueryWindowAddSortOption :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Add selected fields as sort phrase.                                        */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* plDescending                   = Add sort option as descending sort.       */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow     as handle    no-undo.
define input parameter plDescending as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer                as handle    no-undo.
define variable cDatabaseName          as character no-undo.
define variable lPhysicalDatabase      as logical   no-undo.

define variable i                      as integer   no-undo.
define variable iFieldCount            as integer   no-undo.

define variable hFieldSelectionBuffer  as handle    no-undo.
define variable cSortFieldList         as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if bttQueryWindow.ObjSourceQuerySeq > 0 then
  leave.

hFieldSelectionBuffer = bttQueryWindow.QueryFieldBrowseBufferHandle.

assign
  hBuffer           = bttQueryWindow.QueryBrowseHandle:query:get-buffer-handle(1)
  cDatabaseName     = qg_cDatabaseNameForTableOrBuffer( hBuffer )
  lPhysicalDatabase = qg_lIsPhysicalDatabase( cDatabaseName )
  .

  
do i = 1 to bttQueryWindow.QueryFieldBrowseHandle:num-selected-rows:
  
  bttQueryWindow.QueryFieldBrowseHandle:fetch-selected-row (i).
  
  if    lPhysicalDatabase
    and hFieldSelectionBuffer::IsVirtual then
    
    message
      substitute( 'Virtual field &1 can not be used in the query!':T,
                  quoter( hFieldSelectionBuffer::FieldName ) ) skip
      view-as alert-box
      warning
      buttons ok
      in window bttQueryWindow.WindowHandle.
  
  else
    
    assign
      cSortFieldList = substitute('&1,&2&3':U,
                                  cSortFieldList,
                                  qg_cFormattedFieldName(?,
                                                         hFieldSelectionBuffer::BufferName,
                                                         hFieldSelectionBuffer::FieldName,
                                                         hFieldSelectionBuffer::FieldIndex),
                                  (if plDescending then
                                     ' descending':U
                                   else
                                     '':U))
      iFieldCount   = iFieldCount + 1
      .
  
end. /* i = 1 to bttQueryWindow.QueryFieldBrowseHandle:num-selected-rows */

if iFieldCount = 0 then
  
  return.

cSortFieldList = trim(cSortFieldList, ',':U).

if num-entries(cSortFieldList, ',':U) > 0 then
  run qg_QueryWindowAddSortFields(phWindow,
                                  cSortFieldList).

end procedure. /* qg_QueryWindowAddSortOption */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowBeautify hQueryWindow 
PROCEDURE qg_QueryWindowBeautify :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Beautify query text.                                                       */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cQueryText as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if bttQueryWindow.ObjSourceQuerySeq > 0 then
  leave.

assign
  cQueryText = bttQueryWindow.QueryTextEditorHandle:input-value
  cQueryText = qg_cBeautifyQueryText(cQueryText)
  bttQueryWindow.QueryTextEditorHandle:screen-value = cQueryText
  .

return no-apply.

end procedure. /* qg_QueryWindowBeautify */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowBufferComparisonStartMerge hQueryWindow 
PROCEDURE qg_QueryWindowBufferComparisonStartMerge :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter plAllFields     as logical   no-undo.
define input parameter pcFieldName     as character no-undo.
define input parameter piFieldIndex    as integer   no-undo.
define input parameter plCaseSensitive as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i             as integer   no-undo.

define variable cLabel        as character no-undo.
define variable iLongestLabel as integer   no-undo.

define variable clFieldValue1 as longchar  no-undo.
define variable clCompText1   as longchar  no-undo.
define variable cTitle1       as character no-undo.

define variable clFieldValue2 as longchar  no-undo.
define variable clCompText2   as longchar  no-undo.
define variable cTitle2       as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttBufferComparisonField  for temp-table ttBufferComparisonField.
define buffer b2ttBufferComparisonField for temp-table ttBufferComparisonField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

for each bttBufferComparisonField
  on error undo, throw:
  
  if    ( pcFieldName                            > '':U
      and ( bttBufferComparisonField.FieldName  <> pcFieldName
         or bttBufferComparisonField.FieldIndex <> piFieldIndex ) )
     or bttBufferComparisonField.DataType     = 'blob':U
     or ( not plAllFields
      and bttBufferComparisonField.IsEqual    = yes ) then
    next.
  
  assign
    cLabel        = qg_cFormattedFieldName(?,
                                           ?,
                                           bttBufferComparisonField.FieldName,
                                           bttBufferComparisonField.FieldIndex)
    iLongestLabel = maximum(length(cLabel), iLongestLabel)
    .
  
end. /* for each bttBufferComparisonField */

for each bttBufferComparisonField
  on error undo, throw:
  
  if    ( pcFieldName                            > '':U
      and ( bttBufferComparisonField.FieldName  <> pcFieldName
         or bttBufferComparisonField.FieldIndex <> piFieldIndex ) )
     or bttBufferComparisonField.DataType     = 'blob':U
     or ( not plAllFields
      and bttBufferComparisonField.IsEqual   <> no )
     or ( bttBufferComparisonField.BufferNo  = 2
      and can-find(ttBufferComparisonField
                     where ttBufferComparisonField.BufferNo   = 1
                       and ttBufferComparisonField.FieldName  = bttBufferComparisonField.FieldName
                       and ttBufferComparisonField.FieldIndex = bttBufferComparisonField.FieldIndex) ) then
    next.
  
  release b2ttBufferComparisonField.
  
  if bttBufferComparisonField.BufferNo = 1 then
  do:
    
    copy-lob bttBufferComparisonField.FieldValue to clFieldValue1.
    
    if clFieldValue1 = ? then
      clFieldValue1 = '?':U.
    
    assign
      cLabel      = qg_cFormattedFieldName(?,
                                           ?,
                                           bttBufferComparisonField.FieldName,
                                           bttBufferComparisonField.FieldIndex)
      clCompText1 =   clCompText1 + '~n':U
                    + (if pcFieldName > '':U then
                         clFieldValue1
                       else
                           cLabel
                         + fill(' ':U, iLongestLabel - length(cLabel))
                         + ': ':U
                         + quoter(string(clFieldValue1)))
      .
    
    if cTitle1 = '':U then
      cTitle1 = (if pcFieldName > '':U then
                   substitute('&1.&2.&3':U,
                              bttBufferComparisonField.DatabaseName,
                              bttBufferComparisonField.BufferName,
                              cLabel)
                 else
                   substitute('&1.&2':U,
                              bttBufferComparisonField.DatabaseName,
                              bttBufferComparisonField.BufferName)).
    
  end. /* if bttBufferComparisonField.BufferNo = 1 */
  
  find b2ttBufferComparisonField
    where b2ttBufferComparisonField.BufferNo   = 2
      and b2ttBufferComparisonField.FieldName  = bttBufferComparisonField.FieldName
      and b2ttBufferComparisonField.FieldIndex = bttBufferComparisonField.FieldIndex
    no-error.
  
  if available b2ttBufferComparisonField then
  do:
    
    copy-lob b2ttBufferComparisonField.FieldValue to clFieldValue2.
    
    if clFieldValue2 = ? then
      clFieldValue2 = '?':U.
    
    assign
      cLabel      = qg_cFormattedFieldName(?,
                                           ?,
                                           b2ttBufferComparisonField.FieldName,
                                           b2ttBufferComparisonField.FieldIndex)
      clCompText2 =   clCompText2 + '~n':U
                    + (if pcFieldName > '':U then
                         clFieldValue2
                       else
                           cLabel
                         + fill(' ':U, iLongestLabel - length(cLabel))
                         + ': ':U
                         + quoter(string(clFieldValue2)))
      .
    
    if cTitle2 = '':U then
      cTitle2 = (if pcFieldName > '':U then
                   substitute('&1.&2.&3':U,
                              b2ttBufferComparisonField.DatabaseName,
                              b2ttBufferComparisonField.BufferName,
                              cLabel)
                 else
                   substitute('&1.&2':U,
                              b2ttBufferComparisonField.DatabaseName,
                              b2ttBufferComparisonField.BufferName)).
    
  end. /* if available b2ttBufferComparisonField */
  
end. /* for each bttBufferComparisonField */

assign
  clCompText1 = trim(clCompText1, '~n':U)
  clCompText2 = trim(clCompText2, '~n':U)
  .

run qg_CompareText((if cTitle1 > '':U then
                      cTitle1
                    else
                      '<Undefined>':T),
                   clCompText1,
                   (if cTitle2 > '':U then
                      cTitle2
                    else
                      '<Undefined>':T),
                   clCompText2,
                   plCaseSensitive,
                   yes).

end procedure. /* qg_QueryWindowBufferComparisonStartMerge */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowBufferComparisonSelectFirstDifference hQueryWindow 
PROCEDURE qg_QueryWindowBufferComparisonSelectFirstDifference :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter plCaseSensitive as logical   no-undo.
define input parameter phField1        as handle    no-undo.
define input parameter phField2        as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable clFieldValue1   as longchar  no-undo.
define variable iField1Length   as integer   no-undo.
define variable cChar1          as character no-undo.

define variable clFieldValue2   as longchar  no-undo.
define variable iField2Length   as integer   no-undo.
define variable cChar2          as character no-undo.

define variable i               as integer   no-undo.
define variable iBufferNo       as integer   no-undo.
define variable iTemp           as integer   no-undo.
define variable iIndex1         as integer   no-undo.
define variable iIndex2         as integer   no-undo.
define variable iSelectionStart1 as integer   no-undo.
define variable iSelectionEnd1   as integer   no-undo.
define variable iSelectionStart2 as integer   no-undo.
define variable iSelectionEnd2   as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttBufferComparisonField  for temp-table ttBufferComparisonField.
define buffer b2ttBufferComparisonField for temp-table ttBufferComparisonField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

assign
  clFieldValue1 = phField1:input-value
  iField1Length = length(clFieldValue1)
  clFieldValue2 = phField2:input-value
  iField2Length = length(clFieldValue2)
  .

do i = 1 to maximum(iField1Length, iField2Length):
  
  if    iIndex1 > 0
    and i       > iIndex1
    and iIndex2 > 0
    and i       > iIndex2 then
    leave.
  
  assign
    cChar1 = substring(clFieldValue1, i, 1)
    cChar2 = substring(clFieldValue2, i, 1)
    .
  
  if compare(cChar1,
             'NE':U,
             cChar2,
             (if plCaseSensitive then
                'CASE-SENSITIVE':U
              else
                'CASE-INSENSITIVE':U)) then
  do:
    
    if iSelectionStart1 = 0 then
      iSelectionStart1 = i.
      
    if iSelectionStart2 = 0 then
      iSelectionStart2 = i.
    
  end. /* if cChar1 <> cChar2 */
  
  if    iSelectionStart1 > 0
    and cChar1           > '':U then
  do:
    
    iTemp = 0.
    
    do while yes:
      
      iTemp = index(clFieldValue2,
                    cChar1,
                    maximum(iSelectionStart1, iTemp + 1)).
      
      if iTemp = 0 then
        leave.
      
      if not compare(cChar1,
                     'EQ':U,
                     substring(clFieldValue2, iTemp, 1),
                     (if plCaseSensitive then
                        'CASE-SENSITIVE':U
                      else
                        'CASE-INSENSITIVE':U)) then
        next.
      
      if    iIndex1 = 0
         or iTemp   < iIndex1 then
      do:
        
        assign
          iIndex1        = iTemp
          iSelectionEnd1 = i
          .
        
        leave.
        
      end. /* if    iIndex1 = 0 */
      
    end. /* do while yes */
    
  end. /* if iSelectionStart1 > 0 */
  
  if    iSelectionStart2 > 0
    and cChar2           > '':U then
  do:
    
    iTemp = 0.
    
    do while yes:
      
      iTemp = index(clFieldValue1,
                    cChar2,
                    maximum(iSelectionStart2, iTemp + 1)).
      
      if iTemp = 0 then
        leave.
      
      if not compare(cChar2,
                     'EQ':U,
                     substring(clFieldValue1, iTemp, 1),
                     (if plCaseSensitive then
                        'CASE-SENSITIVE':U
                      else
                        'CASE-INSENSITIVE':U)) then
        next.
      
      if    iIndex2 = 0
         or iTemp   < iIndex2 then
      do:
        
        assign
          iIndex2        = iTemp
          iSelectionEnd2 = i
          .
        
        leave.
        
      end. /* if    iIndex2 = 0 */
      
    end. /* do while yes */
    
  end. /* if iSelectionStart2 > 0 */
  
end. /* do i = 1 to length(clFieldValue1) */

if iIndex2 > 0 then
do:
  
  iTemp = 0.
  
  do while yes:
  
    iTemp = index(clFieldValue1,
                  substring(clFieldValue1, iIndex2, 1),
                  maximum(iSelectionStart1, iTemp + 1)).
    
    if    iTemp > 0
      and not compare(substring(clFieldValue1, iIndex2, 1),
                      'EQ':U,
                      substring(clFieldValue1, iTemp, 1),
                      (if plCaseSensitive then
                         'CASE-SENSITIVE':U
                       else
                         'CASE-INSENSITIVE':U)) then
      next.
    
    if    iSelectionEnd1 > 0
      and iTemp          < iSelectionEnd1 then
      iSelectionEnd1 = iTemp.
    
    leave.
    
  end. /* do while yes */
  
end. /* if iIndex2 > 0 */

if iIndex1 > 0 then
do:
  
  iTemp = index(clFieldValue2,
                substring(clFieldValue2, iIndex1, 1),
                iSelectionStart2).
  
  if    iSelectionEnd2 > 0
    and iTemp          > iSelectionEnd2 then
    iSelectionEnd2 = iTemp.
  
end. /* if iIndex1 > 0 */

/* Line feeds count as one character in progress but are two        */
/* characters in the editor widget.                                 */

do i = 1 to iSelectionEnd1 - 1:
  
  if substring(clFieldValue1, i, 1) = '~n':U then
  do:
    
    if i < iSelectionStart1 then
      iSelectionStart1 = iSelectionStart1 + 1.
    
    iSelectionEnd1 = iSelectionEnd1 + 1.
    
  end. /* if substring(clFieldValue1, i, 1) = '~n':U */
  
end. /* do i = 1 to iSelectionEnd1 */

do i = 1 to iSelectionEnd2 - 1:
  
  if substring(clFieldValue2, i, 1) = '~n':U then
  do:
    
    if i < iSelectionStart2 then
      iSelectionStart2 = iSelectionStart2 + 1.
    
    iSelectionEnd2 = iSelectionEnd2 + 1.
    
  end. /* if substring(clFieldValue2, i, 1) = '~n':U */
  
end. /* do i = 1 to iSelectionEnd2 */

if iSelectionStart1 > 0 then
  phField1:set-selection(iSelectionStart1, iSelectionEnd1).

if iSelectionStart2 > 0 then
  phField2:set-selection(iSelectionStart2, iSelectionEnd2).

end procedure. /* qg_QueryWindowBufferComparisonSelectFirstDifference */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowCalculateSum hQueryWindow 
PROCEDURE qg_QueryWindowCalculateSum :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Calculate Sum for currently selected field.                                */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow            as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable dDecimalSum           as decimal   no-undo.
define variable iIntegerSum           as int64     no-undo.

define variable hQuery                as handle    no-undo.
define variable hFieldBuffer          as handle    no-undo.
define variable hField                as handle    no-undo.
define variable cBufferName           as character no-undo.
define variable iFieldType            as integer   no-undo.
define variable cDataType             as character no-undo.
define variable cFieldName            as character no-undo.
define variable iFieldIndex           as integer   no-undo.
define variable iDecimals             as integer   no-undo.
define variable iBufferCounter        as integer   no-undo.
define variable rCurrentRecords       as rowid     no-undo extent.
define variable lRestoreQueryPosition as logical   no-undo.

define variable cFormat               as character no-undo.

define variable cFieldSumLabel as character no-undo
  format 'x(255)':U
  view-as text
  size 56 by 1
  .

define variable cFieldSum as character no-undo
  format 'x(255)':U
  view-as fill-in
  size 45 by 1
  .

define button btnCopy
  label 'Copy':T
  size 10 by 1
  .

define button btnClose
  label 'Close':T
  size 20 by 1.14
  auto-go.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow        for temp-table ttQueryWindow.

define buffer bttVirtualFieldColumn for temp-table ttVirtualFieldColumn.
define buffer bttField              for temp-table ttField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

define frame fFieldSum
  cFieldSumLabel at row 1.5 col 3 no-label
  cFieldSum at row 3 col 3 no-label
  btnCopy at row 3 col 49
  btnClose at row 5 col 20
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    side-labels no-underline three-d 
    size 61 by 6.83
    title gcTitlePrefix + 'Field Sum':T
    default-button btnClose
    cancel-button btnClose.

on window-close of frame fFieldSum
  apply 'end-error' to self.

on choose of btnCopy in frame fFieldSum
  clipboard:value = cFieldSum.

if not valid-handle(phWindow) then
  return.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if    not available bttQueryWindow
   or not valid-handle( bttQueryWindow.QueryFieldBrowseHandle ) then
  return.

if not valid-handle( bttQueryWindow.QueryBrowseSelectedColumn ) then
  
  message
    'No field selected':T skip
    view-as alert-box
    error
    buttons ok
    in window bttQueryWindow.WindowHandle.

assign
  hQuery = bttQueryWindow.QueryHandle
  hField = bttQueryWindow.QueryBrowseSelectedColumn:buffer-field.

if valid-handle( hField ) then
  
  assign
    hFieldBuffer = hField:buffer-handle
    cBufferName  = hFieldBuffer:name
    iFieldType   = {&K_FIELD_TYPE_DB_FIELD}
    cDataType    = hField:data-type
    cFieldName   = hField:name
    iDecimals    = hField:decimals
    .

else
do:
  
  find first bttVirtualFieldColumn
    where bttVirtualFieldColumn.OwnerHandle  = hQuery
      and bttVirtualFieldColumn.ColumnHandle = bttQueryWindow.QueryBrowseSelectedColumn
    no-error.
  
  if not available bttVirtualFieldColumn then
    
    return.
  
  assign
    hFieldBuffer  = bttVirtualFieldColumn.BufferHandle
    cBufferName   = bttVirtualFieldColumn.BufferName
    iFieldType    = bttVirtualFieldColumn.FieldType
    cDataType     = bttVirtualFieldColumn.DataType
    cFieldName    = bttVirtualFieldColumn.FieldName
    iDecimals     = 0
    .
  
end.

assign
  iFieldIndex               = bttQueryWindow.QueryBrowseSelectedColumn:index
  extent( rCurrentRecords ) = hQuery:num-buffers
  .

if lookup( bttQueryWindow.QueryBrowseSelectedColumn:data-type, 'DECIMAL,INTEGER,INT64':U ) = 0 then
do:
  
  message
    'Sums can only be calculated for decimal, inter or int64 fields':T skip
    view-as alert-box
    error
    buttons ok
    in window bttQueryWindow.WindowHandle.
  
  return.
  
end. /* if lookup( bttQueryWindow.QueryBrowseSelectedColumn:data-type, 'DECIMAL,INTEGER,INT64':U ) = 0 */

lRestoreQueryPosition = (     hQuery:num-buffers > 0
                          and hQuery:get-buffer-handle( 1 ):available ).

do iBufferCounter = 1 to hQuery:num-buffers:
  rCurrentRecords[iBufferCounter] = hQuery:get-buffer-handle( iBufferCounter ):rowid.
end. /* do iBufferCounter = 1 to hQuery:num-buffers */

do on error undo, throw:
  
  hQuery:get-first().
  
  do while not hQuery:query-off-end:
    
    case string( bttQueryWindow.QueryBrowseSelectedColumn:data-type ):
      
      when 'DECIMAL':U then

        dDecimalSum =   dDecimalSum
                      + ( if valid-handle( hField ) then
                            decimal( hField:buffer-value( iFieldIndex ) )
                          else
                            decimal( qg_clVirtualFieldValueAsLongchar( iFieldType,
                                                                       cDataType,
                                                                       cFieldName,
                                                                       qg_cObjectIdForBuffer( hFieldBuffer ),
                                                                       ? ) ) ).
      
      otherwise
        
        iIntegerSum =   iIntegerSum
                      + ( if valid-handle( hField ) then
                            integer( hField:buffer-value( iFieldIndex ) )
                          else
                            integer( qg_clVirtualFieldValueAsLongchar( iFieldType,
                                                                       cDataType,
                                                                       cFieldName,
                                                                       qg_cObjectIdForBuffer( hFieldBuffer ),
                                                                       ? ) ) ).
      
    end case. /* string( hFieldSelectionBuffer::DataType ) */
    
    hQuery:get-next().
    
  end. /* do while not hQuery:query-off-end */
  
  assign
    cFieldSumLabel = substitute( 'Sum of Field &1:':T,
                                  qg_cFormattedFieldName( ?,
                                                          cBufferName,
                                                          cFieldName,
                                                          iFieldIndex ) )
    cFieldSum:read-only in frame fFieldSum = yes
    .
  
  case string( cDataType ):
    
    when 'DECIMAL':U then
    do:
      
      cFormat = substitute( '&1zz9':U, fill( 'zzz,':U, 17 ) ).
      
      if iDecimals > 0 then
        
        cFormat = substitute( '&1.&2':U, cFormat, fill( '9':U, iDecimals ) ).
      
      else
        
        cFormat = substitute( '&1.&2':U, cFormat, fill( '9':U, 10 ) ).
      
      cFieldSum = trim( string( dDecimalSum, cFormat ) ).
      
    end. /* when 'DECIMAL':U */
    
    otherwise
      
      assign
        cFormat   = '-z,zzz,zzz,zzz,zzz,zzz,zz9':U
        cFieldSum = trim( string( iIntegerSum, cFormat ) )
        .
    
  end case. /* string( hFieldSelectionBuffer::DataType ) */
  
  update unless-hidden
    cFieldSumLabel
    cFieldSum
    btnCopy
    btnClose
    with frame fFieldSum
      in window bttQueryWindow.WindowHandle.
  
  finally:
    
    if lRestoreQueryPosition then
      hQuery:reposition-to-rowid(rCurrentRecords).
    
  end finally.
  
end.

end procedure. /* qg_QueryWindowCalculateSum */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowClose hQueryWindow 
PROCEDURE qg_QueryWindowClose :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Close query window (and clean up dynamically created widgets).             */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* phQuery                        = Query of the Query window.                */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow            as handle    no-undo.
define input parameter plCloseChildWindows as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer          as handle    no-undo.
define variable rQueryWindowView as rowid     no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow                  for temp-table ttQueryWindow.
define buffer bttFieldOverlay                 for temp-table ttFieldOverlay.
define buffer bttQueryWindowQueryBrowseColumn for temp-table ttQueryWindowQueryBrowseColumn.
define buffer bttQueryWindowView              for temp-table ttQueryWindowView.
define buffer bttQueryLink                    for temp-table ttQueryLink.
define buffer bttRecentQuery                  for temp-table ttRecentQuery.
define buffer bttQueryWindowField             for temp-table ttQueryWindowField.
define buffer bttQueryWindowObjField          for temp-table ttQueryWindowObjField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if available bttQueryWindow then
do:
  
  if    plCloseChildWindows = ?
    and can-find(first ttQueryLink
                   where ttQueryLink.SourceSeq = bttQueryWindow.QuerySeq) then
    message
      'Do you want to close all linked child windows as well?':T
      view-as alert-box
      question
      buttons yes-no
      update plCloseChildWindows
      in window bttQueryWindow.WindowHandle.
    
  if plCloseChildWindows then
    run qg_QueryWindowCloseChildWindows(bttQueryWindow.QuerySeq).
  
  if valid-handle(bttQueryWindow.QueryBrowseHandle) then
    
    bttQueryWindow.QueryBrowseHandle:visible = no.
  
  run qg_RemoveAllVirtualFieldColums( buffer bttQueryWindow ).
  
  for each bttFieldOverlay
    where bttFieldOverlay.OwnerHandle = bttQueryWindow.QueryHandle
    on error undo, throw:
    
    run qg_DeleteFieldOverlay(bttFieldOverlay.OwnerHandle,
                              bttFieldOverlay.BufferName,
                              bttFieldOverlay.FieldName,
                              bttFieldOverlay.FieldIndex).
    
  end. /* for each bttFieldOverlay */
  
  for each bttQueryWindowQueryBrowseColumn
    where bttQueryWindowQueryBrowseColumn.WindowHandle = bttQueryWindow.WindowHandle:
    
    delete bttQueryWindowQueryBrowseColumn.
    
  end. /* for each bttQueryWindowQueryBrowseColumn */
  
  for each bttRecentQuery
    where bttRecentQuery.WindowHandle = bttQueryWindow.WindowHandle
    on error undo, throw:
    
    delete bttRecentQuery.
    
  end. /* for each bttRecentQuery */
  
  for each bttQueryLink
    where bttQueryLink.TargetSeq = bttQueryWindow.QuerySeq
    on error undo, throw:
    
    delete bttQueryLink.
    
  end. /* for each bttQueryLink */
  
  for each bttQueryWindowField
    where bttQueryWindowField.WindowHandle = bttQueryWindow.WindowHandle
    on error undo, throw:
    
    delete bttQueryWindowField.
    
  end. /* for each bttQueryWindowField */

  for each bttQueryWindowObjField
    where bttQueryWindowObjField.WindowHandle = bttQueryWindow.WindowHandle
    on error undo, throw:
    
    delete bttQueryWindowObjField.
    
  end. /* for each bttQueryWindowObjField */
  
  if valid-handle(ghQueryWindowListWindow) then
  do:
    
    hBuffer = ghQueryWindowListBrowse:query:get-buffer-handle(1).
    
    if hBuffer:available then
    do:
      
      if hBuffer::WindowHandle <> bttQueryWindow.WindowHandle then
        rQueryWindowView = hBuffer:rowid.
      
      else
      do:
        
        find last bttQueryWindowView
          where bttQueryWindowView.Id < hBuffer::Id
          no-error.
        
        if available bttQueryWindowView then
          rQueryWindowView = rowid(bttQueryWindowView).
        
      end. /* if hBuffer:WindowHandle <> bttQueryWindow:WindowHandle */
      
    end. /* if hBuffer:available */
    
  end. /* if valid-handle(ghQueryWindowListWindow) */
  
  for each bttQueryWindowView
    where bttQueryWindowView.ParentWindowHandle = bttQueryWindow.WindowHandle
    on error undo, throw:
    
    bttQueryWindowView.ParentWindowHandle = ?.
    
  end. /* for each bttQueryWindowView */
  
  for each bttQueryWindowView
    where bttQueryWindowView.WindowHandle = bttQueryWindow.WindowHandle
    on error undo, throw:
    
    delete bttQueryWindowView.
    
  end. /* for each bttQueryWindowView */
  
  delete bttQueryWindow.
  
end. /* if available bttQueryWindow */

/* Clean up all dynamically created objects. */

run qg_DeleteWidgetTree(phWindow, yes).

run qg_QueryWindowUpdateAll('':U).

run qg_QueryWindowListRefresh.

if    valid-handle(ghQueryWindowListWindow)
  and rQueryWindowView <> ? then
do:
  
  find bttQueryWindowView
    where rowid(bttQueryWindowView) = rQueryWindowView
    no-error.
  
  if available bttQueryWindowView then
    ghQueryWindowListBrowse:query:reposition-to-rowid(rowid(bttQueryWindowView)).
  
end. /* if    valid-handle(ghQueryWindowListWindow) */

if valid-handle(ghQueryWindowListWindow) then
  run qg_ActivateWindow(ghQueryWindowListWindow, ghQueryWindowListBrowse).

end procedure. /* qg_QueryWindowClose */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowCloseChildWindows hQueryWindow 
PROCEDURE qg_QueryWindowCloseChildWindows :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter piSourceSeq as integer   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow  for temp-table ttQueryWindow.
define buffer bttQueryLink    for temp-table ttQueryLink.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

for each bttQueryLink
  where bttQueryLink.SourceSeq = piSourceSeq,
first bttQueryWindow
  where bttQueryWindow.QuerySeq = bttQueryLink.TargetSeq
  on error undo, throw:
  
  run qg_QueryWindowCloseChildWindows(bttQueryWindow.QuerySeq).
  
  if valid-handle(bttQueryWindow.WindowHandle) then
    run qg_QueryWindowClose(bttQueryWindow.WindowHandle, no).
  
end. /* for each bttQueryLink */

end procedure. /* qg_QueryWindowCloseChildWindows */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowCompareSelectedRecords hQueryWindow 
PROCEDURE qg_QueryWindowCompareSelectedRecords :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phParentWindow  as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable lCaseSensitive   as logical   no-undo.

define variable iDifferentFields as integer   no-undo.
define variable dColOffset       as decimal   no-undo.

define variable cBufferLabel1    as character no-undo.
define variable hColLabel1       as handle    no-undo.
define variable cBufferLabel2    as character no-undo.
define variable hColLabel2       as handle    no-undo.

define variable hScrollBox       as handle    no-undo.

define variable lAllFields as logical no-undo
  format 'yes/no':U
  view-as radio-set
    radio-buttons
      'Different fields':T, no,
      'All fields':T, yes
    horizontal
  size 35 by 1.

define variable cCaseSensitive as character no-undo
  view-as text
  size 5 by 1 .

define rectangle rectCaseSensitive
  no-fill
  edge-pixels 2
  graphic-edge
  tooltip 'Switch to case sensitive mode':U
  size 7 by 1.5.

define button btnMerge
  label 'Merge':T
  tooltip 'Compare field values in Araxis Merge':T
  size 20 by 1.14.

define button btnCancel
  label 'Close':T
  size 20 by 1.14
  auto-end-key.

/* Buffers -------------------------------------------------------------------*/

define buffer bttBufferComparisonField  for temp-table ttBufferComparisonField.
define buffer b2ttBufferComparisonField for temp-table ttBufferComparisonField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

define frame fBufferComparison
    lAllFields at row 2 col 1 no-label
    rectCaseSensitive at row 1.75 col 1
    cCaseSensitive at row 2 col 1 no-label
    btnMerge at row 5 col 1
    btnCancel at row 5 col 1
  with 1 down keep-tab-order overlay
    view-as dialog-box
    side-labels no-underline three-d 
    size 170 by 6.94
    title gcTitlePrefix + 'Buffer comparison':T
    cancel-button btnCancel.

on window-close of frame fBufferComparison
  apply 'end-error' to self.

on choose of btnMerge
  run qg_QueryWindowBufferComparisonStartMerge(input frame fBufferComparison lAllFields,
                                               ?,
                                               ?,
                                               lCaseSensitive).

on value-changed of lAllFields in frame fBufferComparison
do:
  
  define variable iX as integer   no-undo.
  define variable iY as integer   no-undo.
  
  /* Update comparison field widgets. */
  
  if valid-handle(hScrollBox) then
    run qg_DeleteWidgetTree(hScrollBox:handle, yes).
  
  lAllFields = input frame fBufferComparison lAllFields.
  
  run qg_QueryWindowCreateBufferComparisonFrame(input-output hScrollBox,
                                                lCaseSensitive,
                                                lAllFields,
                                                      output iDifferentFields,
                                                      output dColOffset).
  
  
  /* Set dialog size. */
  
  assign
    iX                                               = frame fBufferComparison:x
    iY                                               = frame fBufferComparison:y
    frame fBufferComparison:title                    = substitute('&1Buffer comparison (&2&3 &4)':T,
                                                                  gcTitlePrefix,
                                                                  (if lCaseSensitive then
                                                                     'case sensitive, ':L
                                                                   else
                                                                     '':U),
                                                                  string(iDifferentFields),
                                                                  (if iDifferentFields = 1 then
                                                                     'difference':T
                                                                   else
                                                                     'differences':T))
    frame fBufferComparison:width-chars              = hScrollBox:width-chars  + 5
    frame fBufferComparison:virtual-width-chars      = frame fBufferComparison:width-chars
    frame fBufferComparison:height-chars             = hScrollBox:height-chars + 8
    frame fBufferComparison:virtual-height-chars     = frame fBufferComparison:height-chars
    frame fBufferComparison:x                        = iX
    frame fBufferComparison:y                        = iY
    lAllFields:col in frame fBufferComparison        =   ( frame fBufferComparison:width-chars
                                                       - lAllFields:width-chars in frame fBufferComparison )
                                                       / 2
    rectCaseSensitive:col in frame fBufferComparison =   frame fBufferComparison:width
                                                       - rectCaseSensitive:width in frame fBufferComparison
                                                       - 5
    cCaseSensitive:col in frame fBufferComparison   =   rectCaseSensitive:col in frame fBufferComparison
                                                      + (   rectCaseSensitive:width in frame fBufferComparison
                                                          - cCaseSensitive:width in frame fBufferComparison )
                                                      / 2
    btnMerge:row in frame fBufferComparison         = frame fBufferComparison:height-chars - 1.94
    btnCancel:row in frame fBufferComparison        = frame fBufferComparison:height-chars - 1.94
      .

  /* Hide merge button if araxis merge is not available. */

  if valid-handle(gchMerge) then
    assign
      btnMerge:col in frame fBufferComparison  = (frame fBufferComparison:width-chars / 2)
                                                   - btnMerge:width-chars in frame fBufferComparison 
      btnCancel:col in frame fBufferComparison = (frame fBufferComparison:width-chars / 2)
      .
  
  else
    btnCancel:col in frame fBufferComparison =   frame fBufferComparison:width-chars / 2
                                               - btnCancel:width-chars in frame fBufferComparison / 2.

  process events.
  
  assign
    hScrollBox:frame                             = frame fBufferComparison:handle
    hScrollBox:hidden                            = no
    hScrollBox:visible                           = yes
    .
  
  /* Remove horizontal scrollbar if necessary. */
  
  if hScrollBox:virtual-height-chars > hScrollBox:height-chars then
  do:
    
    display unless-hidden
      with frame fBufferComparison
        in window phParentWindow.
    
    run qg_SetScrollbars(hScrollBox:handle, no, ?).
    
  end. /* if hScrollBox:virtual-height-chars > hScrollBox:height-chars */

end. /* on value-changed of lAllFields in frame fBufferComparison */

on mouse-select-click of rectCaseSensitive in frame fBufferComparison
do:
  
  if lCaseSensitive then
  do:
    
    assign
      lCaseSensitive            = no
      rectCaseSensitive:filled  = no
      rectCaseSensitive:bgcolor = ?
      rectCaseSensitive:tooltip = 'Switch to case sensitive mode':T
      cCaseSensitive:bgcolor    = ?
      .
    
  end. /* if lCaseSensitive */
  
  else
  do:
    
    assign
      lCaseSensitive            = yes
      rectCaseSensitive:filled  = yes
      rectCaseSensitive:bgcolor = {&K_COLOR_YELLOW}
      rectCaseSensitive:tooltip = 'Switch to case insensitive mode':T
      cCaseSensitive:bgcolor    = {&K_COLOR_YELLOW}
      .
    
  end. /* else: if lCaseSensitive */
  
  process events.
  
  apply 'value-changed':U to lAllFields in frame fBufferComparison.
  
end. /* on mouse-select-click of rectCaseSensitive in frame fBufferComparison */

run qg_QueryWindowCreateBufferComparisonFrame(input-output hScrollBox,
                                              lCaseSensitive,
                                              no,
                                                    output iDifferentFields,
                                                    output dColOffset).

if iDifferentFields = 0 then
  message
    'The Records are identical':T skip
    view-as alert-box
    information
    in window phParentWindow.
  

/* Set dialog size. */

assign
  frame fBufferComparison:title                          = substitute('&1 (&2&3 differences)':U,
                                                                      frame fBufferComparison:title,
                                                                      (if lCaseSensitive then
                                                                         'case sensitive, ':L
                                                                       else
                                                                         '':U),
                                                                      string(iDifferentFields),
                                                                      (if iDifferentFields = 1 then
                                                                         'difference':T
                                                                       else
                                                                         'differences':T))
  frame fBufferComparison:width-chars                    = hScrollBox:width-chars  + 5
  frame fBufferComparison:height-chars                   = hScrollBox:height-chars + 8
  lAllFields:col in frame fBufferComparison              =   ( frame fBufferComparison:width-chars
                                                           - lAllFields:width-chars in frame fBufferComparison )
                                                           / 2
  rectCaseSensitive:col in frame fBufferComparison       =   frame fBufferComparison:width
                                                           - rectCaseSensitive:width in frame fBufferComparison
                                                           - 5
  rectCaseSensitive:sensitive in frame fBufferComparison = yes
  cCaseSensitive                                         = 'Aa':T
  cCaseSensitive:width in frame fBufferComparison        = font-table:get-text-width-chars(cCaseSensitive,
                                                                                          cCaseSensitive:font in frame fBufferComparison)
  cCaseSensitive:height in frame fBufferComparison       = font-table:get-text-height-chars(cCaseSensitive:font in frame fBufferComparison)
  cCaseSensitive:col in frame fBufferComparison          =   rectCaseSensitive:col in frame fBufferComparison
                                                           + (   rectCaseSensitive:width in frame fBufferComparison
                                                               - cCaseSensitive:width in frame fBufferComparison )
                                                           / 2
  cCaseSensitive:row in frame fBufferComparison          =   rectCaseSensitive:row in frame fBufferComparison
                                                           + (   rectCaseSensitive:height in frame fBufferComparison
                                                               - cCaseSensitive:height in frame fBufferComparison )
                                                           / 2
  btnMerge:row in frame fBufferComparison                = frame fBufferComparison:height-chars - 1.94
  btnCancel:row in frame fBufferComparison               = frame fBufferComparison:height-chars - 1.94
  .
  
  if valid-handle(gchMerge) then
    assign
      btnMerge:col in frame fBufferComparison  = (frame fBufferComparison:width-chars / 2)
                                                   - btnMerge:width-chars in frame fBufferComparison 
      btnCancel:col in frame fBufferComparison = (frame fBufferComparison:width-chars / 2)
      .
  
  else
    assign
      btnMerge:visible in frame fBufferComparison = no
      btnCancel:col in frame fBufferComparison    =   frame fBufferComparison:width-chars / 2
                                                    - btnCancel:width-chars in frame fBufferComparison / 2
      .

  hScrollBox:frame = frame fBufferComparison:handle.

/* Create column labels. */

find first bttBufferComparisonField
  where bttBufferComparisonField.BufferNo  = 1
  no-error.

if available bttBufferComparisonField then
do:
  
  cBufferLabel1 = substitute('&1.&2':U,
                             bttBufferComparisonField.DatabaseName,
                             bttBufferComparisonField.BufferName).
  
  create text hColLabel1
    assign
      format        = substitute('x(&1)':U, length(cBufferLabel1))
      screen-value  = cBufferLabel1
      frame         = frame fBufferComparison:handle
      width         = font-table:get-text-width-chars(cBufferLabel1)
      row           = 3.5
      height        = 1
      col           = dColOffset + 3 + (76 - hColLabel1:width-chars) / 2
      .
  
end. /* if available bttBufferComparisonField */

find first bttBufferComparisonField
  where bttBufferComparisonField.BufferNo  = 2
  no-error.

if available bttBufferComparisonField then
do:

  cBufferLabel2 = substitute('&1.&2':U,
                             bttBufferComparisonField.DatabaseName,
                             bttBufferComparisonField.BufferName).
    .
  
  create text hColLabel2
    assign
      format        = substitute('x(&1)':U, length(cBufferLabel2))
      screen-value  = cBufferLabel2
      frame         = frame fBufferComparison:handle
      width         = font-table:get-text-width-chars(cBufferLabel2)
      row           = 3.5
      height        = 1
      col           = dColOffset + 3 + 76 + (76 - hColLabel2:width-chars) / 2
      .
    
end. /* if available bttBufferComparisonField */

/* Remove horizontal scrollbar if necessary. */

if hScrollBox:virtual-height-chars > hScrollBox:height-chars then
do:
  
  display unless-hidden
    with frame fBufferComparison
      in window phParentWindow.
  
  run qg_SetScrollbars(hScrollBox:handle, no, ?).
  
end. /* if hScrollBox:virtual-height-chars > hScrollBox:height-chars */

/* Show dialog. */

update unless-hidden
  lAllFields
  rectCaseSensitive
  cCaseSensitive
  btnMerge
    when valid-handle(gchMerge)
  btnCancel
  with frame fBufferComparison
    in window phParentWindow.

finally:
  
  if valid-handle(hColLabel1) then
    delete object hColLabel1 no-error.
  
  if valid-handle(hColLabel2) then
    delete object hColLabel2 no-error.
  
  if valid-handle(hScrollBox) then
    run qg_DeleteWidgetTree(hScrollBox:handle, yes).
  
end finally.

end procedure. /* qg_QueryWindowCompareSelectedRecords */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowCopyQueryText hQueryWindow 
PROCEDURE qg_QueryWindowCopyQueryText :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Copy actual query text with resolved external tokens to clipboard.         */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if not valid-handle(bttQueryWindow.QueryHandle) then
  leave.

clipboard:value = bttQueryWindow.QueryHandle:prepare-string.

end procedure. /* qg_QueryWindowCopyQueryText */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowCopyRecid hQueryWindow 
PROCEDURE qg_QueryWindowCopyRecid :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Copy recid/rowid of the current query window record.                       */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* plRecid                        = If yes then the recid will be copied. If  */
/*                                  no then the rowid will be copied.         */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.
define input parameter plRecid  as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i       as integer   no-undo.
define variable hBuffer as handle    no-undo.
define variable cList   as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if not valid-handle(bttQueryWindow.QueryHandle) then
  leave.

do i = 1 to bttQueryWindow.QueryHandle:num-buffers:
  
  assign
    hBuffer = bttQueryWindow.QueryHandle:get-buffer-handle(i)
    cList   = substitute('&1,&2':U,
                         cList,
                         (if plRecid then
                            string(hBuffer:recid)
                          else
                            string(hBuffer:rowid)))
    .

end. /* do i = 1 to bttQueryWindow.QueryHandle:num-buffers */

clipboard:value = trim(cList, ',':U).

end procedure. /* qg_QueryWindowCopyRecid */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowCopyRecordValues hQueryWindow 
PROCEDURE qg_QueryWindowCopyRecordValues :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Copy record values.                                                        */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* plRawValues                    = Copy raw values.                          */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable lRawValues as logical no-undo
  format 'yes/no':U
  view-as radio-set
    radio-buttons
      'Raw values':T, yes,
      'Formatted values':T, no
  size 30 by 2.

define button btnOk
  label 'Ok':T
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T
  size 20 by 1.14
  auto-end-key.


/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

define frame fCopyRecordValues
  lRawValues at row 1.5 col 10 no-label
  btnOk at row 4.5 col 5
  btnCancel at row 4.5 col 25
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    side-labels no-underline three-d 
    size 49 by 6.5
    title gcTitlePrefix + 'Copy record values':T
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fCopyRecordValues
  apply 'end-error' to self.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

lRawValues = glCopyRawValues.

update unless-hidden
  lRawValues
  btnOk
  btnCancel
  with frame fCopyRecordValues
    in window bttQueryWindow.WindowHandle. 

glCopyRawValues = lRawValues.

clipboard:value = qg_clBrowseValues(bttQueryWindow.QueryBrowseHandle,
                                    glCopyRawValues).

end procedure. /* qg_QueryWindowCopyRecordValues */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowSelectForComparison hQueryWindow 
PROCEDURE qg_QueryWindowSelectForComparison :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow   as handle    no-undo.
define input parameter piBufferNo as integer   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hQuery        as handle    no-undo.
define variable hBuffer       as handle    no-undo.
define variable cDatabaseName as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hQuery = bttQueryWindow.QueryHandle.

if hQuery:num-buffers = 1 then
  hBuffer = hQuery:get-buffer-handle(1).

else
  run qg_SelectQueryBuffer(hQuery, output hBuffer).

if valid-handle(hBuffer) then
do:
  
  cDatabaseName = qg_cDatabaseNameForTableOrBuffer( hBuffer ).
  
  run qg_SetBufferComparisonBuffer(cDatabaseName, hBuffer, piBufferNo).
  
end. /* if valid-handle(hBuffer) */

end procedure. /* qg_QueryWindowSelectForComparison */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowUpdateQuery hQueryWindow 
PROCEDURE qg_QueryWindowUpdateQuery :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow    as handle    no-undo.
define input parameter pcTables    as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable lRebuild      as logical   no-undo.
define variable lHidden       as logical   no-undo.
define variable hOldBuffers   as handle    no-undo extent.

define variable hBuffer       as handle    no-undo.
define variable hQuery        as handle    no-undo.

define variable i             as integer   no-undo.

define variable cTableEntry   as character no-undo.
define variable cDatabaseName as character no-undo.
define variable cTableName    as character no-undo.
define variable cBufferName   as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

define buffer bttTable       for temp-table ttTable.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hQuery = bttQueryWindow.QueryHandle.

/* Create new (if necessary). */ 

if not valid-handle(hQuery) then
do:
  
  create query hQuery.
  
  bttQueryWindow.QueryHandle = hQuery.

end. /* if not valid-handle(hQuery) */

/* Check if current query buffers match the tables parameter. If that is the  */
/* case no changes have to be made. Otherwise all buffers have to be rebuilt. */

if num-entries(pcTables) <> hQuery:num-buffers then
  lRebuild = yes.

else
do:
  
  do i = 1 to num-entries(pcTables):
    
    if i > hQuery:num-buffers then
    do:
      
      lRebuild = yes.
      leave.
    
    end. /* if i > hQuery:num-buffers */
    
    assign
      cTableEntry   = entry(i, pcTables)
      cDatabaseName = entry(1, cTableEntry, '.':U)
      cTableEntry   = entry(2, cTableEntry, '.':U)
      cTableName    = entry(1, cTableEntry, ':':U)
      cBufferName   = (if num-entries(cTableEntry, ':':U) > 1 then
                         entry(2, cTableEntry, ':':U)
                       else
                         cTableName)
      hBuffer       = hQuery:get-buffer-handle(i)
      .
    
    if    cTableName    <> hBuffer:table
       or cDatabaseName <> qg_cDatabaseNameForTableOrBuffer( hBuffer ) then
    do:
      
      lRebuild = yes.
      leave.
      
    end. /* if    cTableName    <> hBuffer:table */
    
    if hBuffer:name <> cBufferName then
      hBuffer:name = cBufferName.
    
  end. /* do i = 1 to hQuery:num-buffers */
  
end. /* else: if num-entries(pcTables) <> hQuery:num-buffers */

if lRebuild then
do on error undo, throw:
  
  if valid-handle(bttQueryWindow.QueryBrowseHandle) then
    assign
      lHidden = bttQueryWindow.QueryBrowseHandle:hidden
      bttQueryWindow.QueryBrowseHandle:hidden = yes
      .
  
  /* Delete all currently assigned buffers. Deleting one buffer will also     */
  /* remove all other buffers from the query. Due to this we have to store    */
  /* all buffers in an extent field prior to deletion.                        */
  
  if hQuery:num-buffers > 0 then
  do:
    
    extent(hOldBuffers) = hQuery:num-buffers.
    
    do i = hQuery:num-buffers to 1 by -1:
      hOldBuffers[i] = hQuery:get-buffer-handle(i).
    end. /* do i = 1 to hQuery:num-buffers */ 
    
    do i = 1 to extent(hOldBuffers):
      delete object hOldBuffers[i].
    end. /* do i = 1 to extent(hOldBuffers) */
    
  end. /* if hQuery:num-buffers > 0 */
  
  /* Create and assign new buffers */
  
  do i = 1 to num-entries(pcTables):
    
    assign
      cTableEntry   = entry(i, pcTables)
      cDatabaseName = entry(1, cTableEntry, '.':U)
      cTableEntry   = entry(2, cTableEntry, '.':U)
      cTableName    = entry(1, cTableEntry, ':':U)
      cBufferName   = (if num-entries(cTableEntry, ':':U) > 1 then
                         entry(2, cTableEntry, ':':U)
                       else
                         cTableName)
      .
    
    find bttTable
      where bttTable.DatabaseName = cDatabaseName
        and bttTable.TableName    = cTableName
      no-error.
  
    if   not available bttTable
      or (  not bttTable.PhysicalTable
        and not valid-handle(bttTable.TableHandle)) then
      next.
  
    if not bttTable.DetailsLoaded then
      run qg_AddTableDetails(bttTable.DatabaseName,
                             bttTable.TableName).
    
    if not bttTable.PhysicalTable then
      create buffer hBuffer for table bttTable.TableHandle /* code checked by mth 30.07.2015 */
        buffer-name cBufferName.
    
    else
      create buffer hBuffer for table substitute('&1.&2':U, /* code checked by mth 30.07.2015 */
                                                 bttTable.DatabaseName,
                                                 bttTable.TableName)
        buffer-name cBufferName.
    
    hBuffer:private-data = qg_cParamListWriteCharacter(hBuffer:private-data,
                                                       'DatabaseName':U,
                                                       bttTable.DatabaseName,
                                                       ',':U).
  
    hQuery:add-buffer(hBuffer).
    
  end. /* do i = 1 to num-entries(pcTables) */
  
  run qg_QueryWindowUpdateFieldTempTable( bttQueryWindow.QueryHandle,
                                          bttQueryWindow.WindowHandle,
                                          '':U ).

  if valid-handle(bttQueryWindow.QueryFrameHandle) then
  do:
    
    /* For some reason deleting query buffers also removes the query from the */
    /* query browse handle. Due to this we have to set it again.              */
    
    bttQueryWindow.QueryBrowseHandle:query = hQuery.
  
    run qg_QueryWindowRefreshBrowseColumns(bttQueryWindow.WindowHandle).
    
    run qg_QueryWindowQueryOpenFieldQuery(bttQueryWindow.WindowHandle).
    
  end. /* if valid-handle(bttQueryWindow.QueryFrameHandle) */
  
  if valid-handle(bttQueryWindow.RecordFrameHandle) then
    run qg_QueryWindowRecordOpenQuery(bttQueryWindow.WindowHandle).
  
  /* Update window title. Since for a record window the title is updated with */
  /* every record data refresh this has only to be done for query windows at  */
  /* this point.                                                              */
  
  if bttQueryWindow.WindowMode = {&K_QUERY_WINDOW_MODE_QUERY} then
    run qg_QueryWindowQueryUpdateTitle(bttQueryWindow.WindowHandle).
  
  finally:
    
    if valid-handle(bttQueryWindow.QueryBrowseHandle) then
      bttQueryWindow.QueryBrowseHandle:hidden = lHidden.
    
  end finally.
  
end. /* if lRebuild */

validate bttQueryWindow.

end procedure. /* qg_QueryWindowUpdateQuery */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowCreateBufferComparisonFrame hQueryWindow 
PROCEDURE qg_QueryWindowCreateBufferComparisonFrame :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input-output parameter iophFrame          as handle    no-undo.
define input        parameter plCaseSensitive    as logical   no-undo.
define input        parameter plAllFields        as logical   no-undo.
define       output parameter opiDifferentFields as integer   no-undo.
define       output parameter opdColOffset       as decimal   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i                as integer   no-undo.
define variable dHeightDelta     as decimal   no-undo.

define variable lEditor          as logical   no-undo.

define variable clFieldValue1    as longchar  no-undo.
define variable clFieldValue2    as longchar  no-undo.

define variable hColLabel1       as handle    no-undo.
define variable hColLabel2       as handle    no-undo.
define variable hField1          as handle    no-undo.
define variable hField2          as handle    no-undo.
define variable hButton          as handle    no-undo.
define variable hTemp            as handle    no-undo.
define variable cPrivateData     as character no-undo.

define variable cLabel           as character no-undo.
define variable iLongestLabel    as integer   no-undo.
define variable dLongestLabel    as decimal   no-undo.

define variable iFlags           as integer   no-undo.
define variable iDummy           as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttBufferComparisonField  for temp-table ttBufferComparisonField.
define buffer b2ttBufferComparisonField for temp-table ttBufferComparisonField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

for each bttBufferComparisonField
  where bttBufferComparisonField.DataType <> 'blob':U
  on error undo, throw:
  
  if    bttBufferComparisonField.BufferNo  = 2
    and can-find(ttBufferComparisonField
                   where ttBufferComparisonField.BufferNo   = 1
                     and ttBufferComparisonField.FieldName  = bttBufferComparisonField.FieldName
                     and ttBufferComparisonField.FieldIndex = bttBufferComparisonField.FieldIndex) then
    next.
  
  release b2ttBufferComparisonField.
  
  if bttBufferComparisonField.BufferNo = 1 then
  do:
    
    find b2ttBufferComparisonField
      where b2ttBufferComparisonField.BufferNo   = 2
        and b2ttBufferComparisonField.FieldName  = bttBufferComparisonField.FieldName
        and b2ttBufferComparisonField.FieldIndex = bttBufferComparisonField.FieldIndex
      no-error.
    
    if available b2ttBufferComparisonField then
    do:
      
      copy-lob bttBufferComparisonField.FieldValue to clFieldValue1.
      copy-lob b2ttBufferComparisonField.FieldValue to clFieldValue2.
      
      assign
        bttBufferComparisonField.IsEqual  = compare(clFieldValue1,
                                                    'EQ':U,
                                                    clFieldValue2,
                                                    (if plCaseSensitive then
                                                       'CASE-SENSITIVE':U
                                                     else
                                                       'CASE-INSENSITIVE':U))
        b2ttBufferComparisonField.IsEqual = bttBufferComparisonField.IsEqual
        .
      
    end. /* if available b2ttBufferComparisonField */
    
  end. /* if b2ttBufferComparisonField.BufferNo = 1 */
  

  if    plAllFields
     or bttBufferComparisonField.IsEqual = no then
    assign
      i                  = i + 1
      opiDifferentFields = opiDifferentFields + 1
          when bttBufferComparisonField.IsEqual = no
      lEditor            =    bttBufferComparisonField.DataType  = 'clob':U
                           or (  bttBufferComparisonField.BufferNo = 1
                             and available b2ttBufferComparisonField
                             and b2ttBufferComparisonField.DataType = 'clob':U )
                           or length(clFieldValue1) > 30000
                           or length(clFieldValue2) > 30000
                           or index(clFieldValue1, '~n':U) > 0
                           or index(clFieldValue2, '~n':U) > 0
      dHeightDelta       = dHeightDelta + (if lEditor then
                                             5
                                           else
                                             1)
      cLabel             = qg_cFormattedFieldName
                             (?,
                              ?,
                              bttBufferComparisonField.FieldName,
                              bttBufferComparisonField.FieldIndex)
      iLongestLabel      = maximum(iLongestLabel,
                                   length(cLabel))
      dLongestLabel      = maximum(dLongestLabel,
                                   font-table:get-text-width-chars(cLabel))
      .
  
end. /* for each bttBufferComparisonField */

opdColOffset = dLongestLabel + 3.

if valid-handle(iophFrame) then
  run qg_DeleteWidgetTree(iophFrame:first-child, no).

else
  create frame iophFrame
    assign
      name                 = 'fScrollBox':U
      box                  = no
      three-d              = yes
      width-chars          = 165 + dLongestLabel
      virtual-width-chars  = 165 + dLongestLabel
      height               = 0.25 + minimum(30, dHeightDelta)
      virtual-height       = 0.25 + dHeightDelta
      row                  = 5
      col                  = 3
      sensitive            = yes
      scrollable           = yes
      careful-paint        = no
      .

assign
  dHeightDelta = 0
  i            = 0
  .

for each bttBufferComparisonField
  where bttBufferComparisonField.DataType <> 'blob':U
  on error undo, throw:
  
  if    ( not plAllFields
      and bttBufferComparisonField.IsEqual <> no )
     or ( bttBufferComparisonField.BufferNo  = 2
      and can-find(ttBufferComparisonField
                     where ttBufferComparisonField.BufferNo   = 1
                       and ttBufferComparisonField.FieldName  = bttBufferComparisonField.FieldName
                       and ttBufferComparisonField.FieldIndex = bttBufferComparisonField.FieldIndex) ) then
    next.
  
  i = i + 1.
  
  release b2ttBufferComparisonField.
  
  if bttBufferComparisonField.BufferNo = 1 then
  do:
    
    copy-lob bttBufferComparisonField.FieldValue to clFieldValue1.
    
    if clFieldValue1 = ? then
      clFieldValue1 = '?':U.
    
    find b2ttBufferComparisonField
      where b2ttBufferComparisonField.BufferNo   = 2
        and b2ttBufferComparisonField.FieldName  = bttBufferComparisonField.FieldName
        and b2ttBufferComparisonField.FieldIndex = bttBufferComparisonField.FieldIndex
      no-error.
  
    if available b2ttBufferComparisonField then
      copy-lob b2ttBufferComparisonField.FieldValue to clFieldValue2.
    
    else
      clFieldValue2 = '':U.
    
    if clFieldValue2 = ? then
      clFieldValue2 = '?':U.
    
  end. /* if bttBufferComparisonField.BufferNo = 1 */
  
  else
  do:
    
    copy-lob bttBufferComparisonField.FieldValue to clFieldValue2.
    
    clFieldValue1 = '':U.
    
  end. /* else: if bttBufferComparisonField.BufferNo = 1 */
  
  lEditor =    bttBufferComparisonField.DataType  = 'clob':U
            or (  bttBufferComparisonField.BufferNo = 1
              and available b2ttBufferComparisonField
              and b2ttBufferComparisonField.DataType = 'clob':U )
            or length(clFieldValue1) > 30000
            or length(clFieldValue2) > 30000
            or index(clFieldValue1, '~n':U) > 0
            or index(clFieldValue2, '~n':U) > 0.
  
  create editor hField1
    assign
      name                 = substitute('&1_1':U, bttBufferComparisonField.FieldName)
      frame                = iophFrame
      width                = 76
      height               = (if lEditor then
                                5
                              else
                                1)
      row                  = dHeightDelta + 1
      col                  = dLongestLabel + 5
      word-wrap            = no
      scrollbar-horizontal = (if lEditor then
                                yes
                              else
                                no)
      scrollbar-vertical   = (if lEditor then
                                yes
                              else
                                no)
      return-inserted      = (if lEditor then
                                yes
                              else
                                no)
      bgcolor              = (if    plAllFields
                                and bttBufferComparisonField.IsEqual = ?
                                and ( bttBufferComparisonField.BufferNo = 2 ) then
                                {&K_COLOR_LIGHT_GREY}
                              else if plAllFields
                                and bttBufferComparisonField.IsEqual = no then
                                {&K_COLOR_YELLOW}
                              else
                                ?)
      fgcolor              = ( if    bttBufferComparisonField.IsVirtual
                                 and bttBufferComparisonField.FieldType = {&K_FIELD_TYPE_VIRTUAL_DB_FIELD} then
                                 {&K_VIRTUAL_DB_FIELD_FGCOLOR}
                               else
                                 ? )
      sensitive            = yes
      read-only            = yes
      .
  
  assign
    hField1:screen-value = clFieldValue1
    cLabel               = qg_cFormattedFieldName(?,
                                                  ?,
                                                  bttBufferComparisonField.FieldName,
                                                  bttBufferComparisonField.FieldIndex)
    .
  
  create text hTemp
    assign
      format        = substitute('x(&1)':U, length(cLabel))
      screen-value  = cLabel
      frame         = iophFrame
      width         = font-table:get-text-width-chars(cLabel)
      row           = dHeightDelta + 1
      height        = 1
      col           = 1
      fgcolor       = ( if    ( available bttBufferComparisonField
                            and bttBufferComparisonField.IsVirtual
                            and bttBufferComparisonField.FieldType  = {&K_FIELD_TYPE_VIRTUAL_DB_FIELD} )
                          or ( available b2ttBufferComparisonField
                            and b2ttBufferComparisonField.IsVirtual
                            and b2ttBufferComparisonField.FieldType = {&K_FIELD_TYPE_VIRTUAL_DB_FIELD} ) then
                          {&K_VIRTUAL_DB_FIELD_FGCOLOR}
                        else
                          ? )
      .
  
  assign
    hTemp:col                 = hField1:col - hTemp:width - 1
    hField1:side-label-handle = hTemp
    .
  
  create editor hField2
    assign
      name                 = substitute('&1_2':U, bttBufferComparisonField.FieldName)
      frame                = iophFrame
      width                = 76
      height               = (if lEditor then
                                5
                              else
                                1)
      row                  = dHeightDelta + 1
      col                  = dLongestLabel + 5 + 76
      word-wrap            = no
      scrollbar-horizontal = (if lEditor then
                                yes
                              else
                                no)
      scrollbar-vertical   = (if lEditor then
                                yes
                              else
                                no)
      return-inserted      = (if lEditor then
                                yes
                              else
                                no)
      bgcolor              = (if    plAllFields
                                and bttBufferComparisonField.IsEqual = ?
                                and bttBufferComparisonField.BufferNo = 1
                                and not available b2ttBufferComparisonField then
                                {&K_COLOR_LIGHT_GREY}
                              else if plAllFields
                                and bttBufferComparisonField.IsEqual = no then
                                {&K_COLOR_YELLOW}
                              else
                                ?)
      fgcolor              = ( if    available b2ttBufferComparisonField
                                 and b2ttBufferComparisonField.IsVirtual
                                 and b2ttBufferComparisonField.FieldType = {&K_FIELD_TYPE_VIRTUAL_DB_FIELD} then
                                 {&K_VIRTUAL_DB_FIELD_FGCOLOR}
                               else
                                 ? )
      sensitive            = yes
      read-only            = yes
      .
  
  
  hField2:screen-value = clFieldValue2.
  
  if bttBufferComparisonField.IsEqual = no then
  do:
    
    create button hButton
      assign
        name                 = substitute('btnCompare&1':U, bttBufferComparisonField.FieldName)
        frame                = iophFrame
        width                = 5
        height               = 1
        row                  = dHeightDelta + 1
        col                  = dLongestLabel + 5 + 152
        label                = '>':T
        tooltip              = 'Show first difference':T
        sensitive            =  yes
      triggers:
        
        on choose
          persistent run qg_QueryWindowBufferComparisonSelectFirstDifference in target-procedure
                           (plCaseSensitive,
                            hField1,
                            hField2).
        
      end triggers.
    
    if valid-handle(gchMerge) then
    do:
      
      create menu hTemp
        assign
          name       = substitute('m_PopupMenu':U)
          popup-only = yes
          sensitive  = yes
          .
      
      hButton:popup-menu = hTemp.
      
      create menu-item hTemp
        assign
          name         = 'mi_MergeFields':U
          parent       = hButton:popup-menu
          label        = 'Merge field':T
          sensitive    = yes
        triggers:
          on choose
            persistent run qg_QueryWindowBufferComparisonStartMerge in target-procedure
                             (plAllFields,
                              bttBufferComparisonField.FieldName,
                              bttBufferComparisonField.FieldIndex,
                              plCaseSensitive).
        end triggers
        .
      
    end. /* if valid-handle(gchMerge) */

  end. /* if bttBufferComparisonField.IsEqual = no */
  
  dHeightDelta  = dHeightDelta + (if lEditor then
                                    5
                                  else
                                    1).
  
end. /*for each bttBufferComparisonField  */

end procedure. /* qg_QueryWindowCreateBufferComparisonFrame */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowCreateFieldTempTableOverlayEntries hQueryWindow 
PROCEDURE qg_QueryWindowCreateFieldTempTableOverlayEntries :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow    as handle    no-undo.
define input parameter pcFieldList as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow       for temp-table ttQueryWindow.

define buffer bttFieldOverlay      for temp-table ttFieldOverlay.
define buffer bttQueryWindowField  for temp-table ttQueryWindowField.
define buffer b2ttQueryWindowField for temp-table ttQueryWindowField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

for each bttFieldOverlay
  where bttFieldOverlay.OwnerHandle = bttQueryWindow.QueryHandle
  on error undo, throw:
  
  find bttQueryWindowField
    where bttQueryWindowField.WindowHandle = bttQueryWindow.WindowHandle
      and bttQueryWindowField.BufferName   = bttFieldOverlay.BufferName 
      and bttQueryWindowField.FieldName    = bttFieldOverlay.FieldName 
      and bttQueryWindowField.FieldIndex   = bttFieldOverlay.FieldIndex
    no-error. 
  
  if    not available bttQueryWindowField
     or can-find(ttQueryWindowField
                   where ttQueryWindowField.WindowHandle = bttQueryWindowField.WindowHandle
                     and ttQueryWindowField.BufferId     = bttQueryWindowField.BufferId
                     and ttQueryWindowField.FieldName    = bttQueryWindowField.FieldName
                     and ttQueryWindowField.FieldIndex   = bttQueryWindowField.FieldIndex
                     and ttQueryWindowField.IsOverlay    = yes) then
    next.
  
  create b2ttQueryWindowField.
  
  buffer-copy bttQueryWindowField
    to b2ttQueryWindowField
    assign
     b2ttQueryWindowField.DisplayName = substitute({&K_OBJECTID_OVERLAY_LABEL_PATTERN},
                                                   bttQueryWindowField.FieldLabel)
     b2ttQueryWindowField.IsOverlay   = yes
     b2ttQueryWindowField.Order       = (if pcFieldList > '':U then
                                           lookup(substitute({&K_OBJECTID_OVERLAY_NAME_PATTERN},
                                                             qg_cFormattedFieldName(?,
                                                                                    b2ttQueryWindowField.BufferName,
                                                                                    b2ttQueryWindowField.FieldName,
                                                                                    b2ttQueryWindowField.FieldIndex)),
                                                  pcFieldList)
                                         else
                                           1)
     .
  
  validate b2ttQueryWindowField.
  
end. /* for each bttFieldOverlay */
  
end procedure. /* qg_QueryWindowCreateFieldTempTableOverlayEntries */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowCreateQueryFrame hQueryWindow 
PROCEDURE qg_QueryWindowCreateQueryFrame :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hTemp                      as handle    no-undo.

define variable hFrame                     as handle    no-undo.

define variable hMenuBar                   as handle    no-undo.
define variable hMenu                      as handle    no-undo.

define variable hCopyObjectIdSubMenu       as handle    no-undo.

define variable hQueryTextEditor           as handle    no-undo.
define variable hFieldSelectionBrowse      as handle    no-undo.
define variable hFieldSelectionBuffer      as handle    no-undo.
define variable hFieldSelectionQuery       as handle    no-undo.
define variable cFieldSelectionQueryText   as character no-undo.
define variable hQueryBrowse               as handle    no-undo.

define variable i                          as integer   no-undo.
define variable hField                     as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

define buffer bttTable       for temp-table ttTable.
define buffer bttField       for temp-table ttField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

/*----------------------------------------------------------------------------*/
/* Create Menu                                                                */
/*----------------------------------------------------------------------------*/

create menu hMenuBar.

/* File menu */

create sub-menu hMenu
  assign
    name      = 'm_File':U
    label     = 'File':T
    sensitive = yes
    parent    = hMenuBar
    .

create menu-item hTemp
  assign
    name        = 'mi_Close':U
    label       = 'Close':T
    accelerator = 'CTRL-W':U
    sensitive   = yes
    parent      = hMenu
  triggers:
  
    on choose
      persistent run qg_QueryWindowClose in target-procedure
                       (bttQueryWindow.WindowHandle,
                        ?).  
    
  end triggers.

/* Edit menu */

create sub-menu hMenu
  assign
    name      = 'm_Edit':U
    label     = 'Edit':T
    sensitive = yes
    parent    = hMenuBar
    .

create menu-item hTemp
  assign
    name         = 'mi_CopyQueryText':U
    parent       = hMenu
    label        = 'Copy query text':T
    sensitive    = yes
  triggers:
    on choose
      persistent run qg_QueryWindowCopyQueryText in target-procedure
                       (bttQueryWindow.WindowHandle).
  end triggers
  .

/* Tools menu */

create sub-menu hMenu
  assign
    name      = 'm_Tools':U
    label     = 'Tools':T
    sensitive = yes
    parent    = hMenuBar
  triggers:
    
    on menu-drop
      persistent run qg_QueryWindowQueryToolsMenuDrop in target-procedure
                       (bttQueryWindow.WindowHandle).
    
  end triggers.

create menu-item hTemp
  assign
    name        = 'mi_Execute':U
    label       = 'Execute query':T
    accelerator = 'F2':U
    sensitive   = yes
    parent      = hMenu
  triggers:
  
    on choose
      persistent run qg_QueryWindowExecute in target-procedure
                       (bttQueryWindow.WindowHandle,
                        ?,
                        yes).
    
  end triggers.

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hMenu
    .

create menu-item hTemp
  assign
    name        = 'mi_OpenRelatedQuery':U
    label       = 'Open related query':T
    accelerator = 'CTRL-R':U
    sensitive   = yes
    parent      = hMenu
  triggers:
    
    on choose
      persistent run qg_QueryWindowOpenRelatedQuery in target-procedure
                       (bttQueryWindow.WindowHandle).
    
  end triggers.

create menu-item hTemp
  assign
    name        = 'mi_ObjectFieldValues':U
    label       = 'Open Object field values':T
    accelerator = 'CTRL-O':U
    sensitive   = yes
    parent      = hMenu
  triggers:
    
    on choose
      persistent run qg_QueryWindowOpenObjectFieldValues in target-procedure
                       (bttQueryWindow.WindowHandle).
    
  end triggers.

create menu-item hTemp
  assign
    name        = 'mi_FindMissingObjectIds':U
    label       = 'Find missing Object IDs':T
    accelerator = 'CTRL-ALT-J':U
    sensitive   = yes
    parent      = hMenu
  triggers:
    
    on choose
      persistent run qg_QueryWindowFindMissingObjectIds in target-procedure
                       ( bttQueryWindow.WindowHandle ).
    
  end triggers.

create menu-item hTemp
  assign
    name        = 'mi_FindNextMissingObjectIds':U
    label       = 'Find next missing Object ID':T
    accelerator = 'CTRL-J':U
    sensitive   = yes
    parent      = hMenu
  triggers:
    
    on choose
      persistent run qg_QueryWindowFindNextMissingObjectId in target-procedure
                       ( bttQueryWindow.WindowHandle ).
    
  end triggers.

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hMenu
    .

create menu-item hTemp
  assign
    name        = 'mi_OpenRecordWindowFixRowId':U
    label       = 'Open record window (fix / rowid)':T
    accelerator = 'SHIFT-F8':U
    sensitive   = yes
    parent      = hMenu
  triggers:
    
    on choose
      persistent run qg_QueryWindowOpenRecordWindow in target-procedure
                       (bttQueryWindow.WindowHandle,
                        {&K_QUERY_WINDOW_LINK_MODE_FIX_ROWID}).
    
  end triggers.

create menu-item hTemp
  assign
    name        = 'mi_OpenRecordWindowFixIndex':U
    label       = 'Open record window (fix / index)':T
    accelerator = 'ALT-SHIFT-F8':U
    sensitive   = yes
    parent      = hMenu
  triggers:
    
    on choose
      persistent run qg_QueryWindowOpenRecordWindow in target-procedure
                       (bttQueryWindow.WindowHandle,
                        {&K_QUERY_WINDOW_LINK_MODE_FIX_INDEX}).
    
  end triggers.

create menu-item hTemp
  assign
    name        = 'mi_OpenRecordWindowLinked':U
    label       = 'Open record window (linked)':T
    accelerator = 'CTRL-SHIFT-F8':U
    sensitive   = yes
    parent      = hMenu
  triggers:
    
    on choose
      persistent run qg_QueryWindowOpenRecordWindow in target-procedure
                       (bttQueryWindow.WindowHandle,
                        {&K_QUERY_WINDOW_LINK_MODE_LINKED}).
    
  end triggers.

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hMenu
    .

create menu-item hTemp
  assign
    name         = 'mi_ShowQueryText':U
    parent       = hMenu
    label        = 'Show query text':T
    sensitive    = yes
  triggers:
    
    on choose
      persistent run qg_QueryWindowShowQueryText in target-procedure
                       (bttQueryWindow.WindowHandle).
    
  end triggers
  .

create menu-item hTemp
  assign
    name         = 'mi_ExecCurrentQueryText':U
    parent       = hMenu
    label        = 'Execute query text':T
    sensitive    = yes
  triggers:
    
    on choose
      persistent run qg_QueryWindowExecCurrentQuery in target-procedure
                       (bttQueryWindow.WindowHandle).
    
  end triggers
  .

create menu-item hTemp
  assign
    name         = 'mi_ShowIndexInformation':U
    parent       = hMenu
    label        = 'Show index information':T
    sensitive    = yes
  triggers:
    
    on choose
      persistent run qg_QueryWindowShowIndexInformation in target-procedure
                       (bttQueryWindow.WindowHandle).
    
  end triggers
  .

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hMenu
    .

create menu-item hTemp
  assign
    name        = 'mi_AddSnapshot':U
    label       = 'Add snapshot':T
    accelerator = 'F10':U
    sensitive   = yes
    parent      = hMenu
  triggers:
    
    on choose
      persistent run qg_QueryWindowAddSnapshot in target-procedure
                       (bttQueryWindow.WindowHandle).
    
  end triggers.

/* Options menu */

create sub-menu hMenu
  assign
    name      = 'm_Options':U
    label     = 'Options':T
    sensitive = yes
    parent    = hMenuBar
    .

create menu-item hTemp
  assign
    name        = 'mi_SelectQueryBuffers':U
    label       = 'Query buffers':T
    accelerator = 'CTRL-B':U
    sensitive   = yes
    parent      = hMenu
  triggers:
    
    on choose
      persistent run qg_QueryWindowEditQueryBuffers in target-procedure
                       (bttQueryWindow.WindowHandle).
    
  end triggers.

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hMenu
    .

create menu-item hTemp
  assign
    name       = 'mi_ObjectIdOveray':U
    label      = 'Object id overlay':T
    sensitive  = yes
    parent     = hMenu
  triggers:
    
    on choose
      persistent run qg_QueryWindowObjectIdOverlay in target-procedure
                       (bttQueryWindow.WindowHandle).
    
  end triggers.

create menu-item hTemp
  assign
    name       = 'mi_DeepResolveObjectIds':U
    label      = 'Deep resolve object ids':T
    toggle-box = yes
    sensitive  = yes
    parent     = hMenu
  triggers:
    
    on value-changed
      persistent run qg_QueryWindowToggleDeepResolve in target-procedure
                       (bttQueryWindow.WindowHandle).
    
  end triggers.

/* View menu */

create sub-menu hMenu
  assign
    name      = 'm_View':U
    label     = 'View':T
    sensitive = yes
    parent    = hMenuBar
  triggers:
  
    on menu-drop
      persistent run qg_QueryWindowViewMenuDrop in target-procedure
                       (bttQueryWindow.WindowHandle).
    
  
  end triggers.

create menu-item hTemp
  assign
    name       = 'mi_FieldList':U
    label      = 'Field list':T
    toggle-box = yes
    sensitive  = yes
    parent     = hMenu
  triggers:
    
    on value-changed
      persistent run qg_QueryWindowToggleFieldList in target-procedure
                       (bttQueryWindow.WindowHandle).
    
  end triggers.

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hMenu
    .

create menu-item hTemp
  assign
    name       = 'mi_RawValues':U
    label      = 'Raw Values':T
    toggle-box = yes
    sensitive  = yes
    parent     = hMenu
  triggers:
    
    on value-changed
      persistent run qg_QueryWindowToggleRawValues in target-procedure
                       ( bttQueryWindow.WindowHandle ).
    
  end triggers.

create sub-menu hMenu
  assign
    name      = 'm_Window':U
    label     = 'Window':T
    sensitive = yes
    parent    = hMenuBar
  triggers:
  
    on menu-drop
      persistent run qg_QueryWindowWindowMenuDrop in target-procedure
                       (bttQueryWindow.WindowHandle).
    
  
  end triggers.

create menu-item hTemp
  assign
    name        = 'mi_RecordMode':U
    label       = 'Switch to record mode':T
    toggle-box  = no
    accelerator = 'F8':U
    sensitive   = yes
    parent      = hMenu
  triggers:
    
    on choose
      persistent run qg_QueryWindowSetWindowMode in target-procedure
                       (bttQueryWindow.WindowHandle,
                        {&K_QUERY_WINDOW_MODE_RECORD},
                        ?,
                        ?).
    
  end triggers.

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hMenu
    .

create menu-item hTemp
  assign
    name      = 'mi_WindowSizeDefault':U
    label     = 'Restore default window size':T
    sensitive = yes
    parent    = hMenu
  triggers:
    
    on choose
      persistent run qg_QueryWindowSetSize in target-procedure
                       (bttQueryWindow.WindowHandle,
                        {&K_QUERY_SIZE_MODE_DEFAULT}).
    
  end triggers.

run qg_AddHelpMenu(hMenuBar).

/*----------------------------------------------------------------------------*/
/* Create Frame                                                               */
/*----------------------------------------------------------------------------*/

create frame hFrame
  assign
    name           = 'fQuery':U
    box            = no
    three-d        = yes
    width          = 235
    virtual-width  = 235
    height         = 32
    virtual-height = 32
    sensitive      = yes
    parent         = bttQueryWindow.WindowHandle
  triggers:
    
    on f3 anywhere /* Show all */
      persistent run qg_QueryWindowShowAll in target-procedure
                       (bttQueryWindow.WindowHandle).
    
    on f4 anywhere /* Show index */
      persistent run qg_QueryWindowShowIndex in target-procedure
                       (bttQueryWindow.WindowHandle).
    
    on f5 anywhere /* Recent queries */
      persistent run qg_QueryWindowRecentQueries in target-procedure
                       (bttQueryWindow.WindowHandle).
    
    on shift-f2 anywhere /* Set focus to query text editor */
      persistent run qg_QueryWindowSetFocus in target-procedure
                       (bttQueryWindow.WindowHandle,
                        'cQueryText':U).
    
    on shift-f8 anywhere /* Toggle field list */
      persistent run qg_QueryWindowToggleFieldList in target-procedure
                       (bttQueryWindow.WindowHandle).
    
    on shift-f4 anywhere /* Set focus to query browse */
      persistent run qg_QueryWindowSetFocus in target-procedure
                       (bttQueryWindow.WindowHandle,
                        'brQuery':U).
    
    on ctrl-n anywhere
      persistent run qg_QueryWindowEdit in target-procedure
                       (bttQueryWindow.WindowHandle,
                        {&K_EDITACTION_CREATE}).
    
    on ctrl-p anywhere
      persistent run qg_QueryWindowEdit in target-procedure 
                       (bttQueryWindow.WindowHandle,
                        {&K_EDITACTION_DUPLICATE}).
    
    on ctrl-d anywhere
      persistent run qg_QueryWindowDelete in target-procedure
                       (bttQueryWindow.WindowHandle).
    
  end triggers
  .

bttQueryWindow.QueryFrameHandle = hFrame.

/* Create Query text Editor */

create editor hQueryTextEditor
  assign
    name                 = 'cQueryText':U
    frame                = hFrame
    width                = 162
    height               = 6
    row                  = 1
    col                  = 1
    word-wrap            = no
    font                 = 0
    large                = yes
    return-inserted      = yes
    auto-indent          = yes
    scrollbar-horizontal = yes
    scrollbar-vertical   = yes
    read-only            = (bttQueryWindow.ObjSourceQuerySeq > 0)
    sensitive            = yes
  triggers:
    
    on ctrl-d
      persistent run qg_QueryWindowQueryTextEditorDeleteLines in target-procedure
                       (bttQueryWindow.WindowHandle).
    
    on alt-up
      persistent run qg_QueryWindowQueryTextEditorMoveLines in target-procedure
                       (bttQueryWindow.WindowHandle,
                        no).
    
    on alt-down
      persistent run qg_QueryWindowQueryTextEditorMoveLines in target-procedure
                       (bttQueryWindow.WindowHandle,
                        yes).
    
    on ctrl-alt-cursor-up
      persistent run qg_QueryWindowQueryTextEditorDuplicateLines in target-procedure
                       (bttQueryWindow.WindowHandle,
                        no).
    
    on ctrl-alt-cursor-down
      persistent run qg_QueryWindowQueryTextEditorDuplicateLines in target-procedure
                       (bttQueryWindow.WindowHandle,
                        yes).
    
    on ctrl-ins
      persistent run qg_QueryWindowInsertExternalReference in target-procedure
                       (bttQueryWindow.WindowHandle,
                        hQueryTextEditor,
                        yes).
    
    on ctrl-shift-ins
      persistent run qg_QueryWindowInsertExternalReference in target-procedure
                       (bttQueryWindow.WindowHandle,
                        hQueryTextEditor,
                        no).
    
    on tab
      persistent run qg_QueryWindowSelectNextCondition in target-procedure
                       (bttQueryWindow.WindowHandle,
                        yes).
    
    on shift-tab
      persistent run qg_QueryWindowSelectNextCondition in target-procedure
                       (bttQueryWindow.WindowHandle,
                        no).
    
    on ctrl-enter
      persistent run qg_QueryWindowSelectNextCondition in target-procedure
                       (bttQueryWindow.WindowHandle,
                        ?).
    
    on mouse-extend-click
      persistent run qg_QueryWindowSelectNextCondition in target-procedure
                       (bttQueryWindow.WindowHandle,
                        ?).
    
    on ctrl-tab
      persistent run qg_QueryWindowSetFocus in target-procedure
                       (bttQueryWindow.WindowHandle,
                        'brFieldSelection':U).
    
    /* TODO: Anderer Shortcut
    on ctrl-i
      persistent run qg_QueryWindowBeautify in target-procedure
                       (bttQueryWindow.WindowHandle).
    */
    
  end triggers
  .

/* Create field selection browse. */

create buffer hFieldSelectionBuffer for table 'ttQueryWindowField':U. /* code checked by mth 30.07.2015 */

create query hFieldSelectionQuery.
hFieldSelectionQuery:set-buffers(hFieldSelectionBuffer).

create browse hFieldSelectionBrowse
  assign
    name                   = 'brFieldSelection':U
    frame                  = hFrame
    width                  = 50
    height                 = 6
    row                    = 1
    col                    = 183
    read-only              = yes
    row-markers            = no
    allow-column-searching = no
    multiple               = yes
    fit-last-column        = yes
  triggers:
    
    on default-action
      persistent run qg_QueryWindowFieldSelectionBrowseDefaultAction in target-procedure
                       (bttQueryWindow.WindowHandle).
    
    on ctrl-ins
      persistent run qg_QueryWindowQueryTextEditorAddCondition in target-procedure
                       (bttQueryWindow.WindowHandle).
    
    on ctrl-home
      persistent run qg_QueryWindowMoveColumn in target-procedure
                       (bttQueryWindow.WindowHandle,
                        yes).
    
    on ctrl-end
      persistent run qg_QueryWindowMoveColumn in target-procedure
                       (bttQueryWindow.WindowHandle,
                        no).
    
    on ctrl-page-up
      persistent run qg_QueryWindowAddSortOption in target-procedure
                       (bttQueryWindow.WindowHandle,
                        no).
    
    on ctrl-page-down
      persistent run qg_QueryWindowAddSortOption in target-procedure
                       (bttQueryWindow.WindowHandle,
                        yes).
    
    on row-display
      persistent run qg_QueryWindowQueryFieldBrowseRowDisplay in target-procedure
                       (bttQueryWindow.WindowHandle).
    
  end triggers
  .

/* Create field selection browse toggle button. */

create button hTemp
  assign
    name                 = 'btnToggleFieldBrowse':U
    frame                = hFrame
    width                = 3
    height               = 6
    row                  = 1
    col                  = 163
    label                = '>':T
    tooltip              = 'Hide field List':T
    flat-button          = yes
    sensitive            = yes
  triggers:
    
    on choose
      persistent run qg_QueryWindowToggleFieldList in target-procedure
                       (bttQueryWindow.WindowHandle).
    
  end triggers
  .

if gcCursorHand > '':U then
  hTemp:load-mouse-pointer(gcCursorHand).

/* Create Buttons. */

create button hTemp
  assign
    name                 = 'btnExecute':U
    frame                = hFrame
    width                = 20
    height               = 2
    row                  = 1
    col                  = 215
    label                = 'Execute':T
    tooltip              = 'Execute current query and refresh browse (F2)':T
    sensitive            = yes
  triggers:
    
    on choose
      persistent run qg_QueryWindowExecute in target-procedure
                       (bttQueryWindow.WindowHandle,
                        ?,
                        yes).
    
  end triggers.

create button hTemp
  assign
    name      = 'btnEdit':U
    frame     = hFrame
    width     = 20
    height    = 1
    row       = 3
    col       = 215
    &IF {&K_EDITMODE_ENABLED} &THEN
      label   = 'Edit Record':T
      tooltip = 'Edit currently selected record.':T
    &ELSE
      label   = 'Record':T
      tooltip = 'Show record details for currently selected record':T
    &ENDIF
    sensitive = yes
  triggers:
    
    on choose
      persistent run qg_QueryWindowEdit in target-procedure
                       (bttQueryWindow.WindowHandle,
                        {&K_EDITACTION_EDIT}).
    
  end triggers
  .

&IF {&K_EDITMODE_ENABLED} &THEN
  
  create button hTemp
    assign
      name      = 'btnDelete':U
      frame     = hFrame
      width     = 20
      height    = 1
      row       = 4
      col       = 215
      label     = 'Delete Record':T
      tooltip   = 'Delete currently selected record (CTRL+D)':T
      sensitive = yes
    triggers:
      
      on choose
        persistent run qg_QueryWindowDelete in target-procedure
                         (bttQueryWindow.WindowHandle).
      
    end triggers
    .
  
  create button hTemp
    assign
      name      = 'btnCreate':U
      frame     = hFrame
      width     = 20
      height    = 1
      row       = 5
      col       = 215
      label     = 'Create Record':T
      tooltip   = 'Create new record (CTRL-N)':T
      sensitive = yes
    triggers:
      
      on choose
        persistent run qg_QueryWindowEdit in target-procedure
                         (bttQueryWindow.WindowHandle,
                          {&K_EDITACTION_CREATE}).
      
    end triggers
    .
  
  create button hTemp
    assign
      name      = 'btnDuplicate':U
      frame     = hFrame
      width     = 20
      height    = 1
      row       = 6
      col       = 215
      label     = 'Duplicate Record':T
      tooltip   = 'Create new record by duplicating currently selected record (CTRL-P)':T
      sensitive = yes
    triggers:
      
      on choose
        persistent run qg_QueryWindowEdit in target-procedure 
                         (bttQueryWindow.WindowHandle,
                          {&K_EDITACTION_DUPLICATE}).
      
    end triggers
    .
  
&ENDIF

/* Create Splitter button. */

create button hTemp
  assign
    name        = 'btnSplitter1':U
    frame       = hFrame
    width       = 10
    height      = 0.25
    row         = 7
    col         = 1
    label       = '':U
    no-focus    = yes
    flat-button = yes
    movable     = yes
    sensitive   = yes
  triggers:
    
    on end-move
      persistent run qg_QueryWindowResize in target-procedure
                       (bttQueryWindow.WindowHandle).
    
  end triggers
  .

hTemp:load-mouse-pointer ('SIZE-N':U).

/* Create query browse. */

create browse hQueryBrowse
  assign
    name                 = 'brQuery':U
    frame                = hFrame
    width                = 10
    height               = 10
    row                  = 7.25
    col                  = 1
    read-only            = yes
    row-markers          = no
    allow-column-searching = yes
  triggers:
    
    on value-changed
      persistent run qg_QueryWindowUpdateAll in target-procedure
                       ('':U).
    
    on row-display
      persistent run qg_QueryWindowQueryBrowseRowDisplay in target-procedure
                       (bttQueryWindow.WindowHandle).
    
    on default-action
      persistent run qg_QueryWindowQueryBrowseDefaultAction in target-procedure
                       (bttQueryWindow.WindowHandle).
    
    on mouse-select-click
      persistent run qg_QueryWindowQueryBrowseSelectColumn in target-procedure
                       (bttQueryWindow.WindowHandle).
    
    on mouse-menu-down
      persistent run qg_QueryWindowQueryBrowseSelectColumn in target-procedure
                       (bttQueryWindow.WindowHandle).
    
    on start-search
      persistent run qg_QueryWindowQueryBrowseStartSearch in target-procedure
                       (bttQueryWindow.WindowHandle).
    
    on mouse-select-dblclick
      persistent run qg_QueryWindowQueryBrowseStartSearch in target-procedure
                       (bttQueryWindow.WindowHandle).
    
    on mouse-extend-dblclick
      persistent run qg_QueryWindowQueryBrowseStartSearch in target-procedure
                       (bttQueryWindow.WindowHandle).
    
    on ctrl-c
      persistent run qg_QueryWindowQueryBrowseCopy in target-procedure
                           (bttQueryWindow.WindowHandle).
    
    on ' ':U
      persistent run qg_QueryWindowEdit in target-procedure
                       (bttQueryWindow.WindowHandle,
                        {&K_EDITACTION_EDIT}).
    
  end triggers.

/* Create query text editor popup menu. */

if bttQueryWindow.ObjSourceQuerySeq = 0 then
do:
  
  create menu hTemp
    assign
      name       = 'm_QueryTextPopupMenu':U
      popup-only = yes
      sensitive  = yes
    triggers:
      
      on menu-drop
        persistent run qg_QueryWindowQueryTextEditorPopupMenuDrop in target-procedure
                         (bttQueryWindow.WindowHandle).
      
    end triggers.
  
  hQueryTextEditor:popup-menu = hTemp.
  
  create menu-item hTemp
    assign
      name         = 'mi_ShowAll':U
      parent       = hQueryTextEditor:popup-menu
      label        = 'Show all':T
      sensitive    = yes
    triggers:
      
      on choose
        persistent run qg_QueryWindowShowAll in target-procedure
                         (bttQueryWindow.WindowHandle).
      
    end triggers
    .
  
  create menu-item hTemp
    assign
      name      = 'm_ShowIndex':U
      parent    = hQueryTextEditor:popup-menu
      label     = 'Show index':T
      sensitive = yes
    triggers:
      
      on choose
        persistent run qg_QueryWindowShowIndex in target-procedure
                         (bttQueryWindow.WindowHandle).
      
    end triggers.
  
  create menu-item hTemp
    assign
      name      = 'm_SortByIndex':U
      parent    = hQueryTextEditor:popup-menu
      label     = 'Sort by Index':T
      sensitive = yes
    triggers:
      
      on choose
        persistent run qg_QueryWindowSortByIndex in target-procedure
                         (bttQueryWindow.WindowHandle).
      
    end triggers.
  
  create menu-item hTemp
    assign
      subtype = 'RULE':U
      parent  = hQueryTextEditor:popup-menu
      .
  
  create menu-item hTemp
    assign
      name         = 'mi_InsertExternalFieldReference':U
      parent       = hQueryTextEditor:popup-menu
      label        = 'Insert external field reference':T
      sensitive    = yes
    triggers:
      
      on choose
        persistent run qg_QueryWindowInsertExternalReference in target-procedure
                         (bttQueryWindow.WindowHandle,
                          hQueryTextEditor,
                          yes).
      
    end triggers
    .
  
  create menu-item hTemp
    assign
      name         = 'mi_InsertExternalTableReference':U
      parent       = hQueryTextEditor:popup-menu
      label        = 'Insert external table reference':T
      sensitive    = yes
    triggers:
      
      on choose
        persistent run qg_QueryWindowInsertExternalReference in target-procedure
                         (bttQueryWindow.WindowHandle,
                          hQueryTextEditor,
                          no).
      
    end triggers
    .
  
  create menu-item hTemp
    assign
      subtype = 'RULE':U
      parent  = hQueryTextEditor:popup-menu
      .
  
  create menu-item hTemp
    assign
      name         = 'mi_Equal':U
      parent       = hQueryTextEditor:popup-menu
      label        = '= (eqal)':T
      sensitive    = yes
    triggers:
      
      on choose
        persistent run qg_QueryWindowSetComparator in target-procedure
                         (bttQueryWindow.WindowHandle,
                          '=':U).
      
    end triggers
    .
  
  create menu-item hTemp
    assign
      name         = 'mi_NotEqual':U
      parent       = hQueryTextEditor:popup-menu
      label        = '<> (not equal)':T
      sensitive    = yes
    triggers:
      
      on choose
        persistent run qg_QueryWindowSetComparator in target-procedure
                         (bttQueryWindow.WindowHandle,
                          '<>':U).
      
    end triggers
    .
  
  create menu-item hTemp
    assign
      name         = 'mi_Greater':U
      parent       = hQueryTextEditor:popup-menu
      label        = '> (greater than)':T
      sensitive    = yes
    triggers:
      
      on choose
        persistent run qg_QueryWindowSetComparator in target-procedure
                         (bttQueryWindow.WindowHandle,
                          '>':U).
      
    end triggers
    .
  
  create menu-item hTemp
    assign
      name         = 'mi_GreaterEqual':U
      parent       = hQueryTextEditor:popup-menu
      label        = '>= (greater or equal)':T
      sensitive    = yes
    triggers:
      
      on choose
        persistent run qg_QueryWindowSetComparator in target-procedure
                         (bttQueryWindow.WindowHandle,
                          '>=':U).
      
    end triggers
    .
  
  create menu-item hTemp
    assign
      name         = 'mi_Lower':U
      parent       = hQueryTextEditor:popup-menu
      label        = '< (lower than)':T
      sensitive    = yes
    triggers:
      
      on choose
        persistent run qg_QueryWindowSetComparator in target-procedure
                         (bttQueryWindow.WindowHandle,
                          '<':U).
      
    end triggers
    .
  
  create menu-item hTemp
    assign
      name         = 'mi_LowerEqual':U
      parent       = hQueryTextEditor:popup-menu
      label        = '<= (lower or queal)':T
      sensitive    = yes
    triggers:
      
      on choose
        persistent run qg_QueryWindowSetComparator in target-procedure
                         (bttQueryWindow.WindowHandle,
                          '<=':U).
      
    end triggers
    .
  
  create menu-item hTemp
    assign
      name         = 'mi_Begins':U
      parent       = hQueryTextEditor:popup-menu
      label        = 'begins':T
      sensitive    = yes
    triggers:
      
      on choose
        persistent run qg_QueryWindowSetComparator in target-procedure
                         (bttQueryWindow.WindowHandle,
                          'begins':U).
      
    end triggers
    .
  
  create menu-item hTemp
    assign
      name         = 'mi_Matches':U
      parent       = hQueryTextEditor:popup-menu
      label        = 'matches':T
      sensitive    = yes
    triggers:
      
      on choose
        persistent run qg_QueryWindowSetComparator in target-procedure
                         (bttQueryWindow.WindowHandle,
                          'matches':U).
      
    end triggers
    .
  
  create menu-item hTemp
    assign
      name         = 'mi_Contains':U
      parent       = hQueryTextEditor:popup-menu
      label        = 'contains':T
      sensitive    = yes
    triggers:
      
      on choose
        persistent run qg_QueryWindowSetComparator in target-procedure
                         (bttQueryWindow.WindowHandle,
                          'contains':U).
      
    end triggers
    .
  
  create menu-item hTemp
    assign
      subtype = 'RULE':U
      parent  = hQueryTextEditor:popup-menu
      .
  
  create menu-item hTemp
    assign
      name        = 'mi_BeautifyQueryText':U
      parent      = hQueryTextEditor:popup-menu
      label       = 'Beautify query text':T
      sensitive   = yes
    triggers:
      
      on choose persistent run qg_QueryWindowBeautify in target-procedure
                                 (bttQueryWindow.WindowHandle).
      
    end triggers
    .
  
  create menu-item hTemp
    assign
      subtype = 'RULE':U
      parent  = hQueryTextEditor:popup-menu
      .
  
  create menu-item hTemp
    assign
      name        = 'mi_RecentQueries':U
      parent      = hQueryTextEditor:popup-menu
      label       = 'Recent queries':T
      sensitive   = yes
    triggers:
      
      on choose persistent run qg_QueryWindowRecentQueries in target-procedure
                                 (bttQueryWindow.WindowHandle).
      
    end triggers
    .
  
end. /* if bttQueryWindow.ObjSourceQuerySeq = 0 */

/* Create field selection browse popup menu. */

create menu hTemp
  assign
    name       = 'm_PopupMenu':U
    popup-only = yes
    sensitive  = yes
    .

hFieldSelectionBrowse:popup-menu = hTemp.

create menu-item hTemp
  assign
    name         = 'mi_MoveToFirstColumn':U
    parent       = hFieldSelectionBrowse:popup-menu
    label        = 'Move to first column':T
    sensitive    = yes
  triggers:
    
    on choose
      persistent run qg_QueryWindowMoveColumn in target-procedure
                       (bttQueryWindow.WindowHandle,
                        yes).
    
  end triggers
  .

create menu-item hTemp
  assign
    name         = 'mi_MoveToLastColumn':U
    parent       = hFieldSelectionBrowse:popup-menu
    label        = 'Move to last column':T
    sensitive    = yes
  triggers:
    
    on choose
      persistent run qg_QueryWindowMoveColumn in target-procedure
                       (bttQueryWindow.WindowHandle,
                        no).
    
  end triggers
  .

if bttQueryWindow.ObjSourceQuerySeq = 0 then
do:
  
  create menu-item hTemp
    assign
      subtype = 'RULE':U
      parent  = hFieldSelectionBrowse:popup-menu
      .
  
  create menu-item hTemp
    assign
      name         = 'mi_AddCondition':U
      parent       = hFieldSelectionBrowse:popup-menu
      label        = 'Add condition':T
      sensitive    = yes
    triggers:
      
      on choose
        persistent run qg_QueryWindowQueryTextEditorAddCondition in target-procedure
                         (bttQueryWindow.WindowHandle).
      
    end triggers
    .
  
  create menu-item hTemp
    assign
      name         = 'mi_AddSortPhrase':U
      parent       = hFieldSelectionBrowse:popup-menu
      label        = 'Add sort option':T
      sensitive    = yes
    triggers:
      
      on choose
        persistent run qg_QueryWindowAddSortOption in target-procedure
                         (bttQueryWindow.WindowHandle,
                          no).
      
    end triggers
    .
  
  create menu-item hTemp
    assign
      name         = 'mi_AddSortPhrase':U
      parent       = hFieldSelectionBrowse:popup-menu
      label        = 'Add sort option (descending)':T
      sensitive    = yes
    triggers:
      
      on choose
        persistent run qg_QueryWindowAddSortOption in target-procedure
                         (bttQueryWindow.WindowHandle,
                          yes).
      
    end triggers
    .
  
end. /* if bttQueryWindow.ObjSourceQuerySeq = 0 */

run qg_InitBrowse(hFieldSelectionBrowse).

/* Create query browse popup menu. */

create menu hTemp
  assign
    name       = 'm_PopupMenu':U
    popup-only = yes
    sensitive  = yes
  triggers:
    
    on menu-drop
      persistent run qg_QueryWindowQueryBrowsePopupMenuDrop in target-procedure
                      (bttQueryWindow.WindowHandle).
    
  end triggers.

hQueryBrowse:popup-menu = hTemp.

create menu-item hTemp
  assign
    name         = 'mi_CopySelectedColumnValueRaw':U
    parent       = hQueryBrowse:popup-menu
    label        = 'Copy raw value':T
    sensitive    = yes
  triggers:
    
    on choose
      persistent run qg_QueryWindowQueryBrowseCopySelectedColumnValue in target-procedure
                       ( bttQueryWindow.WindowHandle,
                         yes ).
    
  end triggers
  .

create menu-item hTemp
  assign
    name         = 'mi_CopySelectedColumnValueFormatted':U
    parent       = hQueryBrowse:popup-menu
    label        = 'Copy formatted value':T
    sensitive    = yes
  triggers:
    
    on choose
      persistent run qg_QueryWindowQueryBrowseCopySelectedColumnValue in target-procedure
                       ( bttQueryWindow.WindowHandle,
                         no ).
    
  end triggers
  .

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hQueryBrowse:popup-menu
    .

create menu-item hTemp
  assign
    name         = 'mi_CopyRecordValuesRaw':U
    parent       = hQueryBrowse:popup-menu
    label        = 'Copy record values':T
    sensitive    = yes
  triggers:
    
    on choose
      persistent run qg_QueryWindowCopyRecordValues in target-procedure
                       (bttQueryWindow.WindowHandle).
    
  end triggers
  .

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hQueryBrowse:popup-menu
    .

create menu-item hTemp
  assign
    name         = 'mi_CopyRecid':U
    parent       = hQueryBrowse:popup-menu
    label        = 'Copy recid':T
    sensitive    = yes
  triggers:
    
    on choose
      persistent run qg_QueryWindowCopyRecid in target-procedure
                       (bttQueryWindow.WindowHandle,
                        yes).
    
  end triggers
  .

create menu-item hTemp
  assign
    name         = 'mi_CopyRowid':U
    parent       = hQueryBrowse:popup-menu
    label        = 'Copy rowid':T
    sensitive    = yes
  triggers:
    
    on choose
      persistent run qg_QueryWindowCopyRecid in target-procedure
                       (bttQueryWindow.WindowHandle,
                        no).
    
  end triggers
  .

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hQueryBrowse:popup-menu
    .

create menu-item hTemp
  assign
    name         = 'mi_CalculateSum':U
    parent       = hQueryBrowse:popup-menu
    label        = 'Calculate Sum':T
    sensitive    = yes
  triggers:
    
    on choose
      persistent run qg_QueryWindowCalculateSum in target-procedure
                       (bttQueryWindow.WindowHandle).
    
  end triggers
  .

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hQueryBrowse:popup-menu
    .

create menu-item hTemp
  assign
    name         = 'mi_SelectForComparison1':U
    parent       = hQueryBrowse:popup-menu
    label        = 'Select for comparison 1':T
    sensitive    = yes
  triggers:
    
    on choose
      persistent run qg_QueryWindowSelectForComparison in target-procedure
                       (bttQueryWindow.WindowHandle,
                        1).
    
  end triggers
  .

create menu-item hTemp
  assign
    name         = 'mi_SelectForComparison2':U
    parent       = hQueryBrowse:popup-menu
    label        = 'Select for comparison 2':T
    sensitive    = yes
  triggers:
    
    on choose
      persistent run qg_QueryWindowSelectForComparison in target-procedure
                       (bttQueryWindow.WindowHandle,
                        2).
    
  end triggers
  .

create menu-item hTemp
  assign
    name         = 'mi_CompareSelectedRecords':U
    parent       = hQueryBrowse:popup-menu
    label        = 'Compare selected records':T
    sensitive    = yes
  triggers:
    
    on choose
      persistent run qg_QueryWindowCompareSelectedRecords in target-procedure
                       (bttQueryWindow.WindowHandle).
    
  end triggers
  .

run qg_InitBrowse(hQueryBrowse).

hQueryBrowse:column-movable = no.

hQueryBrowse:query = bttQueryWindow.QueryHandle.

assign
  bttQueryWindow.QueryFrameHandle                      = hFrame
  bttQueryWindow.QueryMenuHandle                       = hMenuBar
  bttQueryWindow.QueryTextEditorHandle                 = hQueryTextEditor
  bttQueryWindow.QueryFieldBrowseHandle                = hFieldSelectionBrowse
  bttQueryWindow.QueryFieldBrowseBufferHandle          = hFieldSelectionBuffer
  bttQueryWindow.QueryBrowseHandle                     = hQueryBrowse
  hFieldSelectionBrowse:query                          = hFieldSelectionQuery
  bttQueryWindow.QueryFieldBrowseColHandles[1]         = hFieldSelectionBrowse:add-like-column('ttQueryWindowField.FieldName':U)
  bttQueryWindow.QueryFieldBrowseColHandles[1]:visible = no
  bttQueryWindow.QueryFieldBrowseColHandles[2]         = hFieldSelectionBrowse:add-like-column('ttQueryWindowField.DisplayName':U)
  bttQueryWindow.QueryFieldBrowseColHandles[2]:width   = 32
  bttQueryWindow.QueryFieldBrowseColHandles[3]         = hFieldSelectionBrowse:add-like-column('ttQueryWindowField.IsVirtual':U)
  bttQueryWindow.QueryFieldBrowseColHandles[4]         = hFieldSelectionBrowse:add-like-column('ttQueryWindowField.DataType':U)
  hFieldSelectionBrowse:labels                         = no
  .

validate bttQueryWindow.

end procedure. /* qg_QueryWindowCreateQueryFrame */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowCreateRecordFrame hQueryWindow 
PROCEDURE qg_QueryWindowCreateRecordFrame :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hMenuBar         as handle    no-undo.
define variable hMenu            as handle    no-undo.

define variable hFrame           as handle    no-undo.
define variable hBrowse          as handle    no-undo.
define variable hBuffer          as handle    no-undo.
define variable hQuery           as handle    no-undo.

define variable hTemp            as handle    no-undo.

define variable iIndex           as integer   no-undo.

define variable cIconDown        as character no-undo.
define variable cIconFirst       as character no-undo.
define variable cIconPrev        as character no-undo.
define variable cIconRefresh     as character no-undo.
define variable cIconNext        as character no-undo.
define variable cIconLast        as character no-undo.
define variable cIconPreferences as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow      for temp-table ttQueryWindow.

define buffer bttQueryWindowField for temp-table ttQueryWindowField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

/*----------------------------------------------------------------------------*/
/* Create Menu                                                                */
/*----------------------------------------------------------------------------*/

cIconDown = search('bmp/icon_down.bmp':U).

if cIconDown = ? then
  cIconDown = search('bmp/btndown.bmp':U).

cIconRefresh = search('bmp/icon_refresh.bmp':U).

if cIconRefresh = ? then
  cIconRefresh = search('bmp/btnrefru.bmp':U).

cIconFirst = search('bmp/icon_first.bmp':U).

if cIconFirst = ? then
  cIconFirst = search('bmp/btnfirsu.bmp':U).

cIconPrev = search('bmp/icon_prev.bmp':U).

if cIconPrev = ? then
  cIconPrev = search('bmp/btnprevu.bmp':U).

cIconNext = search('bmp/icon_next.bmp':U).

if cIconNext = ? then
  cIconNext = search('bmp/btnnextu.bmp':U).

cIconLast = search('bmp/icon_last.bmp':U).

if cIconLast = ? then
  cIconLast = search('bmp/btnlastu.bmp':U).

cIconPreferences = search('bmp/icon_preferences.bmp':U).

create menu hMenuBar.

create sub-menu hMenu
  assign
    name      = 'm_File':U
    label     = 'File':T
    sensitive = yes
    parent    = hMenuBar
    .

create menu-item hTemp
  assign
    name        = 'mi_Close':U
    label       = 'Close':T
    accelerator = 'CTRL-W':U
    sensitive   = yes
    parent      = hMenu
  triggers:
    
    on choose
      persistent run qg_QueryWindowClose in target-procedure
                       (bttQueryWindow.WindowHandle,
                        ?).  
    
  end triggers.

create sub-menu hMenu
  assign
    name      = 'm_Edit':U
    label     = 'Edit':T
    sensitive = yes
    parent    = hMenuBar
    .

create menu-item hTemp
  assign
    name        = 'mi_CopyValue':U
    label       = 'Copy value':T
    sensitive   = yes
    parent      = hMenu
  triggers:
    
    on choose
      persistent run qg_QueryWindowRecordCopyValue in target-procedure
                       (bttQueryWindow.WindowHandle).
    
  end triggers
  .

create sub-menu hMenu
  assign
    name      = 'm_Tools':U
    label     = 'Tools':T
    sensitive = yes
    parent    = hMenuBar
    .

create menu-item hTemp
  assign
    name        = 'mi_Refresh':U
    label       = 'Refresh':T
    accelerator = 'F5':U
    sensitive   = yes
    parent      = hMenu
  triggers:
    
    on choose
      persistent run qg_QueryWindowRecordRefresh in target-procedure
                       (bttQueryWindow.WindowHandle).
    
  end triggers.

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hMenu
    .

create menu-item hTemp
  assign
    name        = 'mi_OpenRelatedQuery':U
    label       = 'Open related query':T
    accelerator = 'CTRL-R':U
    sensitive   = yes
    parent      = hMenu
  triggers:
    
    on choose
      persistent run qg_QueryWindowOpenRelatedQuery in target-procedure
                       (bttQueryWindow.WindowHandle).
    
  end triggers.

create menu-item hTemp
  assign
    name        = 'mi_ObjectFieldValues':U
    label       = 'Open Object field values':T
    accelerator = 'CTRL-O':U
    sensitive   = yes
    parent      = hMenu
  triggers:
    
    on choose
      persistent run qg_QueryWindowOpenObjectFieldValues in target-procedure
                       (bttQueryWindow.WindowHandle).
    
  end triggers.

/* Options menu */

create sub-menu hMenu
  assign
    name      = 'm_Options':U
    label     = 'Options':T
    sensitive = yes
    parent    = hMenuBar
    .

create menu-item hTemp
  assign
    name       = 'mi_ObjectIdOveray':U
    label      = 'Object id overlay':T
    sensitive  = yes
    parent     = hMenu
  triggers:
    
    on choose
      persistent run qg_QueryWindowObjectIdOverlay in target-procedure
                       (bttQueryWindow.WindowHandle).
    
  end triggers.

create menu-item hTemp
  assign
    name       = 'mi_DeepResolveObjectIds':U
    label      = 'Deep resolve object ids':T
    toggle-box = yes
    sensitive  = yes
    parent     = hMenu
  triggers:
    
    on value-changed
      persistent run qg_QueryWindowToggleDeepResolve in target-procedure
                       (bttQueryWindow.WindowHandle).
    
  end triggers.

create sub-menu hMenu
  assign
    name      = 'm_View':U
    label     = 'View':T
    sensitive = yes
    parent    = hMenuBar
  triggers:
    
    on menu-drop
      persistent run qg_QueryWindowRecordViewMenuDrop in target-procedure
                      (bttQueryWindow.WindowHandle).
    
  end triggers
  .

create menu-item hTemp
  assign
    name       = 'mi_RawValues':U
    label      = 'Raw values':T
    toggle-box = yes
    sensitive  = yes
    parent     = hMenu
  triggers:
    
    on value-changed
      persistent run qg_QueryWindowToggleRawValues in target-procedure
                      ( bttQueryWindow.WindowHandle ).
    
  end triggers.

create sub-menu hMenu
  assign
    name      = 'm_Window':U
    label     = 'Window':T
    sensitive = yes
    parent    = hMenuBar
    .

create menu-item hTemp
  assign
    name        = 'mi_QueryMode':U
    label       = 'Switch to query mode':T
    accelerator = 'F8':U
    sensitive   = yes
    parent      = hMenu
  triggers:
    
    on choose
      persistent run qg_QueryWindowSetWindowMode in target-procedure
                       (bttQueryWindow.WindowHandle,
                        {&K_QUERY_WINDOW_MODE_QUERY},
                        ?,
                        ?).
    
  end triggers.

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hMenu
    .
  
create menu-item hTemp
  assign
    name      = 'mi_WindowSizeDefault':U
    label     = 'Restore default window size':T
    sensitive = yes
    parent    = hMenu
  triggers:
    on choose
      persistent run qg_QueryWindowSetSize in target-procedure
                       (bttQueryWindow.WindowHandle,
                        {&K_RECORD_SIZE_MODE_DEFAULT}).
  end triggers.


run qg_AddHelpMenu(hMenuBar).

/*----------------------------------------------------------------------------*/
/* Create Frame                                                               */
/*----------------------------------------------------------------------------*/

create frame hFrame
  assign
    name           = 'fQuery':U
    box            = no
    three-d        = yes
    width          = 235
    virtual-width  = 235
    height         = 32
    virtual-height = 32
    sensitive      = yes
    parent         = bttQueryWindow.WindowHandle
  triggers:
    
    on ctrl-f7 anywhere /* Show query window */
      persistent run qg_OpenQueryWindowListWindow in target-procedure.
    
  end triggers.

create browse hBrowse
  assign
    name                   = 'brRecord':U
    frame                  = hFrame
    width                  = 91
    height                 = 18.44
    row                    = 3
    col                    = 1
    read-only              = yes
    row-markers            = no
    allow-column-searching = no
    multiple               = no
  triggers:
    
    on row-display
      persistent run qg_QueryWindowRecordBrowseRowDisplay in target-procedure
                       (bttQueryWindow.WindowHandle).
    
    on default-action
      persistent run qg_QueryWindowRecordFieldDetails in target-procedure
                       (bttQueryWindow.WindowHandle).
    
    on ' ':U /* Value details */
      persistent run qg_QueryWindowRecordFieldDetails in target-procedure
                       (bttQueryWindow.WindowHandle).
    
    on ctrl-c /* Copy value */
      persistent run qg_QueryWindowRecordCopyValue in target-procedure
                       (bttQueryWindow.WindowHandle).
    
  end triggers.

/* Create browse popup menu. */

create menu hTemp
  assign
    name       = 'm_RecordBrowsePopupMenu':U
    popup-only = yes
    sensitive  = yes
    .

hBrowse:popup-menu = hTemp.

create menu-item hTemp
  assign
    name         = 'mi_CopyValue':U
    parent       = hBrowse:popup-menu
    label        = 'Copy value':T
    sensitive    = yes
  triggers:
    
    on choose
      persistent run qg_QueryWindowRecordCopyValue in target-procedure
                       (bttQueryWindow.WindowHandle).
    
  end triggers
  .

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hBrowse:popup-menu
    .

create menu-item hTemp
  assign
    name         = 'mi_FieldDetails':U
    parent       = hBrowse:popup-menu
    label        = 'Field details':T
    sensitive    = yes
  triggers:
    
    on choose
      persistent run qg_QueryWindowRecordFieldDetails in target-procedure
                       (bttQueryWindow.WindowHandle).
    
  end triggers
    .

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hBrowse:popup-menu
    .

create menu-item hTemp
  assign
    name         = 'mi_SelectFields':U
    parent       = hBrowse:popup-menu
    label        = 'Select fields':T
    sensitive    = yes
  triggers:
    on choose
      persistent run qg_QueryWindowRecordSelectFields in target-procedure
                       (bttQueryWindow.WindowHandle).
  end triggers.

create button hTemp
  assign
    name                 = 'btnRefresh':U
    frame                = hFrame
    width                = 6
    height               = 1.5
    row                  = 1.25
    col                  = 45
    label                = '*':T
    tooltip              = 'Refresh current record values':T
    flat-button          = yes
    sensitive            = yes
  triggers:
    
    on choose
      persistent run qg_QueryWindowRecordRefresh in target-procedure
                      (bttQueryWindow.WindowHandle).
  
  end triggers.

if cIconRefresh > '':U then
  hTemp:load-image(cIconRefresh) no-error.
  
if bttQueryWindow.ObjSourceQuerySeq > 0 then
do:
  
  create text hTemp
    assign
      name      = 'cObjField':U
      frame     = hFrame
      data-type = 'character':U
      format    = 'x(255)':U
      width     = 65
      height    = 1
      row       = 1.5
      col       = 3
      sensitive = yes
      read-only = yes
      tab-stop  = no
      .
  
  create button hTemp
    assign
      name                 = 'btnSelectObjField':U
      frame                = hFrame
      width                = 6
      height               = 1.5
      row                  = 1.25
      col                  = 68
      label                = '...':T
      tooltip              = 'Select object id field':T
      flat-button          = yes
      sensitive            = yes
    triggers:
      
      on choose
        persistent run qg_QueryWindowObjSelectObjField in target-procedure
                        (bttQueryWindow.WindowHandle).
    
    end triggers.

  if cIconPreferences > '':U then
    hTemp:load-image(cIconPreferences) no-error.

end. /* if bttQueryWindow.ObjSourceQuerySeq > 0 */

else
do:
  
  create radio-set hTemp
    assign
      name          = 'lRawValues':U
      frame         = hFrame
      width         = 40
      height        = 1
      row           = 1.5
      col           = 3
      sensitive     = yes
      radio-buttons = 'Formatted values,no,Raw values,yes':T
      horizontal    = yes
    triggers:
      
      on value-changed
        persistent run qg_QueryWindowToggleRawValues in target-procedure
                         ( bttQueryWindow.WindowHandle ).
      
    end triggers
    .
  
  create button hTemp
    assign
      name                 = 'btnFirstRecord':U
      frame                = hFrame
      width                = 6
      height               = 1.5
      row                  = 1.25
      col                  = 46
      label                = '<<':T
      tooltip              = 'Select first record':T
      flat-button          = yes
      sensitive            = yes
    triggers:
      
      on choose
        persistent run qg_QueryWindowRecordNavigate in target-procedure
                        (bttQueryWindow.WindowHandle,
                         {&K_NAVIGATE_FIRST}).
    
    end triggers.
  
  if cIconFirst > '':U then
    hTemp:load-image(cIconFirst) no-error.
  
  create button hTemp
    assign
      name                 = 'btnPrevRecord':U
      frame                = hFrame
      width                = 6
      height               = 1.5
      row                  = 1.25
      col                  = 52
      label                = '<':T
      tooltip              = 'Select previous record':T
      flat-button          = yes
      sensitive            = yes
    triggers:
      
      on choose
        persistent run qg_QueryWindowRecordNavigate in target-procedure
                        (bttQueryWindow.WindowHandle,
                         {&K_NAVIGATE_PREV}).
    
    end triggers.
  
  if cIconPrev > '':U then
    hTemp:load-image(cIconPrev) no-error.
  
  create button hTemp
    assign
      name                 = 'btnNextRecord':U
      frame                = hFrame
      width                = 6
      height               = 1.5
      row                  = 1.25
      col                  = 64
      label                = '>':T
      tooltip              = 'Select next record':T
      flat-button          = yes
      sensitive            = yes
    triggers:
      
      on choose
        persistent run qg_QueryWindowRecordNavigate in target-procedure
                        (bttQueryWindow.WindowHandle,
                         {&K_NAVIGATE_NEXT}).
    
    end triggers.
  
  if cIconNext > '':U then
    hTemp:load-image(cIconNext) no-error.
  
  create button hTemp
    assign
      name                 = 'btnLastRecord':U
      frame                = hFrame
      width                = 6
      height               = 1.5
      row                  = 1.25
      col                  = 70
      label                = '>>':T
      tooltip              = 'Select last record':T
      flat-button          = yes
      sensitive            = yes
    triggers:
      
      on choose
        persistent run qg_QueryWindowRecordNavigate in target-procedure
                        (bttQueryWindow.WindowHandle,
                         {&K_NAVIGATE_LAST}).
    
    end triggers.
  
  if cIconLast > '':U then
    hTemp:load-image(cIconLast) no-error.
  
end. /* else: if bttQueryWindow.ObjSourceQuerySeq > 0 */

create buffer hBuffer for table 'ttQueryWindowField':U. /* code checked by mth 30.07.2015 */

create query hQuery.
hQuery:set-buffers(hBuffer).

hBrowse:query = hQuery.

assign
  bttQueryWindow.RecordFrameHandle         = hFrame
  bttQueryWindow.RecordMenuHandle          = hMenuBar
  bttQueryWindow.RecordQueryHandle         = hQuery
  bttQueryWindow.RecordBrowseHandle        = hBrowse
  bttQueryWindow.RecordBrowseColHandles[1] = hBrowse:add-like-column('ttQueryWindowField.FieldName':U)
  bttQueryWindow.RecordBrowseColHandles[2] = hBrowse:add-like-column('ttQueryWindowField.FieldIndex':U)
  bttQueryWindow.RecordBrowseColHandles[3] = hBrowse:add-like-column('ttQueryWindowField.DisplayName':U)
  bttQueryWindow.RecordBrowseColHandles[4] = hBrowse:add-like-column('ttQueryWindowField.FieldLabel':U)
  bttQueryWindow.RecordBrowseColHandles[5] = hBrowse:add-like-column('ttQueryWindowField.CurrentDisplayValue':U)
  .

/* Hide field name, label and index column. */

assign
  bttQueryWindow.RecordBrowseColHandles[1]:visible = no
  bttQueryWindow.RecordBrowseColHandles[2]:visible = no
  bttQueryWindow.RecordBrowseColHandles[3]:width   = 32
  bttQueryWindow.RecordBrowseColHandles[4]:visible = no
  .

run qg_InitBrowse(hBrowse).

validate bttQueryWindow.

if bttQueryWindow.ObjSourceQuerySeq > 0 then
  run qg_QueryWindowObjUpdateObjFieldText(bttQueryWindow.WindowHandle).

end procedure. /* qg_QueryWindowCreateRecordFrame */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowDelete hQueryWindow 
PROCEDURE qg_QueryWindowDelete :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Delete current record.                                                     */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow    as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable lOk              as logical   no-undo.
define variable lDisableTriggers as logical   no-undo.

define variable hBuffer     as handle    no-undo.
define variable hLockBuffer as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

define buffer bttTable       for temp-table ttTable.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if   not valid-handle(bttQueryWindow.QueryHandle)
  or bttQueryWindow.QueryHandle:num-buffers = 0 then
  leave.

hBuffer = bttQueryWindow.QueryHandle:get-buffer-handle(1).

if not hBuffer:available then
do:
  
  message /* code checked by mth */
    'No record is selected!':T
    view-as alert-box
    error
    buttons ok
    in window bttQueryWindow.WindowHandle.
  
  leave.

end. /* if not hBuffer:available */

Main:
do transaction
  on error undo, throw:
  
  create buffer hLockBuffer for table hBuffer.
  
  find bttTable
    where bttTable.DatabaseName = hLockBuffer:dbname
      and bttTable.TableName    = hLockBuffer:table
    no-error.
  
  hLockBuffer:find-by-rowid(hBuffer:rowid, exclusive-lock).
  
  lDisableTriggers =     available bttTable
                     and bttTable.DeleteTrigger         > '':U
                     and search(bttTable.DeleteTrigger) = ?.
  
  run qg_ConfirmTriggerChanges(substitute('Confirm deletion of &1 record (&2)':T,
                                          hLockBuffer:table,
                                          string(hLockBuffer:rowid)),
                               'WARNING: You are about to delete the current record. Please confirm deletion of this record!':T,
                               'Delete':T,
                               (    available bttTable
                                and search(bttTable.DeleteTrigger) <> ?),
                               bttQueryWindow.WindowHandle,
                                     output lOk,
                               input-output lDisableTriggers).
  
  if lOk then
  do:
    
    
    if lDisableTriggers then
    do:
      
      run qg_DeleteVirtualFieldRecordsForRecord( hLockBuffer:dbname,
                                                 hLockBuffer,
                                                 lDisableTriggers ).
      
      hLockBuffer:disable-load-triggers(no).
      
    end. /* if lDisableTriggers */
    
    hLockBuffer:buffer-delete().
    
    qg_lQueryOpen(bttQueryWindow.QueryHandle, ?, bttQueryWindow.WindowHandle).
    
  end. /* if lOk */
  
  finally:
    
    if valid-handle(hLockBuffer) then
      delete object hLockBuffer.
    
  end finally.
  
end. /* Main */

end procedure. /* qg_QueryWindowDelete */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowDock hQueryWindow 
PROCEDURE qg_QueryWindowDock :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Dock query window to closest other query window.                           */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* piDirection                    = Direction to search for other query       */
/*                                  windows.                                  */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow    as handle    no-undo.
define input parameter piDirection as integer   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hWindow       as handle    no-undo.

define variable iX1 as integer   no-undo.
define variable iY1 as integer   no-undo.
define variable iX2 as integer   no-undo.
define variable iY2 as integer   no-undo.

define variable iX1Temp as integer   no-undo.
define variable iY1Temp as integer   no-undo.
define variable iX2Temp as integer   no-undo.
define variable iY2Temp as integer   no-undo.

define variable dDistance      as decimal   no-undo.
define variable dDockDistanceX as decimal   no-undo init ?.
define variable dDockDistanceY as decimal   no-undo init ?.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow  for temp-table ttQueryWindow.
define buffer b2ttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

/* The size that progress returns for window:width-pixels and window:height-  */
/* pixels does not include the borders. So in order to get the true window    */
/* size and position we need the windows api.                                 */

run qg_GetWindowRect(phWindow,
                     output iX1,
                     output iY1,
                     output iX2,
                     output iY2).

for each b2ttQueryWindow
  on error undo, throw:
  
  hWindow = b2ttQueryWindow.WindowHandle.
  
  if    not valid-handle(hWindow)
     or hWindow = bttQueryWindow.WindowHandle then
    next.
  
  run qg_GetWindowRect(hWindow,
                       output iX1Temp,
                       output iY1Temp,
                       output iX2Temp,
                       output iY2Temp).
  
  if    ( ( piDirection = {&K_DIRECTION_UP}
         or piDirection = {&K_DIRECTION_DOWN} )
      and iX1 <= iX2Temp
      and iX2 >= iX1Temp )
     or ( ( piDirection = {&K_DIRECTION_LEFT}
         or piDirection = {&K_DIRECTION_RIGHT} )
      and iY1 <= iY2Temp
      and iY2 >= iY1Temp ) then
  do:
    
    case piDirection:
      
      when {&K_DIRECTION_UP} then
      do:
        
        dDistance = iY1 - iY2Temp.
        
        if    dDistance > 0
          and ( dDockDistanceY = ?
             or dDistance      < dDockDistanceY ) then
          assign
            dDockDistanceX = iX1 - iX1Temp
            dDockDistanceY = dDistance
            .
        
      end. /* when {&K_DIRECTION_UP} */
      
      when {&K_DIRECTION_DOWN} then
      do:
        
        dDistance = iY2 - iY1Temp.
        
        if    dDistance < 0
          and ( dDockDistanceY = ?
             or dDistance      > dDockDistanceY ) then
          assign
            dDockDistanceX = iX1 - iX1Temp
            dDockDistanceY = dDistance
            .
        
      end. /* when {&K_DIRECTION_DOWN} */
      
      when {&K_DIRECTION_LEFT} then
      do:
        
        dDistance = iX1 - iX2Temp.
        
        if    dDistance > 0
          and ( dDockDistanceX = ?
             or dDistance      < dDockDistanceX ) then
          assign
            dDockDistanceX = dDistance
            dDockDistanceY = iY1 - iY1Temp
            .
        
      end. /* when {&K_DIRECTION_LEFT} */
      
      when {&K_DIRECTION_RIGHT} then
      do:
        
        dDistance = iX2 - iX1Temp.
        
        if    dDistance < 0
          and ( dDockDistanceX = ?
             or dDistance      > dDockDistanceX ) then
          assign
            dDockDistanceX = dDistance
            dDockDistanceY = iY1 - iY1Temp
            .
        
      end. /* when {&K_DIRECTION_RIGHT} */
      
    end case. /* piDirection */
    
  end. /* if    ( ( piDirection = {&K_DIRECTION_UP} */
  
end. /* for each b2ttQueryWindow */

if    dDockDistanceX <> ?
  and dDockDistanceY <> ? then
  assign
    bttQueryWindow.WindowHandle:x = bttQueryWindow.WindowHandle:x - dDockDistanceX
    bttQueryWindow.WindowHandle:y = bttQueryWindow.WindowHandle:y - dDockDistanceY
    .

end procedure. /* qg_QueryWindowDock */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowEdit hQueryWindow 
PROCEDURE qg_QueryWindowEdit :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Edit current record.                                                       */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* piEditAction                   = Action that should be performed:          */
/*                                  - {&K_EDITACTION_EDIT}                    */
/*                                  - {&K_EDITACTION_CREATE}                  */
/*                                  - {&K_EDITACTION_DUPLICATE}               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow       as handle    no-undo.
define input parameter piEditAction   as integer   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer as handle    no-undo.
define variable rRowid  as rowid     no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if   not valid-handle(bttQueryWindow.QueryHandle)
  or bttQueryWindow.QueryHandle:num-buffers = 0 then
  leave.

hBuffer = bttQueryWindow.QueryHandle:get-buffer-handle(1).
  
if   ( piEditAction = {&K_EDITACTION_EDIT}
    or piEditAction = {&K_EDITACTION_DUPLICATE})
  and not hBuffer:available then
do:
  
  message /* code checked by mth */
    'No record is selected!':T
    view-as alert-box
    error
    buttons ok
    in window bttQueryWindow.WindowHandle.
  
  leave.
  
end. /* if not phBuffer:available */

run qg_EditRecord(hBuffer,
                  piEditAction,
                  {&K_EDITMODE_ENABLED},
                  bttQueryWindow.WindowHandle,
                  (if valid-handle(bttQueryWindow.QueryBrowseHandle) then
                     qg_cBrowseColumnList(bttQueryWindow.QueryBrowseHandle,
                                          yes,
                                          no,
                                          no)
                   else
                     ?),
                  output rRowid).

&IF {&K_EDITMODE_ENABLED} &THEN

  case piEditAction:
    
    when {&K_EDITACTION_EDIT} then
    do:
      
      if valid-handle(bttQueryWindow.QueryBrowseHandle) then 
        bttQueryWindow.QueryBrowseHandle:refresh().
      
      run qg_QueryWindowUpdateAll('':U).
      
    end. /* when {&K_EDITACTION_EDIT} */
    
    otherwise
    do:
      
      qg_lQueryOpen(bttQueryWindow.QueryHandle, ?, bttQueryWindow.WindowHandle).

      if rRowid <> ? then
        bttQueryWindow.QueryHandle:reposition-to-rowid(rRowid) no-error.
      
/*      bttQueryWindow.QueryBrowseHandle:scroll-to-current-row().*/
      
    end. /* otherwise */
    
  end case. /* piEditAction */
  
&ENDIF

end procedure. /* qg_QueryWindowEdit */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_queryWindowEntry hQueryWindow 
PROCEDURE qg_queryWindowEntry :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow     for temp-table ttQueryWindow.
define buffer bttQueryWindowView for temp-table ttQueryWindowView.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

ghActiveQueryWindow = bttQueryWindow.WindowHandle.

run qg_QueryWindowListSelectQueryWindow(ghActiveQueryWindow).

end procedure. /* qg_queryWindowEntry */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowExecCurrentQuery hQueryWindow 
PROCEDURE qg_QueryWindowExecCurrentQuery :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Executes the current query text in a new query window.                     */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow       as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i             as integer   no-undo.
define variable hBuffer       as handle    no-undo.
define variable cDatabaseName as character no-undo.
define variable cTables       as character no-undo.
define variable iQuerySeq     as integer   no-undo init ?.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow     for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if   not valid-handle(bttQueryWindow.QueryHandle)
  or bttQueryWindow.QueryHandle:num-buffers = 0 then
  leave.

do i = 1 to bttQueryWindow.QueryHandle:num-buffers:
  
  assign
    hBuffer       = bttQueryWindow.QueryHandle:get-buffer-handle(i)
    cDatabaseName = qg_cDatabaseNameForTableOrBuffer( hBuffer )
    cTables       = substitute('&1.&2:&3':U,
                               cDatabaseName,
                               hBuffer:table,
                               hBuffer:name)
    .
  
end. /* do i = 1 to bttQueryWindow.QueryHandle:num-buffers */

if bttQueryWindow.QueryHandle:prepare-string > '':U then
  run qg_ExecQuery({&K_QUERY_WINDOW_MODE_QUERY},
                   {&K_QUERY_SIZE_MODE_DEFAULT},
                   cTables,
                   bttQueryWindow.QueryHandle:prepare-string,
                   no,  /* Init mode */
                   '':U,
                   input-output iQuerySeq).

end procedure. /* qg_QueryWindowExecCurrentQuery */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowExecute hQueryWindow 
PROCEDURE qg_QueryWindowExecute :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Execute query of given query window.                                       */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* pcQueryText                    = Query text that should be executed. If    */
/*                                  empty or "?" then the query text will be  */
/*                                  be determined by the window mode.         */
/* plFocusBrowse                  = Focus browse if the browse contains hits. */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow      as handle    no-undo.
define input parameter pcQueryText   as character no-undo.
define input parameter plFocusBrowse as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cQueryText as character no-undo.
define variable i          as integer   no-undo.
define variable cButtons   as character no-undo init 'btnExecute,btnEdit,btnDelete,btnCreate,btnDuplicate':U.
define variable hTemp      as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

/* Additional do block to ensure that bttQueryWindow will be available in     */
/* finally block.                                                             */

do on error undo, throw:
  
  phWindow:title = substitute('&1 (executing ...)':U, bttQueryWindow.WindowTitle).
  
  if   not valid-handle(bttQueryWindow.QueryHandle)
    or bttQueryWindow.QueryHandle:num-buffers = 0 then
    leave.
  
  case bttQueryWindow.WindowMode:
    
    when {&K_QUERY_WINDOW_MODE_QUERY} then
    do:
      
      do i = 1 to num-entries(cButtons):
        
        hTemp = qg_hGetWidgetByName(bttQueryWindow.WindowHandle,
                                    entry(i, cButtons)).
        
        if valid-handle(hTemp) then
          hTemp:sensitive = no. /* code checked by mth 30.07.2015 */
        
      end. /* do i = 1 to num-entries(i) */
      
      cQueryText = (if pcQueryText > '':U then
                      pcQueryText
                    else
                      bttQueryWindow.QueryTextEditorHandle:input-value).
      
    end. /* when {&K_QUERY_WINDOW_MODE_QUERY} */
    
    when {&K_QUERY_WINDOW_MODE_RECORD} then
      cQueryText = (if pcQueryText > '':U then
                      pcQueryText
                    else
                      bttQueryWindow.QueryText).
    
  end case. /* case bttQueryWindow.WindowMode */
  
  process events.
  
  if cQueryText <> bttQueryWindow.QueryText then
    run qg_QueryWindowSetQueryText(bttQueryWindow.WindowHandle, cQueryText).
  
  run qg_QueryWindowUpdateAll(string(bttQueryWindow.WindowHandle)).
  
  case bttQueryWindow.WindowMode:
    
    when {&K_QUERY_WINDOW_MODE_QUERY} then
      if    plFocusBrowse
        and bttQueryWindow.QueryHandle:num-results > 0 then
        apply 'entry':U to bttQueryWindow.QueryBrowseHandle.
    
    when {&K_QUERY_WINDOW_MODE_RECORD} then
      if    plFocusBrowse
        and bttQueryWindow.RecordQueryHandle:num-results > 0 then
        apply 'entry':U to bttQueryWindow.RecordBrowseHandle.
    
  end case. /* case bttQueryWindow.WindowMode */
  
  finally:
    
    if valid-handle(phWindow) then
      phWindow:title = bttQueryWindow.WindowTitle.
    
    if bttQueryWindow.WindowMode = {&K_QUERY_WINDOW_MODE_QUERY} then
    do:
      
      do i = 1 to num-entries(cButtons):
        
        hTemp = qg_hGetWidgetByName(bttQueryWindow.WindowHandle,
                                    entry(i, cButtons)).
      
        if valid-handle(hTemp) then
          hTemp:sensitive = yes. /* code checked by mth 30.07.2015 */
        
      end. /* do i = 1 to num-entries(i) */
      
    end. /* if bttQueryWindow.WindowMode = {&K_QUERY_WINDOW_MODE_QUERY} */
    
  end finally.
  
end.

end procedure. /* qg_QueryWindowExecute */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowFieldSelectionBrowseDefaultAction hQueryWindow 
PROCEDURE qg_QueryWindowFieldSelectionBrowseDefaultAction :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Default action trigger of field selection browse.                          */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable iKeyState             as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

bttQueryWindow.QueryFieldBrowseHandle:deselect-rows().
bttQueryWindow.QueryFieldBrowseHandle:select-focused-row().

run GetKeyState({&K_WIN_CONST_VK_ALT}, output iKeyState).

if iKeyState < 0 then
do:
  
  run GetKeyState({&K_WIN_CONST_VK_SHIFT}, output iKeyState).
  
  run qg_QueryWindowAddSortOption(bttQueryWindow.WindowHandle,
                                  (iKeyState < 0)).

end. /* else: if iKeyState >= 0 */

else
do:
  
  run GetKeyState({&K_WIN_CONST_VK_CTRL}, output iKeyState).
  
  if iKeyState < 0 then
    run qg_QueryWindowMoveColumn(bttQueryWindow.WindowHandle, yes).
  
  else
    run qg_QueryWindowQueryTextEditorAddCondition(bttQueryWindow.WindowHandle).

end. /* else: if iKeyState < 0 */

end procedure. /* qg_QueryWindowFieldSelectionBrowseDefaultAction */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowFindMissingObjectIds hQueryWindow 
PROCEDURE qg_QueryWindowFindMissingObjectIds :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Default action trigger of field selection browse.                          */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable lSelected               as logical   no-undo.
define variable cField_Key              as character no-undo.
define variable cField_Label            as character no-undo.
define variable cAvailableColumn_Keys   as character no-undo.
define variable cAvailableColumn_Labels as character no-undo.
define variable cSelectedColumn_Keys    as character no-undo.
define variable lOk                     as logical   no-undo.

define variable i                       as integer   no-undo.
define variable hQuery                  as handle    no-undo.
define variable hBuffer                 as handle    no-undo.
define variable cDatabaseNames          as character no-undo extent.
define variable cBufferNames            as character no-undo extent.
define variable cFieldNames             as character no-undo extent.
define variable iFieldIndices           as integer   no-undo extent.
define variable hBufferFields           as handle    no-undo extent.
define variable cObjectId               as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow      for temp-table ttQueryWindow.

define buffer bttQueryWindowField for temp-table ttQueryWindowField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

for each bttQueryWindowField
  where bttQueryWindowField.WindowHandle = bttQueryWindow.WindowHandle
    and bttQueryWindowField.IsOverlay    = no
  on error undo, throw:
  
  if lookup(bttQueryWindowField.DataType, 'CHARACTER,LONGCHAR':U) = 0 then
    next.
  
  assign
    lSelected               =   (     bttQueryWindowField.FieldName matches '*_Obj':U
                                   or bttQueryWindowField.isObjectId )
                              and not bttQueryWindowField.FieldName matches substitute('&1_Obj':U, bttQueryWindowField.TableName)
    cField_Key              = qg_cFormattedFieldName(?,
                                                     bttQueryWindowField.BufferName,
                                                     bttQueryWindowField.FieldName,
                                                     bttQueryWindowField.FieldIndex)
    cAvailableColumn_Keys   = substitute('&1,&2':U, cAvailableColumn_Keys, cField_Key)
    cField_Label            = qg_cFormattedFieldName(?,
                                                     (if    valid-handle(bttQueryWindow.QueryBrowseHandle)
                                                        and bttQueryWindow.QueryHandle:num-buffers > 1 then
                                                        bttQueryWindowField.BufferName
                                                      else
                                                        ?),
                                                     bttQueryWindowField.FieldName,
                                                     bttQueryWindowField.FieldIndex)
    cAvailableColumn_Labels = substitute('&1,&2':U,
                                         cAvailableColumn_Labels,
                                          cField_Label)
    .
  
  if lSelected then
    cSelectedColumn_Keys = substitute('&1,&2':U, cSelectedColumn_Keys, cField_Key).
  
end. /* for each bttQueryWindowField */

assign
  cAvailableColumn_Keys   = trim(cAvailableColumn_Keys, ',':U)
  cAvailableColumn_Labels = trim(cAvailableColumn_Labels, ',':U)
  cSelectedColumn_Keys    = ( if bttQueryWindow.MissingObjectIdFields > '':U then
                                bttQueryWindow.MissingObjectIdFields
                              else
                                trim( cSelectedColumn_Keys, ',':U ) )
  .

do while yes
  on error undo, throw:
  
  run qg_SelectionDialog( cAvailableColumn_Keys,
                          cAvailableColumn_Labels,
                          input-output cSelectedColumn_Keys,
                          'Select Fields to check':T,
                          bttQueryWindow.WindowHandle,
                          no,
                          output lOk ).
  
  if not lOk then
    return.
  
  if num-entries( cSelectedColumn_Keys ) > 0 then
  do:
    
    if cSelectedColumn_Keys <> bttQueryWindow.MissingObjectIdFields then
      assign
        bttQueryWindow.MissingObjectIdFields      = cSelectedColumn_Keys
        bttQueryWindow.LastMissingObjectIdRecords = '':U
        .
    
    if    valid-handle( bttQueryWindow.QueryHandle )
      and bttQueryWindow.QueryHandle:is-open
      and bttQueryWindow.QueryHandle:num-results > 0 then
      run qg_QueryWindowFindNextMissingObjectId( bttQueryWindow.WindowHandle ).
    
    leave.
    
  end. /* if num-entries( cSelectedColumn_Keys ) > 0 */
  
  message
    'At least one field has to be selected':T skip
    view-as alert-box
    error
    buttons ok.
  
end.

end procedure. /* qg_QueryWindowFindMissingObjectIds */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowFindNextMissingObjectId hQueryWindow 
PROCEDURE qg_QueryWindowFindNextMissingObjectId :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Default action trigger of field selection browse.                          */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i                  as integer   no-undo.
define variable rCurrentRecords    as rowid     no-undo extent.
define variable hQuery             as handle    no-undo.
define variable hBuffers           as handle    no-undo extent.
define variable cDatabaseNames     as character no-undo extent.
define variable cBufferNames       as character no-undo extent.
define variable cFieldNames        as character no-undo extent.
define variable iFieldIndices      as integer   no-undo extent.
define variable hBufferFields      as handle    no-undo extent.
define variable cFieldDataTypes    as character no-undo extent.
define variable lIsVirtual         as logical   no-undo extent.
define variable iFieldTypes        as integer   no-undo extent.
define variable cObjectId          as character no-undo.

define variable lOmitCurrentRecord as logical   no-undo initial yes.

define variable iRecordCount       as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow      for temp-table ttQueryWindow.

define buffer bttField            for temp-table ttField.

define buffer bttQueryWindowField for temp-table ttQueryWindowField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if bttQueryWindow.MissingObjectIdFields = '':U then
do:
  
  run qg_QueryWindowFindMissingObjectIds( bttQueryWindow.WindowHandle ).
  return.
  
end. /* if bttQueryWindow.MissingObjectIdFields = '':U */

assign
  hQuery = bttQueryWindow.QueryHandle
  extent( rCurrentRecords ) = hQuery:num-buffers.
  .

assign
  extent( hBuffers )        = num-entries( bttQueryWindow.MissingObjectIdFields )
  extent( cDatabaseNames )  = num-entries( bttQueryWindow.MissingObjectIdFields )
  extent( cBufferNames )    = num-entries( bttQueryWindow.MissingObjectIdFields )
  extent( cFieldNames )     = num-entries( bttQueryWindow.MissingObjectIdFields )
  extent( iFieldIndices )   = num-entries( bttQueryWindow.MissingObjectIdFields )
  extent( hBufferFields )   = num-entries( bttQueryWindow.MissingObjectIdFields )
  extent( cFieldDataTypes ) = num-entries( bttQueryWindow.MissingObjectIdFields )
  extent( lIsVirtual )      = num-entries( bttQueryWindow.MissingObjectIdFields )
  extent( iFieldTypes )     = num-entries( bttQueryWindow.MissingObjectIdFields )
  .

do i = 1 to num-entries( bttQueryWindow.MissingObjectIdFields ):
  
  run qg_SplitFieldName( entry( i, bttQueryWindow.MissingObjectIdFields ),
                         output cDatabaseNames[i],
                         output cBufferNames[i],
                         output cFieldNames[i],
                         output iFieldIndices[i] ).
  
  assign
    hBuffers[i]       = hQuery:get-buffer-handle( cBufferNames[i] )
    cDatabaseNames[i] = qg_cDatabaseNameForTableOrBuffer( hBuffers[i] )
    .
  
  hBufferFields[i]  = hBuffers[i]:buffer-field( cFieldNames[i] ) no-error.
  
  if   ( error-status:error
       or not valid-handle( hBufferFields[i] ) )
     and qg_lIsPhysicalDatabase( hBuffers[i]:dbname ) then
  do:
    
    find bttField
      where bttField.DatabaseName = cDatabaseNames[i]
        and bttField.TableName    = hBuffers[i]:table
        and bttField.FieldName    = cFieldNames[i]
      no-error.
    
    if available bttField then
      
      assign
        cFieldDataTypes[i] = bttField.DataType
        lIsVirtual[i]      = bttField.IsVirtual
        iFieldTypes[i]     = bttField.FieldType
        .
    
  end. /* if    error-status:error */
  
end. /* do i = 1 to num-entries( bttQueryWindow.MissingObjectIdFields ) */

do i = 1 to hQuery:num-buffers:
  
  rCurrentRecords[i] = hQuery:get-buffer-handle(i):rowid.
  
  if    num-entries( bttQueryWindow.LastMissingObjectIdRecords ) < i
     or to-rowid( entry( i, bttQueryWindow.LastMissingObjectIdRecords ) ) <> rCurrentRecords[i] then
    lOmitCurrentRecord = no.
  
end. /* do i = 1 to hQuery:num-buffers */

if lOmitCurrentRecord then
  hQuery:get-next().

do on error undo, throw:
  
  do while not hQuery:query-off-end:
    
    iRecordCount = iRecordCount + 1.
    
    if   iRecordCount = 50
      or iRecordCount mod 500 = 0 then
    do:
      
      display unless-hidden
        substitute( 'Searching for missing object ids (&1 records checked) ...':T,
                    trim(string( iRecordCount, {&K_MAX_INT64_FORMAT} ) ) )
          @ gcStatusText60
        with frame fStatus
          no-labels
          overlay
          color messages
          centered
          view-as dialog-box
          width 65
          in window bttQueryWindow.WindowHandle
          .
      
      process events.
      
    end. /* if iRecordCount mod 500 = 0 */
    
    do i = 1 to num-entries( bttQueryWindow.MissingObjectIdFields ):
      
      cObjectId = ( if lIsVirtual[i] then
                      string( qg_clVirtualFieldValueAsLongchar( iFieldTypes[i],
                                                                cFieldDataTypes[i],
                                                                cFieldNames[i],
                                                                qg_cObjectIdForBuffer( hBuffers[i] ),
                                                                ? ) )
                    else if valid-handle( hBufferFields[i] ) then
                      hBufferFields[i]:buffer-value( iFieldIndices[i] )
                    else
                      '':U ).
        
      if cObjectId > '':U then
      do:
        
        if qg_cResolveObjectId( cDatabaseNames[i],
                                cFieldNames[i],
                                cObjectId,
                                no,
                                no ) = ? then
        do:
          
          bttQueryWindow.LastMissingObjectIdRecords = '':U.
          
          do i = 1 to hQuery:num-buffers:
            
            rCurrentRecords[i] = hQuery:get-buffer-handle(i):rowid.
            
            if bttQueryWindow.LastMissingObjectIdRecords > '':U then
              bttQueryWindow.LastMissingObjectIdRecords
                  = bttQueryWindow.LastMissingObjectIdRecords + ',':U.
            
            bttQueryWindow.LastMissingObjectIdRecords
                = bttQueryWindow.LastMissingObjectIdRecords + string( rCurrentRecords[i] ).
            
          end. /* do i = 1 to hQuery:num-buffers */
          
          return.
          
        end. /* if cObjectId > '':U */
        
      end. /* if cObjectId > '':U */
      
    end. /* do i = 1 to num-entries( bttQueryWindow.MissingObjectIdFields ) */
    
    hQuery:get-next().
    
  end. /* do while not hQuery:query-off-end */

  finally:
    
    hQuery:reposition-to-rowid(rCurrentRecords).
    
  end finally.
  
end.

hide frame fStatus.

message
  'No more missing Object IDs have been found!':T skip
  view-as alert-box
  information
  buttons ok
    in window bttQueryWindow.WindowHandle.

finally:
  
  hide frame fStatus.
  
end finally.

end procedure. /* qg_QueryWindowFindNextMissingObjectId */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowInsertExternalReference hQueryWindow 
PROCEDURE qg_QueryWindowInsertExternalReference :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Insert external value token into query text.                               */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* phEditor                       = Handle of editor into which the external  */
/*                                  reference should be inserted.             */
/* plFieldReference               = Flag to indicate wether a field reference */
/*                                  or a table reference should be inserted.  */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow         as handle    no-undo.
define input parameter phEditor         as handle    no-undo.
define input parameter plFieldReference as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i                    as integer   no-undo.
define variable j                    as integer   no-undo.

define variable iStartPos            as integer   no-undo.
define variable iFieldRefPos         as integer   no-undo.
define variable iMaxFieldPos         as integer   no-undo.
define variable hQuery               as handle    no-undo.
define variable hBuffer              as handle    no-undo.
define variable hField               as handle    no-undo.
define variable cReferenceText       as character no-undo init ?.
define variable cEditorText          as character no-undo.
define variable iSelectionStart      as integer   no-undo.
define variable iSelectionEnd        as integer   no-undo.

define variable cTableName           as character no-undo init ?.
define variable cFieldName           as character no-undo init ?.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow      for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*---------------------------------------------------------------o-------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if    bttQueryWindow.ObjSourceQuerySeq > 0
   or not valid-handle(bttQueryWindow.QueryHandle) then
  leave.

if plFieldReference then
do:
  
  assign
    hQuery      = bttQueryWindow.QueryHandle
    cEditorText = phEditor:input-value
    iStartPos   = max(r-index(cEditorText,
                              '=':U,
                              phEditor:cursor-offset),
                      r-index(cEditorText,
                              '<':U,
                              phEditor:cursor-offset),
                      r-index(cEditorText,
                              '>':U,
                              phEditor:cursor-offset))
    iStartPos   = (if iStartPos = 0 then
                     phEditor:cursor-offset
                   else
                     iStartPos)
    .
  
  /* Try to guess the field name for wich an external reference should be     */
  /* inserted.                                                                */
  
  do i = 1 to hQuery:num-buffers:
    
    hBuffer = hQuery:get-buffer-handle(i).
    
    do j = 1 to hBuffer:num-fields:
      
      hField = hBuffer:buffer-field(j).
      
      iFieldRefPos = r-index(cEditorText,
                             substitute('&1.&2':U, hBuffer:name, hField:name),
                             iStartPos).
      
      if    iFieldRefPos > 0
        and iFieldRefPos > iMaxFieldPos then
        assign
          cTableName   = hBuffer:table
          cFieldName   = hField:name
          iMaxFieldPos = iFieldRefPos
          .
      
    end. /* do j = 1 to hBuffer:num-fields */
    
  end. /* do i = 1 to hQuery:num-buffers */
  
end. /* if plFieldReference */

run qg_GetExternalReference(cTableName,
                            cFieldName,
                            plFieldReference,
                            substitute('!&1,*':U, bttQueryWindow.WindowHandle),
                            bttQueryWindow.WindowHandle,
                            output cReferenceText).

if cReferenceText > '':U then
do:
  
  assign
    iSelectionStart = (if phEditor:selection-start <> ? then
                         phEditor:selection-start
                       else
                         phEditor:cursor-offset)
    iSelectionEnd   = (if phEditor:selection-end <> ? then
                         phEditor:selection-end
                       else
                         phEditor:cursor-offset)
    .
  
  if cEditorText > '':U then
  do:
  
    if    iSelectionStart > 1
      and index('~'"':U, substring(cEditorText, iSelectionStart - 1, 1)) > 0 then
      iSelectionStart = iSelectionStart - 1.
    
    if index('~'"':U, substring(cEditorText, iSelectionEnd, 1)) > 0 then
      iSelectionEnd = iSelectionEnd + 1.
    
    if    iSelectionStart > 0
      and iSelectionEnd  >= iSelectionStart then
      phEditor:set-selection(iSelectionStart, iSelectionEnd).
  
  end. /* if cEditorText > '':U */
  
  if phEditor:selection-text > '':U then
    phEditor:replace-selection-text(cReferenceText).
  else
    phEditor:insert-string(cReferenceText).
  
end. /* cReferenceText */

end procedure. /* qg_QueryWindowInsertExternalReference */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowListActivateQueryWindow hQueryWindow 
PROCEDURE qg_QueryWindowListActivateQueryWindow :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer as handle    no-undo.
define variable hWindow as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(ghQueryWindowListWindow) then
  leave.

hBuffer = ghQueryWindowListBrowse:query:get-buffer-handle(1).

if    hBuffer:available
  and hBuffer::WindowHandle:visible then
do:
  
  find bttQueryWindow
    where bttQueryWindow.WindowHandle = hBuffer::WindowHandle
    no-lock no-error.
  
  run qg_QueryWindowShowChildWindows(bttQueryWindow.QuerySeq).
  
  run qg_ActivateWindow(bttQueryWindow.WindowHandle, bttQueryWindow.QueryBrowseHandle).
  
end. /* if hBuffer:available */

end procedure. /* qg_QueryWindowListActivateQueryWindow */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowListBrowseOnRowDisplay hQueryWindow 
PROCEDURE qg_QueryWindowListBrowseOnRowDisplay :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phColumn as handle    no-undo.
define input parameter phBuffer as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define variable hBuffer as handle    no-undo.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(ghQueryWindowListWindow) then
  leave.

phColumn:fgcolor = (if not phBuffer:available then
                      ?
                    else if not phBuffer::WindowHandle:visible then
                      {&K_COLOR_LIGHT_GREY}
                    else
                      ?).

end procedure. /* qg_QueryWindowListBrowseOnRowDisplay */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowListBrowsePopupMenuDrop hQueryWindow 
PROCEDURE qg_QueryWindowListBrowsePopupMenuDrop :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer                        as handle    no-undo.

define variable hMenu                          as handle    no-undo.

define variable hActivateMenuItem              as handle    no-undo.
define variable hMinimizeMenuItem              as handle    no-undo.
define variable hHideMenuItem                  as handle    no-undo.
define variable hCloseMenuItem                 as handle    no-undo.
define variable hMinimizeBranchMenuItem        as handle    no-undo.
define variable hHideBranchMenuItem            as handle    no-undo.
define variable hCloseBranchMenuItem           as handle    no-undo.
define variable hCloseAllMenuItem              as handle    no-undo.
define variable hOpenRelatedQueryMenuItem      as handle    no-undo.
define variable hAlwaysOnTopMenuItem           as handle    no-undo.

define variable lQueryWindowsExist             as logical   no-undo.
define variable lHasChildren                   as logical   no-undo.
define variable lIsVisible                     as logical   no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(ghQueryWindowListWindow) then
  leave.

assign
  lQueryWindowsExist = temp-table ttQueryWindow:has-records
  hBuffer            = ghQueryWindowListBrowse:query:get-buffer-handle(1)
  lHasChildren
      = (if hBuffer:available then
           can-find(first ttQueryWindowView
                      where ttQueryWindowView.ParentWindowHandle = hBuffer::WindowHandle)
         else
           no)
  lIsVisible
      = (if hBuffer:available then
           hBuffer::WindowHandle:visible
         else
           no)
  hMenu   = ghQueryWindowListBrowse:popup-menu
  hActivateMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_Activate':U)
  hActivateMenuItem:sensitive
      = lIsVisible
  hMinimizeMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_Minimize':U)
  hHideMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_Hide':U)
  hCloseMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_Close':U)
  hMinimizeBranchMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_MinimizeBranch':U)
  hHideBranchMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_HideBranch':U)
  hCloseBranchMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_CloseBranch':U)
  hCloseAllMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_CloseAll':U)
  hCloseAllMenuItem:sensitive
      = lQueryWindowsExist
  hOpenRelatedQueryMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_OpenRelatedQuery':U)
  hOpenRelatedQueryMenuItem:sensitive
      = hBuffer:available
  hAlwaysOnTopMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_AlwaysOnTop':U)
  hAlwaysOnTopMenuItem:sensitive
      = hBuffer:available
  .

if hBuffer:available then
  assign
    hMinimizeMenuItem:sensitive
        = lIsVisible
    hMinimizeMenuItem:label
        = (if hBuffer::WindowHandle:window-state = {&K_WINDOW_MINIMIZED} then
             'Restore':T
           else
             'Minimize':T)
    hHideMenuItem:sensitive
        = yes
    hHideMenuItem:label
        = (if hBuffer::WindowHandle:visible then
             'Hide':T
           else
             'Show':T)
    hCloseMenuItem:sensitive
        = yes
    hMinimizeBranchMenuItem:sensitive
        = lHasChildren
    hMinimizeBranchMenuItem:label
        = (if hBuffer::WindowHandle:window-state = {&K_WINDOW_MINIMIZED} then
             'Restore branch':T
           else
             'Minimize branch':T)
    hHideBranchMenuItem:sensitive
        = lHasChildren
    hHideBranchMenuItem:label
        = (if hBuffer::WindowHandle:visible then
             'Hide branch':T
           else
             'Show branch':T)
    hCloseBranchMenuItem:sensitive
        = lHasChildren
    hAlwaysOnTopMenuItem:checked
        = hBuffer::WindowHandle:always-on-top
    .
  
else
  assign
    hMinimizeMenuItem:sensitive
        = no
    hMinimizeMenuItem:label
        = 'Minimize':T
    hHideMenuItem:sensitive
        = no
    hHideMenuItem:label
        = 'Hide':T
    hCloseMenuItem:sensitive
        = no
    hMinimizeBranchMenuItem:sensitive
        = no
    hMinimizeBranchMenuItem:label
        = 'Minimize branch':U
    hHideBranchMenuItem:sensitive
        = no
    hHideBranchMenuItem:label
        = 'Hide branch':T
    hCloseBranchMenuItem:sensitive
        = no
    hAlwaysOnTopMenuItem:checked
        = no
    .

end procedure. /* qg_QueryWindowListBrowsePopupMenuDrop */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowListCloseAllQueryWindows hQueryWindow 
PROCEDURE qg_QueryWindowListCloseAllQueryWindows :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/


/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

for each bttQueryWindow
  on error undo, throw:
  
  if valid-handle(bttQueryWindow.WindowHandle) then
    run qg_QueryWindowClose(bttQueryWindow.WindowHandle, no).
  
  else
    delete bttQueryWindow.
  
end. /* for each bttQueryWindow */

end procedure. /* qg_QueryWindowListCloseAllQueryWindows */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowListCloseQueryWindow hQueryWindow 
PROCEDURE qg_QueryWindowListCloseQueryWindow :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter plCloseChildWindows as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer as handle    no-undo.
define variable hWindow as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(ghQueryWindowListWindow) then
  leave.

hBuffer = ghQueryWindowListBrowse:query:get-buffer-handle(1).

if hBuffer:available then
  run qg_QueryWindowClose(hBuffer::WindowHandle, plCloseChildWindows).
  
end procedure. /* qg_QueryWindowListCloseQueryWindow */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowListCopyQueryScenario hQueryWindow 
PROCEDURE qg_QueryWindowListCopyQueryScenario :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

apply 'choose':U to menu-item mi_CopyQueryScenario in menu m_Edit.

end procedure. /* qg_QueryWindowListCopyQueryScenario */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowListDropFileNotify hQueryWindow 
PROCEDURE qg_QueryWindowListDropFileNotify :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hFrame    as handle    no-undo.
define variable i         as integer   no-undo.
define variable cFileName as character no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(ghQueryWindowListWindow) then
  leave.

hFrame = qg_hGetWidgetByName(ghQueryWindowListWindow, 'fQueryWindows':U).

do i = 1 to hFrame:num-dropped-files:
  
  cFileName = hFrame:get-dropped-file(i).

  if cFileName matches '*.qsc':U then
    run qg_LoadQueryScenario(cFileName, (i = 1)).

end. /* do i = 1 to hFrame:num-dropped-files */

finally:
  
  if valid-handle(hFrame) then
    hFrame:end-file-drop().
  
end finally.

end procedure. /* qg_QueryWindowListDropFileNotify */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowListEditMenuDrop hQueryWindow 
PROCEDURE qg_QueryWindowListEditMenuDrop :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Trigger procedure for window close event of query window list window.      */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hMenu                       as handle    no-undo.
define variable hCopyQueryScenarioMenuItem  as handle    no-undo.
define variable hPasetQueryScenarioMenuItem as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(ghQueryWindowListWindow) then
  leave.

assign
  hMenu                 = ghQueryWindowListWindow:menu-bar
  hCopyQueryScenarioMenuItem
      = qg_hGetWidgetByName(hMenu, 'mi_CopyQueryScenario':U)
  hCopyQueryScenarioMenuItem:sensitive
      = can-find(first ttQueryWindow)
  hPasetQueryScenarioMenuItem
      = qg_hGetWidgetByName(hMenu, 'mi_PasteQueryScenario':U)
  hPasetQueryScenarioMenuItem:sensitive
      = lookup('PRO_TEXT':U, clipboard:available-formats) > 0
  .

end procedure. /* qg_QueryWindowListEditMenuDrop */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowListFileMenuDrop hQueryWindow 
PROCEDURE qg_QueryWindowListFileMenuDrop :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hMenu                      as handle    no-undo.
define variable hSaveQueryScenarioMenuItem as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(ghQueryWindowListWindow) then
  leave.

assign
  hMenu                 = ghQueryWindowListWindow:menu-bar
  hSaveQueryScenarioMenuItem
      = qg_hGetWidgetByName(hMenu, 'mi_SaveQueryScenario':U)
  hSaveQueryScenarioMenuItem:sensitive
      = can-find(first ttQueryWindow)
  .

end procedure. /* qg_QueryWindowListFileMenuDrop */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowListHideQueryWindow hQueryWindow 
PROCEDURE qg_QueryWindowListHideQueryWindow :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter plUpdateChildren as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer as handle    no-undo.
define variable hWindow as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(ghQueryWindowListWindow) then
  leave.

hBuffer = ghQueryWindowListBrowse:query:get-buffer-handle(1).

if hBuffer:available then
do:
  
  find bttQueryWindow
    where bttQueryWindow.WindowHandle = hBuffer::WindowHandle
    no-error.
  
  if available bttQueryWindow then
  do:
    
    run qg_QueryWindowSetVisibleState(bttQueryWindow.QuerySeq,
                                      not bttQueryWindow.WindowHandle:visible,
                                      plUpdateChildren).
    
    run qg_UpdateQueryWindowView.
    
    if ghQueryWindowListBrowse:query:num-results > 0 then
      ghQueryWindowListBrowse:refresh().
    
  end. /* if available bttQueryWindow */

end. /* if hBuffer:available */

end procedure. /* qg_QueryWindowListHideQueryWindow */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowListLoadQueryScenario hQueryWindow 
PROCEDURE qg_QueryWindowListLoadQueryScenario :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

apply 'choose':U to menu-item mi_LoadQueryScenario in menu m_File.

end procedure. /* qg_QueryWindowListLoadQueryScenario */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowListSetVisibleStates hQueryWindow 
PROCEDURE qg_QueryWindowListSetVisibleStates :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter plVisible as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

for each bttQueryWindow
  on error undo, throw:
  
  if bttQueryWindow.WindowHandle:visible <> plVisible then
    run qg_QueryWindowSetVisibleState(bttQueryWindow.QuerySeq,
                                      plVisible,
                                      no).
  
end. /* for each bttQueryWindow */

run qg_UpdateQueryWindowView.

if    valid-handle(ghQueryWindowListWindow)
  and ghQueryWindowListBrowse:query:num-results > 0 then
  ghQueryWindowListBrowse:refresh().

end procedure. /* qg_QueryWindowListSetVisibleStates */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowListSetWindowStates hQueryWindow 
PROCEDURE qg_QueryWindowListSetWindowStates :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter piWindowState as integer   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer as handle    no-undo.
define variable hWindow as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

for each bttQueryWindow
  on error undo, throw:
  
  if    ( piWindowState = {&K_WINDOW_MINIMIZED}
      and bttQueryWindow.WindowHandle:window-state <> {&K_WINDOW_MINIMIZED} )
     or
        ( piWindowState <> {&K_WINDOW_MINIMIZED}
      and bttQueryWindow.WindowHandle:window-state = {&K_WINDOW_MINIMIZED} ) then
  run qg_QueryWindowSetWindowState(bttQueryWindow.QuerySeq,
                                   piWindowState,
                                   no).
  
end. /* for each bttQueryWindow */

end procedure. /* qg_QueryWindowListSetWindowStates */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowListMinimizeQueryWindow hQueryWindow 
PROCEDURE qg_QueryWindowListMinimizeQueryWindow :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter plUpdateChildren as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer as handle    no-undo.
define variable hWindow as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(ghQueryWindowListWindow) then
  leave.

hBuffer = ghQueryWindowListBrowse:query:get-buffer-handle(1).

if hBuffer:available then
do:
  
  find bttQueryWindow
    where bttQueryWindow.WindowHandle = hBuffer::WindowHandle
    no-error.
  
  if available bttQueryWindow then
    run qg_QueryWindowSetWindowState(bttQueryWindow.QuerySeq,
                                     (if bttQueryWindow.WindowHandle:window-state = {&K_WINDOW_MINIMIZED} then
                                        {&K_WINDOW_NORMAL}
                                      else
                                        {&K_WINDOW_MINIMIZED}),
                                     plUpdateChildren).
    
end. /* if hBuffer:available */

end procedure. /* qg_QueryWindowListMinimizeQueryWindow */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowListOpenRelatedQuery hQueryWindow 
PROCEDURE qg_QueryWindowListOpenRelatedQuery :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(ghQueryWindowListWindow) then
  leave.

hBuffer = ghQueryWindowListBrowse:query:get-buffer-handle(1).

if hBuffer:available then
  run qg_QueryWindowOpenRelatedQuery(hBuffer::WindowHandle).

end procedure. /* qg_QueryWindowListOpenRelatedQuery */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowListPasteQueryScenario hQueryWindow 
PROCEDURE qg_QueryWindowListPasteQueryScenario :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

apply 'choose':U to menu-item mi_PasteQueryScenario in menu m_Edit.

end procedure. /* qg_QueryWindowListPasteQueryScenario */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowListQueryWindowAlwaysOnTop hQueryWindow 
PROCEDURE qg_QueryWindowListQueryWindowAlwaysOnTop :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(ghQueryWindowListWindow) then
  leave.

hBuffer = ghQueryWindowListBrowse:query:get-buffer-handle(1).

if hBuffer:available then
do:
  
  find bttQueryWindow
    where bttQueryWindow.WindowHandle = hBuffer::WindowHandle
    no-lock no-error.
  
  bttQueryWindow.WindowHandle:always-on-top = not bttQueryWindow.WindowHandle:always-on-top.
  
end. /* if hBuffer:available */

end procedure. /* qg_QueryWindowListQueryWindowAlwaysOnTop */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowListRefresh hQueryWindow 
PROCEDURE qg_QueryWindowListRefresh :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hQuery        as handle    no-undo.
define variable hBuffer       as handle    no-undo.

define variable rLine         as rowid     no-undo.
define variable hWindow       as handle    no-undo.
define variable hParentWindow as handle    no-undo.


/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow     for temp-table ttQueryWindow.
define buffer bttQueryWindowView for temp-table ttQueryWindowView.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

run qg_UpdateQueryWindowView.

if valid-handle(ghQueryWindowListWindow) then
do:
  
  assign
    hQuery      = ghQueryWindowListBrowse:query
    hBuffer     = hQuery:get-buffer-handle(1)
    .
  
  if hBuffer:available then
    assign
      rLine         = hBuffer:rowid
      hWindow       = hBuffer::windowHandle
      hParentWindow = hBuffer::ParentWindowHandle
      .
  
  qg_lQueryOpen(hQuery, 'for each ttQueryWindowView by Id':U, ghQueryWindowListWindow).
  
  if hWindow <> ? then
  do:
    
    find bttQueryWindowView
      where rowid(bttQueryWindowView) = rLine
      no-error.
    
    if not available bttQueryWindowView then
    do:
      
      find first bttQueryWindowView
        where bttQueryWindowView.ParentWindowHandle = hParentWindow
          and bttQueryWindowView.WindowHandle       = hWindow
        no-error.
      
      if not available bttQueryWindowView then
        find first bttQueryWindowView
          where bttQueryWindowView.WindowHandle = hWindow
          no-error.
      
    end. /* if not available bttQueryWindowView */
    
    if available bttQueryWindowView then
      hQuery:reposition-to-rowid(rowid(bttQueryWindowView)) no-error.
    
  end. /* if hWindow <> ? */
  
end. /* if valid-handle(ghQueryWindowListWindow) */

end procedure. /* qg_QueryWindowListRefresh */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowListSaveQueryScenario hQueryWindow 
PROCEDURE qg_QueryWindowListSaveQueryScenario :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

apply 'choose':U to menu-item mi_SaveQueryScenario in menu m_File.

end procedure. /* qg_QueryWindowListSaveQueryScenario */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowListSelectQueryWindow hQueryWindow 
PROCEDURE qg_QueryWindowListSelectQueryWindow :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindowView for temp-table ttQueryWindowView.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if    valid-handle(ghQueryWindowListWindow)
  and valid-handle(phWindow) then
do:
  
  hBuffer = ghQueryWindowListBrowse:query:get-buffer-handle(1).
  
  if   not hBuffer:available
    or hBuffer::WindowHandle <> phWindow then
  do:
    
    find first bttQueryWindowView
      where bttQueryWindowView.WindowHandle = phWindow
      no-error.
    
    if available bttQueryWindowView then
      ghQueryWindowListBrowse:query:reposition-to-rowid(rowid(bttQueryWindowView)) no-error.
    
  end. /* if   not hBuffer:available ... */
  
end. /* if valid-handle(ghQueryWindowListWindow) ... */

end procedure. /* qg_QueryWindowListSelectQueryWindow */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowListToggleAlwaysOnTop hQueryWindow 
PROCEDURE qg_QueryWindowListToggleAlwaysOnTop :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(ghQueryWindowListWindow) then
  leave.

ghQueryWindowListWindow:always-on-top = not ghQueryWindowListWindow:always-on-top.

end procedure. /* qg_QueryWindowListToggleAlwaysOnTop */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowListToolsMenuDrop hQueryWindow 
PROCEDURE qg_QueryWindowListToolsMenuDrop :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer                        as handle    no-undo.

define variable hMenu                          as handle    no-undo.

define variable hMinimizeAllMenuItem           as handle    no-undo.
define variable hRestoreAllMenuItem            as handle    no-undo.
define variable hHideAllMenuItem               as handle    no-undo.
define variable hShowAllMenuItem               as handle    no-undo.
define variable hCloseAllMenuItem              as handle    no-undo.

define variable lQueryWindowsExist             as logical   no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(ghQueryWindowListWindow) then
  leave.

assign
  lQueryWindowsExist = temp-table ttQueryWindow:has-records
  hBuffer            = ghQueryWindowListBrowse:query:get-buffer-handle(1)
  hMenu              = ghQueryWindowListWindow:menu-bar
  hMinimizeAllMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_MinimizeAll':U)
  hMinimizeAllMenuItem:sensitive
      = lQueryWindowsExist
  hRestoreAllMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_RestoreAll':U)
  hRestoreAllMenuItem:sensitive
      = lQueryWindowsExist
  hHideAllMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_HideAll':U)
  hHideAllMenuItem:sensitive
      = lQueryWindowsExist
  hShowAllMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_ShowAll':U)
  hShowAllMenuItem:sensitive
      = lQueryWindowsExist
  hCloseAllMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_CloseAll':U)
  hCloseAllMenuItem:sensitive
      = lQueryWindowsExist
  .

end procedure. /* qg_QueryWindowListToolsMenuDrop */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowListWindowClose hQueryWindow 
PROCEDURE qg_QueryWindowListWindowClose :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Trigger procedure for window close event of query window list window.      */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/


/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if valid-handle(ghQueryWindowListWindow) then
  run qg_DeleteWidgetTree(ghQueryWindowListWindow, yes).

end procedure. /* qg_QueryWindowListWindowClose */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowListWindowMenuDrop hQueryWindow 
PROCEDURE qg_QueryWindowListWindowMenuDrop :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Trigger procedure for window close event of query window list window.      */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hMenu                as handle    no-undo.
define variable hAlwaysOnTopMenuItem as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(ghQueryWindowListWindow) then
  leave.

assign
  hMenu                 = ghQueryWindowListWindow:menu-bar
  hAlwaysOnTopMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_AlwaysOnTop':U)
  hAlwaysOnTopMenuItem:checked
      = ghQueryWindowListWindow:always-on-top
  .

end procedure. /* qg_QueryWindowListWindowMenuDrop */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowListWindowResize hQueryWindow 
PROCEDURE qg_QueryWindowListWindowResize :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Trigger procedure for window resize event of query window list window.     */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hFrame as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(ghQueryWindowListWindow) then
  leave.

assign
  ghQueryWindowListWindow:width     = max(20, ghQueryWindowListWindow:width)
  ghQueryWindowListWindow:height    = max(3, ghQueryWindowListWindow:height)
  hFrame                            = qg_hGetWidgetByName(ghQueryWindowListWindow,
                                                          'fQueryWindows':U)
  hFrame:width                      = ghQueryWindowListWindow:width
  hFrame:virtual-width              = ghQueryWindowListWindow:width
  hFrame:height                     = ghQueryWindowListWindow:height
  hFrame:virtual-height             = ghQueryWindowListWindow:height
  ghQueryWindowListBrowse:width     = hFrame:width
  ghQueryWindowListBrowse:height    = hFrame:height
  .

end procedure. /* qg_QueryWindowListWindowResize */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowMoveColumn hQueryWindow 
PROCEDURE qg_QueryWindowMoveColumn :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Move field column to first column.                                         */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* plFirst                        = If yes the field will be moved to the     */
/*                                  first column. Otherwise it will be moved  */
/*                                  to the last column.                       */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.
define input parameter plFirst  as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hFieldSelectionBuffer as handle    no-undo.
define variable hColumn               as handle    no-undo.
define variable iSelection            as integer   no-undo.
define variable iColumn               as integer   no-undo.

define variable cFieldName            as character no-undo.
define variable cColumnName           as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow  for temp-table ttQueryWindow.

define buffer bttFieldOverlay for temp-table ttFieldOverlay.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hFieldSelectionBuffer = bttQueryWindow.QueryFieldBrowseBufferHandle.

if plFirst then
do:

  do iSelection = bttQueryWindow.QueryFieldBrowseHandle:num-selected-rows to 1 by -1:
    
    bttQueryWindow.QueryFieldBrowseHandle:fetch-selected-row(iSelection).
    
    cFieldName = qg_cFormattedFieldName(?,
                                        hFieldSelectionBuffer::BufferName,
                                        hFieldSelectionBuffer::FieldName,
                                        hFieldSelectionBuffer::FieldIndex).
    
    do iColumn = 1 to bttQueryWindow.QueryBrowseHandle:num-columns:
      
      hColumn = bttQueryWindow.QueryBrowseHandle:get-browse-column(iColumn).
      
      find first bttFieldOverlay
        where bttFieldOverlay.OwnerHandle         = bttQueryWindow.QueryHandle
          and bttFieldOverlay.OverlayColumnHandle = hColumn
        no-error.
      
      if    available bttFieldOverlay
        and valid-handle(bttFieldOverlay.ColumnHandle)
        and not bttFieldOverlay.ColumnHandle:visible then
        hColumn = bttFieldOverlay.ColumnHandle.

      cColumnName = qg_cColumnFieldName(hColumn, yes).
        
      if cColumnName = cFieldName then
      do:
        
        bttQueryWindow.QueryBrowseHandle:move-column(iColumn, 1).
        leave.
        
      end. /* if cColumnName = cFieldName */
      
    end. /* do iColumn = 1 to bttQueryWindow.QueryBrowseHandle:num-columns */
      
  end. /* do iSelection = bttQueryWindow.QueryFieldBrowseHandle:num-selected-rows to 1 by -1 */

end. /* if plFirst */

else
do:
  
  do iSelection = 1 to bttQueryWindow.QueryFieldBrowseHandle:num-selected-rows:
    
    bttQueryWindow.QueryFieldBrowseHandle:fetch-selected-row(iSelection).
    
    cFieldName = qg_cFormattedFieldName(?,
                                        hFieldSelectionBuffer::BufferName,
                                        hFieldSelectionBuffer::FieldName,
                                        hFieldSelectionBuffer::FieldIndex).
    
    do iColumn = 1 to bttQueryWindow.QueryBrowseHandle:num-columns:
      
      hColumn = bttQueryWindow.QueryBrowseHandle:get-browse-column(iColumn).
      
      find first bttFieldOverlay
        where bttFieldOverlay.OwnerHandle         = bttQueryWindow.QueryHandle
          and bttFieldOverlay.OverlayColumnHandle = hColumn
        no-error.
      
      if    available bttFieldOverlay
        and valid-handle(bttFieldOverlay.ColumnHandle)
        and not bttFieldOverlay.ColumnHandle:visible then
        hColumn = bttFieldOverlay.ColumnHandle.

      cColumnName = qg_cColumnFieldName(hColumn, yes).
        
      if cColumnName = cFieldName then
      do:
        
        bttQueryWindow.QueryBrowseHandle:move-column(iColumn, bttQueryWindow.QueryBrowseHandle:num-columns).
        leave.
        
      end. /* if cColumnName = cFieldName */
      
    end. /* do iColumn = 1 to bttQueryWindow.QueryBrowseHandle:num-columns */
    
  end. /* do iSelection = bttQueryWindow.QueryFieldBrowseHandle:num-selected-rows to 1 by -1 */
  
end. /* else: if plFirst */

end procedure. /* qg_QueryWindowMoveColumn */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowObjectIdOverlay hQueryWindow 
PROCEDURE qg_QueryWindowObjectIdOverlay :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable lHidden                 as logical   no-undo.
define variable lSuggestions            as logical   no-undo.
define variable lSelected               as logical   no-undo.

define variable cField_Key              as character no-undo.
define variable cField_Label            as character no-undo.
define variable cAvailableColumn_Keys   as character no-undo.
define variable cAvailableColumn_Labels as character no-undo.
define variable cSelectedColumn_Keys    as character no-undo.
define variable lOk                     as logical   no-undo.

define variable i                       as integer   no-undo.

define variable cDatabaseName           as character no-undo.
define variable cBufferName             as character no-undo.
define variable cFieldName              as character no-undo.
define variable iFieldIndex             as integer   no-undo.
define variable cNewOverlayFields       as character no-undo.

define variable cOverlayFieldName       as character no-undo.
define variable cFieldOrder             as character no-undo.
define variable cColumns                as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow      for temp-table ttQueryWindow.

define buffer bttField            for temp-table ttField.

define buffer bttQueryWindowField for temp-table ttQueryWindowField.
define buffer bttFieldOverlay     for temp-table ttFieldOverlay.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if    not available bttQueryWindow
   or not valid-handle(bttQueryWindow.QueryHandle) then
  leave.

/* Show field overlay selection dialog. */

lSuggestions = not can-find(first ttFieldOverlay
                              where ttFieldOverlay.OwnerHandle = bttQueryWindow.QueryHandle).

for each bttQueryWindowField
  where bttQueryWindowField.WindowHandle = bttQueryWindow.WindowHandle
    and bttQueryWindowField.IsOverlay    = no
  on error undo, throw:
  
  if lookup(bttQueryWindowField.DataType, 'CHARACTER,LONGCHAR':U) = 0 then
    next.
  
  assign
    lSelected               = (if not lSuggestions then
                                 can-find(ttFieldOverlay
                                            where ttFieldOverlay.OwnerHandle  = bttQueryWindow.QueryHandle
                                              and ttFieldOverlay.BufferName   = bttQueryWindowField.BufferName
                                              and ttFieldOverlay.FieldName    = bttQueryWindowField.FieldName
                                              and ttFieldOverlay.FieldIndex   = bttQueryWindowField.FieldIndex)
                               else
                                       ( bttQueryWindowField.FieldName matches '*_Obj':U
                                      or bttQueryWindowField.isObjectId )
                                   and not bttQueryWindowField.FieldName matches substitute('&1_Obj':U, bttQueryWindowField.TableName))
    cField_Key              = qg_cFormattedFieldName(?,
                                                     bttQueryWindowField.BufferName,
                                                     bttQueryWindowField.FieldName,
                                                     bttQueryWindowField.FieldIndex)
    cAvailableColumn_Keys   = substitute('&1,&2':U, cAvailableColumn_Keys, cField_Key)
    cField_Label            = qg_cFormattedFieldName(?,
                                                     (if    valid-handle(bttQueryWindow.QueryBrowseHandle)
                                                        and bttQueryWindow.QueryHandle:num-buffers > 1 then
                                                        bttQueryWindowField.BufferName
                                                      else
                                                        ?),
                                                     bttQueryWindowField.FieldName,
                                                     bttQueryWindowField.FieldIndex)
    cAvailableColumn_Labels = substitute('&1,&2':U,
                                         cAvailableColumn_Labels,
                                         (if   lSuggestions
                                            and lSelected then
                                            substitute('&1 *':U, cField_Label)
                                          else
                                            cField_Label))
    .
  
  if lSelected then
    cSelectedColumn_Keys = substitute('&1,&2':U, cSelectedColumn_Keys, cField_Key).
  
end. /* for each bttQueryWindowField */

assign
  cAvailableColumn_Keys   = trim(cAvailableColumn_Keys, ',':U)
  cAvailableColumn_Labels = trim(cAvailableColumn_Labels, ',':U)
  cSelectedColumn_Keys    = trim(cSelectedColumn_Keys, ',':U)
  .

run qg_SelectionDialog(cAvailableColumn_Keys,
                       cAvailableColumn_Labels,
                       input-output cSelectedColumn_Keys,
                       'Select overlay columns':T,
                       bttQueryWindow.WindowHandle,
                       no,
                       output lOk).

if lOk then
do on error undo, throw:
  
  cFieldOrder = qg_cQueryWindowFieldList(bttQueryWindow.WindowHandle,
                                         yes,
                                         no).
  
  if valid-handle(bttQueryWindow.QueryFrameHandle) then
    assign
      lHidden                                 = bttQueryWindow.QueryBrowseHandle:hidden
      bttQueryWindow.QueryBrowseHandle:hidden = yes
      cColumns                                = qg_cBrowseColumnList( bttQueryWindow.QueryBrowseHandle,
                                                                      yes,
                                                                      no,
                                                                      yes )
      .
  
  /* Remove field overlay entries that are no longer selected. */
  
  for each bttFieldOverlay
    where bttFieldOverlay.OwnerHandle = bttQueryWindow.QueryHandle
    no-lock
    on error undo, throw:
    
    if lookup(qg_cFormattedFieldName(?,
                                     bttFieldOverlay.BufferName,
                                     bttFieldOverlay.FieldName,
                                     bttFieldOverlay.FieldIndex),
              cSelectedColumn_Keys) > 0 then
      next.
    
    assign
      cFieldName        = qg_cFormattedFieldName(?,
                                                 bttFieldOverlay.BufferName,
                                                 bttFieldOverlay.FieldName,
                                                 bttFieldOverlay.FieldIndex)
      cOverlayFieldName = substitute({&K_OBJECTID_OVERLAY_NAME_PATTERN},
                                     cFieldName)
      cFieldOrder       = qg_cReplaceColumn(cFieldOrder,
                                            cOverlayFieldName,
                                            cFieldName)
      .
    
    if    valid-handle(bttQueryWindow.QueryFrameHandle)
      and valid-handle(bttFieldOverlay.ColumnHandle)
      and valid-handle(bttFieldOverlay.OverlayColumnhandle)
      and not bttFieldOverlay.ColumnHandle:visible then
      
      cColumns = qg_cReplaceColumn(cColumns,
                                   cFieldName,
                                   cOverlayFieldName).
    
    run qg_DeleteFieldOverlay(bttFieldOverlay.OwnerHandle,
                              bttFieldOverlay.BufferName,
                              bttFieldOverlay.FieldName,
                              bttFieldOverlay.FieldIndex).
      
  end. /* for each bttFieldOverlay */
  
  /* Create field overlay entries for all selected fields. */
  
  do i = 1 to num-entries(cSelectedColumn_Keys):
    
    run qg_SplitFieldName(entry(i, cSelectedColumn_Keys),
                          output cDatabaseName,
                          output cBufferName,
                          output cFieldName,
                          output iFieldIndex).
    
    find bttQueryWindowField
      where bttQueryWindowField.WindowHandle = bttQueryWindow.WindowHandle
        and bttQueryWindowField.BufferName   = cBufferName
        and bttQueryWindowField.FieldName    = cFieldName
        and bttQueryWindowField.FieldIndex   = iFieldIndex
      no-error.
    
    if not available bttQueryWindowField then
      next.
    
    find bttFieldOverlay
      where bttFieldOverlay.OwnerHandle = bttQueryWindow.QueryHandle
        and bttFieldOverlay.BufferName  = bttQueryWindowField.BufferName
        and bttFieldOverlay.FieldName   = bttQueryWindowField.FieldName
        and bttFieldOverlay.FieldIndex  = bttQueryWindowField.FieldIndex
      no-error.
    
    if not available bttFieldOverlay then
    do:
      
      create bttFieldOverlay.
      
      assign
        bttFieldOverlay.OwnerHandle  = bttQueryWindow.QueryHandle
        bttFieldOverlay.DatabaseName = bttQueryWindowField.DatabaseName
        bttFieldOverlay.BufferName   = bttQueryWindowField.BufferName
        bttFieldOverlay.FieldName    = bttQueryWindowField.FieldName
        bttFieldOverlay.FieldIndex   = bttQueryWindowField.FieldIndex
        .
      
      validate bttFieldOverlay.
      
      cNewOverlayFields = substitute('&1,&2':U,
                                     cNewOverlayFields,
                                     string(rowid(bttFieldOverlay))).
      
    end. /* if not available bttFieldOverlay */
    
  end. /* do i = 1 to num-entries(cSelectedColumn_Keys) */
  
  cNewOverlayFields = trim(cNewOverlayFields, ',':U).
  
  /* Update window field temp-table. */
  
  do i = 1 to num-entries(cNewOverlayFields):
    
    find bttFieldOverlay
      where rowid(bttFieldOverlay) = to-rowid(entry(i, cNewOverlayFields))
      no-error.
    
    if not available bttFieldOverlay then
      next.
    
    assign
      cFieldName        = qg_cFormattedFieldName(?,
                                                 bttFieldOverlay.BufferName,
                                                 bttFieldOverlay.FieldName,
                                                 bttFieldOverlay.FieldIndex)
      cOverlayFieldName = substitute({&K_OBJECTID_OVERLAY_NAME_PATTERN},
                                     cFieldName)
      cFieldOrder       = qg_cReplaceColumn(cFieldOrder,
                                            cFieldName,
                                            cOverlayFieldName)
      .
    
    if valid-handle(bttQueryWindow.QueryFrameHandle) then
      cColumns = qg_cReplaceColumn(cColumns,
                                   cFieldName,
                                   cOverlayFieldName).
    
  end. /* for each bttFieldOverlay */
  
  run qg_QueryWindowUpdateFieldTempTable(bttQueryWindow.QueryHandle,
                                         bttQueryWindow.WindowHandle,
                                         cFieldOrder).

  /* Update browse columns (if necessary). */
  
  if valid-handle(bttQueryWindow.QueryFrameHandle) then
  do:
    
    /* For some reason deleting query buffers also removes the query from the */
    /* query browse handle. Due to this we have to set it again.              */
    
    bttQueryWindow.QueryBrowseHandle:query = bttQueryWindow.QueryHandle.

    run qg_QueryWindowQueryOpenFieldQuery(bttQueryWindow.WindowHandle).

    run qg_QueryWindowRefreshBrowseColumns(bttQueryWindow.WindowHandle).
    run qg_SetBrowseColumns(bttQueryWindow.QueryBrowseHandle, cColumns).
    
  end. /* if valid-handle(bttQueryWindow.QueryFrameHandle) */
  
  if valid-handle(bttQueryWindow.RecordFrameHandle) then
  do:
    
    run qg_QueryWindowRecordOpenQuery(bttQueryWindow.WindowHandle).
    run qg_QueryWindowRecordRefresh(bttQueryWindow.WindowHandle).
    
  end. /* if valid-handle(bttQueryWindow.RecordFrameHandle) */
  
  finally:
    
    if valid-handle(bttQueryWindow.QueryFrameHandle) then
      bttQueryWindow.QueryBrowseHandle:hidden = lHidden.
    
  end finally.
  
end. /* if lOk */

end procedure. /* qg_QueryWindowObjectIdOverlay */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowObjSelectionBrowseClick hQueryWindow 
PROCEDURE qg_QueryWindowObjSelectionBrowseClick :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hCurrentWindow as handle    no-undo.

define variable hBrowse        as handle    no-undo.
define variable hBuffer        as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow:parent
  no-error.

if not available bttQueryWindow then
  leave.

assign
  hCurrentWindow = current-window
  current-window = bttQueryWindow.WindowHandle
  hBrowse        = qg_hGetWidgetByName(phWindow, 'brObjField':U)
  .

if not valid-handle(hBrowse) then
  leave.

hBuffer = hBrowse:query:get-buffer-handle(1).

if    valid-handle(hBuffer)
  and hBuffer:available then
do:
  
  assign
    bttQueryWindow.ObjSourceBufferName = hBuffer::BufferName
    bttQueryWindow.ObjSourceFieldName  = hBuffer::FieldName
    bttQueryWindow.ObjSourceFieldIndex = hBuffer::FieldIndex
    .
  
  run qg_QueryWindowObjUpdateObjFieldText(bttQueryWindow.WindowHandle).
  
  run qg_QueryWindowObjUpdateQuery(bttQueryWindow.WindowHandle).
  
  run qg_QueryWindowUpdateAll('':U).
  
end. /* if    valid-handle(hBuffer) */

apply 'window-close':U to phWindow.

finally:
  
  if valid-handle(hCurrentWindow) then
    current-window = hCurrentWindow.
  
end finally.

end procedure. /* qg_QueryWindowObjSelectionBrowseClick */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowObjSelectionBrowseRowDisplay hQueryWindow 
PROCEDURE qg_QueryWindowObjSelectionBrowseRowDisplay :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBrowse  as handle    no-undo.
define variable hBuffer  as handle    no-undo.

define variable i        as integer   no-undo.
define variable cColList as character no-undo.
define variable hColumn  as handle    no-undo.
define variable iColor   as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow:parent
  no-error.

if not available bttQueryWindow then
  leave.

hBrowse = qg_hGetWidgetByName(phWindow, 'brObjField':U).

if not valid-handle(hBrowse) then
  leave.

assign
  cColList = qg_cParamListReadValue(hBrowse:private-data,
                                    'ColList':U,
                                    ',':U)
  hBuffer  = handle(qg_cParamListReadValue(hBrowse:private-data,
                                           'Buffer':U,
                                           ',':U))
  .

iColor = (if    not valid-handle(hBuffer)
             or not hBuffer:available then
            {&K_COLOR_LIGHT_GREY}
          /*
          else if hBuffer::IsVirtual then
            {&K_VIRTUAL_DB_FIELD_FGCOLOR}
          */
          else if hBuffer::ContainsObj then
            ?
          else if hBuffer::IsObjectId then
            {&K_COLOR_DARK_GREY}
          else
            {&K_COLOR_LIGHT_GREY}).

do i = 1 to num-entries(cColList, '|':U):
  
  assign
    hColumn         = handle(entry(i, cColList, '|':U))
    hColumn:fgcolor = iColor
    .
  
end. /* do i = 1 to num-entries(cColList, '|':U) */

end procedure. /* qg_QueryWindowObjSelectionBrowseRowDisplay */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowObjSelectionWindowClose hQueryWindow 
PROCEDURE qg_QueryWindowObjSelectionWindowClose :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hParentWindow as handle    no-undo.
define variable hButton       as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

assign
  hParentWindow = phWindow:parent
  hButton       = qg_hGetWidgetByName(hParentWindow,
                                      'btnSelectObjField':U)
  .

run qg_DeleteWidgetTree(phWindow, yes).

if valid-handle(hButton) then
  hButton:sensitive = yes.

apply 'entry':U to hParentWindow.

end procedure. /* qg_QueryWindowObjSelectionWindowClose */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowObjSelectObjField hQueryWindow 
PROCEDURE qg_QueryWindowObjSelectObjField :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hTemp      as handle    no-undo.
define variable hButton    as handle    no-undo.

define variable hWindow    as handle    no-undo.
define variable hFrame     as handle    no-undo.
define variable hBrowse    as handle    no-undo.

define variable hQuery     as handle    no-undo.
define variable hBuffer    as handle    no-undo.

define variable cQueryText as character no-undo.

define variable i          as integer   no-undo.
define variable cColList   as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow         for temp-table ttQueryWindow.

define buffer bttQueryWindowObjField for temp-table ttQueryWindowObjField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hButton = qg_hGetWidgetByName(bttQueryWindow.RecordFrameHandle,
                              'btnSelectObjField':U).

if not valid-handle(hButton) then
  leave.

create window hWindow
  assign
    hidden          = yes
    width           = 64
    max-width       = 1024
    height          = 15
    max-height      = 1024
    scroll-bars     = no
    status-area     = no
    three-d         = yes
    message-area    = no
    control-box     = no
    small-title     = yes
    show-in-taskbar = no
    top-only        = yes
    sensitive       = yes
    resize          = no
    parent          = bttQueryWindow.WindowHandle
    title           = substitute('&1Select object id field':U, gcTitlePrefix)
  triggers:
    
    on leave
      persistent run qg_QueryWindowObjSelectionWindowClose in target-procedure
                       (hWindow).
    
    on window-close
      persistent run qg_QueryWindowObjSelectionWindowClose in target-procedure
                       (hWindow).
    
  end triggers
  .

create frame hFrame
  assign
    name           = 'fObjField':U
    box            = no
    three-d        = yes
    width          = hWindow:width
    virtual-width  = hWindow:width
    height         = hWindow:height
    virtual-height = hWindow:height
    sensitive      = yes
    parent         = hWindow
    .

create browse hBrowse
  assign
    name                   = 'brObjField':U
    frame                  = hFrame
    width                  = hFrame:width - 2
    height                 = hFrame:height - 0.5
    row                    = 1.25
    col                    = 2
    read-only              = yes
    row-markers            = no
    allow-column-searching = no
  triggers:
    
    on mouse-select-click
      persistent run qg_QueryWindowObjSelectionBrowseClick in target-procedure
                       (hWindow).
    
    on row-display
      persistent run qg_QueryWindowObjSelectionBrowseRowDisplay in target-procedure
                       (hWindow).
      
    
  end triggers
  .

run qg_InitBrowse(hBrowse).

run qg_DropDownWindow(hWindow, hButton, {&K_DIRECTION_RIGHT}).

create query hQuery.

create buffer hBuffer for table 'ttQueryWindowObjField':U.

hQuery:set-buffers(hBuffer).

run qg_QueryWindowObjUpdateFieldList(bttQueryWindow.WindowHandle).

assign
  cQueryText =            'for each ttQueryWindowObjField':U
               + '~n':U + '  where ttQueryWindowObjField.WindowHandle = &1':U
               + '~n':U + '  use-index priority':U
  cQueryText = substitute(cQuerytext, quoter(bttQueryWindow.WindowHandle))
  .

assign
  hButton:sensitive = no
  hWindow:hidden    = no
  hFrame:hidden     = no
  .

hBrowse:query = hQuery.

assign
  hTemp       = hBrowse:add-like-column('ttQueryWindowObjField.BufferName':U)
  hTemp:width = 25
  cColList    = string(hTemp) 
  hTemp       = hBrowse:add-like-column('ttQueryWindowObjField.DisplayName':U)
  hTemp:width = 32
  cColList    = substitute('&1|&2':U, cColList, string(hTemp))
  hTemp       = hBrowse:add-like-column('ttQueryWindowObjField.TargetTableName':U)
  hTemp:width = 25
  cColList    = substitute('&1|&2':U, cColList, string(hTemp))
  .

assign
  hBrowse:labels          = no
  hBrowse:fit-last-column = yes
  hBrowse:private-data    = qg_cParamListWriteCharacter(hBrowse:private-data,
                                                        'ColList':U,
                                                        cColList,
                                                        ',':U)
  hBrowse:private-data    = qg_cParamListWriteCharacter(hBrowse:private-data,
                                                        'Buffer':U,
                                                        string(hBuffer),
                                                        ',':U)
  .

qg_lQueryOpen(hQuery, cQueryText, hWindow).

find bttQueryWindowObjField
  where bttQueryWindowObjField.WindowHandle = bttQueryWindow.WindowHandle
    and bttQueryWindowObjField.BufferName   = bttQueryWindow.ObjSourceBufferName
    and bttQueryWindowObjField.FieldName    = bttQueryWindow.ObjSourceFieldName
    and bttQueryWindowObjField.FieldIndex   = bttQueryWindow.ObjSourceFieldIndex
  no-error.

if available bttQueryWindowObjField then
  hQuery:reposition-to-rowid(rowid(bttQueryWindowObjField)).

apply 'value-changed':U to hBrowse.
apply 'entry':U to hBrowse.

end procedure. /* qg_QueryWindowObjSelectObjField */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowObjUpdateObjFieldText hQueryWindow 
PROCEDURE qg_QueryWindowObjUpdateObjFieldText :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cObjFieldLabel as character no-undo.

define variable hObjFieldText  as handle    no-undo.
define variable hRefreshButton as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

assign
  hRefreshButton             = qg_hGetWidgetByName(bttQueryWindow.RecordFrameHandle,
                                                   'btnRefresh':U)
  hObjFieldText              = qg_hGetWidgetByName(bttQueryWindow.RecordFrameHandle,
                                                   'cObjField':U)
  cObjFieldLabel             = qg_cFormattedFieldName(?,
                                                      bttQueryWindow.ObjSourceBufferName,
                                                      bttQueryWindow.ObjSourceFieldName,
                                                      bttQueryWindow.ObjSourceFieldIndex)
  hObjFieldText:screen-value = cObjFieldLabel
  hObjFieldText:width        = max(10, font-table:get-text-width-chars(cObjFieldLabel))
  hRefreshButton:col         = hObjFieldText:col + hObjFieldText:width + 5
  no-error.

end procedure. /* qg_QueryWindowObjUpdateObjFieldText */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowObjUpdateQuery hQueryWindow 
PROCEDURE qg_QueryWindowObjUpdateQuery :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer            as handle    no-undo.
define variable hField             as handle    no-undo.
define variable cDatabaseName      as character no-undo.
define variable cTableName         as character no-undo.
define variable lObjectId          as logical   no-undo.
define variable cFieldValue        as character no-undo.
define variable cTableRef          as character no-undo.
define variable cTables            as character no-undo.

define variable hObFieldText       as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow         for temp-table ttQueryWindow.
define buffer bttQueryWindowObjField for temp-table ttQueryWindowObjField.

define buffer b2ttQueryWindow        for temp-table ttQueryWindow.
define buffer bttDatabase            for temp-table ttDatabase.
define buffer bttTable               for temp-table ttTable.
define buffer bttField               for temp-table ttField.

define buffer bttQueryLink           for temp-table ttQueryLink.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

find b2ttQueryWindow
  where b2ttQueryWindow.QuerySeq = bttQueryWindow.ObjSourceQuerySeq
  no-error.

if   not available b2ttQueryWindow
  or not valid-handle(b2ttQueryWindow.QueryHandle) then
  leave.

hBuffer = b2ttQueryWindow.QueryHandle:get-buffer-handle(bttQueryWindow.ObjSourceBufferName) no-error.

if valid-handle(hBuffer) then
  cDatabaseName = qg_cDatabaseNameForTableOrBuffer( hBuffer ).

else
do:
  
  run qg_QueryWindowObjUpdateFieldList(bttQueryWindow.WindowHandle).
  
  find first bttQueryWindowObjField
    where bttQueryWindowObjField.WindowHandle = bttQueryWindow.WindowHandle
    use-index Priority
    no-error.
  
  if not available bttQueryWindowObjField then
    leave.
  
  hBuffer = b2ttQueryWindow.QueryHandle:get-buffer-handle(bttQueryWindowObjField.BufferName) no-error.
  
  if not valid-handle(hBuffer) then
    
    leave.
  
  assign
    cDatabaseName                      = bttQueryWindowObjField.DatabaseName
    bttQueryWindow.ObjSourceBufferName = bttQueryWindowObjField.BufferName
    bttQueryWindow.ObjSourceFieldName  = bttQueryWindowObjField.FieldName
    bttQueryWindow.ObjSourceFieldIndex = bttQueryWindowObjField.FieldIndex
    bttQueryWindow.ObjTargetTableId    = '':U
    bttQueryWindow.ObjTargetTableName  = '':U
    .
    
  if valid-handle(bttQueryWindow.RecordFrameHandle) then
    
    run qg_QueryWindowObjUpdateObjFieldText(bttQueryWindow.WindowHandle).

end. /* else: if valid-handle(hBuffer) */

find bttDatabase
  where bttDatabase.DatabaseName = cDatabaseName
  no-error.

if not available bttDatabase then
  find bttDatabase
    where bttDatabase.DatabaseName = hBuffer:dbname
    no-error.

if not available bttDatabase then
  leave.

if hBuffer:available then
do:
  
  hField = hBuffer:buffer-field( bttQueryWindow.ObjSourceFieldName ) no-error.
  
  if valid-handle( hField ) then
    
    cFieldValue = hField:buffer-value( bttQueryWindow.ObjSourceFieldIndex ) no-error.
  
  else
    
    if qg_lIsPhysicalDatabase( hBuffer:dbname ) then
    do:
      
      find bttField
        where bttField.DatabaseName = cDatabaseName
          and bttField.TableName    = hBuffer:table
          and bttField.FieldName    = bttQueryWindow.ObjSourceFieldName
        no-error.
      
      if    available bttField
        and bttField.IsVirtual then
        
        cFieldValue = qg_clVirtualFieldValueAsLongchar( bttField.FieldType,
                                                        bttField.DataType,
                                                        bttField.FieldName,
                                                        qg_cObjectIdForBuffer( hBuffer ),
                                                        ? ).
      
    end. /* if qg_lIsPhysicalDatabase( cDatabaseName ) */
    
end. /* if hBuffer:available */

assign
  lObjectId =     length(cFieldValue)            <= 50
              and num-entries(cFieldValue, ':':U) = 3
  cTableRef = (if lObjectId then
                 entry(1, cFieldValue, ':':U)
               else if bttQueryWindow.ObjSourceFieldName matches '*_Obj':U then
                 substring(bttQueryWindow.ObjSourceFieldName,
                           1,
                           length(bttQueryWindow.ObjSourceFieldName) - 4)
               else
                 '':U)
  .

if    (     lObjectId
        and cTableRef <> bttQueryWindow.ObjTargetTableId )
   or (     not lObjectId
        and cTableRef <> bttQueryWindow.ObjTargetTableName )
   or not valid-handle(bttQueryWindow.QueryHandle) then
do:
  
  run qg_GetObjectIdTable(bttDatabase.DatabaseName,
                          (if lObjectId then
                             cFieldValue
                           else
                             bttQueryWindow.ObjSourceFieldName),
                          output cDatabaseName,
                          output cTableName).
  
  find bttTable
    where bttTable.DatabaseName = cDatabaseName
      and bttTable.TableName    = cTableName
    no-error.
  
  if not available bttTable then
    assign
      bttQuerywindow.ObjTargetTableId   = '':U
      bttQuerywindow.ObjTargetTableName = '':U
      bttQueryWindow.QueryText          = '':U
      cTables                           = '':U
      .
    
  else
    assign
      bttQuerywindow.ObjTargetTableId   = bttTable.InternalIdentifier
      bttQuerywindow.ObjTargetTableName = bttTable.TableName
      bttQueryWindow.QueryText          = substitute('for each &1~n  where &1.&1_Obj = &2':U,
                                                     bttTable.TableName,
                                                     substitute('$~{&1:&2~}':U,
                                                               string(bttQueryWindow.ObjSourceQuerySeq),
                                                               qg_cFormattedFieldName(?,
                                                                                      bttQueryWindow.ObjSourceBufferName,
                                                                                      bttQueryWindow.ObjSourceFieldName,
                                                                                      bttQueryWindow.ObjSourceFieldIndex)))
      cTables = substitute('&1.&2':U,
                           bttTable.DatabaseName,
                           bttTable.TableName)
      .
  
  validate bttQuerywindow.
  
  if valid-handle(bttQueryWindow.QueryFrameHandle) then
    bttQueryWindow.QueryTextEditorHandle:screen-value = bttQueryWindow.QueryText.
  
  run qg_QueryWindowUpdateQuery(bttQueryWindow.WindowHandle, cTables).
  
  run qg_ParseQueryLinks(bttQueryWindow.QueryText,
                         bttQueryWindow.QuerySeq,
                         temp-table ttQueryLink:handle).
  
  if not can-find(first ttQueryLink
                    where ttQueryLink.TargetSeq = bttQueryWindow.QuerySeq
                      and ttQueryLink.SourceSeq = b2ttQueryWindow.QuerySeq) then
  do:
    
    create bttQueryLink.
    
    assign
      bttQueryLink.TargetSeq = bttQueryWindow.QuerySeq
      bttQueryLink.SourceSeq = b2ttQueryWindow.QuerySeq
      .
    
    validate bttQueryLink.
    
  end. /* if not can-find(first ttQueryLink */
  
  run qg_QueryWindowListRefresh.
  
end. /* if cTableRef <> bttQueryWindow.ObjTargetTableId */

end procedure. /* qg_QueryWindowObjUpdateQuery */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowObjUpdateFieldList hQueryWindow 
PROCEDURE qg_QueryWindowObjUpdateFieldList :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable iQueryBufferCounter as integer   no-undo.
define variable iFieldCounter       as integer   no-undo.
define variable iFieldIndexCounter  as integer   no-undo.
define variable hBuffer             as handle    no-undo.
define variable hField              as handle    no-undo.

define variable cDatabaseName       as character no-undo.
define variable clFieldValue        as longchar  no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow         for temp-table ttQueryWindow.

define buffer b2ttQueryWindow        for temp-table ttQueryWindow.
define buffer bttQueryWindowObjField for temp-table ttQueryWindowObjField.
define buffer bttField               for temp-table ttField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

for each bttQueryWindowObjField
  where bttQueryWindowObjField.WindowHandle = bttQueryWindow.WindowHandle
  on error undo, throw:
  
  delete bttQueryWindowObjField.
  
end. /* for each bttQueryWindowObjField */

find b2ttQueryWindow
  where b2ttQueryWindow.QuerySeq = bttQueryWindow.ObjSourceQuerySeq
  no-error.

if   not available b2ttQueryWindow
  or not valid-handle(b2ttQueryWindow.QueryHandle) then
  leave.

do iQueryBufferCounter = 1 to b2ttQueryWindow.QueryHandle:num-buffers:
  
  assign
    hBuffer       = b2ttQueryWindow.QueryHandle:get-buffer-handle(iQueryBufferCounter)
    cDatabaseName = qg_cDatabaseNameForTableOrBuffer( hBuffer ).
    .
  
  do iFieldCounter = 1 to hBuffer:num-fields:
    
    hField = hBuffer:buffer-field( iFieldCounter ).
    
    if not hField:data-type = 'CHARACTER':U then
      
      next.
    
    do iFieldIndexCounter = integer(hField:extent > 0) to hField:extent:
      
      run qg_AddFieldToQueryWindowObjFieldTempTable( buffer bttQueryWindow,
                                                     cDatabaseName,
                                                     hBuffer:name,
                                                     hBuffer:table,
                                                     hField:name,
                                                     iFieldIndexCounter,
                                                     ( if hBuffer:available then
                                                         hField:string-value( iFieldIndexCounter )
                                                       else
                                                         ? ) ).
      
      validate bttQueryWindowObjField.
      
    end. /* do iFieldIndexCounter = integer(hField:extent > 0) to hField:extent */
    
  end. /* do iFieldCounter = 1 to hBuffer:num-fields */
  
  if qg_lIsPhysicalDatabase( hBuffer:dbname ) then
    
    for each bttField
      where bttField.DatabaseName = cDatabaseName
        and bttField.TableName    = hBuffer:table
        and bttField.IsVirtual    = yes
      on error undo, throw:
      
      clFieldValue = qg_clVirtualFieldValueAsLongchar( bttField.FieldType,
                                                       bttField.DataType,
                                                       bttField.FieldName,
                                                       qg_cObjectIdForBuffer( hBuffer ),
                                                       ? ).
      
      run qg_AddFieldToQueryWindowObjFieldTempTable( buffer bttQueryWindow,
                                                     bttField.DatabaseName,
                                                     hBuffer:name,
                                                     bttField.TableName,
                                                     bttField.FieldName,
                                                     0,
                                                     string( clFieldValue ) ).
      
    end. /* for each bttField */  
  
end. /* do iQueryBufferCounter = 1 to b2ttQueryWindow.QueryHandle:num-buffers */

end procedure. /* qg_QueryWindowObjUpdateFieldList */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowOpenObjectFieldValues hQueryWindow 
PROCEDURE qg_QueryWindowOpenObjectFieldValues :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow   as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cParamList as character no-undo.
define variable iQuerySeq  as integer   no-undo init ?.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow  for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

cParamList = qg_cParamListWriteInteger(cParamList,
                                       'ObjSourceQuerySeq':U,
                                       bttQueryWindow.QuerySeq,
                                       {&K_PARAM_SPLITTER}).

run qg_ExecQuery({&K_QUERY_WINDOW_MODE_RECORD},
                 {&K_RECORD_SIZE_MODE_DEFAULT},
                 ?,
                 ?,
                 no,  /* Init mode */
                 cParamList,
                 input-output iQuerySeq).

end procedure. /* qg_QueryWindowOpenObjectFieldValues */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowOpenRelatedQuery hQueryWindow 
PROCEDURE qg_QueryWindowOpenRelatedQuery :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer       as handle    no-undo.
define variable cDatabaseName as character no-undo.

define variable iFilterId     as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow       for temp-table ttQueryWindow.

define buffer bttTableRelationView for temp-table ttTableRelationView.
define buffer bttFilterMatch       for temp-table ttFilterMatch.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if not valid-handle(bttQueryWindow.QueryHandle) then
  leave.

define query brTableRelation
  for bttTableRelationView,bttFilterMatch
  scrolling.

define browse brTableRelation
  query brTableRelation no-lock
    display
      bttTableRelationView.RelatedTableName
      bttTableRelationView.RelationType width 8
      bttTableRelationView.ReferenceFields
      with no-assign fit-last-column size 96 by 16.

define variable cFilter as character no-undo
  format 'x(1024)':U
  view-as fill-in
  tooltip "Filter for related tables that match given name pattern (comma separated)"
  size 89 by 1.

define button btnClearFilter
  label '':T
  tooltip "Clear filter"
  size 7 by 1.

define variable cRelationFields as character no-undo
  format 'x(1024)':U
  view-as fill-in
  size 96 by 1.

define button btnOk
  label 'Ok':T2
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T
  size 20 by 1.14
  auto-end-key.

/* Define frame. */

define frame fTableRelation
  cFilter at row 1.5 col 3 no-label
  btnClearFilter at row 1.5 col 92
  brTableRelation at row 2.5 col 3
  cRelationFields at row 19 col 3 no-label no-tab-stop
  btnOk at row 21 col 31
  btnCancel at row 21 col 51
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    title gcTitlePrefix + 'Select table relation':U
    side-labels no-underline three-d 
    size 101 by 22.94
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fTableRelation
  apply 'end-error' to self.

on off-home of brTableRelation in frame fTableRelation
do:
  apply 'entry':U to cFilter in frame fTableRelation.
  return no-apply.
end. /* on cursor-down of cProcedureFilter in frame fTableRelation */
  
on cursor-down of cFilter in frame fTableRelation
do:
  apply 'entry':U to brTableRelation in frame fTableRelation.
  browse brTableRelation:select-focused-row().
  return no-apply.
end. /* on cursor-down of cFilter in frame fTableRelation */

on cursor-down of btnClearFilter in frame fTableRelation
do:
  apply 'entry':U to brTableRelation in frame fTableRelation.
  browse brTableRelation:select-focused-row().
  return no-apply.
end. /* on cursor-down of btnClearFilter in frame fTableRelation */

on value-changed of cFilter in frame fTableRelation
do:
  
  define variable cFilterEntry as character no-undo.
  define variable cPrepFilter  as character no-undo.
  
  define variable i            as integer       no-undo.
  
  cFilter = input frame fTableRelation cFilter.
  
  do i = 1 to num-entries(cFilter):
    
    assign
      cFilterEntry = entry(i, cFilter).
      cPrepFilter  = substitute('&1,&2':U,
                                cPrepFilter,
                                qg_cFilterEntryMatchcode(cFilterEntry))
      .
    
  end. /* do i = 1 to num-entries(cFilter) */
  
  cPrepFilter = (if cPrepFilter = '':U then
                   '*':U
                 else
                   trim(cPrepFilter, ',':U)).
  
  for each bttTableRelationView
    where bttTableRelationView.DatabaseName       = cDatabaseName
      and bttTableRelationView.ReferenceTableName = hBuffer:table,
  first bttFilterMatch
    where bttFilterMatch.FilterId    = iFilterId
      and bttFilterMatch.RecordRowId = rowid(bttTableRelationView)
    on error undo, throw:
    
    bttFilterMatch.RecordMatches = can-do(cPrepFilter, bttTableRelationView.RelatedTableName).
    
  end. /* for each bttTableRelationView */
  
  open query brTableRelation
    for each bttTableRelationView
      where bttTableRelationView.DatabaseName       = cDatabaseName
        and bttTableRelationView.ReferenceTableName = hBuffer:table,
    first bttFilterMatch
      where bttFilterMatch.FilterId      = iFilterId
        and bttFilterMatch.RecordRowId   = rowid(bttTableRelationView)
        and bttFilterMatch.RecordMatches = yes
      by bttTableRelationView.RelatedTableName
      by bttTableRelationView.RelationId
      .
  
  apply 'value-changed':U to browse brTableRelation.
  
end. /* on value-changed of cFilter in frame fTableRelation */

on choose of btnClearFilter in frame fTableRelation
do:
  
  display unless-hidden
    '':U @ cFilter
    with frame fTableRelation.
  
  apply 'value-changed':U to cFilter in frame fTableRelation.
  
end. /* on choose of btnClearFilter in frame fTableRelation */

on default-action of browse brTableRelation
  apply 'go':U to frame fTableRelation.

on value-changed of browse brTableRelation
do:
  
  cRelationFields = (if available bttTableRelationView then
                       bttTableRelationView.FieldDetails
                     else
                       '':U).
  
  display unless-hidden
    cRelationFields
    with frame fTableRelation.
  
end. /* on value-changed of browse brRelation */

run qg_InitBrowse(browse brTableRelation:handle).

assign
  hBuffer       = bttQueryWindow.QueryHandle:get-buffer-handle(1)
  cDatabaseName = qg_cDatabaseNameForTableOrBuffer( hBuffer )
  iFilterId     = qg_iFilterSeq()
  .

for each bttTableRelationView
  where bttTableRelationView.DatabaseName       = cDatabaseName
    and bttTableRelationView.ReferenceTableName = hBuffer:table
  on error undo, throw:
  
  create bttFilterMatch.
  
  assign
    bttFilterMatch.FilterId      = iFilterId
    bttFilterMatch.RecordRowId   = rowid(bttTableRelationView)
    bttFilterMatch.RecordMatches = yes
    .
  
  validate bttFilterMatch.
  
end. /* for each bttTableRelationView */

open query brTableRelation
  for each bttTableRelationView
    where bttTableRelationView.DatabaseName       = cDatabaseName
      and bttTableRelationView.ReferenceTableName = hBuffer:table,
  first bttFilterMatch
    where bttFilterMatch.FilterId      = iFilterId
      and bttFilterMatch.RecordRowId   = rowid(bttTableRelationView)
      and bttFilterMatch.RecordMatches = yes
    by bttTableRelationView.RelatedTableName
    by bttTableRelationView.RelationId
    .

cRelationFields:read-only in frame fTableRelation = yes.

update unless-hidden
  cFilter
  btnClearFilter
  brTableRelation
  cRelationFields
  btnOk
  btnCancel
  with frame fTableRelation
    in window bttQueryWindow.WindowHandle. 

if available bttTableRelationView then
  run qg_OpenRelatedQueryWindow(bttQueryWindow.WindowHandle,
                                bttTableRelationView.RelationId).

finally:
  
  if iFilterId > 0 then
  do:
    
    for each bttFilterMatch
      where bttFilterMatch.FilterId = iFilterId
      on error undo, throw:
      
      delete bttFilterMatch.
      
    end. /* for each bttFilterMatch */
    
  end. /* if iFilterId > 0 */
  
end finally.

end procedure. /* qg_QueryWindowOpenRelatedQuery */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowOpenRecordWindow hQueryWindow 
PROCEDURE qg_QueryWindowOpenRecordWindow :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow   as handle    no-undo.
define input parameter piLinkMode as integer   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i                  as integer   no-undo.
define variable hBuffer            as handle    no-undo.
define variable hField             as handle    no-undo.
define variable cDatabaseName      as character no-undo.
define variable cTargetTableName   as character no-undo.
define variable cFieldList         as character no-undo.
define variable cValueList         as character no-undo.
define variable cExternalReference as character no-undo.
define variable cQueryText         as character no-undo.
define variable iQuerySeq          as integer   no-undo init ?.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.
define buffer bttIndex       for temp-table ttIndex.
define buffer bttIndexField  for temp-table ttIndexField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if not valid-handle(bttQueryWindow.QueryHandle) then
  leave.

case piLinkMode:
  
  when {&K_QUERY_WINDOW_LINK_MODE_FIX_ROWID} then
  do:
    
    do i = 1 to bttQueryWindow.QueryHandle:num-buffers:
      
      hBuffer = bttQueryWindow.QueryHandle:get-buffer-handle(i).
      
      if not hBuffer:available then
        return.
      
      assign
        cDatabaseName    = qg_cDatabaseNameForTableOrBuffer( hBuffer )
        cTargetTableName = hBuffer:table
        cQueryText       = substitute('&1&2~nfor each &3~n  where rowid(&3) = to-rowid(&4)':U,
                                      cQueryText,
                                      (if i > 1 then
                                         ',':U
                                       else
                                         '':U),
                                      hBuffer:table,
                                      quoter(hBuffer:rowid))
        .
      
    end. /* do i = 1 to bttQueryWindow.QueryHandle:num-buffers() */
    
  end. /* when {&K_QUERY_WINDOW_LINK_MODE_FIX_ROWID} */ 
  
  when {&K_QUERY_WINDOW_LINK_MODE_FIX_INDEX} then
  do:
    
    do i = 1 to bttQueryWindow.QueryHandle:num-buffers:
      
      hBuffer = bttQueryWindow.QueryHandle:get-buffer-handle(i).
      
      if not hBuffer:available then
        return.
      
      assign
        cDatabaseName    = qg_cDatabaseNameForTableOrBuffer( hBuffer )
        cTargetTableName = hBuffer:table
        cQueryText       = substitute('&1&2~n&3each &4':U,
                                      cQueryText,
                                      (if i > 1 then
                                         ',':U
                                       else
                                         '':U),
                                      (if i = 1 then
                                         'for ':U
                                       else
                                         '':U),
                                      hBuffer:table)
        .
      
      find first bttIndex
        where bttIndex.DatabaseName = cDatabaseName
          and bttIndex.TableName    = hBuffer:table
          and bttIndex.IsPrimary    = true
          and bttIndex.IsUnique     = true
        no-error.
      
      if not available bttIndex then
        find first bttIndex
          where bttIndex.DatabaseName = cDatabaseName
            and bttIndex.TableName    = hBuffer:table
            and bttIndex.IsUnique     = true
          no-error.
      
      if available bttIndex then
      do:
        
        assign
          cFieldList = '':U
          cValueList = '':U
          .
        
        for each bttIndexField
          where bttIndexField.DatabaseName = bttIndex.DatabaseName
            and bttIndexField.TableName    = bttIndex.TableName
            and bttIndexField.IndexName    = bttIndex.IndexName
          by bttIndexField.IndexSequence
          on error undo, throw:
          
          assign
            cFieldList = substitute('&1,&2':U,
                                    cFieldList,
                                    bttIndexField.FieldName)
            hField     = hBuffer:buffer-field(bttIndexField.FieldName)
            cValueList = substitute('&1&2&3':U,
                                    cValueList,
                                    {&K_PARAM_SPLITTER},
                                    (if hField:data-type = 'CHARACTER':U then
                                       quoter(hField:buffer-value)
                                     else
                                       hField:buffer-value))
            .
          
        end. /* for each bttIndexField */
        
        assign
          cFieldList = trim(cFieldList, ',':U)
          cValueList = trim(cValueList, {&K_PARAM_SPLITTER})
          cQueryText = substitute( '&1~n&2~n':U,
                                   cQueryText,
                                   qg_cCreateWhereClause( /* pcDatabaseName   */ bttIndex.DatabaseName,
                                                          /* pcTableNames     */ bttIndex.TableName,
                                                          /* pcBufferNames    */ bttIndex.TableName,
                                                          /* pcFieldList      */ cFieldList,
                                                          /* pcFieldLabelList */ ?,
                                                          /* plStartWithWhere */ yes,
                                                          /* piValueMode      */ {&K_VALUE_MODE_PARAMETER},
                                                          /* pcValueList      */ cValueList,
                                                          /* piAccessMode     */ {&K_ACCESS_MODE_PHYSICAL},
                                                          /* plAddTags        */ no,
                                                          /* piIndentBlanks   */ 2 ) )
          .
        
        
      end. /* if available bttIndex */
      
    end. /* do i = 1 to bttQueryWindow.QueryHandle:num-buffers() */
    
  end. /* when {&K_QUERY_WINDOW_LINK_MODE_FIX_INDEX} */
  
  when {&K_QUERY_WINDOW_LINK_MODE_LINKED} then
  do:
    
    do i = 1 to bttQueryWindow.QueryHandle:num-buffers:
      
      assign
        hBuffer          = bttQueryWindow.QueryHandle:get-buffer-handle(i)
        cDatabaseName    = qg_cDatabaseNameForTableOrBuffer( hBuffer )
        cTargetTableName = hBuffer:table
        cQueryText       = substitute('&1&2~nfor each &3~n  where rowid(&3) = &4':U,
                                      cQueryText,
                                      (if i > 1 then
                                         ',':U
                                       else
                                         '':U),
                                      hBuffer:table,
                                      substitute('$~{&1:rowid(&2)~}':U,
                                                 bttQueryWindow.QuerySeq,
                                                 hBuffer:name))
        .
      
    end. /* do i = 1 to bttQueryWindow.QueryHandle:num-buffers() */
    
  end. /* when {&K_QUERY_WINDOW_LINK_MODE_LINKED} */
  
end case. /* piLinkMode */

run qg_ExecQuery({&K_QUERY_WINDOW_MODE_RECORD},
                 {&K_RECORD_SIZE_MODE_DEFAULT},
                 substitute('&1.&2':U, cDatabaseName, cTargetTableName),
                 trim(cQueryText),
                 no,  /* Init mode */
                 '':U,
                 input-output iQuerySeq).

end procedure. /* qg_QueryWindowOpenRecordWindow */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowQueryBrowseCopy hQueryWindow 
PROCEDURE qg_QueryWindowQueryBrowseCopy :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable iKeyState as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

run GetKeyState( {&K_WIN_CONST_VK_SHIFT}, output iKeyState ).

if    iKeyState < 0
   or not valid-handle( bttQueryWindow.QueryBrowseSelectedColumn ) then

  run qg_QueryWindowCopyRecordValues( phWindow ).

else
  
  run qg_QueryWindowQueryBrowseCopySelectedColumnValue( phWindow, yes ).

end procedure. /* qg_QueryWindowQueryBrowseCopy */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowQueryBrowseCopySelectedColumnValue hQueryWindow 
PROCEDURE qg_QueryWindowQueryBrowseCopySelectedColumnValue :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.
define input parameter plRaw    as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if not valid-handle( bttQueryWindow.QueryBrowseSelectedColumn ) then
  leave.

clipboard:value = ( if plRaw then
                      bttQueryWindow.QueryBrowseSelectedColumn:input-value
                    else
                      bttQueryWindow.QueryBrowseSelectedColumn:screen-value ).

end procedure. /* qg_QueryWindowQueryBrowseCopySelectedColumnValue */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowQueryBrowseDefaultAction hQueryWindow 
PROCEDURE qg_QueryWindowQueryBrowseDefaultAction :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Default action trigger of query browse.                                    */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer   as handle    no-undo.
define variable iKeyState as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if not valid-handle(bttQueryWindow.QueryHandle) then
  leave.

hBuffer = bttQueryWindow.QueryHandle:get-buffer-handle(1).

if not valid-handle(hBuffer) then
  leave.

run qg_QueryWindowEdit(bttQueryWindow.WindowHandle,
                       {&K_EDITACTION_EDIT}).

end procedure. /* qg_QueryWindowQueryBrowseDefaultAction */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowQueryBrowsePopupMenuDrop hQueryWindow 
PROCEDURE qg_QueryWindowQueryBrowsePopupMenuDrop :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Menu drop event trigger for context menu of the query text editor widget.  */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBrowse               as handle    no-undo.
define variable hTemp                 as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow            for temp-table ttQueryWindow.

define buffer bttBufferComparisonField  for temp-table ttBufferComparisonField.
define buffer b2ttBufferComparisonField for temp-table ttBufferComparisonField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hBrowse = bttQueryWindow.QueryBrowseHandle.

find first bttBufferComparisonField
  where bttBufferComparisonField.BufferNo = 1
  no-error.

find first b2ttBufferComparisonField
  where b2ttBufferComparisonField.BufferNo = 2
  no-error.

assign
  hTemp           = qg_hGetWidgetByName( hBrowse:popup-menu, 'mi_CopySelectedColumnValueRaw':U )
  hTemp:label     = ( if valid-handle( bttQueryWindow.QueryBrowseSelectedColumn ) then
                        substitute( 'Copy raw value (&1)':T,
                                    ( if valid-handle( bttQueryWindow.QueryBrowseSelectedColumn:buffer-field ) then
                                        qg_cFormattedFieldName( '':U,
                                                                bttQueryWindow.QueryBrowseSelectedColumn:buffer-field:buffer-handle:name,
                                                                bttQueryWindow.QueryBrowseSelectedColumn:buffer-field:name,
                                                                bttQueryWindow.QueryBrowseSelectedColumn:index )
                                      else
                                        bttQueryWindow.QueryBrowseSelectedColumn:name ) )
                      else
                        'Copy raw value':T )
  hTemp:sensitive = valid-handle( bttQueryWindow.QueryBrowseSelectedColumn )
  hTemp           = qg_hGetWidgetByName( hBrowse:popup-menu, 'mi_CopySelectedColumnValueFormatted':U )
  hTemp:label     = ( if valid-handle( bttQueryWindow.QueryBrowseSelectedColumn ) then
                        substitute( 'Copy formatted value (&1)':T,
                                    ( if valid-handle( bttQueryWindow.QueryBrowseSelectedColumn:buffer-field ) then
                                        qg_cFormattedFieldName( '':U,
                                                                bttQueryWindow.QueryBrowseSelectedColumn:buffer-field:buffer-handle:name,
                                                                bttQueryWindow.QueryBrowseSelectedColumn:buffer-field:name,
                                                                bttQueryWindow.QueryBrowseSelectedColumn:index )
                                      else
                                        bttQueryWindow.QueryBrowseSelectedColumn:name ) )
                      else
                        'Copy formatted value':T )
  hTemp:sensitive = valid-handle( bttQueryWindow.QueryBrowseSelectedColumn )
  hTemp           = qg_hGetWidgetByName(hBrowse:popup-menu, 'mi_SelectForComparison1':U)
  hTemp:label     = substitute('Select for comparison 1&1':T,
                               (if available bttBufferComparisonField then
                                  substitute(' (&1.&2)':U,
                                             bttBufferComparisonField.DatabaseName,
                                             bttBufferComparisonField.BufferName)
                                else
                                  '':U))
  hTemp           = qg_hGetWidgetByName(hBrowse:popup-menu, 'mi_SelectForComparison2':U)
  hTemp:label     = substitute('Select for comparison 2&1':T,
                               (if available b2ttBufferComparisonField then
                                  substitute(' (&1.&2)':U,
                                             b2ttBufferComparisonField.DatabaseName,
                                             b2ttBufferComparisonField.BufferName)
                                else
                                  '':U))
  hTemp           = qg_hGetWidgetByName(hBrowse:popup-menu, 'mi_CompareSelectedRecords':U)
  hTemp:sensitive =     available bttBufferComparisonField
                    and available b2ttBufferComparisonField
  hTemp           = qg_hGetWidgetByName( hBrowse:popup-menu, 'mi_CalculateSum':U )
  hTemp:label     = ( if valid-handle( bttQueryWindow.QueryBrowseSelectedColumn ) then
                        substitute( 'Calculate Sum for &1':T,
                                    ( if valid-handle( bttQueryWindow.QueryBrowseSelectedColumn:buffer-field ) then
                                        qg_cFormattedFieldName( '':U,
                                                                bttQueryWindow.QueryBrowseSelectedColumn:buffer-field:buffer-handle:name,
                                                                bttQueryWindow.QueryBrowseSelectedColumn:buffer-field:name,
                                                                bttQueryWindow.QueryBrowseSelectedColumn:index )
                                      else
                                        bttQueryWindow.QueryBrowseSelectedColumn:name ) )
                      else
                        'Calculate Sum':T )
  hTemp:sensitive = ( if    valid-handle( bttQueryWindow.QueryBrowseSelectedColumn ) then
                        lookup( bttQueryWindow.QueryBrowseSelectedColumn:data-type, 'DECIMAL,INTEGER,INT64':U ) > 0
                      else
                        no )
  .

end procedure. /* qg_QueryWindowQueryBrowsePopupMenuDrop */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowQueryBrowseRowDisplay hQueryWindow 
PROCEDURE qg_QueryWindowQueryBrowseRowDisplay :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cDatabaseName        as character no-undo.
define variable cTableId             as character no-undo.
define variable cOverlayDatabaseName as character no-undo.
define variable cOverlayTableName    as character no-undo.
define variable cObjectIdFieldName   as character no-undo.

define variable lIncludeTablename    as logical   no-undo.
define variable cKeyValues           as character no-undo.
define variable cOverlayValue        as character no-undo.
define variable iFieldColor          as integer   no-undo.

define variable cObjectIdValue       as character no-undo.
define variable cFieldValue          as character no-undo.
define variable lResolved            as logical   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow                  for temp-table ttQueryWindow.

define buffer bttQueryWindowField             for temp-table ttQueryWindowField.
define buffer bttVirtualFieldColumn           for temp-table ttVirtualFieldColumn.
define buffer bttFieldOverlay                 for temp-table ttFieldOverlay.
define buffer bttQueryWindowQueryBrowseColumn for temp-table ttQueryWindowQueryBrowseColumn.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

/* Applay column formats. */

if    bttQueryWindow.DisplayRawValues
   or bttQueryWindow.ApplyColumnFormats then
  
  for each bttQueryWindowQueryBrowseColumn
    where bttQueryWindowQueryBrowseColumn.WindowHandle = bttQueryWindow.WindowHandle:
    
    if not valid-handle( bttQueryWindowQueryBrowseColumn.ColumnHandle ) then
      next.
    
    bttQueryWindowQueryBrowseColumn.ColumnHandle:format = ( if bttQueryWindow.DisplayRawValues then
                                                              bttQueryWindowQueryBrowseColumn.RawFormat
                                                            else
                                                              bttQueryWindowQueryBrowseColumn.OriginalFormat ).
    
  end. /* for each bttQueryWindowQueryBrowseColumn: */

/* Display virtual fields. */

for each bttVirtualFieldColumn
  where bttVirtualFieldColumn.OwnerHandle = bttQueryWindow.QueryHandle
  break by bttVirtualFieldColumn.BufferName
  on error undo, throw:
  
  if not valid-handle( bttVirtualFieldColumn.ColumnHandle ) then
    
    next.
  
  if first-of( bttVirtualFieldColumn.BufferName ) then
    
    cObjectIdValue = qg_cObjectIdForBuffer( bttVirtualFieldColumn.BufferHandle ).
  
  assign
    bttVirtualFieldColumn.ColumnHandle:screen-value = string( qg_clVirtualFieldValueAsLongchar( bttVirtualFieldColumn.FieldType,
                                                                                                bttVirtualFieldColumn.DataType,
                                                                                                bttVirtualFieldColumn.FieldName,
                                                                                                cObjectIdValue,
                                                                                                ( if bttQueryWindow.DisplayRawValues then
                                                                                                    ?
                                                                                                  else
                                                                                                    bttVirtualFieldColumn.FieldFormat ) ) )
    bttVirtualFieldColumn.ColumnHandle:fgcolor      = {&K_VIRTUAL_DB_FIELD_FGCOLOR}
    .
  
end. /* for each bttVirtualFieldColumn */

/* Display overlay fields. */

for each bttFieldOverlay
  where bttFieldOverlay.OwnerHandle = bttQueryWindow.QueryHandle
  on error undo, throw:
  
  if    not valid-handle( bttFieldOverlay.ColumnHandle )
     or not valid-handle( bttFieldOverlay.OverlayColumnHandle ) then
    
    next.
  
  run qg_GetOverlayColumnValue( buffer bttFieldOverlay,
                                bttQueryWindow.DeepResolveObjectIds,
                                bttQueryWindow.DisplayRawValues,
                                output cFieldValue,
                                output lResolved ).
  
  assign
    iFieldColor = ( if lResolved then
                      {&K_OBJECTID_OVERLAY_FGCOLOR}
                    else
                      {&K_COLOR_RED} )
    bttFieldOverlay.OverlayColumnHandle:screen-value = cFieldValue
    bttFieldOverlay.OverlayColumnHandle:fgcolor      = iFieldColor
    .
  
end. /* for each bttFieldOverlay */

end procedure. /* qg_QueryWindowQueryBrowseRowDisplay */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowQueryBrowseStartSearch hQueryWindow 
PROCEDURE qg_QueryWindowQueryBrowseStartSearch :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable iKeyState as integer   no-undo.

define variable hColumn       as handle    no-undo.
define variable hBuffer       as handle    no-undo.
define variable hBufferField  as handle    no-undo.

define variable cDatabaseName as character no-undo.
define variable cBufferName   as character no-undo.
define variable cFieldName    as character no-undo.
define variable iFieldIndex   as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow        for temp-table ttQueryWindow.

define buffer bttQueryWindowField   for temp-table ttQueryWindowField.
define buffer bttVirtualFieldColumn for temp-table ttVirtualFieldColumn.
define buffer bttFieldOverlay       for temp-table ttFieldOverlay.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

case last-event:function:
  
  when 'START-SEARCH':U then
  do:
    
    hColumn = bttQueryWindow.QueryBrowseHandle:current-column.
    
    find bttFieldOverlay
      where bttFieldOverlay.OwnerHandle         = bttQueryWindow.QueryHandle
        and bttFieldOverlay.OverlayColumnHandle = hColumn
      no-error.
    
    if available bttFieldOverlay then
      
      hColumn = bttFieldOverlay.ColumnHandle.
    
    if valid-handle( hColumn:buffer-field ) then
      
      assign
        hBufferField  = hColumn:buffer-field
        hBuffer       = hBufferField:buffer-handle
        cBufferName   = hBuffer:name
        cFieldName    = hBufferField:name
        iFieldIndex   = hColumn:index
        .
    
    else
    do:
      
      find bttVirtualFieldColumn
        where bttVirtualFieldColumn.OwnerHandle  = bttQueryWindow.QueryHandle
          and bttVirtualFieldColumn.ColumnHandle = hColumn
        no-error.
      
      if available bttVirtualFieldColumn then
        
        assign
          cBufferName = bttVirtualFieldColumn.BufferName
          cFieldName  = bttVirtualFieldColumn.FieldName
          iFieldIndex = bttVirtualFieldColumn.FieldIndex
          .
      
    end. /* else: if valid-handle( hColumn:buffer-field ) */
    
    apply 'end-search':U to bttQueryWindow.QueryBrowseHandle.
    
    find bttQueryWindowField
      where bttQueryWindowField.WindowHandle = bttQueryWindow.WindowHandle
        and bttQueryWindowField.BufferName   = cBufferName
        and bttQueryWindowField.FieldName    = cFieldName
        and bttQueryWindowField.FieldIndex   = iFieldIndex
        and bttQueryWindowField.IsOverlay    = no
      no-lock no-error.
    
    if available bttQueryWindowField then
    do:
      
      run GetKeyState({&K_WIN_CONST_VK_SHIFT}, output iKeyState).
      
      if iKeyState >= 0 then
        
        bttQueryWindow.QueryFieldBrowseHandle:deselect-rows().
      
      bttQueryWindow.QueryFieldBrowseHandle:query:reposition-to-rowid(rowid(bttQueryWindowField)) no-error.
      
      if not error-status:error then
      do:
        
        bttQueryWindow.QueryFieldBrowseHandle:select-focused-row().
        apply 'entry':U to bttQueryWindow.QueryFieldBrowseHandle.
      end.
      
    end. /* if available bttField */

  end. /* when 'START-SEARCH':U */

  otherwise
  do:
    
    run GetKeyState({&K_WIN_CONST_VK_ALT}, output iKeyState).
    
    if iKeyState < 0 then
    do:
      
      run GetKeyState({&K_WIN_CONST_VK_SHIFT}, output iKeyState).
      
      run qg_QueryWindowAddSortOption(bttQueryWindow.WindowHandle,
                                      (iKeyState < 0)).
      
    end. /* else: if iKeyState >= 0 */
    
    else
    do:
      
      run GetKeyState({&K_WIN_CONST_VK_CTRL}, output iKeyState).
      
      if iKeyState < 0 then
        run qg_QueryWindowMoveColumn(bttQueryWindow.WindowHandle, yes).
      
      else
        run qg_QueryWindowQueryTextEditorAddCondition(bttQueryWindow.WindowHandle).
      
    end. /* else: if iKeyState < 0 */
    
  end. /* otherwise */
  
end case. /* last-event:function */

end procedure. /* qg_QueryWindowQueryBrowseStartSearch */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowQueryBrowseSelectColumn hQueryWindow 
PROCEDURE qg_QueryWindowQueryBrowseSelectColumn :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hColumn         as handle    no-undo.
define variable hSelectedColumn as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hColumn = bttQueryWindow.QueryBrowseHandle:first-column.

do while valid-handle(hColumn):
  
  if    last-event:x > hColumn:x
    and last-event:x < ( hColumn:x + hColumn:width-pixels ) then
    
    hSelectedColumn = hColumn.
  
  hColumn = hColumn:next-column.
  
end. /* do while valid-handle(hColumn) */

if hSelectedColumn <> bttQueryWindow.QueryBrowseSelectedColumn then
do:
  
  bttQueryWindow.QueryBrowseSelectedColumn = hSelectedColumn.
  validate bttQueryWindow.
  
end. /* if hSelectedColumn <> bttQueryWindow.QueryBrowseSelectedColumn */

end procedure. /* qg_QueryWindowQueryBrowseSelectColumn */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowQueryFieldBrowseRowDisplay hQueryWindow 
PROCEDURE qg_QueryWindowQueryFieldBrowseRowDisplay :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hFieldBrowseBufferHandle as handle    no-undo.
define variable iColor                   as integer   no-undo init ?.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

define buffer bttField       for temp-table ttField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hFieldBrowseBufferHandle = bttQueryWindow.QueryFieldBrowseBufferHandle.

if    valid-handle( hFieldBrowseBufferHandle )
  and hFieldBrowseBufferHandle:available then
do:
  
  case integer( hFieldBrowseBufferHandle::FieldType ):
    
    when {&K_FIELD_TYPE_VIRTUAL_DB_FIELD} then
      
      iColor = {&K_VIRTUAL_DB_FIELD_FGCOLOR}.
    
  end case. /* hFieldBrowseBufferHandle::FieldType */
  
  if iColor <> ? then
    
    assign
      bttQueryWindow.QueryFieldBrowseColHandles[1]:fgcolor = iColor
      bttQueryWindow.QueryFieldBrowseColHandles[2]:fgcolor = iColor
      .
  
end. /* if    valid-handle( hFieldBrowseBufferHandle ) */ 

assign
  bttQueryWindow.QueryFieldBrowseColHandles[3]:fgcolor = {&K_COLOR_LIGHT_GREY}
  bttQueryWindow.QueryFieldBrowseColHandles[4]:fgcolor = {&K_COLOR_LIGHT_GREY}
  .

end procedure. /* qg_QueryWindowQueryFieldBrowseRowDisplay */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowQueryOpenFieldQuery hQueryWindow 
PROCEDURE qg_QueryWindowQueryOpenFieldQuery :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cQueryText as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

assign
  cQueryText =            'for each ttQueryWindowField':U
               + '~n':U + '  where ttQueryWindowField.WindowHandle = &1':U
               + '~n':U + '    and ttQueryWindowField.IsOverlay    = no':U
               + '~n':U + '  use-index BufferName':U
  cQueryText = substitute(cQueryText, quoter(bttQueryWindow.WindowHandle))
  .

qg_lQueryOpen(bttQueryWindow.QueryFieldBrowseHandle:query,
              cQueryText,
              bttQueryWindow.WindowHandle).

end procedure. /* qg_QueryWindowQueryOpenFieldQuery */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowRefreshBrowseColumns hQueryWindow 
PROCEDURE qg_QueryWindowRefreshBrowseColumns :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i                 as integer   no-undo.
define variable iBufferCounter    as integer   no-undo.
define variable j                 as integer   no-undo.
define variable hBuffer           as handle    no-undo.

define variable hColumn           as handle    no-undo.
define variable hField            as handle    no-undo.
define variable cDatabaseName     as character no-undo.
define variable cBufferName       as character no-undo.
define variable cFieldName        as character no-undo.
define variable iFieldIndex       as integer   no-undo.
define variable cColExceptList    as character no-undo.

define variable lInitialize       as logical   no-undo.
define variable cColumns          as character no-undo.
define variable cColumn           as character no-undo.
define variable cOverlayFieldName as character no-undo.
define variable hOverlayColumn    as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow                  for temp-table ttQueryWindow.

define buffer bttField                        for temp-table ttField.
define buffer bttFieldOverlay                 for temp-table ttFieldOverlay.
define buffer bttQueryWindowQueryBrowseColumn for temp-table ttQueryWindowQueryBrowseColumn.
define buffer bttVirtualFieldColumn           for temp-table ttVirtualFieldColumn.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

/*----------------------------------------------------------------------------*/
/* Clear browse columns.                                                      */
/*----------------------------------------------------------------------------*/

lInitialize = (bttQueryWindow.QueryBrowseHandle:num-columns = 0).

run qg_RemoveInvalidVirtualFieldColumns( buffer bttQueryWindow ).

run qg_RemoveInvalidOverlayColumns( buffer bttQueryWindow ).

/* Remove all browse columns. */

for each bttQueryWindowQueryBrowseColumn
  where bttQueryWindowQueryBrowseColumn.WindowHandle = bttQueryWindow.WindowHandle:
  
  delete bttQueryWindowQueryBrowseColumn.
  
end. /* for each bttQueryWindowQueryBrowseColumn */

do i = bttQueryWindow.QueryBrowseHandle:num-columns to 1 by -1:
  
  hColumn = bttQueryWindow.QueryBrowseHandle:get-browse-column(i).
  delete object hColumn.
  
end. /* do i = bttQueryWindow.QueryBrowseHandle:num-columns to 1 by -1 */

/*----------------------------------------------------------------------------*/
/* Create browse columns.                                                     */
/*----------------------------------------------------------------------------*/

/* Create buffer field columns. */

do iBufferCounter = 1 to bttQueryWindow.QueryHandle:num-buffers:
  
  assign
    hBuffer       = bttQueryWindow.QueryHandle:get-buffer-handle( iBufferCounter )
    cDatabaseName = qg_cDatabaseNameForTableOrBuffer( hBuffer )
    .
  
  /* If a field has format = ? then the entire progress session will crash on */
  /* "add-columns-from". To avoid this we add all fields with format = ? to   */
  /* the the blacklist.                                                       */
  
  for each bttField
    where bttField.DatabaseName = cDatabaseName
      and bttField.TableName    = hBuffer:table
      and bttField.FieldFormat  = ?
    on error undo, throw:
    
    cColExceptList = substitute( '&1,&2':U,
                                 cColExceptList,
                                 bttField.FieldName ).
    
  end. /* for each bttField */
  
  cColExceptList = trim( cColExceptList, ',':U ).
  
  bttQueryWindow.QueryBrowseHandle:add-columns-from( hBuffer, cColExceptList ).
  
  run qg_CreateVirtualFieldColumnsForBuffer( buffer bttQueryWindow,
                                             iBufferCounter ).
  
end. /* do i = 1 to bttQueryWindow.QueryHandle:num-buffers */

if lInitialize then
  
  cColumns = qg_cBrowseColumnList( bttQueryWindow.QueryBrowseHandle,
                                   yes,
                                   no,
                                   yes ).

/* Create field overlay columns. */

do i = 1 to bttQueryWindow.QueryBrowseHandle:num-columns:
  
  assign
    hColumn = bttQueryWindow.QueryBrowseHandle:get-browse-column(i)
    hField  = hColumn:buffer-field
    .
  
  if valid-handle( hField ) then
    
    assign
      cBufferName  = hField:buffer-name
      cFieldName   = hField:name
      iFieldIndex  = hColumn:index
      .
  
  else
  do:
    
    find bttVirtualFieldColumn
      where bttVirtualFieldColumn.OwnerHandle  = bttQueryWindow.QueryHandle
        and bttVirtualFieldColumn.ColumnHandle = hColumn
      no-error.
    
    if not available bttVirtualFieldColumn then
      
      next.
    
    assign
      cBufferName = bttVirtualFieldColumn.BufferName
      cFieldName  = bttVirtualFieldColumn.FieldName
      iFieldIndex = bttVirtualFieldColumn.FieldIndex
      .
    
  end. /* if valid-handle( hField ) */
  
  find bttFieldOverlay
    where bttFieldOverlay.OwnerHandle = bttQueryWindow.QueryHandle
      and bttFieldOverlay.BufferName  = cBufferName
      and bttFieldOverlay.FieldName   = cFieldName
      and bttFieldOverlay.FieldIndex  = iFieldIndex
    no-error.
  
  if not available bttFieldOverlay then
    next.
  
  assign
    hOverlayColumn                      = bttQueryWindow.QueryBrowseHandle:add-calc-column
                                            ('CHARACTER':U,
                                             {&K_OBJECTID_OVERLAY_FORMAT},
                                             '':U,
                                             substitute({&K_OBJECTID_OVERLAY_LABEL_PATTERN},
                                                        hColumn:label))
    hOverlayColumn:name                 = substitute({&K_OBJECTID_OVERLAY_NAME_PATTERN},
                                                     qg_cFormattedFieldName(?,
                                                                            bttFieldOverlay.BufferName,
                                                                            bttFieldOverlay.FieldName,
                                                                            bttFieldOverlay.FieldIndex))
    hOverlayColumn:width                = {&K_OBJECTID_OVERLAY_DEFAULT_WIDTH}
    hOverlayColumn:label-fgcolor        = {&K_OBJECTID_OVERLAY_FGCOLOR}
    bttFieldOverlay.ColumnHandle        = hColumn
    bttFieldOverlay.FieldHandle         = hField
    bttFieldOverlay.OverlayColumnHandle = hOverlayColumn
    .
  
  validate bttFieldOverlay.
  
  if lInitialize then
    assign
      cFieldName        = qg_cFormattedFieldName(?,
                                                 bttFieldOverlay.BufferName,
                                                 bttFieldOverlay.FieldName,
                                                 bttFieldOverlay.FieldIndex)
      cOverlayFieldName = substitute({&K_OBJECTID_OVERLAY_NAME_PATTERN},
                                              cFieldName)
      cColumns          = qg_cReplaceColumn(cColumns,
                                            cFieldName,
                                            cOverlayFieldName).
  
end. /* do i = bttQueryWindow.QueryBrowseHandle:num-columns to 1 by -1: */

do i = 1 to bttQueryWindow.QueryBrowseHandle:num-columns:
  
  hColumn = bttQueryWindow.QueryBrowseHandle:get-browse-column(i).
  
  create bttQueryWindowQueryBrowseColumn.
  
  assign
    bttQueryWindowQueryBrowseColumn.WindowHandle   = bttQueryWindow.WindowHandle
    bttQueryWindowQueryBrowseColumn.ColumnHandle   = hColumn
    bttQueryWindowQueryBrowseColumn.OriginalFormat = hColumn:format
    bttQueryWindowQueryBrowseColumn.RawFormat      = ( if valid-handle( hColumn:buffer-field ) then
                                                         qg_cMaximumDataTypeFormat( hColumn:buffer-field:data-type,
                                                                                    hColumn:buffer-field:decimals )
                                                       else
                                                         qg_cMaximumDataTypeFormat( hColumn:data-type,
                                                                                    10 ) )
    .
  
  validate bttQueryWindowQueryBrowseColumn.
  
end. /* do i = 1 to bttQueryWindow.QueryBrowseHandle:num-columns */

if    lInitialize
  and cColumns > '':U
  and can-find( first ttFieldOverlay
                  where ttFieldOverlay.OwnerHandle = bttQueryWindow.QueryHandle ) then
  
  run qg_SetBrowseColumns( bttQueryWindow.QueryBrowseHandle, cColumns ).

end procedure. /* qg_QueryWindowRefreshBrowseColumns */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowQueryTextEditorAddCondition hQueryWindow 
PROCEDURE qg_QueryWindowQueryTextEditorAddCondition :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Add selected field(s) as condition(s) to the current query text.           */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hEditor               as handle    no-undo.
define variable cQueryText            as character no-undo.
define variable iOffset               as integer   no-undo.
define variable iLineEndOffset        as integer   no-undo.

define variable hBuffer               as handle    no-undo.
define variable hFieldSelectionBrowse as handle    no-undo.
define variable hFieldSelectionBuffer as handle    no-undo.
define variable hField                as handle    no-undo.
define variable i                     as integer   no-undo.
define variable iFieldCount           as integer   no-undo.
define variable cDatabaseName         as character no-undo.
define variable lPhysicalDatabase     as logical   no-undo.
define variable cFieldList            as character no-undo.
define variable lWhere                as logical   no-undo.
define variable cInsertText           as character no-undo.

define variable iLine                 as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow    for temp-table ttQueryWindow.
define buffer bttQueryAST       for temp-table ttQueryAST.
define buffer bttQueryCondition for temp-table ttQueryCondition.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if bttQueryWindow.ObjSourceQuerySeq > 0 then
  leave.

/*----------------------------------------------------------------------------*/
/* Get selection info                                                         */
/*----------------------------------------------------------------------------*/

assign
  hEditor    = bttQueryWindow.QueryTextEditorHandle
  cQueryText = hEditor:input-value
  iOffset    = (if hEditor:selection-end = ? then
                  hEditor:cursor-offset
                else
                  hEditor:selection-end - 1)
  .

/*----------------------------------------------------------------------------*/
/* Analyze selection and query text                                           */
/*----------------------------------------------------------------------------*/

iLineEndOffset = index(cQueryText, '~n':U, iOffset).

if iLineEndOffset > 0 then
  iOffset = iLineEndOffset.

run qg_ParseQueryConditions(cQueryText).

/* Don't insert after certain progress keywords. */

find first bttQueryAST
  where bttQueryAST.TokenType   = {&K_QP_TOKEN_TYPE_KEYWORD}
    and bttQueryAST.TokenStart <= iOffset
    and lookup(bttQueryAST.TokenText, 'BREAK,BY,NO-LOCK,SHARE-LOCK,EXCLUSIVE-LOCK,USE-INDEX':U) > 0
  no-error.

if available bttQueryAST then
do:
  
  iLineEndOffset = r-index(cQueryText, '~n':U, bttQueryAST.TokenStart).
  
  if iLineEndOffset > 0 then
    iOffset = iLineEndOffset.
  
end. /* if available bttQueryAST */

/* Switch where to end if necessary. */

find last bttQueryCondition
  where bttQueryCondition.RightStartPos <= iOffset
    and bttQueryCondition.RightEndPos   >= iOffset
  no-error.

if available bttQueryCondition then
  iOffset = bttQueryCondition.RightEndPos.

lWhere = not can-find(first ttQueryAST
                        where ttQueryAST.TokenType  = {&K_QP_TOKEN_TYPE_KEYWORD}
                          and ttQueryAST.TokenText  = 'WHERE':U
                          and ttQueryAST.TokenStart < iOffset).

if lWhere then
do:
  
  find first bttQueryAST
    where bttQueryAST.TokenType   = {&K_QP_TOKEN_TYPE_KEYWORD}
      and bttQueryAST.TokenText   = 'WHERE':U
      and bttQueryAST.TokenStart >= iOffset
    no-error.
  
  if available bttQueryAST then
    overlay(cQueryText,
            bttQueryAST.TokenStart,
            bttQueryAST.TokenEnd - bttQueryAST.TokenStart) = 'and':U.
  
end. /* if lWhere */

/*----------------------------------------------------------------------------*/
/* Generate line text.                                                        */
/*----------------------------------------------------------------------------*/

assign
  hBuffer               = bttQueryWindow.QueryBrowseHandle:query:get-buffer-handle(1)
  hFieldSelectionBrowse = bttQueryWindow.QueryFieldBrowseHandle
  hFieldSelectionBuffer = bttQueryWindow.QueryFieldBrowseBufferHandle
  cDatabaseName         = qg_cDatabaseNameForTableOrBuffer( hBuffer ).
  lPhysicalDatabase     = qg_lIsPhysicalDatabase( cDatabaseName )
  .

do i = 1 to hFieldSelectionBrowse:num-selected-rows:
  
  hFieldSelectionBrowse:fetch-selected-row (i).
  
  if    lPhysicalDatabase
    and hFieldSelectionBuffer::IsVirtual then
    
    message
      substitute( 'Virtual field &1 can not be used in the query!':T,
                  quoter( hFieldSelectionBuffer::FieldName ) ) skip
      view-as alert-box
      warning
      buttons ok
      in window bttQueryWindow.WindowHandle.
  
  else
    
    assign
      cFieldList  = substitute('&1,&2':U,
                               cFieldList,
                               qg_cFormattedFieldName(?,
                                                      ?,
                                                      hFieldSelectionBuffer::FieldName,
                                                      hFieldSelectionBuffer::FieldIndex))
      iFieldCount = iFieldCount + 1
      .
  
end. /* do i = 1 to bttQueryWindow.QueryFieldBrowseHandle:num-selected-rows */

if iFieldCount = 0 then
  
  return.

assign
  cFieldList  = trim(cFieldList, ',':U)
  cInsertText = qg_cCreateWhereClause( /* pcDatabaseName   */ cDatabaseName,
                                       /* pcTableNames     */ hBuffer:table,
                                       /* pcBufferNames    */ hBuffer:name,
                                       /* pcFieldList      */ cFieldList,
                                       /* pcFieldLabelList */ ?,
                                       /* plStartWithWhere */ lWhere,
                                       /* piValueMode      */ {&K_VALUE_MODE_DEFAULT_VALUE},
                                       /* pcValueList      */ ?,
                                       /* piAccessMode     */ {&K_ACCESS_MODE_PHYSICAL},
                                       /* plAddTags        */ no,
                                       /* piIndentBlanks   */ 0 )
  .

/*----------------------------------------------------------------------------*/
/* Insert text lines.                                                         */
/*----------------------------------------------------------------------------*/

run qg_InsertTextLines(cInsertText,
                       iOffset,
                       input-output cQueryText,
                             output iLine).

/*----------------------------------------------------------------------------*/
/* Update editor                                                              */
/*----------------------------------------------------------------------------*/

cQueryText = qg_cBeautifyQueryText(cQueryText).

run qg_UpdateEditor(hEditor,
                    cQueryText,
                    iLine,
                    iLine + max(0, num-entries(cInsertText, '~n':U) - 1)).

apply 'entry':U to hEditor.

end procedure. /* qg_QueryWindowQueryTextEditorAddCondition */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowQueryTextEditorDeleteLines hQueryWindow 
PROCEDURE qg_QueryWindowQueryTextEditorDeleteLines :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Delete selected lines.                                                     */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hEditor                   as handle    no-undo.
define variable cQueryText                as character no-undo.

define variable iSelectionStart           as integer   no-undo.
define variable iSelectionEnd             as integer   no-undo.

define variable iLine                     as integer   no-undo.

define variable iSelectionStartLine       as integer   no-undo.
define variable iSelectionEndLine         as integer   no-undo.
define variable iSelectionStartLineOffset as integer   no-undo.
define variable iSelectionEndLineOffset   as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow    for temp-table ttQueryWindow.
define buffer bttQueryAST       for temp-table ttQueryAST.
define buffer bttQueryCondition for temp-table ttQueryCondition.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if bttQueryWindow.ObjSourceQuerySeq > 0 then
  leave.

assign
  hEditor     = bttQueryWindow.QueryTextEditorHandle
  cQueryText  = hEditor:input-value
  .

/*----------------------------------------------------------------------------*/
/* Fix connective operator                                                    */
/*----------------------------------------------------------------------------*/

run qg_ParseQueryConditions(cQueryText).

run qg_GetEditorSelectionInfo(hEditor,
                              output iSelectionStart,
                              output iSelectionEnd,
                              output iSelectionStartLine,
                              output iSelectionEndLine).

if    iSelectionStartLine > 0
  and iSelectionEndLine   > 0 then
do:
  
  assign
    iSelectionStartLineOffset = hEditor:convert-to-offset(iSelectionStartLine,
                                                          1)
    iSelectionEndLineOffset   = hEditor:convert-to-offset(iSelectionEndLine,
                                                          length(entry(iSelectionEndLine,
                                                                       cQueryText,
                                                                       '~n':U)))
    .

  find first bttQueryAST
    where bttQueryAST.TokenType = {&K_QP_TOKEN_TYPE_KEYWORD}
      and bttQueryAST.TokenText = 'WHERE':U
    no-error.
  
  if    available bttQueryAST
    and bttQueryAST.TokenStart >= iSelectionStartLineOffset
    and bttQueryAST.TokenEnd   <= iSelectionEndLineOffset then
  do:
    
    find first bttQueryAST
      where bttQueryAST.TokenType  = {&K_QP_TOKEN_TYPE_OPERATOR}
        and bttQueryAST.TokenStart > iSelectionEndLineOffset
        and lookup(bttQueryAST.TokenText, 'AND,OR':U) > 0
        and not can-find(first bttQueryCondition
                           where bttQueryCondition.RightStartPos <= bttQueryAST.TokenStart
                             and bttQueryCondition.RightEndPos   >= bttQueryAST.TokenEnd)

      no-error.
    
    if available bttQueryAST then
      cQueryText = substitute('&1where&2':U,
                              substring(cQueryText,
                                        1,
                                        bttQueryAST.TokenStart - 1),
                              substring(cQueryText,
                                        bttQueryAST.TokenEnd)).
      
  end. /* if    bttQueryAST.TokenStart >= iSelectionStartLineOffset */

  /*--------------------------------------------------------------------------*/
  /* Delete line                                                              */
  /*--------------------------------------------------------------------------*/
  
  run qg_DeleteTextLines(iSelectionStart,
                         iSelectionEnd,
                         input-output cQueryText,
                               output iLine).
  
  /*--------------------------------------------------------------------------*/
  /* Beautify query text                                                      */
  /*--------------------------------------------------------------------------*/
  
  cQueryText = qg_cBeautifyQueryText(cQueryText).
  
  assign
    hEditor:screen-value = cQueryText
    hEditor:cursor-line  = iLine
    .
  
end. /* if    iSelectionStartLine > 0 */

end procedure. /* qg_QueryWindowQueryTextEditorDeleteLines */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowQueryTextEditorDuplicateLines hQueryWindow 
PROCEDURE qg_QueryWindowQueryTextEditorDuplicateLines :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Add selected field(s) as condition(s) to the current query text.           */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* phBuffer                       = Buffer that contains the field.           */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.
define input parameter plDown   as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hEditor                   as handle    no-undo.
define variable cQueryText                as character no-undo.

define variable iLine                     as integer   no-undo.
define variable iSelectionStart           as integer   no-undo.
define variable iSelectionEnd             as integer   no-undo.
define variable iSelectionStartLine       as integer   no-undo.
define variable iSelectionEndLine         as integer   no-undo.
define variable iSelectedLines            as integer   no-undo.

define variable iSelectionStartLineOffset as integer   no-undo.
define variable iSelectionEndLineOffset   as integer   no-undo.

define variable i                         as integer   no-undo.
define variable iOffset                   as integer   no-undo init 1.
define variable iLineEndOffset            as integer   no-undo.

define variable iRelativeOffset           as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow    for temp-table ttQueryWindow.
define buffer bttQueryAST       for temp-table ttQueryAST.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if bttQueryWindow.ObjSourceQuerySeq > 0 then
  leave.

/*----------------------------------------------------------------------------*/
/* Get selection info                                                         */
/*----------------------------------------------------------------------------*/

assign
  hEditor    = bttQueryWindow.QueryTextEditorHandle
  cQueryText = hEditor:input-value
  .

run qg_GetEditorSelectionInfo(hEditor,
                              output iSelectionStart,
                              output iSelectionEnd,
                              output iSelectionStartLine,
                              output iSelectionEndLine).

/*----------------------------------------------------------------------------*/
/* Analyze selection and query text                                           */
/*----------------------------------------------------------------------------*/

assign
  iSelectionStartLineOffset = hEditor:convert-to-offset(iSelectionStartLine,
                                                        1)
  iSelectionEndLineOffset   = hEditor:convert-to-offset(iSelectionEndLine,
                                                        length(entry(iSelectionStartLine,
                                                                     cQueryText,
                                                                     '~n':U))) + 1
  .

run qg_ParseQueryConditions(cQueryText).

find first bttQueryAST
  where bttQueryAST.TokenType   = {&K_QP_TOKEN_TYPE_KEYWORD}
    and bttQueryAST.TokenStart >= iSelectionStartLineOffset
    and bttQueryAST.TokenEnd   <= iSelectionEndLineOffset
    and bttQueryAST.TokenText   = 'WHERE':U
  use-index TokenType
  no-error.

if available bttQueryAST then
  iRelativeOffset = bttQueryAST.TokenStart - iSelectionStartLineOffset.

/*----------------------------------------------------------------------------*/
/* Move text lines                                                            */
/*----------------------------------------------------------------------------*/

run qg_DuplicateTextLines(iSelectionStart,
                          iSelectionEnd,
                          plDown,
                          input-output cQueryText,
                                output iLine).

/*----------------------------------------------------------------------------*/
/* Fix duplicted lines                                                        */
/*----------------------------------------------------------------------------*/

if available bttQueryAST then
do:
  
  /* Get line offset. */
  
  assign
    iSelectionStartLineOffset = 0
    iSelectionEndLineOffset   = 0
    .
  
  do i = 1 to num-entries(cQueryText, '~n':U):
    
    iLineEndOffset = iOffset + length(entry(i, cQueryText, '~n':U)).
    
    if i = iLine then
      iSelectionStartLineOffset = iOffset.
    
    if i = iLine + iSelectionEndLine - iSelectionStartLine then
    do:
      
      iSelectionEndLineOffset = iLineEndOffset.
      leave.
      
    end. /* if i = iLine + iSelectedLines - 1 */
    
    iOffset = iLineEndOffset + length('~n':U).
    
  end. /* do i = 1 to num-entries(cQueryText, '~n':U) */
  
  iOffset = (if plDown then
               iSelectionStartLineOffset
             else
               iSelectionEndLineOffset + length('~n':U)).
  
  /* Replace "where" by "and". */
  
  if iOffset > 0 then
    overlay(cQueryText,
            iOffset + iRelativeOffset,
            length(bttQueryAST.TokenText)) = 'and':U.
  
end. /* if available bttQueryAST */

/*----------------------------------------------------------------------------*/
/* Update editor                                                              */
/*----------------------------------------------------------------------------*/

cQueryText = qg_cBeautifyQueryText(cQueryText).

run qg_UpdateEditor(hEditor,
                    cQueryText,
                    iLine,
                    iLine + iSelectionEndLine - iSelectionStartLine).

apply 'entry':U to hEditor.

end procedure. /* qg_QueryWindowQueryTextEditorDuplicateLines */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowQueryTextEditorMoveLines hQueryWindow 
PROCEDURE qg_QueryWindowQueryTextEditorMoveLines :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Add selected field(s) as condition(s) to the current query text.           */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* plDown                         = If yes the lines will be moved down.      */
/*                                  Otherwise the lines will be moved up.     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.
define input parameter plDown   as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hEditor                   as handle    no-undo.
define variable cQueryText                as character no-undo.

define variable iLine                     as integer   no-undo.
define variable iSelectionStart           as integer   no-undo.
define variable iSelectionEnd             as integer   no-undo.
define variable iSelectionStartLine       as integer   no-undo.
define variable iSelectionEndLine         as integer   no-undo.

define variable iSelectionStartLineOffset as integer   no-undo.
define variable iSelectionEndLineOffset   as integer   no-undo.
define variable iNextLineOffset           as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow    for temp-table ttQueryWindow.
define buffer b1ttQueryAST      for temp-table ttQueryAST.
define buffer b2ttQueryAST      for temp-table ttQueryAST.
define buffer bttQueryCondition for temp-table ttQueryCondition.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if bttQueryWindow.ObjSourceQuerySeq > 0 then
  leave.

/*----------------------------------------------------------------------------*/
/* Get selection info                                                         */
/*----------------------------------------------------------------------------*/

assign
  hEditor    = bttQueryWindow.QueryTextEditorHandle
  cQueryText = hEditor:input-value
  .

run qg_GetEditorSelectionInfo(hEditor,
                              output iSelectionStart,
                              output iSelectionEnd,
                              output iSelectionStartLine,
                              output iSelectionEndLine).

/*----------------------------------------------------------------------------*/
/* Analyze selection and query text                                           */
/*----------------------------------------------------------------------------*/

assign
  iSelectionStartLineOffset = hEditor:convert-to-offset(iSelectionStartLine,
                                                        1)
  iSelectionEndLineOffset   = hEditor:convert-to-offset(iSelectionEndLine,
                                                        length(entry(iSelectionStartLine,
                                                                     cQueryText,
                                                                     '~n':U))) + 1
  .

run qg_ParseQueryConditions(cQueryText).

if plDown then
do:
  
  find first b1ttQueryAST
    where b1ttQueryAST.TokenType   = {&K_QP_TOKEN_TYPE_KEYWORD}
      and b1ttQueryAST.TokenStart >= iSelectionStartLineOffset
      and b1ttQueryAST.TokenEnd   <= iSelectionEndLineOffset
      and b1ttQueryAST.TokenText   = 'WHERE':U
    no-error.
  
  if available b1ttQueryAST then
  do:
    
    iNextLineOffset = index(cQueryText,
                            '~n':U,
                            iSelectionEndLineOffset + length('~n':U)).
    
    if iNextLineOffset = 0 then
      iNextLineOffset = length(cQueryText) + 1.
    
    find first b2ttQueryAST
      where b2ttQueryAST.TokenType   = {&K_QP_TOKEN_TYPE_OPERATOR}
        and b2ttQueryAST.TokenStart >= iSelectionEndLineOffset
        and b2ttQueryAST.TokenEnd   <= iNextLineOffset
        and lookup(b2ttQueryAST.TokenText, 'AND,OR':U) > 0
        and not can-find(first bttQueryCondition
                           where bttQueryCondition.RightStartPos <= b2ttQueryAST.TokenStart
                             and bttQueryCondition.RightEndPos   >= b2ttQueryAST.TokenEnd)
      no-error.
    
  end. /* if available b1ttQueryAST */
  
end. /* if plDown */

else
do:
  
  iNextLineOffset = r-index(cQueryText,
                            '~n':U,
                            maximum(1, iSelectionStartLineOffset - length('~n':U) - 1)).
  
  if iNextLineOffset = 0 then
    iNextLineOffset = 1.
    
  find first b1ttQueryAST
    where b1ttQueryAST.TokenType   = {&K_QP_TOKEN_TYPE_KEYWORD}
      and b1ttQueryAST.TokenStart >= iNextLineOffset
      and b1ttQueryAST.TokenEnd   <= iSelectionStartLineOffset
      and b1ttQueryAST.TokenText   = 'WHERE':U
    no-error.
  
  if available b1ttQueryAST then
    find first b2ttQueryAST
      where b2ttQueryAST.TokenType   = {&K_QP_TOKEN_TYPE_OPERATOR}
        and b2ttQueryAST.TokenStart >= iSelectionStartLineOffset
        and b2ttQueryAST.TokenEnd   <= iSelectionEndLineOffset
        and lookup(b2ttQueryAST.TokenText, 'AND,OR':U) > 0
        and not can-find(first bttQueryCondition
                           where bttQueryCondition.RightStartPos <= b2ttQueryAST.TokenStart
                             and bttQueryCondition.RightEndPos   >= b2ttQueryAST.TokenEnd)
      no-error.
    
end. /* else: if plDown */

if    available b1ttQueryAST
  and available b2ttQueryAST then
  assign
    cQueryText =   substring(cQueryText,
                             1,
                             b1ttQueryAST.TokenStart - 1)
                 + lc(b2ttQueryAST.TokenText)
                 + substring(cQueryText,
                             b1ttQueryAST.TokenEnd,
                             b2ttQueryAST.TokenStart - b1ttQueryAST.TokenEnd)
                 + lc(b1ttQueryAST.TokenText)
                 + substring(cQueryText, b2ttQueryAST.TokenEnd)
    iSelectionStart = iSelectionStart - 5 + length(b2ttQueryAST.TokenText)
        when iSelectionStart > b1ttQueryAST.TokenEnd
    iSelectionStart = iSelectionStart - 5 + length(b1ttQueryAST.TokenText)
        when iSelectionStart > b2ttQueryAST.TokenEnd
    iSelectionEnd = iSelectionEnd - 5 + length(b2ttQueryAST.TokenText)
        when iSelectionEnd > b1ttQueryAST.TokenEnd
    iSelectionEnd = iSelectionEnd - 5 + length(b1ttQueryAST.TokenText)
        when iSelectionEnd > b2ttQueryAST.TokenEnd
    .

/*----------------------------------------------------------------------------*/
/* Move text lines                                                            */
/*----------------------------------------------------------------------------*/

run qg_MoveTextLines(iSelectionStart,
                     iSelectionEnd,
                     plDown,
                     input-output cQueryText,
                           output iLine).

/*----------------------------------------------------------------------------*/
/* Update editor                                                              */
/*----------------------------------------------------------------------------*/

cQueryText = qg_cBeautifyQueryText(cQueryText).

run qg_UpdateEditor(hEditor,
                    cQueryText,
                    iLine,
                    iLine + iSelectionEndLine - iSelectionStartLine).

apply 'entry':U to hEditor.

end procedure. /* qg_QueryWindowQueryTextEditorMoveLines */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowQueryTextEditorPopupMenuDrop hQueryWindow 
PROCEDURE qg_QueryWindowQueryTextEditorPopupMenuDrop :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Menu drop event trigger for context menu of the query text editor widget.  */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hInsertExternalFieldReference as handle    no-undo.
define variable hInsertExternalTableReference as handle    no-undo.

define variable hTemp                         as handle    no-undo.

define variable iOffset                       as integer   no-undo.
define variable cQuerytext                    as character no-undo.
define variable cComparator                   as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow    for temp-table ttQueryWindow.

define buffer bttQueryCondition for temp-table ttQueryCondition.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

cQueryText = bttQueryWindow.QueryTextEditorHandle:input-value.

run qg_ParseQueryConditions(cQueryText).

iOffset = bttQueryWindow.QueryTextEditorHandle:cursor-offset.

find first bttQueryCondition
  where bttQueryCondition.StartPos <= iOffset
    and bttQueryCondition.EndPos   >= iOffset
  no-error.

if available bttQueryCondition then
  cComparator = substring(cQuerytext,
                          bttQueryCondition.ComparatorStartPos,
                          bttQueryCondition.ComparatorEndPos - bttQueryCondition.ComparatorStartPos).

if bttQueryWindow.ObjSourceQuerySeq = 0 then
  assign
    hInsertExternalFieldReference           = qg_hGetWidgetByName(bttQueryWindow.QueryTextEditorHandle:popup-menu,
                                                                  'mi_InsertExternalFieldReference':U)
    hInsertExternalFieldReference:sensitive /* code checked by mth */
        = can-find(first ttQueryWindow
                     where ttQueryWindow.QuerySeq <> bttQueryWindow.QuerySeq)
    hInsertExternalTableReference           = qg_hGetWidgetByName(bttQueryWindow.QueryTextEditorHandle:popup-menu,
                                                                  'mi_InsertExternalTableReference':U)
    hInsertExternalTableReference:sensitive /* code checked by mth */
        = hInsertExternalFieldReference:sensitive
    hTemp           = qg_hGetWidgetByName(bttQueryWindow.QueryTextEditorHandle:popup-menu,
                                         'mi_Equal':U)
    hTemp:sensitive =     cComparator  > '':U
                      and cComparator <> '=':U
    hTemp           = qg_hGetWidgetByName(bttQueryWindow.QueryTextEditorHandle:popup-menu,
                                         'mi_NotEqual':U)
    hTemp:sensitive =     cComparator  > '':U
                      and cComparator <> '<>':U
    hTemp           = qg_hGetWidgetByName(bttQueryWindow.QueryTextEditorHandle:popup-menu,
                                         'mi_Greater':U)
    hTemp:sensitive =     cComparator  > '':U
                      and cComparator <> '>':U
    hTemp           = qg_hGetWidgetByName(bttQueryWindow.QueryTextEditorHandle:popup-menu,
                                         'mi_GreaterEqual':U)
    hTemp:sensitive =     cComparator  > '':U
                      and cComparator <> '>=':U
    hTemp           = qg_hGetWidgetByName(bttQueryWindow.QueryTextEditorHandle:popup-menu,
                                         'mi_Lower':U)
    hTemp:sensitive =     cComparator  > '':U
                      and cComparator <> '<':U
    hTemp           = qg_hGetWidgetByName(bttQueryWindow.QueryTextEditorHandle:popup-menu,
                                         'mi_LowerEqual':U)
    hTemp:sensitive =     cComparator  > '':U
                      and cComparator <> '<=':U
    hTemp           = qg_hGetWidgetByName(bttQueryWindow.QueryTextEditorHandle:popup-menu,
                                         'mi_Begins':U)
    hTemp:sensitive =     cComparator  > '':U
                      and cComparator <> 'begins':U
    hTemp           = qg_hGetWidgetByName(bttQueryWindow.QueryTextEditorHandle:popup-menu,
                                         'mi_Matches':U)
    hTemp:sensitive =     cComparator  > '':U
                      and cComparator <> 'matches':U
    hTemp           = qg_hGetWidgetByName(bttQueryWindow.QueryTextEditorHandle:popup-menu,
                                         'mi_Contains':U)
    hTemp:sensitive =     cComparator  > '':U
                      and cComparator <> 'contains':U
    .

end procedure. /* qg_QueryWindowQueryTextEditorPopupMenuDrop */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowQueryToolsMenuDrop hQueryWindow 
PROCEDURE qg_QueryWindowQueryToolsMenuDrop :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Menu drop event trigger for the query window tools menu.                   */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable lBufferAvailable          as logical   no-undo.
define variable hOpenRecordWindowFixRowId as handle    no-undo.
define variable hOpenRecordWindowFixIndex as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

assign
  lBufferAvailable          =     valid-handle(bttQueryWindow.QueryHandle)
                              and bttQueryWindow.QueryHandle:get-buffer-handle(1):available
  hOpenRecordWindowFixRowId = qg_hGetWidgetByName(bttQueryWindow.WindowHandle:menu-bar,
                                                  'mi_OpenRecordWindowFixRowId':U)
  hOpenRecordWindowFixRowId:sensitive /* code checked by mth */
      = lBufferAvailable
  hOpenRecordWindowFixIndex = qg_hGetWidgetByName(bttQueryWindow.WindowHandle:menu-bar,
                                                  'mi_OpenRecordWindowFixIndex':U)
  hOpenRecordWindowFixIndex:sensitive /* code checked by mth */
      = lBufferAvailable
  .

end procedure. /* qg_QueryWindowQueryToolsMenuDrop */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowQueryUpdateTitle hQueryWindow 
PROCEDURE qg_QueryWindowQueryUpdateTitle :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hQuery        as handle    no-undo.
define variable hBuffer       as handle    no-undo.

define variable cDatabaseName as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hQuery = bttQueryWindow.QueryHandle.

if    valid-handle(hQuery)
  and hQuery:num-buffers > 0 then
  hBuffer = hQuery:get-buffer-handle(1).

if not valid-handle(hBuffer) then
    bttQueryWindow.WindowTitle = substitute('&1[&2] Query - unknown':U,
                                            gcTitlePrefix,
                                            bttQueryWindow.QuerySeq).

else
  assign
    cDatabaseName              = qg_cDatabaseNameForTableOrBuffer( hBuffer )
    bttQueryWindow.WindowTitle = substitute('&1[&2] Query - &3.&4':T,
                                            gcTitlePrefix,
                                            bttQueryWindow.QuerySeq,
                                            cDatabaseName,
                                            hBuffer:table)
    .

bttQueryWindow.WindowHandle:title = bttQueryWindow.WindowTitle.

end procedure. /* qg_QueryWindowQueryUpdateTitle */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowRecentQueries hQueryWindow 
PROCEDURE qg_QueryWindowRecentQueries :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Show dialog with recently executed queries.                                */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Window that contains the widgets.         */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable iOrderLabel as integer   no-undo.

define query brRecentQueriesBrowse
  for ttRecentQuery
  scrolling.

define browse brRecentQueriesBrowse
  query brRecentQueriesBrowse no-lock
    display
      ttRecentQuery.OrderLabel format 'zzzzz9  ':U label 'Ord':U
      ttRecentQuery.QueryLabel format 'x(255)':U label 'Query':U
      with no-assign size 146 by 10.5.

define variable cQueryText as character no-undo
  view-as editor
  no-word-wrap
  scrollbar-horizontal
  scrollbar-vertical
  size 146 by 10
  font 0.

define button btnOk
  label 'Ok':T2
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T
  size 20 by 1.14
  auto-end-key.


/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.
define buffer bttRecentQuery for temp-table ttRecentQuery.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if bttQueryWindow.ObjSourceQuerySeq > 0 then
  leave.

define frame fSelectRecentQuery
  brRecentQueriesBrowse at row 1.5 col 3
  cQueryText at row 12.5 col 3 no-label
  btnOk at row 23.5 col 56
  btnCancel at row 23.5 col 76
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    title gcTitlePrefix + 'Select recent query':U
    side-labels no-underline three-d 
    size 151 by 25.44
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fSelectRecentQuery
  apply 'end-error' to self.

on value-changed of brRecentQueriesBrowse in frame fSelectRecentQuery
do:
  
  if available ttRecentQuery then
    cQueryText = ttRecentQuery.QueryText.
  
  else
    cQueryText = '':U.
  
  display unless-hidden
    cQueryText
    with frame fSelectRecentQuery.
  
end. /* on 'value-changed':U of browse brRecentQueriesBrowse in window fSelectRecentQuery */

on default-action of brRecentQueriesBrowse in frame fSelectRecentQuery
  apply 'go':U to frame fSelectRecentQuery.

/* Refresh display order numbers. */

for each bttRecentQuery
  where bttRecentQuery.WindowHandle = bttQueryWindow.WindowHandle
  by Order
  on error undo, throw:
  
  assign
    iOrderLabel               = iOrderLabel + 1
    bttRecentQuery.OrderLabel = iOrderLabel
    .
  
end. /* for each bttRecentQuery */

open query brRecentQueriesBrowse
  for each ttRecentQuery
    where ttRecentQuery.WindowHandle = bttQueryWindow.WindowHandle
    by Order descending.

run qg_InitBrowse(browse brRecentQueriesBrowse:handle).

cQueryText:read-only in frame fSelectRecentQuery = yes.

if query brRecentQueriesBrowse:num-results > 0 then
do:
  
  display unless-hidden
    brRecentQueriesBrowse
    with frame fSelectRecentQuery
      in window bttQueryWindow.WindowHandle. 
  
  brRecentQueriesBrowse:select-row(1) in frame fSelectRecentQuery.
  apply 'value-changed':U to brRecentQueriesBrowse in frame fSelectRecentQuery.
  
end. /* if query brRecentQueriesBrowse:num-results > 0 */

update unless-hidden
  brRecentQueriesBrowse
  cQueryText
  btnOk
  btnCancel
  with frame fSelectRecentQuery
    in window bttQueryWindow.WindowHandle. 

if available ttRecentQuery then
do:
  
  run qg_ExecRecentQuery in target-procedure
        (bttQueryWindow.WindowHandle,
         ttRecentQuery.QueryText).
  
  apply 'entry':U to bttQueryWindow.QueryTextEditorHandle.
  
end. /* if available ttRecentQuery */

end procedure. /* qg_QueryWindowRecentQueries */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowRecordBrowseRowDisplay hQueryWindow 
PROCEDURE qg_QueryWindowRecordBrowseRowDisplay :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Copy selected record field value.                                          */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the record window.              */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer        as handle    no-undo.
define variable iColor         as integer   no-undo init ?.
define variable iColumnCounter as integer   no-undo.
define variable iLastColumn    as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hBuffer = bttQueryWindow.RecordQueryHandle:get-buffer-handle(1).

if hBuffer:available then
do:
  
  if hBuffer::IsOverlay then
    
    iColor = {&K_OBJECTID_OVERLAY_FGCOLOR}.
  
  else
    
    case integer( hBuffer::FieldType ):
      
      when {&K_FIELD_TYPE_VIRTUAL_DB_FIELD} then
        
        iColor = {&K_VIRTUAL_DB_FIELD_FGCOLOR}.
      
    end case. /* hFieldBrowseBufferHandle::FieldType */
  
  if iColor <> ? then
    
    do iColumnCounter = 1 to extent(bttQueryWindow.RecordBrowseColHandles):
      bttQueryWindow.RecordBrowseColHandles[iColumnCounter]:fgcolor = iColor.
    end. /* do i = 1 to extent(bttQueryWindow.RecordBrowseColHandles) */
  
  if hBuffer::IsOverlay then
  do:
      
    iLastColumn = extent(bttQueryWindow.RecordBrowseColHandles).
    
    bttQueryWindow.RecordBrowseColHandles[iLastColumn]:fgcolor = ( if hBuffer::IsOverlayResolved then
                                                                     {&K_OBJECTID_OVERLAY_FGCOLOR}
                                                                   else
                                                                     {&K_COLOR_RED} ).
    
  end. /* if hBuffer::IsOverlay */
  
end. /* for each bttFieldOverlay */

end procedure. /* qg_QueryWindowRecordBrowseRowDisplay */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowRecordCopyValue hQueryWindow 
PROCEDURE qg_QueryWindowRecordCopyValue :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Copy selected record field value.                                          */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the record window.              */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer    as handle    no-undo.
define variable clValue    as longchar  no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hBuffer = bttQueryWindow.RecordQueryHandle:get-buffer-handle(1).

if not hBuffer:available then
  message /* code checked by mth */
    'No field is selected':T skip
    view-as alert-box
    error
    buttons ok.
  
else
do:
  
  if bttQueryWindow.DisplayRawValues then
    copy-lob hBuffer::CurrentUnformattedValue to clValue.
  
  else
    copy-lob hBuffer::CurrentFormattedValue to clValue.
  
  clipboard:value = clValue.
    
end. /* else: if not hBuffer:available */

end procedure. /* qg_QueryWindowRecordCopyValue */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowRecordFieldDetails hQueryWindow 
PROCEDURE qg_QueryWindowRecordFieldDetails :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Show field details dialog for selected field.                              */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the record window.              */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hRecordBrowseBuffer as handle    no-undo.
define variable hRecordBuffer       as handle    no-undo.
define variable clValue             as longchar  no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hRecordBrowseBuffer = bttQueryWindow.RecordQueryHandle:get-buffer-handle(1).

if not hRecordBrowseBuffer:available then
  message /* code checked by mth */
    'No field is selected':T skip
    view-as alert-box
    error
    buttons ok
    in window bttQueryWindow.WindowHandle.
  
else
do:
  
  hRecordBuffer = bttQueryWindow.QueryHandle:get-buffer-handle(string(hRecordBrowseBuffer::BufferName)).
  
  if valid-handle(hRecordBuffer) then
  do:
  
    if not hRecordBuffer:available then
      message /* code checked by mth */
        '&1 record is not available':T skip
        view-as alert-box
        error
        buttons ok
        in window bttQueryWindow.WindowHandle.
    
    else
    do:
      
      if bttQueryWindow.DisplayRawValues then
        copy-lob from hRecordBrowseBuffer::CurrentUnformattedValue to clValue.
      
      else
        copy-lob from hRecordBrowseBuffer::CurrentFormattedValue to clValue.
      
      run qg_EditFieldValue(hRecordBrowseBuffer::FieldName,
                            hRecordBrowseBuffer::DataType,
                            hRecordBrowseBuffer::FieldFormat,
                            hRecordBrowseBuffer::FieldViewAs,
                            bttQueryWindow.DisplayRawValues,
                            no,
                            input-output clValue,
                            bttQueryWindow.WindowHandle).
      
    end. /* else: if not hRecordBuffer:available */
    
  end. /* if valid-handle(hRecordBuffer) */
  
end. /* else: if not hRecordBrowseBuffer:available */

apply 'entry':U to bttQueryWindow.RecordBrowseHandle.
  
end procedure. /* qg_QueryWindowRecordFieldDetails */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowRecordNavigate hQueryWindow 
PROCEDURE qg_QueryWindowRecordNavigate :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow         as handle    no-undo.
define input parameter piNavigationType as integer   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable rCurrentRecord as rowid     no-undo.
define variable hBuffer        as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if not valid-handle(bttQueryWindow.QueryHandle) then
  leave.

assign
  hBuffer        = bttQueryWindow.QueryHandle:get-buffer-handle(1)
  rCurrentRecord = hBuffer:rowid
  .

case piNavigationType:
  
  when {&K_NAVIGATE_FIRST} then
    bttQueryWindow.QueryHandle:get-first().
  
  when {&K_NAVIGATE_PREV} then
  do:
    
    bttQueryWindow.QueryHandle:get-prev().
    
    if    rCurrentRecord <> ?
      and not hBuffer:available then
    do:
      
      message
        'This already is the first record':T
        view-as alert-box
        information
        buttons ok
        in window bttQueryWindow.WindowHandle.
      
      bttQueryWindow.QueryHandle:get-next().
      
    end. /* if    rCurrentRecord <> ? */
    
  end. /* when {&K_NAVIGATE_PREV} */
  
  when {&K_NAVIGATE_NEXT} then
  do:
    
    bttQueryWindow.QueryHandle:get-next().
    
    if    rCurrentRecord <> ?
      and not hBuffer:available then
    do:
      
      message
        'This already is the last record':T
        view-as alert-box
        information
        buttons ok
        in window bttQueryWindow.WindowHandle.
      
      bttQueryWindow.QueryHandle:get-prev().
      
    end. /* if    rCurrentRecord <> ? */
    
  end. /* when {&K_NAVIGATE_NEXT} */
  
  when {&K_NAVIGATE_LAST} then
    bttQueryWindow.QueryHandle:get-last().
  
end case. /* piNavigationType */

run qg_QueryWindowRecordRefresh(bttQueryWindow.WindowHandle).

run qg_QueryWindowUpdateAll('':U).

end procedure. /* qg_QueryWindowRecordNavigate */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowRecordOpenQuery hQueryWindow 
PROCEDURE qg_QueryWindowRecordOpenQuery :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Open query for record field browse.                                        */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cQueryText as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

assign
  cQueryText =   'for each ttQueryWindowField':U
               + '  where ttQueryWindowField.WindowHandle = ~'&1~'':U
               + '    and ttQueryWindowField.Order        > 0':U
               + '  use-index &2':U
  cQueryText = substitute(cQueryText,
                          string(bttQueryWindow.WindowHandle),
                          (if can-find(first ttQueryWindowField
                                         where ttQueryWindowField.WindowHandle = bttQueryWindow.WindowHandle
                                           and ttQueryWindowField.Order        > 1) then
                             'Order':U
                           else
                             'Main':U))
  .

qg_lQueryOpen(bttQueryWindow.RecordQueryHandle,
              cQueryText,
              bttQueryWindow.WindowHandle).

end procedure. /* qg_QueryWindowRecordOpenQuery */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowRecordRefresh hQueryWindow 
PROCEDURE qg_QueryWindowRecordRefresh :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Refresh record field browse with current database values.                  */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the record window.              */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer as handle    no-undo.
define variable hField  as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow      for temp-table ttQueryWindow.

define buffer bttQueryWindowField for temp-table ttQueryWindowField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

for each bttQueryWindowField
  where bttQueryWindowField.WindowHandle = bttQueryWindow.WindowHandle
  on error undo, throw:
  
  run qg_UpdateRecordField( bttQueryWindowField.FieldHandle,
                            bttQueryWindowField.FieldIndex,
                            ( buffer bttQueryWindowField:handle ),
                            bttQueryWindow.DeepResolveObjectIds ).
  
end. /* for each bttQueryWindowField */

run qg_QueryWindowRecordUpdateValues(bttQueryWindow.WindowHandle).
run qg_QueryWindowRecordUpdateTitle(bttQueryWindow.WindowHandle).

end procedure. /* qg_QueryWindowRecordRefresh */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowRecordSelectFields hQueryWindow 
PROCEDURE qg_QueryWindowRecordSelectFields :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Select displayed fields.                                                   */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the record window.              */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cAvailableField_Keys   as character no-undo.
define variable cAvailableField_Labels as character no-undo.
define variable cSelectedField_Keys    as character no-undo.

define variable lOk                    as logical   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow      for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

assign
  cAvailableField_Keys   = qg_cQueryWindowFieldList(bttQueryWindow.WindowHandle,
                                                    yes,
                                                    yes)
  cAvailableField_Labels = qg_cQueryWindowFieldList(bttQueryWindow.WindowHandle,
                                                    no,
                                                    yes)
  cSelectedField_Keys    = qg_cQueryWindowFieldList(bttQueryWindow.WindowHandle,
                                                    yes,
                                                    no)
  .

run qg_SelectionDialog(cAvailableField_Keys,
                       cAvailableField_Labels,
                       input-output cSelectedField_Keys,
                       'Select fields':U,
                       bttQueryWindow.WindowHandle,
                       yes,
                       output lOk).

if lOk then
  run qg_QueryWindowRecordSetFields(bttQueryWindow.WindowHandle,
                                    cSelectedField_Keys).

end procedure. /* qg_QueryWindowRecordSelectFields */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowRecordSetFields hQueryWindow 
PROCEDURE qg_QueryWindowRecordSetFields :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Set displayed fields.                                                      */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the record window.              */
/* pcSelectedFields               = Selected fields that should be set.       */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow         as handle    no-undo.
define input parameter pcSelectedFields as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cFieldName as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow      for temp-table ttQueryWindow.

define buffer bttQueryWindowField for temp-table ttQueryWindowField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

for each bttQueryWindowField
  where bttQueryWindowField.WindowHandle = bttQueryWindow.WindowHandle
  on error undo, throw:
  
  assign
    cFieldName                = qg_cFormattedFieldName( ?,
                                                        bttQueryWindowField.BufferName,
                                                        bttQueryWindowField.FieldName,
                                                        bttQueryWindowField.FieldIndex )
    bttQueryWindowField.Order = ( if pcSelectedFields > '':U then
                                    lookup( (if bttQueryWindowField.IsOverlay then
                                               substitute( {&K_OBJECTID_OVERLAY_NAME_PATTERN},
                                                           cFieldName )
                                             else
                                               cFieldName ),
                                           pcSelectedFields )
                                  else
                                    1 )
    .
  
end. /* for each bttQueryWindowField */

run qg_QueryWindowRecordOpenQuery( bttQueryWindow.WindowHandle ).
run qg_QueryWindowRecordUpdateValues( bttQueryWindow.WindowHandle ).

end procedure. /* qg_QueryWindowRecordSetFields */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowRecordUpdateTitle hQueryWindow 
PROCEDURE qg_QueryWindowRecordUpdateTitle :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Update record window title.                                                */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the record window.              */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hQuery        as handle    no-undo.
define variable hBuffer       as handle    no-undo.

define variable cDatabaseName as character no-undo.

define variable cTitle        as character no-undo.
define variable cFieldValue   as character no-undo.
define variable clFieldValue  as longchar  no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow      for temp-table ttQueryWindow.

define buffer bttField            for temp-table ttField.
define buffer bttQueryWindowField for temp-table ttQueryWindowField.
define buffer bttIndex            for temp-table ttIndex.
define buffer bttIndexField       for temp-table ttIndexField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hQuery = bttQueryWindow.QueryHandle.

if    valid-handle(hQuery)
  and hQuery:num-buffers > 0 then
  hBuffer = hQuery:get-buffer-handle(1).

if not valid-handle(hBuffer) then
  assign
    bttQueryWindow.WindowTitle = substitute('&1[&2] Record - unknown':U,
                                            gcTitlePrefix,
                                            bttQueryWindow.QuerySeq).

else
do:
  
  cDatabaseName = qg_cDatabaseNameForTableOrBuffer( hBuffer ).
  
  if not hBuffer:available then
    cTitle = 'not available':T.
  
  else
  do:
    
    find first bttIndex
      where bttIndex.DatabaseName = cDatabaseName
        and bttIndex.TableName    = hBuffer:table
        and bttIndex.IsPrimary    = yes
      no-error.
    
    if not available bttIndex then
      cTitle = substitute('Rowid: &1':T, hBuffer:rowid).
    
    else
    do:
      
      for each bttIndexField
        where bttIndexField.DatabaseName = bttIndex.DatabaseName
          and bttIndexField.TableName    = bttIndex.TableName
          and bttIndexField.IndexName    = bttIndex.IndexName,
      first bttField
        where bttField.DatabaseName = bttIndexField.DatabaseName
          and bttField.TableName    = bttIndexField.TableName
          and bttField.FieldName    = bttIndexField.FieldName,
      first bttQueryWindowField
        where bttQueryWindowField.WindowHandle = bttQueryWindow.WindowHandle
          and bttQueryWindowField.BufferName   = hBuffer:name
          and bttQueryWindowField.FieldName    = bttIndexField.FieldName 
          and bttQueryWindowField.FieldIndex   = 0
        by bttIndexField.IndexSequence
        on error undo, throw:
        
        copy-lob bttQueryWindowField.CurrentUnformattedValue to clFieldValue.
        
        /* If the quoter function is used directly the result ist an odd      */
        /* character sequence. To avoid this we have to do it in two steps    */
        
        assign
          cFieldValue = substring(clFieldValue, 1, 30)
          cTitle      = substitute('&1, &2':U,
                                   cTitle,
                                   (if bttField.DataType = 'character':U then
                                      quoter(cFieldValue)
                                    else
                                      cFieldValue))
          .
        
      end. /* for each bttIndexField */
      
      cTitle = trim(cTitle, ',':U).
      
    end. /* else: if not available bttIndex */
    
  end. /* else: if not hBuffer:available */
  
  bttQueryWindow.WindowTitle = substitute('&1[&2] Record - &3.&4 (&5)':U,
                                          gcTitlePrefix,
                                          bttQueryWindow.QuerySeq,
                                          cDatabaseName,
                                          hBuffer:table,
                                          cTitle).
  
end. /* else: if not valid-handle(hBuffer) */

bttQueryWindow.WindowHandle:title = bttQueryWindow.WindowTitle.

end procedure. /* qg_QueryWindowRecordUpdateTitle */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowRecordUpdateValues hQueryWindow 
PROCEDURE qg_QueryWindowRecordUpdateValues :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Refresh displayed values of record field browse.                           */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the record window.              */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow      for temp-table ttQueryWindow.

define buffer bttQueryWindowField for temp-table ttQueryWindowField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

for each bttQueryWindowField
  where bttQueryWindowField.WindowHandle = bttQueryWindow.WindowHandle
  on error undo, throw:
  
  run qg_UpdateRecordFieldDisplayValue((buffer bttQueryWindowField:handle),
                                        bttQueryWindow.DisplayRawValues,
                                        255). 
  
end. /* for each bttQueryWindowField */

if bttQueryWindow.RecordQueryHandle:num-results > 0 then
  bttQueryWindow.RecordBrowseHandle:refresh().

end procedure. /* qg_QueryWindowRecordUpdateValues */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowRecordViewMenuDrop hQueryWindow 
PROCEDURE qg_QueryWindowRecordViewMenuDrop :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the record window.              */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hRawValues as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

assign
  hRawValues         = qg_hGetWidgetByName(bttQueryWindow.RecordMenuHandle,
                                           'mi_RawValues':U)
  hRawValues:checked = bttQueryWindow.DisplayRawValues
  .

end procedure. /* qg_QueryWindowRecordViewMenuDrop */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowResize hQueryWindow 
PROCEDURE qg_QueryWindowResize :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Resize widgets to match the current window size.                           */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Window that contains the widgets.         */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

case bttQueryWindow.WindowMode:
  
  when {&K_QUERY_WINDOW_MODE_QUERY} then
    run qg_QueryWindowResizeQueryFrame(bttQueryWindow.WindowHandle).
  
  when {&K_QUERY_WINDOW_MODE_RECORD} then
    run qg_QueryWindowResizeRecordFrame(bttQueryWindow.WindowHandle).
  
end case. /* bttQueryWindow.WindowMod */

end procedure. /* qg_QueryWindowResize */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowResizeQueryFrame hQueryWindow 
PROCEDURE qg_QueryWindowResizeQueryFrame :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Resize widgets to match the current window size.                           */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phFrame                        = Frame that contains the widgets.          */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hFrame       as handle    no-undo.
define variable hFieldGroup  as handle    no-undo.
define variable hWidget      as handle    no-undo.

define variable hSplitter1   as handle    no-undo.
define variable hFieldBrowse as handle    no-undo.

define variable dNewRow      as decimal   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hFrame = bttQueryWindow.QueryFrameHandle.

assign
  hSplitter1            = qg_hGetWidgetByName(phWindow, 'btnSplitter1':U)
  hFieldBrowse          = qg_hGetWidgetByName(phWindow, 'brFieldSelection':U)
  hSplitter1:row        = (if hFieldBrowse:hidden then
                             hSplitter1:row
                           else
                             max(3, hSplitter1:row))
  phWindow:height       = max(hSplitter1:row + hSplitter1:height + 3, phWindow:height)
  phWindow:width        = (if hFieldBrowse:hidden then
                             max(50, phWindow:width)
                           else
                             max(100, phWindow:width))
  hFrame:width          = max(1, phWindow:width)
  hFrame:virtual-width  = max(1, phWindow:width)
  hFrame:height         = max(1, phWindow:height)
  hFrame:virtual-height = max(1, phWindow:height)
  hSplitter1:width      = phWindow:width
  hSplitter1:row        = min(phWindow:height - 2,
                              max((if hFieldBrowse:hidden then
                                     3
                                   else
                                     3),
                                   hSplitter1:row))
  no-error.

hFieldGroup = hFrame:first-child.

do while valid-handle(hFieldGroup):
  
  hWidget = hFieldGroup:first-child.
  
  do while valid-handle(hWidget):
  
    case hWidget:name:
      
      when 'brQuery':U then
        assign
          hWidget:width  = max(1, phWindow:width)
          dNewRow        = hSplitter1:row + hSplitter1:height
          hWidget:height = max(1, phWindow:height - dNewRow + 1)
          hWidget:row    = dNewRow
          no-error.
        
      when 'cQueryText':U then
        assign
          hWidget:width  = (if hFieldBrowse:hidden then
                              max(1, phWindow:width - 23)
                            else
                              max(1, phWindow:width - 73))
          hWidget:height = hSplitter1:row - 1
          .
      
      when 'btnToggleFieldBrowse':U then
        assign
          hWidget:col    = (if hFieldBrowse:hidden then
                              max(1, phWindow:width - 22)
                            else
                              max(1, phWindow:width - 72))
          hWidget:height = hSplitter1:row - 1
          .
      
      when 'brFieldSelection':U then
        if not hWidget:hidden then
          assign
            hWidget:height = hSplitter1:row - 1
            hWidget:col    = max(1, phWindow:width - 69)
            no-error.
      
      when 'btnExecute':U then
        assign
          hWidget:col = max(1, phWindow:width - 19)
          no-error.
      
      when 'btnColumns':U then
        assign
          hWidget:col = max(1, phWindow:width - 19)
          no-error.
      
      when 'btnEdit':U then
        assign
          hWidget:col = max(1, phWindow:width - 19)
          no-error.
      
      when 'btnDelete':U then
        assign
          hWidget:col = max(1, phWindow:width - 19)
          no-error.
      
      when 'btnCreate':U then
        assign
          hWidget:col = max(1, phWindow:width - 19)
          no-error.
      
      when 'btnDuplicate':U then
        assign
          hWidget:col = max(1, phWindow:width - 19)
          no-error.
      
    end. /* case hWidget:name */

    hWidget = hWidget:next-sibling.
    
  end. /* do while valid-handle(hWidget) */
  
  hFieldGroup = hFieldGroup:next-sibling.
  
end. /* do while valid-handle(hFieldGroup) */

/* Since widgets might be moved after the frame has been resized there will */
/* somtimes be unnessesary scrollbars. As a workaround this can be avoided  */
/* by setting the width attribute a second time.                            */

hFrame:width = hFrame:width no-error.

end procedure. /* qg_QueryWindowResizeQueryFrame */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowResizeRecordFrame hQueryWindow 
PROCEDURE qg_QueryWindowResizeRecordFrame :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Adjust all widgets size and position according to current window size.     */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the record window.              */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hFrame      as handle    no-undo.
define variable hFieldGroup as handle    no-undo.
define variable hWidget     as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hFrame = bttQueryWindow.RecordFrameHandle.

assign
  phWindow:height       = max(6, phWindow:height)
  phWindow:width        = max(75, phWindow:width)
  hFrame:width          = max(1, phWindow:width)
  hFrame:virtual-width  = max(1, phWindow:width)
  hFrame:height         = max(1, phWindow:height)
  hFrame:virtual-height = max(1, phWindow:height)
  no-error.

hFieldGroup = hFrame:first-child.

do while valid-handle(hFieldGroup):
  
  hWidget = hFieldGroup:first-child.
  
  do while valid-handle(hWidget):
  
    case hWidget:name:
      
      when 'brRecord':U then
        assign
          hWidget:width  = max(1, phWindow:width)
          hWidget:height = max(1, phWindow:height - hWidget:row + 1)
          no-error.
      
      when 'btnSelectObjField':U then
        assign
          hWidget:col = max(1, phWindow:width - 7)
          no-error.
      
      when 'btnFirstRecord':U then
        assign
          hWidget:col = max(1, phWindow:width - 25)
          no-error.
      
      when 'btnPrevRecord':U then
        assign
          hWidget:col = max(1, phWindow:width - 19)
          no-error.
      
      when 'btnNextRecord':U then
        assign
          hWidget:col = max(1, phWindow:width - 13)
          no-error.
      
      when 'btnLastRecord':U then
        assign
          hWidget:col = max(1, phWindow:width - 7)
          no-error.
      
    end. /* case hWidget:name */

    hWidget = hWidget:next-sibling.
    
  end. /* do while valid-handle(hWidget) */
  
  hFieldGroup = hFieldGroup:next-sibling.
  
end. /* do while valid-handle(hFieldGroup) */

end procedure. /* qg_QueryWindowResizeRecordFrame */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowSelectNextCondition hQueryWindow 
PROCEDURE qg_QueryWindowSelectNextCondition :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Select next condition in query text editor.                                */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* plNext                         = If yes the next condition will be         */
/*                                  selected otherwise the previous condition */
/*                                  will be selected.                         */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.
define input parameter plNext   as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/


/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow  for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if not qg_lSelectNextQueryCondition(bttQueryWindow.QueryTextEditorHandle, plNext) then
do:
  
  if plNext = yes then
    bttQueryWindow.QueryTextEditorHandle:cursor-offset = 1.
  
  else if plNext = no then
    bttQueryWindow.QueryTextEditorHandle:move-to-eof().
  
  qg_lSelectNextQueryCondition(bttQueryWindow.QueryTextEditorHandle, plNext).
  
end. /* if not qg_lSelectNextQueryCondition(bttQueryWindow.QueryTextEditorHandle, plNext) */

return no-apply.

end procedure. /* qg_QueryWindowSelectNextCondition */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowEditQueryBuffers hQueryWindow 
PROCEDURE qg_QueryWindowEditQueryBuffers :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Select next condition in query text editor.                                */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* plNext                         = If yes the next condition will be         */
/*                                  selected otherwise the previous condition */
/*                                  will be selected.                         */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable iFilterId         as integer   no-undo.
define variable lShowHiddenTables as logical   no-undo.

define variable i                 as integer   no-undo.
define variable hBuffer           as handle    no-undo.

define variable cQueryText        as character no-undo.
define variable cWhereClause      as character no-undo.
define variable cBufferList       as character no-undo.

define variable lMatch            as logical   no-undo.
define variable lContinuous       as logical   no-undo.
define variable iIndexScore       as integer   no-undo extent 2.
define variable iTempIndexScore   as integer   no-undo extent 2.
define variable cFieldList        as character no-undo.
define variable cTempFieldList    as character no-undo.
define variable cValueList        as character no-undo.
define variable cTempValueList    as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow       for temp-table ttQueryWindow.

define buffer bttDatabase          for temp-table ttDatabase.
define buffer bttTable             for temp-table ttTable.
define buffer bttField             for temp-table ttField.
define buffer bttIndex             for temp-table ttIndex.
define buffer bttIndexField        for temp-table ttIndexField.
define buffer bttFilterMatch       for temp-table ttFilterMatch.
define buffer bttQueryBuffer       for temp-table ttQueryBuffer.
define buffer b2ttQueryBuffer      for temp-table ttQueryBuffer.
define buffer bttTableRelation     for temp-table ttTableRelation.
define buffer bttTableRelationView for temp-table ttTableRelationView.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

define query brBufferDatabase
  for bttDatabase
  scrolling.

define browse brBufferDatabase
  query brBufferDatabase no-lock
    display
      bttDatabase.DatabaseName width 12
      bttDatabase.PhysicalName
      with no-assign size 70 by 5.

define variable lRelatedTables as logical no-undo init yes
  format 'yes/no':U
  view-as radio-set
    radio-buttons
      'Related tables':T, yes,
      'All tables':T, no
    horizontal
  size 35 by 1.

define variable cTableFilter as character no-undo
  format 'x(32000)':U
  view-as combo-box inner-lines 8
     drop-down
  tooltip "Filter for tables that match given name pattern (comma separated)"
  size 63 by 1.

define button btnClearTableFilter
  label '':T2
  tooltip "Clear table filter"
  size 7 by 1.

define query brBufferTable
  for bttTable,bttFilterMatch
  scrolling.

define browse brBufferTable
  query brBufferTable no-lock
    display
      bttTable.TableName
      bttTable.ShortDescription
      with no-assign size 70 by 10.

define button btnAddTableBuffer
  label 'Add':T
  size 10 by 1.5.

define button btnRemoveTableBuffer
  label 'Remove':T
  size 10 by 1.5.

define button btnEditTableBuffer
  label 'Edit':T
  size 10 by 1.5.

define button btnClearTableBuffers
  label 'Clear':T
  size 10 by 1.5.

define button btnTop
  label 'Top':T
  size 10 by 1.5.

define button btnUp
  label 'Up':T
  size 10 by 1.5.

define button btnDown
  label 'Down':T
  size 10 by 1.5.

define button btnBottom
  label 'Bottom':T
  size 10 by 1.5.

define query brQueryBuffer
  for bttQueryBuffer
  scrolling.

define browse brQueryBuffer
  query brQueryBuffer no-lock
    display
      bttQueryBuffer.BufferName width 32
      bttQueryBuffer.TableDisplayName
      with no-assign size 70 by 18.

define button btnOk
  label 'Ok':T
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T
  size 20 by 1.14
  auto-end-key.

define frame fBufferSelection
  brBufferDatabase at row 1.5 col 3
  lRelatedTables at row 7 col 3 no-label
  cTableFilter at row 8.5 col 3 no-label
  btnClearTableFilter at row 8.5 col 66
  brBufferTable at row 9.5 col 3
  brQueryBuffer at row 1.5 col 91
  btnAddTableBuffer at row 1.5 col 77
  btnRemoveTableBuffer at row 3 col 77
  btnEditTableBuffer at row 5 col 77
  btnClearTableBuffers at row 8.75 col 77
  btnTop at row 12.5 col 77
  btnUp at row 14.5 col 77
  btnDown at row 16 col 77
  btnBottom at row 18 col 77
  btnOk at row 20.5 col 62
  btnCancel at row 20.5 col 82
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    side-labels no-underline three-d 
    size 163 by 22.33
    title gcTitlePrefix + 'Select query buffers':T
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fBufferSelection
  apply 'end-error' to self.

on F3 of frame fBufferSelection anywhere
do:
  
  lRelatedTables = not input frame fBufferSelection lRelatedTables.
  
  display unless-hidden
    lRelatedTables
    with frame fBufferSelection.
  
  apply 'value-changed':U to lRelatedTables in frame fBufferSelection.
  
end. /* on F3 of frame fBufferSelection */

on ins of frame fBufferSelection anywhere
do:
  
  define variable hFocusWidget as handle    no-undo.
  
  hFocusWidget = focus.
  
  if valid-handle(hFocusWidget) then
  do:
    
    /* Fire leave trigger but keep focus in active widget. */
    apply 'leave':U to hFocusWidget.
    apply 'entry':U to hFocusWidget.
    
  end. /* if valid-handle(hFocusWidget) */

  apply 'choose':U to btnAddTableBuffer in frame fBufferSelection.
  
end. /* on ins of frame fBufferSelection */

on del of frame fBufferSelection anywhere
  apply 'choose':U to btnRemoveTableBuffer in frame fBufferSelection.

on value-changed of brBufferDatabase in frame fBufferSelection
do:
  
  define buffer bttTable       for temp-table ttTable.
  define buffer bttFilterMatch for temp-table ttFilterMatch.
  
  if    available(bttDatabase)
    and bttDatabase.PhysicalDB
    and not can-find(first ttTable
                       where ttTable.DatabaseName = bttDatabase.DatabaseName) then
  do:
    
    run qg_AddTables(bttDatabase.DatabaseName).
    
    for each bttTable
      where bttTable.DatabaseName = bttDatabase.DatabaseName
      on error undo, throw:
      
      create bttFilterMatch.
      
      assign
        bttFilterMatch.FilterId      = iFilterId
        bttFilterMatch.RecordRowId   = rowid(bttTable)
        bttFilterMatch.RecordMatches = yes
        .
      
      validate bttFilterMatch.
      
    end. /* for each bttTable */

  end. /* if    available(bttDatabase) */
  
  apply 'U1':U to brBufferTable in frame fBufferSelection.
  
end. /* on value-changed of brBufferDatabase */

on value-changed of lRelatedTables in frame fBufferSelection
  apply 'U1':U to brBufferTable in frame fBufferSelection.

on value-changed of cTableFilter in frame fBufferSelection
  apply 'U1':U to brBufferTable in frame fBufferSelection.

on choose of btnClearTableFilter in frame fBufferSelection
do:
  
  cTableFilter = '':U.
  
  display unless-hidden
    cTableFilter
    with frame fBufferSelection.
  
  apply 'value-changed':U to cTableFilter in frame fBufferSelection.
  
end. /* on choose of btnClearTableFilter */

on U1 of brBufferTable in frame fBufferSelection
do:
  
  define variable cDatabaseName       as character no-undo.
  define variable cFilterEntry        as character no-undo.
  define variable cPrepFilter         as character no-undo.
  
  define variable i                   as integer       no-undo.
  
  define variable cBufferDatabaseName as character no-undo.
  define variable cBufferTableName    as character no-undo.
  
  assign
    cDatabaseName  = (if available bttDatabase then
                        bttDatabase.DatabaseName
                      else
                        ?)
    cTableFilter   = input frame fBufferSelection cTableFilter
    lRelatedTables = input frame fBufferSelection lRelatedTables
    .
  
  if not available bttQueryBuffer then
    cBufferDatabaseName = cDatabaseName.
  
  else
    assign
      cBufferDatabaseName = bttQueryBuffer.DatabaseName
      cBufferTableName    = bttQueryBuffer.TableName
      .
  
  do i = 1 to num-entries(cTableFilter):
    
    assign
      cFilterEntry = entry(i, cTableFilter).
      cPrepFilter  = substitute('&1,&2':U,
                                cPrepFilter,
                                qg_cFilterEntryMatchcode(cFilterEntry))
      .
    
  end. /* do i = 1 to num-entries(cFilter) */
  
  cPrepFilter = (if cPrepFilter = '':U then
                   '*':U
                 else
                   trim(cPrepFilter, ',':U)).
  
  for each bttTable
    where bttTable.DatabaseName = cDatabaseName,
  first bttFilterMatch
    where bttFilterMatch.FilterId    = iFilterId
      and bttFilterMatch.RecordRowId = rowid(bttTable)
    on error undo, throw:
    
    bttFilterMatch.RecordMatches =     can-do(cPrepFilter, bttTable.TableName)
                                   and ( lShowHiddenTables
                                      or ( not can-do('sys*':U, bttTable.TableName)
                                       and not can-do('_*':U, bttTable.TableName) ) )
                                   and ( not lRelatedTables
                                      or cBufferTableName = '':U 
                                      or can-find(first ttTableRelationView
                                                    where ttTableRelationView.DatabaseName       = cBufferDatabaseName
                                                      and ttTableRelationView.ReferenceTableName = cBufferTableName
                                                      and ttTableRelationView.RelatedTableName   = bttTable.TableName ) ).
    
    validate bttFilterMatch.
    
  end. /* for each bttTableRelationView */
  
  open query brBufferTable
    for each bttTable
      where bttTable.DatabaseName = cDatabaseName,
    first bttFilterMatch
      where bttFilterMatch.FilterId      = iFilterId
        and bttFilterMatch.RecordRowId   = rowid(bttTable)
        and bttFilterMatch.RecordMatches = yes
      .
  
  apply 'value-changed':U to browse brBufferTable.
  
end. /* on value-changed of cTableFilte */

on leave of cTableFilter in frame fBufferSelection
do:
  
  if available bttDatabase then
    run qg_FixCase(cTableFilter:handle in frame fBufferSelection,
                   bttDatabase.DatabaseName,
                   ?,
                   {&K_CASEMODE_TABLE}).
  
  if brBufferTable:query:num-results > 0 then
    run qg_AddFieldHistoryEntry(cTableFilter:handle in frame fBufferSelection).
  
end. /* on leave of cTableFilter */

on end-error of cTableFilter in frame fBufferSelection
do:
  
  apply 'choose':U to btnClearTableFilter in frame fBufferSelection.
  return no-apply.
  
end. /* on end-error of cTableFilter */

on default-action of brBufferTable in frame fBufferSelection
  apply 'choose':U to btnAddTableBuffer in frame fBufferSelection.

on row-display of brBufferTable in frame fBufferSelection
do:
  
  if    not bttTable.DescriptionLoaded
    
    /* For performance reasons we only do this when the database is connected */
    /* in shared memory mode.                                                 */
    
    and ( available bttDatabase
      and ( bttDatabase.SharedMemory
         or not bttDatabase.PhysicalDB ) ) then
    
    run qg_AddTableRepositoryInfo(bttTable.DatabaseName, bttTable.TableName).

  bttTable.ShortDescription:fgcolor in browse brBufferTable = {&K_COLOR_LIGHT_GREY}.
  
end. /* on row-display of brBufferDatabase in frame fBufferSelection */

on U1 of brQueryBuffer in frame fBufferSelection
do:
  
  open query brQueryBuffer
    for each bttQueryBuffer
    use-index Order.
  
  apply 'value-changed':U to brQueryBuffer in frame fBufferSelection.
  
end. /* on U1 of brQueryBuffer */

on value-changed of brQueryBuffer in frame fBufferSelection
do:
  
  if input frame fBufferSelection lRelatedTables then
    apply 'U1':U to brBufferTable in frame fBufferSelection.
  
end. /* on 'value-changed':U of frame fBufferSelection */

on choose of btnAddTableBuffer in frame fBufferSelection
do:
  
  define variable iOrder      as integer   no-undo.
  
  define variable iBuffer     as integer   no-undo.
  define variable cBufferName as character no-undo.
  
  define buffer bttQueryBuffer for temp-table ttQueryBuffer.
  
  find last bttQueryBuffer
    where bttQueryBuffer.QuerySeq = bttQueryWindow.QuerySeq
    use-index Order
    no-error.
  
  iOrder = (if available bttQueryBuffer then
              bttQueryBuffer.Order + 1
            else
              1).
  
  if available bttTable then
  do:
    
    do while yes:
      
      case iBuffer:
        
        when 0 then
          cBufferName = bttTable.TableName.
        
        when 1 then
          cBufferName = substitute('b&1':U,
                                   bttTable.TableName).
        
        otherwise
          cBufferName = substitute('b&1&2':U,
                                   string(iBuffer),
                                   bttTable.TableName).
        
      end case. /* iBuffer */
      
      find bttQueryBuffer
        where bttQueryBuffer.QuerySeq   = bttQueryWindow.QuerySeq
          and bttQueryBuffer.BufferName = cBufferName
        no-error.
      
      if not available bttQueryBuffer then
        leave.
      
      iBuffer = iBuffer + 1.
      
    end. /* do while yes */
    
    create bttQueryBuffer.
    
    assign
      bttQueryBuffer.QuerySeq         = bttQueryWindow.QuerySeq
      bttQueryBuffer.BufferName       = cBufferName
      bttQueryBuffer.DatabaseName     = bttTable.DatabaseName
      bttQueryBuffer.TableName        = bttTable.TableName
      bttQueryBuffer.TableDisplayName = substitute('&1.&2':U,
                                                   bttQueryBuffer.DatabaseName,
                                                   bttQueryBuffer.TableName)
      bttQueryBuffer.Order            = iOrder
      .
    
    validate bttQueryBuffer.
    
    if not bttTable.DetailsLoaded then
      run qg_AddTableDetails(bttTable.DatabaseName,
                             bttTable.TableName).
    
    apply 'U1':U to brQueryBuffer in frame fBufferSelection.
    
    if    query brQueryBuffer:num-results > 0
      and can-find(first ttFilterMatch
                     where ttFilterMatch.FilterId    = iFilterId
                       and ttFilterMatch.RecordRowId = rowid(bttTable)) then
    do:
      reposition brQueryBuffer to rowid rowid(bttQueryBuffer) no-error.
      apply 'value-changed':U to brQueryBuffer in frame fBufferSelection.
    end. /* if    query brQueryBuffer:num-results > 0 */
    
  end. /* if available bttTable */
  
end. /* on choose of btnAddTableBuffer */

on choose of btnRemoveTableBuffer in frame fBufferSelection
do:
  
  define variable iOrder    as integer   no-undo.
  define variable iNewOrder as integer   no-undo.
  
  define buffer b2ttQueryBuffer for temp-table ttQueryBuffer.
  
  if available bttQueryBuffer then
  do:
    
    assign
      iOrder    = bttQueryBuffer.Order
      iNewOrder = iOrder
      .
    
    delete bttQueryBuffer.
    
    for each b2ttQueryBuffer
      where b2ttQueryBuffer.QuerySeq = bttQueryWindow.QuerySeq
        and b2ttQueryBuffer.Order    > iOrder
      use-index Order
      on error undo, throw:
      
      b2ttQueryBuffer.Order = iNewOrder.
      
      validate bttQueryBuffer.
      
      iNewOrder = iNewOrder + 1.
      
    end. /* for each b2ttQueryBuffer */
    
    apply 'U1':U to brQueryBuffer in frame fBufferSelection.
    
    find first b2ttQueryBuffer
      where b2ttQueryBuffer.QuerySeq = bttQuerywindow.QuerySeq
        and b2ttQueryBuffer.Order   >= iOrder
      use-index Order
      no-error.
    
    if not available b2ttQueryBuffer then
      find last b2ttQueryBuffer
        where b2ttQueryBuffer.QuerySeq = bttQueryWindow.QuerySeq
        use-index Order
        no-error.
    
    if    available b2ttQueryBuffer
      and query brQueryBuffer:num-results > 0 then
    do:
      reposition brQueryBuffer to rowid rowid(b2ttQueryBuffer) no-error.
      apply 'value-changed':U to brQueryBuffer in frame fBufferSelection.
    end. /* if    available b2ttQueryBuffer */
    
  end. /* if available bttQueryBuffer */
  
end. /* on choose of btnRemoveTableBuffer */

on choose of btnClearTableBuffers in frame fBufferSelection
do:
  
  define buffer bttQueryBuffer for temp-table ttQueryBuffer.
  
  for each bttQueryBuffer
    where bttQueryBuffer.QuerySeq = bttQueryWindow.QuerySeq
    on error undo, throw:
    
    delete bttQueryBuffer.
    
  end. /* for each bttQueryBuffer */
  
  apply 'U1':U to brQueryBuffer in frame fBufferSelection.
  
end. /* on choose of btnClearTableBuffers in frame fBufferSelection */

on choose of btnTop in frame fBufferSelection
do:
  
  define variable iOrder as integer   no-undo.
  define variable rRowId as rowid     no-undo.
  
  define buffer b2ttQueryBuffer for temp-table ttQueryBuffer.
  
  if    available bttQueryBuffer
    and bttQueryBuffer.Order > 1 then
  do:
    
    for each b2ttQueryBuffer
      where b2ttQueryBuffer.QuerySeq = bttQueryWindow.QuerySeq
        and b2ttQueryBuffer.Order    < bttQueryBuffer.Order
      use-index Order
      on error undo, throw:
      
      b2ttQueryBuffer.Order = b2ttQueryBuffer.Order + 1.
      
    end. /* for each b2ttQueryBuffer */
    
    bttQueryBuffer.Order = 1.
    
    rRowId = rowid(bttQueryBuffer).
    
    apply 'U1':U to brQueryBuffer in frame fBufferSelection.
    
    reposition brQueryBuffer to rowid rRowId no-error.
    
  end. /* if available bttQueryBuffer */
  
end. /* on choose of btnTop in frame fBufferSelection */

on choose of btnUp in frame fBufferSelection
do:
  
  define variable iOrder as integer   no-undo.
  define variable rRowId as rowid     no-undo.
  
  define buffer b2ttQueryBuffer for temp-table ttQueryBuffer.
  
  if    available bttQueryBuffer
    and bttQueryBuffer.Order > 1 then
  do:
    
    find last b2ttQueryBuffer
      where b2ttQueryBuffer.QuerySeq = bttQueryWindow.QuerySeq
        and b2ttQueryBuffer.Order    < bttQueryBuffer.Order
      use-index Order
      no-error.
    
    if available b2ttQueryBuffer then
    do:
    
      assign
        iOrder                 = bttQueryBuffer.Order
        bttQueryBuffer.Order   = b2ttQueryBuffer.Order
        b2ttQueryBuffer.Order  = iOrder
        .
      
      validate bttQueryBuffer.
      validate b2ttQueryBuffer.
      
      rRowId = rowid(bttQueryBuffer).
      
      apply 'U1':U to brQueryBuffer in frame fBufferSelection.
      
      reposition brQueryBuffer to rowid rRowId no-error.
      
    end. /* if available b2ttQueryBuffer */
    
  end. /* if available bttQueryBuffer */
  
end. /* on choose of btnUp in frame fBufferSelection */

on choose of btnDown in frame fBufferSelection
do:
  
  define variable iOrder as integer   no-undo.
  define variable rRowId as rowid     no-undo.
  
  define buffer b2ttQueryBuffer for temp-table ttQueryBuffer.
  
  if available bttQueryBuffer then
  do:
    
    find first b2ttQueryBuffer
      where b2ttQueryBuffer.QuerySeq = bttQueryWindow.QuerySeq
        and b2ttQueryBuffer.Order    > bttQueryBuffer.Order
      use-index Order
      no-error.
    
    if available b2ttQueryBuffer then
    do:
    
      assign
        iOrder                 = bttQueryBuffer.Order
        bttQueryBuffer.Order   = b2ttQueryBuffer.Order
        b2ttQueryBuffer.Order  = iOrder
        .
      
      validate bttQueryBuffer.
      validate b2ttQueryBuffer.
      
      rRowId = rowid(bttQueryBuffer).
      
      apply 'U1':U to brQueryBuffer in frame fBufferSelection.
      
      reposition brQueryBuffer to rowid rRowId.
      
    end. /* if available b2ttQueryBuffer */
    
  end. /* if available bttQueryBuffer */
  
end. /* on choose of btnDown in frame fBufferSelection */

on choose of btnBottom in frame fBufferSelection
do:
  
  define variable iOrder as integer   no-undo.
  define variable rRowId as rowid     no-undo.
  
  define buffer b2ttQueryBuffer for temp-table ttQueryBuffer.
  
  if available bttQueryBuffer then
  do:
    
    find last b2ttQueryBuffer
      where b2ttQueryBuffer.QuerySeq = bttQueryWindow.QuerySeq
      use-index Order
      no-error.
    
    if    available b2ttQueryBuffer
      and b2ttQueryBuffer.Order > bttQueryBuffer.Order then
    do:
      
      iOrder = b2ttQueryBuffer.Order.
      
      for each b2ttQueryBuffer
        where b2ttQueryBuffer.QuerySeq = bttQueryWindow.QuerySeq
          and b2ttQueryBuffer.Order    > bttQueryBuffer.Order
        use-index Order
        on error undo, throw:
        
        b2ttQueryBuffer.Order = b2ttQueryBuffer.Order - 1.
        
      end. /* for each b2ttQueryBuffer */
      
      bttQueryBuffer.Order = iOrder.
      
      rRowId = rowid(bttQueryBuffer).
      
      apply 'U1':U to brQueryBuffer in frame fBufferSelection.
      
      reposition brQueryBuffer to rowid rRowId.
      
    end. /* if    available b2ttQueryBuffer ... */
    
  end. /* if available bttQueryBuffer */
  
end. /* on choose of btnBottom in frame fBufferSelection */

iFilterId = qg_iFilterSeq().

for each bttTable
  on error undo, throw:
  
  create bttFilterMatch.
  
  assign
    bttFilterMatch.FilterId      = iFilterId
    bttFilterMatch.RecordRowId   = rowid(bttTable)
    bttFilterMatch.RecordMatches = yes
    .
  
  validate bttFilterMatch.
  
end. /* for each bttTable */

empty temp-table ttQueryBuffer.

do i = 1 to bttQueryWindow.QueryHandle:num-buffers:

  hBuffer = bttQueryWindow.QueryHandle:get-buffer-handle(i).

  create bttQueryBuffer.
  
  assign
    bttQueryBuffer.QuerySeq         = bttQueryWindow.QuerySeq
    bttQueryBuffer.BufferName       = hBuffer:name
    bttQueryBuffer.DatabaseName     = qg_cDatabaseNameForTableOrBuffer( hBuffer )
    bttQueryBuffer.TableName        = hBuffer:table
    bttQueryBuffer.TableDisplayName = substitute('&1.&2':U,
                                                 bttQueryBuffer.DatabaseName,
                                                 bttQueryBuffer.TableName)
    bttQueryBuffer.Order            = i
    .

end. /* do i = 1 to bttQueryWindow.QueryHandle:num-buffers */

display unless-hidden
  brBufferDatabase
  lRelatedTables
  cTableFilter
  brBufferTable
  brQueryBuffer
  with frame fBufferSelection
    in window bttQueryWindow.WindowHandle.

assign
  cTableFilter:delimiter in frame fBufferSelection
      = chr(1)
  cTableFilter:list-items in frame fBufferSelection
      = gcTableFilter:list-items in frame {&FRAME-NAME}
  .

run qg_InitBrowse(browse brBufferDatabase:handle).
run qg_InitBrowse(browse brBufferTable:handle).
run qg_InitBrowse(browse brQueryBuffer:handle).

apply 'U1':U to brQueryBuffer in frame fBufferSelection.

open query brBufferDatabase
  for each bttDatabase
    no-lock.

apply 'value-changed':U to brBufferDatabase in frame fBufferSelection.

update unless-hidden
  cTableFilter
  btnClearTableFilter
  brBufferTable
  btnAddTableBuffer
  btnRemoveTableBuffer
  btnEditTableBuffer
  btnClearTableBuffers
  btnTop
  btnUp
  btnDown
  btnBottom
  brQueryBuffer
  btnOk
  btnCancel
  brBufferDatabase
  lRelatedTables
  with frame fBufferSelection
    in window bttQueryWindow.WindowHandle.

for each bttQueryBuffer
  where bttQueryBuffer.QuerySeq = bttQueryWindow.QuerySeq
  by bttQueryBuffer.Order
  on error undo, throw:
  
  assign
    cQueryText   = (if cQueryText > '':U then
                      substitute('&1,~neach &2':U,
                                 cQueryText,
                                 bttQueryBuffer.BufferName)
                    else
                      substitute('for each &1':U,
                                 bttQueryBuffer.BufferName))
    cWhereClause = '':U
    cBufferList  = substitute('&1,&2.&3:&4',
                              cBufferList,
                              bttQueryBuffer.DatabaseName,
                              bttQueryBuffer.TableName,
                              bttQueryBuffer.BufferName)
    .
  
  find bttTable
    where bttTable.DatabaseName = bttQueryBuffer.DatabaseName
      and bttTable.TableName    = bttQueryBuffer.TableName
    no-error.
  
  if    available bttTable
    and not bttTable.DetailsLoaded then
    run qg_AddTableDetails(bttTable.DatabaseName,
                           bttTable.TableName).
  
  for each b2ttQueryBuffer
    where b2ttQueryBuffer.QuerySeq = bttQueryBuffer.QuerySeq
      and b2ttQueryBuffer.Order    < bttQueryBuffer.Order,
  first bttTableRelationView
    where bttTableRelationView.DatabaseName       = bttQueryBuffer.DatabaseName
      and bttTableRelationView.ReferenceTableName = bttQueryBuffer.TableName
      and bttTableRelationView.RelatedTableName   = b2ttQueryBuffer.TableName,
  first bttTableRelation
    where bttTableRelation.RelationId = bttTableRelationView.RelationId
    by b2ttQueryBuffer.Order descending
    on error undo, throw:
    
    cWhereClause = qg_cCreateRelatedWhereClause(buffer bttTableRelation,
                                                (bttTableRelation.ParentTableName = b2ttQueryBuffer.TableName),
                                                bttQueryBuffer.BufferName,
                                                b2ttQueryBuffer.BufferName,
                                                ?).
    
    if cWhereClause > '':U then
      leave.
    
  end. /* for each b2ttQueryBuffer */
  
  if   cWhereClause = ?
    or cWhereClause = '':U then
  do:
    
    assign
      iIndexScore     = 0
      cFieldList      = '':U
      cValueList      = '':U
      .
    
    for each bttIndex
      where ( bttIndex.DatabaseName = bttQueryBuffer.DatabaseName
          and bttIndex.TableName    = bttQueryBuffer.TableName
          and bttIndex.IsPrimary    = yes )
         or ( bttIndex.DatabaseName = bttQueryBuffer.DatabaseName
          and bttIndex.TableName    = bttQueryBuffer.TableName
          and bttIndex.IsPrimary    = no )
      on error undo, throw:
      
      assign
        lContinuous     = yes
        iTempIndexScore = 0
        cTempFieldList  = '':U
        cTempValueList  = '':U
        .
      
      for each bttIndexField
        where bttIndexField.DatabaseName = bttIndex.DatabaseName
          and bttIndexField.TableName    = bttIndex.Tablename
          and bttIndexField.IndexName    = bttIndex.IndexName
        by bttIndexField.IndexSequence
        on error undo, throw:
        
        lMatch = no.
        
        for each b2ttQueryBuffer
          where b2ttQueryBuffer.QuerySeq = bttQueryBuffer.QuerySeq
            and b2ttQueryBuffer.Order    < bttQueryBuffer.Order,
        each bttField
          where bttField.DatabaseName = b2ttQueryBuffer.DatabaseName
            and bttField.TableName    = b2ttQueryBuffer.TableName
            and bttField.FieldName    = bttIndexField.FieldName
          by b2ttQueryBuffer.Order descending
          on error undo, throw:
          
          assign
            cTempFieldList = substitute('&1,&2':U,
                                        cTempFieldList,
                                        bttIndexField.FieldName)
            cTempValueList = substitute('&1&2&3':U,
                                        cTempValueList,
                                        {&K_PARAM_SPLITTER},
                                        (if can-do({&K_COMPANY_FIELDS}, bttIndexField.FieldName) then
                                           substitute('~'&1~'',
                                                      qg_cGetCompany(bttField.TableName, ?))
                                         else
                                           qg_cFormattedFieldName(?,
                                                                  b2ttQueryBuffer.BufferName,
                                                                  bttField.FieldName,
                                                                  0)))
            lMatch         = yes
            .
        
        end. /* for each b2ttQueryBuffer */
        
        if not lMatch then
          lContinuous = no.
        
        else
          iTempIndexScore[2 - integer(lContinuous)] = iTempIndexScore[2 - integer(lContinuous)] + 1.
        
      end. /* for each bttIndexField */
      
      if    iTempIndexScore[1] > iIndexScore[1]
         or ( iTempIndexScore[1] = iIndexScore[1]
          and iTempIndexScore[2] > iIndexScore[2] ) then
        assign
          cFieldList = trim(cTempFieldList, ',':U)
          cValueList = trim(cTempValueList, {&K_PARAM_SPLITTER})
          .
      
    end. /* for each bttIndex */
    
    if cFieldList > '':U then
      cWhereClause = qg_cCreateWhereClause( /* pcDatabaseName   */ bttQueryBuffer.DatabaseName,
                                            /* pcTableNames     */ bttQueryBuffer.TableName,
                                            /* pcBufferNames    */ bttQueryBuffer.BufferName,
                                            /* pcFieldList      */ cFieldList,
                                            /* pcFieldLabelList */ ?,
                                            /* plStartWithWhere */ yes,
                                            /* piValueMode      */ {&K_VALUE_MODE_PARAMETER},
                                            /* pcValueList      */ cValueList,
                                            /* piAccessMode     */ {&K_ACCESS_MODE_PHYSICAL},
                                            /* plAddTags        */ no,
                                            /* piIndentBlanks   */ 2 ).
    
  end. /* if   cWhereClause = ? */
  
  if cWhereClause > '':U then
    cQueryText = substitute('&1~n&2':U, cQuerytext, cWhereClause).
  
/*  assign                                           */
/*    cPrevDatabaseName = bttQueryBuffer.DatabaseName*/
/*    cPrevTableName    = bttQueryBuffer.TableName   */
/*    cPrevBufferName   = bttQueryBuffer.BufferName  */
/*    .                                              */
  
end. /* for each bttQueryBuffer */

assign
  cBufferList              = trim(cBufferList, ',':U).
  bttQueryWindow.QueryText = cQueryText
  .

validate bttQuerywindow.

if valid-handle(bttQueryWindow.QueryFrameHandle) then
  bttQueryWindow.QueryTextEditorHandle:screen-value = bttQueryWindow.QueryText.

run qg_QueryWindowUpdateQuery(bttQueryWindow.WindowHandle, cBufferList).

/*run qg_QueryWindowListRefresh.*/

/*message                 */
/*  cQueryText skip       */
/*  view-as alert-box     */
/*  title program-name(1).*/

finally:

/*  if cTableFilter:list-items in frame fBufferSelection > '':U then*/
/*    assign                                                        */
/*      cTableFilter = input frame {&FRAME-NAME} gcTableFilter      */
/*      gcTableFilter:list-items in frame {&FRAME-NAME}             */
/*          = cTableFilter:list-items in frame fBufferSelection     */
/*      gcTableFilter:screen-value in frame {&FRAME-NAME}           */
/*          = cTableFilter                                          */
/*      .                                                           */
  
  if iFilterId > 0 then
    
    for each bttFilterMatch
      where bttFilterMatch.FilterId = iFilterId
      on error undo, next:
      
      delete bttFilterMatch.
      
    end. /* for each bttFilterMatch */
    
  if available bttQueryWindow then
  
    for each bttQueryBuffer
      where bttQueryBuffer.QuerySeq = bttQueryWindow.QuerySeq
      on error undo, next:
      
      delete bttQueryBuffer.
      
    end. /* for each bttQueryBuffer */
    
end finally.

end procedure. /* qg_QueryWindowEditQueryBuffers */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowSetComparator hQueryWindow 
PROCEDURE qg_QueryWindowSetComparator :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow     as handle    no-undo.
define input parameter pcComparator as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cQueryText   as character no-undo.
define variable iOffset      as integer   no-undo.

define variable i            as integer   no-undo.
define variable iConditionNo as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow    for temp-table ttQueryWindow.
define buffer bttQueryCondition for temp-table ttQueryCondition.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if    bttQueryWindow.ObjSourceQuerySeq > 0
   or not valid-handle(bttQueryWindow.QueryFrameHandle) then
  leave.

assign
  iOffset    = bttQueryWindow.QueryTextEditorHandle:cursor-offset
  cQueryText = bttQueryWindow.QueryTextEditorHandle:input-value
  .

run qg_ParseQueryConditions(cQueryText).

for each bttQueryCondition
  on error undo, throw:
  
  i = i + 1.
  
  if    bttQueryCondition.StartPos <= iOffset
    and bttQueryCondition.EndPos   >= iOffset then
  do:
    
    iConditionNo = i.
    leave.
    
  end. /* if    bttQueryCondition.StartPos <= iOffset */
  
end. /* for each bttQueryCondition */

if available bttQueryCondition then
  assign
    cQueryText = substitute('&1 &2 &3':U,
                            right-trim(substring(cQueryText,
                                                 1,
                                                 bttQueryCondition.ComparatorStartPos - 1)),
                            pcComparator,
                            left-trim(substring(cQueryText,
                                                bttQueryCondition.ComparatorEndPos)))
    cQueryText = qg_cBeautifyQueryText(cQuerytext)
    bttQueryWindow.QueryTextEditorHandle:screen-value  = cQueryText
    .

if iConditionNo > 0 then
do:
  
  run qg_ParseQueryConditions(cQueryText).
  
  i = 0.
  
  for each bttQueryCondition
    on error undo, throw:
    
    i = i + 1.
    
    if i = iConditionNo then
    do:
      
      bttQueryWindow.QueryTextEditorHandle:cursor-offset = bttQueryCondition.StartPos.
      run qg_QueryWindowSelectNextCondition(bttQueryWindow.WindowHandle, yes).
      
      leave.
      
    end. /* if i = iConditionNo */
    
  end. /* for each bttQueryCondition */
  
  apply 'entry':U to bttQueryWindow.QueryTextEditorHandle.
  
end. /* if iConditionNo > 0 */

end procedure. /* qg_QueryWindowSetComparator */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowSetFocus hQueryWindow 
PROCEDURE qg_QueryWindowSetFocus :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Set focus to given widget.                                                 */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* pcWidgetName                   = Name of the Widget to set focus to.       */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow     as handle    no-undo.
define input parameter pcWidgetName as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hWidget as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hWidget = qg_hGetWidgetByName(bttQueryWindow.WindowHandle, pcWidgetName).

if hWidget:name = 'cQueryText':U then
do:
  
  hWidget:cursor-offset = 1.
  qg_lSelectNextQueryCondition(hWidget, yes).
  
end. /* if phWidget:name = 'cQueryText':U */

apply 'entry':U to hWidget.

end procedure. /* qg_QueryWindowSetFocus */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowSetQueryText hQueryWindow 
PROCEDURE qg_QueryWindowSetQueryText :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow    as handle    no-undo.
define input parameter pcQueryText as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/


/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

bttQueryWindow.QueryText = pcQueryText.

run qg_ParseQueryLinks(bttQueryWindow.QueryText,
                       bttQueryWindow.QuerySeq,
                       temp-table ttQueryLink:handle).

run qg_QueryWindowListRefresh.

end procedure. /* PROCEDURE qg_QueryWindowSetQueryText */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowQuerySetQueryText hQueryWindow 
PROCEDURE qg_QueryWindowQuerySetQueryText :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Set query text to given editor and place cursor to the first value.        */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phEditor                       = Editor widget.                            */
/* pcQueryText                    = Query text.                               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow               as handle    no-undo.
define input parameter pcQueryText            as character no-undo.
define input parameter plSelectFirstCondition as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

assign
  bttQueryWindow.QueryTextEditorHandle:screen-value  = pcQueryText
  bttQueryWindow.QueryTextEditorHandle:cursor-offset = 1
  .

if plSelectFirstCondition then
  qg_lSelectNextQueryCondition(bttQueryWindow.QueryTextEditorHandle, yes).

end procedure. /* qg_QueryWindowQuerySetQueryText */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowSetSize hQueryWindow 
PROCEDURE qg_QueryWindowSetSize :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Set Query window to a predefined size.                                     */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* piSize                         = Size code to use.                         */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.
define input parameter piSize   as integer   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hSplitter1      as handle    no-undo.
define variable hFieldBrowse    as handle    no-undo.

define variable dSplitterMinRow as decimal   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if bttQueryWindow.WindowMode = {&K_QUERY_WINDOW_MODE_QUERY} then
  assign
    hSplitter1      = qg_hGetWidgetByName(bttQueryWindow.QueryFrameHandle, 'btnSplitter1':U)
    hFieldBrowse    = qg_hGetWidgetByName(bttQueryWindow.QueryFrameHandle, 'brFieldSelection':U)
    dSplitterMinRow = (if hFieldBrowse:hidden then
                         3
                       else
                         4)
    .

case piSize:
  
  when {&K_QUERY_SIZE_MODE_DEFAULT} then
  do:
    
    if bttQueryWindow.WindowMode = {&K_QUERY_WINDOW_MODE_QUERY} then
      hSplitter1:row = 7 no-error.
    
    assign
      bttQueryWindow.WindowHandle:width  = 150
      bttQueryWindow.WindowHandle:height = 18
      no-error.
    
  end. /* when {&K_QUERY_SIZE_MODE_DEFAULT} */
  
  when {&K_QUERY_SIZE_MODE_DEFAULT_SPLITTER} then
  do:
    
    if bttQueryWindow.WindowMode = {&K_QUERY_WINDOW_MODE_QUERY} then
    do:
      
      if    bttQueryWindow.WindowHandle:width  = 150
        and bttQueryWindow.WindowHandle:height = 18 then
      do:

        if hSplitter1:row < 7 then
          hSplitter1:row = truncate(hSplitter1:row, 0) + 1.

        else
          hSplitter1:row = dSplitterMinRow.

      end. /* if    bttQueryWindow.WindowHandle:width  = 150 */
    
      hSplitter1:row = (if hSplitter1:row > 7 then
                          7
                        else
                          hSplitter1:row).
      
    end. /* if bttQueryWindow.WindowMode = {&K_QUERY_WINDOW_MODE_QUERY} */
    
    assign
      bttQueryWindow.WindowHandle:width  = 150
      bttQueryWindow.WindowHandle:height = 18
      no-error.
    
  end. /* when {&K_QUERY_SIZE_MODE_DEFAULT_SPLITTER} */

  when {&K_QUERY_SIZE_MODE_SMALL} then
  do:
    
    if bttQueryWindow.WindowMode = {&K_QUERY_WINDOW_MODE_QUERY} then
      hSplitter1:row = dSplitterMinRow no-error.
    
    assign
      bttQueryWindow.WindowHandle:width  = 150
      bttQueryWindow.WindowHandle:height = hSplitter1:row + hSplitter1:height + 3
      no-error.
      
  end. /* when {&K_QUERY_SIZE_MODE_SMALL} */
  
  when {&K_QUERY_SIZE_MODE_MINIMUM} then
  do:
    
    if bttQueryWindow.WindowMode = {&K_QUERY_WINDOW_MODE_QUERY} then
      hSplitter1:row = dSplitterMinRow no-error.
    
    assign
      bttQueryWindow.WindowHandle:width  = (if hFieldBrowse:hidden then
                                              50
                                            else
                                              100)
      bttQueryWindow.WindowHandle:height = hSplitter1:row + hSplitter1:height + 3
      no-error.
    
  end. /* when {&K_QUERY_SIZE_MODE_MINIMUM} */
  
  when {&K_QUERY_SIZE_MODE_BIG} then
  do:
    
    if bttQueryWindow.WindowMode = {&K_QUERY_WINDOW_MODE_QUERY} then
      hSplitter1:row = 7 no-error.
    
    assign
      bttQueryWindow.WindowHandle:width  = 235
      bttQueryWindow.WindowHandle:height = 32
      no-error.
    
  end. /* when {&K_QUERY_SIZE_MODE_BIG} */
  
  when {&K_RECORD_SIZE_MODE_DEFAULT} then
    assign
      bttQueryWindow.WindowHandle:width  = 80
      bttQueryWindow.WindowHandle:height = 18
      no-error.
  
  otherwise
    leave.
  
end case. /* piSize */

run qg_QueryWindowResize(bttQueryWindow.WindowHandle).

end procedure. /* qg_QueryWindowSetSize */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowSetVisibleState hQueryWindow 
PROCEDURE qg_QueryWindowSetVisibleState :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Set query window visible state.                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* piSourceSeq                    = QuerySeq of the query window.             */
/* plVisible                      = Visible state that should be set.         */
/* plChildren                     = If yes the visible state is set for       */
/*                                  linked child windows as well.             */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter piQuerySeq as integer   no-undo.
define input parameter plVisible  as logical   no-undo.
define input parameter plChildren as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow  for temp-table ttQueryWindow.
define buffer bttQueryLink    for temp-table ttQueryLink.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

find bttQueryWindow
  where bttQueryWindow.QuerySeq = piQuerySeq
  no-error.

if not available bttQueryWindow then
  leave.

bttQueryWindow.WindowHandle:visible = plVisible.

if plChildren then
do:

  for each bttQueryLink
    where bttQueryLink.SourceSeq = piQuerySeq,
  first bttQueryWindow
    where bttQueryWindow.QuerySeq = bttQueryLink.TargetSeq
    on error undo, throw:
    
    run qg_QueryWindowSetVisibleState(bttQueryWindow.QuerySeq, plVisible, yes).
    
  end. /* for each bttQueryLink */
  
end. /* if plChildren */

end procedure. /* qg_QueryWindowSetVisibleState */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowSetWindowMode hQueryWindow 
PROCEDURE qg_QueryWindowSetWindowMode :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow         as handle    no-undo.
define input parameter piWindowMode     as integer   no-undo.
define input parameter pcQueryText      as character no-undo.
define input parameter plFocusQueryText as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i                       as integer   no-undo.

define variable hBuffer                 as handle    no-undo extent.
define variable rCurrentRecord          as rowid     no-undo extent.
define variable cDatabaseName           as character no-undo.
define variable cTableName              as character no-undo.

define variable cWindowTitle            as character no-undo.
define variable cIconFilename           as character no-undo.
define variable cSmallIconFilename      as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

bttQueryWindow.WindowMode = piWindowMode.

validate bttQueryWindow.

if    valid-handle(bttQueryWindow.QueryHandle)
  and bttQueryWindow.QueryHandle:num-buffers > 0 then
do:
  
  assign
    extent(hBuffer)        = bttQueryWindow.QueryHandle:num-buffers
    extent(rCurrentRecord) = bttQueryWindow.QueryHandle:num-buffers
      .
  
  do i = 1 to bttQueryWindow.QueryHandle:num-buffers:
    
    assign
      hBuffer[i]        = bttQueryWindow.QueryHandle:get-buffer-handle(i)
      rCurrentRecord[i] = hBuffer[i]:rowid
      .
    
  end. /* do i = 1 to extent(hBuffer) */
  
  assign
    cDatabaseName = qg_cDatabaseNameForTableOrBuffer( hBuffer[1] )
    cTableName    = hBuffer[1]:table
    .
  
end. /* if bttQueryWindow.QueryHandle:num-buffers > 0 */

case piWindowMode:
  
  when {&K_QUERY_WINDOW_MODE_QUERY} then
  do:
    
    assign
      cIconFilename      = (if gcIconDir > '':U then
                              substitute('&1/32/table_go.ico':U,
                                         gcIconDir)
                            else
                              search('adeicon/startdbs.ico':U))
      cSmallIconFilename = (if gcIconDir > '':U then
                              substitute('&1/16/table_go.ico':U,
                                         gcIconDir)
                            else
                              '':U)
      .
    
    if not valid-handle(bttQueryWindow.QueryFrameHandle) then
    do:
      
      run qg_QueryWindowCreateQueryFrame(bttQueryWindow.WindowHandle).
      
      run qg_QueryWindowQuerySetQueryText(bttQueryWindow.WindowHandle,
                                          (if pcQueryText > '':U then
                                             pcQueryText
                                           else
                                             bttQueryWindow.QueryText),
                                          plFocusQueryText).
      
      run qg_QueryWindowRefreshBrowseColumns(bttQueryWindow.WindowHandle).
      
      run qg_QueryWindowQueryOpenFieldQuery(bttQueryWindow.WindowHandle).
      
    end. /* if not valid-handle(bttQueryWindow.QueryFrameHandle) */

    bttQueryWindow.WindowHandle:menu-bar = bttQueryWindow.QueryMenuHandle.

    if valid-handle(bttQueryWindow.RecordFrameHandle) then
      bttQueryWindow.RecordFrameHandle:visible = no.
    
    bttQueryWindow.QueryFrameHandle:visible = yes.
    
    run qg_QueryWindowQueryUpdateTitle(bttQueryWindow.WindowHandle).
    
    /* Only reposition browse if necessary. */
    
    RepositionBrowse:
    do i = 1 to bttQueryWindow.QueryHandle:num-buffers:
      
      if    i > extent(rCurrentRecord)
         or bttQueryWindow.QueryHandle:get-buffer-handle(i):rowid <> rCurrentRecord[i] then
      do:
        
        bttQueryWindow.QueryHandle:reposition-to-rowid(rCurrentRecord) no-error.
        leave RepositionBrowse.
        
      end. /* if    i > extent(rCurrentRecord) ... */
      
    end. /* do i = 1 to bttQueryWindow.QueryHandle:num-buffers */
    
    if plFocusQueryText then
      apply 'entry':U to bttQueryWindow.QueryTextEditorHandle.
    
    else
      apply 'entry':U to bttQueryWindow.QueryBrowseHandle.
    
  end. /* when {&K_QUERY_WINDOW_MODE_QUERY} */
  
  when {&K_QUERY_WINDOW_MODE_RECORD} then
  do:
    
    assign
      cIconFilename      = (if gcIconDir > '':U then
                              substitute('&1/32/table_analysis.ico':U,
                                         gcIconDir)
                            else
                              search('adeicon/dict%.ico':U))
      cSmallIconFilename = (if gcIconDir > '':U then
                              substitute('&1/16/table_analysis.ico':U,
                                         gcIconDir)
                            else
                              '':U)
      .
    
    if not valid-handle(bttQueryWindow.RecordFrameHandle) then
    do:
      
      run qg_QueryWindowCreateRecordFrame(bttQueryWindow.WindowHandle).
      
      run qg_QueryWindowRecordOpenQuery(bttQueryWindow.WindowHandle).
      
    end. /* if not valid-handle(bttQueryWindow.RecordFrameHandle) */
    
    bttQueryWindow.WindowHandle:menu-bar = bttQueryWindow.RecordMenuHandle.

    if valid-handle(bttQueryWindow.QueryFrameHandle) then
      bttQueryWindow.QueryFrameHandle:visible = no.
    
    bttQueryWindow.RecordFrameHandle:visible = yes.
    
    run qg_QueryWindowRecordRefresh(bttQueryWindow.WindowHandle).

  end. /* when {&K_QUERY_WINDOW_MODE_RECORD} */
  
end case. /* piWindowMode */

run qg_QueryWindowUpdateRawValuesMode( bttQueryWindow.WindowHandle ).

if cIconFilename > '':U then
  bttQueryWindow.WindowHandle:load-icon(cIconFilename).

if cSmallIconFilename > '':U then
  bttQueryWindow.WindowHandle:load-small-icon(cSmallIconFilename) no-error.

run qg_QueryWindowResize(bttQueryWindow.WindowHandle).

end procedure. /* qg_QueryWindowSetWindowMode */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowSetWindowState hQueryWindow 
PROCEDURE qg_QueryWindowSetWindowState :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Set query window state.                                                    */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* piSourceSeq                    = QuerySeq of the query window.             */
/* piWindowState                  = Window state that should be set.          */
/* plChildren                     = If yes the window state is set for        */
/*                                  linked child windows as well.             */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter piQuerySeq    as integer   no-undo.
define input parameter piWindowState as integer   no-undo.
define input parameter plChildren    as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow  for temp-table ttQueryWindow.
define buffer bttQueryLink    for temp-table ttQueryLink.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

find bttQueryWindow
  where bttQueryWindow.QuerySeq = piQuerySeq
  no-error.

if not available bttQueryWindow then
  leave.

bttQueryWindow.WindowHandle:window-state = piWindowState.

if plChildren then
do:

  for each bttQueryLink
    where bttQueryLink.SourceSeq = piQuerySeq,
  first bttQueryWindow
    where bttQueryWindow.QuerySeq = bttQueryLink.TargetSeq
    on error undo, throw:
    
    run qg_QueryWindowSetWindowState(bttQueryWindow.QuerySeq,
                                     piWindowState,
                                     yes).
    
  end. /* for each bttQueryLink */
  
end. /* if plChildren */

end procedure. /* qg_QueryWindowSetWindowState */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowShowAll hQueryWindow 
PROCEDURE qg_QueryWindowShowAll :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Show all query records (remove where clause).                              */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow    as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i          as integer   no-undo.
define variable hBuffer    as handle    no-undo.
define variable cQueryText as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if   bttQueryWindow.ObjSourceQuerySeq       > 0
  or not valid-handle(bttQueryWindow.QueryHandle)
  or bttQueryWindow.QueryHandle:num-buffers = 0 then
  leave.

do i = 1 to bttQueryWindow.QueryHandle:num-buffers:
  
  assign
    hBuffer = bttQueryWindow.QueryHandle:get-buffer-handle(1)
    cQueryText = (if i = 1 then
                    substitute('for each &1':U, hBuffer:name)
                  else
                    substitute(',~nfirst &1':U, hBuffer:name))
    .
  
end. /* do i = 1 to bttQueryWindow.WindowHandle:num-buffers */

bttQueryWindow.QueryTextEditorHandle:screen-value = cQueryText.

run qg_QueryWindowExecute(bttQueryWindow.WindowHandle, ?, yes).

end procedure. /* qg_QueryWindowShowAll */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowShowChildWindows hQueryWindow 
PROCEDURE qg_QueryWindowShowChildWindows :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Show all query windows that are linked to this query window.               */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* piSourceSeq                    = QuerySeq of the query window.             */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter piSourceSeq as integer   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow  for temp-table ttQueryWindow.
define buffer bttQueryLink    for temp-table ttQueryLink.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

for each bttQueryLink
  where bttQueryLink.SourceSeq = piSourceSeq,
first bttQueryWindow
  where bttQueryWindow.QuerySeq = bttQueryLink.TargetSeq
  on error undo, throw:
  
  run qg_QueryWindowShowChildWindows(bttQueryWindow.QuerySeq).
  
  run qg_ActivateWindow(bttQueryWindow.WindowHandle, ?).
  
end. /* for each bttQueryLink */

end procedure. /* qg_QueryWindowShowChildWindows */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowShowIndex hQueryWindow 
PROCEDURE qg_QueryWindowShowIndex :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Creates a dummy query for the given index and executes it.                 */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow       as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer       as handle    no-undo.
define variable cDatabaseName as character no-undo.
define variable cIndexName    as character no-undo.
define variable lOk           as logical   no-undo.
define variable cQueryText    as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttIndex       for temp-table ttIndex.
define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if    bttQueryWindow.ObjSourceQuerySeq        > 0
   or not valid-handle(bttQueryWindow.QueryHandle)
   or bttQueryWindow.QueryHandle:num-buffers <> 1 then
  leave.

assign
  hBuffer       = bttQueryWindow.QueryHandle:get-buffer-handle(1)
  cDatabaseName = qg_cDatabaseNameForTableOrBuffer( hBuffer )
  .

run qg_SelectIndex(cDatabaseName,
                   hBuffer:table,
                   input-output cIndexName,
                         output lOk,
                   bttQueryWindow.WindowHandle).

if lOk then
do:
  
  find bttIndex
    where bttIndex.DatabaseName = cDatabaseName
      and bttIndex.TableName    = hBuffer:table
      and bttIndex.IndexName    = cIndexName
    no-error.
  
  if available bttIndex then
  do:
    
    assign
      cQueryText = substitute( 'for each &1':U,
                               bttIndex.TableName )
      cQueryText = substitute( '&1~n&2~n':U,
                               cQueryText,
                               qg_cCreateWhereClause( /* pcDatabaseName   */ bttIndex.DatabaseName,
                                                      /* pcTableNames     */ bttIndex.TableName,
                                                      /* pcBufferNames    */ bttIndex.TableName,
                                                      /* pcFieldList      */ bttIndex.IndexFieldList,
                                                      /* pcFieldLabelList */ ?,
                                                      /* plStartWithWhere */ yes,
                                                      /* piValueMode      */ {&K_VALUE_MODE_DEFAULT_VALUE},
                                                      /* pcValueList      */ ?,
                                                      /* piAccessMode     */ {&K_ACCESS_MODE_PHYSICAL},
                                                      /* plAddTags        */ no,
                                                      /* piIndentBlanks   */ 2 ) )
      .
    
    run qg_QueryWindowQuerySetQueryText(bttQueryWindow.WindowHandle,
                                        cQueryText,
                                        yes).
    
    run qg_QueryWindowExecute(bttQueryWindow.WindowHandle, ?, no).
    
    apply 'entry':U to bttQueryWindow.QueryTextEditorHandle.
    
  end. /* if available bttIndex */
  
end. /* if lOk */

end procedure. /* qg_QueryWindowShowIndex */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowShowIndexInformation hQueryWindow 
PROCEDURE qg_QueryWindowShowIndexInformation :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Creates a dummy query for the given index and executes it.                 */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow       as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i              as integer   no-undo.
define variable j              as integer   no-undo.
define variable hQuery         as handle    no-undo.
define variable hBuffer        as handle    no-undo.

define variable cDatabaseName  as character no-undo.
define variable cIndexInfo     as character no-undo.
define variable cIndexName     as character no-undo.
define variable cIndexInfoText as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.
define buffer bttIndex       for temp-table ttIndex.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hQuery = bttQueryWindow.QueryHandle.

if not valid-handle(hQuery) then
  leave.

do i = 1 to hQuery:num-buffers:
  
  assign
    hBuffer       = hQuery:get-buffer-handle(i)
    cDatabaseName = qg_cDatabaseNameForTableOrBuffer( hBuffer )
    cIndexInfo    = hQuery:index-information(i)
    .
  
  cIndexInfoText = substitute('&1~n~n&2 &3':U,
                              cIndexInfoText,
                              gcBulletChar2,
                              hBuffer:name).
  
  do j = 1 to num-entries(cIndexInfo):
    
    cIndexName = entry(j, cIndexInfo).
    
    if cIndexName = 'WHOLE-INDEX':U then
      cIndexInfoText = substitute('&1   !!! &2 !!!':U,
                                  cIndexInfoText,
                                  cIndexName).
    
    else
    do:
      
      find bttIndex
        where bttIndex.DatabaseName = cDatabaseName
          and bttIndex.TableName    = hBuffer:table
          and bttIndex.IndexName = cIndexName
        no-error.
      
      if available bttIndex then
        cIndexInfoText = substitute('&1~n&2&3 Index &4: &5':U,
                                    cIndexInfoText,
                                    gcLineUpAndRight,
                                    gcBulletChar1,
                                    bttIndex.IndexName,
                                    bttIndex.IndexFields).
      
      else
        cIndexInfoText = substitute('&1~n    -> Index &2':U,
                                    cIndexInfoText,
                                    bttIndex.IndexName).
      
    end. /* if cIndexName = 'WHOLE-INDEX':U */
    
  end. /* if cIndexName = 'WHOLE-INDEX':U */
  
end. /* do i = 1 to hQuery:num-buffers */

message
  trim(cIndexInfoText, '~n':U) skip
  view-as alert-box
  information
  buttons ok
  in window bttQueryWindow.WindowHandle.

end procedure. /* qg_QueryWindowShowIndexInformation */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowShowQueryText hQueryWindow 
PROCEDURE qg_QueryWindowShowQueryText :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Show actual query text with resolved external tokens.                      */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cQueryText as character no-undo
  view-as editor
  no-word-wrap
  scrollbar-horizontal
  scrollbar-vertical
  size 146 by 14.5
  font 0.

define button btnClose
  label 'Close':T
  size 20 by 1.14
  auto-end-key.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if not valid-handle(bttQueryWindow.QueryHandle) then
  leave.

define frame fQueryText
  cQueryText at row 1.5 col 3 no-labels
  btnClose at row 16.5 col 66
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    side-labels no-underline three-d 
    size 151 by 18.44
    title gcTitlePrefix + 'Query text of query browse':T
    default-button btnClose
    cancel-button btnClose.

on window-close of frame fQueryText
  apply 'end-error' to self.

assign
  cQueryText                               = bttQueryWindow.QueryHandle:prepare-string
  cQueryText:read-only in frame fQueryText = yes
  .

update unless-hidden
  cQueryText
  btnClose
  with frame fQueryText
    in window bttQueryWindow.WindowHandle.

end procedure. /* qg_QueryWindowShowQueryText */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowSortByIndex hQueryWindow 
PROCEDURE qg_QueryWindowSortByIndex :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Add Sort options for a given index.                                        */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* pcDatabaseName                 = Database name.                            */
/* pcTableName                    = Table name.                               */
/* pcIndexName                    = Index name.                               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer        as handle    no-undo.
define variable cDatabaseName  as character no-undo.
define variable cIndexName     as character no-undo.
define variable lOk            as logical   no-undo.
define variable cSortFieldList as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

define buffer bttIndexField  for temp-table ttIndexField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if    bttQueryWindow.ObjSourceQuerySeq        > 0
   or not valid-handle(bttQueryWindow.QueryHandle)
   or bttQueryWindow.QueryHandle:num-buffers <> 1 then
  leave.

assign
  hBuffer       = bttQueryWindow.QueryHandle:get-buffer-handle(1)
  cDatabaseName = qg_cDatabaseNameForTableOrBuffer( hBuffer )
  .

run qg_SelectIndex(cDatabaseName,
                   hBuffer:table,
                   input-output cIndexName,
                         output lOk,
                   phWindow).

if lOk then
do:
  
  for each bttIndexField
    where bttIndexField.DatabaseName = cDatabasename
      and bttIndexField.TableName    = hBuffer:table 
      and bttIndexField.IndexName    = cIndexName
    by DatabaseName by TableName by IndexName by IndexSequence
    on error undo, throw:
    
    cSortFieldList = substitute('&1,&2.&3&4':U,
                                cSortFieldList,
                                bttIndexField.TableName,
                                bttIndexField.FieldName,
                                (if bttIndexField.SortAscending then
                                   '':U
                                 else
                                   ' descending':U)).
    
  end. /* for each bttIndexField */

  cSortFieldList = trim(cSortFieldList, ',':U).
  
  if num-entries(cSortFieldList) > 0 then
    run qg_QueryWindowAddSortFields(phWindow,
                                    cSortFieldList).
  
end. /* if lOk */

end procedure. /* qg_QueryWindowSortByIndex */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowToggleDeepResolve hQueryWindow 
PROCEDURE qg_QueryWindowToggleDeepResolve :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow   as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hFrame                     as handle    no-undo.
define variable hToggleDeepResolveMenuItem as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

assign
  hToggleDeepResolveMenuItem          = qg_hGetWidgetByName(phWindow:menu-bar,
                                                            'mi_DeepResolveObjectIds':U)
  bttQueryWindow.DeepResolveObjectIds = hToggleDeepResolveMenuItem:checked
  .

if    valid-handle(bttQueryWindow.QueryHandle)
  and bttQueryWindow.QueryHandle:num-results > 0
  and valid-handle(bttQueryWindow.QueryBrowseHandle) then
  bttQueryWindow.QueryBrowseHandle:refresh().

end procedure. /* qg_QueryWindowToggleDeepResolve */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowToggleRawValues hQueryWindow 
PROCEDURE qg_QueryWindowToggleRawValues :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the record window.              */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow         as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

bttQueryWindow.DisplayRawValues = not bttQueryWindow.DisplayRawValues.

if bttQueryWindow.DisplayRawValues then
  
  /* This flag will be set the first time "raw values" is set to true. Once   */
  /* we have been applying formats to columns we have to keep doing it,       */
  /* otherwise the display will not be correct.                               */
  
  bttQueryWindow.ApplyColumnFormats = yes.

run qg_QueryWindowUpdateRawValuesMode( bttQueryWindow.WindowHandle ).

end procedure. /* qg_QueryWindowToggleRawValues */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowToggleFieldList hQueryWindow 
PROCEDURE qg_QueryWindowToggleFieldList :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Toggle field list visibility.                                              */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow   as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hFrame                   as handle    no-undo.
define variable hToggleFieldBrowseButton as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

/* If the field selection browse should be displayed we first have to make    */
/* sure that it will fit into the frame to avoid errors.                      */

if bttQueryWindow.QueryFieldBrowseHandle:hidden then
  assign
    hFrame                            = qg_hGetWidgetByName(phWindow, 'fQuery':U)
    bttQueryWindow.WindowHandle:width = max(100, bttQueryWindow.WindowHandle:width)
    hFrame:width                      = bttQueryWindow.WindowHandle:width
    bttQueryWindow.QueryFieldBrowseHandle:height = 3
    bttQueryWindow.QueryFieldBrowseHandle:col    = max(1, bttQueryWindow.WindowHandle:width - 72)
    no-error.
  
/* Now we can toggle the hidden state. */

assign
  bttQueryWindow.QueryFieldBrowseHandle:hidden = not bttQueryWindow.QueryFieldBrowseHandle:hidden
  hToggleFieldBrowseButton         = qg_hGetWidgetByName(phWindow, 'btnToggleFieldBrowse':U)
  hToggleFieldBrowseButton:label   = (if bttQueryWindow.QueryFieldBrowseHandle:hidden then
                                        '<':T
                                      else
                                        '>':T)
  hToggleFieldBrowseButton:tooltip                 = (if bttQueryWindow.QueryFieldBrowseHandle:hidden then
                                        'Show field list':T
                                      else
                                        'Hide field List':T)
  .

run qg_QueryWindowResize(bttQueryWindow.WindowHandle).

end procedure. /* qg_QueryWindowToggleFieldList */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowUpdate hQueryWindow 
PROCEDURE qg_QueryWindowUpdate :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Execute current query text of given query window.                          */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Window handle of the query window that    */
/*                                  should be updated.                        */
/* pcForceUpdateWindowList        = List of window handles that should be up- */
/*                                  dated even if the query text is un-       */
/*                                  changed.                                  */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow                as handle    no-undo.
define input parameter pcForceUpdateWindowList as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cQueryText as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

/* Additional do block to ensure that bttQueryWindow will be available in     */
/* finally block.                                                             */

do on error undo, throw:
  
  phWindow:title = substitute('&1 (updating ...)':U, bttQueryWindow.WindowTitle).
  
  if bttQueryWindow.ObjSourceQuerySeq > 0 then
    run qg_QueryWindowObjUpdateQuery(bttQueryWindow.WindowHandle).
  
  if not valid-handle(bttQueryWindow.QueryHandle) then
    leave.
  
  cQueryText = qg_cSubstituteQueryLinkTokens(bttQueryWindow.WindowHandle).
  
  if   can-do(pcForceUpdateWindowList, string(bttQueryWindow.WindowHandle))
    or cQueryText <> bttQueryWindow.QueryHandle:prepare-string
    or not bttQueryWindow.QueryHandle:is-open then
  do:
    
    if    cQueryText > '':U
      and bttQueryWindow.QueryHandle:num-buffers > 0 then
    do:
      
      qg_lQueryOpen(bttQueryWindow.QueryHandle,
                    cQueryText,
                    bttQueryWindow.WindowHandle).
      
      run qg_AddRecentQuery(bttQueryWindow.WindowHandle).
      
    end. /* if    cQueryText > 0 */
    
    if bttQueryWindow.WindowMode = {&K_QUERY_WINDOW_MODE_RECORD} then
    do:
      
      if    bttQueryWindow.QueryHandle:is-open
        and bttQueryWindow.QueryHandle:num-results = 0 then
        bttQueryWindow.QueryHandle:get-first().
      
      run qg_QueryWindowRecordRefresh(bttQueryWindow.WindowHandle).
      
    end. /* if bttQueryWindow.WindowMode = {&K_QUERY_WINDOW_MODE_RECORD} */
    
  end. /* if   can-do(pcForceUpdateWindowList, string(bttQueryWindow.WindowHandle)) ... */
  
  finally:
    
    if    valid-handle(phWindow)
      and bttQueryWindow.WindowTitle > '':U then
      phWindow:title = bttQueryWindow.WindowTitle.
    
  end finally.
  
end.

end procedure. /* qg_QueryWindowUpdate */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowUpdateAll hQueryWindow 
PROCEDURE qg_QueryWindowUpdateAll :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Refresh all Query windows.                                                 */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcForceUpdateWindowList as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow            for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

/* Check for circular references and reset update flags. */

for each bttQueryWindow
  on error undo, throw:
  
  if not qg_lCheckLinkReference(bttQueryWindow.QuerySeq, '':U) then
  do:
    
    message /* code checked by mth */
      substitute('Circular reference detected in Query window &1':T,
                 string(bttQueryWindow.QuerySeq)) skip
      view-as alert-box
      error
      buttons ok
      in window bttQueryWindow.WindowHandle.
    
    return error.
    
  end. /* not qg_lCheckLinkReference(bttQueryWindow.QuerySeq, '':U) */
  
  bttQueryWindow.Updated = no.
  
end. /* for each bttQueryWindow */

/* Refresh query windows. */

for each bttQueryWindow
  where not can-find(first ttQueryLink
                       where ttQueryLink.SourceSeq = bttQueryWindow.QuerySeq)
  on error undo, throw:
  
  if valid-handle(bttQueryWindow.WindowHandle) then
    run qg_QueryWindowUpdateRecursive(bttQueryWindow.WindowHandle,
                                      pcForceUpdateWindowList).
  
end. /* for each bttQueryWindow */

end procedure. /* qg_QueryWindowUpdateAll */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowUpdateRawValuesMode hQueryWindow 
PROCEDURE qg_QueryWindowUpdateRawValuesMode :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Update all query windows that are linked to given query window.            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* pcForceUpdateWindowList        = List of window handles that should be up- */
/*                                  dated even if the query text is un-       */
/*                                  changed.                                  */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hRawValues as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow  for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave. 

validate bttQueryWindow.

case bttQueryWindow.WindowMode:
  
  when {&K_QUERY_WINDOW_MODE_QUERY} then
  do:
    
    hRawValues = qg_hGetWidgetByName( phWindow:menu-bar,
                                      'mi_RawValues':U ).
    
    if valid-handle( hRawValues ) then
      
      hRawValues:checked = bttQueryWindow.DisplayRawValues.
    
    if bttQueryWindow.QueryHandle:num-results > 0 then
  
      bttQueryWindow.QueryBrowseHandle:refresh().
    
  end. /* when {&K_QUERY_WINDOW_MODE_QUERY} */
  
  when {&K_QUERY_WINDOW_MODE_RECORD} then
  do:
    
    hRawValues = qg_hGetWidgetByName( bttQueryWindow.RecordFrameHandle,
                                      'lRawValues':U ).
    
    if valid-handle(hRawValues) then
      
      hRawValues:screen-value = string(bttQueryWindow.DisplayRawValues).
    
    run qg_QueryWindowRecordUpdateValues( bttQueryWindow.WindowHandle ).
    
  end. /* when {&K_QUERY_WINDOW_MODE_RECORD} */
  
end case. /* if not available bttQueryWindow */

end procedure. /* qg_QueryWindowUpdateRawValuesMode */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowUpdateRecursive hQueryWindow 
PROCEDURE qg_QueryWindowUpdateRecursive :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Update all query windows that are linked to given query window.            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* pcForceUpdateWindowList        = List of window handles that should be up- */
/*                                  dated even if the query text is un-       */
/*                                  changed.                                  */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow                as handle    no-undo.
define input parameter pcForceUpdateWindowList as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow  for temp-table ttQueryWindow.
define buffer b2ttQueryWindow for temp-table ttQueryWindow.
define buffer bttQueryLink    for temp-table ttQueryLink.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave. 

if bttQueryWindow.Updated then
  leave.

for each bttQueryLink
  where bttQueryLink.TargetSeq = bttQueryWindow.QuerySeq,
first b2ttQueryWindow
  where b2ttQueryWindow.QuerySeq = bttQueryLink.SourceSeq
  break by bttQueryLink.SourceSeq
  on error undo, throw:
  
  if first-of(bttQueryLink.SourceSeq) then
    run qg_QueryWindowUpdateRecursive(b2ttQueryWindow.WindowHandle,
                                      pcForceUpdateWindowList).
  
end. /* for each bttQueryLink */

run qg_QueryWindowUpdate(bttQueryWindow.WindowHandle,
                         pcForceUpdateWindowList).

bttQueryWindow.Updated = yes.

end procedure. /* qg_QueryWindowUpdateRecursive */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowViewMenuDrop hQueryWindow 
PROCEDURE qg_QueryWindowViewMenuDrop :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow                as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hFieldSelectionBrowse as handle    no-undo.

define variable hMenu                 as handle    no-undo.
define variable hFieldListMenuItem    as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow  for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave. 

assign
  hMenu = bttQueryWindow.WindowHandle:menu-bar
  hFieldSelectionBrowse
      = qg_hGetWidgetByName(bttQueryWindow.WindowHandle,
                          'brFieldSelection':U)
  hFieldListMenuItem
      = qg_hGetWidgetByName(hMenu, 'mi_FieldList':U)
  hFieldListMenuItem:checked
      = hFieldSelectionBrowse:visible
  .

end procedure. /* qg_QueryWindowViewMenuDrop */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowWindowMenuDrop hQueryWindow 
PROCEDURE qg_QueryWindowWindowMenuDrop :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow                as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow  for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave. 

/* Nothing to do here right now. Maybe this can be deleted. */


end procedure. /* qg_QueryWindowWindowMenuDrop */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_RemoveInvalidOverlayColumns Method-Library
procedure qg_RemoveInvalidOverlayColumns :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define parameter buffer pbttQueryWindow for temp-table ttQueryWindow.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttFieldOverlay for temp-table ttFieldOverlay.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

for each bttFieldOverlay
  where bttFieldOverlay.OwnerHandle = pbttQueryWindow.QueryHandle
  break by bttFieldOverlay.BufferName
  on error undo, throw:
  
  if first-of( bttFieldOverlay.BufferName ) then
    
    hBuffer = pbttQueryWindow.QueryHandle:get-buffer-handle( bttFieldOverlay.BufferName ) no-error.
  
  if    not valid-handle( hBuffer )
     or not can-find( first ttQueryWindowField
                        where ttQueryWindowField.WindowHandle = pbttQueryWindow.WindowHandle
                          and ttQueryWindowField.BufferName   = bttFieldOverlay.BufferName
                          and ttQueryWindowField.FieldName    = bttFieldOverlay.FieldName
                          and ttQueryWindowField.FieldIndex   = bttFieldOverlay.FieldIndex
                          and ttQueryWindowField.IsOverlay    = no ) then
    
    run qg_DeleteFieldOverlay( bttFieldOverlay.OwnerHandle,
                               bttFieldOverlay.BufferName,
                               bttFieldOverlay.FieldName,
                               bttFieldOverlay.FieldIndex ).
  
  if last-of( bttFieldOverlay.BufferName ) then
    
    hBuffer = ?.
  
end. /* for each bttFieldOverlay */

end procedure. /* qg_RemoveInvalidOverlayColumns */


/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

/* <<< Include: incl/query_window.i <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

/* >>> Include: incl/virtual_fields.i >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> */
/*------------------------------------------------------------------------
    File        : virtual_fields.i
    Purpose     : 

    Syntax      :

    Description : 

    Author(s)   : Thiemann_M
    Created     : Tue Apr 05 13:54:45 CEST 2022
    Notes       :
  ----------------------------------------------------------------------*/


/* **********************  Internal Procedures  *********************** */

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddTableVirtualDBFields Method-Library
procedure qg_AddTableVirtualDBFields :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define parameter buffer pbttDatabase for temp-table ttDatabase.
define parameter buffer pbttTable    for temp-table ttTable. 

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hRepVirtualFieldBuffer as handle    no-undo.
define variable hRepDomainBuffer       as handle    no-undo.
define variable hRepVirtualFieldQuery  as handle    no-undo.

define variable cQueryText             as character no-undo.

define variable cDataType              as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttField for temp-table ttField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

create buffer hRepVirtualFieldBuffer for table substitute( '&1.DRC_VirtualField':U, pbttDatabase.BasisDBName ).
create buffer hRepDomainBuffer for table substitute( '&1.DRC_Domain':U, pbttDatabase.BasisDBName ).

create query hRepVirtualFieldQuery.

hRepVirtualFieldQuery:set-buffers( hRepVirtualFieldBuffer, hRepDomainBuffer ).

cQueryText =            'for each DRC_VirtualField':U
             + '~n':U + '  where DRC_VirtualField.DRC_Table_Obj = &1':U
             + '~n':U + '    and DRC_VirtualField.&2            = yes':U
             + '~n':U + '  no-lock,':U
             + '~n':U + 'first DRC_Domain left outer-join':U
             + '~n':U + '  where DRC_Domain.DRC_Domain_Obj = DRC_VirtualField.DRC_Domain_Obj':U
             + '~n':U + '  no-lock':U.
             .

hRepVirtualFieldQuery:query-prepare( substitute( cQueryText,
                                                 quoter( pbttTable.RepObjectId ),
                                                 gcVirtualDBFieldReposFlagFieldName ) ).

hRepVirtualFieldQuery:query-open().

hRepVirtualFieldQuery:get-first().

do while not hRepVirtualFieldQuery:query-off-end:
  
  create bttField.
  
  assign
    bttField.DatabaseName      = pbttDatabase.DatabaseName
    bttField.TableName         = pbttTable.TableName
    bttField.FieldName         = hRepVirtualFieldBuffer::DRC_VirtualField_ID
    bttField.RepObjectId       = hRepVirtualFieldBuffer::DRC_VirtualField_Obj
    cDataType                  = dynamic-function( 'pa_cReposDomainInformationByObj':U,
                                                   hRepDomainBuffer::DRC_Domain_Obj,
                                                   'DATA-TYPE':U )
    bttField.DataType          = substitute( '&1&2':U,
                                             caps( substring( cDataType, 1, 1 ) ),
                                             lc( substring( cDataType, 2 ) ) )
    bttField.FieldExtent       = dynamic-function( 'pa_cReposDomainInformationByObj':U,
                                                   hRepDomainBuffer::DRC_Domain_Obj,
                                                   'EXTENT':U )
    bttField.FieldInitialValue = dynamic-function( 'pa_cReposDomainInformationByObj':U,
                                                   hRepDomainBuffer::DRC_Domain_Obj,
                                                   'INITIAL':U )
    bttField.FieldLabel        = dynamic-function( 'pa_cReposDomainInformationByObj':U,
                                                   hRepDomainBuffer::DRC_Domain_Obj,
                                                   'LABEL':U )
    bttField.FieldColumnLabel  = dynamic-function( 'pa_cReposDomainInformationByObj':U,
                                                   hRepDomainBuffer::DRC_Domain_Obj,
                                                   'COLUMN-LABEL':U )
    bttField.FieldDecimals     = dynamic-function( 'pa_cReposDomainInformationByObj':U,
                                                   hRepDomainBuffer::DRC_Domain_Obj,
                                                   'DECIMALS':U )
    bttField.FieldFormat       = dynamic-function( 'pa_cReposDomainInformationByObj':U,
                                                   hRepDomainBuffer::DRC_Domain_Obj,
                                                   'FORMAT':U )
    bttField.IsMandatory       = dynamic-function( 'pa_cReposDomainInformationByObj':U,
                                                   hRepDomainBuffer::DRC_Domain_Obj,
                                                   'MANDATORY':U )
    bttField.Domain            = (if hRepDomainBuffer:available then
                                    hRepDomainBuffer::DRC_Domain_ID
                                  else
                                    '':U)
    bttField.IsObjectId        = (     bttField.FieldName matches '*_Obj':U
                                    or lookup(bttField.Domain, {&K_OBJECT_ID_DOMAIN}) > 0 )
    bttField.FieldType         = {&K_FIELD_TYPE_VIRTUAL_DB_FIELD}
    bttField.IsVirtual         = yes
    .
  
  /* Attribute "VIEW-AS" is only available in development mode. To avoid      */
  /* errors when running in production mode we use "no-error" to assign this  */
  /* specific attribute.                                                      */
  
  bttField.FieldViewAs = dynamic-function( 'pa_cReposDomainInformationByObj':U,
                                           hRepDomainBuffer::DRC_Domain_Obj,
                                           'VIEW-AS':U ) no-error.
  
  /* An empty initial value for logical fields is interpreted as "no"   */
  /* by the database. Therefore we simulate this behaviour for virtual  */
  /* fields.                                                            */
  
  if    bttField.DataType          = 'logical':U
    and bttField.FieldInitialValue = '':U then
    
    bttField.FieldInitialValue = 'no':U.
  
  /* The "initial" attribute for date fields allways has to have the US       */
  /* format "mm/dd/yyyy" (or "today/now" or ?)                                */

  else if    cDataType                  begins  'date':U
         and bttField.FieldInitialValue matches '*/*/*':U then
    
    bttField.FieldInitialValue = qg_cDateStringFormUSFormat( bttField.FieldInitialValue ).
  
  if    bttField.FieldLabel = ?
     or bttField.FieldLabel = '':U then
    
    bttField.FieldLabel = bttField.FieldName.
  
  if    bttField.FieldColumnLabel = ?
     or bttField.FieldColumnLabel = '':U then
    
    bttField.FieldColumnLabel = bttField.FieldLabel.
  
  hRepVirtualFieldQuery:get-next().
  
end. /* do while not hRepVirtualFieldQuery:query-off-end */

catch oError as class progress.lang.error:
  return.
end catch. /* progress.lang.error */

finally:
  
  if valid-handle( hRepVirtualFieldQuery ) then
    
    delete object hRepVirtualFieldQuery no-error.
  
  if valid-handle( hRepDomainBuffer ) then
    
    delete object hRepDomainBuffer no-error.
  
  if valid-handle( hRepVirtualFieldBuffer ) then
    
    delete object hRepVirtualFieldBuffer no-error.
  
end finally.

end procedure. /* qg_AddTableVirtualDBFields */


/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddVirtualFieldsToBufferComparisonBuffer Method-Library
procedure qg_AddVirtualFieldsToBufferComparisonBuffer :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcDatabaseName as character no-undo.
define input parameter phBuffer       as handle    no-undo.
define input parameter piBufferNo     as integer   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cObjectIdValue     as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttField                 for temp-table ttField.

define buffer bttBufferComparisonField for temp-table ttBufferComparisonField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not phBuffer:available then
  
  return.

if not qg_lIsPhysicalDatabase( phBuffer:dbname ) then
  
  return.

cObjectIdValue = qg_cObjectIdForBuffer( phBuffer ).

for each bttField
  where bttField.DatabaseName = pcDatabaseName
    and bttField.TableName    = phBuffer:table
    and bttField.IsVirtual    = yes
  on error undo, throw:
  
  find bttBufferComparisonField
    where bttBufferComparisonField.BufferNo   = piBufferNo
      and bttBufferComparisonField.FieldName  = bttField.FieldName
      and bttBufferComparisonField.FieldIndex = 0
    no-error.
  
  if not available bttBufferComparisonField then
  do:
    
    create bttBufferComparisonField.
    
    assign
      bttBufferComparisonField.BufferNo   = piBufferNo
      bttBufferComparisonField.FieldName  = bttField.FieldName
      bttBufferComparisonField.FieldIndex = 0
      .
    
  end. /* if not available bttBufferComparisonField */
  
  assign
    bttBufferComparisonField.DatabaseName = pcDatabaseName
    bttBufferComparisonField.TableName    = phBuffer:table
    bttBufferComparisonField.BufferName   = phBuffer:name
    bttBufferComparisonField.DataType     = bttField.DataType
    bttBufferComparisonField.FieldFormat  = bttField.FieldFormat
    bttBufferComparisonField.IsVirtual    = bttField.IsVirtual
    bttBufferComparisonField.FieldType    = bttField.FieldType
    bttBufferComparisonField.FieldValue   = qg_clVirtualFieldValueAsLongchar( bttField.FieldType,
                                                                              bttField.DataType,
                                                                              bttField.FieldName,
                                                                              cObjectIdValue,
                                                                              ? ).
    .
  
  
  validate bttBufferComparisonField.
  
end. /* for each bttField */

end procedure. /* qg_AddVirtualFieldsToBufferComparisonBuffer */


/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddVirtualFieldsToTempTable Method-Library
procedure qg_AddVirtualFieldsToTempTable :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcDatabaseName as character no-undo.
define input parameter pcTableName    as character no-undo.
define input parameter phTempTable    as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttField for temp-table ttField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

for each bttField
  where bttField.DatabaseName = pcDatabaseName
    and bttField.TableName    = pcTableName
    and bttField.IsVirtual    = yes
  on error undo, throw:
  
  case bttField.FieldType:
    
    when {&K_FIELD_TYPE_VIRTUAL_DB_FIELD} then
      
      phTempTable:add-new-field( bttField.FieldName,
                                 bttField.DataType,
                                 bttField.FieldExtent,
                                 bttField.FieldFormat,
                                 bttField.FieldInitialValue,
                                 bttField.FieldLabel,
                                 bttField.FieldColumnLabel ).
    
  end case. /* bttField.FieldType */
  
end. /* for each bttField */

end procedure. /* qg_AddVirtualFieldsToTempTable */


/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_BufferCopyVirtualFieldsFromPhysicalBufferToTempTableBuffer Method-Library
procedure qg_BufferCopyVirtualFieldsFromPhysicalBufferToTempTableBuffer :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcDatabaseName    as character no-undo.
define input parameter phPhysicalBuffer  as handle    no-undo.
define input parameter phTempTableBuffer as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cObjectIdValue  as character no-undo.
define variable cMethodName     as character no-undo.
define variable hTempTableField as handle    no-undo.

define variable clFieldValue as longchar  no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttField for temp-table ttField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

cObjectIdValue = qg_cObjectIdForBuffer( phPhysicalBuffer ).

if error-status:error then
  
  return.

for each bttField
  where bttField.DatabaseName = pcDatabaseName
    and bttField.TableName    = phPhysicalBuffer:table
    and bttField.IsVirtual    = yes
  on error undo, throw:
  
  hTempTableField = phTempTableBuffer:buffer-field( bttField.FieldName ) no-error.
  
  if not valid-handle( hTempTableField ) then
    
    next.
  
  case bttField.FieldType:
    
    when {&K_FIELD_TYPE_VIRTUAL_DB_FIELD} then
      
      assign
        cMethodName                  = dynamic-invoke( qg_oVirtualDBFieldDataApiInstance(),
                                                       'cMethodNameByDataType':U,
                                                       bttField.DataType )
        hTempTableField:buffer-value = dynamic-invoke( qg_oVirtualDBFieldDataApiInstance(),
                                                       cMethodName,
                                                       cObjectIdValue,
                                                       bttField.FieldName )
        .
    
  end case. /* bttField.FieldType */
  
end. /* for each bttField */

end procedure. /* qg_BufferCopyVirtualFieldsFromPhysicalBufferToTempTableBuffer */


/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_BufferCopyVirtualFieldsFromTempTableBufferToPhysicalBuffer Method-Library
procedure qg_BufferCopyVirtualFieldsFromTempTableBufferToPhysicalBuffer :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcDatabaseName    as character no-undo.
define input parameter phTempTableBuffer as handle    no-undo.
define input parameter phPhysicalBuffer  as handle    no-undo.
define input parameter plDisabelTriggers as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cObjectIdValue           as character no-undo.
define variable hTempTableField          as handle    no-undo.
define variable cVirtualFieldTableName as character no-undo.
define variable hVirtualFieldTableBuffer as handle    no-undo.

define variable clFieldValue             as longchar  no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttField for temp-table ttField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

cObjectIdValue = qg_cObjectIdForBuffer( phPhysicalBuffer ).

if error-status:error then
  
  return.

for each bttField
  where bttField.DatabaseName = pcDatabaseName
    and bttField.TableName    = phPhysicalBuffer:table
    and bttField.IsVirtual    = yes
    and bttField.FieldType    = {&K_FIELD_TYPE_VIRTUAL_DB_FIELD}
  break by bttField.DataType
  on error undo, throw:
  
  if    first-of( bttField.DataType )
    and plDisabelTriggers then
  do:
    
    cVirtualFieldTableName = dynamic-invoke( qg_oVirtualDBFieldDataFieldApiInstance(),
                                             'cTableNameByDataType':U,
                                             bttField.DataType ).
    
    create buffer hVirtualFieldTableBuffer for table cVirtualFieldTableName.
    
    hVirtualFieldTableBuffer:disable-load-triggers( no ).
    
  end. /* if first-of bttField.DataType */
  
  hTempTableField = phTempTableBuffer:buffer-field( bttField.FieldName ) no-error.
  
  if not valid-handle( hTempTableField ) then
    
    next.
  
  case bttField.DataType:
    
    when 'clob':U then
    do:
      
      copy-lob from hTempTableField:buffer-field( bttField.FieldName ):buffer-value
        to clFieldValue
        .
      
      dynamic-invoke( qg_oVirtualDBFieldDataApiInstance(),
                      'setValue':U,
                      cObjectIdValue,
                      bttField.FieldName,
                      clFieldValue ).
      
    end. /* when 'clob':U */
    
    otherwise
      
      dynamic-invoke( qg_oVirtualDBFieldDataApiInstance(),
                      'setValue':U,
                      cObjectIdValue,
                      bttField.FieldName,
                      hTempTableField:buffer-value ).
    
  end case. /* bttField.DataType */
  
  if    last-of( bttField.DataType )
    and plDisabelTriggers
    and valid-handle( hVirtualFieldTableBuffer ) then
    
    delete object hVirtualFieldTableBuffer.
  
end. /* for each bttField */

end procedure. /* qg_BufferCopyVirtualFieldsFromTempTableBufferToPhysicalBuffer */


/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_CreateVirtualFieldColumn Method-Library
procedure qg_CreateVirtualFieldColumn :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define parameter buffer pbttQueryWindow      for temp-table ttQueryWindow.
define parameter buffer pbttQueryWindowField for temp-table ttQueryWindowField.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hVirtualFieldColumn as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttField              for temp-table ttField.
define buffer bttVirtualFieldColumn for temp-table ttVirtualFieldColumn.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle( pbttQueryWindowField.BufferHandle ) then
  
  return.

find first bttField
  where bttField.DatabaseName = pbttQueryWindowField.DatabaseName
    and bttField.TableName    = pbttQueryWindowField.BufferHandle:table
    and bttField.FieldName    = pbttQueryWindowField.FieldName
  no-error.

if not available bttField then
  
  return.

find bttVirtualFieldColumn
  where bttVirtualFieldColumn.OwnerHandle = pbttQueryWindow.QueryHandle
    and bttVirtualFieldColumn.BufferName  = pbttQueryWindowField.BufferName
    and bttVirtualFieldColumn.FieldName   = pbttQueryWindowField.FieldName
    and bttVirtualFieldColumn.FieldIndex  = pbttQueryWindowField.FieldIndex
  no-error.

if not available bttVirtualFieldColumn then
do:
  
  create bttVirtualFieldColumn.
  
  assign
    bttVirtualFieldColumn.OwnerHandle  = pbttQueryWindow.QueryHandle
    bttVirtualFieldColumn.BufferName   = pbttQueryWindowField.BufferName
    bttVirtualFieldColumn.FieldName    = pbttQueryWindowField.FieldName
    bttVirtualFieldColumn.FieldIndex   = pbttQueryWindowField.FieldIndex
    bttVirtualFieldColumn.DataType     = pbttQueryWindowField.DataType
    bttVirtualFieldColumn.FieldType    = pbttQueryWindowField.FieldType
    bttVirtualFieldColumn.FieldFormat  = pbttQueryWindowField.FieldFormat
    .
  
end. /* if not available bttVirtualFieldColumn */

assign
  bttVirtualFieldColumn.BufferHandle = pbttQueryWindowField.BufferHandle
  hVirtualFieldColumn                = pbttQueryWindow.QueryBrowseHandle:add-calc-column
                                         ( bttField.DataType,
                                           bttField.FieldFormat,
                                           bttField.FieldInitialValue,
                                           bttField.FieldColumnLabel )
  hVirtualFieldColumn:name           = qg_cFormattedFieldName( /* pcDatabaseName */ ?,
                                                               /* pcTableName    */ pbttQueryWindowField.BufferName,
                                                               /* pcFieldName    */ pbttQueryWindowField.FieldName,
                                                               /* piIndex        */ pbttQueryWindowField.FieldIndex )
  hVirtualFieldColumn:label-fgcolor  = {&K_VIRTUAL_DB_FIELD_FGCOLOR}
  bttVirtualFieldColumn.ColumnHandle = hVirtualFieldColumn
  .

validate bttVirtualFieldColumn.

end procedure. /* qg_CreateVirtualFieldColumn */


/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_CreateVirtualFieldColumnsForBuffer Method-Library
procedure qg_CreateVirtualFieldColumnsForBuffer:
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define parameter buffer pbttQueryWindow for temp-table ttQueryWindow.

define input parameter piBufferId as integer   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hVirtualFieldColumn as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindowField for temp-table ttQueryWindowField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

for each bttQueryWindowField
  where bttQueryWindowField.WindowHandle = pbttQueryWindow.WindowHandle
    and bttQueryWindowField.BufferId     = piBufferId
    and bttQueryWindowField.IsOverlay    = no
    and bttQueryWindowField.IsVirtual    = yes
  on error undo, throw:
  
  run qg_CreateVirtualFieldColumn( buffer pbttQueryWindow,
                                   buffer bttQueryWindowField ).
  
end. /* for each bttQueryWindowField */

end procedure. /* qg_CreateVirtualFieldColumnsForBuffer */


/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_DeleteVirtualFieldRecordsForRecord Method-Library
procedure qg_DeleteVirtualFieldRecordsForRecord :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcDatabaseName    as character no-undo.
define input parameter phPhysicalBuffer  as handle    no-undo.
define input parameter plDisableTriggers as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cVirtualFieldTableName   as character no-undo.
define variable hVirtualFieldTableBuffer as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttField for temp-table ttField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not can-find( first ttField
                   where ttField.DatabaseName = pcDatabaseName
                     and ttField.TableName    = phPhysicalBuffer:table
                     and ttField.IsVirtual    = yes ) then
  
  return.

if plDisableTriggers then
  
  for each bttField
    where bttField.DatabaseName = pcDatabaseName
      and bttField.TableName    = phPhysicalBuffer:table
      and bttField.IsVirtual    = yes
    break by bttField.DataType:
    
    if first-of( bttField.DataType ) then
    do on error undo, throw:
      
      cVirtualFieldTableName = dynamic-invoke( qg_oVirtualDBFieldDataFieldApiInstance(),
                                               'cTableNameByDataType':U,
                                               bttField.DataType ).
      
      create buffer hVirtualFieldTableBuffer for table cVirtualFieldTableName.
      
      hVirtualFieldTableBuffer:disable-load-triggers( no ).
      
      finally:
        
        if valid-handle( hVirtualFieldTableBuffer ) then
          
          delete object hVirtualFieldTableBuffer.
        
      end finally.
      
    end. /* if first-of( bttField.DataType ) */
    
  end. /* for each bttField */

dynamic-invoke( qg_oVirtualDBFieldDataApiInstance(),
                'deleteAllForOID':U,
                qg_cObjectIdForBuffer( phPhysicalBuffer ) ).

end procedure. /* qg_DeleteVirtualFieldRecordsForRecord */


/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_InitializeVirtualDBFieldFramework Method-Library
procedure qg_InitializeVirtualDBFieldFramework :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable oVirtualDBFieldDataApiInstance as class progress.lang.object no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

oVirtualDBFieldDataApiInstance = qg_oVirtualDBFieldDataApiInstance().

if valid-object( oVirtualDBFieldDataApiInstance ) then
  
  case oVirtualDBFieldDataApiInstance:GetClass():TypeName:
    
    when 'basis.base.cls.BMCAddDataSvc':U then
      
      gcVirtualDBFieldReposFlagFieldName = 'AdditionalDBField':U.
    
    when 'x.adm.cls.XDCAddDataSvc':U then
      
      gcVirtualDBFieldReposFlagFieldName = 'xDB-Field':U.
    
  end case. /* oVirtualDBFieldDataApiInstance:GetClass():TypeName */
  
end procedure. /* qg_InitializeVirtualDBFieldFramework */


/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_RemoveInvalidVirtualFieldColumns Method-Library
procedure qg_RemoveInvalidVirtualFieldColumns :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define parameter buffer pbttQueryWindow for temp-table ttQueryWindow.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttVirtualFieldColumn for temp-table ttVirtualFieldColumn.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

for each bttVirtualFieldColumn
  where bttVirtualFieldColumn.OwnerHandle = pbttQueryWindow.QueryHandle
  break by bttVirtualFieldColumn.BufferName
  on error undo, throw:
  
  if first-of( bttVirtualFieldColumn.BufferName ) then
    
    hBuffer = pbttQueryWindow.QueryHandle:get-buffer-handle( bttVirtualFieldColumn.BufferName ) no-error.
  
  if    not valid-handle( hBuffer )
     or not can-find( first ttQueryWindowField
                        where ttQueryWindowField.WindowHandle = pbttQueryWindow.WindowHandle
                          and ttQueryWindowField.BufferName   = bttVirtualFieldColumn.BufferName
                          and ttQueryWindowField.FieldName    = bttVirtualFieldColumn.FieldName
                          and ttQueryWindowField.FieldIndex   = bttVirtualFieldColumn.FieldIndex
                          and ttQueryWindowField.IsOverlay    = no ) then
    
    run qg_RemoveVirtualFieldColumn( bttVirtualFieldColumn.OwnerHandle,
                                     bttVirtualFieldColumn.BufferName,
                                     bttVirtualFieldColumn.FieldName,
                                     bttVirtualFieldColumn.FieldIndex ).
  
  if last-of( bttVirtualFieldColumn.BufferName ) then
    
    hBuffer = ?.
  
end. /* for each bttFieldOverlay */

end procedure. /* qg_RemoveInvalidVirtualFieldColumns */


/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_RemoveVirtualFieldColum Method-Library
procedure qg_RemoveVirtualFieldColum :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define parameter buffer pbttVirtualFieldColumn for temp-table ttVirtualFieldColumn.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if valid-handle( pbttVirtualFieldColumn.ColumnHandle ) then
  
  delete object pbttVirtualFieldColumn.ColumnHandle no-error.

delete pbttVirtualFieldColumn.

end procedure. /* qg_RemoveVirtualFieldColum */


/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_RemoveVirtualFieldColums Method-Library
procedure qg_RemoveAllVirtualFieldColums :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define parameter buffer pbttQueryWindow for temp-table ttQueryWindow.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttVirtualFieldColumn for temp-table ttVirtualFieldColumn.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

for each bttVirtualFieldColumn
where bttVirtualFieldColumn.OwnerHandle = pbttQueryWindow.QueryHandle
  on error undo, throw:
  
  run qg_RemoveVirtualFieldColum( buffer bttVirtualFieldColumn ).
  
end. /* for each bttVirtualFieldColumn */

end procedure. /* qg_RemoveVirtualFieldColums */


/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME



/* ************************  Function Implementations ***************** */

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION qg_cBufferCompareVirtualFields Method-Library
function qg_cBufferCompareVirtualFields returns character 
  ( phBuffer1 as handle,
    phBuffer2 as handle ):
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cDatabaseName1       as character no-undo.
define variable lDatabase1IsPhysical as logical   no-undo.
define variable cObjectIdValue1      as character no-undo.

define variable cDatabaseName2       as character no-undo.
define variable lDatabase2IsPhysical as logical   no-undo.
define variable cObjectIdValue2      as character no-undo.

define variable cFieldList           as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttField for temp-table ttField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

assign
  cDatabaseName1       = qg_cDatabaseNameForTableOrBuffer( phBuffer1 )
  lDatabase1IsPhysical = qg_lIsPhysicalDatabase( phBuffer1:dbname )
  cDatabaseName2       = qg_cDatabaseNameForTableOrBuffer( phBuffer2 )
  lDatabase2IsPhysical = qg_lIsPhysicalDatabase( phBuffer2:dbname )
  .

/* Non-physical tables can't have virtual fields. */

if    not lDatabase1IsPhysical
  and not lDatabase2IsPhysical then
  
  return '':U.

if lDatabase1IsPhysical then
  
  cObjectIdValue1 = qg_cObjectIdForBuffer( phBuffer1 ).

if lDatabase2IsPhysical then
  
  cObjectIdValue2 = qg_cObjectIdForBuffer( phBuffer1 ).

if lDatabase1IsPhysical then
  
  for each bttField
    where bttField.DatabaseName = cDatabaseName1
      and bttField.TableName    = phBuffer1:table
      and bttField.IsVirtual    = yes
      and bttField.FieldType    = {&K_FIELD_TYPE_VIRTUAL_DB_FIELD}
    on error undo, throw:
    
    if not qg_lBufferCompareSingleVirtualField( phBuffer1,
                                                lDatabase1IsPhysical,
                                                cObjectIdValue1,
                                                phBuffer2,
                                                lDatabase2IsPhysical,
                                                cObjectIdValue2,
                                                bttField.FieldName,
                                                bttField.DataType ) then
      
      cFieldList = cFieldList + ',':U + bttField.FieldName.
    
  end. /* for each bttField */

if    lDatabase2IsPhysical
  and phBuffer2:table <> phBuffer1:table then
  
  for each bttField
    where bttField.DatabaseName = cDatabaseName1
      and bttField.TableName    = phBuffer2:table
      and bttField.IsVirtual    = yes
      and bttField.FieldType    = {&K_FIELD_TYPE_VIRTUAL_DB_FIELD}
    on error undo, throw:
    
    if not qg_lBufferCompareSingleVirtualField( phBuffer1,
                                                lDatabase1IsPhysical,
                                                cObjectIdValue1,
                                                phBuffer2,
                                                lDatabase2IsPhysical,
                                                cObjectIdValue2,
                                                bttField.FieldName,
                                                bttField.DataType ) then
      
      cFieldList = cFieldList + ',':U + bttField.FieldName.
    
  end. /* for each bttField */

return trim( cFieldList, ',':U ).

end function. /* qg_cBufferCompareVirtualFields */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION qg_clVirtualDBFieldValueAsLongchar Method-Library
function qg_clVirtualDBFieldValueAsLongchar returns longchar 
  ( pcDataType      as character,
    pcFieldName     as character,
    pcObjectIdValue as character,
    pcFormat        as character ):
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cMethodName  as character no-undo.
define variable cFieldValue  as character   no-undo.
define variable iFieldValue  as integer     no-undo.
define variable dFieldValue  as decimal     no-undo.
define variable lFieldValue  as logical     no-undo.
define variable tFieldValue  as date        no-undo.
define variable tzFieldValue as datetime-tz no-undo.
define variable clFieldValue as longchar    no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

cMethodName = dynamic-invoke( qg_oVirtualDBFieldDataApiInstance(),
                              'cMethodNameByDataType':U,
                              pcDataType ).

if cMethodName > '':U then
  
  case pcDataType:
    
    when 'character':U then
    do:
      
      cFieldValue = dynamic-invoke( qg_oVirtualDBFieldDataApiInstance(),
                                    cMethodName,
                                    pcObjectIdValue,
                                    pcFieldName ).
      
      return ( if pcFormat <> ? then
                 string( cFieldValue, pcFormat )
               else
                 cFieldValue ).
      
    end. /* when 'character':U */
    
    when 'integer':U then
    do:
      
      iFieldValue = dynamic-invoke( qg_oVirtualDBFieldDataApiInstance(),
                                    cMethodName,
                                    pcObjectIdValue,
                                    pcFieldName ).
      
      return ( if pcFormat <> ? then
                 trim( string( iFieldValue, pcFormat ) )
               else
                 trim( string( iFieldValue ) ) ).
      
    end. /* when 'integer':U */
    
    when 'decimal':U then
    do:
      
      dFieldValue = dynamic-invoke( qg_oVirtualDBFieldDataApiInstance(),
                                    cMethodName,
                                    pcObjectIdValue,
                                    pcFieldName ).
      
      return ( if pcFormat <> ? then
                 trim( string( dFieldValue, pcFormat ) )
               else
                 trim( string( dFieldValue ) ) ).
      
    end. /* when '':U */
    
    when 'logical':U then
    do:
      
      lFieldValue = dynamic-invoke( qg_oVirtualDBFieldDataApiInstance(),
                                    cMethodName,
                                    pcObjectIdValue,
                                    pcFieldName ).
      
      return ( if pcFormat <> ? then
                 trim( string( lFieldValue, pcFormat ) )
               else
                 trim( string( lFieldValue ) ) ).
      
    end. /* when '':U */
    
    when 'date':U then
    do:
      
      tFieldValue = dynamic-invoke( qg_oVirtualDBFieldDataApiInstance(),
                                    cMethodName,
                                    pcObjectIdValue,
                                    pcFieldName ).
      
      return ( if pcFormat <> ? then
                 trim( string( tFieldValue, pcFormat ) )
               else
                 trim( string( tFieldValue ) ) ).
      
    end. /* when 'date':U */
    
    when 'datetime-tz':U then
    do:
      
      tzFieldValue = dynamic-invoke( qg_oVirtualDBFieldDataApiInstance(),
                                     cMethodName,
                                     pcObjectIdValue,
                                     pcFieldName ).
      
      return ( if pcFormat <> ? then
                 trim( string( tzFieldValue, pcFormat ) )
               else
                 trim( string( tzFieldValue ) ) ).
      
    end. /* when '':U */
    
    when 'clob':U then
    do:
      
      clFieldValue = dynamic-invoke( qg_oVirtualDBFieldDataApiInstance(),
                                     cMethodName,
                                     pcObjectIdValue,
                                     pcFieldName ).
      
      /* Never apply format to clob fields. */
      
      return clFieldValue.
      
    end. /* when '':U */
    
  end case. /* pcDataType */

catch oError as class progress.lang.error:
  return ?.
end catch.

end function. /* qg_clVirtualDBFieldValueAsLongchar */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION qg_clVirtualFieldValueAsLongchar Method-Library
function qg_clVirtualFieldValueAsLongchar returns longchar 
  ( piFieldType     as integer,
    pcDataType      as character,
    pcFieldName     as character,
    pcObjectIdValue as character,
    pcFormat        as character ):
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/    

case piFieldType:
  
  when {&K_FIELD_TYPE_VIRTUAL_DB_FIELD} then
    
    return qg_clVirtualDBFieldValueAsLongchar( pcDataType,
                                               pcFieldName,
                                               pcObjectIdValue,
                                               pcFormat ).
  
end case. /* case phQueryWindowFieldBuffer::FieldType */

end function. /* qg_clVirtualFieldValueAsLongchar */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION qg_lBufferCompareSingleVirtualField Method-Library
function qg_lBufferCompareSingleVirtualField returns logical 
  ( phBuffer1             as handle,
    plDatabase1IsPhysical as logical,
    pcObjectIdValue1      as character,
    phBuffer2             as handle,
    plDatabase2IsPhysical as logical,
    pcObjectIdValue2      as character,
    pcFieldName           as character,
    pcDataType            as character ):
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hField1       as handle    no-undo.
define variable hField2       as handle    no-undo.

define variable cMethodName   as character no-undo.
define variable clFieldValue1 as longchar  no-undo.
define variable clFieldValue2 as longchar  no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

hField1 = phBuffer1:buffer-field( pcFieldName ) no-error.
hField2 = phBuffer2:buffer-field( pcFieldName ) no-error.

/* Case 1: Field does exist physically in both tables. */

if    valid-handle( hField1 )
  and valid-handle( hField2 ) then
do:
  
  if    hField1:data-type <> hField2:data-type
     or hField1:extent     > 0
     or hField2:extent     > 0 then
    
    return yes.
  
  if lookup( hField1:data-type, 'CLOB,BLOB':U ) = 0 then
    
    return ( if lookup( hField1:data-type, 'character,longchar':U ) = 0 then
               ( hField1:buffer-value = hField2:buffer-value )
             else
               compare( hField1:buffer-value,
                        'EQ':U,
                        hField1:buffer-value,
                        'RAW':U ) ).
  
  else
  do:
    
    copy-lob
      from hField1:buffer-value
      to clFieldValue1
      .
    
    copy-lob
      from hField1:buffer-value
      to clFieldValue2
      .
    
    return compare( clFieldValue1,
                    'EQ':U,
                    clFieldValue2,
                    'RAW':U ).
    
  end. /* else: if lookup( pcDataType, 'CLOB,BLOB':U ) = 0 */
  
end. /* if    valid-handle( hField1 ) */

/* Case 2: Field does not exist physically in both tables. */

else
  
  if    not valid-handle( hField1 )
    and not valid-handle( hField2 ) then
  do:
    
    if    not plDatabase1IsPhysical
       or not plDatabase2IsPhysical then
      
      return yes.
    
    cMethodName = dynamic-invoke( qg_oVirtualDBFieldDataApiInstance(),
                                  'cMethodNameByDataType':U,
                                  pcDataType ).
    
    return ( if lookup( pcDataType, 'character,longchar':U ) = 0 then
                 dynamic-invoke( qg_oVirtualDBFieldDataApiInstance(),
                                      cMethodName,
                                      pcObjectIdValue1,
                                      pcFieldName )
               = dynamic-invoke( qg_oVirtualDBFieldDataApiInstance(),
                                    cMethodName,
                                    pcObjectIdValue2,
                                    pcFieldName )
             else
               compare( dynamic-invoke( qg_oVirtualDBFieldDataApiInstance(),
                                        cMethodName,
                                        pcObjectIdValue1,
                                        pcFieldName ),
                        'EQ':U,
                        dynamic-invoke( qg_oVirtualDBFieldDataApiInstance(),
                                        cMethodName,
                                        pcObjectIdValue2,
                                        pcFieldName ),
                        'RAW':U ) ).
    
  end. /* if    not valid-handle( hField1 ) */

/* Case 3: Field does exist physically in table 1 but not in table 2. */

else
  
  if    valid-handle( hField1 )
    and not valid-handle( hField2 ) then
  do:
    
    if not plDatabase2IsPhysical then
      
      return yes.
    
    if    hField1:data-type <> pcDataType
       or hField1:extent     > 0 then
      
      return yes.
    
    cMethodName = dynamic-invoke( qg_oVirtualDBFieldDataApiInstance(),
                                  'cMethodNameByDataType':U,
                                  pcDataType ).
    
    if lookup( pcDataType, 'CLOB,BLOB':U ) = 0 then
      
      return ( if lookup( pcDataType, 'character,longchar':U ) = 0 then
                   hField1:buffer-value
                 = dynamic-invoke( qg_oVirtualDBFieldDataApiInstance(),
                                   cMethodName,
                                   pcObjectIdValue2,
                                   pcFieldName )
               else
                 compare( hField1:buffer-value,
                          'EQ':U,
                          dynamic-invoke( qg_oVirtualDBFieldDataApiInstance(),
                                          cMethodName,
                                          pcObjectIdValue2,
                                          pcFieldName ),
                          'RAW':U ) ).
      
    else
    do:
      
      copy-lob
        from hField1:buffer-value
        to clFieldValue1
        .
      
      return compare( clFieldValue1,
                      'EQ':U,
                      dynamic-invoke( qg_oVirtualDBFieldDataApiInstance(),
                                      cMethodName,
                                      pcObjectIdValue2,
                                      pcFieldName ),
                      'RAW':U ).
      
    end. /* else: if lookup( pcDataType, 'CLOB,BLOB':U ) = 0 */
    
  end. /* else: if    not error-status:error */

/* Case 4: Field does exist physically in table 2 but not in table 1. */

else
  
  if    not valid-handle( hField1 )
    and valid-handle( hField2 ) then
  do:
    
    if not plDatabase1IsPhysical then
      
      return yes.
    
    if    hField2:data-type <> pcDataType
       or hField2:extent     > 0 then
      
      return yes.
    
    cMethodName = dynamic-invoke( qg_oVirtualDBFieldDataApiInstance(),
                                  'cMethodNameByDataType':U,
                                  pcDataType ).
    
    if lookup( pcDataType, 'CLOB,BLOB':U ) = 0 then
      
      return ( if lookup( pcDataType, 'character,longchar':U ) = 0 then
                   dynamic-invoke( qg_oVirtualDBFieldDataApiInstance(),
                                   cMethodName,
                                   pcObjectIdValue1,
                                   pcFieldName )
                 = hField2:buffer-value
               else
                 compare( dynamic-invoke( qg_oVirtualDBFieldDataApiInstance(),
                                          cMethodName,
                                          pcObjectIdValue1,
                                          pcFieldName ),
                          'EQ':U,
                          hField2:buffer-value,
                          'RAW':U ) ).
      
    else
    do:
      
      copy-lob
        from hField2:buffer-value
        to clFieldValue2
        .
      
      return compare( dynamic-invoke( qg_oVirtualDBFieldDataApiInstance(),
                                      cMethodName,
                                      pcObjectIdValue2,
                                      pcFieldName ),
                      'EQ':U,
                      clFieldValue2,
                      'RAW':U ).
      
    end. /* else: if lookup( pcDataType, 'CLOB,BLOB':U ) = 0 */
    
  end. /* else: if    not error-status:error */

end function. /* qg_lBufferCompareSingleVirtualField */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION qg_lVirtualDBFieldsPossible Method-Library
function qg_lVirtualDBFieldsPossible returns logical 
  ( buffer pbttDatabase for ttDatabase ):
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttField for temp-table ttField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if pbttDatabase.BasisDBName <> {&K_BASE_DB_NAME} then
  
  return no.


/* We are not really interested in the fields object id. We make this call to */
/* deterimine if (1) the field exists and (2) we are in an environment that   */
/* has the repository manager up and runnung.                                 */

if    qg_lFieldExistsInDatabaseSchema( pbttDatabase.BasisDBName,
                                       'DRC_VirtualField':U,
                                       gcVirtualDBFieldReposFlagFieldName )
  and dynamic-function( 'pa_cReposFieldInformationByName':U,
                        /* pcDRC_Table_ID */ 'DRC_VirtualField':U,
                        /* pcDRC_Field_ID */ gcVirtualDBFieldReposFlagFieldName,
                        /* pcRequest      */ 'DRC_Field_Obj':U ) > '':U then
    
    return yes.
  
  return no.
  
  catch oError as class progress.lang.error:
    
    return no.
    
  end catch. /* progress.lang.error */
  
end function. /* qg_lVirtualDBFieldsPossible */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION qg_oVirtualDBFieldDataApiInstance Method-Library
function qg_oVirtualDBFieldDataApiInstance returns class progress.lang.object 
  (  ):
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/


/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

&IF keyword-all('dynamic-property':U) <> ? &THEN
  
  if not valid-object( goVirtualDBFieldDataApiInstance ) then
    
    if search( 'basis/base/cls/BMCAddDataSvc.cls':U ) <> ? then
      
      goVirtualDBFieldDataApiInstance = dynamic-property( 'basis.base.cls.BMCAddDataSvc':U, 'prpoInstance':U ).
    
    else
      
      if search( 'x/adm/cls/XDCAddDataSvc.cls':U ) <> ? then
        
        goVirtualDBFieldDataApiInstance = dynamic-property( 'x.adm.cls.XDCAddDataSvc':U, 'prpoInstance':U ).
  
&ENDIF

return goVirtualDBFieldDataApiInstance.

catch oError as class progress.lang.error:
  return ?.
end catch.

end function. /* qg_oVirtualDBFieldDataApiInstance */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION qg_oVirtualDBFieldDataFieldApiInstance Method-Library
function qg_oVirtualDBFieldDataFieldApiInstance returns class progress.lang.object 
  (  ):
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/    

&IF keyword-all( 'dynamic-property':U ) <> ? &THEN
  
  if not valid-object( goVirtualDBFieldDataFieldApiInstance ) then
  
    if search( 'adm/repos/cls/DRCAddDataFieldSvc.cls':U ) <> ? then
    
      goVirtualDBFieldDataFieldApiInstance = dynamic-property( 'adm.repos.cls.DRCAddDataFieldSvc':U, 'prpoInstance':U ).
    
    else
      
      if search( 'x/adm/cls/XDCAddDataSvc.cls':U ) <> ? then
        
        goVirtualDBFieldDataFieldApiInstance = dynamic-property( 'x.adm.cls.XDCAddDataSvc':U, 'prpoInstance':U ).
  
&ENDIF

return goVirtualDBFieldDataFieldApiInstance.

catch oError as class progress.lang.error:
  return ?.
end catch.

end function. /* qg_oVirtualDBFieldDataFieldApiInstance */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

/* <<< Include: incl/virtual_fields.i <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

/* >>> Include: incl/virtual_indices.i >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> */

/*------------------------------------------------------------------------
    File        : virtual_indices.i
    Purpose     : 

    Syntax      :

    Description : 

    Author(s)   : Thiemann_M
    Created     : Wed Jun 01 14:37:00 CEST 2022
    Notes       :
  ----------------------------------------------------------------------*/

/* ***************************  Definitions  ************************** */


/* ********************  Preprocessor Definitions  ******************** */


/* ***************************  Main Block  *************************** */



/* **********************  Internal Procedures  *********************** */

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddTableVirtualIndices Method-Library
procedure qg_AddTableVirtualIndices :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define parameter buffer pbttDatabase for temp-table ttDatabase.
define parameter buffer pbttTable    for temp-table ttTable.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hRepVirtualIndexBuffer      as handle    no-undo.
define variable hRepVirtualIndexFieldBuffer as handle    no-undo.

define variable hRepVirtualIndexQuery       as handle    no-undo.
define variable hRepVirtualIndexFieldQuery  as handle    no-undo.
define variable cIndexQueryText             as character no-undo.
define variable cIndexFieldQueryText        as character no-undo.

define variable iVirtIdxFieldNo             as integer   no-undo.
define variable cVirtIdxFieldDataType       as character no-undo.
define variable cLastVirtIdxFieldDataType   as character no-undo init 'Dec':U.

define variable cMappedFields               as character no-undo.
define variable iMappedFieldIndex           as integer   no-undo.
define variable cSkippedFields              as character no-undo.
define variable iSkippedFieldIndex          as integer   no-undo.

define variable cFieldName                  as character no-undo.
define variable cFieldDataType              as character no-undo.
define variable cFieldValue                 as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttIndex              for temp-table ttIndex.
define buffer bttIndexField         for temp-table ttIndexField.
define buffer bttTable              for temp-table ttTable.
define buffer bttField              for temp-table ttField.
define buffer bttTable-Virtual      for temp-table ttTable.
define buffer bttIndex-Virtual      for temp-table ttIndex.
define buffer bttIndexField-Virtual for temp-table ttIndexField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

find bttTable-Virtual
  where bttTable-Virtual.DatabaseName = pbttDatabase.BasisDBName
    and bttTable-Virtual.TableName    = gcVirtualIndexDataTableName
  no-error.

if    available bttTable-Virtual
  and not bttTable-Virtual.DetailsLoaded
  and bttTable-Virtual.TableName <> pbttTable.TableName then

  run qg_AddTableDetails( bttTable-Virtual.DatabaseName,
                          bttTable-Virtual.TableName ).

create buffer hRepVirtualIndexBuffer for table substitute( '&1.DRC_Index':U,
                                                           pbttDatabase.BasisDBName ).
create buffer hRepVirtualIndexFieldBuffer for table substitute( '&1.DRC_IndexField':U,
                                                                 pbttDatabase.BasisDBName ).

create query hRepVirtualIndexQuery.
create query hRepVirtualIndexFieldQuery.

hRepVirtualIndexQuery:set-buffers( hRepVirtualIndexBuffer ).
hRepVirtualIndexFieldQuery:set-buffers( hRepVirtualIndexFieldBuffer ).

assign
  cIndexQueryText      =            'for each DRC_Index':U
                         + '~n':U + '  where DRC_Index.DRC_Table_Obj = &1':U
                         + '~n':U + '    and DRC_Index.&2            = yes':U
                         + '~n':U + '  no-lock':U
  cIndexFieldQueryText =            'for each DRC_IndexField':U
                         + '~n':U + '  where DRC_IndexField.DRC_Index_Obj = &1':U
                         + '~n':U + '  no-lock':U
                         .

hRepVirtualIndexQuery:query-prepare( substitute( cIndexQueryText,
                                                 quoter( pbttTable.RepObjectId ),
                                                 gcVirtualIndexReposFlagFieldName ) ).

hRepVirtualIndexQuery:query-open().

do while hRepVirtualIndexQuery:get-next():
  
  create bttIndex.
  
  assign
    bttIndex.DatabaseName = pbttDatabase.DatabaseName
    bttIndex.TableName    = pbttTable.TableName
    bttIndex.IndexName    = hRepVirtualIndexBuffer::DRC_Index_ID
    bttIndex.IsPrimary    = hRepVirtualIndexBuffer::IndexIsPrimary
    bttIndex.IsUnique     = hRepVirtualIndexBuffer::IndexIsUnique
    bttIndex.IsVirtual    = yes
    .
  
  validate bttIndex.
  
  hRepVirtualIndexFieldQuery:query-prepare( substitute( cIndexFieldQueryText, quoter( hRepVirtualIndexBuffer::DRC_Index_Obj ) ) ).
  
  hRepVirtualIndexFieldQuery:query-open().
  
  do while hRepVirtualIndexFieldQuery:get-next()
    on error undo, throw:
    
    find bttField
      where bttField.RepObjectId = hRepVirtualIndexFieldBuffer::DRC_Field_Obj
      no-error.
    
    if not available bttField then
      
      next.
    
    create bttIndexField.
  
    assign
      bttIndexField.DatabaseName     = bttIndex.DatabaseName
      bttIndexField.TableName        = bttIndex.TableName
      bttIndexField.IndexName        = bttIndex.IndexName
      bttIndexField.FieldName        = bttField.FieldName
      bttIndexField.IndexSequence    = hRepVirtualIndexFieldBuffer::DRC_IndexField_ID
      bttIndexField.DataType         = bttField.DataType
      bttIndexField.SortAscending    = hRepVirtualIndexFieldBuffer::IndexFieldAscending
      bttIndex.IndexFieldList        =   bttIndex.IndexFieldList
                                       + ',':U
                                       + bttIndexField.FieldName
      bttIndex.IndexFields           =   bttIndex.IndexFields
                                       + ' '
                                       + string( bttIndexField.SortAscending, '+/-':U )
                                       + bttIndexField.FieldName
      bttIndex.VirtualFieldList      =   bttIndex.VirtualFieldList
                                       + ',':U
                                       + bttIndexField.FieldName
      bttIndex.VirtualFieldDataTypes =   bttIndex.VirtualFieldDataTypes
                                       + ',':U
                                       + bttIndexField.DataType
      cVirtIdxFieldDataType          = ( if bttIndexField.DataType = 'character':U then
                                           'Char':U
                                         else
                                           'Dec':U )
      .
    
    validate bttIndexField.
    
    if cVirtIdxFieldDataType = cLastVirtIdxFieldDataType then
      
      assign
        iVirtIdxFieldNo = iVirtIdxFieldNo + 1
        cSkippedFields  =   cSkippedFields
                          + ',Field':U
                          + string( iVirtIdxFieldNo, '99':U )
                          + ( if cLastVirtIdxFieldDataType = 'Char':U then
                                'Dec':U
                              else
                                'Char':U )
        .
    
    assign
      iVirtIdxFieldNo = iVirtIdxFieldNo + 1
      cMappedFields   =   cMappedFields
                        + ',Field':U
                        + string( iVirtIdxFieldNo, '99':U )
                        + cVirtIdxFieldDataType
      cLastVirtIdxFieldDataType = cVirtIdxFieldDataType
      .
    
  end. /* do while hRepVirtualIndexFieldQuery:get-next() */
  
  assign
    bttIndex.IndexFieldList                 = trim( bttIndex.IndexFieldList, ',':U )
    bttIndex.IndexFields                    = trim( bttIndex.IndexFields )
    bttIndex.VirtualFieldList               = trim( bttIndex.VirtualFieldList, ',':U )
    bttIndex.VirtualFieldDataTypes          = trim( bttIndex.VirtualFieldDataTypes, ',':U )
    cSkippedFields                          = trim( cSkippedFields, ',':U )
    cMappedFields                           = trim( cMappedFields, ',':U )
    bttIndex.VirtualIndexDataFieldList      = 'DRC_Table_ID,DRC_Index_ID':U
    bttIndex.VirtualIndexDataFieldLabels    = ',':U
    bttIndex.VirtualIndexDataUntaggedValues = '~'':U + bttIndex.TableName + '~':U':U + {&K_PARAM_SPLITTER} + '~'':U + bttIndex.IndexName + '~':U':U
    bttIndex.VirtualIndexDataTaggedValues   = '~'':U + bttIndex.TableName + '~':U':U + {&K_PARAM_SPLITTER} + '~'':U + bttIndex.IndexName + '~':U':U
    .
  
  find first bttIndex-Virtual
    where bttIndex-Virtual.DatabaseName = bttTable-Virtual.DatabaseName
      and bttIndex-Virtual.TableName    = bttTable-Virtual.TableName
      and bttIndex-Virtual.IsPrimary    = yes
    no-error.
  
  if available bttIndex-Virtual then
  
    for each bttIndexField-Virtual
      where bttIndexField-Virtual.DatabaseName = bttIndex-Virtual.DatabaseName
        and bttIndexField-Virtual.TableName    = bttIndex-Virtual.TableName
      on error undo, throw:
      
      if lookup( bttIndexField-Virtual.FieldName, 'DRC_Table_ID,DRC_Index_ID':U ) > 0 then
        
        next.
      
      assign
        iMappedFieldIndex  = lookup( bttIndexField-Virtual.FieldName, cMappedFields )
        iSkippedFieldIndex = ( if iMappedFieldIndex > 0 then
                                 0
                               else
                                 lookup( bttIndexField-Virtual.FieldName, cSkippedFields ) )
        .
      
      if    iMappedFieldIndex  = 0
        and iSkippedFieldIndex = 0 then
        
        leave.
      
      assign
        bttIndex.VirtualIndexDataFieldList      =   bttIndex.VirtualIndexDataFieldList
                                                  + ',':U
                                                  + bttIndexField-Virtual.FieldName
        bttIndex.VirtualIndexDataFieldLabels    =   bttIndex.VirtualIndexDataFieldLabels
                                                  + ',':U
                                                  + ( if iMappedFieldIndex > 0 then
                                                        entry( iMappedFieldIndex, bttIndex.IndexFieldList )
                                                      else
                                                        '':U )
        cFieldName                              = ( if iMappedFieldIndex > 0 then
                                                      entry( iMappedFieldIndex, bttIndex.VirtualFieldList )
                                                    else
                                                      '':U )
        cFieldDataType                          = ( if iMappedFieldIndex > 0 then
                                                      entry( iMappedFieldIndex, bttIndex.VirtualFieldDataTypes )
                                                    else
                                                      bttIndexField-Virtual.DataType )
        cFieldValue                             = ( if iMappedFieldIndex > 0 then
                                                      ( if can-do( {&K_COMPANY_FIELDS}, cFieldName ) then
                                                          substitute( '~{firma/&1 %COMPANY%}':U,
                                                                      qg_cGetCompanyInclude( bttIndex.TableName ) )
                                                        else if not cFieldDataType begins 'datetime':U then
                                                          substitute( '<&1>':U, caps( cFieldDataType ) )
                                                        else
                                                          qg_cVirtualIndexFieldVariableName( cFieldName, 'decimal':U ) )
                                                    else
                                                      ( if bttIndexField-Virtual.DataType = 'character':U then
                                                          '~'~':U':U
                                                        else
                                                          '0':U ) )
        bttIndex.VirtualIndexDataUntaggedValues =   bttIndex.VirtualIndexDataUntaggedValues
                                                  + {&K_PARAM_SPLITTER}
                                                  + cFieldValue
        bttIndex.VirtualIndexDataTaggedValues   = bttIndex.VirtualIndexDataTaggedValues
                                                  + {&K_PARAM_SPLITTER}
                                                  + ( if can-do( {&K_COMPANY_FIELDS}, cFieldName ) then
                                                        cFieldValue
                                                      else if lookup( cFieldDataType, 'character,decimal':U ) > 0 then
                                                        qg_cTaggedValue( cFieldValue,
                                                                         (     iMappedFieldIndex > 0
                                                                           and cFieldValue > '':U ) )
                                                      else if not cFieldDataType begins 'datetime':U then
                                                        substitute( 'decimal( &1 )':U,
                                                                    qg_cTaggedValue( cFieldValue,
                                                                                     (     iMappedFieldIndex > 0
                                                                                       and cFieldValue > '':U ) ) )
                                                      else
                                                        cFieldValue )
        .
      
    end. /* for each bttIndexField-Virtual */
  
  validate bttIndex.
  
end. /* do while not hRepVirtualIndexQuery:query-off-end */

end procedure. /* qg_AddTableVirtualIndices */


/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_InitializeVirtualIndexFramework Method-Library
procedure qg_InitializeVirtualIndexFramework :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if search( 'basis/base/cls/BMCVirtIndexQuerySvo.cls':U ) <> ? then
  
  assign
    gcVirtualQueryApiPackageName     = 'basis.base.cls':U
    gcVirtualQueryApiClassName       = 'BMCVirtIndexQuerySvo':U
    gcVirtualIndexDataTableName      = 'DBT_VirtualIndex':U
    gcVirtualIndexReposFlagFieldName = 'IndexIsVirtual':U
    .

else
  
  if search( 'x/adm/cls/XDCVirtQuerySvo.cls':U ) <> ? then
    
    assign
      gcVirtualQueryApiPackageName      = 'x.adm.cls':U
      gcVirtualQueryApiClassName        = 'XDCVirtQuerySvo':U
      gcVirtualIndexDataTableName       = 'XDM_VirtualIndex':U
      gcVirtualIndexReposFlagFieldName  = 'xVirtualIndex':U
      .

end procedure. /* qg_InitializeVirtualIndexFramework */


/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

/* ************************  Function Implementations ***************** */

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION qg_cVirtualIndexFieldVariableName Method-Library
function qg_cVirtualIndexFieldVariableName returns character 
  ( pcFieldName as character,
    pcDataType  as character ):
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cFieldName as character no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

cFieldName = ( if pcFieldName = 'Firma':U then
                 'Company':U
               else
                 pcFieldName ).

return    qg_cDataTypePrefix( pcDataType )
        + ( if    cFieldName begins 'x':U
               or cFieldName begins 'y':U then
              substring( cFieldName, 1, 1 )
            else
              caps( substring( cFieldName, 1, 1 ) ) )
        + substring( cFieldName, 2 )
        .

end function. /* qg_cVirtualIndexFieldVariableName */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION qg_lVirtualIndexPossible Method-Library
function qg_lVirtualIndexPossible returns logical 
  ( buffer pbttDatabase for ttDatabase ):
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            