/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.java.oea.plugins.querygenerator;

import com.proalpha.java.oea.plugins.querygenerator.Variable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VariableParser {
    private String parseText = "";
    private String resultText = "";
    private List<Variable> variableList = null;

    public VariableParser() {
    }

    public VariableParser(String parseText) {
        this.parseText = parseText;
    }

    public void parse() {
        this.variableList = new ArrayList<Variable>();
        StringBuffer buffer = new StringBuffer(this.parseText.length());
        Pattern pattern = Pattern.compile("\\$\\{([^\\}]+)\\}");
        Matcher matcher = pattern.matcher(this.parseText);
        int lastMatchEnd = 0;
        while (matcher.find()) {
            buffer.append(this.parseText.substring(lastMatchEnd, matcher.start()));
            Variable variable = new Variable(matcher.group(1), buffer.length());
            buffer.append(variable.getText());
            this.variableList.add(variable);
            lastMatchEnd = matcher.end();
        }
        buffer.append(this.parseText.substring(lastMatchEnd));
        this.resultText = buffer.toString();
    }

    public String getParseText() {
        return this.parseText;
    }

    public void setParseText(String parseText) {
        this.parseText = parseText;
    }

    public String getResultText() {
        return this.resultText;
    }

    public Variable[] getVariables() {
        if (this.variableList != null) {
            return this.variableList.toArray(new Variable[this.variableList.size()]);
        }
        return new Variable[0];
    }
}

