/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.checks;

import com.proalpha.pds.checks.CheckFilter;
import com.proalpha.pds.checks.CheckTreeViewContentProvider;
import com.proalpha.pds.checks.CheckTreeViewLabelProvider;
import com.proalpha.pds.checks.Team;
import com.proalpha.pds.checks.jaxb.DsDSConsistencyChecks;
import com.proalpha.pds.paconnector.PaProject;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;

public class CheckTreeView
extends ViewPart {
    public static final String ID = "com.proalpha.pds.checks.CheckTreeView";
    private final String LOCAL = "Local";
    private final String CHECK_ALL = "<ALL>";
    private DsDSConsistencyChecks currentChecks;
    private String currentTeam = "<ALL>";
    private String currentModule = "<ALL>";
    private CheckFilter filter;
    private Form form;
    private String location;
    private Combo projectViewer;
    private Combo teamViewer;
    private Combo moduleViewer;
    private TreeViewer viewer;
    private File xmlFile;
    private Button serverButton;
    private Button localButton;
    private Button showCommonModulesButton;

    public String getCurrentTeam() {
        return this.currentTeam;
    }

    public String getCurrentModule() {
        return this.currentModule;
    }

    public boolean getCurrentShowCommonModulesStatus() {
        return this.showCommonModulesButton.getSelection();
    }

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.form = toolkit.createForm(parent);
        this.form.getBody().setLayout((Layout)new GridLayout(4, false));
        toolkit.decorateFormHeading(this.form);
        Label lblProject = new Label(this.form.getBody(), 0);
        GridData gridData = new GridData(131072, 0x1000000, false, false, 1, 1);
        gridData.widthHint = 50;
        lblProject.setLayoutData((Object)gridData);
        toolkit.adapt((Control)lblProject, true, true);
        lblProject.setText("Project");
        this.projectViewer = new Combo(this.form.getBody(), 12);
        GridData gridDataCombo = new GridData(4, 0x1000000, true, false, 2, 1);
        gridDataCombo.widthHint = 200;
        this.projectViewer.setLayoutData((Object)gridDataCombo);
        this.projectViewer.setItems(this.getCurrentProjectList());
        this.projectViewer.addSelectionListener(this.projectSelectedListener());
        toolkit.adapt((Control)this.projectViewer, true, true);
        toolkit.paintBordersFor((Composite)this.projectViewer);
        Group group = new Group(this.form.getBody(), 0);
        group.setText("Location");
        group.setLayout((Layout)new RowLayout(512));
        group.setLayoutData((Object)new GridData(16384, -7, false, false, 1, 2));
        toolkit.adapt((Composite)group);
        toolkit.paintBordersFor((Composite)group);
        this.serverButton = new Button((Composite)group, 16);
        this.serverButton.setText("Server");
        this.serverButton.setImage(ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("/images/server_earth.png")).createImage());
        this.serverButton.addSelectionListener(this.locationSelectedListener());
        this.serverButton.setEnabled(false);
        toolkit.adapt((Control)this.serverButton, true, true);
        this.localButton = new Button((Composite)group, 16);
        this.localButton.setText("Local");
        this.localButton.setImage(ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("/images/text_tree.png")).createImage());
        this.localButton.addSelectionListener(this.locationSelectedListener());
        this.localButton.setEnabled(false);
        this.localButton.setSelection(true);
        toolkit.adapt((Control)this.localButton, true, true);
        Label lblModule = new Label(this.form.getBody(), 0);
        GridData gridData3 = new GridData(131072, 0x1000000, false, false, 1, 1);
        gridData3.widthHint = 50;
        lblModule.setLayoutData((Object)gridData3);
        toolkit.adapt((Control)lblModule, true, true);
        lblModule.setText("Module");
        this.teamViewer = new Combo(this.form.getBody(), 12);
        this.teamViewer.setVisibleItemCount(12);
        GridData teamViewerGridData = new GridData(4, 2, true, false, 1, 1);
        teamViewerGridData.minimumWidth = 120;
        this.teamViewer.setLayoutData((Object)teamViewerGridData);
        this.teamViewer.addSelectionListener(this.teamSelectedListener());
        toolkit.adapt((Control)this.teamViewer, true, true);
        toolkit.paintBordersFor((Composite)this.teamViewer);
        this.moduleViewer = new Combo(this.form.getBody(), 12);
        this.moduleViewer.setVisibleItemCount(12);
        this.moduleViewer.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        this.moduleViewer.addSelectionListener(this.moduleSelectedListener());
        toolkit.adapt((Control)this.moduleViewer, true, true);
        toolkit.paintBordersFor((Composite)this.moduleViewer);
        new Label(this.form.getBody(), 0);
        this.showCommonModulesButton = new Button(this.form.getBody(), 32);
        this.showCommonModulesButton.setText("Show " + Team.COMMON.getLabel());
        GridData showCommonModulesButtonGD = new GridData(4, 2, false, false, 2, 1);
        this.showCommonModulesButton.setLayoutData((Object)showCommonModulesButtonGD);
        this.showCommonModulesButton.addSelectionListener(this.showCommonModulesListener());
        this.showCommonModulesButton.setSelection(true);
        toolkit.adapt((Control)this.showCommonModulesButton, true, true);
        this.location = "Local";
        this.form.setText("select an installed project to show the results of the consistency checks");
        this.form.update();
        this.viewer = new TreeViewer(this.form.getBody(), 0);
        this.filter = new CheckFilter();
        this.viewer.setContentProvider((IContentProvider)new CheckTreeViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new CheckTreeViewLabelProvider(this.filter));
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.getTree().setLayoutData((Object)new GridData(4, 4, false, true, 4, 1));
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IAction)new ExpandAllAction());
        toolBarManager.add((IAction)new CollapseAllAction());
    }

    private SelectionListener projectSelectedListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent selectedItem) {
                if (selectedItem != null) {
                    String selectedProjectName = ((Combo)selectedItem.getSource()).getText();
                    if (!selectedProjectName.isEmpty()) {
                        CheckTreeView.this.localButton.setEnabled(true);
                        CheckTreeView.this.serverButton.setEnabled(true);
                    }
                    CheckTreeView.this.checksXmlFile(selectedProjectName);
                }
                CheckTreeView.this.refreshChecks();
            }

            public void widgetDefaultSelected(SelectionEvent selectedItem) {
            }
        };
    }

    private SelectionListener locationSelectedListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent selectedItem) {
                if (selectedItem != null && selectedItem.widget instanceof Button && ((Button)selectedItem.widget).getSelection() && CheckTreeView.this.projectViewer.getSelectionIndex() != -1) {
                    CheckTreeView.this.location = ((Button)selectedItem.widget).getText();
                    String selectedProjectName = CheckTreeView.this.projectViewer.getText();
                    CheckTreeView.this.checksXmlFile(selectedProjectName);
                }
                CheckTreeView.this.refreshChecks();
            }

            public void widgetDefaultSelected(SelectionEvent selectedItem) {
            }
        };
    }

    private SelectionListener teamSelectedListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent selectedItem) {
                if (selectedItem != null) {
                    CheckTreeView.this.currentTeam = ((Combo)selectedItem.getSource()).getText();
                    CheckTreeView.this.currentModule = "<ALL>";
                    CheckTreeView.this.showCommonModulesButton.setSelection(true);
                    CheckTreeView.this.filter.setSearchFilter(CheckTreeView.this.currentTeam, CheckTreeView.this.currentModule, CheckTreeView.this.showCommonModulesButton.getSelection());
                    CheckTreeView.this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
                    CheckTreeView.this.moduleViewer.setItems(CheckTreeView.this.getModules());
                    CheckTreeView.this.moduleViewer.select(CheckTreeView.this.moduleViewer.indexOf("<ALL>"));
                    CheckTreeView.this.viewer.refresh();
                    CheckTreeView.this.viewer.expandAll();
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectedItem) {
            }
        };
    }

    private SelectionListener moduleSelectedListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent selectedItem) {
                if (selectedItem != null) {
                    CheckTreeView.this.currentModule = ((Combo)selectedItem.getSource()).getText();
                    if (CheckTreeView.this.currentTeam.equals("<ALL>") && CheckTreeView.this.currentModule.equals("<ALL>")) {
                        CheckTreeView.this.showCommonModulesButton.setSelection(true);
                    } else if (!CheckTreeView.this.currentModule.equals("<ALL>")) {
                        CheckTreeView.this.showCommonModulesButton.setSelection(false);
                    }
                    CheckTreeView.this.filter.setSearchFilter(CheckTreeView.this.currentTeam, CheckTreeView.this.currentModule, CheckTreeView.this.showCommonModulesButton.getSelection());
                    CheckTreeView.this.moduleViewer.setItems(CheckTreeView.this.getModules());
                    CheckTreeView.this.moduleViewer.select(CheckTreeView.this.moduleViewer.indexOf(CheckTreeView.this.currentModule));
                    CheckTreeView.this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
                    CheckTreeView.this.viewer.refresh();
                    CheckTreeView.this.viewer.expandAll();
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectedItem) {
            }
        };
    }

    private SelectionListener showCommonModulesListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent selectedItem) {
                if (selectedItem != null) {
                    CheckTreeView.this.filter.setSearchFilter(CheckTreeView.this.currentTeam, CheckTreeView.this.currentModule, ((Button)selectedItem.getSource()).getSelection());
                    CheckTreeView.this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
                    String selectedModule = CheckTreeView.this.moduleViewer.getText();
                    CheckTreeView.this.moduleViewer.setItems(CheckTreeView.this.getModules());
                    CheckTreeView.this.moduleViewer.select(CheckTreeView.this.moduleViewer.indexOf(selectedModule));
                    CheckTreeView.this.viewer.refresh();
                    CheckTreeView.this.viewer.expandAll();
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectedItem) {
            }
        };
    }

    public void checksXmlFile(String selectedProjectName) {
        if (selectedProjectName != null) {
            this.xmlFile = this.getXMLFile(selectedProjectName);
            this.displayCheckDate();
        } else {
            this.xmlFile = null;
            MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Consistency checks not available", (String)"The selected project is not open. Consistency checks are only accessible if the selected project is available.");
        }
    }

    public String[] getCurrentProjectList() {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = workspaceRoot.getProjects();
        String[] projectNames = new String[projects.length];
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            projectNames[i] = project.getName();
            ++i;
        }
        return projectNames;
    }

    public String[] getModules() {
        TreeSet<String> modules = new TreeSet<String>();
        modules.add("<ALL>");
        List<DsDSConsistencyChecks.TtDSCheck> filteredList = this.currentChecks.getTtDSCheck();
        for (DsDSConsistencyChecks.TtDSCheck check : filteredList) {
            List<DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck> filteredCheck = check.getTtDSSubCheck();
            for (DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck filteredSubCheck : filteredCheck) {
                List<DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos> filteredRepoEntries;
                List<DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc> filteredSrcEntries = filteredSubCheck.getTtDSLogEntrySrc();
                if (!filteredSrcEntries.isEmpty()) {
                    for (DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc filteredSrcEntry : filteredSrcEntries) {
                        if (filteredSrcEntry.getModule() == null || filteredSrcEntry.getModule().isEmpty() || !this.filter.select(null, null, filteredSrcEntry)) continue;
                        modules.add(filteredSrcEntry.getModule());
                    }
                }
                if ((filteredRepoEntries = filteredSubCheck.getTtDSLogEntryRepos()).isEmpty()) continue;
                for (DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos filteredRepoEntry : filteredRepoEntries) {
                    if (filteredRepoEntry.getModule() == null || filteredRepoEntry.getModule().isEmpty() || !this.filter.select(null, null, filteredRepoEntry)) continue;
                    modules.add(filteredRepoEntry.getModule());
                }
            }
        }
        return (String[])modules.stream().toArray(String[]::new);
    }

    private void displayCheckDate() {
        if (this.xmlFile != null && this.xmlFile.exists() && this.projectViewer.getSelectionIndex() != -1) {
            Date date = new Date();
            date.setTime(this.xmlFile.lastModified());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            String heading = MessageFormat.format("{0} ({1})", this.location, dateFormat.format(calendar.getTime()));
            this.form.setText(heading);
            this.form.update();
        }
    }

    private void refreshChecks() {
        if (this.xmlFile != null && this.xmlFile.exists()) {
            Unmarshaller unmarshaller = null;
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{DsDSConsistencyChecks.class});
                unmarshaller = context.createUnmarshaller();
                if (unmarshaller != null) {
                    this.currentChecks = (DsDSConsistencyChecks)unmarshaller.unmarshal(this.xmlFile);
                }
            }
            catch (JAXBException e) {
                throw new IllegalStateException(e);
            }
            this.currentTeam = "<ALL>";
            this.currentModule = "<ALL>";
            this.filter.setSearchFilter(this.currentTeam, this.currentModule, true);
            this.teamViewer.setItems(Team.getTeams());
            this.moduleViewer.setItems(this.getModules());
            this.teamViewer.select(this.teamViewer.indexOf("<ALL>"));
            this.moduleViewer.select(this.moduleViewer.indexOf("<ALL>"));
            this.showCommonModulesButton.setSelection(true);
        } else {
            this.currentChecks = null;
            this.teamViewer.removeAll();
            this.moduleViewer.removeAll();
        }
        this.refreshTree();
    }

    private void refreshTree() {
        if (this.currentChecks != null) {
            List<DsDSConsistencyChecks.TtDSCheck> filteredList = this.currentChecks.getTtDSCheck();
            this.viewer.setInput(filteredList);
        } else {
            this.viewer.setInput(null);
        }
        Object[] expandedElements = null;
        expandedElements = this.viewer.getExpandedElements();
        if (expandedElements != null) {
            this.viewer.setExpandedElements(expandedElements);
        }
        this.viewer.refresh();
    }

    public void showBusy(boolean busy) {
        Cursor systemCursor = busy ? Display.getCurrent().getSystemCursor(1) : Display.getCurrent().getSystemCursor(0);
        this.viewer.getTree().setCursor(systemCursor);
    }

    public String getSelectedProject() {
        return this.projectViewer.getText();
    }

    public void setSelectedProject(PaProject paProject) {
        this.projectViewer.select(this.projectViewer.indexOf(paProject.getName()));
        this.checksXmlFile(paProject.getName());
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        this.refreshChecks();
        this.viewer.refresh(true);
    }

    private File getXMLFile(String selectedProjectName) {
        Path pathToXMLFile = null;
        String fileName = "ConsistencyCheck.xml";
        Path localLocation = null;
        Path serverLocation = null;
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            localLocation = new Path(root.getPersistentProperty(new QualifiedName(selectedProjectName, "ConsistencyChecksLocationLocal")));
            serverLocation = new Path(root.getPersistentProperty(new QualifiedName(selectedProjectName, "ConsistencyChecksLocationServer")));
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        pathToXMLFile = this.location.equals("Local") ? localLocation : serverLocation;
        File resultFile = null;
        resultFile = pathToXMLFile != null ? pathToXMLFile.append(fileName).toFile() : new File("");
        return resultFile;
    }

    public void setFocus() {
    }

    public class CollapseAllAction
    extends Action {
        public CollapseAllAction() {
            this.setImageDescriptor(ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("/images/collapse_all.png")));
            this.setToolTipText("Collapse all");
        }

        public void run() {
            CheckTreeView.this.viewer.collapseAll();
        }
    }

    public class ExpandAllAction
    extends Action {
        public ExpandAllAction() {
            this.setImageDescriptor(ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("/images/expand_all.gif")));
            this.setToolTipText("Expand all");
        }

        public void run() {
            CheckTreeView.this.viewer.expandAll();
        }
    }
}

