/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.checks;

import com.proalpha.pds.checks.CheckTreeView;
import com.proalpha.pds.gitutils.checks.ObserverJob;
import com.proalpha.pds.paconnector.PaProject;
import java.io.File;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ScanJob
extends Job {
    private final Logger logger = LoggerFactory.getLogger(ScanJob.class);
    private List<String> checkList;
    private PaProject paProject;
    private File resultFile;

    public ScanJob(String name, PaProject paProject, List<String> checkList, File resultFile) {
        super(name);
        this.paProject = paProject;
        this.checkList = checkList;
        this.resultFile = resultFile;
        this.setProperty(IProgressConstants.ICON_PROPERTY, ImageDescriptor.createFromURL((URL)CheckTreeView.class.getResource("/images/bug_yellow_view.png")));
        this.setProperty(IProgressConstants.PROPERTY_IN_DIALOG, Boolean.FALSE);
        this.setProperty(IProgressConstants.KEEPONE_PROPERTY, Boolean.TRUE);
        this.setProperty(IProgressConstants.ACTION_PROPERTY, this.getReservationCompletedAction());
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.paProject.isAvailable()) {
            this.paProject.getBridge().scanObjects(String.join((CharSequence)",", this.checkList));
        }
        ObserverJob observerJob = new ObserverJob("Wait for check results", this.resultFile);
        observerJob.setSystem(true);
        observerJob.schedule();
        IJobManager manager = Job.getJobManager();
        try {
            manager.join((Object)"ObserverJob", monitor);
        }
        catch (InterruptedException | OperationCanceledException exception) {
            this.logger.error(exception.toString());
            return Status.CANCEL_STATUS;
        }
        return new Status(0, "com.proalpha.pds.paconnector", "Scan has been completed. Open proALPHA Checks perspective.");
    }

    protected Action getReservationCompletedAction() {
        return new Action("View scan status"){

            public void run() {
                try {
                    PlatformUI.getWorkbench().showPerspective("com.proalpha.pds.checks.proALPHAChecks", PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
    }

    public boolean belongsTo(Object family) {
        if (family instanceof ScanJob) {
            return this.getName().equals(((ScanJob)((Object)family)).getName());
        }
        return false;
    }
}

