/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.pagit.grep;

import com.proalpha.pds.pagit.exceptions.PaGitGrepException;
import com.proalpha.pds.pagit.grep.GrepConfig;
import com.proalpha.pds.pagit.model.grep.Result;
import com.proalpha.pds.pagit.model.grep.ResultStorage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GitGrep {
    protected final Logger logger = LoggerFactory.getLogger(GitGrep.class);
    protected final Repository repository;
    protected final String searchTerm;
    protected final GrepConfig config;
    protected ResultStorage resultStorage = null;

    public GitGrep(Repository repository, String searchTerm, GrepConfig config) {
        this.repository = repository;
        this.searchTerm = searchTerm;
        this.config = config;
    }

    public GitGrep(String repositoryPath, String searchTerm, GrepConfig config) throws IOException {
        this.repository = new FileRepository(new File(repositoryPath));
        this.searchTerm = searchTerm;
        this.config = config;
    }

    public GitGrep(Repository repository, String searchTerm) {
        this.repository = repository;
        this.searchTerm = searchTerm;
        this.config = new GrepConfig();
    }

    public GitGrep(String repositoryPath, String searchTerm) throws IOException {
        this.repository = new FileRepository(new File(repositoryPath));
        this.searchTerm = searchTerm;
        this.config = new GrepConfig();
    }

    public List<Result> getResults() throws IOException, PaGitGrepException {
        if (this.resultStorage == null) {
            this.retrieveResults();
        }
        return this.resultStorage.getResults();
    }

    public void printResults(boolean printContext) throws IOException, PaGitGrepException {
        List<Result> results = this.getResults();
        int i = 0;
        if (results == null) {
            System.out.println("Keine Ergebnisse...");
        } else {
            for (Result r : results) {
                System.out.println("------------------------------------------------------------------------");
                System.out.println(String.valueOf(Integer.toString(i)) + " : " + r.getContext().getBranch() + " : " + r.getContext().getFile() + " - " + Integer.toString(r.getLineNo()));
                System.out.println("Matching line: " + r.getHit());
                if (printContext) {
                    System.out.println(r.getContext().getContext());
                }
                System.out.println("------------------------------------------------------------------------");
                ++i;
            }
        }
    }

    public abstract void retrieveResults() throws IOException, PaGitGrepException;
}

