/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.common;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergetoolOperation {
    private final Logger logger = LoggerFactory.getLogger(MergetoolOperation.class);
    private List<String> fileList;
    private File workingDir;

    public MergetoolOperation(File workingDir, List<String> fileList) {
        this.workingDir = workingDir;
        this.fileList = fileList;
    }

    public void execute() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (!MergetoolOperation.this.fileList.isEmpty()) {
                    for (String fileToMerge : MergetoolOperation.this.fileList) {
                        ArrayList<String> commands = new ArrayList<String>();
                        commands.add("CMD");
                        commands.add("/C");
                        commands.add("git mergetool " + fileToMerge);
                        ProcessBuilder pb = new ProcessBuilder(commands);
                        pb.directory(MergetoolOperation.this.workingDir);
                        MergetoolOperation.this.logger.debug("Running commands " + commands + " in " + MergetoolOperation.this.workingDir);
                        try {
                            pb.start();
                        }
                        catch (IOException e) {
                            MergetoolOperation.this.logger.error("Process MergetoolOperation throws an IOException", (Throwable)e);
                        }
                    }
                }
            }
        };
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)r);
    }
}

