/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.pagit.util.jira;

import com.google.api.client.http.BasicAuthentication;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.proalpha.pds.pagit.PaGitConfig;
import com.proalpha.pds.pagit.model.jira.JiraIssue;
import com.proalpha.pds.pagit.util.WindowsCredentials;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraRestCall {
    private final Logger logger = LoggerFactory.getLogger(JiraRestCall.class);
    private final String url;
    private final String path;

    public JiraRestCall(String url) {
        this.url = url;
        this.path = PaGitConfig.getStringFromConfig("jira.path");
    }

    public JiraRestCall() {
        this(PaGitConfig.getStringFromConfig("jira.server"));
    }

    public JiraIssue getIssue(String key) {
        JiraIssue issue = null;
        String jiraURL = String.valueOf(this.url) + this.path + key + "?expand=versionedRepresentations";
        try {
            NetHttpTransport httpTransport = new NetHttpTransport();
            HttpRequestFactory requestFactory = httpTransport.createRequestFactory();
            HttpRequest request = requestFactory.buildGetRequest(new GenericUrl(jiraURL));
            String username = System.getenv(PaGitConfig.getStringFromConfig("jira.env_vars.auth_username"));
            String password = System.getenv(PaGitConfig.getStringFromConfig("jira.env_vars.auth_password"));
            if (username == null || username.isEmpty() || password == null || password.isEmpty()) {
                WindowsCredentials creds = new WindowsCredentials(PaGitConfig.getStringFromConfig("jira.windows_cred_manager_credential"));
                username = creds.getGenericUsername();
                password = creds.getGenericPassword();
            }
            if (username.isEmpty() || password.isEmpty()) {
                throw new Exception("Unable to locate Jira credentials");
            }
            BasicAuthentication basicAuthentication = new BasicAuthentication(username, password);
            basicAuthentication.initialize(request);
            HttpResponse response = request.execute();
            Throwable throwable = null;
            Object var12_14 = null;
            try (InputStream in = response.getContent();){
                issue = new JiraIssue(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage());
        }
        return issue;
    }
}

