/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.pagit.util.bitbucket;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.proalpha.pds.pagit.model.server.BitbucketCloudRepository;
import com.proalpha.pds.pagit.model.server.BitbucketCloudRestRepoListResponse;
import com.proalpha.pds.pagit.model.server.GitServerRepository;
import com.proalpha.pds.pagit.util.bitbucket.BitbucketRestCall;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketCloudRestCallGetRepoList
extends BitbucketRestCall<ArrayList<GitServerRepository>> {
    private final Logger logger = LoggerFactory.getLogger(BitbucketCloudRestCallGetRepoList.class);
    private int totalSize = 0;

    public int getTotalSize() {
        return this.totalSize;
    }

    @Override
    protected ArrayList<GitServerRepository> parseRestResponse(InputStream response) throws IOException {
        ArrayList<GitServerRepository> repoList = new ArrayList<GitServerRepository>();
        ObjectMapper mapper = new ObjectMapper();
        BitbucketCloudRestRepoListResponse resp = (BitbucketCloudRestRepoListResponse)mapper.readValue(response, BitbucketCloudRestRepoListResponse.class);
        this.totalSize = resp.getSize();
        for (BitbucketCloudRepository repo : resp.getValues()) {
            GitServerRepository gitRepo = new GitServerRepository();
            gitRepo.setServerType(GitServerRepository.ServerType.BITBUCKET_CLOUD);
            gitRepo.setName(repo.getSlug());
            gitRepo.setProject(repo.getProject().getKey());
            repoList.add(gitRepo);
        }
        return repoList;
    }

    public ArrayList<GitServerRepository> fetchAllPages() {
        ArrayList<GitServerRepository> allRepos = new ArrayList<GitServerRepository>();
        this.setStartEntry(1);
        this.execute();
        List firstPage = (List)this.getRestResponse();
        allRepos.addAll(firstPage);
        int totalPages = (int)Math.ceil((double)this.getTotalSize() / 100.0);
        ArrayList<CompletableFuture<List>> futures = new ArrayList<CompletableFuture<List>>();
        int page = 2;
        while (page <= totalPages) {
            int currentPage = page++;
            futures.add(CompletableFuture.supplyAsync(() -> {
                try {
                    BitbucketCloudRestCallGetRepoList pageCall = new BitbucketCloudRestCallGetRepoList();
                    pageCall.setSubUrl(this.getSubUrl());
                    pageCall.setStartEntry(currentPage);
                    pageCall.execute();
                    return (List)pageCall.getRestResponse();
                }
                catch (Exception e) {
                    this.logger.error("Error fetching page {}", (Object)currentPage, (Object)e);
                    return Collections.emptyList();
                }
            }));
        }
        futures.forEach(f -> {
            boolean bl = allRepos.addAll((Collection)f.join());
        });
        allRepos.sort((a, b) -> a.getName().compareToIgnoreCase(b.getName()));
        return allRepos;
    }
}

