/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.projconf.utils;

import com.openedge.pdt.platform.PlatformSupport;
import com.openedge.pdt.platform.Proversion;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class ProgressUtils {
    private static final String COM_OPENEDGE_PDT_CORE_BUNDLE = "com.openedge.pdt.core";
    private PlatformSupport platformSupport;

    public ProgressUtils(PlatformSupport platformSupport) {
        this.platformSupport = platformSupport;
    }

    public Proversion getProgressVersion() {
        String openEdgeEditorVersion = this.getOpenEdgeEditorVersion();
        Proversion proversion = this.platformSupport.getProversion(openEdgeEditorVersion);
        if (proversion == null) {
            proversion = this.platformSupport.getProversion(String.valueOf(openEdgeEditorVersion) + "BETA");
        }
        if (proversion == null) {
            proversion = this.platformSupport.getProversion(String.valueOf(openEdgeEditorVersion) + "ALPHA");
        }
        if (proversion == null) {
            StringBuilder supportedVersions = new StringBuilder();
            Proversion[] proversionArray = this.platformSupport.getProversions();
            int n = proversionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Proversion proVersion = proversionArray[n2];
                supportedVersions.append(" ");
                supportedVersions.append(proVersion.getVersion());
                ++n2;
            }
            throw new RuntimeException("OpenEdge Version not found.\nSupported OpenEdge version are: " + supportedVersions.toString());
        }
        return proversion;
    }

    public String getOpenEdgeEditorVersion() {
        return this.getOpenEdgeVersionWithMinor();
    }

    public String getOpenEdgeVersionWithMinor() {
        String openEdgeVersion = "";
        Bundle openEdgeBundle = Platform.getBundle((String)COM_OPENEDGE_PDT_CORE_BUNDLE);
        if (openEdgeBundle != null) {
            Version version = openEdgeBundle.getVersion();
            openEdgeVersion = String.format("%s.%s", version.getMajor(), version.getMinor());
        }
        return openEdgeVersion;
    }
}

