/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui.wizards.controller;

import com.proalpha.pds.ui.wizards.controller.PaWizard;
import com.proalpha.pds.ui.wizards.wizardpages.DatasetCustomizationWizardPage;
import com.proalpha.pds.ui.wizards.wizardpages.WizardMainPageConfiguration;
import com.proalpha.pds.ui.wizards.wizardpages.WizardpageFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;

public class DatasetCustomizationWizard
extends PaWizard
implements INewWizard {
    private static final String BUSINESS_ENTITY_OBJECT = "Business Entity Object";
    private static final String DATA_ACCESS_OBJECT = "Data Access Object";
    private DatasetCustomizationWizardPage datasetCustomizationPage = null;

    public DatasetCustomizationWizard() {
        try {
            LinkedHashMap<String, WizardMainPageConfiguration> configList = new LinkedHashMap<String, WizardMainPageConfiguration>();
            ArrayList<String> extensionList = new ArrayList<String>();
            extensionList.add("p");
            WizardMainPageConfiguration beoConfiguration = new WizardMainPageConfiguration();
            beoConfiguration.setWizardTitle("proALPHA Business Entity Object File");
            beoConfiguration.setWizardDescription("This wizard creates a new proALPHA BEO File.");
            beoConfiguration.setTemplateName("pABusinessEntityObject");
            beoConfiguration.setExtensionList(extensionList);
            beoConfiguration.setRootClass(BUSINESS_ENTITY_OBJECT);
            beoConfiguration.setThirdDigit("e");
            beoConfiguration.setCheckRepository(true);
            beoConfiguration.setSupportRepositoryCreateButton(true);
            beoConfiguration.setCheckFileNameLength(true);
            beoConfiguration.setCheckLowerCase(true);
            configList.put(BUSINESS_ENTITY_OBJECT, beoConfiguration);
            WizardMainPageConfiguration daoConfiguration = new WizardMainPageConfiguration();
            daoConfiguration.setWizardTitle("proALPHA Data Access Object File");
            daoConfiguration.setWizardDescription("This wizard creates a new proALPHA DAO File.");
            daoConfiguration.setTemplateName("pADataAccessObject");
            daoConfiguration.setExtensionList(extensionList);
            daoConfiguration.setRootClass(DATA_ACCESS_OBJECT);
            daoConfiguration.setThirdDigit("j");
            daoConfiguration.setCheckRepository(true);
            daoConfiguration.setSupportRepositoryCreateButton(true);
            daoConfiguration.setCheckFileNameLength(true);
            daoConfiguration.setCheckLowerCase(true);
            configList.put(DATA_ACCESS_OBJECT, daoConfiguration);
            this.setConfigList(configList);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Unable to initialize Template", (String)e.getMessage());
        }
    }

    @Override
    public void addPages() {
        this.datasetCustomizationPage = WizardpageFactory.createDatasetCustomizationPropertyPage(this.getConfigList(), this.getRepositoryInformations());
        this.addPage((IWizardPage)this.datasetCustomizationPage);
        super.addPages();
    }

    @Override
    protected boolean doFinish() {
        this.wizardSettings.putAll(this.datasetCustomizationPage.getSettings());
        this.wizardSettings.put("IsCustomizationDatasetObject", true);
        this.wizardSettings.putAll(this.wizardMainPage.getSettings());
        String parentObject = (String)this.wizardSettings.get("ParentObject");
        String targetInstance = (String)this.wizardSettings.get("FileName");
        if (parentObject.equals(BUSINESS_ENTITY_OBJECT)) {
            String currentInstance = (String)this.wizardSettings.get("CurrentBeoInstance");
            if (!targetInstance.equals(currentInstance)) {
                if (((Boolean)this.wizardSettings.get("IsBEOCustomized")).booleanValue() && !MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Confirm Chagnes", (String)("The business entity object is already customized to instance \"" + currentInstance + "\"." + "Do you want to replace the customization with instance \"" + targetInstance + "\""))) {
                    return false;
                }
                this.getRepositoryDelegate().setDatasetCustomizationInstances((String)this.wizardSettings.get("DatasetName"), targetInstance, "");
            }
        } else {
            String currentInstance = (String)this.wizardSettings.get("CurrentDAOInstance");
            if (!targetInstance.equals(currentInstance)) {
                if (((Boolean)this.wizardSettings.get("IsDaoCustomized")).booleanValue() && !MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Confirm Chagnes", (String)("The data access object is already customized to instance \"" + currentInstance + "\"." + "Do you want to replace the customization with instance \"" + targetInstance + "\""))) {
                    return false;
                }
                this.getRepositoryDelegate().setDatasetCustomizationInstances((String)this.wizardSettings.get("DatasetName"), "", targetInstance);
            }
        }
        return super.doFinish();
    }
}

