/*
 * Decompiled with CFR 0.152.
 */
package com.progress.tools.reportbug.ui.wizard.composite;

import com.progress.tools.reportbug.Constants;
import com.progress.tools.reportbug.DefaultProductLog;
import com.progress.tools.reportbug.IContribution;
import com.progress.tools.reportbug.IProductLog;
import com.progress.tools.reportbug.ui.wizard.composite.JVMConfigured;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.ConfigurationInfo;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.about.AboutBundleData;
import org.eclipse.ui.internal.about.AboutData;
import org.osgi.framework.Bundle;

public class EclipseContribution
implements IContribution {
    private StringBuffer configDetails = new StringBuffer("");
    private StringBuffer versionDetails = new StringBuffer("");
    private boolean configPopulated = false;
    private File configHolderFile;
    private File versionInfoHolderFile;
    protected boolean versionDataPopulated = false;
    private static final String ERROR_LOG_ECLIPSE_LOCATION = "/.metadata/.log";

    public EclipseContribution() {
        this.createConfigHolderFile();
        this.createVersionInfoHolderFile();
        this.loadConfigSummary();
        this.loadVersionSummary();
    }

    private void loadConfigSummary() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    EclipseContribution.this.configDetails.append(ConfigurationInfo.getSystemSummary());
                }
                finally {
                    EclipseContribution.this.configPopulated = true;
                }
            }
        });
        t.start();
    }

    private void loadVersionSummary() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    EclipseContribution.this.versionDetails.append(EclipseContribution.this.getPluginRegistry());
                }
                finally {
                    EclipseContribution.this.versionDataPopulated = true;
                }
            }
        });
        t.start();
    }

    private void createConfigHolderFile() {
        try {
            this.configHolderFile = File.createTempFile("configFile", ".txt");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createVersionInfoHolderFile() {
        try {
            this.versionInfoHolderFile = File.createTempFile("versionInfoFile", ".txt");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<IProductLog> getLogs() {
        ArrayList<IProductLog> logs = new ArrayList<IProductLog>();
        try {
            logs.add(this.getConfigurationLog());
            logs.add(this.getErrorLog());
            logs.add(this.getVersionInfoLog());
            logs.add(this.getJVMConfigured());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return logs;
    }

    private IProductLog getJVMConfigured() {
        return new JVMConfigured();
    }

    private IProductLog getErrorLog() throws Exception {
        URI rawLocationURI = ResourcesPlugin.getWorkspace().getRoot().getRawLocationURI();
        return new DefaultProductLog(String.valueOf(new File(rawLocationURI).getAbsolutePath()) + ERROR_LOG_ECLIPSE_LOCATION, Constants.ERROR_LOG_FILE_NAME, Constants.ERROR_LOG_DESCRIPTION);
    }

    private IProductLog getConfigurationLog() throws Exception {
        while (!this.configPopulated) {
            Thread.sleep(1000L);
        }
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.configHolderFile), "UTF-8"));
        bw.write(this.configDetails.toString());
        bw.close();
        return new DefaultProductLog(this.configHolderFile.getAbsolutePath(), Constants.CONFIGURATION_LOG_FILE_NAME, Constants.CONFIGURATION_LOG_DESCRIPTION);
    }

    private IProductLog getVersionInfoLog() throws Exception {
        while (!this.versionDataPopulated) {
            Thread.sleep(1000L);
        }
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.versionInfoHolderFile), "UTF-8"));
        bw.write(this.versionDetails.toString());
        bw.close();
        return new DefaultProductLog(this.versionInfoHolderFile.getAbsolutePath(), Constants.VERSION_LOG_FILE_NAME, Constants.VERSION_LOG_DESCRIPTION);
    }

    private String getPluginRegistry() {
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        Bundle[] bundles = WorkbenchPlugin.getDefault().getBundles();
        AboutBundleData[] bundleInfos = new AboutBundleData[bundles.length];
        int i = 0;
        while (i < bundles.length) {
            bundleInfos[i] = new AboutBundleData(bundles[i]);
            ++i;
        }
        AboutData.sortById((boolean)false, (AboutData[])bundleInfos);
        i = 0;
        while (i < bundleInfos.length) {
            AboutBundleData info = bundleInfos[i];
            if (info.getId().startsWith("com.progress.") || info.getProviderName().equals("Progress Software Corporation")) {
                Object implVersion = info.getBundle().getHeaders().get("Implementation-Version");
                String pluginVersion = null;
                pluginVersion = implVersion != null ? (String)implVersion : info.getVersion();
                Object[] args = new String[]{info.getId(), pluginVersion, info.getName()};
                writer.println(NLS.bind((String)Constants.INSTALLED_PLUGINS_FORMAT, (Object[])args));
            }
            ++i;
        }
        return out.toString();
    }
}

