/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.core.service.rest;

import com.atlassian.jira.rest.client.domain.Field;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.eclipse.osgi.util.NLS;

public class JiraRestCustomFieldsParser {
    private JiraRestCustomFieldsParser() throws Exception {
        throw new Exception("Utility class");
    }

    public static List<String> parseMultiUserPicker(Field field) throws JSONException {
        ArrayList<String> users = new ArrayList<String>();
        JSONArray jsonArray = (JSONArray)field.getValue();
        int i = 0;
        while (i < jsonArray.length()) {
            Object o = jsonArray.get(i);
            if (o instanceof JSONObject) {
                users.add(JsonParseUtil.getOptionalString((JSONObject)((JSONObject)o), (String)"name"));
            }
            ++i;
        }
        return users;
    }

    public static String parseUserPicker(Field field) throws JSONException {
        JSONObject jsonValue = (JSONObject)field.getValue();
        String value = JsonParseUtil.getOptionalString((JSONObject)jsonValue, (String)"name");
        if (value == null) {
            throw new JSONException(NLS.bind((String)"Cannot parse field [{0}]", (Object)field.getName()));
        }
        return value;
    }

    public static String parseSelect(Field field) throws JSONException {
        JSONObject jsonValue = (JSONObject)field.getValue();
        String value = JsonParseUtil.getOptionalString((JSONObject)jsonValue, (String)"value");
        if (value == null) {
            throw new JSONException(NLS.bind((String)"Cannot parse field [{0}]", (Object)field.getName()));
        }
        return value;
    }

    public static List<String> parseMultiSelect(Field field) throws JSONException {
        ArrayList<String> values = new ArrayList<String>();
        JSONArray jsonArray = (JSONArray)field.getValue();
        int i = 0;
        while (i < jsonArray.length()) {
            Object o = jsonArray.get(i);
            if (o instanceof JSONObject) {
                values.add(JsonParseUtil.getOptionalString((JSONObject)((JSONObject)o), (String)"value"));
            }
            ++i;
        }
        return values;
    }

    public static List<String> parseLabels(Field field) throws JSONException {
        ArrayList<String> labels = new ArrayList<String>();
        JSONArray jsonArray = (JSONArray)field.getValue();
        int i = 0;
        while (i < jsonArray.length()) {
            Object o = jsonArray.get(i);
            if (o instanceof String) {
                labels.add((String)o);
            }
            ++i;
        }
        return labels;
    }

    public static String parseGroupPicker(Field field) throws JSONException {
        JSONObject jsonValue = (JSONObject)field.getValue();
        String group = JsonParseUtil.getOptionalString((JSONObject)jsonValue, (String)"name");
        if (group == null) {
            throw new JSONException(NLS.bind((String)"Cannot parse field [{0}]", (Object)field.getName()));
        }
        return group;
    }

    public static List<String> parseMultiGroupPicker(Field field) throws JSONException {
        ArrayList<String> groups = new ArrayList<String>();
        JSONArray jsonArray = (JSONArray)field.getValue();
        int i = 0;
        while (i < jsonArray.length()) {
            Object o = jsonArray.get(i);
            if (o instanceof JSONObject) {
                groups.add(JsonParseUtil.getOptionalString((JSONObject)((JSONObject)o), (String)"name"));
            }
            ++i;
        }
        return groups;
    }

    public static String parseSprint(Field field) throws JSONException {
        JSONArray jsonArray = (JSONArray)field.getValue();
        int i = 0;
        while (i < jsonArray.length()) {
            Object o = jsonArray.get(i);
            if (o instanceof String) {
                String[] sprintPartsList;
                boolean isActive = false;
                String sprintPartsString = StringUtils.substringBetween((String)((String)o), (String)"[", (String)"]");
                String[] stringArray = sprintPartsList = sprintPartsString.split(",");
                int n = sprintPartsList.length;
                int n2 = 0;
                while (n2 < n) {
                    String sprintPart = stringArray[n2];
                    String[] sprintPartsSubList = sprintPart.split("=");
                    if (sprintPartsSubList[0].equals("state") && sprintPartsSubList[1].equals("ACTIVE")) {
                        isActive = true;
                    }
                    if (isActive && sprintPartsSubList[0].equals("name") && !sprintPartsSubList[1].isEmpty()) {
                        return sprintPartsSubList[1];
                    }
                    ++n2;
                }
            }
            ++i;
        }
        return "";
    }
}

