/* ***********************************************************/
/* Copyright (c) 2010-2016 by Progress Software Corporation       */
/*                                                           */
/* All rights reserved.  No part of this program or document */
/* may be  reproduced in  any form  or by  any means without */
/* permission in writing from Progress Software Corporation. */
/*************************************************************/

/* this procedure loads the schema changes into the selected */
/* database schema. schema changes gets loaded through       */
/* .df file.                                                 */   

DEFINE INPUT PARAMETER cparam AS CHARACTER NO-UNDO.
DEFINE OUTPUT PARAMETER cError AS LONGCHAR NO-UNDO INITIAL "".

DEFINE VARIABLE dumpalias AS CHARACTER NO-UNDO.
DEFINE VARIABLE dumplocation AS CHARACTER NO-UNDO INITIAL "".
/*AddObjectsOnline,ForceCommit,ForceIndexDeactivate,ForceSharedSchema*/
DEFINE VARIABLE dump_pcoptions AS CHARACTER NO-UNDO.
DEFINE VARIABLE dump_pcwarnings AS CHARACTER NO-UNDO INITIAL "".

&GLOBAL-DEFINE COMMAND_SEPARATOR CHR(3)
&GLOBAL-DEFINE OPTION_SEPARATOR CHR(4)

RUN separateParams.

CREATE ALIAS DICTDB FOR DATABASE VALUE(dumpalias).


RUN invokeLoadDFSilent.

PROCEDURE invokeLoadDFSilent.
    DEFINE VARIABLE i AS INTEGER NO-UNDO.
    cError = "".
    RUN prodict/load_df_silent.r (INPUT dumplocation, INPUT dump_pcoptions, OUTPUT dump_pcwarnings).
    cError = "SUCCESS".
    CATCH e AS Progress.Lang.Error :
            DO i = 1 TO e:NumMessages:
                cError = cError + e:GetMessage(i) + CHR(10).
            END.
    END CATCH.    
END PROCEDURE.


PROCEDURE separateParams.

    DEFINE VARIABLE i           AS INTEGER   NO-UNDO.
    
    DEFINE VARIABLE OptionCount AS INTEGER   NO-UNDO.
    DEFINE VARIABLE cOption     AS CHARACTER NO-UNDO.
    DEFINE VARIABLE optName     AS CHARACTER NO-UNDO.
    DEFINE VARIABLE optValue    AS CHARACTER NO-UNDO.
    
    OptionCount = NUM-ENTRIES(cparam, {&COMMAND_SEPARATOR}).
    /*
        Should we reset to Unknown. If so we need to use. Whose responsibility to 
        reset this?
    */
    SECURITY-POLICY:XCODE-SESSION-KEY  =  ?.    
    DO i = 1 TO OptionCount:
        cOption = ENTRY(i, cparam, {&COMMAND_SEPARATOR}).
        OptName = ENTRY(1, cOption, {&OPTION_SEPARATOR}).
        optValue = ENTRY(2, cOption, {&OPTION_SEPARATOR}).
        CASE optName:
            WHEN "INPUT" THEN
                DO:
                    dumplocation = REPLACE(optValue, "~\", "/").
                END.
            WHEN "DB" THEN
                DO:
                    dumpalias = REPLACE(optValue, "~\", "/").
                END.  
            WHEN "OPTIONS" THEN
                DO:
                	dump_pcoptions = REPLACE(optValue, "~\", "/").
                END.

        END CASE.

    END.
    
END PROCEDURE.