/* *****************************************************************/
/* Copyright (c) 2009 by Progress Software Corporation             */
/*                                                                 */
/* All rights reserved.  No part of this program or document       */
/* may be  reproduced in  any form  or by  any means without       */
/* permission in writing from Progress Software Corporation.       */
/*******************************************************************/

define variable fLoggerHandle  as handle    no-undo.
define variable fContextHandle as handle    no-undo.

/* This is calculated on startup from setContextHandle  */
define variable fRunDir        as character no-undo.


/******************** MAIN BLOCK ***************************/

fRunDir = replace(this-procedure:file-name,"runtime/_idetxtruntime.p","").

/******************* END MAIN BLOCK ************************/

function log returns character 
	( input msg as character).
	
	if VALID-HANDLE(fLoggerHandle) then do:
	
		DYNAMIC-FUNCTION("log" in fLoggerHandle, msg).
	end.
	
end function.

/* hide as ade object in the persistent procedure viewer  */
procedure adepersistent:
end. 

procedure destroyObject:
    delete procedure this-procedure.
end procedure.

procedure setLoggerHandle:
    define input parameter hLogger as handle no-undo.
    fLoggerHandle = hLogger.
end.   

procedure setContextHandle:
    define input parameter hContext as handle no-undo.
    fContextHandle = hContext.
end.

procedure OpenProcedureEditor:
    define input parameter cPrm as character no-undo.
    run value(fRunDir + "runtime/_ideproedit.p") (input cPrm) no-error.
	if error-status:error then
		return error-status:get-message(1).
	return return-value.    
end procedure.