/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils;

import com.proalpha.git.model.PaCherryPickResult;
import com.proalpha.pds.gitutils.cherrypick.CherryPick;
import com.proalpha.pds.gitutils.common.Repository;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.jgit.api.CherryPickResult;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class GitUtilsPropertyTester
extends PropertyTester {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (property.equals("isConflict")) {
            PaCherryPickResult result = CherryPick.getInstance().getCherryPickResult();
            if (result == null) {
                return false;
            }
            if (result.getStatus() != CherryPickResult.CherryPickStatus.CONFLICTING) return false;
            return true;
        }
        if (property.equals("isMergetoolApplicable") && receiver instanceof RepositoryTreeNode) {
            RepositoryTreeNode node = (RepositoryTreeNode)receiver;
            org.eclipse.jgit.lib.Repository repository = node.getRepository();
            Git git = new Git(repository);
            try {
                Set conflictingFiles = git.status().call().getConflicting();
                Repository.getInstance().setConflictingFiles(new ArrayList<String>(conflictingFiles));
                if (!conflictingFiles.isEmpty()) return true;
                return false;
            }
            catch (NoWorkTreeException e) {
                e.printStackTrace();
                return false;
            }
            catch (GitAPIException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (property.equals("isOngoingCherryPick")) {
            if (CherryPick.getInstance().getCherryPickCommand() != null) {
                RepositoryTreeNode node;
                org.eclipse.jgit.lib.Repository repository;
                org.eclipse.jgit.lib.Repository cpRepo = CherryPick.getInstance().getCherryPickCommand().getRepository();
                if (receiver instanceof RepositoryTreeNode && (repository = (node = (RepositoryTreeNode)receiver).getRepository()) != null) {
                    return cpRepo.equals(repository);
                }
            }
            System.out.println("Property tester: " + property + "=" + "false");
            return false;
        }
        if (property.equals("canStartNewCherryPick")) {
            if (CherryPick.getInstance().getCherryPickCommand() != null) return false;
            return true;
        }
        if (!property.equals("isConsRepo")) return false;
        if (!(receiver instanceof RepositoryTreeNode)) return false;
        RepositoryTreeNode node = (RepositoryTreeNode)receiver;
        org.eclipse.jgit.lib.Repository repository = node.getRepository();
        String workspace = repository.getDirectory().getParent();
        JSONParser jsonParser = new JSONParser();
        try {
            Throwable throwable = null;
            Object var10_25 = null;
            try (FileReader reader = new FileReader(String.valueOf(workspace) + "/pa_config_project.json");){
                JSONObject obj = (JSONObject)jsonParser.parse((Reader)reader);
                if (!obj.containsKey((Object)"repository_type")) return false;
                String repositoryType = (String)obj.get((Object)"repository_type");
                if (!repositoryType.equals("cons")) return false;
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return false;
    }
}

