/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.pagit.util;

import com.proalpha.pds.pagit.PaGit;
import java.io.IOException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaGitTransaction {
    protected final Logger logger = LoggerFactory.getLogger(PaGitTransaction.class);
    private String commit;
    private String branch;

    public PaGitTransaction(String branch) throws IOException {
        Git git = PaGit.getInstance().getGit();
        this.branch = branch;
        this.commit = git.getRepository().resolve(branch).getName();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Starting transaction on branch {}. Current commit id = {}", (Object)branch, (Object)this.commit);
        }
    }

    private void rollback(String branch, String commit) throws IOException, GitAPIException {
        Git git = PaGit.getInstance().getGit();
        String oldBranch = null;
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Switching from branch {} to branch  {}.", (Object)git.getRepository().getBranch(), (Object)branch);
            }
            if (branch != git.getRepository().getBranch()) {
                oldBranch = git.getRepository().getBranch();
                git.checkout().setName(branch).call();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Reset tip of branch {}, current tip = {}, new tip = {}.", new Object[]{branch, git.getRepository().resolve("HEAD").getName(), commit});
            }
            git.reset().setMode(ResetCommand.ResetType.HARD).setRef(commit).call();
        }
        catch (Throwable throwable) {
            if (oldBranch != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Switching back from branch {} to branch  {}.", (Object)branch, (Object)oldBranch);
                }
                git.checkout().setName(oldBranch).call();
            }
            throw throwable;
        }
        if (oldBranch != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Switching back from branch {} to branch  {}.", (Object)branch, (Object)oldBranch);
            }
            git.checkout().setName(oldBranch).call();
        }
    }

    public void rollback() throws IOException, GitAPIException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Rollback branch {} to commit  {}.", (Object)this.branch, (Object)this.commit);
        }
        this.rollback(this.branch, this.commit);
    }
}

