/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.projconf.utils;

import com.proalpha.pds.paconnector.Activator;
import com.proalpha.pds.projconf.utils.Project;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ProjectWarningsPopup {
    private static List<Project> projectsToCheck(List<String> projectNamesToCheck, List<Project> allProjects) {
        List<Project> projectsToCheck = null;
        projectsToCheck = projectNamesToCheck != null ? projectNamesToCheck.stream().map(Object::toString).map(name -> Project.findProjectByName(name, allProjects)).filter(project -> project != null).collect(Collectors.toList()) : allProjects.stream().filter(project -> project.open()).collect(Collectors.toList());
        return projectsToCheck;
    }

    private static String message(List<Project> projectsToCheck, List<Project> allProjects) {
        return projectsToCheck.stream().map(project -> {
            Project projectWithSamePort = allProjects.stream().filter(p -> !p.equals(project) && p.dbPort() == project.dbPort()).findFirst().orElse(null);
            if (projectWithSamePort == null) {
                return "";
            }
            return String.format("You try to open project %s, but project %s uses the same database ports.", project.name(), projectWithSamePort.name());
        }).filter(warning -> warning != "").collect(Collectors.joining("\n\n"));
    }

    private static boolean show(List<Project> projectsToCheck, List<Project> allProjects, boolean async) {
        final String message = ProjectWarningsPopup.message(projectsToCheck, allProjects);
        if (message.equals("")) {
            return true;
        }
        if (async) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Warning", (String)message);
                }
            });
            return true;
        }
        return MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Warning", (String)message);
    }

    public static boolean sync(List<Project> projectsToCheck) {
        List<Project> allProjects = Project.all(Paths.get(Activator.getDefault().getPreferenceStore().getString("PaProjectDirectory"), new String[0]));
        return ProjectWarningsPopup.show(projectsToCheck, allProjects, false);
    }

    public static boolean async(List<String> projectNamesToCheck) {
        List<Project> allProjects = Project.all(Paths.get(Activator.getDefault().getPreferenceStore().getString("PaProjectDirectory"), new String[0]));
        List<Project> projectsToCheck = ProjectWarningsPopup.projectsToCheck(projectNamesToCheck, allProjects);
        if (projectsToCheck.isEmpty()) {
            return true;
        }
        return ProjectWarningsPopup.show(projectsToCheck, allProjects, true);
    }
}

