/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui.wizards.controller;

import com.proalpha.pds.generator.GeneratorFactory;
import com.proalpha.pds.generator.OOABLExitFileGenerator;
import com.proalpha.pds.paconnector.parameter.CustomLevel;
import com.proalpha.pds.paconnector.repository.Instance;
import com.proalpha.pds.paconnector.repository.RepositoryDelegate;
import com.proalpha.pds.templates.data.DataContainerFactory;
import com.proalpha.pds.templates.data.IGeneratorDataContainer;
import com.proalpha.pds.ui.wizards.controller.PaDynamicWizard;
import com.proalpha.pds.ui.wizards.wizardpages.WizardMainPageConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OOABLObject
extends PaDynamicWizard
implements INewWizard {
    private static final Logger logger = LoggerFactory.getLogger(OOABLObject.class);
    private static final String OO_ROOT_CLASS = "OOABL";
    private static final String CLASS_SUFFIX = ".cls";
    private static final String CUSTOM_CLASS_SUFFIX_PATTERN;
    private static final String PARENT_CLASS_TYPE_OO_JOB = "OO Job";
    private static final String PARENT_CLASS_TYPE_OO_WORKFLOW_JOB = "OO Workflow Job";
    private static final String OO_JOB_WRAPPER = "bjvjob02.p";
    private static final String OO_JOB_WRAPPER_PARENT_CLASS = "bjvjob02.p";
    private CustomLevel currentCustomLevel = null;
    private Map<String, GenerationPreprocessor> generationPreprocessorsByParentClass = new HashMap<String, GenerationPreprocessor>();
    private Boolean isGenerateUserExit;

    static {
        StringBuilder customLevelStringListBuilder = new StringBuilder();
        customLevelStringListBuilder.append("(?:");
        CustomLevel[] customLevelArray = CustomLevel.values();
        int n = customLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            CustomLevel customLevel = customLevelArray[n2];
            if (customLevelStringListBuilder.length() > 0) {
                customLevelStringListBuilder.append("|");
            }
            customLevelStringListBuilder.append(customLevel.getClassSuffix());
            ++n2;
        }
        customLevelStringListBuilder.append(")?\\.cls");
        CUSTOM_CLASS_SUFFIX_PATTERN = customLevelStringListBuilder.toString();
    }

    public OOABLObject() {
        try {
            this.isGenerateUserExit = Boolean.FALSE;
            ArrayList<String> extensionList = new ArrayList<String>();
            extensionList.add("cls");
            WizardMainPageConfiguration configuration = new WizardMainPageConfiguration();
            configuration.setWizardTitle("proALPHA OOABL Class File");
            configuration.setWizardDescription("This wizard creates a new proALPHA OOABL Class File.");
            configuration.setTemplateName("pAOOABLClass");
            configuration.setExtensionList(extensionList);
            configuration.setRootClass(OO_ROOT_CLASS);
            configuration.setThirdDigit("C");
            configuration.setCheckRepository(true);
            configuration.setSupportRepositoryCreateButton(true);
            configuration.setCheckFileNameLength(false);
            configuration.setCheckLowerCase(false);
            this.generationPreprocessorsByParentClass.put(PARENT_CLASS_TYPE_OO_JOB, new OOJobPreprocessor(this.getRepositoryDelegate(), Collections.singleton("basis.job.cls.BJCBaseJob"), "BJCBaseJob", Arrays.asList("paOOJobConstructorImpl"), Arrays.asList("paOOJobMethodImpl")));
            this.generationPreprocessorsByParentClass.put(PARENT_CLASS_TYPE_OO_WORKFLOW_JOB, new OOJobPreprocessor(this.getRepositoryDelegate(), Collections.singleton("basis.job.cls.BJCWorkflowBaseWfj"), "BJCWorkflowBaseWfj", Arrays.asList("paOOJobConstructorImpl"), Arrays.asList("paOOWorkflowJobMethodImpl")));
            WizardMainPageConfiguration configuration1 = new WizardMainPageConfiguration();
            configuration1.setWizardTitle("proALPHA OOABL Form File");
            configuration1.setWizardDescription("This wizard creates a new proALPHA OOABL Form File.");
            configuration1.setTemplateName("pAOOABLForm");
            configuration1.setExtensionList(extensionList);
            configuration1.setRootClass(OO_ROOT_CLASS);
            configuration1.setThirdDigit("C");
            configuration1.setCheckRepository(true);
            configuration1.setSupportRepositoryCreateButton(true);
            configuration1.setCheckFileNameLength(false);
            configuration1.setCheckLowerCase(false);
            WizardMainPageConfiguration configuration2 = new WizardMainPageConfiguration();
            configuration2.setWizardTitle("proALPHA Interface File");
            configuration2.setWizardDescription("This wizard creates a new proALPHA Interface File.");
            configuration2.setTemplateName("pAOOABLInterface");
            configuration2.setExtensionList(extensionList);
            configuration2.setRootClass(OO_ROOT_CLASS);
            configuration2.setThirdDigit("I");
            configuration2.setCheckRepository(true);
            configuration2.setSupportRepositoryCreateButton(true);
            configuration2.setCheckFileNameLength(false);
            configuration2.setCheckLowerCase(false);
            LinkedHashMap<String, WizardMainPageConfiguration> configList = new LinkedHashMap<String, WizardMainPageConfiguration>();
            configList.put("OOABL Class", configuration);
            configList.put("OOABL Form", configuration1);
            configList.put("OOABL Interface", configuration2);
            this.setConfigList(configList);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Unable to initialize Template", (String)e.getMessage());
        }
    }

    @Override
    protected boolean doFinish() {
        try {
            if (this.isGenerateUserExit.booleanValue()) {
                this.generateUserExitClassAndBalpEntry();
            } else {
                this.generatorMainClassAndStdClass();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    private void generatorMainClassAndStdClass() throws Exception {
        String targetSuffix;
        String fileName = (String)this.wizardSettings.get("FileName");
        if (!fileName.endsWith(targetSuffix = String.valueOf(this.getCurrentCustomLevel().getClassSuffix()) + CLASS_SUFFIX)) {
            fileName = fileName.replaceAll(CUSTOM_CLASS_SUFFIX_PATTERN, targetSuffix);
        }
        this.wizardSettings.put("CustomLevel", this.getCurrentCustomLevel().getValue());
        this.wizardSettings.put("CustomFileName", fileName);
        this.wizardSettings.put("StandardFileName", fileName);
        GenerationPreprocessor preprocessor = this.generationPreprocessorsByParentClass.get((String)this.wizardSettings.get("ParentObject"));
        if (preprocessor != null) {
            preprocessor.run(this.wizardSettings);
        }
        DataContainerFactory factory = new DataContainerFactory();
        IGeneratorDataContainer datacontainer = factory.createDataContainer(this.paProject, this.cloneWizardSettings());
        GeneratorFactory generatorFactory = new GeneratorFactory();
        String stdTemplate = this.wizardSettings.get("TemplateName").toString();
        if (!stdTemplate.endsWith("Form")) {
            stdTemplate = stdTemplate.replace("pAOOABL", "pAOOABLStd");
        }
        OOABLExitFileGenerator oOABLClass = generatorFactory.createOOABLExitFileGenerator(datacontainer, stdTemplate);
        oOABLClass.generate();
        super.doFinish();
    }

    private void generateUserExitClassAndBalpEntry() throws Exception {
        String fileName = (String)this.wizardSettings.get("FileName");
        this.wizardSettings.put("CustomLevel", this.getCurrentCustomLevel().getValue());
        this.wizardSettings.put("CustomFileName", fileName);
        DataContainerFactory factory = new DataContainerFactory();
        IGeneratorDataContainer datacontainer = factory.createDataContainer(this.paProject, this.wizardSettings);
        OOABLExitFileGenerator oOABLClass = null;
        GeneratorFactory generatorFactory = new GeneratorFactory();
        oOABLClass = this.wizardSettings.get("TemplateName").toString().equals("pAOOABLInterface") ? generatorFactory.createOOABLExitFileGenerator(datacontainer, "pAOOABLStdInterface") : generatorFactory.createOOABLExitFileGenerator(datacontainer, "pAOOABLStdClass");
        oOABLClass.generateUserExitClassAndBalpEntry();
    }

    public void setCurrentCustomLevel(CustomLevel currentCustomLevel) {
        this.currentCustomLevel = currentCustomLevel;
    }

    public CustomLevel getCurrentCustomLevel() {
        if (this.currentCustomLevel == null) {
            this.currentCustomLevel = CustomLevel.getByValue((String)this.getStartparameterReader().getCurrentCustomLevel());
        }
        return this.currentCustomLevel;
    }

    public void setIsGerateUserExit(Boolean value) {
        this.isGenerateUserExit = value;
    }

    private static interface GenerationPreprocessor {
        public void run(Map<String, Object> var1);
    }

    private class OOClassPreprocessor
    implements GenerationPreprocessor {
        private Set<String> usingStatements = null;
        private String parentClassName = "";
        private List<String> constructorSnippetTemplates = null;
        private List<String> methodSnippetTemplates = null;

        public OOClassPreprocessor(Set<String> usingStatements, String parentClass, List<String> constructorSnippetTemplates, List<String> methodSnippetTemplates) {
            this.usingStatements = usingStatements;
            this.parentClassName = parentClass;
            this.constructorSnippetTemplates = constructorSnippetTemplates;
            this.methodSnippetTemplates = methodSnippetTemplates;
        }

        @Override
        public void run(Map<String, Object> wizardSettings) {
            if (this.usingStatements != null) {
                wizardSettings.put("UsingStatements", this.usingStatements);
            }
            if (this.parentClassName != null) {
                wizardSettings.put("qualifiedParentClassName", this.parentClassName);
            }
            if (this.constructorSnippetTemplates != null) {
                wizardSettings.put("ConstructorSnippetTemplates", this.constructorSnippetTemplates);
            }
            if (this.methodSnippetTemplates != null) {
                wizardSettings.put("MethodSnippetTemplates", this.methodSnippetTemplates);
            }
        }
    }

    private class OOJobPreprocessor
    extends OOClassPreprocessor {
        RepositoryDelegate repositoryDelegate;

        public OOJobPreprocessor(RepositoryDelegate repositoryDelegate, Set<String> usingStatements, String parentClass, List<String> constructorSnippetTemplates, List<String> methodSnippetTemplates) {
            super(usingStatements, parentClass, constructorSnippetTemplates, methodSnippetTemplates);
            this.repositoryDelegate = null;
            this.repositoryDelegate = repositoryDelegate;
        }

        @Override
        public void run(Map<String, Object> wizardSettings) {
            super.run(wizardSettings);
            this.createOOJobWrapperRepositoryInstance((String)wizardSettings.get("FileName"));
        }

        private void createOOJobWrapperRepositoryInstance(String filename) {
            String className = filename.substring(0, filename.indexOf("."));
            String ooJobWrapperProcName = "bjvjob02.p#" + className;
            Instance instance = this.repositoryDelegate.getEmptyInstance();
            instance.setName(ooJobWrapperProcName);
            instance.setShortDescription("Wrapper instance for OO Job " + className);
            instance.setParentClass("bjvjob02.p");
            this.repositoryDelegate.createRepositoryEntryforInstance(instance);
        }
    }
}

