/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui.wizards.wizardpages;

import com.proalpha.pds.paconnector.PaProject;
import com.proalpha.pds.templates.data.OOInterfaceTemplate;
import com.proalpha.pds.templates.data.OOType;
import com.proalpha.pds.ui.wizards.wizardpages.InterfaceSelectionWizardPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class InstanceListenerWizardPage
extends InterfaceSelectionWizardPage {
    private static final String GENERATE_SAMPLES_INIT_VALUE = "GENERATE_SAMPLES_INIT_VALUE";
    private Button generateSamplesButton = null;

    public InstanceListenerWizardPage(PaProject paProject) {
        super("InstanceListenerWizardPage");
        this.setPaProject(paProject);
        this.setTitle("Instance Listener Options");
        this.setDescription("Select Instance Listener types to implement");
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.createUserInterfaceGroup(container);
        this.createDatabaseTriggerGroup(container);
        this.createSampleGroup(container);
        this.setControl((Control)container);
        this.initState();
    }

    private void initState() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings.get(GENERATE_SAMPLES_INIT_VALUE) != null) {
            this.setUseAdditionalTemplates(settings.getBoolean(GENERATE_SAMPLES_INIT_VALUE));
        }
        this.generateSamplesButton.setSelection(this.getUseAdditionalTemplates());
        this.updateSampleButtonState();
    }

    private void createDatabaseTriggerGroup(Composite parent) {
        Group databaseTriggerGroup = this.createGroup(parent, "Database Trigger");
        Button databaseTriggerEventButton = this.createInterfaceButton((Composite)databaseTriggerGroup, "Database Trigger Events", new OOInterfaceTemplate(new OOType("adm.method.cls", "DMITriggerProcedureLst"), new String[]{"adm.method.cls.DMITriggerProcedureLst", "adm.method.cls.DMCTriggerProcedureSvo"}, "paOOAblInterfaceImplDMITriggerProcedureLst", new String[]{"paOOAblTriggerEventSubscriptionMethodSample"}));
        this.addSelectionListenerToUpdateSampleButtonState(databaseTriggerEventButton);
    }

    private void createUserInterfaceGroup(Composite parent) {
        Group userInterfaceGroup = this.createGroup(parent, "User Interface");
        Button windowEventButton = this.createInterfaceButton((Composite)userInterfaceGroup, "Window Events", new OOInterfaceTemplate(new OOType("adm.method.cls", "DMIWindowEventLst"), new String[]{"adm.method.cls.DMIWindowEventLst", "adm.method.cls.DMCWindowSvo"}, "paOOAblInterfaceImplDMIWindowEventLst", new String[]{"paOOAblWindowEventSubscriptionMethodSample"}));
        this.addSelectionListenerToUpdateSampleButtonState(windowEventButton);
        Button widgetEventButton = this.createInterfaceButton((Composite)userInterfaceGroup, "Widget Events", new OOInterfaceTemplate(new OOType("adm.method.cls", "DMIWidgetEventLst"), new String[]{"adm.method.cls.DMIWidgetEventLst", "adm.method.cls.DMCUIProcedureSvo", "adm.method.cls.DMCWidgetSvo"}, "paOOAblInterfaceImplDMIWidgetEventLst", new String[]{"paOOAblWidgetEventSubscriptionMethodSample"}));
        this.addSelectionListenerToUpdateSampleButtonState(widgetEventButton);
        Button uiProcedureEventsButton = this.createInterfaceButton((Composite)userInterfaceGroup, "UI Procedure Events", new OOInterfaceTemplate(new OOType("adm.method.cls", "DMIUIProcedureEventLst"), new String[]{"adm.method.cls.DMIUIProcedureEventLst", "adm.method.cls.DMCUIProcedureSvo"}, "paOOAblInterfaceImplDMIUIProcedureEventLst", new String[]{"paOOAblUIProcedureEventSubscriptionMethodSample"}));
        this.addSelectionListenerToUpdateSampleButtonState(uiProcedureEventsButton);
        Button browseEventButton = this.createInterfaceButton((Composite)userInterfaceGroup, "Browse Events", new OOInterfaceTemplate(new OOType("adm.method.cls", "DMIBrowseEventLst"), new String[]{"adm.method.cls.DMIBrowseEventLst", "adm.method.cls.DMCUIProcedureSvo", "adm.method.cls.DMCBrowseSvo"}, "paOOAblInterfaceImplDMIBrowseEventLst", new String[]{"paOOAblBrowseEventSubscriptionMethodSample"}));
        this.addSelectionListenerToUpdateSampleButtonState(browseEventButton);
        Button PrintOrFilterDialogEventButton = this.createInterfaceButton((Composite)userInterfaceGroup, "Print or Filter Dialog Events", new OOInterfaceTemplate(new OOType("adm.method.cls", "DMIPrintOrFilterDialogEventLst"), new String[]{"adm.method.cls.DMIPrintOrFilterDialogEventLst", "adm.method.cls.DMCPrintOrFilterDialogSvo"}, "paOOAblInterfaceImplDMIPrintOrFilterDialogEventLst", new String[]{"paOOAblDMIPrintOrFilterDialogEventSubscriptionMethodSample"}));
        this.addSelectionListenerToUpdateSampleButtonState(PrintOrFilterDialogEventButton);
    }

    private void addSelectionListenerToUpdateSampleButtonState(Button button) {
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstanceListenerWizardPage.this.updateSampleButtonState();
            }
        });
    }

    private void createSampleGroup(Composite parent) {
        Group sampleGroup = this.createGroup(parent, "Examples");
        this.generateSamplesButton = new Button((Composite)sampleGroup, 32);
        this.generateSamplesButton.setText("Generate Examples");
        this.generateSamplesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstanceListenerWizardPage.this.setUseAdditionalTemplates(InstanceListenerWizardPage.this.generateSamplesButton.getSelection());
                IDialogSettings settings = InstanceListenerWizardPage.this.getDialogSettings();
                settings.put(InstanceListenerWizardPage.GENERATE_SAMPLES_INIT_VALUE, InstanceListenerWizardPage.this.getUseAdditionalTemplates());
            }
        });
    }

    private void updateSampleButtonState() {
        this.generateSamplesButton.setEnabled(this.getSelectedTemplates().size() > 0);
    }
}

