/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui.handlers;

import com.proalpha.pds.paconnector.Activator;
import com.proalpha.pds.paconnector.PaProject;
import com.proalpha.pds.paconnector.exception.ProALPHANotAvailableException;
import com.proalpha.pds.paconnector.utils.ExceptionUtils;
import com.proalpha.pds.ui.AbstractProAlphaHandler;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.IProgressService;

public class RunProAlphaProgramHandler
extends AbstractProAlphaHandler {
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            PaProject paProject = this.getPaProjectOfEvent(event);
            String fileName = this.getOeFileOfEvent(event);
            RunProAlphaProgramHandler.runProgram(paProject, fileName);
        }
        catch (ProALPHANotAvailableException e) {
            ExceptionUtils.showAndLogErrorMessage((AbstractUIPlugin)Activator.getDefault(), (Throwable)e);
        }
        return null;
    }

    private static void runProgram(PaProject paProject, String fileName) {
        IRunnableWithProgress runnable = monitor -> {
            monitor.beginTask("Run Proalpha Program", 2);
            monitor.worked(1);
            paProject.getBridge().runProgram(fileName);
            monitor.done();
        };
        IWorkspaceRoot rule = ResourcesPlugin.getWorkspace().getRoot();
        IProgressService context = PlatformUI.getWorkbench().getProgressService();
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, runnable, (ISchedulingRule)rule);
        }
        catch (InvocationTargetException e) {
            ExceptionUtils.showAndLogErrorMessage((AbstractUIPlugin)Activator.getDefault(), (Throwable)e);
        }
        catch (InterruptedException e) {
            ExceptionUtils.showAndLogErrorMessage((AbstractUIPlugin)Activator.getDefault(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }
}

