/*
 * Decompiled with CFR 0.152.
 */
package com.progress.tools.reportbug.configinfo;

import com.progress.tools.reportbug.configinfo.ConfigInfo;
import com.progress.tools.reportbug.model.EntryType;
import com.progress.tools.reportbug.model.ProductType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class ConfigInfoUtil {
    private static ConfigInfo[] getConfigInfo() {
        ArrayList<ConfigInfo> products = new ArrayList<ConfigInfo>();
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("com.progress.tools.reportbug.thirdpartyproducts");
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                Object o = iConfigurationElement.createExecutableExtension("class");
                if (o instanceof ConfigInfo) {
                    products.add((ConfigInfo)o);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return products.size() == 0 ? null : products.toArray(new ConfigInfo[0]);
    }

    public static ProductType[] getProducts() {
        ArrayList<ProductType> products = new ArrayList<ProductType>();
        ConfigInfo[] configInfo = ConfigInfoUtil.getConfigInfo();
        if (configInfo != null) {
            ConfigInfo[] configInfoArray = configInfo;
            int n = configInfo.length;
            int n2 = 0;
            while (n2 < n) {
                ConfigInfo configInfo2 = configInfoArray[n2];
                products.add(ConfigInfoUtil.getProductType(configInfo2));
                ++n2;
            }
        }
        return products.size() == 0 ? null : products.toArray(new ProductType[0]);
    }

    private static ProductType getProductType(ConfigInfo info) {
        ProductType product = new ProductType();
        product.setName(info.getName());
        product.setVersion(info.getVersion());
        if (info.getBuildNumber() != null) {
            product.setBuildNumber(info.getBuildNumber());
        }
        Map<String, String> environment = info.getEnvironment();
        List<EntryType> entries = product.getEntry();
        for (String key : environment.keySet()) {
            EntryType entry = new EntryType();
            entry.setName(key);
            entry.setValue(environment.get(key));
            entries.add(entry);
        }
        return product;
    }
}

