/*
 * Decompiled with CFR 0.152.
 */
package com.progress.tools.reportbug;

import com.progress.tools.installinfo.IProduct;
import com.progress.tools.reportbug.configinfo.ConfigInfoUtil;
import com.progress.tools.reportbug.model.BugType;
import com.progress.tools.reportbug.model.ConfigurationInfoType;
import com.progress.tools.reportbug.model.CustomerType;
import com.progress.tools.reportbug.model.EntryType;
import com.progress.tools.reportbug.model.ProductType;
import com.progress.tools.reportbug.model.ProgressProductType;
import com.progress.tools.reportbug.model.ProgressProductsType;
import com.progress.tools.reportbug.model.Report;
import com.progress.tools.reportbug.store.ProductImpl;
import com.progress.tools.reportbug.store.ProductRegistrationStore;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class ReportGenerator {
    private static ReportGenerator instance = null;
    JAXBContext context;

    ReportGenerator() {
        try {
            this.context = JAXBContext.newInstance((String)"com.progress.tools.reportbug.model");
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    public static ReportGenerator getInstance() {
        if (instance == null) {
            instance = new ReportGenerator();
        }
        return instance;
    }

    public Report generateReport(BugType info) {
        Report report = new Report();
        report.setBugInfo(info);
        report.setConfigurationInfo(this.getConfigInfo());
        report.setProgressProductsInstalled(this.getProgressProductsInstalled());
        report.setCustomerInfo(this.getCustomerInfo());
        report.setVersion(this.getVersion());
        return report;
    }

    private CustomerType getCustomerInfo() {
        return ProductRegistrationStore.getInstance().getCustomerInfo();
    }

    public File getReportAsXmlFile(BugType info) {
        Report report = this.generateReport(info);
        File file = null;
        FileOutputStream fileOutputStream = null;
        if (this.context != null) {
            try {
                try {
                    file = File.createTempFile("bugReport", "xml");
                    file.deleteOnExit();
                    Marshaller marshaller = this.context.createMarshaller();
                    marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                    fileOutputStream = new FileOutputStream(file);
                    marshaller.marshal((Object)report, (OutputStream)fileOutputStream);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return file;
    }

    private BigDecimal getVersion() {
        return new BigDecimal(1.0);
    }

    private ProgressProductsType getProgressProductsInstalled() {
        List<ProductImpl> products = ProductRegistrationStore.getInstance().getProductInfo();
        ProgressProductsType type = new ProgressProductsType();
        for (IProduct iProduct : products) {
            ProgressProductType progressProduct = new ProgressProductType();
            progressProduct.setBuildNumber(iProduct.getBuildNumber());
            progressProduct.setLicenseKey(iProduct.getLicenseKey());
            progressProduct.setName(iProduct.getName());
            progressProduct.setProductRuntime(iProduct.getProductRuntime());
            progressProduct.setProductRuntimeVersion(iProduct.getProductRuntimeVersion());
            progressProduct.setSerialNumber(iProduct.getSerialNumber());
            progressProduct.setVersion(iProduct.getVersion() != null ? iProduct.getVersion().toString() : "");
            Map environment = iProduct.getEnvironment();
            if (environment != null) {
                for (String key : environment.keySet()) {
                    EntryType entryType = new EntryType();
                    entryType.setName(key);
                    entryType.setValue((String)environment.get(key));
                    progressProduct.getEntry().add(entryType);
                }
            }
            type.getProgressProduct().add(progressProduct);
        }
        return type;
    }

    private ConfigurationInfoType getConfigInfo() {
        ConfigurationInfoType type = new ConfigurationInfoType();
        ProductType[] products = ConfigInfoUtil.getProducts();
        if (products != null) {
            ProductType[] productTypeArray = products;
            int n = products.length;
            int n2 = 0;
            while (n2 < n) {
                ProductType productType = productTypeArray[n2];
                type.getProduct().add(productType);
                ++n2;
            }
        }
        return type;
    }

    public Report parseXML(InputStream is) throws Exception {
        Unmarshaller unmarshaller = this.context.createUnmarshaller();
        Object object = unmarshaller.unmarshal(is);
        Report report = (Report)object;
        return report;
    }
}

