/*
 * Decompiled with CFR 0.152.
 */
package com.progress.tools.reportbug.ui.preference;

import com.progress.tools.reportbug.store.ProductRegistrationStore;
import com.progress.tools.reportbug.ui.Activator;
import com.progress.tools.reportbug.ui.preference.CustomerInfoComposite;
import com.progress.tools.reportbug.ui.preference.ProductDetailsComposite;
import com.progress.tools.reportbug.ui.validation.PreferencePageSupport;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class ProductRegistrationPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private CustomerInfoComposite customerInfoComposite;
    private ProductDetailsComposite productDetailsComposite;
    private DataBindingContext dbc;

    protected Control createContents(Composite parent) {
        this.dbc = new DataBindingContext();
        this.addValidationSupport();
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(1, false));
        this.createCustomerInfo(comp);
        this.createProductDetails(comp);
        this.initializeValue();
        this.setContextHelp(comp);
        return comp;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Button btn = this.getDefaultsButton();
        if (btn != null) {
            btn.setEnabled(false);
        }
    }

    private void addValidationSupport() {
        PreferencePageSupport.create(this, this.dbc);
    }

    private void createCustomerInfo(Composite comp) {
        this.customerInfoComposite = new CustomerInfoComposite(comp, this.dbc, 0);
        this.customerInfoComposite.setLayoutData(new GridData(4, 4, true, false));
    }

    private void createProductDetails(Composite comp) {
        this.productDetailsComposite = new ProductDetailsComposite(comp, 0);
        this.productDetailsComposite.setLayoutData(new GridData(4, 4, true, true));
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public boolean performOk() {
        return this.storeValues();
    }

    private boolean storeValues() {
        ProductRegistrationStore.getInstance().storeCustomerInfo(this.customerInfoComposite.getCustomerInfo());
        ProductRegistrationStore.getInstance().storeProductInfo(this.productDetailsComposite.getInput());
        return true;
    }

    private void initializeValue() {
        this.productDetailsComposite.setInput(ProductRegistrationStore.getInstance().getProductInfo());
        this.customerInfoComposite.setCustomerInfo(ProductRegistrationStore.getInstance().getCustomerInfo());
    }

    protected void performApply() {
        this.storeValues();
    }

    void setContextHelp(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.progress.tools.reportbug.ui.ProductRegistrationPage");
    }
}

