/*
 * Decompiled with CFR 0.152.
 */
package com.progress.tools.reportbug.ui.wizard.composite;

import com.progress.tools.installinfo.IProduct;
import com.progress.tools.installinfo.util.ProductInfoUtil;
import com.progress.tools.reportbug.Constants;
import com.progress.tools.reportbug.IContribution;
import com.progress.tools.reportbug.IProductLog;
import com.progress.tools.reportbug.IProductLog2;
import com.progress.tools.reportbug.model.Attachment;
import com.progress.tools.reportbug.model.ProductAttachment;
import com.progress.tools.reportbug.ui.Messages;
import com.progress.tools.reportbug.ui.ReportBugDialog;
import com.progress.tools.reportbug.ui.dialogs.ViewDetailsDialog;
import com.progress.tools.reportbug.ui.wizard.composite.AttachmentsComposite;
import com.progress.tools.reportbug.ui.wizard.composite.EclipseContribution;
import com.progress.tools.reportbug.ui.wizard.composite.LogCheckStateProvider;
import com.progress.tools.reportbug.ui.wizard.composite.LogContentProvider;
import com.progress.tools.reportbug.ui.wizard.composite.LogLabelProvider;
import com.progress.tools.reportbug.util.ProductContributionUtil;
import com.progress.tools.reportbug.zipper.SizeCalculator;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class LogComposite
extends Composite
implements ISelectionChangedListener {
    CheckboxTreeViewer viewer;
    EclipseContribution eclipseContribution;
    private AttachmentsComposite attachmentsComposite;
    private long previousSize = 0L;
    private Button viewButton;
    private Button selectAll;
    private Button deselectAll;
    private ReportBugDialog dialog;

    public LogComposite(ReportBugDialog dialog, Composite parent, AttachmentsComposite attachmentsComposite, int style) {
        this(parent, attachmentsComposite, style);
        this.dialog = dialog;
    }

    public LogComposite(Composite parent, AttachmentsComposite attachmentsComposite, int style) {
        super(parent, style);
        this.attachmentsComposite = attachmentsComposite;
        this.eclipseContribution = new EclipseContribution();
        this.createUI();
        this.init();
    }

    public List<Attachment> getAttachments() {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        TreeItem[] treeItems = this.viewer.getTree().getItems();
        String pathInZip = null;
        String parentPathInZip = null;
        String newPath = null;
        TreeItem[] treeItemArray = treeItems;
        int n = treeItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem parentItem = treeItemArray[n2];
            parentPathInZip = parentItem.getText().equals(Constants.ECLIPSE_KEY) ? "eclipse_logs" : "product_logs/" + parentItem.getText();
            TreeItem[] treeItemArray2 = parentItem.getItems();
            int n3 = treeItemArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem childItem = treeItemArray2[n4];
                pathInZip = String.valueOf(parentPathInZip) + "/" + childItem.getText();
                newPath = String.valueOf(parentPathInZip) + "/";
                Object data = childItem.getData();
                if (data instanceof IProductLog && childItem.getChecked()) {
                    IProductLog productLog = (IProductLog)data;
                    ProductAttachment attachment = null;
                    attachment = productLog instanceof IProductLog2 ? new ProductAttachment(newPath, productLog, ((IProductLog2)productLog).getFileName()) : new ProductAttachment(pathInZip, productLog);
                    attachment.setSelected(true);
                    attachments.add((Attachment)attachment);
                }
                ++n4;
            }
            ++n2;
        }
        return attachments;
    }

    private void createUI() {
        Composite parent = new Composite((Composite)this, 0);
        parent.setToolTipText(Messages.AttachmentsComposite_logTabTooltip);
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        parent.setLayout((Layout)new GridLayout(2, false));
        this.viewer = new CheckboxTreeViewer(parent);
        this.viewer.getTree().setToolTipText(Messages.AttachmentsComposite_logTabTooltip);
        GridData data = new GridData(4, 4, true, false);
        data.heightHint = 70;
        this.viewer.getTree().setLayoutData((Object)data);
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                LogComposite.this.viewer.setSubtreeChecked(event.getElement(), event.getChecked());
                LogComposite.this.updateRootNodes();
                LogComposite.this.updateSize();
                if (LogComposite.this.dialog != null) {
                    LogComposite.this.dialog.validate();
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                LogComposite.this.openViewDetailsDialog();
            }
        });
        Composite buttons = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        buttons.setLayout((Layout)layout);
        buttons.setLayoutData((Object)new GridData(4, 128, false, false));
        this.viewButton = new Button(buttons, 8);
        this.viewButton.setText(Messages.LogComposite_VIEW_BUTTON_TEXT);
        this.viewButton.setToolTipText(Messages.ReportBugDialog_viewButtonTooltip);
        this.viewButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.viewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogComposite.this.openViewDetailsDialog();
            }
        });
        this.viewButton.setEnabled(false);
        this.selectAll = new Button(buttons, 8);
        this.selectAll.setText(Messages.BasicInformationWizardPage_SelectAll);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.horizontalSpan = 2;
        this.selectAll.setLayoutData((Object)layoutData);
        this.selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogComposite.this.selectOrDeselectAll(true);
                if (LogComposite.this.dialog != null) {
                    LogComposite.this.dialog.validate();
                }
            }
        });
        this.deselectAll = new Button(buttons, 8);
        this.deselectAll.setText(Messages.BasicInformationWizardPage_DeSelectAll);
        GridData layoutData1 = new GridData(4, 4, true, true);
        layoutData1.horizontalSpan = 2;
        this.deselectAll.setLayoutData((Object)layoutData1);
        this.deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogComposite.this.selectOrDeselectAll(false);
                if (LogComposite.this.dialog != null) {
                    LogComposite.this.dialog.validate();
                }
            }
        });
    }

    private void openViewDetailsDialog() {
        Object firstElement;
        ISelection selection = this.viewer.getSelection();
        if (selection != null && (firstElement = ((TreeSelection)selection).getFirstElement()) instanceof IProductLog) {
            ViewDetailsDialog dialog = new ViewDetailsDialog(Display.getDefault().getActiveShell(), (IProductLog)firstElement);
            dialog.open();
        }
    }

    private void selectOrDeselectAll(boolean state) {
        LogContentProvider prv = (LogContentProvider)this.viewer.getContentProvider();
        Object[] viewerElements = prv.getElements(this.viewer.getInput());
        int i = 0;
        while (i < viewerElements.length) {
            this.viewer.setSubtreeChecked(viewerElements[i], state);
            ++i;
        }
        this.updateRootNodes();
        this.updateSize();
    }

    private void init() {
        this.viewer.setContentProvider((IContentProvider)new LogContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LogLabelProvider());
        this.viewer.setCheckStateProvider((ICheckStateProvider)new LogCheckStateProvider());
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.viewer.setInput(this.getInput());
        this.viewer.expandAll();
        this.updateRootNodes();
        this.updateSize();
    }

    private void updateRootNodes() {
        TreeItem[] items;
        Tree tree = this.viewer.getTree();
        TreeItem[] treeItemArray = items = tree.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            TreeItem[] childItems = treeItem.getItems();
            boolean allItemsChecked = true;
            boolean allItemsUnChecked = true;
            TreeItem[] treeItemArray2 = childItems;
            int n3 = childItems.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem treeItem2 = treeItemArray2[n4];
                if (treeItem2.getChecked()) {
                    allItemsUnChecked = false;
                } else {
                    allItemsChecked = false;
                }
                ++n4;
            }
            if (allItemsChecked) {
                treeItem.setChecked(true);
                treeItem.setGrayed(false);
            } else if (allItemsUnChecked) {
                treeItem.setChecked(false);
                treeItem.setGrayed(false);
            } else {
                treeItem.setChecked(true);
                treeItem.setGrayed(true);
            }
            ++n2;
        }
    }

    private void updateSize() {
        Object[] elements;
        this.attachmentsComposite.updateSize(this.previousSize, "remove");
        long size = 0L;
        Object[] objectArray = elements = this.viewer.getCheckedElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                Object element = objectArray[n2];
                if (element instanceof IProductLog) {
                    IProductLog productLog = (IProductLog)element;
                    try {
                        try {
                            productLog.preFinish();
                            size += SizeCalculator.calculateSize((String)productLog.getName(), (InputStream)productLog.getInputStream());
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            productLog.postFinish();
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        productLog.postFinish();
                        throw throwable;
                    }
                    productLog.postFinish();
                }
            }
            ++n2;
        }
        this.attachmentsComposite.updateSize(size, "add");
        this.attachmentsComposite.updateSizeComponent();
        this.previousSize = size;
    }

    private Object getInput() {
        LinkedHashMap<String, IContribution> map = new LinkedHashMap<String, IContribution>();
        map.put(Constants.ECLIPSE_KEY, this.eclipseContribution);
        this.populateProductSpecificDetails(map);
        return map;
    }

    private void populateProductSpecificDetails(Map<String, IContribution> map) {
        IProduct[] products;
        IProduct[] iProductArray = products = ProductInfoUtil.getInstance().getProducts();
        int n = products.length;
        int n2 = 0;
        while (n2 < n) {
            IProduct product = iProductArray[n2];
            IContribution contribution = ProductContributionUtil.getContribution((String)product.getName());
            if (contribution != null) {
                map.put(product.getName(), contribution);
            }
            ++n2;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object firstElement;
        ISelection selection = this.viewer.getSelection();
        if (selection != null && (firstElement = ((TreeSelection)selection).getFirstElement()) instanceof IProductLog) {
            this.viewButton.setEnabled(true);
            return;
        }
        this.viewButton.setEnabled(false);
    }
}

