/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.wst.jsdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.EditFilterWizard;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.BuildpathModifierAction;

public class EditFilterAction
extends BuildpathModifierAction {
    public EditFilterAction(IWorkbenchSite site) {
        this(site, null, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
    }

    public EditFilterAction(IRunnableContext context, ISetSelectionTarget selectionTarget) {
        this(null, selectionTarget, context);
    }

    private EditFilterAction(IWorkbenchSite site, ISetSelectionTarget selectionTarget, IRunnableContext context) {
        super(site, selectionTarget, 4);
        this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Edit_label);
        this.setImageDescriptor(JavaPluginImages.DESC_ELCL_CONFIGURE_BUILDPATH_FILTERS);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Edit_tooltip);
        this.setDescription(NewWizardMessages.PackageExplorerActionGroup_FormText_Edit);
        this.setDisabledImageDescriptor(JavaPluginImages.DESC_DLCL_CONFIGURE_BUILDPATH_FILTERS);
    }

    @Override
    public String getDetailedDescription() {
        if (!this.isEnabled()) {
            return null;
        }
        return NewWizardMessages.PackageExplorerActionGroup_FormText_Edit;
    }

    public void run() {
        Shell shell = this.getShell();
        try {
            EditFilterWizard wizard = this.createWizard();
            wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection(this.getSelectedElements().get(0)));
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            PixelConverter converter = new PixelConverter(JFaceResources.getDialogFont());
            dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(70), converter.convertHeightInCharsToPixels(20));
            dialog.create();
            int res = dialog.open();
            if (res == 0) {
                BuildpathDelta delta = new BuildpathDelta(this.getToolTipText());
                ArrayList newEntries = wizard.getExistingEntries();
                delta.setNewEntries(newEntries.toArray(new CPListElement[newEntries.size()]));
                IResource resource = wizard.getCreatedElement().getCorrespondingResource();
                delta.addCreatedResource(resource);
                this.informListeners(delta);
                this.selectAndReveal((ISelection)new StructuredSelection((Object)wizard.getCreatedElement()));
            }
            this.notifyResult(res == 0);
        }
        catch (CoreException e) {
            String title = NewWizardMessages.AbstractOpenWizardAction_createerror_title;
            String message = NewWizardMessages.AbstractOpenWizardAction_createerror_message;
            ExceptionHandler.handle(e, shell, title, message);
        }
    }

    private EditFilterWizard createWizard() throws CoreException {
        IJavaScriptProject javaProject = null;
        Object firstElement = this.getSelectedElements().get(0);
        javaProject = firstElement instanceof IJavaScriptProject ? (IJavaScriptProject)firstElement : ((IPackageFragmentRoot)firstElement).getJavaScriptProject();
        CPListElement[] existingEntries = CPListElement.createFromExisting(javaProject);
        CPListElement elementToEdit = EditFilterAction.findElement((IJavaScriptElement)firstElement, existingEntries);
        return new EditFilterWizard(existingEntries, elementToEdit);
    }

    private static CPListElement findElement(IJavaScriptElement element, CPListElement[] elements) {
        IPath path = element.getPath();
        int i = 0;
        while (i < elements.length) {
            CPListElement cur = elements[i];
            if (cur.getEntryKind() == 3 && cur.getPath().equals((Object)path)) {
                return cur;
            }
            ++i;
        }
        return null;
    }

    @Override
    protected boolean canHandle(IStructuredSelection selection) {
        block5: {
            IPackageFragmentRoot packageFragmentRoot;
            block6: {
                if (selection.size() != 1) {
                    return false;
                }
                try {
                    Object element = selection.getFirstElement();
                    if (element instanceof IJavaScriptProject) {
                        return ClasspathModifier.isSourceFolder((IJavaScriptProject)element);
                    }
                    if (!(element instanceof IPackageFragmentRoot)) break block5;
                    packageFragmentRoot = (IPackageFragmentRoot)element;
                    if (packageFragmentRoot.getKind() == 1) break block6;
                    return false;
                }
                catch (JavaScriptModelException javaScriptModelException) {}
            }
            return packageFragmentRoot.getJavaScriptProject() != null;
        }
        return false;
    }
}

